/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "../config.h"
#include "../Include/Item.h"
#include "../Include/Archive.h"


///////////////////////////////////////////////////////////////////////////////////////////////////
// Arxx::Item                                                                                     //
///////////////////////////////////////////////////////////////////////////////////////////////////

Arxx::Item::Item(Arxx::Archive & Archive, Arxx::u4byte u4UniqueID) :
	m_u4UniqueID(u4UniqueID),
	m_u4Type(0xFFFFFFFF),
	m_u4SubType(0xFFFFFFFF),
	m_u4Version(0x00000000),
	m_pArchive(&Archive),
	m_pItemFactory(0),
	m_Structure(*this)
{
	pGetArchive()->vRegisterItem(*this);
}

Arxx::Item::Item(Arxx::ItemFactory & ItemFactory, Arxx::Archive & Archive, Arxx::u4byte u4UniqueID) :
	m_u4UniqueID(u4UniqueID),
	m_u4Type(0xFFFFFFFF),
	m_u4SubType(0xFFFFFFFF),
	m_u4Version(0x00000000),
	m_pArchive(&Archive),
	m_pItemFactory(&ItemFactory),
	m_Structure(*this)
{
	pGetArchive()->vRegisterItem(*this);
}

Arxx::Item::Item(Arxx::u4byte u4UniqueID) :
	m_u4UniqueID(u4UniqueID),
	m_u4Type(0xFFFFFFFF),
	m_u4SubType(0xFFFFFFFF),
	m_u4Version(0x00000000),
	m_pArchive(0),
	m_pItemFactory(0),
	m_Structure(*this)
{
}

Arxx::Item::Item(Arxx::ItemFactory & ItemFactory, Arxx::u4byte u4UniqueID) :
	m_u4UniqueID(u4UniqueID),
	m_u4Type(0xFFFFFFFF),
	m_u4SubType(0xFFFFFFFF),
	m_u4Version(0x00000000),
	m_pArchive(0),
	m_pItemFactory(&ItemFactory),
	m_Structure(*this)
{
}

Arxx::Item::~Item(void)
{
	if(pGetArchive() != 0)
	{
		try
		{
			pGetArchive()->vUnregisterItem(*this);
		}
		catch(std::invalid_argument & Exception)
		{
		}
	}
}

Arxx::u4byte Arxx::Item::u4GetUniqueID(void) const
{
	return m_u4UniqueID;
}

void Arxx::Item::vSetUniqueID(Arxx::u4byte u4UniqueID)
{
	if(pGetArchive() == 0)
	{
		m_u4UniqueID = u4UniqueID;
	}
	else
	{
		// save the library as it will be set to null in vUnregisterItem.
		Arxx::Archive * pArchive(pGetArchive());
		
		try
		{
			pArchive->vUnregisterItem(*this);
		}
		catch(std::invalid_argument &Exception)
		{
		}
		
		Arxx::u4byte u4OldUniqueID = m_u4UniqueID;
		
		m_u4UniqueID = u4UniqueID;
		try
		{
			pArchive->vRegisterItem(*this);
		}
		catch(Arxx::id_not_unique & Exception)
		{
			m_u4UniqueID = u4OldUniqueID;
			pArchive->vRegisterItem(*this);
			throw;
		}
	}
}

const std::string & Arxx::Item::sGetName(void) const
{
	return m_sName;
}

void Arxx::Item::vSetName(const std::string & sName)
{
	m_sName = sName;
}

Arxx::u4byte Arxx::Item::u4GetType(void) const
{
	return m_u4Type;
}

void Arxx::Item::vSetType(Arxx::u4byte u4Type)
{
	m_u4Type = u4Type;
}

Arxx::u4byte Arxx::Item::u4GetSubType(void) const
{
	return m_u4SubType;
}

void Arxx::Item::vSetSubType(Arxx::u4byte u4SubType)
{
	m_u4SubType = u4SubType;
}

Arxx::u4byte Arxx::Item::u4GetVersion(void) const
{
	return m_u4Version;
}

void Arxx::Item::vSetVersion(Arxx::u4byte u4Version)
{
	m_u4Version = u4Version;
}

Arxx::Archive * Arxx::Item::pGetArchive(void) const
{
	return m_pArchive;
}

Arxx::ItemFactory * Arxx::Item::pGetItemFactory(void) const
{
	return m_pItemFactory;
}

Arxx::Structure & Arxx::Item::GetStructure(void)
{
	return m_Structure;
}

const Arxx::Structure & Arxx::Item::GetStructure(void) const
{
	return m_Structure;
}
