/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2006  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#ifndef ARXX_FETCHSTATUS_H
#define ARXX_FETCHSTATUS_H

/**
 * @file FetchStatus.h
 * 
 * This file declares the status possibilities for a fetching process. This file only ensures that the dependency graph for header files remains free of cycles.
 **/

namespace Arxx
{
	typedef enum
	{
		FETCHED = 0,
		UNFETCHED = 1,
		CONNECTING = 2,
		LOGGINGIN = 3,
		LOGGINGOUT = 4,
		DISCONNECTING = 5,
		TRANSFERING = 6,
		REQUESTING = 7,
		HOSTUNREACHABLE = 8,
		LOGINNOTALLOWED = 9,
		SERVICEUNAVAILABLE = 10,
		DATANOTFOUND = 11,
		FETCHING = 12,
		RESOLVINGHOST = 13,
		SYSTEMERROR = 14
	} FetchStatus;
}

#endif
