/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "common.h"

int main(int argc, char ** argv)
{
	Arxx::Repository.bRegisterDataChannel(&g_LocalFileChannel);
	
	Arxx::Archive Archive;
	Arxx::Item Item1(Archive, g_u4AssembleHostname);
	Arxx::Item Item2(Archive, g_u4AssembleDomainname);
	Arxx::Item Item3(Archive, g_u4AssembleOSType);
	Arxx::Item Item4(Archive, g_u4AssembleOSRelease);
	Arxx::Item Item5(Archive, g_u4LiveHostname);
	Arxx::Item Item6(Archive, g_u4LiveDomainname);
	Arxx::Item Item7(Archive, g_u4LiveOSType);
	Arxx::Item Item8(Archive, g_u4LiveOSRelease);
	
	Item1.vSetName("assemble hostname");
	Item1.vSetExternal("file:///proc/sys/kernel/hostname");
	Item2.vSetName("assemble domainname");
	Item2.vSetExternal("file:///proc/sys/kernel/domainname");
	Item3.vSetName("assemble ostype");
	Item3.vSetExternal("file:///proc/sys/kernel/ostype");
	Item4.vSetName("assemble release");
	Item4.vSetExternal("file:///proc/sys/kernel/osrelease");
	Item1.vInternalize();
	Item2.vInternalize();
	Item3.vInternalize();
	Item4.vInternalize();
	Item5.vSetName("live hostname");
	Item5.vSetExternal("file:///proc/sys/kernel/hostname");
	Item6.vSetName("live domainname");
	Item6.vSetExternal("file:///proc/sys/kernel/domainname");
	Item7.vSetName("live ostype");
	Item7.vSetExternal("file:///proc/sys/kernel/ostype");
	Item8.vSetName("live release");
	Item8.vSetExternal("file:///proc/sys/kernel/osrelease");
	Archive.vSave("example.arx");
	
	return 0;
}
