/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <iostream>

#include <BufferReader.h>

#include "common.h"

int main(int argc, char ** argv)
{
	Arxx::Repository.bRegisterDataChannel(&g_LocalFileChannel);
	
	Arxx::Archive Archive;
	
	if(Archive.bLoad("example.arx") == false)
	{
		std::cerr << "Error reading the resource file." << std::endl;
		
		return 1;
	}
	
	Arxx::Item * pItem1(Archive.pGetItem(g_u4AssembleHostname));
	Arxx::Item * pItem2(Archive.pGetItem(g_u4AssembleDomainname));
	Arxx::Item * pItem3(Archive.pGetItem(g_u4AssembleOSType));
	Arxx::Item * pItem4(Archive.pGetItem(g_u4AssembleOSRelease));
	Arxx::Item * pItem5(Archive.pGetItem(g_u4LiveHostname));
	Arxx::Item * pItem6(Archive.pGetItem(g_u4LiveDomainname));
	Arxx::Item * pItem7(Archive.pGetItem(g_u4LiveOSType));
	Arxx::Item * pItem8(Archive.pGetItem(g_u4LiveOSRelease));
	
	if((pItem1 == 0) || (pItem2 == 0) || (pItem3 == 0) || (pItem4 == 0) || (pItem5 == 0) || (pItem6 == 0) || (pItem7 == 0) || (pItem8 == 0))
	{
		std::cerr << "Error reading the resource file." << std::endl;
		
		return 1;
	}
	pItem1->bFetch();
	pItem2->bFetch();
	pItem3->bFetch();
	pItem4->bFetch();
	pItem5->bFetch();
	pItem6->bFetch();
	pItem7->bFetch();
	pItem8->bFetch();
	
	std::string sAssembleHostname;
	std::string sAssembleDomainname;
	std::string sAssembleOSType;
	std::string sAssembleOSRelease;
	std::string sLiveHostname;
	std::string sLiveDomainname;
	std::string sLiveOSType;
	std::string sLiveOSRelease;
	Arxx::BufferReader ItemReader1(*pItem1);
	Arxx::BufferReader ItemReader2(*pItem2);
	Arxx::BufferReader ItemReader3(*pItem3);
	Arxx::BufferReader ItemReader4(*pItem4);
	Arxx::BufferReader ItemReader5(*pItem5);
	Arxx::BufferReader ItemReader6(*pItem6);
	Arxx::BufferReader ItemReader7(*pItem7);
	Arxx::BufferReader ItemReader8(*pItem8);
	
	ItemReader1 >> sAssembleHostname;
	ItemReader2 >> sAssembleDomainname;
	ItemReader3 >> sAssembleOSType;
	ItemReader4 >> sAssembleOSRelease;
	ItemReader5 >> sLiveHostname;
	ItemReader6 >> sLiveDomainname;
	ItemReader7 >> sLiveOSType;
	ItemReader8 >> sLiveOSRelease;
	sAssembleHostname[sAssembleHostname.length() - 1] = '\0';
	sAssembleDomainname[sAssembleDomainname.length() - 1] = '\0';
	sAssembleOSType[sAssembleOSType.length() - 1] = '\0';
	sAssembleOSRelease[sAssembleOSRelease.length() - 1] = '\0';
	sLiveHostname[sLiveHostname.length() - 1] = '\0';
	sLiveDomainname[sLiveDomainname.length() - 1] = '\0';
	sLiveOSType[sLiveOSType.length() - 1] = '\0';
	sLiveOSRelease[sLiveOSRelease.length() - 1] = '\0';
	std::cout << "The resource file was built on " << sAssembleHostname << '.' << sAssembleDomainname << " ( " << sAssembleOSType << " - " << sAssembleOSRelease << " )." << std::endl;
	std::cout << "The tester is now being run on " << sLiveHostname << '.' << sLiveDomainname << " ( " << sLiveOSType << " - " << sLiveOSRelease << " )." << std::endl;
	
	return 0;
}
