/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "common.h"

int main(int argc, char ** argv)
{
	Arxx::Archive Archive;
	
	if(Archive.bLoad("example.arx") == false)
	{
		std::cerr << "Error reading the resource file." << std::endl;
		
		return 1;
	}
	
	Arxx::Item * pItem1(Archive.pGetItem(g_u4Item1));
	Arxx::Item * pItem2(Archive.pGetItem(g_u4Item2));
	Arxx::Item * pItem3(Archive.pGetItem(g_u4Item3));
	Arxx::Item * pItem4(Archive.pGetItem(g_u4Item4));
	Arxx::Item * pItem5(Archive.pGetItem(g_u4Item5));
	Arxx::Item * pItem6(Archive.pGetItem(g_u4Item6));
	
	if((pItem1 == 0) || (pItem2 == 0) || (pItem3 == 0) || (pItem4 == 0) || (pItem5 == 0) || (pItem6 == 0))
	{
		std::cerr << "Error reading the resource file." << std::endl;
		
		return 1;
	}
	std::cout << "Given the restriction of having only 3MB for item data we cannot load the whole archive \"example.arx\" into memory since it is about 7MB." << std::endl;
	std::cout << "Fortunately we never need more than 3MB of data in the memory and can use vFetch() and vUnfetch() to get and release data memory." << std::endl;
///////////////////////////////////////////////////////////////////////////////////////////////////
	std::cout << "Data memory consumption after reading the file:\n";
	vPrintLibraryMemoryUsage(Archive);
	std::cout << std::endl << "[Press ENTER to continue]" << std::endl;
	std::cin.get();
///////////////////////////////////////////////////////////////////////////////////////////////////
	pItem1->bFetch();
	pItem4->bFetch();
	std::cout << "Data memory consumption after fetching Item1 and Item4 data:\n";
	vPrintLibraryMemoryUsage(Archive);
	std::cout << std::endl << "[Press ENTER to continue]" << std::endl;
	std::cin.get();
///////////////////////////////////////////////////////////////////////////////////////////////////
	pItem1->vUnfetch();
	pItem2->bFetch();
	pItem3->bFetch();
	std::cout << "Data memory consumption after unfetching Item1 and fetching Item2 and Item3 data:\n";
	vPrintLibraryMemoryUsage(Archive);
	std::cout << std::endl << "[Press ENTER to continue]" << std::endl;
	std::cin.get();
///////////////////////////////////////////////////////////////////////////////////////////////////
	pItem3->vUnfetch();
	pItem4->vUnfetch();
	pItem5->bFetch();
	std::cout << "Data memory consumption after unfetching Item3 and Item4 and fetching Item5 data:\n";
	vPrintLibraryMemoryUsage(Archive);
	std::cout << std::endl << "[Press ENTER to continue]" << std::endl;
	std::cin.get();
///////////////////////////////////////////////////////////////////////////////////////////////////
	pItem2->vUnfetch();
	pItem6->bFetch();
	std::cout << "Data memory consumption after unfetching Item2 and fetching Item6 data:\n";
	vPrintLibraryMemoryUsage(Archive);
	std::cout << std::endl << "[Press ENTER to continue]" << std::endl;
	std::cin.get();
///////////////////////////////////////////////////////////////////////////////////////////////////
	pItem6->vUnfetch();
	pItem4->bFetch();
	pItem3->bFetch();
	std::cout << "Data memory consumption after unfetching Item6 and refetching Item4 and Item3 data:\n";
	vPrintLibraryMemoryUsage(Archive);
	std::cout << std::endl << "[Press ENTER to continue]" << std::endl;
	std::cin.get();
	
	return 0;
}
