/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <iostream>
#include <iomanip>

#include <Arxx.h>

const Arxx::u4byte g_u4Item1 = 0x00000001;
const Arxx::u4byte g_u4Item2 = 0x00000002;
const Arxx::u4byte g_u4Item3 = 0x00000003;
const Arxx::u4byte g_u4Item4 = 0x00000004;
const Arxx::u4byte g_u4Item5 = 0x00000005;
const Arxx::u4byte g_u4Item6 = 0x00000006;

void vPrintLibraryMemoryUsage(Arxx::Archive & Archive)
{
	Arxx::Archive::iterator iItem(Archive.begin());
	Arxx::u4byte u4Sum(0);
	
	while(iItem != Archive.end())
	{
		if(iItem->stGetLength() > 0)
		{
			std::string sName(iItem->sGetName());
			
			if(sName.length() > 20)
			{
				sName = sName.substr(0, 16) + " ...";
			}
			std::cout << std::left << std::setw(20) << sName << "  " << std::setw(10) << std::right << iItem->stGetLength() << " byte\n";
			u4Sum += iItem->stGetLength();
		}
		++iItem;
	}
	std::cout << std::setw(22) << ' ' << "==========" << '\n' << std::setw(22) << ' ' << std::setw(10) << std::right << u4Sum << " byte" << std::endl;
}
