/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <BufferWriter.h>

#include "common.h"

int main(int argc, char ** argv)
{
	// creating the ARX archive file which we will use
	Arxx::Archive Archive;
	Arxx::Item Item1(Archive);
	Arxx::BufferWriter BufferWriter1(Item1);
	
	Item1.vSetUniqueID(g_u4ApplicationTitle);
	BufferWriter1 << "Mighty Example 1";
	
	Arxx::Item Item2(Archive);
	Arxx::BufferWriter BufferWriter2(Item2);
	
	Item2.vSetUniqueID(g_u4MOTD);
	BufferWriter2 << "This example is intended to demonstrate the use of ARX archive files\nas resource files for applications. The example uses the file\nexample.arx and you can change its content to change the way\nthe application appears to you.";
	
	Arxx::Item Item3(Archive);
	Item3.vSetUniqueID(g_u4SeparatorCharacter);
	Item3.vSetLength(1);
	Item3[0] = '=';
	Archive.vSave("example.arx");
	
	return 0;
}
