/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <iostream>

#include <BufferReader.h>

#include "common.h"

int main(int argc, char ** argv)
{
	Arxx::Archive Archive;
	
	if(Archive.bLoad("example.arx") == false)
	{
		std::cerr << "Error reading the resource file." << std::endl;
		
		return 1;
	}
	
	Arxx::Item * pItem1(Archive.pGetItem(g_u4ApplicationTitle));
	Arxx::Item * pItem2(Archive.pGetItem(g_u4MOTD));
	Arxx::Item * pItem3(Archive.pGetItem(g_u4SeparatorCharacter));
	
	if((pItem1 == 0) || (pItem2 == 0) || (pItem3 == 0))
	{
		std::cerr << "Error reading the resource file." << std::endl;
		
		return 1;
	}
	
	Arxx::BufferReader ItemReader1(*pItem1);
	Arxx::BufferReader ItemReader2(*pItem2);
	
	std::string sApplicationTitle;
	std::string sMOTD;
	
	ItemReader1 >> sApplicationTitle;
	ItemReader2 >> sMOTD;
	for(unsigned int uiI = 0; uiI < 80; ++uiI)
	{
		std::cout << pItem3[0];
	}
	std::cout << '\n' << sApplicationTitle << '\n';
	for(unsigned int uiI = 0; uiI < 80; ++uiI)
	{
		std::cout << pItem3[0];
	}
	std::cout << std::endl << "\nMessage of the day:" << std::endl << sMOTD << std::endl;
	
	return 0;
}
