/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated C++ Implementation file for the Node wrapper class 
 of the 3MF Library

Interface version: 2.3.0

*/


#include <node.h>
#include "lib3mf_nodewrapper.h"


using namespace v8;

Persistent<Function> CLib3MFWrapper::constructor;
Persistent<Function> CLib3MFBase::constructor;
Persistent<Function> CLib3MFWriter::constructor;
Persistent<Function> CLib3MFReader::constructor;
Persistent<Function> CLib3MFPackagePart::constructor;
Persistent<Function> CLib3MFResource::constructor;
Persistent<Function> CLib3MFResourceIterator::constructor;
Persistent<Function> CLib3MFSliceStackIterator::constructor;
Persistent<Function> CLib3MFObjectIterator::constructor;
Persistent<Function> CLib3MFMeshObjectIterator::constructor;
Persistent<Function> CLib3MFComponentsObjectIterator::constructor;
Persistent<Function> CLib3MFTexture2DIterator::constructor;
Persistent<Function> CLib3MFBaseMaterialGroupIterator::constructor;
Persistent<Function> CLib3MFColorGroupIterator::constructor;
Persistent<Function> CLib3MFTexture2DGroupIterator::constructor;
Persistent<Function> CLib3MFCompositeMaterialsIterator::constructor;
Persistent<Function> CLib3MFMultiPropertyGroupIterator::constructor;
Persistent<Function> CLib3MFMetaData::constructor;
Persistent<Function> CLib3MFMetaDataGroup::constructor;
Persistent<Function> CLib3MFObject::constructor;
Persistent<Function> CLib3MFMeshObject::constructor;
Persistent<Function> CLib3MFBeamLattice::constructor;
Persistent<Function> CLib3MFComponent::constructor;
Persistent<Function> CLib3MFComponentsObject::constructor;
Persistent<Function> CLib3MFBeamSet::constructor;
Persistent<Function> CLib3MFBaseMaterialGroup::constructor;
Persistent<Function> CLib3MFColorGroup::constructor;
Persistent<Function> CLib3MFTexture2DGroup::constructor;
Persistent<Function> CLib3MFCompositeMaterials::constructor;
Persistent<Function> CLib3MFMultiPropertyGroup::constructor;
Persistent<Function> CLib3MFAttachment::constructor;
Persistent<Function> CLib3MFTexture2D::constructor;
Persistent<Function> CLib3MFBuildItem::constructor;
Persistent<Function> CLib3MFBuildItemIterator::constructor;
Persistent<Function> CLib3MFSlice::constructor;
Persistent<Function> CLib3MFSliceStack::constructor;
Persistent<Function> CLib3MFConsumer::constructor;
Persistent<Function> CLib3MFAccessRight::constructor;
Persistent<Function> CLib3MFContentEncryptionParams::constructor;
Persistent<Function> CLib3MFResourceData::constructor;
Persistent<Function> CLib3MFResourceDataGroup::constructor;
Persistent<Function> CLib3MFKeyStore::constructor;
Persistent<Function> CLib3MFModel::constructor;

/*************************************************************************************************************************
 Class sLib3MFTriangle Conversion
**************************************************************************************************************************/
sLib3MFTriangle convertObjectToLib3MFTriangle(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTriangle sTriangle;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sTriangle.m_Indices[rowIndex] = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Indices Member
			MaybeLocal<Value> maybeValIndices = obj->Get(context, String::NewFromUtf8(isolate, "Indices"));
			if (!maybeValIndices.IsEmpty()) {
				Local<Value> valIndices = maybeValIndices.ToLocalChecked();
				if (valIndices->IsArray()) {
					Local<Array> arrayIndices = Local<Array>::Cast(valIndices);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayIndices->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sTriangle.m_Indices[rowIndex] = localNumber.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTriangle;
}



Local<Object> convertLib3MFTriangleToObject(Isolate* isolate, sLib3MFTriangle sTriangle)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newIndices = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newIndices->Set(rowIndex, Integer::NewFromUnsigned(isolate, sTriangle.m_Indices[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Indices"), newIndices);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFTriangleProperties Conversion
**************************************************************************************************************************/
sLib3MFTriangleProperties convertObjectToLib3MFTriangleProperties(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTriangleProperties sTriangleProperties;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	sTriangleProperties.m_ResourceID = 0;
	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sTriangleProperties.m_PropertyIDs[rowIndex] = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// ResourceID Member
			MaybeLocal<Value> maybeValResourceID = obj->Get(context, String::NewFromUtf8(isolate, "ResourceID"));
			if (!maybeValResourceID.IsEmpty()) {
				Local<Value> valResourceID = maybeValResourceID.ToLocalChecked();
				if (valResourceID->IsNumber()) {
					MaybeLocal<Number> localValResourceID = valResourceID->ToNumber(context);
					sTriangleProperties.m_ResourceID = localValResourceID.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member not found in object" )));
			}

			// PropertyIDs Member
			MaybeLocal<Value> maybeValPropertyIDs = obj->Get(context, String::NewFromUtf8(isolate, "PropertyIDs"));
			if (!maybeValPropertyIDs.IsEmpty()) {
				Local<Value> valPropertyIDs = maybeValPropertyIDs.ToLocalChecked();
				if (valPropertyIDs->IsArray()) {
					Local<Array> arrayPropertyIDs = Local<Array>::Cast(valPropertyIDs);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayPropertyIDs->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sTriangleProperties.m_PropertyIDs[rowIndex] = localNumber.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTriangleProperties;
}



Local<Object> convertLib3MFTrianglePropertiesToObject(Isolate* isolate, sLib3MFTriangleProperties sTriangleProperties)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "ResourceID"), Integer::NewFromUnsigned (isolate, sTriangleProperties.m_ResourceID));
	Local<Array> newPropertyIDs = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newPropertyIDs->Set(rowIndex, Integer::NewFromUnsigned(isolate, sTriangleProperties.m_PropertyIDs[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "PropertyIDs"), newPropertyIDs);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFPosition Conversion
**************************************************************************************************************************/
sLib3MFPosition convertObjectToLib3MFPosition(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFPosition sPosition;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sPosition.m_Coordinates[rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Coordinates Member
			MaybeLocal<Value> maybeValCoordinates = obj->Get(context, String::NewFromUtf8(isolate, "Coordinates"));
			if (!maybeValCoordinates.IsEmpty()) {
				Local<Value> valCoordinates = maybeValCoordinates.ToLocalChecked();
				if (valCoordinates->IsArray()) {
					Local<Array> arrayCoordinates = Local<Array>::Cast(valCoordinates);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCoordinates->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sPosition.m_Coordinates[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sPosition;
}



Local<Object> convertLib3MFPositionToObject(Isolate* isolate, sLib3MFPosition sPosition)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newCoordinates = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newCoordinates->Set(rowIndex, Number::New(isolate, (double) sPosition.m_Coordinates[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Coordinates"), newCoordinates);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFPosition2D Conversion
**************************************************************************************************************************/
sLib3MFPosition2D convertObjectToLib3MFPosition2D(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFPosition2D sPosition2D;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sPosition2D.m_Coordinates[rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Coordinates Member
			MaybeLocal<Value> maybeValCoordinates = obj->Get(context, String::NewFromUtf8(isolate, "Coordinates"));
			if (!maybeValCoordinates.IsEmpty()) {
				Local<Value> valCoordinates = maybeValCoordinates.ToLocalChecked();
				if (valCoordinates->IsArray()) {
					Local<Array> arrayCoordinates = Local<Array>::Cast(valCoordinates);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCoordinates->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sPosition2D.m_Coordinates[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sPosition2D;
}



Local<Object> convertLib3MFPosition2DToObject(Isolate* isolate, sLib3MFPosition2D sPosition2D)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newCoordinates = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newCoordinates->Set(rowIndex, Number::New(isolate, (double) sPosition2D.m_Coordinates[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Coordinates"), newCoordinates);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFCompositeConstituent Conversion
**************************************************************************************************************************/
sLib3MFCompositeConstituent convertObjectToLib3MFCompositeConstituent(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFCompositeConstituent sCompositeConstituent;
	Local<Context> context = isolate->GetCurrentContext();

	sCompositeConstituent.m_PropertyID = 0;
	sCompositeConstituent.m_MixingRatio = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// PropertyID Member
			MaybeLocal<Value> maybeValPropertyID = obj->Get(context, String::NewFromUtf8(isolate, "PropertyID"));
			if (!maybeValPropertyID.IsEmpty()) {
				Local<Value> valPropertyID = maybeValPropertyID.ToLocalChecked();
				if (valPropertyID->IsNumber()) {
					MaybeLocal<Number> localValPropertyID = valPropertyID->ToNumber(context);
					sCompositeConstituent.m_PropertyID = localValPropertyID.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyID member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyID member not found in object" )));
			}

			// MixingRatio Member
			MaybeLocal<Value> maybeValMixingRatio = obj->Get(context, String::NewFromUtf8(isolate, "MixingRatio"));
			if (!maybeValMixingRatio.IsEmpty()) {
				Local<Value> valMixingRatio = maybeValMixingRatio.ToLocalChecked();
				if (valMixingRatio->IsNumber()) {
					MaybeLocal<Number> localValMixingRatio = valMixingRatio->ToNumber(context);
					sCompositeConstituent.m_MixingRatio = localValMixingRatio.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MixingRatio member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MixingRatio member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sCompositeConstituent;
}



Local<Object> convertLib3MFCompositeConstituentToObject(Isolate* isolate, sLib3MFCompositeConstituent sCompositeConstituent)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "PropertyID"), Integer::NewFromUnsigned (isolate, sCompositeConstituent.m_PropertyID));
	returnInstance->Set(String::NewFromUtf8(isolate, "MixingRatio"), Number::New (isolate, sCompositeConstituent.m_MixingRatio));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFMultiPropertyLayer Conversion
**************************************************************************************************************************/
sLib3MFMultiPropertyLayer convertObjectToLib3MFMultiPropertyLayer(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFMultiPropertyLayer sMultiPropertyLayer;
	Local<Context> context = isolate->GetCurrentContext();

	sMultiPropertyLayer.m_ResourceID = 0;
	sMultiPropertyLayer.m_TheBlendMethod.m_code = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// ResourceID Member
			MaybeLocal<Value> maybeValResourceID = obj->Get(context, String::NewFromUtf8(isolate, "ResourceID"));
			if (!maybeValResourceID.IsEmpty()) {
				Local<Value> valResourceID = maybeValResourceID.ToLocalChecked();
				if (valResourceID->IsNumber()) {
					MaybeLocal<Number> localValResourceID = valResourceID->ToNumber(context);
					sMultiPropertyLayer.m_ResourceID = localValResourceID.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member not found in object" )));
			}

			// TheBlendMethod Member
			MaybeLocal<Value> maybeValTheBlendMethod = obj->Get(context, String::NewFromUtf8(isolate, "TheBlendMethod"));
			if (!maybeValTheBlendMethod.IsEmpty()) {
				Local<Value> valTheBlendMethod = maybeValTheBlendMethod.ToLocalChecked();
				if (valTheBlendMethod->IsNumber()) {
					MaybeLocal<Number> localValTheBlendMethod = valTheBlendMethod->ToNumber(context);
					sMultiPropertyLayer.m_TheBlendMethod.m_code = localValTheBlendMethod.ToLocalChecked()->Int32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "TheBlendMethod member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "TheBlendMethod member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sMultiPropertyLayer;
}



Local<Object> convertLib3MFMultiPropertyLayerToObject(Isolate* isolate, sLib3MFMultiPropertyLayer sMultiPropertyLayer)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "ResourceID"), Integer::NewFromUnsigned (isolate, sMultiPropertyLayer.m_ResourceID));
	returnInstance->Set(String::NewFromUtf8(isolate, "TheBlendMethod"), Integer::New (isolate, sMultiPropertyLayer.m_TheBlendMethod.m_code));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFTex2Coord Conversion
**************************************************************************************************************************/
sLib3MFTex2Coord convertObjectToLib3MFTex2Coord(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTex2Coord sTex2Coord;
	Local<Context> context = isolate->GetCurrentContext();

	sTex2Coord.m_U = 0.0;
	sTex2Coord.m_V = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// U Member
			MaybeLocal<Value> maybeValU = obj->Get(context, String::NewFromUtf8(isolate, "U"));
			if (!maybeValU.IsEmpty()) {
				Local<Value> valU = maybeValU.ToLocalChecked();
				if (valU->IsNumber()) {
					MaybeLocal<Number> localValU = valU->ToNumber(context);
					sTex2Coord.m_U = localValU.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "U member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "U member not found in object" )));
			}

			// V Member
			MaybeLocal<Value> maybeValV = obj->Get(context, String::NewFromUtf8(isolate, "V"));
			if (!maybeValV.IsEmpty()) {
				Local<Value> valV = maybeValV.ToLocalChecked();
				if (valV->IsNumber()) {
					MaybeLocal<Number> localValV = valV->ToNumber(context);
					sTex2Coord.m_V = localValV.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "V member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "V member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTex2Coord;
}



Local<Object> convertLib3MFTex2CoordToObject(Isolate* isolate, sLib3MFTex2Coord sTex2Coord)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "U"), Number::New (isolate, sTex2Coord.m_U));
	returnInstance->Set(String::NewFromUtf8(isolate, "V"), Number::New (isolate, sTex2Coord.m_V));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFTransform Conversion
**************************************************************************************************************************/
sLib3MFTransform convertObjectToLib3MFTransform(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTransform sTransform;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;
	int columnIndex;

	for (columnIndex = 0; columnIndex < 4; columnIndex++)
		for (rowIndex = 0; rowIndex < 3; rowIndex++)
			sTransform.m_Fields[columnIndex][rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Fields Member
			MaybeLocal<Value> maybeValFields = obj->Get(context, String::NewFromUtf8(isolate, "Fields"));
			if (!maybeValFields.IsEmpty()) {
				Local<Value> valFields = maybeValFields.ToLocalChecked();
				if (valFields->IsArray()) {
					Local<Array> arrayFields = Local<Array>::Cast(valFields);
					for (int colIndex = 0; colIndex < 4; colIndex++) {
						MaybeLocal<Value> mlocalCol = arrayFields->Get(context, colIndex);
						Local<Value> localCol;
						if (mlocalCol.ToLocal(&localCol)) {
					  if (localCol->IsArray()) {
								Local<Array> localColArray = Local<Array>::Cast(localCol);
								for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
									MaybeLocal<Value> mlocalValue = localColArray->Get(context, rowIndex);
									Local<Value> localValue;
									if (mlocalValue.ToLocal(&localValue)) {
										if (localValue->IsNumber()) {
											MaybeLocal<Number> localNumber = localValue->ToNumber(context);
											sTransform.m_Fields[colIndex][rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
										} else {
											isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is not a number" )));
										}
									} else {
										isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is invalid" )));
									}
								}
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is not an array" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTransform;
}



Local<Object> convertLib3MFTransformToObject(Isolate* isolate, sLib3MFTransform sTransform)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newFields = Array::New(isolate, 4);
	for (int colIndex = 0; colIndex < 4; colIndex++) {
		Local<Array> colArray = Array::New(isolate, 3);
		for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
			colArray->Set(rowIndex, Number::New(isolate, (double) sTransform.m_Fields[colIndex][rowIndex]));
		}
		newFields->Set(colIndex, colArray);
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Fields"), newFields);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFBox Conversion
**************************************************************************************************************************/
sLib3MFBox convertObjectToLib3MFBox(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFBox sBox;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sBox.m_MinCoordinate[rowIndex] = 0.0f;
	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sBox.m_MaxCoordinate[rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// MinCoordinate Member
			MaybeLocal<Value> maybeValMinCoordinate = obj->Get(context, String::NewFromUtf8(isolate, "MinCoordinate"));
			if (!maybeValMinCoordinate.IsEmpty()) {
				Local<Value> valMinCoordinate = maybeValMinCoordinate.ToLocalChecked();
				if (valMinCoordinate->IsArray()) {
					Local<Array> arrayMinCoordinate = Local<Array>::Cast(valMinCoordinate);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayMinCoordinate->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBox.m_MinCoordinate[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate member not found in object" )));
			}

			// MaxCoordinate Member
			MaybeLocal<Value> maybeValMaxCoordinate = obj->Get(context, String::NewFromUtf8(isolate, "MaxCoordinate"));
			if (!maybeValMaxCoordinate.IsEmpty()) {
				Local<Value> valMaxCoordinate = maybeValMaxCoordinate.ToLocalChecked();
				if (valMaxCoordinate->IsArray()) {
					Local<Array> arrayMaxCoordinate = Local<Array>::Cast(valMaxCoordinate);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayMaxCoordinate->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBox.m_MaxCoordinate[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sBox;
}



Local<Object> convertLib3MFBoxToObject(Isolate* isolate, sLib3MFBox sBox)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newMinCoordinate = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newMinCoordinate->Set(rowIndex, Number::New(isolate, (double) sBox.m_MinCoordinate[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "MinCoordinate"), newMinCoordinate);

	Local<Array> newMaxCoordinate = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newMaxCoordinate->Set(rowIndex, Number::New(isolate, (double) sBox.m_MaxCoordinate[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "MaxCoordinate"), newMaxCoordinate);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFColor Conversion
**************************************************************************************************************************/
sLib3MFColor convertObjectToLib3MFColor(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFColor sColor;
	Local<Context> context = isolate->GetCurrentContext();

	sColor.m_Red = 0;
	sColor.m_Green = 0;
	sColor.m_Blue = 0;
	sColor.m_Alpha = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Red Member
			MaybeLocal<Value> maybeValRed = obj->Get(context, String::NewFromUtf8(isolate, "Red"));
			if (!maybeValRed.IsEmpty()) {
				Local<Value> valRed = maybeValRed.ToLocalChecked();
				if (valRed->IsNumber()) {
					MaybeLocal<Number> localValRed = valRed->ToNumber(context);
					sColor.m_Red = localValRed.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Red member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Red member not found in object" )));
			}

			// Green Member
			MaybeLocal<Value> maybeValGreen = obj->Get(context, String::NewFromUtf8(isolate, "Green"));
			if (!maybeValGreen.IsEmpty()) {
				Local<Value> valGreen = maybeValGreen.ToLocalChecked();
				if (valGreen->IsNumber()) {
					MaybeLocal<Number> localValGreen = valGreen->ToNumber(context);
					sColor.m_Green = localValGreen.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Green member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Green member not found in object" )));
			}

			// Blue Member
			MaybeLocal<Value> maybeValBlue = obj->Get(context, String::NewFromUtf8(isolate, "Blue"));
			if (!maybeValBlue.IsEmpty()) {
				Local<Value> valBlue = maybeValBlue.ToLocalChecked();
				if (valBlue->IsNumber()) {
					MaybeLocal<Number> localValBlue = valBlue->ToNumber(context);
					sColor.m_Blue = localValBlue.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Blue member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Blue member not found in object" )));
			}

			// Alpha Member
			MaybeLocal<Value> maybeValAlpha = obj->Get(context, String::NewFromUtf8(isolate, "Alpha"));
			if (!maybeValAlpha.IsEmpty()) {
				Local<Value> valAlpha = maybeValAlpha.ToLocalChecked();
				if (valAlpha->IsNumber()) {
					MaybeLocal<Number> localValAlpha = valAlpha->ToNumber(context);
					sColor.m_Alpha = localValAlpha.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Alpha member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Alpha member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sColor;
}



Local<Object> convertLib3MFColorToObject(Isolate* isolate, sLib3MFColor sColor)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "Red"), Integer::NewFromUnsigned (isolate, sColor.m_Red));
	returnInstance->Set(String::NewFromUtf8(isolate, "Green"), Integer::NewFromUnsigned (isolate, sColor.m_Green));
	returnInstance->Set(String::NewFromUtf8(isolate, "Blue"), Integer::NewFromUnsigned (isolate, sColor.m_Blue));
	returnInstance->Set(String::NewFromUtf8(isolate, "Alpha"), Integer::NewFromUnsigned (isolate, sColor.m_Alpha));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFBeam Conversion
**************************************************************************************************************************/
sLib3MFBeam convertObjectToLib3MFBeam(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFBeam sBeam;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sBeam.m_Indices[rowIndex] = 0;
	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sBeam.m_Radii[rowIndex] = 0.0;
	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sBeam.m_CapModes[rowIndex].m_code = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Indices Member
			MaybeLocal<Value> maybeValIndices = obj->Get(context, String::NewFromUtf8(isolate, "Indices"));
			if (!maybeValIndices.IsEmpty()) {
				Local<Value> valIndices = maybeValIndices.ToLocalChecked();
				if (valIndices->IsArray()) {
					Local<Array> arrayIndices = Local<Array>::Cast(valIndices);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayIndices->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBeam.m_Indices[rowIndex] = localNumber.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member not found in object" )));
			}

			// Radii Member
			MaybeLocal<Value> maybeValRadii = obj->Get(context, String::NewFromUtf8(isolate, "Radii"));
			if (!maybeValRadii.IsEmpty()) {
				Local<Value> valRadii = maybeValRadii.ToLocalChecked();
				if (valRadii->IsArray()) {
					Local<Array> arrayRadii = Local<Array>::Cast(valRadii);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayRadii->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBeam.m_Radii[rowIndex] = localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii member not found in object" )));
			}

			// CapModes Member
			MaybeLocal<Value> maybeValCapModes = obj->Get(context, String::NewFromUtf8(isolate, "CapModes"));
			if (!maybeValCapModes.IsEmpty()) {
				Local<Value> valCapModes = maybeValCapModes.ToLocalChecked();
				if (valCapModes->IsArray()) {
					Local<Array> arrayCapModes = Local<Array>::Cast(valCapModes);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCapModes->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBeam.m_CapModes[rowIndex].m_code = localNumber.ToLocalChecked()->Int32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sBeam;
}



Local<Object> convertLib3MFBeamToObject(Isolate* isolate, sLib3MFBeam sBeam)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newIndices = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newIndices->Set(rowIndex, Integer::NewFromUnsigned(isolate, sBeam.m_Indices[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Indices"), newIndices);

	Local<Array> newRadii = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newRadii->Set(rowIndex, Number::New(isolate, sBeam.m_Radii[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Radii"), newRadii);

	Local<Array> newCapModes = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newCapModes->Set(rowIndex, Integer::New(isolate, sBeam.m_CapModes[rowIndex].m_code));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "CapModes"), newCapModes);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFBall Conversion
**************************************************************************************************************************/
sLib3MFBall convertObjectToLib3MFBall(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFBall sBall;
	Local<Context> context = isolate->GetCurrentContext();

	sBall.m_Index = 0;
	sBall.m_Radius = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Index Member
			MaybeLocal<Value> maybeValIndex = obj->Get(context, String::NewFromUtf8(isolate, "Index"));
			if (!maybeValIndex.IsEmpty()) {
				Local<Value> valIndex = maybeValIndex.ToLocalChecked();
				if (valIndex->IsNumber()) {
					MaybeLocal<Number> localValIndex = valIndex->ToNumber(context);
					sBall.m_Index = localValIndex.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Index member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Index member not found in object" )));
			}

			// Radius Member
			MaybeLocal<Value> maybeValRadius = obj->Get(context, String::NewFromUtf8(isolate, "Radius"));
			if (!maybeValRadius.IsEmpty()) {
				Local<Value> valRadius = maybeValRadius.ToLocalChecked();
				if (valRadius->IsNumber()) {
					MaybeLocal<Number> localValRadius = valRadius->ToNumber(context);
					sBall.m_Radius = localValRadius.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radius member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radius member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sBall;
}



Local<Object> convertLib3MFBallToObject(Isolate* isolate, sLib3MFBall sBall)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "Index"), Integer::NewFromUnsigned (isolate, sBall.m_Index));
	returnInstance->Set(String::NewFromUtf8(isolate, "Radius"), Number::New (isolate, sBall.m_Radius));

	return returnInstance;
}

/*************************************************************************************************************************
 Class CLib3MFBaseClass Implementation
**************************************************************************************************************************/

CLib3MFBaseClass::CLib3MFBaseClass()
		: node::ObjectWrap()
{

}

void CLib3MFBaseClass::RaiseError(v8::Isolate * isolate, std::string Message)
{
		if (isolate != nullptr) {
				isolate->ThrowException(Exception::TypeError(
						String::NewFromUtf8(isolate, Message.c_str() )));
		}
}
void CLib3MFBaseClass::CheckError(v8::Isolate * isolate, sLib3MFDynamicWrapperTable * sWrapperTable, Lib3MFHandle pInstance, Lib3MFResult errorCode)
{
		if (errorCode != 0) {
			std::string sMessage;
			if ((sWrapperTable != nullptr) && (pInstance != nullptr)) {
				if (sWrapperTable->m_GetLastError != nullptr) {
					uint32_t neededChars = 0;
					bool hasLastError = 0;
					if (sWrapperTable->m_GetLastError(pInstance, 0, &neededChars, nullptr, &hasLastError) == 0) {
						uint32_t dummyChars = 0;
						std::vector<char> Buffer;
						Buffer.resize(neededChars + 2);
						if (sWrapperTable->m_GetLastError(pInstance, neededChars + 1, &dummyChars, Buffer.data(), &hasLastError) == 0) {
							Buffer[neededChars + 1] = 0;
							sMessage = std::string(": ") + std::string(&Buffer[0]);
						}
					}
				}
			}
			throw std::runtime_error("Lib3MF Error" + sMessage + " (" + std::to_string(errorCode) + ")");
		}
}

void CLib3MFBaseClass::setHandle(Lib3MFHandle pHandle)
{
		
}

Lib3MFHandle CLib3MFBaseClass::getHandle(v8::Local<v8::Object> objecthandle)
{
		auto Field = objecthandle->GetInternalField(NODEWRAPPER_HANDLEINDEX);
		v8::Local<v8::External> externalField = Field.As<v8::External>();
		return (Lib3MFHandle *) externalField->Value();
}

sLib3MFDynamicWrapperTable * CLib3MFBaseClass::getDynamicWrapperTable(v8::Local<v8::Object> objecthandle)
{
		auto Field = objecthandle->GetInternalField(NODEWRAPPER_TABLEINDEX);
		v8::Local<v8::External> externalField = Field.As<v8::External>();
		return (sLib3MFDynamicWrapperTable *) externalField->Value();
}


/*************************************************************************************************************************
 Class CLib3MFBase Implementation
**************************************************************************************************************************/

CLib3MFBase::CLib3MFBase()
		: CLib3MFBaseClass()
{
}

CLib3MFBase::~CLib3MFBase()
{
}

void CLib3MFBase::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBase"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClassTypeId", ClassTypeId);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBase::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBase * baseInstance = new CLib3MFBase();
				baseInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBase: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBase::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBase::ClassTypeId(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnClassTypeId = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClassTypeId.");
        if (wrapperTable->m_Base_ClassTypeId == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Base::ClassTypeId.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Base_ClassTypeId(instanceHandle, &nReturnClassTypeId);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnClassTypeId).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFWriter Implementation
**************************************************************************************************************************/

CLib3MFWriter::CLib3MFWriter()
		: CLib3MFBaseClass()
{
}

CLib3MFWriter::~CLib3MFWriter()
{
}

void CLib3MFWriter::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFWriter"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToFile", WriteToFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStreamSize", GetStreamSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToBuffer", WriteToBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToCallback", WriteToCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetProgressCallback", SetProgressCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDecimalPrecision", GetDecimalPrecision);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDecimalPrecision", SetDecimalPrecision);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetStrictModeActive", SetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStrictModeActive", GetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarning", GetWarning);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarningCount", GetWarningCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddKeyWrappingCallback", AddKeyWrappingCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetContentEncryptionCallback", SetContentEncryptionCallback);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFWriter::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFWriter * writerInstance = new CLib3MFWriter();
				writerInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFWriter: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFWriter::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFWriter::WriteToFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Filename)");
        }
        v8::String::Utf8Value sutf8Filename(isolate, args[0]);
        std::string sFilename = *sutf8Filename;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToFile.");
        if (wrapperTable->m_Writer_WriteToFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::WriteToFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_WriteToFile(instanceHandle, sFilename.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetStreamSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnStreamSize = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStreamSize.");
        if (wrapperTable->m_Writer_GetStreamSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetStreamSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetStreamSize(instanceHandle, &nReturnStreamSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnStreamSize).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::WriteToBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToBuffer.");
        if (wrapperTable->m_Writer_WriteToBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::WriteToBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_WriteToBuffer(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::WriteToCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 2 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[2]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToCallback.");
        if (wrapperTable->m_Writer_WriteToCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::WriteToCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_WriteToCallback(instanceHandle, nullptr, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetProgressCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetProgressCallback.");
        if (wrapperTable->m_Writer_SetProgressCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetProgressCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetProgressCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetDecimalPrecision(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnDecimalPrecision = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDecimalPrecision.");
        if (wrapperTable->m_Writer_GetDecimalPrecision == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetDecimalPrecision.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetDecimalPrecision(instanceHandle, &nReturnDecimalPrecision);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnDecimalPrecision));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetDecimalPrecision(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (DecimalPrecision)");
        }
        unsigned int nDecimalPrecision = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDecimalPrecision.");
        if (wrapperTable->m_Writer_SetDecimalPrecision == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetDecimalPrecision.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetDecimalPrecision(instanceHandle, nDecimalPrecision);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (StrictModeActive)");
        }
        bool bStrictModeActive = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetStrictModeActive.");
        if (wrapperTable->m_Writer_SetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetStrictModeActive(instanceHandle, bStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnStrictModeActive = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStrictModeActive.");
        if (wrapperTable->m_Writer_GetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetStrictModeActive(instanceHandle, &bReturnStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnStrictModeActive));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetWarning(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        Local<Object> outObject = Object::New(isolate);
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nReturnErrorCode = 0;
        unsigned int bytesNeededWarning = 0;
        unsigned int bytesWrittenWarning = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarning.");
        if (wrapperTable->m_Writer_GetWarning == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetWarning.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Writer_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, 0, &bytesNeededWarning, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferWarning;
        bufferWarning.resize(bytesNeededWarning);
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, bytesNeededWarning, &bytesWrittenWarning, &bufferWarning[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ErrorCode"), Integer::NewFromUnsigned(isolate, nReturnErrorCode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Warning"), String::NewFromUtf8(isolate, &bufferWarning[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetWarningCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarningCount.");
        if (wrapperTable->m_Writer_GetWarningCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetWarningCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetWarningCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::AddKeyWrappingCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 2 (UserData)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        v8::String::Utf8Value sutf8UserData(isolate, args[2]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddKeyWrappingCallback.");
        if (wrapperTable->m_Writer_AddKeyWrappingCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::AddKeyWrappingCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_AddKeyWrappingCallback(instanceHandle, sConsumerID.c_str(), nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetContentEncryptionCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetContentEncryptionCallback.");
        if (wrapperTable->m_Writer_SetContentEncryptionCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetContentEncryptionCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetContentEncryptionCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFReader Implementation
**************************************************************************************************************************/

CLib3MFReader::CLib3MFReader()
		: CLib3MFBaseClass()
{
}

CLib3MFReader::~CLib3MFReader()
{
}

void CLib3MFReader::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFReader"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromFile", ReadFromFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromBuffer", ReadFromBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromCallback", ReadFromCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetProgressCallback", SetProgressCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddRelationToRead", AddRelationToRead);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveRelationToRead", RemoveRelationToRead);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetStrictModeActive", SetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStrictModeActive", GetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarning", GetWarning);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarningCount", GetWarningCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddKeyWrappingCallback", AddKeyWrappingCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetContentEncryptionCallback", SetContentEncryptionCallback);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFReader::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFReader * readerInstance = new CLib3MFReader();
				readerInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFReader: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFReader::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFReader::ReadFromFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Filename)");
        }
        v8::String::Utf8Value sutf8Filename(isolate, args[0]);
        std::string sFilename = *sutf8Filename;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromFile.");
        if (wrapperTable->m_Reader_ReadFromFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::ReadFromFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_ReadFromFile(instanceHandle, sFilename.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::ReadFromBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromBuffer.");
        if (wrapperTable->m_Reader_ReadFromBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::ReadFromBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_ReadFromBuffer(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::ReadFromCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 1 (StreamSize)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 3 (UserData)");
        }
        v8::String::Utf8Value sutf8StreamSize(isolate, args[1]);
        std::string sStreamSize = *sutf8StreamSize;
        uint64_t nStreamSize = stoull(sStreamSize);
        v8::String::Utf8Value sutf8UserData(isolate, args[3]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromCallback.");
        if (wrapperTable->m_Reader_ReadFromCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::ReadFromCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_ReadFromCallback(instanceHandle, nullptr, nStreamSize, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::SetProgressCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetProgressCallback.");
        if (wrapperTable->m_Reader_SetProgressCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::SetProgressCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_SetProgressCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::AddRelationToRead(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (RelationShipType)");
        }
        v8::String::Utf8Value sutf8RelationShipType(isolate, args[0]);
        std::string sRelationShipType = *sutf8RelationShipType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddRelationToRead.");
        if (wrapperTable->m_Reader_AddRelationToRead == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::AddRelationToRead.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_AddRelationToRead(instanceHandle, sRelationShipType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::RemoveRelationToRead(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (RelationShipType)");
        }
        v8::String::Utf8Value sutf8RelationShipType(isolate, args[0]);
        std::string sRelationShipType = *sutf8RelationShipType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveRelationToRead.");
        if (wrapperTable->m_Reader_RemoveRelationToRead == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::RemoveRelationToRead.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_RemoveRelationToRead(instanceHandle, sRelationShipType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::SetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (StrictModeActive)");
        }
        bool bStrictModeActive = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetStrictModeActive.");
        if (wrapperTable->m_Reader_SetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::SetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_SetStrictModeActive(instanceHandle, bStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::GetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnStrictModeActive = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStrictModeActive.");
        if (wrapperTable->m_Reader_GetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::GetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_GetStrictModeActive(instanceHandle, &bReturnStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnStrictModeActive));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::GetWarning(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        Local<Object> outObject = Object::New(isolate);
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nReturnErrorCode = 0;
        unsigned int bytesNeededWarning = 0;
        unsigned int bytesWrittenWarning = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarning.");
        if (wrapperTable->m_Reader_GetWarning == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::GetWarning.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Reader_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, 0, &bytesNeededWarning, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferWarning;
        bufferWarning.resize(bytesNeededWarning);
        Lib3MFResult errorCode = wrapperTable->m_Reader_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, bytesNeededWarning, &bytesWrittenWarning, &bufferWarning[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ErrorCode"), Integer::NewFromUnsigned(isolate, nReturnErrorCode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Warning"), String::NewFromUtf8(isolate, &bufferWarning[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::GetWarningCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarningCount.");
        if (wrapperTable->m_Reader_GetWarningCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::GetWarningCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_GetWarningCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::AddKeyWrappingCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 2 (UserData)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        v8::String::Utf8Value sutf8UserData(isolate, args[2]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddKeyWrappingCallback.");
        if (wrapperTable->m_Reader_AddKeyWrappingCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::AddKeyWrappingCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_AddKeyWrappingCallback(instanceHandle, sConsumerID.c_str(), nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::SetContentEncryptionCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetContentEncryptionCallback.");
        if (wrapperTable->m_Reader_SetContentEncryptionCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::SetContentEncryptionCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_SetContentEncryptionCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFPackagePart Implementation
**************************************************************************************************************************/

CLib3MFPackagePart::CLib3MFPackagePart()
		: CLib3MFBaseClass()
{
}

CLib3MFPackagePart::~CLib3MFPackagePart()
{
}

void CLib3MFPackagePart::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFPackagePart"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPath", GetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPath", SetPath);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFPackagePart::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFPackagePart * packagepartInstance = new CLib3MFPackagePart();
				packagepartInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFPackagePart: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFPackagePart::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFPackagePart::GetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPath.");
        if (wrapperTable->m_PackagePart_GetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method PackagePart::GetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_PackagePart_GetPath(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_PackagePart_GetPath(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFPackagePart::SetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPath.");
        if (wrapperTable->m_PackagePart_SetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method PackagePart::SetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_PackagePart_SetPath(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResource Implementation
**************************************************************************************************************************/

CLib3MFResource::CLib3MFResource()
		: CLib3MFBaseClass()
{
}

CLib3MFResource::~CLib3MFResource()
{
}

void CLib3MFResource::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResource"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceID", GetResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUniqueResourceID", GetUniqueResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "PackagePart", PackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPackagePart", SetPackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetModelResourceID", GetModelResourceID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResource::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResource * resourceInstance = new CLib3MFResource();
				resourceInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResource: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResource::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResource::GetResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceID.");
        if (wrapperTable->m_Resource_GetResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::GetResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_GetResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::GetUniqueResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUniqueResourceID.");
        if (wrapperTable->m_Resource_GetUniqueResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::GetUniqueResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_GetUniqueResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::PackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPackagePart = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method PackagePart.");
        if (wrapperTable->m_Resource_PackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::PackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_PackagePart(instanceHandle, &hReturnPackagePart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPackagePart = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnPackagePart);
        args.GetReturnValue().Set(instanceObjPackagePart);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::SetPackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (PackagePart)");
        }
        Local<Object> objPackagePart = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instancePackagePart = ObjectWrap::Unwrap<CLib3MFPackagePart>(objPackagePart);
        if (instancePackagePart == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (PackagePart)");
        Lib3MFHandle hPackagePart = instancePackagePart->getHandle( objPackagePart );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPackagePart.");
        if (wrapperTable->m_Resource_SetPackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::SetPackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_SetPackagePart(instanceHandle, hPackagePart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::GetModelResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnModelResourceId = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetModelResourceID.");
        if (wrapperTable->m_Resource_GetModelResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::GetModelResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_GetModelResourceID(instanceHandle, &nReturnModelResourceId);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnModelResourceId));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResourceIterator Implementation
**************************************************************************************************************************/

CLib3MFResourceIterator::CLib3MFResourceIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceIterator::~CLib3MFResourceIterator()
{
}

void CLib3MFResourceIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "MoveNext", MoveNext);
		NODE_SET_PROTOTYPE_METHOD(tpl, "MovePrevious", MovePrevious);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrent", GetCurrent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Clone", Clone);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Count", Count);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceIterator * resourceiteratorInstance = new CLib3MFResourceIterator();
				resourceiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceIterator::MoveNext(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasNext = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MoveNext.");
        if (wrapperTable->m_ResourceIterator_MoveNext == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::MoveNext.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_MoveNext(instanceHandle, &bReturnHasNext);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasNext));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::MovePrevious(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasPrevious = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MovePrevious.");
        if (wrapperTable->m_ResourceIterator_MovePrevious == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::MovePrevious.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_MovePrevious(instanceHandle, &bReturnHasPrevious);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasPrevious));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::GetCurrent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrent.");
        if (wrapperTable->m_ResourceIterator_GetCurrent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::GetCurrent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_GetCurrent(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFResource::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::Clone(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnOutResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Clone.");
        if (wrapperTable->m_ResourceIterator_Clone == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::Clone.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_Clone(instanceHandle, &hReturnOutResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjOutResourceIterator = CLib3MFResourceIterator::NewInstance(args.Holder(), hReturnOutResourceIterator);
        args.GetReturnValue().Set(instanceObjOutResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::Count(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Count.");
        if (wrapperTable->m_ResourceIterator_Count == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::Count.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_Count(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSliceStackIterator Implementation
**************************************************************************************************************************/

CLib3MFSliceStackIterator::CLib3MFSliceStackIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFSliceStackIterator::~CLib3MFSliceStackIterator()
{
}

void CLib3MFSliceStackIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSliceStackIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentSliceStack", GetCurrentSliceStack);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSliceStackIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSliceStackIterator * slicestackiteratorInstance = new CLib3MFSliceStackIterator();
				slicestackiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSliceStackIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSliceStackIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSliceStackIterator::GetCurrentSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentSliceStack.");
        if (wrapperTable->m_SliceStackIterator_GetCurrentSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStackIterator::GetCurrentSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStackIterator_GetCurrentSliceStack(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFObjectIterator Implementation
**************************************************************************************************************************/

CLib3MFObjectIterator::CLib3MFObjectIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFObjectIterator::~CLib3MFObjectIterator()
{
}

void CLib3MFObjectIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFObjectIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentObject", GetCurrentObject);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFObjectIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFObjectIterator * objectiteratorInstance = new CLib3MFObjectIterator();
				objectiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFObjectIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFObjectIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFObjectIterator::GetCurrentObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentObject.");
        if (wrapperTable->m_ObjectIterator_GetCurrentObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ObjectIterator::GetCurrentObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ObjectIterator_GetCurrentObject(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFObject::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMeshObjectIterator Implementation
**************************************************************************************************************************/

CLib3MFMeshObjectIterator::CLib3MFMeshObjectIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFMeshObjectIterator::~CLib3MFMeshObjectIterator()
{
}

void CLib3MFMeshObjectIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMeshObjectIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentMeshObject", GetCurrentMeshObject);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMeshObjectIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMeshObjectIterator * meshobjectiteratorInstance = new CLib3MFMeshObjectIterator();
				meshobjectiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMeshObjectIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMeshObjectIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMeshObjectIterator::GetCurrentMeshObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentMeshObject.");
        if (wrapperTable->m_MeshObjectIterator_GetCurrentMeshObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObjectIterator::GetCurrentMeshObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObjectIterator_GetCurrentMeshObject(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFMeshObject::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComponentsObjectIterator Implementation
**************************************************************************************************************************/

CLib3MFComponentsObjectIterator::CLib3MFComponentsObjectIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFComponentsObjectIterator::~CLib3MFComponentsObjectIterator()
{
}

void CLib3MFComponentsObjectIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComponentsObjectIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentComponentsObject", GetCurrentComponentsObject);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComponentsObjectIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComponentsObjectIterator * componentsobjectiteratorInstance = new CLib3MFComponentsObjectIterator();
				componentsobjectiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComponentsObjectIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComponentsObjectIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComponentsObjectIterator::GetCurrentComponentsObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentComponentsObject.");
        if (wrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObjectIterator::GetCurrentComponentsObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFComponentsObject::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2DIterator Implementation
**************************************************************************************************************************/

CLib3MFTexture2DIterator::CLib3MFTexture2DIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2DIterator::~CLib3MFTexture2DIterator()
{
}

void CLib3MFTexture2DIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2DIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentTexture2D", GetCurrentTexture2D);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2DIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2DIterator * texture2diteratorInstance = new CLib3MFTexture2DIterator();
				texture2diteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2DIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2DIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2DIterator::GetCurrentTexture2D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentTexture2D.");
        if (wrapperTable->m_Texture2DIterator_GetCurrentTexture2D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DIterator::GetCurrentTexture2D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DIterator_GetCurrentTexture2D(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFTexture2D::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFBaseMaterialGroupIterator::CLib3MFBaseMaterialGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFBaseMaterialGroupIterator::~CLib3MFBaseMaterialGroupIterator()
{
}

void CLib3MFBaseMaterialGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBaseMaterialGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentBaseMaterialGroup", GetCurrentBaseMaterialGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBaseMaterialGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBaseMaterialGroupIterator * basematerialgroupiteratorInstance = new CLib3MFBaseMaterialGroupIterator();
				basematerialgroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBaseMaterialGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBaseMaterialGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentBaseMaterialGroup.");
        if (wrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroupIterator::GetCurrentBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFColorGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFColorGroupIterator::CLib3MFColorGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFColorGroupIterator::~CLib3MFColorGroupIterator()
{
}

void CLib3MFColorGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFColorGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentColorGroup", GetCurrentColorGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFColorGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFColorGroupIterator * colorgroupiteratorInstance = new CLib3MFColorGroupIterator();
				colorgroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFColorGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFColorGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFColorGroupIterator::GetCurrentColorGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentColorGroup.");
        if (wrapperTable->m_ColorGroupIterator_GetCurrentColorGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroupIterator::GetCurrentColorGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroupIterator_GetCurrentColorGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFColorGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFTexture2DGroupIterator::CLib3MFTexture2DGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2DGroupIterator::~CLib3MFTexture2DGroupIterator()
{
}

void CLib3MFTexture2DGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2DGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentTexture2DGroup", GetCurrentTexture2DGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2DGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2DGroupIterator * texture2dgroupiteratorInstance = new CLib3MFTexture2DGroupIterator();
				texture2dgroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2DGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2DGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2DGroupIterator::GetCurrentTexture2DGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentTexture2DGroup.");
        if (wrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroupIterator::GetCurrentTexture2DGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFTexture2DGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterialsIterator Implementation
**************************************************************************************************************************/

CLib3MFCompositeMaterialsIterator::CLib3MFCompositeMaterialsIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFCompositeMaterialsIterator::~CLib3MFCompositeMaterialsIterator()
{
}

void CLib3MFCompositeMaterialsIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCompositeMaterialsIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentCompositeMaterials", GetCurrentCompositeMaterials);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCompositeMaterialsIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCompositeMaterialsIterator * compositematerialsiteratorInstance = new CLib3MFCompositeMaterialsIterator();
				compositematerialsiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCompositeMaterialsIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCompositeMaterialsIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFCompositeMaterialsIterator::GetCurrentCompositeMaterials(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentCompositeMaterials.");
        if (wrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterialsIterator::GetCurrentCompositeMaterials.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFCompositeMaterials::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFMultiPropertyGroupIterator::CLib3MFMultiPropertyGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFMultiPropertyGroupIterator::~CLib3MFMultiPropertyGroupIterator()
{
}

void CLib3MFMultiPropertyGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMultiPropertyGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentMultiPropertyGroup", GetCurrentMultiPropertyGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMultiPropertyGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMultiPropertyGroupIterator * multipropertygroupiteratorInstance = new CLib3MFMultiPropertyGroupIterator();
				multipropertygroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMultiPropertyGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMultiPropertyGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentMultiPropertyGroup.");
        if (wrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroupIterator::GetCurrentMultiPropertyGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFMultiPropertyGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMetaData Implementation
**************************************************************************************************************************/

CLib3MFMetaData::CLib3MFMetaData()
		: CLib3MFBaseClass()
{
}

CLib3MFMetaData::~CLib3MFMetaData()
{
}

void CLib3MFMetaData::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMetaData"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetNameSpace", GetNameSpace);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetNameSpace", SetNameSpace);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKey", GetKey);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMustPreserve", GetMustPreserve);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMustPreserve", SetMustPreserve);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetType", GetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetType", SetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetValue", GetValue);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetValue", SetValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMetaData::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMetaData * metadataInstance = new CLib3MFMetaData();
				metadataInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMetaData: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMetaData::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMetaData::GetNameSpace(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededNameSpace = 0;
        unsigned int bytesWrittenNameSpace = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetNameSpace.");
        if (wrapperTable->m_MetaData_GetNameSpace == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetNameSpace.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetNameSpace(instanceHandle, 0, &bytesNeededNameSpace, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferNameSpace;
        bufferNameSpace.resize(bytesNeededNameSpace);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetNameSpace(instanceHandle, bytesNeededNameSpace, &bytesWrittenNameSpace, &bufferNameSpace[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferNameSpace[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetNameSpace(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (NameSpace)");
        }
        v8::String::Utf8Value sutf8NameSpace(isolate, args[0]);
        std::string sNameSpace = *sutf8NameSpace;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetNameSpace.");
        if (wrapperTable->m_MetaData_SetNameSpace == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetNameSpace.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetNameSpace(instanceHandle, sNameSpace.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_MetaData_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_MetaData_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetKey(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededKey = 0;
        unsigned int bytesWrittenKey = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKey.");
        if (wrapperTable->m_MetaData_GetKey == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetKey.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetKey(instanceHandle, 0, &bytesNeededKey, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferKey;
        bufferKey.resize(bytesNeededKey);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetKey(instanceHandle, bytesNeededKey, &bytesWrittenKey, &bufferKey[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferKey[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetMustPreserve(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnMustPreserve = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMustPreserve.");
        if (wrapperTable->m_MetaData_GetMustPreserve == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetMustPreserve.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetMustPreserve(instanceHandle, &bReturnMustPreserve);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnMustPreserve));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetMustPreserve(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (MustPreserve)");
        }
        bool bMustPreserve = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMustPreserve.");
        if (wrapperTable->m_MetaData_SetMustPreserve == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetMustPreserve.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetMustPreserve(instanceHandle, bMustPreserve);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededType = 0;
        unsigned int bytesWrittenType = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetType.");
        if (wrapperTable->m_MetaData_GetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetType(instanceHandle, 0, &bytesNeededType, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferType;
        bufferType.resize(bytesNeededType);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetType(instanceHandle, bytesNeededType, &bytesWrittenType, &bufferType[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferType[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Type)");
        }
        v8::String::Utf8Value sutf8Type(isolate, args[0]);
        std::string sType = *sutf8Type;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetType.");
        if (wrapperTable->m_MetaData_SetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetType(instanceHandle, sType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededValue = 0;
        unsigned int bytesWrittenValue = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetValue.");
        if (wrapperTable->m_MetaData_GetValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetValue(instanceHandle, 0, &bytesNeededValue, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferValue;
        bufferValue.resize(bytesNeededValue);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetValue(instanceHandle, bytesNeededValue, &bytesWrittenValue, &bufferValue[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferValue[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Value)");
        }
        v8::String::Utf8Value sutf8Value(isolate, args[0]);
        std::string sValue = *sutf8Value;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetValue.");
        if (wrapperTable->m_MetaData_SetValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetValue(instanceHandle, sValue.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMetaDataGroup Implementation
**************************************************************************************************************************/

CLib3MFMetaDataGroup::CLib3MFMetaDataGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFMetaDataGroup::~CLib3MFMetaDataGroup()
{
}

void CLib3MFMetaDataGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMetaDataGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataCount", GetMetaDataCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaData", GetMetaData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataByKey", GetMetaDataByKey);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMetaDataByIndex", RemoveMetaDataByIndex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMetaData", RemoveMetaData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMetaData", AddMetaData);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMetaDataGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMetaDataGroup * metadatagroupInstance = new CLib3MFMetaDataGroup();
				metadatagroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMetaDataGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMetaDataGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMetaDataGroup::GetMetaDataCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataCount.");
        if (wrapperTable->m_MetaDataGroup_GetMetaDataCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::GetMetaDataCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_GetMetaDataCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::GetMetaData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnMetaData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaData.");
        if (wrapperTable->m_MetaDataGroup_GetMetaData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::GetMetaData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_GetMetaData(instanceHandle, nIndex, &hReturnMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaData = CLib3MFMetaData::NewInstance(args.Holder(), hReturnMetaData);
        args.GetReturnValue().Set(instanceObjMetaData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::GetMetaDataByKey(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (NameSpace)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        v8::String::Utf8Value sutf8NameSpace(isolate, args[0]);
        std::string sNameSpace = *sutf8NameSpace;
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        Lib3MFHandle hReturnMetaData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataByKey.");
        if (wrapperTable->m_MetaDataGroup_GetMetaDataByKey == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::GetMetaDataByKey.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_GetMetaDataByKey(instanceHandle, sNameSpace.c_str(), sName.c_str(), &hReturnMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaData = CLib3MFMetaData::NewInstance(args.Holder(), hReturnMetaData);
        args.GetReturnValue().Set(instanceObjMetaData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::RemoveMetaDataByIndex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMetaDataByIndex.");
        if (wrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::RemoveMetaDataByIndex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex(instanceHandle, nIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::RemoveMetaData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheMetaData)");
        }
        Local<Object> objTheMetaData = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFMetaData * instanceTheMetaData = ObjectWrap::Unwrap<CLib3MFMetaData>(objTheMetaData);
        if (instanceTheMetaData == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheMetaData)");
        Lib3MFHandle hTheMetaData = instanceTheMetaData->getHandle( objTheMetaData );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMetaData.");
        if (wrapperTable->m_MetaDataGroup_RemoveMetaData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::RemoveMetaData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_RemoveMetaData(instanceHandle, hTheMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::AddMetaData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (NameSpace)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Value)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Type)");
        }
        if (!args[4]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 4 (MustPreserve)");
        }
        v8::String::Utf8Value sutf8NameSpace(isolate, args[0]);
        std::string sNameSpace = *sutf8NameSpace;
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        v8::String::Utf8Value sutf8Value(isolate, args[2]);
        std::string sValue = *sutf8Value;
        v8::String::Utf8Value sutf8Type(isolate, args[3]);
        std::string sType = *sutf8Type;
        bool bMustPreserve = args[4]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnMetaData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMetaData.");
        if (wrapperTable->m_MetaDataGroup_AddMetaData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::AddMetaData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_AddMetaData(instanceHandle, sNameSpace.c_str(), sName.c_str(), sValue.c_str(), sType.c_str(), bMustPreserve, &hReturnMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaData = CLib3MFMetaData::NewInstance(args.Holder(), hReturnMetaData);
        args.GetReturnValue().Set(instanceObjMetaData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFObject Implementation
**************************************************************************************************************************/

CLib3MFObject::CLib3MFObject()
		: CLib3MFBaseClass()
{
}

CLib3MFObject::~CLib3MFObject()
{
}

void CLib3MFObject::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFObject"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetType", GetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetType", SetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPartNumber", GetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPartNumber", SetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsMeshObject", IsMeshObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsComponentsObject", IsComponentsObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsValid", IsValid);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAttachmentAsThumbnail", SetAttachmentAsThumbnail);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetThumbnailAttachment", GetThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClearThumbnailAttachment", ClearThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutbox", GetOutbox);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataGroup", GetMetaDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetSlicesMeshResolution", SetSlicesMeshResolution);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSlicesMeshResolution", GetSlicesMeshResolution);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasSlices", HasSlices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClearSliceStack", ClearSliceStack);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceStack", GetSliceStack);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AssignSliceStack", AssignSliceStack);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFObject::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFObject * objectInstance = new CLib3MFObject();
				objectInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFObject: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFObject::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFObject::GetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFObjectType eReturnObjectType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetType.");
        if (wrapperTable->m_Object_GetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetType(instanceHandle, &eReturnObjectType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnObjectType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ObjectType)");
        }
        unsigned int eObjectType = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetType.");
        if (wrapperTable->m_Object_SetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetType(instanceHandle, (eLib3MFObjectType) eObjectType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_Object_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Object_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_Object_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_Object_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPartNumber = 0;
        unsigned int bytesWrittenPartNumber = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPartNumber.");
        if (wrapperTable->m_Object_GetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Object_GetPartNumber(instanceHandle, 0, &bytesNeededPartNumber, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPartNumber;
        bufferPartNumber.resize(bytesNeededPartNumber);
        Lib3MFResult errorCode = wrapperTable->m_Object_GetPartNumber(instanceHandle, bytesNeededPartNumber, &bytesWrittenPartNumber, &bufferPartNumber[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPartNumber[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (PartNumber)");
        }
        v8::String::Utf8Value sutf8PartNumber(isolate, args[0]);
        std::string sPartNumber = *sutf8PartNumber;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPartNumber.");
        if (wrapperTable->m_Object_SetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetPartNumber(instanceHandle, sPartNumber.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsMeshObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsMeshObject = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsMeshObject.");
        if (wrapperTable->m_Object_IsMeshObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsMeshObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsMeshObject(instanceHandle, &bReturnIsMeshObject);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsMeshObject));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsComponentsObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsComponentsObject = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsComponentsObject.");
        if (wrapperTable->m_Object_IsComponentsObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsComponentsObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsComponentsObject(instanceHandle, &bReturnIsComponentsObject);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsComponentsObject));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsValid(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsValid = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsValid.");
        if (wrapperTable->m_Object_IsValid == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsValid.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsValid(instanceHandle, &bReturnIsValid);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsValid));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetAttachmentAsThumbnail(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Attachment)");
        }
        Local<Object> objAttachment = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceAttachment = ObjectWrap::Unwrap<CLib3MFAttachment>(objAttachment);
        if (instanceAttachment == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Attachment)");
        Lib3MFHandle hAttachment = instanceAttachment->getHandle( objAttachment );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAttachmentAsThumbnail.");
        if (wrapperTable->m_Object_SetAttachmentAsThumbnail == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetAttachmentAsThumbnail.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetAttachmentAsThumbnail(instanceHandle, hAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnAttachment = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetThumbnailAttachment.");
        if (wrapperTable->m_Object_GetThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetThumbnailAttachment(instanceHandle, &hReturnAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachment = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachment);
        args.GetReturnValue().Set(instanceObjAttachment);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::ClearThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClearThumbnailAttachment.");
        if (wrapperTable->m_Object_ClearThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::ClearThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_ClearThumbnailAttachment(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetOutbox(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFBox sReturnOutbox;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutbox.");
        if (wrapperTable->m_Object_GetOutbox == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetOutbox.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetOutbox(instanceHandle, &sReturnOutbox);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBoxToObject(isolate, sReturnOutbox));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_Object_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Object_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_Object_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_Object_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetMetaDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMetaDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataGroup.");
        if (wrapperTable->m_Object_GetMetaDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetMetaDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetMetaDataGroup(instanceHandle, &hReturnMetaDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaDataGroup = CLib3MFMetaDataGroup::NewInstance(args.Holder(), hReturnMetaDataGroup);
        args.GetReturnValue().Set(instanceObjMetaDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetSlicesMeshResolution(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (MeshResolution)");
        }
        unsigned int eMeshResolution = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetSlicesMeshResolution.");
        if (wrapperTable->m_Object_SetSlicesMeshResolution == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetSlicesMeshResolution.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetSlicesMeshResolution(instanceHandle, (eLib3MFSlicesMeshResolution) eMeshResolution);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetSlicesMeshResolution(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFSlicesMeshResolution eReturnMeshResolution;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSlicesMeshResolution.");
        if (wrapperTable->m_Object_GetSlicesMeshResolution == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetSlicesMeshResolution.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetSlicesMeshResolution(instanceHandle, &eReturnMeshResolution);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnMeshResolution));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::HasSlices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (Recursive)");
        }
        bool bRecursive = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        bool bReturnHasSlices = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasSlices.");
        if (wrapperTable->m_Object_HasSlices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::HasSlices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_HasSlices(instanceHandle, bRecursive, &bReturnHasSlices);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasSlices));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::ClearSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClearSliceStack.");
        if (wrapperTable->m_Object_ClearSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::ClearSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_ClearSliceStack(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnSliceStackInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceStack.");
        if (wrapperTable->m_Object_GetSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetSliceStack(instanceHandle, &hReturnSliceStackInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSliceStackInstance = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnSliceStackInstance);
        args.GetReturnValue().Set(instanceObjSliceStackInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::AssignSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (SliceStackInstance)");
        }
        Local<Object> objSliceStackInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFSliceStack * instanceSliceStackInstance = ObjectWrap::Unwrap<CLib3MFSliceStack>(objSliceStackInstance);
        if (instanceSliceStackInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (SliceStackInstance)");
        Lib3MFHandle hSliceStackInstance = instanceSliceStackInstance->getHandle( objSliceStackInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AssignSliceStack.");
        if (wrapperTable->m_Object_AssignSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::AssignSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_AssignSliceStack(instanceHandle, hSliceStackInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMeshObject Implementation
**************************************************************************************************************************/

CLib3MFMeshObject::CLib3MFMeshObject()
		: CLib3MFBaseClass()
{
}

CLib3MFMeshObject::~CLib3MFMeshObject()
{
}

void CLib3MFMeshObject::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMeshObject"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertexCount", GetVertexCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleCount", GetTriangleCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertex", GetVertex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVertex", SetVertex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddVertex", AddVertex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertices", GetVertices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangle", GetTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTriangle", SetTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTriangle", AddTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleIndices", GetTriangleIndices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetObjectLevelProperty", SetObjectLevelProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectLevelProperty", GetObjectLevelProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTriangleProperties", SetTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleProperties", GetTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAllTriangleProperties", SetAllTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllTriangleProperties", GetAllTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClearAllProperties", ClearAllProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetGeometry", SetGeometry);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsManifoldAndOriented", IsManifoldAndOriented);
		NODE_SET_PROTOTYPE_METHOD(tpl, "BeamLattice", BeamLattice);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMeshObject::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMeshObject * meshobjectInstance = new CLib3MFMeshObject();
				meshobjectInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMeshObject: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMeshObject::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMeshObject::GetVertexCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnVertexCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertexCount.");
        if (wrapperTable->m_MeshObject_GetVertexCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVertexCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVertexCount(instanceHandle, &nReturnVertexCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnVertexCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnVertexCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleCount.");
        if (wrapperTable->m_MeshObject_GetTriangleCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleCount(instanceHandle, &nReturnVertexCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnVertexCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetVertex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFPosition sReturnCoordinates;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertex.");
        if (wrapperTable->m_MeshObject_GetVertex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVertex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVertex(instanceHandle, nIndex, &sReturnCoordinates);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFPositionToObject(isolate, sReturnCoordinates));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetVertex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Coordinates)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFPosition sCoordinates = convertObjectToLib3MFPosition(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVertex.");
        if (wrapperTable->m_MeshObject_SetVertex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetVertex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetVertex(instanceHandle, nIndex, &sCoordinates);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::AddVertex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Coordinates)");
        }
        sLib3MFPosition sCoordinates = convertObjectToLib3MFPosition(isolate, args[0]);
        unsigned int nReturnNewIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddVertex.");
        if (wrapperTable->m_MeshObject_AddVertex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::AddVertex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_AddVertex(instanceHandle, &sCoordinates, &nReturnNewIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnNewIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetVertices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertices.");
        if (wrapperTable->m_MeshObject_GetVertices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVertices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVertices(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangle sReturnIndices;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangle.");
        if (wrapperTable->m_MeshObject_GetTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangle(instanceHandle, nIndex, &sReturnIndices);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTriangleToObject(isolate, sReturnIndices));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Indices)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangle sIndices = convertObjectToLib3MFTriangle(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTriangle.");
        if (wrapperTable->m_MeshObject_SetTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetTriangle(instanceHandle, nIndex, &sIndices);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::AddTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Indices)");
        }
        sLib3MFTriangle sIndices = convertObjectToLib3MFTriangle(isolate, args[0]);
        unsigned int nReturnNewIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTriangle.");
        if (wrapperTable->m_MeshObject_AddTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::AddTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_AddTriangle(instanceHandle, &sIndices, &nReturnNewIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnNewIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleIndices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleIndices.");
        if (wrapperTable->m_MeshObject_GetTriangleIndices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleIndices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleIndices(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetObjectLevelProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 1 (PropertyID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nPropertyID = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetObjectLevelProperty.");
        if (wrapperTable->m_MeshObject_SetObjectLevelProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetObjectLevelProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetObjectLevelProperty(instanceHandle, nUniqueResourceID, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetObjectLevelProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        unsigned int nReturnUniqueResourceID = 0;
        unsigned int nReturnPropertyID = 0;
        bool bReturnHasObjectLevelProperty = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectLevelProperty.");
        if (wrapperTable->m_MeshObject_GetObjectLevelProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetObjectLevelProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetObjectLevelProperty(instanceHandle, &nReturnUniqueResourceID, &nReturnPropertyID, &bReturnHasObjectLevelProperty);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UniqueResourceID"), Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "PropertyID"), Integer::NewFromUnsigned(isolate, nReturnPropertyID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasObjectLevelProperty"), Boolean::New(isolate, bReturnHasObjectLevelProperty));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Properties)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangleProperties sProperties = convertObjectToLib3MFTriangleProperties(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTriangleProperties.");
        if (wrapperTable->m_MeshObject_SetTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetTriangleProperties(instanceHandle, nIndex, &sProperties);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangleProperties sReturnProperty;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleProperties.");
        if (wrapperTable->m_MeshObject_GetTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleProperties(instanceHandle, nIndex, &sReturnProperty);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTrianglePropertiesToObject(isolate, sReturnProperty));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetAllTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAllTriangleProperties.");
        if (wrapperTable->m_MeshObject_SetAllTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetAllTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetAllTriangleProperties(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetAllTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllTriangleProperties.");
        if (wrapperTable->m_MeshObject_GetAllTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetAllTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetAllTriangleProperties(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::ClearAllProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClearAllProperties.");
        if (wrapperTable->m_MeshObject_ClearAllProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::ClearAllProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_ClearAllProperties(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetGeometry(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetGeometry.");
        if (wrapperTable->m_MeshObject_SetGeometry == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetGeometry.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetGeometry(instanceHandle, 0, nullptr, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::IsManifoldAndOriented(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsManifoldAndOriented = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsManifoldAndOriented.");
        if (wrapperTable->m_MeshObject_IsManifoldAndOriented == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::IsManifoldAndOriented.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_IsManifoldAndOriented(instanceHandle, &bReturnIsManifoldAndOriented);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsManifoldAndOriented));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::BeamLattice(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheBeamLattice = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method BeamLattice.");
        if (wrapperTable->m_MeshObject_BeamLattice == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::BeamLattice.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_BeamLattice(instanceHandle, &hReturnTheBeamLattice);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheBeamLattice = CLib3MFBeamLattice::NewInstance(args.Holder(), hReturnTheBeamLattice);
        args.GetReturnValue().Set(instanceObjTheBeamLattice);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBeamLattice Implementation
**************************************************************************************************************************/

CLib3MFBeamLattice::CLib3MFBeamLattice()
		: CLib3MFBaseClass()
{
}

CLib3MFBeamLattice::~CLib3MFBeamLattice()
{
}

void CLib3MFBeamLattice::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBeamLattice"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMinLength", GetMinLength);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMinLength", SetMinLength);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetClipping", GetClipping);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetClipping", SetClipping);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetRepresentation", GetRepresentation);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetRepresentation", SetRepresentation);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallOptions", GetBallOptions);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBallOptions", SetBallOptions);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeamCount", GetBeamCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeam", GetBeam);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBeam", AddBeam);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBeam", SetBeam);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBeams", SetBeams);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeams", GetBeams);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallCount", GetBallCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBall", GetBall);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBall", AddBall);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBall", SetBall);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBalls", SetBalls);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBalls", GetBalls);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeamSetCount", GetBeamSetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBeamSet", AddBeamSet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeamSet", GetBeamSet);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBeamLattice::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBeamLattice * beamlatticeInstance = new CLib3MFBeamLattice();
				beamlatticeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBeamLattice: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBeamLattice::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBeamLattice::GetMinLength(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnMinLength = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMinLength.");
        if (wrapperTable->m_BeamLattice_GetMinLength == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetMinLength.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetMinLength(instanceHandle, &dReturnMinLength);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnMinLength));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetMinLength(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (MinLength)");
        }
        double dMinLength = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMinLength.");
        if (wrapperTable->m_BeamLattice_SetMinLength == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetMinLength.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetMinLength(instanceHandle, dMinLength);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetClipping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFBeamLatticeClipMode eReturnClipMode;
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetClipping.");
        if (wrapperTable->m_BeamLattice_GetClipping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetClipping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetClipping(instanceHandle, &eReturnClipMode, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ClipMode"), Integer::New(isolate, (int)eReturnClipMode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UniqueResourceID"), Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetClipping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ClipMode)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 1 (UniqueResourceID)");
        }
        unsigned int eClipMode = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nUniqueResourceID = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetClipping.");
        if (wrapperTable->m_BeamLattice_SetClipping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetClipping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetClipping(instanceHandle, (eLib3MFBeamLatticeClipMode) eClipMode, nUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetRepresentation(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasRepresentation = false;
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetRepresentation.");
        if (wrapperTable->m_BeamLattice_GetRepresentation == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetRepresentation.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetRepresentation(instanceHandle, &bReturnHasRepresentation, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasRepresentation"), Boolean::New(isolate, bReturnHasRepresentation));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UniqueResourceID"), Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetRepresentation(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetRepresentation.");
        if (wrapperTable->m_BeamLattice_SetRepresentation == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetRepresentation.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetRepresentation(instanceHandle, nUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBallOptions(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFBeamLatticeBallMode eReturnBallMode;
        double dReturnBallRadius = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallOptions.");
        if (wrapperTable->m_BeamLattice_GetBallOptions == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBallOptions.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBallOptions(instanceHandle, &eReturnBallMode, &dReturnBallRadius);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "BallMode"), Integer::New(isolate, (int)eReturnBallMode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "BallRadius"), Number::New(isolate, dReturnBallRadius));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBallOptions(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (BallMode)");
        }
        if (!args[1]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 1 (BallRadius)");
        }
        unsigned int eBallMode = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        double dBallRadius = (double) args[1]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBallOptions.");
        if (wrapperTable->m_BeamLattice_SetBallOptions == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBallOptions.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBallOptions(instanceHandle, (eLib3MFBeamLatticeBallMode) eBallMode, dBallRadius);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeamCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeamCount.");
        if (wrapperTable->m_BeamLattice_GetBeamCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeamCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeamCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeam(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBeam sReturnBeamInfo;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeam.");
        if (wrapperTable->m_BeamLattice_GetBeam == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeam.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeam(instanceHandle, nIndex, &sReturnBeamInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBeamToObject(isolate, sReturnBeamInfo));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::AddBeam(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (BeamInfo)");
        }
        sLib3MFBeam sBeamInfo = convertObjectToLib3MFBeam(isolate, args[0]);
        unsigned int nReturnIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBeam.");
        if (wrapperTable->m_BeamLattice_AddBeam == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::AddBeam.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_AddBeam(instanceHandle, &sBeamInfo, &nReturnIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBeam(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (BeamInfo)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBeam sBeamInfo = convertObjectToLib3MFBeam(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBeam.");
        if (wrapperTable->m_BeamLattice_SetBeam == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBeam.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBeam(instanceHandle, nIndex, &sBeamInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBeams(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBeams.");
        if (wrapperTable->m_BeamLattice_SetBeams == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBeams.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBeams(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeams(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeams.");
        if (wrapperTable->m_BeamLattice_GetBeams == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeams.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeams(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBallCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallCount.");
        if (wrapperTable->m_BeamLattice_GetBallCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBallCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBallCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBall(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBall sReturnBallInfo;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBall.");
        if (wrapperTable->m_BeamLattice_GetBall == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBall.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBall(instanceHandle, nIndex, &sReturnBallInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBallToObject(isolate, sReturnBallInfo));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::AddBall(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (BallInfo)");
        }
        sLib3MFBall sBallInfo = convertObjectToLib3MFBall(isolate, args[0]);
        unsigned int nReturnIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBall.");
        if (wrapperTable->m_BeamLattice_AddBall == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::AddBall.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_AddBall(instanceHandle, &sBallInfo, &nReturnIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBall(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (BallInfo)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBall sBallInfo = convertObjectToLib3MFBall(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBall.");
        if (wrapperTable->m_BeamLattice_SetBall == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBall.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBall(instanceHandle, nIndex, &sBallInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBalls(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBalls.");
        if (wrapperTable->m_BeamLattice_SetBalls == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBalls.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBalls(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBalls(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBalls.");
        if (wrapperTable->m_BeamLattice_GetBalls == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBalls.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBalls(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeamSetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeamSetCount.");
        if (wrapperTable->m_BeamLattice_GetBeamSetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeamSetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeamSetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::AddBeamSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBeamSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBeamSet.");
        if (wrapperTable->m_BeamLattice_AddBeamSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::AddBeamSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_AddBeamSet(instanceHandle, &hReturnBeamSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBeamSet = CLib3MFBeamSet::NewInstance(args.Holder(), hReturnBeamSet);
        args.GetReturnValue().Set(instanceObjBeamSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeamSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnBeamSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeamSet.");
        if (wrapperTable->m_BeamLattice_GetBeamSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeamSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeamSet(instanceHandle, nIndex, &hReturnBeamSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBeamSet = CLib3MFBeamSet::NewInstance(args.Holder(), hReturnBeamSet);
        args.GetReturnValue().Set(instanceObjBeamSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComponent Implementation
**************************************************************************************************************************/

CLib3MFComponent::CLib3MFComponent()
		: CLib3MFBaseClass()
{
}

CLib3MFComponent::~CLib3MFComponent()
{
}

void CLib3MFComponent::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComponent"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResource", GetObjectResource);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResourceID", GetObjectResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasTransform", HasTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTransform", GetTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTransform", SetTransform);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComponent::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComponent * componentInstance = new CLib3MFComponent();
				componentInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComponent: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComponent::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComponent::GetObjectResource(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnObjectResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResource.");
        if (wrapperTable->m_Component_GetObjectResource == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetObjectResource.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_GetObjectResource(instanceHandle, &hReturnObjectResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjObjectResource = CLib3MFObject::NewInstance(args.Holder(), hReturnObjectResource);
        args.GetReturnValue().Set(instanceObjObjectResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::GetObjectResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResourceID.");
        if (wrapperTable->m_Component_GetObjectResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetObjectResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_GetObjectResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_Component_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Component_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_Component_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_Component_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::HasTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasTransform = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasTransform.");
        if (wrapperTable->m_Component_HasTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::HasTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_HasTransform(instanceHandle, &bReturnHasTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::GetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTransform.");
        if (wrapperTable->m_Component_GetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_GetTransform(instanceHandle, &sReturnTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::SetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTransform.");
        if (wrapperTable->m_Component_SetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::SetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_SetTransform(instanceHandle, &sTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComponentsObject Implementation
**************************************************************************************************************************/

CLib3MFComponentsObject::CLib3MFComponentsObject()
		: CLib3MFBaseClass()
{
}

CLib3MFComponentsObject::~CLib3MFComponentsObject()
{
}

void CLib3MFComponentsObject::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComponentsObject"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComponent", AddComponent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComponent", GetComponent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComponentCount", GetComponentCount);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComponentsObject::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComponentsObject * componentsobjectInstance = new CLib3MFComponentsObject();
				componentsobjectInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComponentsObject: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComponentsObject::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComponentsObject::AddComponent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ObjectResource)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Transform)");
        }
        Local<Object> objObjectResource = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFObject * instanceObjectResource = ObjectWrap::Unwrap<CLib3MFObject>(objObjectResource);
        if (instanceObjectResource == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ObjectResource)");
        Lib3MFHandle hObjectResource = instanceObjectResource->getHandle( objObjectResource );
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[1]);
        Lib3MFHandle hReturnComponentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComponent.");
        if (wrapperTable->m_ComponentsObject_AddComponent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObject::AddComponent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObject_AddComponent(instanceHandle, hObjectResource, &sTransform, &hReturnComponentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjComponentInstance = CLib3MFComponent::NewInstance(args.Holder(), hReturnComponentInstance);
        args.GetReturnValue().Set(instanceObjComponentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponentsObject::GetComponent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnComponentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComponent.");
        if (wrapperTable->m_ComponentsObject_GetComponent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObject::GetComponent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObject_GetComponent(instanceHandle, nIndex, &hReturnComponentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjComponentInstance = CLib3MFComponent::NewInstance(args.Holder(), hReturnComponentInstance);
        args.GetReturnValue().Set(instanceObjComponentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponentsObject::GetComponentCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComponentCount.");
        if (wrapperTable->m_ComponentsObject_GetComponentCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObject::GetComponentCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObject_GetComponentCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBeamSet Implementation
**************************************************************************************************************************/

CLib3MFBeamSet::CLib3MFBeamSet()
		: CLib3MFBaseClass()
{
}

CLib3MFBeamSet::~CLib3MFBeamSet()
{
}

void CLib3MFBeamSet::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBeamSet"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIdentifier", SetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentifier", GetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetReferenceCount", GetReferenceCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetReferences", SetReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetReferences", GetReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallReferenceCount", GetBallReferenceCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBallReferences", SetBallReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallReferences", GetBallReferences);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBeamSet::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBeamSet * beamsetInstance = new CLib3MFBeamSet();
				beamsetInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBeamSet: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBeamSet::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBeamSet::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_BeamSet_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_BeamSet_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BeamSet_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::SetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIdentifier.");
        if (wrapperTable->m_BeamSet_SetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetIdentifier(instanceHandle, sIdentifier.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededIdentifier = 0;
        unsigned int bytesWrittenIdentifier = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentifier.");
        if (wrapperTable->m_BeamSet_GetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BeamSet_GetIdentifier(instanceHandle, 0, &bytesNeededIdentifier, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferIdentifier;
        bufferIdentifier.resize(bytesNeededIdentifier);
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetIdentifier(instanceHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferIdentifier[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetReferenceCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetReferenceCount.");
        if (wrapperTable->m_BeamSet_GetReferenceCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetReferenceCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetReferenceCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::SetReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetReferences.");
        if (wrapperTable->m_BeamSet_SetReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetReferences(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetReferences.");
        if (wrapperTable->m_BeamSet_GetReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetReferences(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetBallReferenceCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallReferenceCount.");
        if (wrapperTable->m_BeamSet_GetBallReferenceCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetBallReferenceCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetBallReferenceCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::SetBallReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBallReferences.");
        if (wrapperTable->m_BeamSet_SetBallReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetBallReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetBallReferences(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetBallReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallReferences.");
        if (wrapperTable->m_BeamSet_GetBallReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetBallReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetBallReferences(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroup Implementation
**************************************************************************************************************************/

CLib3MFBaseMaterialGroup::CLib3MFBaseMaterialGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFBaseMaterialGroup::~CLib3MFBaseMaterialGroup()
{
}

void CLib3MFBaseMaterialGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBaseMaterialGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMaterial", AddMaterial);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMaterial", RemoveMaterial);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDisplayColor", SetDisplayColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDisplayColor", GetDisplayColor);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBaseMaterialGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBaseMaterialGroup * basematerialgroupInstance = new CLib3MFBaseMaterialGroup();
				basematerialgroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBaseMaterialGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBaseMaterialGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBaseMaterialGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_BaseMaterialGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::AddMaterial(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (DisplayColor)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFColor sDisplayColor = convertObjectToLib3MFColor(isolate, args[1]);
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMaterial.");
        if (wrapperTable->m_BaseMaterialGroup_AddMaterial == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::AddMaterial.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_AddMaterial(instanceHandle, sName.c_str(), &sDisplayColor, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::RemoveMaterial(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMaterial.");
        if (wrapperTable->m_BaseMaterialGroup_RemoveMaterial == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::RemoveMaterial.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_RemoveMaterial(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_BaseMaterialGroup_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BaseMaterialGroup_GetName(instanceHandle, nPropertyID, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetName(instanceHandle, nPropertyID, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_BaseMaterialGroup_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_SetName(instanceHandle, nPropertyID, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::SetDisplayColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (TheColor)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDisplayColor.");
        if (wrapperTable->m_BaseMaterialGroup_SetDisplayColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::SetDisplayColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_SetDisplayColor(instanceHandle, nPropertyID, &sTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::GetDisplayColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sReturnTheColor;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDisplayColor.");
        if (wrapperTable->m_BaseMaterialGroup_GetDisplayColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetDisplayColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetDisplayColor(instanceHandle, nPropertyID, &sReturnTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFColorToObject(isolate, sReturnTheColor));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFColorGroup Implementation
**************************************************************************************************************************/

CLib3MFColorGroup::CLib3MFColorGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFColorGroup::~CLib3MFColorGroup()
{
}

void CLib3MFColorGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFColorGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddColor", AddColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveColor", RemoveColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetColor", SetColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetColor", GetColor);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFColorGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFColorGroup * colorgroupInstance = new CLib3MFColorGroup();
				colorgroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFColorGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFColorGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFColorGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_ColorGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_ColorGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::AddColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (TheColor)");
        }
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[0]);
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddColor.");
        if (wrapperTable->m_ColorGroup_AddColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::AddColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_AddColor(instanceHandle, &sTheColor, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::RemoveColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveColor.");
        if (wrapperTable->m_ColorGroup_RemoveColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::RemoveColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_RemoveColor(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::SetColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (TheColor)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetColor.");
        if (wrapperTable->m_ColorGroup_SetColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::SetColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_SetColor(instanceHandle, nPropertyID, &sTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::GetColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sReturnTheColor;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetColor.");
        if (wrapperTable->m_ColorGroup_GetColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::GetColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_GetColor(instanceHandle, nPropertyID, &sReturnTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFColorToObject(isolate, sReturnTheColor));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroup Implementation
**************************************************************************************************************************/

CLib3MFTexture2DGroup::CLib3MFTexture2DGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2DGroup::~CLib3MFTexture2DGroup()
{
}

void CLib3MFTexture2DGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2DGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTex2Coord", AddTex2Coord);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTex2Coord", GetTex2Coord);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveTex2Coord", RemoveTex2Coord);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTexture2D", GetTexture2D);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2DGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2DGroup * texture2dgroupInstance = new CLib3MFTexture2DGroup();
				texture2dgroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2DGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2DGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2DGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_Texture2DGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_Texture2DGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::AddTex2Coord(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (UVCoordinate)");
        }
        sLib3MFTex2Coord sUVCoordinate = convertObjectToLib3MFTex2Coord(isolate, args[0]);
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTex2Coord.");
        if (wrapperTable->m_Texture2DGroup_AddTex2Coord == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::AddTex2Coord.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_AddTex2Coord(instanceHandle, &sUVCoordinate, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::GetTex2Coord(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTex2Coord sReturnUVCoordinate;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTex2Coord.");
        if (wrapperTable->m_Texture2DGroup_GetTex2Coord == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetTex2Coord.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetTex2Coord(instanceHandle, nPropertyID, &sReturnUVCoordinate);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTex2CoordToObject(isolate, sReturnUVCoordinate));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::RemoveTex2Coord(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveTex2Coord.");
        if (wrapperTable->m_Texture2DGroup_RemoveTex2Coord == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::RemoveTex2Coord.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_RemoveTex2Coord(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::GetTexture2D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTexture2DInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTexture2D.");
        if (wrapperTable->m_Texture2DGroup_GetTexture2D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetTexture2D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetTexture2D(instanceHandle, &hReturnTexture2DInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTexture2DInstance = CLib3MFTexture2D::NewInstance(args.Holder(), hReturnTexture2DInstance);
        args.GetReturnValue().Set(instanceObjTexture2DInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterials Implementation
**************************************************************************************************************************/

CLib3MFCompositeMaterials::CLib3MFCompositeMaterials()
		: CLib3MFBaseClass()
{
}

CLib3MFCompositeMaterials::~CLib3MFCompositeMaterials()
{
}

void CLib3MFCompositeMaterials::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCompositeMaterials"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBaseMaterialGroup", GetBaseMaterialGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComposite", AddComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveComposite", RemoveComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComposite", GetComposite);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCompositeMaterials::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCompositeMaterials * compositematerialsInstance = new CLib3MFCompositeMaterials();
				compositematerialsInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCompositeMaterials: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCompositeMaterials::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFCompositeMaterials::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_CompositeMaterials_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_CompositeMaterials_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::GetBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBaseMaterialGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBaseMaterialGroup.");
        if (wrapperTable->m_CompositeMaterials_GetBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetBaseMaterialGroup(instanceHandle, &hReturnBaseMaterialGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBaseMaterialGroupInstance = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnBaseMaterialGroupInstance);
        args.GetReturnValue().Set(instanceObjBaseMaterialGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::AddComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComposite.");
        if (wrapperTable->m_CompositeMaterials_AddComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::AddComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_AddComposite(instanceHandle, 0, nullptr, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::RemoveComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveComposite.");
        if (wrapperTable->m_CompositeMaterials_RemoveComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::RemoveComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_RemoveComposite(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::GetComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComposite.");
        if (wrapperTable->m_CompositeMaterials_GetComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetComposite(instanceHandle, nPropertyID, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroup Implementation
**************************************************************************************************************************/

CLib3MFMultiPropertyGroup::CLib3MFMultiPropertyGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFMultiPropertyGroup::~CLib3MFMultiPropertyGroup()
{
}

void CLib3MFMultiPropertyGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMultiPropertyGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMultiProperty", AddMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMultiProperty", SetMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMultiProperty", GetMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMultiProperty", RemoveMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLayerCount", GetLayerCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLayer", AddLayer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLayer", GetLayer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveLayer", RemoveLayer);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMultiPropertyGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMultiPropertyGroup * multipropertygroupInstance = new CLib3MFMultiPropertyGroup();
				multipropertygroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMultiPropertyGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMultiPropertyGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMultiPropertyGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_MultiPropertyGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::AddMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_AddMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::AddMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_AddMultiProperty(instanceHandle, 0, nullptr, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::SetMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_SetMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::SetMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_SetMultiProperty(instanceHandle, nPropertyID, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_GetMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetMultiProperty(instanceHandle, nPropertyID, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::RemoveMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_RemoveMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::RemoveMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_RemoveMultiProperty(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetLayerCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLayerCount.");
        if (wrapperTable->m_MultiPropertyGroup_GetLayerCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetLayerCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetLayerCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::AddLayer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (TheLayer)");
        }
        sLib3MFMultiPropertyLayer sTheLayer = convertObjectToLib3MFMultiPropertyLayer(isolate, args[0]);
        unsigned int nReturnLayerIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLayer.");
        if (wrapperTable->m_MultiPropertyGroup_AddLayer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::AddLayer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_AddLayer(instanceHandle, &sTheLayer, &nReturnLayerIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnLayerIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetLayer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (LayerIndex)");
        }
        unsigned int nLayerIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFMultiPropertyLayer sReturnTheLayer;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLayer.");
        if (wrapperTable->m_MultiPropertyGroup_GetLayer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetLayer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetLayer(instanceHandle, nLayerIndex, &sReturnTheLayer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFMultiPropertyLayerToObject(isolate, sReturnTheLayer));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::RemoveLayer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (LayerIndex)");
        }
        unsigned int nLayerIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveLayer.");
        if (wrapperTable->m_MultiPropertyGroup_RemoveLayer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::RemoveLayer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_RemoveLayer(instanceHandle, nLayerIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFAttachment Implementation
**************************************************************************************************************************/

CLib3MFAttachment::CLib3MFAttachment()
		: CLib3MFBaseClass()
{
}

CLib3MFAttachment::~CLib3MFAttachment()
{
}

void CLib3MFAttachment::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFAttachment"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPath", GetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPath", SetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "PackagePart", PackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetRelationShipType", GetRelationShipType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetRelationShipType", SetRelationShipType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToFile", WriteToFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromFile", ReadFromFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromCallback", ReadFromCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStreamSize", GetStreamSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToBuffer", WriteToBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromBuffer", ReadFromBuffer);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFAttachment::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFAttachment * attachmentInstance = new CLib3MFAttachment();
				attachmentInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFAttachment: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFAttachment::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFAttachment::GetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPath.");
        if (wrapperTable->m_Attachment_GetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::GetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Attachment_GetPath(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_Attachment_GetPath(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::SetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPath.");
        if (wrapperTable->m_Attachment_SetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::SetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_SetPath(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::PackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPackagePart = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method PackagePart.");
        if (wrapperTable->m_Attachment_PackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::PackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_PackagePart(instanceHandle, &hReturnPackagePart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPackagePart = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnPackagePart);
        args.GetReturnValue().Set(instanceObjPackagePart);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::GetRelationShipType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetRelationShipType.");
        if (wrapperTable->m_Attachment_GetRelationShipType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::GetRelationShipType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Attachment_GetRelationShipType(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_Attachment_GetRelationShipType(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::SetRelationShipType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetRelationShipType.");
        if (wrapperTable->m_Attachment_SetRelationShipType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::SetRelationShipType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_SetRelationShipType(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::WriteToFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (FileName)");
        }
        v8::String::Utf8Value sutf8FileName(isolate, args[0]);
        std::string sFileName = *sutf8FileName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToFile.");
        if (wrapperTable->m_Attachment_WriteToFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::WriteToFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_WriteToFile(instanceHandle, sFileName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::ReadFromFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (FileName)");
        }
        v8::String::Utf8Value sutf8FileName(isolate, args[0]);
        std::string sFileName = *sutf8FileName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromFile.");
        if (wrapperTable->m_Attachment_ReadFromFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::ReadFromFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_ReadFromFile(instanceHandle, sFileName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::ReadFromCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 1 (StreamSize)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 3 (UserData)");
        }
        v8::String::Utf8Value sutf8StreamSize(isolate, args[1]);
        std::string sStreamSize = *sutf8StreamSize;
        uint64_t nStreamSize = stoull(sStreamSize);
        v8::String::Utf8Value sutf8UserData(isolate, args[3]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromCallback.");
        if (wrapperTable->m_Attachment_ReadFromCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::ReadFromCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_ReadFromCallback(instanceHandle, nullptr, nStreamSize, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::GetStreamSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnStreamSize = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStreamSize.");
        if (wrapperTable->m_Attachment_GetStreamSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::GetStreamSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_GetStreamSize(instanceHandle, &nReturnStreamSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnStreamSize).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::WriteToBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToBuffer.");
        if (wrapperTable->m_Attachment_WriteToBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::WriteToBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_WriteToBuffer(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::ReadFromBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromBuffer.");
        if (wrapperTable->m_Attachment_ReadFromBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::ReadFromBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_ReadFromBuffer(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2D Implementation
**************************************************************************************************************************/

CLib3MFTexture2D::CLib3MFTexture2D()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2D::~CLib3MFTexture2D()
{
}

void CLib3MFTexture2D::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2D"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAttachment", GetAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAttachment", SetAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetContentType", GetContentType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetContentType", SetContentType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTileStyleUV", GetTileStyleUV);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTileStyleUV", SetTileStyleUV);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFilter", GetFilter);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFilter", SetFilter);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2D::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2D * texture2dInstance = new CLib3MFTexture2D();
				texture2dInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2D: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2D::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2D::GetAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnAttachment = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAttachment.");
        if (wrapperTable->m_Texture2D_GetAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetAttachment(instanceHandle, &hReturnAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachment = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachment);
        args.GetReturnValue().Set(instanceObjAttachment);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Attachment)");
        }
        Local<Object> objAttachment = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceAttachment = ObjectWrap::Unwrap<CLib3MFAttachment>(objAttachment);
        if (instanceAttachment == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Attachment)");
        Lib3MFHandle hAttachment = instanceAttachment->getHandle( objAttachment );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAttachment.");
        if (wrapperTable->m_Texture2D_SetAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetAttachment(instanceHandle, hAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::GetContentType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFTextureType eReturnContentType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetContentType.");
        if (wrapperTable->m_Texture2D_GetContentType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetContentType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetContentType(instanceHandle, &eReturnContentType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnContentType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetContentType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ContentType)");
        }
        unsigned int eContentType = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetContentType.");
        if (wrapperTable->m_Texture2D_SetContentType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetContentType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetContentType(instanceHandle, (eLib3MFTextureType) eContentType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::GetTileStyleUV(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFTextureTileStyle eReturnTileStyleU;
        eLib3MFTextureTileStyle eReturnTileStyleV;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTileStyleUV.");
        if (wrapperTable->m_Texture2D_GetTileStyleUV == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetTileStyleUV.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetTileStyleUV(instanceHandle, &eReturnTileStyleU, &eReturnTileStyleV);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleU"), Integer::New(isolate, (int)eReturnTileStyleU));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleV"), Integer::New(isolate, (int)eReturnTileStyleV));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetTileStyleUV(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (TileStyleU)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (TileStyleV)");
        }
        unsigned int eTileStyleU = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eTileStyleV = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTileStyleUV.");
        if (wrapperTable->m_Texture2D_SetTileStyleUV == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetTileStyleUV.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetTileStyleUV(instanceHandle, (eLib3MFTextureTileStyle) eTileStyleU, (eLib3MFTextureTileStyle) eTileStyleV);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::GetFilter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFTextureFilter eReturnFilter;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFilter.");
        if (wrapperTable->m_Texture2D_GetFilter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetFilter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetFilter(instanceHandle, &eReturnFilter);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnFilter));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetFilter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (Filter)");
        }
        unsigned int eFilter = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFilter.");
        if (wrapperTable->m_Texture2D_SetFilter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetFilter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetFilter(instanceHandle, (eLib3MFTextureFilter) eFilter);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBuildItem Implementation
**************************************************************************************************************************/

CLib3MFBuildItem::CLib3MFBuildItem()
		: CLib3MFBaseClass()
{
}

CLib3MFBuildItem::~CLib3MFBuildItem()
{
}

void CLib3MFBuildItem::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBuildItem"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResource", GetObjectResource);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResourceID", GetObjectResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasObjectTransform", HasObjectTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectTransform", GetObjectTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetObjectTransform", SetObjectTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPartNumber", GetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPartNumber", SetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataGroup", GetMetaDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutbox", GetOutbox);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBuildItem::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBuildItem * builditemInstance = new CLib3MFBuildItem();
				builditemInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBuildItem: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBuildItem::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBuildItem::GetObjectResource(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnObjectResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResource.");
        if (wrapperTable->m_BuildItem_GetObjectResource == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetObjectResource.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetObjectResource(instanceHandle, &hReturnObjectResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjObjectResource = CLib3MFObject::NewInstance(args.Holder(), hReturnObjectResource);
        args.GetReturnValue().Set(instanceObjObjectResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_BuildItem_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BuildItem_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_BuildItem_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetObjectResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResourceID.");
        if (wrapperTable->m_BuildItem_GetObjectResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetObjectResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetObjectResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::HasObjectTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasTransform = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasObjectTransform.");
        if (wrapperTable->m_BuildItem_HasObjectTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::HasObjectTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_HasObjectTransform(instanceHandle, &bReturnHasTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetObjectTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectTransform.");
        if (wrapperTable->m_BuildItem_GetObjectTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetObjectTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetObjectTransform(instanceHandle, &sReturnTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::SetObjectTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetObjectTransform.");
        if (wrapperTable->m_BuildItem_SetObjectTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::SetObjectTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_SetObjectTransform(instanceHandle, &sTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPartNumber = 0;
        unsigned int bytesWrittenPartNumber = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPartNumber.");
        if (wrapperTable->m_BuildItem_GetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BuildItem_GetPartNumber(instanceHandle, 0, &bytesNeededPartNumber, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPartNumber;
        bufferPartNumber.resize(bytesNeededPartNumber);
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetPartNumber(instanceHandle, bytesNeededPartNumber, &bytesWrittenPartNumber, &bufferPartNumber[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPartNumber[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::SetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (SetPartnumber)");
        }
        v8::String::Utf8Value sutf8SetPartnumber(isolate, args[0]);
        std::string sSetPartnumber = *sutf8SetPartnumber;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPartNumber.");
        if (wrapperTable->m_BuildItem_SetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::SetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_SetPartNumber(instanceHandle, sSetPartnumber.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetMetaDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMetaDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataGroup.");
        if (wrapperTable->m_BuildItem_GetMetaDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetMetaDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetMetaDataGroup(instanceHandle, &hReturnMetaDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaDataGroup = CLib3MFMetaDataGroup::NewInstance(args.Holder(), hReturnMetaDataGroup);
        args.GetReturnValue().Set(instanceObjMetaDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetOutbox(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFBox sReturnOutbox;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutbox.");
        if (wrapperTable->m_BuildItem_GetOutbox == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetOutbox.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetOutbox(instanceHandle, &sReturnOutbox);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBoxToObject(isolate, sReturnOutbox));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBuildItemIterator Implementation
**************************************************************************************************************************/

CLib3MFBuildItemIterator::CLib3MFBuildItemIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFBuildItemIterator::~CLib3MFBuildItemIterator()
{
}

void CLib3MFBuildItemIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBuildItemIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "MoveNext", MoveNext);
		NODE_SET_PROTOTYPE_METHOD(tpl, "MovePrevious", MovePrevious);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrent", GetCurrent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Clone", Clone);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Count", Count);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBuildItemIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBuildItemIterator * builditemiteratorInstance = new CLib3MFBuildItemIterator();
				builditemiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBuildItemIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBuildItemIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBuildItemIterator::MoveNext(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasNext = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MoveNext.");
        if (wrapperTable->m_BuildItemIterator_MoveNext == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::MoveNext.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_MoveNext(instanceHandle, &bReturnHasNext);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasNext));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::MovePrevious(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasPrevious = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MovePrevious.");
        if (wrapperTable->m_BuildItemIterator_MovePrevious == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::MovePrevious.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_MovePrevious(instanceHandle, &bReturnHasPrevious);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasPrevious));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::GetCurrent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBuildItem = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrent.");
        if (wrapperTable->m_BuildItemIterator_GetCurrent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::GetCurrent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_GetCurrent(instanceHandle, &hReturnBuildItem);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBuildItem = CLib3MFBuildItem::NewInstance(args.Holder(), hReturnBuildItem);
        args.GetReturnValue().Set(instanceObjBuildItem);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::Clone(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnOutBuildItemIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Clone.");
        if (wrapperTable->m_BuildItemIterator_Clone == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::Clone.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_Clone(instanceHandle, &hReturnOutBuildItemIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjOutBuildItemIterator = CLib3MFBuildItemIterator::NewInstance(args.Holder(), hReturnOutBuildItemIterator);
        args.GetReturnValue().Set(instanceObjOutBuildItemIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::Count(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Count.");
        if (wrapperTable->m_BuildItemIterator_Count == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::Count.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_Count(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSlice Implementation
**************************************************************************************************************************/

CLib3MFSlice::CLib3MFSlice()
		: CLib3MFBaseClass()
{
}

CLib3MFSlice::~CLib3MFSlice()
{
}

void CLib3MFSlice::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSlice"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVertices", SetVertices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertices", GetVertices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertexCount", GetVertexCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddPolygon", AddPolygon);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPolygonCount", GetPolygonCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPolygonIndices", SetPolygonIndices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPolygonIndices", GetPolygonIndices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPolygonIndexCount", GetPolygonIndexCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetZTop", GetZTop);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSlice::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSlice * sliceInstance = new CLib3MFSlice();
				sliceInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSlice: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSlice::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSlice::SetVertices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVertices.");
        if (wrapperTable->m_Slice_SetVertices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::SetVertices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_SetVertices(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetVertices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertices.");
        if (wrapperTable->m_Slice_GetVertices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetVertices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetVertices(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetVertexCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertexCount.");
        if (wrapperTable->m_Slice_GetVertexCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetVertexCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetVertexCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::AddPolygon(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddPolygon.");
        if (wrapperTable->m_Slice_AddPolygon == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::AddPolygon.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_AddPolygon(instanceHandle, 0, nullptr, &nReturnIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnIndex).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetPolygonCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPolygonCount.");
        if (wrapperTable->m_Slice_GetPolygonCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetPolygonCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetPolygonCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::SetPolygonIndices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (Index)");
        }
        v8::String::Utf8Value sutf8Index(isolate, args[0]);
        std::string sIndex = *sutf8Index;
        uint64_t nIndex = stoull(sIndex);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPolygonIndices.");
        if (wrapperTable->m_Slice_SetPolygonIndices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::SetPolygonIndices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_SetPolygonIndices(instanceHandle, nIndex, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetPolygonIndices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (Index)");
        }
        v8::String::Utf8Value sutf8Index(isolate, args[0]);
        std::string sIndex = *sutf8Index;
        uint64_t nIndex = stoull(sIndex);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPolygonIndices.");
        if (wrapperTable->m_Slice_GetPolygonIndices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetPolygonIndices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetPolygonIndices(instanceHandle, nIndex, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetPolygonIndexCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (Index)");
        }
        v8::String::Utf8Value sutf8Index(isolate, args[0]);
        std::string sIndex = *sutf8Index;
        uint64_t nIndex = stoull(sIndex);
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPolygonIndexCount.");
        if (wrapperTable->m_Slice_GetPolygonIndexCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetPolygonIndexCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetPolygonIndexCount(instanceHandle, nIndex, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetZTop(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnZTop = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetZTop.");
        if (wrapperTable->m_Slice_GetZTop == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetZTop.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetZTop(instanceHandle, &dReturnZTop);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnZTop));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSliceStack Implementation
**************************************************************************************************************************/

CLib3MFSliceStack::CLib3MFSliceStack()
		: CLib3MFBaseClass()
{
}

CLib3MFSliceStack::~CLib3MFSliceStack()
{
}

void CLib3MFSliceStack::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSliceStack"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBottomZ", GetBottomZ);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceCount", GetSliceCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSlice", GetSlice);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSlice", AddSlice);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceRefCount", GetSliceRefCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSliceStackReference", AddSliceStackReference);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceStackReference", GetSliceStackReference);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CollapseSliceReferences", CollapseSliceReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetOwnPath", SetOwnPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOwnPath", GetOwnPath);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSliceStack::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSliceStack * slicestackInstance = new CLib3MFSliceStack();
				slicestackInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSliceStack: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSliceStack::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSliceStack::GetBottomZ(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnZBottom = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBottomZ.");
        if (wrapperTable->m_SliceStack_GetBottomZ == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetBottomZ.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetBottomZ(instanceHandle, &dReturnZBottom);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnZBottom));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSliceCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceCount.");
        if (wrapperTable->m_SliceStack_GetSliceCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSliceCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSliceCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSlice(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (SliceIndex)");
        }
        v8::String::Utf8Value sutf8SliceIndex(isolate, args[0]);
        std::string sSliceIndex = *sutf8SliceIndex;
        uint64_t nSliceIndex = stoull(sSliceIndex);
        Lib3MFHandle hReturnTheSlice = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSlice.");
        if (wrapperTable->m_SliceStack_GetSlice == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSlice.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSlice(instanceHandle, nSliceIndex, &hReturnTheSlice);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheSlice = CLib3MFSlice::NewInstance(args.Holder(), hReturnTheSlice);
        args.GetReturnValue().Set(instanceObjTheSlice);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::AddSlice(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (ZTop)");
        }
        double dZTop = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheSlice = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSlice.");
        if (wrapperTable->m_SliceStack_AddSlice == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::AddSlice.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_AddSlice(instanceHandle, dZTop, &hReturnTheSlice);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheSlice = CLib3MFSlice::NewInstance(args.Holder(), hReturnTheSlice);
        args.GetReturnValue().Set(instanceObjTheSlice);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSliceRefCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceRefCount.");
        if (wrapperTable->m_SliceStack_GetSliceRefCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSliceRefCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSliceRefCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::AddSliceStackReference(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheSliceStack)");
        }
        Local<Object> objTheSliceStack = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFSliceStack * instanceTheSliceStack = ObjectWrap::Unwrap<CLib3MFSliceStack>(objTheSliceStack);
        if (instanceTheSliceStack == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheSliceStack)");
        Lib3MFHandle hTheSliceStack = instanceTheSliceStack->getHandle( objTheSliceStack );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSliceStackReference.");
        if (wrapperTable->m_SliceStack_AddSliceStackReference == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::AddSliceStackReference.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_AddSliceStackReference(instanceHandle, hTheSliceStack);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSliceStackReference(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (SliceRefIndex)");
        }
        v8::String::Utf8Value sutf8SliceRefIndex(isolate, args[0]);
        std::string sSliceRefIndex = *sutf8SliceRefIndex;
        uint64_t nSliceRefIndex = stoull(sSliceRefIndex);
        Lib3MFHandle hReturnTheSliceStack = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceStackReference.");
        if (wrapperTable->m_SliceStack_GetSliceStackReference == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSliceStackReference.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSliceStackReference(instanceHandle, nSliceRefIndex, &hReturnTheSliceStack);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheSliceStack = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnTheSliceStack);
        args.GetReturnValue().Set(instanceObjTheSliceStack);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::CollapseSliceReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CollapseSliceReferences.");
        if (wrapperTable->m_SliceStack_CollapseSliceReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::CollapseSliceReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_CollapseSliceReferences(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::SetOwnPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetOwnPath.");
        if (wrapperTable->m_SliceStack_SetOwnPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::SetOwnPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_SetOwnPath(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetOwnPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOwnPath.");
        if (wrapperTable->m_SliceStack_GetOwnPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetOwnPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_SliceStack_GetOwnPath(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetOwnPath(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFConsumer Implementation
**************************************************************************************************************************/

CLib3MFConsumer::CLib3MFConsumer()
		: CLib3MFBaseClass()
{
}

CLib3MFConsumer::~CLib3MFConsumer()
{
}

void CLib3MFConsumer::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFConsumer"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumerID", GetConsumerID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyID", GetKeyID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyValue", GetKeyValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFConsumer::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFConsumer * consumerInstance = new CLib3MFConsumer();
				consumerInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFConsumer: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFConsumer::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFConsumer::GetConsumerID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededConsumerID = 0;
        unsigned int bytesWrittenConsumerID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumerID.");
        if (wrapperTable->m_Consumer_GetConsumerID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Consumer::GetConsumerID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Consumer_GetConsumerID(instanceHandle, 0, &bytesNeededConsumerID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferConsumerID;
        bufferConsumerID.resize(bytesNeededConsumerID);
        Lib3MFResult errorCode = wrapperTable->m_Consumer_GetConsumerID(instanceHandle, bytesNeededConsumerID, &bytesWrittenConsumerID, &bufferConsumerID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferConsumerID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConsumer::GetKeyID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededKeyID = 0;
        unsigned int bytesWrittenKeyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyID.");
        if (wrapperTable->m_Consumer_GetKeyID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Consumer::GetKeyID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Consumer_GetKeyID(instanceHandle, 0, &bytesNeededKeyID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferKeyID;
        bufferKeyID.resize(bytesNeededKeyID);
        Lib3MFResult errorCode = wrapperTable->m_Consumer_GetKeyID(instanceHandle, bytesNeededKeyID, &bytesWrittenKeyID, &bufferKeyID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferKeyID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConsumer::GetKeyValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededKeyValue = 0;
        unsigned int bytesWrittenKeyValue = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyValue.");
        if (wrapperTable->m_Consumer_GetKeyValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Consumer::GetKeyValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Consumer_GetKeyValue(instanceHandle, 0, &bytesNeededKeyValue, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferKeyValue;
        bufferKeyValue.resize(bytesNeededKeyValue);
        Lib3MFResult errorCode = wrapperTable->m_Consumer_GetKeyValue(instanceHandle, bytesNeededKeyValue, &bytesWrittenKeyValue, &bufferKeyValue[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferKeyValue[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFAccessRight Implementation
**************************************************************************************************************************/

CLib3MFAccessRight::CLib3MFAccessRight()
		: CLib3MFBaseClass()
{
}

CLib3MFAccessRight::~CLib3MFAccessRight()
{
}

void CLib3MFAccessRight::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFAccessRight"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumer", GetConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWrappingAlgorithm", GetWrappingAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMgfAlgorithm", GetMgfAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDigestMethod", GetDigestMethod);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFAccessRight::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFAccessRight * accessrightInstance = new CLib3MFAccessRight();
				accessrightInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFAccessRight: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFAccessRight::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFAccessRight::GetConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumer.");
        if (wrapperTable->m_AccessRight_GetConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetConsumer(instanceHandle, &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAccessRight::GetWrappingAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFWrappingAlgorithm eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWrappingAlgorithm.");
        if (wrapperTable->m_AccessRight_GetWrappingAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetWrappingAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetWrappingAlgorithm(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAccessRight::GetMgfAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFMgfAlgorithm eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMgfAlgorithm.");
        if (wrapperTable->m_AccessRight_GetMgfAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetMgfAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetMgfAlgorithm(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAccessRight::GetDigestMethod(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFDigestMethod eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDigestMethod.");
        if (wrapperTable->m_AccessRight_GetDigestMethod == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetDigestMethod.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetDigestMethod(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFContentEncryptionParams Implementation
**************************************************************************************************************************/

CLib3MFContentEncryptionParams::CLib3MFContentEncryptionParams()
		: CLib3MFBaseClass()
{
}

CLib3MFContentEncryptionParams::~CLib3MFContentEncryptionParams()
{
}

void CLib3MFContentEncryptionParams::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFContentEncryptionParams"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetEncryptionAlgorithm", GetEncryptionAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKey", GetKey);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInitializationVector", GetInitializationVector);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAuthenticationTag", GetAuthenticationTag);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAuthenticationTag", SetAuthenticationTag);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAdditionalAuthenticationData", GetAdditionalAuthenticationData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDescriptor", GetDescriptor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyUUID", GetKeyUUID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFContentEncryptionParams::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFContentEncryptionParams * contentencryptionparamsInstance = new CLib3MFContentEncryptionParams();
				contentencryptionparamsInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFContentEncryptionParams: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFContentEncryptionParams::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFContentEncryptionParams::GetEncryptionAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFEncryptionAlgorithm eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetEncryptionAlgorithm.");
        if (wrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetEncryptionAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetKey(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKey.");
        if (wrapperTable->m_ContentEncryptionParams_GetKey == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetKey.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetKey(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetInitializationVector(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInitializationVector.");
        if (wrapperTable->m_ContentEncryptionParams_GetInitializationVector == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetInitializationVector.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetInitializationVector(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetAuthenticationTag(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAuthenticationTag.");
        if (wrapperTable->m_ContentEncryptionParams_GetAuthenticationTag == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetAuthenticationTag.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetAuthenticationTag(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::SetAuthenticationTag(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAuthenticationTag.");
        if (wrapperTable->m_ContentEncryptionParams_SetAuthenticationTag == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::SetAuthenticationTag.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_SetAuthenticationTag(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetAdditionalAuthenticationData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAdditionalAuthenticationData.");
        if (wrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetAdditionalAuthenticationData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetDescriptor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnDescriptor = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDescriptor.");
        if (wrapperTable->m_ContentEncryptionParams_GetDescriptor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetDescriptor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetDescriptor(instanceHandle, &nReturnDescriptor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnDescriptor).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetKeyUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyUUID.");
        if (wrapperTable->m_ContentEncryptionParams_GetKeyUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetKeyUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ContentEncryptionParams_GetKeyUUID(instanceHandle, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetKeyUUID(instanceHandle, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferUUID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResourceData Implementation
**************************************************************************************************************************/

CLib3MFResourceData::CLib3MFResourceData()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceData::~CLib3MFResourceData()
{
}

void CLib3MFResourceData::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceData"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPath", GetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetEncryptionAlgorithm", GetEncryptionAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCompression", GetCompression);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAdditionalAuthenticationData", GetAdditionalAuthenticationData);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceData::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceData * resourcedataInstance = new CLib3MFResourceData();
				resourcedataInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceData: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceData::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceData::GetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPath = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPath.");
        if (wrapperTable->m_ResourceData_GetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetPath(instanceHandle, &hReturnPath);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPath = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnPath);
        args.GetReturnValue().Set(instanceObjPath);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceData::GetEncryptionAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFEncryptionAlgorithm eReturnEncryptionAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetEncryptionAlgorithm.");
        if (wrapperTable->m_ResourceData_GetEncryptionAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetEncryptionAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetEncryptionAlgorithm(instanceHandle, &eReturnEncryptionAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnEncryptionAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceData::GetCompression(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFCompression eReturnCompression;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCompression.");
        if (wrapperTable->m_ResourceData_GetCompression == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetCompression.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetCompression(instanceHandle, &eReturnCompression);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnCompression));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceData::GetAdditionalAuthenticationData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAdditionalAuthenticationData.");
        if (wrapperTable->m_ResourceData_GetAdditionalAuthenticationData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetAdditionalAuthenticationData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetAdditionalAuthenticationData(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResourceDataGroup Implementation
**************************************************************************************************************************/

CLib3MFResourceDataGroup::CLib3MFResourceDataGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceDataGroup::~CLib3MFResourceDataGroup()
{
}

void CLib3MFResourceDataGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceDataGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyUUID", GetKeyUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddAccessRight", AddAccessRight);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindAccessRightByConsumer", FindAccessRightByConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveAccessRight", RemoveAccessRight);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceDataGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceDataGroup * resourcedatagroupInstance = new CLib3MFResourceDataGroup();
				resourcedatagroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceDataGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceDataGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceDataGroup::GetKeyUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyUUID.");
        if (wrapperTable->m_ResourceDataGroup_GetKeyUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::GetKeyUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ResourceDataGroup_GetKeyUUID(instanceHandle, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_GetKeyUUID(instanceHandle, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferUUID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceDataGroup::AddAccessRight(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (WrappingAlgorithm)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (MgfAlgorithm)");
        }
        if (!args[3]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 3 (DigestMethod)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        unsigned int eWrappingAlgorithm = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eMgfAlgorithm = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eDigestMethod = (unsigned int) args[3]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheAccessRight = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddAccessRight.");
        if (wrapperTable->m_ResourceDataGroup_AddAccessRight == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::AddAccessRight.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_AddAccessRight(instanceHandle, hConsumer, (eLib3MFWrappingAlgorithm) eWrappingAlgorithm, (eLib3MFMgfAlgorithm) eMgfAlgorithm, (eLib3MFDigestMethod) eDigestMethod, &hReturnTheAccessRight);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheAccessRight = CLib3MFAccessRight::NewInstance(args.Holder(), hReturnTheAccessRight);
        args.GetReturnValue().Set(instanceObjTheAccessRight);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceDataGroup::FindAccessRightByConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        Lib3MFHandle hReturnTheAccessRight = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindAccessRightByConsumer.");
        if (wrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::FindAccessRightByConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer(instanceHandle, hConsumer, &hReturnTheAccessRight);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheAccessRight = CLib3MFAccessRight::NewInstance(args.Holder(), hReturnTheAccessRight);
        args.GetReturnValue().Set(instanceObjTheAccessRight);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceDataGroup::RemoveAccessRight(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveAccessRight.");
        if (wrapperTable->m_ResourceDataGroup_RemoveAccessRight == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::RemoveAccessRight.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_RemoveAccessRight(instanceHandle, hConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFKeyStore Implementation
**************************************************************************************************************************/

CLib3MFKeyStore::CLib3MFKeyStore()
		: CLib3MFBaseClass()
{
}

CLib3MFKeyStore::~CLib3MFKeyStore()
{
}

void CLib3MFKeyStore::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFKeyStore"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddConsumer", AddConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumerCount", GetConsumerCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumer", GetConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveConsumer", RemoveConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindConsumer", FindConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceDataGroupCount", GetResourceDataGroupCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddResourceDataGroup", AddResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceDataGroup", GetResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveResourceDataGroup", RemoveResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindResourceDataGroup", FindResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddResourceData", AddResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveResourceData", RemoveResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindResourceData", FindResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceDataCount", GetResourceDataCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceData", GetResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFKeyStore::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFKeyStore * keystoreInstance = new CLib3MFKeyStore();
				keystoreInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFKeyStore: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFKeyStore::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFKeyStore::AddConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (KeyID)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (KeyValue)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        v8::String::Utf8Value sutf8KeyID(isolate, args[1]);
        std::string sKeyID = *sutf8KeyID;
        v8::String::Utf8Value sutf8KeyValue(isolate, args[2]);
        std::string sKeyValue = *sutf8KeyValue;
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddConsumer.");
        if (wrapperTable->m_KeyStore_AddConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::AddConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_AddConsumer(instanceHandle, sConsumerID.c_str(), sKeyID.c_str(), sKeyValue.c_str(), &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetConsumerCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumerCount.");
        if (wrapperTable->m_KeyStore_GetConsumerCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetConsumerCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetConsumerCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (ConsumerIndex)");
        }
        v8::String::Utf8Value sutf8ConsumerIndex(isolate, args[0]);
        std::string sConsumerIndex = *sutf8ConsumerIndex;
        uint64_t nConsumerIndex = stoull(sConsumerIndex);
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumer.");
        if (wrapperTable->m_KeyStore_GetConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetConsumer(instanceHandle, nConsumerIndex, &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::RemoveConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveConsumer.");
        if (wrapperTable->m_KeyStore_RemoveConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::RemoveConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_RemoveConsumer(instanceHandle, hConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::FindConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindConsumer.");
        if (wrapperTable->m_KeyStore_FindConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::FindConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_FindConsumer(instanceHandle, sConsumerID.c_str(), &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetResourceDataGroupCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceDataGroupCount.");
        if (wrapperTable->m_KeyStore_GetResourceDataGroupCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetResourceDataGroupCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetResourceDataGroupCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::AddResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddResourceDataGroup.");
        if (wrapperTable->m_KeyStore_AddResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::AddResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_AddResourceDataGroup(instanceHandle, &hReturnResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceDataGroup = CLib3MFResourceDataGroup::NewInstance(args.Holder(), hReturnResourceDataGroup);
        args.GetReturnValue().Set(instanceObjResourceDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (ResourceDataIndex)");
        }
        v8::String::Utf8Value sutf8ResourceDataIndex(isolate, args[0]);
        std::string sResourceDataIndex = *sutf8ResourceDataIndex;
        uint64_t nResourceDataIndex = stoull(sResourceDataIndex);
        Lib3MFHandle hReturnResourceDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceDataGroup.");
        if (wrapperTable->m_KeyStore_GetResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetResourceDataGroup(instanceHandle, nResourceDataIndex, &hReturnResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceDataGroup = CLib3MFResourceDataGroup::NewInstance(args.Holder(), hReturnResourceDataGroup);
        args.GetReturnValue().Set(instanceObjResourceDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::RemoveResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourceDataGroup)");
        }
        Local<Object> objResourceDataGroup = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResourceDataGroup * instanceResourceDataGroup = ObjectWrap::Unwrap<CLib3MFResourceDataGroup>(objResourceDataGroup);
        if (instanceResourceDataGroup == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourceDataGroup)");
        Lib3MFHandle hResourceDataGroup = instanceResourceDataGroup->getHandle( objResourceDataGroup );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveResourceDataGroup.");
        if (wrapperTable->m_KeyStore_RemoveResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::RemoveResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_RemoveResourceDataGroup(instanceHandle, hResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::FindResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (PartPath)");
        }
        Local<Object> objPartPath = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instancePartPath = ObjectWrap::Unwrap<CLib3MFPackagePart>(objPartPath);
        if (instancePartPath == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (PartPath)");
        Lib3MFHandle hPartPath = instancePartPath->getHandle( objPartPath );
        Lib3MFHandle hReturnResourceDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindResourceDataGroup.");
        if (wrapperTable->m_KeyStore_FindResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::FindResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_FindResourceDataGroup(instanceHandle, hPartPath, &hReturnResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceDataGroup = CLib3MFResourceDataGroup::NewInstance(args.Holder(), hReturnResourceDataGroup);
        args.GetReturnValue().Set(instanceObjResourceDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::AddResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourceDataGroup)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected class parameter 1 (PartPath)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (Algorithm)");
        }
        if (!args[3]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 3 (Compression)");
        }
        Local<Object> objResourceDataGroup = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResourceDataGroup * instanceResourceDataGroup = ObjectWrap::Unwrap<CLib3MFResourceDataGroup>(objResourceDataGroup);
        if (instanceResourceDataGroup == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourceDataGroup)");
        Lib3MFHandle hResourceDataGroup = instanceResourceDataGroup->getHandle( objResourceDataGroup );
        Local<Object> objPartPath = args[1]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instancePartPath = ObjectWrap::Unwrap<CLib3MFPackagePart>(objPartPath);
        if (instancePartPath == nullptr)
            throw std::runtime_error("Invalid Object parameter 1 (PartPath)");
        Lib3MFHandle hPartPath = instancePartPath->getHandle( objPartPath );
        unsigned int eAlgorithm = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eCompression = (unsigned int) args[3]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnResourceData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddResourceData.");
        if (wrapperTable->m_KeyStore_AddResourceData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::AddResourceData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_AddResourceData(instanceHandle, hResourceDataGroup, hPartPath, (eLib3MFEncryptionAlgorithm) eAlgorithm, (eLib3MFCompression) eCompression, 0, nullptr, &hReturnResourceData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceData = CLib3MFResourceData::NewInstance(args.Holder(), hReturnResourceData);
        args.GetReturnValue().Set(instanceObjResourceData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::RemoveResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourceData)");
        }
        Local<Object> objResourceData = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResourceData * instanceResourceData = ObjectWrap::Unwrap<CLib3MFResourceData>(objResourceData);
        if (instanceResourceData == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourceData)");
        Lib3MFHandle hResourceData = instanceResourceData->getHandle( objResourceData );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveResourceData.");
        if (wrapperTable->m_KeyStore_RemoveResourceData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::RemoveResourceData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_RemoveResourceData(instanceHandle, hResourceData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::FindResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourcePath)");
        }
        Local<Object> objResourcePath = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instanceResourcePath = ObjectWrap::Unwrap<CLib3MFPackagePart>(objResourcePath);
        if (instanceResourcePath == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourcePath)");
        Lib3MFHandle hResourcePath = instanceResourcePath->getHandle( objResourcePath );
        Lib3MFHandle hReturnResourceData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindResourceData.");
        if (wrapperTable->m_KeyStore_FindResourceData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::FindResourceData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_FindResourceData(instanceHandle, hResourcePath, &hReturnResourceData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceData = CLib3MFResourceData::NewInstance(args.Holder(), hReturnResourceData);
        args.GetReturnValue().Set(instanceObjResourceData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetResourceDataCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceDataCount.");
        if (wrapperTable->m_KeyStore_GetResourceDataCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetResourceDataCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetResourceDataCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (ResourceDataIndex)");
        }
        v8::String::Utf8Value sutf8ResourceDataIndex(isolate, args[0]);
        std::string sResourceDataIndex = *sutf8ResourceDataIndex;
        uint64_t nResourceDataIndex = stoull(sResourceDataIndex);
        Lib3MFHandle hReturnResourceData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceData.");
        if (wrapperTable->m_KeyStore_GetResourceData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetResourceData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetResourceData(instanceHandle, nResourceDataIndex, &hReturnResourceData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceData = CLib3MFResourceData::NewInstance(args.Holder(), hReturnResourceData);
        args.GetReturnValue().Set(instanceObjResourceData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_KeyStore_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_KeyStore_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_KeyStore_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFModel Implementation
**************************************************************************************************************************/

CLib3MFModel::CLib3MFModel()
		: CLib3MFBaseClass()
{
}

CLib3MFModel::~CLib3MFModel()
{
}

void CLib3MFModel::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFModel"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "RootModelPart", RootModelPart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindOrCreatePackagePart", FindOrCreatePackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUnit", SetUnit);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUnit", GetUnit);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLanguage", GetLanguage);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetLanguage", SetLanguage);
		NODE_SET_PROTOTYPE_METHOD(tpl, "QueryWriter", QueryWriter);
		NODE_SET_PROTOTYPE_METHOD(tpl, "QueryReader", QueryReader);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceByID", GetResourceByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTexture2DByID", GetTexture2DByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPropertyTypeByID", GetPropertyTypeByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBaseMaterialGroupByID", GetBaseMaterialGroupByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTexture2DGroupByID", GetTexture2DGroupByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCompositeMaterialsByID", GetCompositeMaterialsByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMultiPropertyGroupByID", GetMultiPropertyGroupByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMeshObjectByID", GetMeshObjectByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComponentsObjectByID", GetComponentsObjectByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetColorGroupByID", GetColorGroupByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceStackByID", GetSliceStackByID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBuildUUID", GetBuildUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBuildUUID", SetBuildUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBuildItems", GetBuildItems);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutbox", GetOutbox);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResources", GetResources);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjects", GetObjects);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMeshObjects", GetMeshObjects);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComponentsObjects", GetComponentsObjects);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTexture2Ds", GetTexture2Ds);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBaseMaterialGroups", GetBaseMaterialGroups);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetColorGroups", GetColorGroups);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTexture2DGroups", GetTexture2DGroups);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCompositeMaterials", GetCompositeMaterials);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMultiPropertyGroups", GetMultiPropertyGroups);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceStacks", GetSliceStacks);
		NODE_SET_PROTOTYPE_METHOD(tpl, "MergeToModel", MergeToModel);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMeshObject", AddMeshObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComponentsObject", AddComponentsObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSliceStack", AddSliceStack);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTexture2DFromAttachment", AddTexture2DFromAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBaseMaterialGroup", AddBaseMaterialGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddColorGroup", AddColorGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTexture2DGroup", AddTexture2DGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddCompositeMaterials", AddCompositeMaterials);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMultiPropertyGroup", AddMultiPropertyGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBuildItem", AddBuildItem);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveBuildItem", RemoveBuildItem);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataGroup", GetMetaDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddAttachment", AddAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveAttachment", RemoveAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAttachment", GetAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindAttachment", FindAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAttachmentCount", GetAttachmentCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasPackageThumbnailAttachment", HasPackageThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreatePackageThumbnailAttachment", CreatePackageThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPackageThumbnailAttachment", GetPackageThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemovePackageThumbnailAttachment", RemovePackageThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddCustomContentType", AddCustomContentType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveCustomContentType", RemoveCustomContentType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetRandomNumberCallback", SetRandomNumberCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyStore", GetKeyStore);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFModel::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFModel * modelInstance = new CLib3MFModel();
				modelInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFModel: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFModel::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFModel::RootModelPart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnRootModelPart = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RootModelPart.");
        if (wrapperTable->m_Model_RootModelPart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::RootModelPart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_RootModelPart(instanceHandle, &hReturnRootModelPart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjRootModelPart = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnRootModelPart);
        args.GetReturnValue().Set(instanceObjRootModelPart);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::FindOrCreatePackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (AbsolutePath)");
        }
        v8::String::Utf8Value sutf8AbsolutePath(isolate, args[0]);
        std::string sAbsolutePath = *sutf8AbsolutePath;
        Lib3MFHandle hReturnModelPart = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindOrCreatePackagePart.");
        if (wrapperTable->m_Model_FindOrCreatePackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::FindOrCreatePackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_FindOrCreatePackagePart(instanceHandle, sAbsolutePath.c_str(), &hReturnModelPart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjModelPart = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnModelPart);
        args.GetReturnValue().Set(instanceObjModelPart);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::SetUnit(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (Unit)");
        }
        unsigned int eUnit = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUnit.");
        if (wrapperTable->m_Model_SetUnit == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::SetUnit.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_SetUnit(instanceHandle, (eLib3MFModelUnit) eUnit);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetUnit(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFModelUnit eReturnUnit;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUnit.");
        if (wrapperTable->m_Model_GetUnit == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetUnit.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetUnit(instanceHandle, &eReturnUnit);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnUnit));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetLanguage(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededLanguage = 0;
        unsigned int bytesWrittenLanguage = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLanguage.");
        if (wrapperTable->m_Model_GetLanguage == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetLanguage.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Model_GetLanguage(instanceHandle, 0, &bytesNeededLanguage, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferLanguage;
        bufferLanguage.resize(bytesNeededLanguage);
        Lib3MFResult errorCode = wrapperTable->m_Model_GetLanguage(instanceHandle, bytesNeededLanguage, &bytesWrittenLanguage, &bufferLanguage[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferLanguage[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::SetLanguage(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Language)");
        }
        v8::String::Utf8Value sutf8Language(isolate, args[0]);
        std::string sLanguage = *sutf8Language;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetLanguage.");
        if (wrapperTable->m_Model_SetLanguage == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::SetLanguage.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_SetLanguage(instanceHandle, sLanguage.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::QueryWriter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (WriterClass)");
        }
        v8::String::Utf8Value sutf8WriterClass(isolate, args[0]);
        std::string sWriterClass = *sutf8WriterClass;
        Lib3MFHandle hReturnWriterInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method QueryWriter.");
        if (wrapperTable->m_Model_QueryWriter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::QueryWriter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_QueryWriter(instanceHandle, sWriterClass.c_str(), &hReturnWriterInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjWriterInstance = CLib3MFWriter::NewInstance(args.Holder(), hReturnWriterInstance);
        args.GetReturnValue().Set(instanceObjWriterInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::QueryReader(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ReaderClass)");
        }
        v8::String::Utf8Value sutf8ReaderClass(isolate, args[0]);
        std::string sReaderClass = *sutf8ReaderClass;
        Lib3MFHandle hReturnReaderInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method QueryReader.");
        if (wrapperTable->m_Model_QueryReader == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::QueryReader.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_QueryReader(instanceHandle, sReaderClass.c_str(), &hReturnReaderInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjReaderInstance = CLib3MFReader::NewInstance(args.Holder(), hReturnReaderInstance);
        args.GetReturnValue().Set(instanceObjReaderInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetResourceByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceByID.");
        if (wrapperTable->m_Model_GetResourceByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetResourceByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetResourceByID(instanceHandle, nUniqueResourceID, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFResource::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetTexture2DByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTextureInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTexture2DByID.");
        if (wrapperTable->m_Model_GetTexture2DByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetTexture2DByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetTexture2DByID(instanceHandle, nUniqueResourceID, &hReturnTextureInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTextureInstance = CLib3MFTexture2D::NewInstance(args.Holder(), hReturnTextureInstance);
        args.GetReturnValue().Set(instanceObjTextureInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetPropertyTypeByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        eLib3MFPropertyType eReturnThePropertyType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPropertyTypeByID.");
        if (wrapperTable->m_Model_GetPropertyTypeByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetPropertyTypeByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetPropertyTypeByID(instanceHandle, nUniqueResourceID, &eReturnThePropertyType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnThePropertyType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetBaseMaterialGroupByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnBaseMaterialGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBaseMaterialGroupByID.");
        if (wrapperTable->m_Model_GetBaseMaterialGroupByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetBaseMaterialGroupByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetBaseMaterialGroupByID(instanceHandle, nUniqueResourceID, &hReturnBaseMaterialGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBaseMaterialGroupInstance = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnBaseMaterialGroupInstance);
        args.GetReturnValue().Set(instanceObjBaseMaterialGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetTexture2DGroupByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTexture2DGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTexture2DGroupByID.");
        if (wrapperTable->m_Model_GetTexture2DGroupByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetTexture2DGroupByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetTexture2DGroupByID(instanceHandle, nUniqueResourceID, &hReturnTexture2DGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTexture2DGroupInstance = CLib3MFTexture2DGroup::NewInstance(args.Holder(), hReturnTexture2DGroupInstance);
        args.GetReturnValue().Set(instanceObjTexture2DGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetCompositeMaterialsByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnCompositeMaterialsInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCompositeMaterialsByID.");
        if (wrapperTable->m_Model_GetCompositeMaterialsByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetCompositeMaterialsByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetCompositeMaterialsByID(instanceHandle, nUniqueResourceID, &hReturnCompositeMaterialsInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjCompositeMaterialsInstance = CLib3MFCompositeMaterials::NewInstance(args.Holder(), hReturnCompositeMaterialsInstance);
        args.GetReturnValue().Set(instanceObjCompositeMaterialsInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetMultiPropertyGroupByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnMultiPropertyGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMultiPropertyGroupByID.");
        if (wrapperTable->m_Model_GetMultiPropertyGroupByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetMultiPropertyGroupByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetMultiPropertyGroupByID(instanceHandle, nUniqueResourceID, &hReturnMultiPropertyGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMultiPropertyGroupInstance = CLib3MFMultiPropertyGroup::NewInstance(args.Holder(), hReturnMultiPropertyGroupInstance);
        args.GetReturnValue().Set(instanceObjMultiPropertyGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetMeshObjectByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnMeshObjectInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMeshObjectByID.");
        if (wrapperTable->m_Model_GetMeshObjectByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetMeshObjectByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetMeshObjectByID(instanceHandle, nUniqueResourceID, &hReturnMeshObjectInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMeshObjectInstance = CLib3MFMeshObject::NewInstance(args.Holder(), hReturnMeshObjectInstance);
        args.GetReturnValue().Set(instanceObjMeshObjectInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetComponentsObjectByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnComponentsObjectInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComponentsObjectByID.");
        if (wrapperTable->m_Model_GetComponentsObjectByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetComponentsObjectByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetComponentsObjectByID(instanceHandle, nUniqueResourceID, &hReturnComponentsObjectInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjComponentsObjectInstance = CLib3MFComponentsObject::NewInstance(args.Holder(), hReturnComponentsObjectInstance);
        args.GetReturnValue().Set(instanceObjComponentsObjectInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetColorGroupByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnColorGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetColorGroupByID.");
        if (wrapperTable->m_Model_GetColorGroupByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetColorGroupByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetColorGroupByID(instanceHandle, nUniqueResourceID, &hReturnColorGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjColorGroupInstance = CLib3MFColorGroup::NewInstance(args.Holder(), hReturnColorGroupInstance);
        args.GetReturnValue().Set(instanceObjColorGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetSliceStackByID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnSliceStacInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceStackByID.");
        if (wrapperTable->m_Model_GetSliceStackByID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetSliceStackByID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetSliceStackByID(instanceHandle, nUniqueResourceID, &hReturnSliceStacInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSliceStacInstance = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnSliceStacInstance);
        args.GetReturnValue().Set(instanceObjSliceStacInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetBuildUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBuildUUID.");
        if (wrapperTable->m_Model_GetBuildUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetBuildUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Model_GetBuildUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_Model_GetBuildUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::SetBuildUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBuildUUID.");
        if (wrapperTable->m_Model_SetBuildUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::SetBuildUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_SetBuildUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetBuildItems(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBuildItemIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBuildItems.");
        if (wrapperTable->m_Model_GetBuildItems == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetBuildItems.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetBuildItems(instanceHandle, &hReturnBuildItemIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBuildItemIterator = CLib3MFBuildItemIterator::NewInstance(args.Holder(), hReturnBuildItemIterator);
        args.GetReturnValue().Set(instanceObjBuildItemIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetOutbox(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFBox sReturnOutbox;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutbox.");
        if (wrapperTable->m_Model_GetOutbox == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetOutbox.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetOutbox(instanceHandle, &sReturnOutbox);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBoxToObject(isolate, sReturnOutbox));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetResources(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResources.");
        if (wrapperTable->m_Model_GetResources == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetResources.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetResources(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFResourceIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetObjects(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjects.");
        if (wrapperTable->m_Model_GetObjects == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetObjects.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetObjects(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFObjectIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetMeshObjects(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMeshObjects.");
        if (wrapperTable->m_Model_GetMeshObjects == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetMeshObjects.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetMeshObjects(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFMeshObjectIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetComponentsObjects(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComponentsObjects.");
        if (wrapperTable->m_Model_GetComponentsObjects == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetComponentsObjects.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetComponentsObjects(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFComponentsObjectIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetTexture2Ds(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTexture2Ds.");
        if (wrapperTable->m_Model_GetTexture2Ds == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetTexture2Ds.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetTexture2Ds(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFTexture2DIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetBaseMaterialGroups(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBaseMaterialGroups.");
        if (wrapperTable->m_Model_GetBaseMaterialGroups == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetBaseMaterialGroups.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetBaseMaterialGroups(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFBaseMaterialGroupIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetColorGroups(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetColorGroups.");
        if (wrapperTable->m_Model_GetColorGroups == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetColorGroups.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetColorGroups(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFColorGroupIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetTexture2DGroups(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTexture2DGroups.");
        if (wrapperTable->m_Model_GetTexture2DGroups == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetTexture2DGroups.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetTexture2DGroups(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFTexture2DGroupIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetCompositeMaterials(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCompositeMaterials.");
        if (wrapperTable->m_Model_GetCompositeMaterials == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetCompositeMaterials.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetCompositeMaterials(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFCompositeMaterialsIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetMultiPropertyGroups(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMultiPropertyGroups.");
        if (wrapperTable->m_Model_GetMultiPropertyGroups == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetMultiPropertyGroups.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetMultiPropertyGroups(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFMultiPropertyGroupIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetSliceStacks(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceStacks.");
        if (wrapperTable->m_Model_GetSliceStacks == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetSliceStacks.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetSliceStacks(instanceHandle, &hReturnResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceIterator = CLib3MFSliceStackIterator::NewInstance(args.Holder(), hReturnResourceIterator);
        args.GetReturnValue().Set(instanceObjResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::MergeToModel(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMergedModelInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MergeToModel.");
        if (wrapperTable->m_Model_MergeToModel == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::MergeToModel.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_MergeToModel(instanceHandle, &hReturnMergedModelInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMergedModelInstance = CLib3MFModel::NewInstance(args.Holder(), hReturnMergedModelInstance);
        args.GetReturnValue().Set(instanceObjMergedModelInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddMeshObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMeshObjectInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMeshObject.");
        if (wrapperTable->m_Model_AddMeshObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddMeshObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddMeshObject(instanceHandle, &hReturnMeshObjectInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMeshObjectInstance = CLib3MFMeshObject::NewInstance(args.Holder(), hReturnMeshObjectInstance);
        args.GetReturnValue().Set(instanceObjMeshObjectInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddComponentsObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnComponentsObjectInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComponentsObject.");
        if (wrapperTable->m_Model_AddComponentsObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddComponentsObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddComponentsObject(instanceHandle, &hReturnComponentsObjectInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjComponentsObjectInstance = CLib3MFComponentsObject::NewInstance(args.Holder(), hReturnComponentsObjectInstance);
        args.GetReturnValue().Set(instanceObjComponentsObjectInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (ZBottom)");
        }
        double dZBottom = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnSliceStackInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSliceStack.");
        if (wrapperTable->m_Model_AddSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddSliceStack(instanceHandle, dZBottom, &hReturnSliceStackInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSliceStackInstance = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnSliceStackInstance);
        args.GetReturnValue().Set(instanceObjSliceStackInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddTexture2DFromAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TextureAttachment)");
        }
        Local<Object> objTextureAttachment = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceTextureAttachment = ObjectWrap::Unwrap<CLib3MFAttachment>(objTextureAttachment);
        if (instanceTextureAttachment == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TextureAttachment)");
        Lib3MFHandle hTextureAttachment = instanceTextureAttachment->getHandle( objTextureAttachment );
        Lib3MFHandle hReturnTexture2DInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTexture2DFromAttachment.");
        if (wrapperTable->m_Model_AddTexture2DFromAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddTexture2DFromAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddTexture2DFromAttachment(instanceHandle, hTextureAttachment, &hReturnTexture2DInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTexture2DInstance = CLib3MFTexture2D::NewInstance(args.Holder(), hReturnTexture2DInstance);
        args.GetReturnValue().Set(instanceObjTexture2DInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBaseMaterialGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBaseMaterialGroup.");
        if (wrapperTable->m_Model_AddBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddBaseMaterialGroup(instanceHandle, &hReturnBaseMaterialGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBaseMaterialGroupInstance = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnBaseMaterialGroupInstance);
        args.GetReturnValue().Set(instanceObjBaseMaterialGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddColorGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnColorGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddColorGroup.");
        if (wrapperTable->m_Model_AddColorGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddColorGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddColorGroup(instanceHandle, &hReturnColorGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjColorGroupInstance = CLib3MFColorGroup::NewInstance(args.Holder(), hReturnColorGroupInstance);
        args.GetReturnValue().Set(instanceObjColorGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddTexture2DGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Texture2DInstance)");
        }
        Local<Object> objTexture2DInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFTexture2D * instanceTexture2DInstance = ObjectWrap::Unwrap<CLib3MFTexture2D>(objTexture2DInstance);
        if (instanceTexture2DInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Texture2DInstance)");
        Lib3MFHandle hTexture2DInstance = instanceTexture2DInstance->getHandle( objTexture2DInstance );
        Lib3MFHandle hReturnTexture2DGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTexture2DGroup.");
        if (wrapperTable->m_Model_AddTexture2DGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddTexture2DGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddTexture2DGroup(instanceHandle, hTexture2DInstance, &hReturnTexture2DGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTexture2DGroupInstance = CLib3MFTexture2DGroup::NewInstance(args.Holder(), hReturnTexture2DGroupInstance);
        args.GetReturnValue().Set(instanceObjTexture2DGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddCompositeMaterials(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (BaseMaterialGroupInstance)");
        }
        Local<Object> objBaseMaterialGroupInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFBaseMaterialGroup * instanceBaseMaterialGroupInstance = ObjectWrap::Unwrap<CLib3MFBaseMaterialGroup>(objBaseMaterialGroupInstance);
        if (instanceBaseMaterialGroupInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (BaseMaterialGroupInstance)");
        Lib3MFHandle hBaseMaterialGroupInstance = instanceBaseMaterialGroupInstance->getHandle( objBaseMaterialGroupInstance );
        Lib3MFHandle hReturnCompositeMaterialsInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddCompositeMaterials.");
        if (wrapperTable->m_Model_AddCompositeMaterials == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddCompositeMaterials.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddCompositeMaterials(instanceHandle, hBaseMaterialGroupInstance, &hReturnCompositeMaterialsInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjCompositeMaterialsInstance = CLib3MFCompositeMaterials::NewInstance(args.Holder(), hReturnCompositeMaterialsInstance);
        args.GetReturnValue().Set(instanceObjCompositeMaterialsInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddMultiPropertyGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMultiPropertyGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMultiPropertyGroup.");
        if (wrapperTable->m_Model_AddMultiPropertyGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddMultiPropertyGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddMultiPropertyGroup(instanceHandle, &hReturnMultiPropertyGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMultiPropertyGroupInstance = CLib3MFMultiPropertyGroup::NewInstance(args.Holder(), hReturnMultiPropertyGroupInstance);
        args.GetReturnValue().Set(instanceObjMultiPropertyGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddBuildItem(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Object)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Transform)");
        }
        Local<Object> objObject = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFObject * instanceObject = ObjectWrap::Unwrap<CLib3MFObject>(objObject);
        if (instanceObject == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Object)");
        Lib3MFHandle hObject = instanceObject->getHandle( objObject );
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[1]);
        Lib3MFHandle hReturnBuildItemInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBuildItem.");
        if (wrapperTable->m_Model_AddBuildItem == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddBuildItem.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddBuildItem(instanceHandle, hObject, &sTransform, &hReturnBuildItemInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBuildItemInstance = CLib3MFBuildItem::NewInstance(args.Holder(), hReturnBuildItemInstance);
        args.GetReturnValue().Set(instanceObjBuildItemInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::RemoveBuildItem(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (BuildItemInstance)");
        }
        Local<Object> objBuildItemInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFBuildItem * instanceBuildItemInstance = ObjectWrap::Unwrap<CLib3MFBuildItem>(objBuildItemInstance);
        if (instanceBuildItemInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (BuildItemInstance)");
        Lib3MFHandle hBuildItemInstance = instanceBuildItemInstance->getHandle( objBuildItemInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveBuildItem.");
        if (wrapperTable->m_Model_RemoveBuildItem == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::RemoveBuildItem.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_RemoveBuildItem(instanceHandle, hBuildItemInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetMetaDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheMetaDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataGroup.");
        if (wrapperTable->m_Model_GetMetaDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetMetaDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetMetaDataGroup(instanceHandle, &hReturnTheMetaDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheMetaDataGroup = CLib3MFMetaDataGroup::NewInstance(args.Holder(), hReturnTheMetaDataGroup);
        args.GetReturnValue().Set(instanceObjTheMetaDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (URI)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (RelationShipType)");
        }
        v8::String::Utf8Value sutf8URI(isolate, args[0]);
        std::string sURI = *sutf8URI;
        v8::String::Utf8Value sutf8RelationShipType(isolate, args[1]);
        std::string sRelationShipType = *sutf8RelationShipType;
        Lib3MFHandle hReturnAttachmentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddAttachment.");
        if (wrapperTable->m_Model_AddAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddAttachment(instanceHandle, sURI.c_str(), sRelationShipType.c_str(), &hReturnAttachmentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachmentInstance = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachmentInstance);
        args.GetReturnValue().Set(instanceObjAttachmentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::RemoveAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (AttachmentInstance)");
        }
        Local<Object> objAttachmentInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceAttachmentInstance = ObjectWrap::Unwrap<CLib3MFAttachment>(objAttachmentInstance);
        if (instanceAttachmentInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (AttachmentInstance)");
        Lib3MFHandle hAttachmentInstance = instanceAttachmentInstance->getHandle( objAttachmentInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveAttachment.");
        if (wrapperTable->m_Model_RemoveAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::RemoveAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_RemoveAttachment(instanceHandle, hAttachmentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnAttachmentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAttachment.");
        if (wrapperTable->m_Model_GetAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetAttachment(instanceHandle, nIndex, &hReturnAttachmentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachmentInstance = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachmentInstance);
        args.GetReturnValue().Set(instanceObjAttachmentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::FindAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (URI)");
        }
        v8::String::Utf8Value sutf8URI(isolate, args[0]);
        std::string sURI = *sutf8URI;
        Lib3MFHandle hReturnAttachmentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindAttachment.");
        if (wrapperTable->m_Model_FindAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::FindAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_FindAttachment(instanceHandle, sURI.c_str(), &hReturnAttachmentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachmentInstance = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachmentInstance);
        args.GetReturnValue().Set(instanceObjAttachmentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetAttachmentCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnAttachmentCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAttachmentCount.");
        if (wrapperTable->m_Model_GetAttachmentCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetAttachmentCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetAttachmentCount(instanceHandle, &nReturnAttachmentCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnAttachmentCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::HasPackageThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasThumbnail = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasPackageThumbnailAttachment.");
        if (wrapperTable->m_Model_HasPackageThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::HasPackageThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_HasPackageThumbnailAttachment(instanceHandle, &bReturnHasThumbnail);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasThumbnail));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::CreatePackageThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnAttachment = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreatePackageThumbnailAttachment.");
        if (wrapperTable->m_Model_CreatePackageThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::CreatePackageThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_CreatePackageThumbnailAttachment(instanceHandle, &hReturnAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachment = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachment);
        args.GetReturnValue().Set(instanceObjAttachment);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetPackageThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnAttachment = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPackageThumbnailAttachment.");
        if (wrapperTable->m_Model_GetPackageThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetPackageThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetPackageThumbnailAttachment(instanceHandle, &hReturnAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachment = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachment);
        args.GetReturnValue().Set(instanceObjAttachment);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::RemovePackageThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemovePackageThumbnailAttachment.");
        if (wrapperTable->m_Model_RemovePackageThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::RemovePackageThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_RemovePackageThumbnailAttachment(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::AddCustomContentType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Extension)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (ContentType)");
        }
        v8::String::Utf8Value sutf8Extension(isolate, args[0]);
        std::string sExtension = *sutf8Extension;
        v8::String::Utf8Value sutf8ContentType(isolate, args[1]);
        std::string sContentType = *sutf8ContentType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddCustomContentType.");
        if (wrapperTable->m_Model_AddCustomContentType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::AddCustomContentType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_AddCustomContentType(instanceHandle, sExtension.c_str(), sContentType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::RemoveCustomContentType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Extension)");
        }
        v8::String::Utf8Value sutf8Extension(isolate, args[0]);
        std::string sExtension = *sutf8Extension;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveCustomContentType.");
        if (wrapperTable->m_Model_RemoveCustomContentType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::RemoveCustomContentType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_RemoveCustomContentType(instanceHandle, sExtension.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::SetRandomNumberCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetRandomNumberCallback.");
        if (wrapperTable->m_Model_SetRandomNumberCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::SetRandomNumberCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_SetRandomNumberCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFModel::GetKeyStore(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnKeyStore = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyStore.");
        if (wrapperTable->m_Model_GetKeyStore == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Model::GetKeyStore.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Model_GetKeyStore(instanceHandle, &hReturnKeyStore);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjKeyStore = CLib3MFKeyStore::NewInstance(args.Holder(), hReturnKeyStore);
        args.GetReturnValue().Set(instanceObjKeyStore);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFWrapper Implementation
**************************************************************************************************************************/

CLib3MFWrapper::CLib3MFWrapper()
		: CLib3MFBaseClass()
{
}

CLib3MFWrapper::~CLib3MFWrapper()
{

}

void CLib3MFWrapper::Init()
{
		Isolate* isolate = Isolate::GetCurrent();
		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFWrapper"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);
		
		// Prototype
		
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLibraryVersion", GetLibraryVersion);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPrereleaseInformation", GetPrereleaseInformation);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBuildInformation", GetBuildInformation);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSpecificationVersion", GetSpecificationVersion);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreateModel", CreateModel);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Release", Release);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Acquire", Acquire);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetJournal", SetJournal);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLastError", GetLastError);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSymbolLookupMethod", GetSymbolLookupMethod);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RetrieveProgressMessage", RetrieveProgressMessage);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RGBAToColor", RGBAToColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FloatRGBAToColor", FloatRGBAToColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ColorToRGBA", ColorToRGBA);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ColorToFloatRGBA", ColorToFloatRGBA);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentityTransform", GetIdentityTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUniformScaleTransform", GetUniformScaleTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetScaleTransform", GetScaleTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTranslationTransform", GetTranslationTransform);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());
}

void CLib3MFWrapper::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		try {
				if (args.IsConstructCall()) {
						// Get Library Name as Argument
						#ifdef _WIN32
						std::string sLibraryName = "lib3mf.dll";
						#elif __APPLE__
						std::string sLibraryName = "lib3mf.dylib";
						#elif __linux__
						std::string sLibraryName = "lib3mf.so";
						#endif
						if (args[0]->IsString()) {
								v8::String::Utf8Value stringParam(isolate, args[0]);
								sLibraryName = *stringParam;
						}
						// Invoked as constructor: `new Lib3MFWrapper(...)`
						CLib3MFWrapper* obj = new CLib3MFWrapper();
						Local<Object> newObject = args.This();
						std::auto_ptr<sLib3MFDynamicWrapperTable> wrapperTable( new sLib3MFDynamicWrapperTable );
						CheckError(isolate, nullptr, nullptr, LoadLib3MFWrapperTable(wrapperTable.get(), sLibraryName.c_str()));
						newObject->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, wrapperTable.release()));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ePropertyType_NoPropertyType"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ePropertyType_BaseMaterial"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ePropertyType_TexCoord"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ePropertyType_Colors"), Integer::New(isolate, 3));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ePropertyType_Composite"), Integer::New(isolate, 4));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ePropertyType_Multi"), Integer::New(isolate, 5));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eSlicesMeshResolution_Fullres"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eSlicesMeshResolution_Lowres"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eModelUnit_MicroMeter"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eModelUnit_MilliMeter"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eModelUnit_CentiMeter"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eModelUnit_Inch"), Integer::New(isolate, 3));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eModelUnit_Foot"), Integer::New(isolate, 4));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eModelUnit_Meter"), Integer::New(isolate, 5));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eObjectType_Other"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eObjectType_Model"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eObjectType_Support"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eObjectType_SolidSupport"), Integer::New(isolate, 3));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureType_Unknown"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureType_PNG"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureType_JPEG"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureTileStyle_Wrap"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureTileStyle_Mirror"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureTileStyle_Clamp"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureTileStyle_NoTileStyle"), Integer::New(isolate, 3));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureFilter_Auto"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureFilter_Linear"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eTextureFilter_Nearest"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeCapMode_Sphere"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeCapMode_HemiSphere"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeCapMode_Butt"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeClipMode_NoClipMode"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeClipMode_Inside"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeClipMode_Outside"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeBallMode_None"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeBallMode_Mixed"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBeamLatticeBallMode_All"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_QUERYCANCELED"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_DONE"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_CLEANUP"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READSTREAM"), Integer::New(isolate, 3));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_EXTRACTOPCPACKAGE"), Integer::New(isolate, 4));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READNONROOTMODELS"), Integer::New(isolate, 5));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READROOTMODEL"), Integer::New(isolate, 6));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READRESOURCES"), Integer::New(isolate, 7));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READMESH"), Integer::New(isolate, 8));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READSLICES"), Integer::New(isolate, 9));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READBUILD"), Integer::New(isolate, 10));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READCUSTOMATTACHMENT"), Integer::New(isolate, 11));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_READTEXTURETACHMENTS"), Integer::New(isolate, 12));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_CREATEOPCPACKAGE"), Integer::New(isolate, 13));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITEMODELSTOSTREAM"), Integer::New(isolate, 14));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITEROOTMODEL"), Integer::New(isolate, 15));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITENONROOTMODELS"), Integer::New(isolate, 16));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITEATTACHMENTS"), Integer::New(isolate, 17));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITECONTENTTYPES"), Integer::New(isolate, 18));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITENOBJECTS"), Integer::New(isolate, 19));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITENODES"), Integer::New(isolate, 20));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITETRIANGLES"), Integer::New(isolate, 21));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITESLICES"), Integer::New(isolate, 22));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eProgressIdentifier_WRITEKEYSTORE"), Integer::New(isolate, 23));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBlendMethod_NoBlendMethod"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBlendMethod_Mix"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eBlendMethod_Multiply"), Integer::New(isolate, 2));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eEncryptionAlgorithm_AES256_GCM"), Integer::New(isolate, 1));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eWrappingAlgorithm_RSA_OAEP"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eMgfAlgorithm_MGF1_SHA1"), Integer::New(isolate, 160));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eMgfAlgorithm_MGF1_SHA224"), Integer::New(isolate, 224));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eMgfAlgorithm_MGF1_SHA256"), Integer::New(isolate, 256));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eMgfAlgorithm_MGF1_SHA384"), Integer::New(isolate, 384));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eMgfAlgorithm_MGF1_SHA512"), Integer::New(isolate, 512));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eDigestMethod_SHA1"), Integer::New(isolate, 160));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eDigestMethod_SHA256"), Integer::New(isolate, 256));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eCompression_NoCompression"), Integer::New(isolate, 0));
						newObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "eCompression_Deflate"), Integer::New(isolate, 1));
						obj->Wrap(newObject);
						args.GetReturnValue().Set(newObject);
				} else {
						// Invoked as plain function `Lib3MFWrapper(...)`, turn into construct call.
						const int argc = 1;
						Local<Value> argv[argc] = { args[0] };
						Local<Function> cons = Local<Function>::New(isolate, constructor);
						args.GetReturnValue().Set(cons->NewInstance(isolate->GetCurrentContext(), argc, argv).ToLocalChecked());
				}
		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

Local<Object> CLib3MFWrapper::NewInstance(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		const int argc = 1;
		Local<Value> argv[argc] = { args[0] };
		cons->NewInstance(isolate->GetCurrentContext(), argc, argv).ToLocal(&instance);
		return instance;
}


void CLib3MFWrapper::GetLibraryVersion(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        unsigned int nReturnMajor = 0;
        unsigned int nReturnMinor = 0;
        unsigned int nReturnMicro = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLibraryVersion.");
        if (wrapperTable->m_GetLibraryVersion == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetLibraryVersion.");
        Lib3MFResult errorCode = wrapperTable->m_GetLibraryVersion(&nReturnMajor, &nReturnMinor, &nReturnMicro);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Major"), Integer::NewFromUnsigned(isolate, nReturnMajor));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Minor"), Integer::NewFromUnsigned(isolate, nReturnMinor));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Micro"), Integer::NewFromUnsigned(isolate, nReturnMicro));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetPrereleaseInformation(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasPrereleaseInfo = false;
        unsigned int bytesNeededPrereleaseInfo = 0;
        unsigned int bytesWrittenPrereleaseInfo = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPrereleaseInformation.");
        if (wrapperTable->m_GetPrereleaseInformation == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetPrereleaseInformation.");
        Lib3MFResult initErrorCode = wrapperTable->m_GetPrereleaseInformation(&bReturnHasPrereleaseInfo, 0, &bytesNeededPrereleaseInfo, nullptr);
        CheckError(isolate, wrapperTable, nullptr, initErrorCode);
        std::vector<char> bufferPrereleaseInfo;
        bufferPrereleaseInfo.resize(bytesNeededPrereleaseInfo);
        Lib3MFResult errorCode = wrapperTable->m_GetPrereleaseInformation(&bReturnHasPrereleaseInfo, bytesNeededPrereleaseInfo, &bytesWrittenPrereleaseInfo, &bufferPrereleaseInfo[0]);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasPrereleaseInfo"), Boolean::New(isolate, bReturnHasPrereleaseInfo));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "PrereleaseInfo"), String::NewFromUtf8(isolate, &bufferPrereleaseInfo[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetBuildInformation(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasBuildInfo = false;
        unsigned int bytesNeededBuildInformation = 0;
        unsigned int bytesWrittenBuildInformation = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBuildInformation.");
        if (wrapperTable->m_GetBuildInformation == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetBuildInformation.");
        Lib3MFResult initErrorCode = wrapperTable->m_GetBuildInformation(&bReturnHasBuildInfo, 0, &bytesNeededBuildInformation, nullptr);
        CheckError(isolate, wrapperTable, nullptr, initErrorCode);
        std::vector<char> bufferBuildInformation;
        bufferBuildInformation.resize(bytesNeededBuildInformation);
        Lib3MFResult errorCode = wrapperTable->m_GetBuildInformation(&bReturnHasBuildInfo, bytesNeededBuildInformation, &bytesWrittenBuildInformation, &bufferBuildInformation[0]);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasBuildInfo"), Boolean::New(isolate, bReturnHasBuildInfo));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "BuildInformation"), String::NewFromUtf8(isolate, &bufferBuildInformation[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetSpecificationVersion(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (SpecificationURL)");
        }
        Local<Object> outObject = Object::New(isolate);
        v8::String::Utf8Value sutf8SpecificationURL(isolate, args[0]);
        std::string sSpecificationURL = *sutf8SpecificationURL;
        bool bReturnIsSupported = false;
        unsigned int nReturnMajor = 0;
        unsigned int nReturnMinor = 0;
        unsigned int nReturnMicro = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSpecificationVersion.");
        if (wrapperTable->m_GetSpecificationVersion == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetSpecificationVersion.");
        Lib3MFResult errorCode = wrapperTable->m_GetSpecificationVersion(sSpecificationURL.c_str(), &bReturnIsSupported, &nReturnMajor, &nReturnMinor, &nReturnMicro);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "IsSupported"), Boolean::New(isolate, bReturnIsSupported));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Major"), Integer::NewFromUnsigned(isolate, nReturnMajor));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Minor"), Integer::NewFromUnsigned(isolate, nReturnMinor));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Micro"), Integer::NewFromUnsigned(isolate, nReturnMicro));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::CreateModel(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnModel = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreateModel.");
        if (wrapperTable->m_CreateModel == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CreateModel.");
        Lib3MFResult errorCode = wrapperTable->m_CreateModel(&hReturnModel);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        Local<Object> instanceObjModel = CLib3MFModel::NewInstance(args.Holder(), hReturnModel);
        args.GetReturnValue().Set(instanceObjModel);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::Release(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Instance)");
        }
        Local<Object> objInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFBase * instanceInstance = ObjectWrap::Unwrap<CLib3MFBase>(objInstance);
        if (instanceInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Instance)");
        Lib3MFHandle hInstance = instanceInstance->getHandle( objInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Release.");
        if (wrapperTable->m_Release == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Release.");
        Lib3MFResult errorCode = wrapperTable->m_Release(hInstance);
        CheckError(isolate, wrapperTable, nullptr, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::Acquire(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Instance)");
        }
        Local<Object> objInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFBase * instanceInstance = ObjectWrap::Unwrap<CLib3MFBase>(objInstance);
        if (instanceInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Instance)");
        Lib3MFHandle hInstance = instanceInstance->getHandle( objInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Acquire.");
        if (wrapperTable->m_Acquire == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Acquire.");
        Lib3MFResult errorCode = wrapperTable->m_Acquire(hInstance);
        CheckError(isolate, wrapperTable, nullptr, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::SetJournal(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (JournalPath)");
        }
        v8::String::Utf8Value sutf8JournalPath(isolate, args[0]);
        std::string sJournalPath = *sutf8JournalPath;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetJournal.");
        if (wrapperTable->m_SetJournal == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SetJournal.");
        Lib3MFResult errorCode = wrapperTable->m_SetJournal(sJournalPath.c_str());
        CheckError(isolate, wrapperTable, nullptr, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetLastError(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Instance)");
        }
        Local<Object> outObject = Object::New(isolate);
        Local<Object> objInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFBase * instanceInstance = ObjectWrap::Unwrap<CLib3MFBase>(objInstance);
        if (instanceInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Instance)");
        Lib3MFHandle hInstance = instanceInstance->getHandle( objInstance );
        unsigned int bytesNeededLastErrorString = 0;
        unsigned int bytesWrittenLastErrorString = 0;
        bool bReturnHasLastError = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLastError.");
        if (wrapperTable->m_GetLastError == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetLastError.");
        Lib3MFResult initErrorCode = wrapperTable->m_GetLastError(hInstance, 0, &bytesNeededLastErrorString, nullptr, &bReturnHasLastError);
        CheckError(isolate, wrapperTable, nullptr, initErrorCode);
        std::vector<char> bufferLastErrorString;
        bufferLastErrorString.resize(bytesNeededLastErrorString);
        Lib3MFResult errorCode = wrapperTable->m_GetLastError(hInstance, bytesNeededLastErrorString, &bytesWrittenLastErrorString, &bufferLastErrorString[0], &bReturnHasLastError);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "LastErrorString"), String::NewFromUtf8(isolate, &bufferLastErrorString[0]));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasLastError"), Boolean::New(isolate, bReturnHasLastError));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetSymbolLookupMethod(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnSymbolLookupMethod = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSymbolLookupMethod.");
        if (wrapperTable->m_GetSymbolLookupMethod == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetSymbolLookupMethod.");
        Lib3MFResult errorCode = wrapperTable->m_GetSymbolLookupMethod(&nReturnSymbolLookupMethod);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnSymbolLookupMethod).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::RetrieveProgressMessage(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (TheProgressIdentifier)");
        }
        unsigned int eTheProgressIdentifier = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int bytesNeededProgressMessage = 0;
        unsigned int bytesWrittenProgressMessage = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RetrieveProgressMessage.");
        if (wrapperTable->m_RetrieveProgressMessage == nullptr)
            throw std::runtime_error("Could not call Lib3MF method RetrieveProgressMessage.");
        Lib3MFResult initErrorCode = wrapperTable->m_RetrieveProgressMessage((eLib3MFProgressIdentifier) eTheProgressIdentifier, 0, &bytesNeededProgressMessage, nullptr);
        CheckError(isolate, wrapperTable, nullptr, initErrorCode);
        std::vector<char> bufferProgressMessage;
        bufferProgressMessage.resize(bytesNeededProgressMessage);
        Lib3MFResult errorCode = wrapperTable->m_RetrieveProgressMessage((eLib3MFProgressIdentifier) eTheProgressIdentifier, bytesNeededProgressMessage, &bytesWrittenProgressMessage, &bufferProgressMessage[0]);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferProgressMessage[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::RGBAToColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint8 parameter 0 (Red)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected uint8 parameter 1 (Green)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected uint8 parameter 2 (Blue)");
        }
        if (!args[3]->IsUint32()) {
            throw std::runtime_error("Expected uint8 parameter 3 (Alpha)");
        }
        unsigned char nRed = (unsigned char) args[0]->Uint32Value(isolate->GetCurrentContext()).ToChecked();
        unsigned char nGreen = (unsigned char) args[1]->Uint32Value(isolate->GetCurrentContext()).ToChecked();
        unsigned char nBlue = (unsigned char) args[2]->Uint32Value(isolate->GetCurrentContext()).ToChecked();
        unsigned char nAlpha = (unsigned char) args[3]->Uint32Value(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sReturnTheColor;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RGBAToColor.");
        if (wrapperTable->m_RGBAToColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method RGBAToColor.");
        Lib3MFResult errorCode = wrapperTable->m_RGBAToColor(nRed, nGreen, nBlue, nAlpha, &sReturnTheColor);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(convertLib3MFColorToObject(isolate, sReturnTheColor));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::FloatRGBAToColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 0 (Red)");
        }
        if (!args[1]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 1 (Green)");
        }
        if (!args[2]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 2 (Blue)");
        }
        if (!args[3]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 3 (Alpha)");
        }
        float fRed = (float) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fGreen = (float) args[1]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fBlue = (float) args[2]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fAlpha = (float) args[3]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sReturnTheColor;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FloatRGBAToColor.");
        if (wrapperTable->m_FloatRGBAToColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FloatRGBAToColor.");
        Lib3MFResult errorCode = wrapperTable->m_FloatRGBAToColor(fRed, fGreen, fBlue, fAlpha, &sReturnTheColor);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(convertLib3MFColorToObject(isolate, sReturnTheColor));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::ColorToRGBA(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (TheColor)");
        }
        Local<Object> outObject = Object::New(isolate);
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[0]);
        unsigned char nReturnRed = 0;
        unsigned char nReturnGreen = 0;
        unsigned char nReturnBlue = 0;
        unsigned char nReturnAlpha = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ColorToRGBA.");
        if (wrapperTable->m_ColorToRGBA == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorToRGBA.");
        Lib3MFResult errorCode = wrapperTable->m_ColorToRGBA(&sTheColor, &nReturnRed, &nReturnGreen, &nReturnBlue, &nReturnAlpha);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Red"), Integer::NewFromUnsigned(isolate, nReturnRed));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Green"), Integer::NewFromUnsigned(isolate, nReturnGreen));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Blue"), Integer::NewFromUnsigned(isolate, nReturnBlue));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Alpha"), Integer::NewFromUnsigned(isolate, nReturnAlpha));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::ColorToFloatRGBA(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (TheColor)");
        }
        Local<Object> outObject = Object::New(isolate);
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[0]);
        float fReturnRed = 0.0f;
        float fReturnGreen = 0.0f;
        float fReturnBlue = 0.0f;
        float fReturnAlpha = 0.0f;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ColorToFloatRGBA.");
        if (wrapperTable->m_ColorToFloatRGBA == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorToFloatRGBA.");
        Lib3MFResult errorCode = wrapperTable->m_ColorToFloatRGBA(&sTheColor, &fReturnRed, &fReturnGreen, &fReturnBlue, &fReturnAlpha);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Red"), Number::New(isolate, (double)fReturnRed));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Green"), Number::New(isolate, (double)fReturnGreen));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Blue"), Number::New(isolate, (double)fReturnBlue));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Alpha"), Number::New(isolate, (double)fReturnAlpha));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetIdentityTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentityTransform.");
        if (wrapperTable->m_GetIdentityTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetIdentityTransform.");
        Lib3MFResult errorCode = wrapperTable->m_GetIdentityTransform(&sReturnTransform);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetUniformScaleTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 0 (Factor)");
        }
        float fFactor = (float) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUniformScaleTransform.");
        if (wrapperTable->m_GetUniformScaleTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetUniformScaleTransform.");
        Lib3MFResult errorCode = wrapperTable->m_GetUniformScaleTransform(fFactor, &sReturnTransform);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetScaleTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 0 (FactorX)");
        }
        if (!args[1]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 1 (FactorY)");
        }
        if (!args[2]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 2 (FactorZ)");
        }
        float fFactorX = (float) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fFactorY = (float) args[1]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fFactorZ = (float) args[2]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetScaleTransform.");
        if (wrapperTable->m_GetScaleTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetScaleTransform.");
        Lib3MFResult errorCode = wrapperTable->m_GetScaleTransform(fFactorX, fFactorY, fFactorZ, &sReturnTransform);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWrapper::GetTranslationTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 0 (VectorX)");
        }
        if (!args[1]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 1 (VectorY)");
        }
        if (!args[2]->IsNumber()) {
            throw std::runtime_error("Expected single parameter 2 (VectorZ)");
        }
        float fVectorX = (float) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fVectorY = (float) args[1]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        float fVectorZ = (float) args[2]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTranslationTransform.");
        if (wrapperTable->m_GetTranslationTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method GetTranslationTransform.");
        Lib3MFResult errorCode = wrapperTable->m_GetTranslationTransform(fVectorX, fVectorY, fVectorZ, &sReturnTransform);
        CheckError(isolate, wrapperTable, nullptr, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


