program intrinsics_216
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    integer :: i

    real(dp) :: w(18)
    real(sp) :: x(19)
    real(dp) :: expected_w(18)
    real(sp) :: expected_x(19)
         
    real(dp), parameter :: res(18) = tand([18.7234114226922479_dp, 31.7355871858161613_dp, 46.7189879975828859_dp, &
    -18.7234114226922479_dp, -31.7355871858161613_dp, -46.7189879975828859_dp,  &
    -88.1889782219856926_dp, -87.4387217993888584_dp, -86.8629570229495442_dp, -86.3775039053440139_dp, &
    -85.9497575149846398_dp, -85.5629967823348778_dp, -85.2072890476047604_dp, -84.8761629060389708_dp, &
    -84.5651234927047142_dp, -84.2708982602068915_dp, -83.9910168022338581_dp, -83.7235599383380418_dp])

    real(sp), parameter :: res_sp(19) = tand([17.7966309_sp, 27.7443714_sp, 36.0546188_sp, &
        -17.7966309_sp, -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp])

    expected_w = [0.33893680906656531_dp, 0.61847095166537402_dp, 1.0618790637212407_dp, &
    -0.33893680906656531_dp, -0.61847095166537402_dp, -1.0618790637212407_dp, -31.626730189083542_dp, &
    -22.355091700495215_dp, -18.246009265584753_dp, -15.795576912540882_dp, -14.122687866626119_dp, &
    -12.887346837923063_dp, -11.926878796582502_dp, -11.152376450806424_dp, -10.510603475834616_dp, &
    -9.9674784142684150_dp, -9.5000362475747657_dp, -9.0921624583853777_dp]

    w = [18.7234114226922479_dp, 31.7355871858161613_dp, 46.7189879975828859_dp, -18.7234114226922479_dp, &
    -31.7355871858161613_dp, -46.7189879975828859_dp, -88.1889782219856926_dp, -87.4387217993888584_dp, &
    -86.8629570229495442_dp, -86.3775039053440139_dp, -85.9497575149846398_dp, -85.5629967823348778_dp, -85.2072890476047604_dp, &
    -84.8761629060389708_dp, -84.5651234927047142_dp, -84.2708982602068915_dp, -83.9910168022338581_dp, &
    -83.7235599383380418_dp]

    x = [17.7966309_sp, 27.7443714_sp, 36.0546188_sp, -17.7966309_sp, &
        -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp]

    expected_x = [0.320999980_sp, 0.526000023_sp, 0.727999985_sp, -0.320999980_sp, &
        -0.526000023_sp, -0.727999985_sp, -1.00000000_sp, -0.998999894_sp, -0.998999894_sp, &
        -0.997999907_sp, -0.997999907_sp, -0.996999860_sp, -0.996999860_sp, -0.995999992_sp, &
        -0.995999992_sp, -0.995000064_sp, -0.995000064_sp, -0.993999898_sp, -0.993999898_sp]

    do i = 1, size(res)
        print *, res(i)
        if (abs(res(i) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(w)
        print *, tand(w(i))
        if (abs(tand(w(i)) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(res_sp)
        print *, res_sp(i)
        if (abs(res_sp(i) - expected_x(i)) > 1e-5) error stop
    end do

    do i = 1, size(x)
        print *, tand(x(i))
        if (abs(tand(x(i)) - expected_x(i)) > 1e-5) error stop
    end do

end program