program intrinsics_190
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    real(8) :: x(40)
    real(8) :: expected(40)

    real :: y(30)
    real :: expected_y(30)

    integer :: i

    x = [3.3398640543782485_dp, 5.039184326269492_dp, 6.738504598160736_dp, 8.43782487005198_dp, &
    10.137145141943222_dp, 11.836465413834466_dp, 13.53578568572571_dp, 15.235105957616954_dp, &
    16.934426229508198_dp, 18.63374650139944_dp, 1.999201299880048d+306, 1.199520279928029d+307, &
    2.1991204298680527d+307, 3.198720579808077d+307, 4.198320729748101d+307, 5.197920879688125d+307, &
    6.197521029628149d+307, 7.197121179568173d+307, 8.196721329508197d+307, 9.196321479448221d+307, &
    -0.8439824070371851_dp, -1.0638944422231107_dp, -1.2838064774090363_dp, -1.503718512594962_dp, &
    -1.7236305477808875_dp, -1.9435425829668134_dp, -2.163454618152739_dp, -2.3833666533386646_dp, &
    -2.60327868852459_dp, -2.823190723710516_dp, .8439824070371851_dp, 1.0638944422231107_dp, &
    1.2838064774090363_dp, 1.503718512594962_dp, 1.7236305477808875_dp, 1.9435425829668134_dp, &
    2.163454618152739_dp, 2.3833666533386646_dp, 2.60327868852459_dp, 2.823190723710516_dp]

    expected = [-0.35276533724012665_dp, -0.16467814025284372_dp, 0.2885135446265932_dp, 0.05889084216205015_dp, &
    -0.2495399733324126_dp, 0.0104212906373451_dp, 0.21349211445035887_dp, -0.06124277731984677_dp, &
    -0.17590100995447924_dp, 0.09861767893471807_dp, 5.6416523635296804d-154, -2.2862889422883802d-154, &
    6.631140845542755d-155, -5.568530188979783d-155, -1.4147891343158852d-155, 6.574020907172679d-155, &
    1.010764003164187d-154, 9.351175657542549d-155, 3.874969850157508d-155, -4.371594366447781d-155, &
    0.8296961122853597_dp, 0.7364314862573926_dp, 0.6285104628739052_dp, 0.509752014245272_dp, &
    0.3843166288058289_dp, 0.25654187983098076_dp, 0.1307721336491019_dp, 0.011189479462964488_dp, &
    -0.09834712549229654_dp, -0.19444788933021404_dp, 0.8296961122853597_dp, 0.7364314862573926_dp, &
    0.6285104628739052_dp, 0.509752014245272_dp, 0.3843166288058289_dp, 0.25654187983098076_dp, &
    0.1307721336491019_dp, 0.011189479462964488_dp, -0.09834712549229654_dp, -0.19444788933021404_dp]

    do i = 1, size(x)
        print *, bessel_j0(x(i)), "i = ", i
        if (abs(bessel_j0(x(i)) - expected(i)) > 1e-12) error stop
    end do

    y = [3.3398640543782485_sp, 5.039184326269492_sp, 6.738504598160736_sp, 8.43782487005198_sp, &
    10.137145141943222_sp, 11.836465413834466_sp, 13.53578568572571_sp, 15.235105957616954_sp, &
    16.934426229508198_sp, 18.63374650139944_sp, &
    -0.8439824070371851_sp, -1.0638944422231107_sp, -1.2838064774090363_sp, -1.503718512594962_sp, &
    -1.7236305477808875_sp, -1.9435425829668134_sp, -2.163454618152739_sp, -2.3833666533386646_sp, &
    -2.60327868852459_sp, -2.823190723710516_sp, .8439824070371851_sp, 1.0638944422231107_sp, &
    1.2838064774090363_sp, 1.503718512594962_sp, 1.7236305477808875_sp, 1.9435425829668134_sp, &
    2.163454618152739_sp, 2.3833666533386646_sp, 2.60327868852459_sp, 2.823190723710516_sp]

    expected_y = [-0.35276533724012665_sp, -0.16467814025284372_sp, 0.2885135446265932_sp, 0.05889084216205015_sp, &
    -0.2495399733324126_sp, 0.0104212906373451_sp, 0.21349211445035887_sp, -0.06124277731984677_sp, &
    -0.17590100995447924_sp, 0.09861767893471807_sp, &
    0.8296961122853597_sp, 0.7364314862573926_sp, 0.6285104628739052_sp, 0.509752014245272_sp, &
    0.3843166288058289_sp, 0.25654187983098076_sp, 0.1307721336491019_sp, 0.011189479462964488_sp, &
    -0.09834712549229654_sp, -0.19444788933021404_sp, 0.8296961122853597_sp, 0.7364314862573926_sp, &
    0.6285104628739052_sp, 0.509752014245272_sp, 0.3843166288058289_sp, 0.25654187983098076_sp, &
    0.1307721336491019_sp, 0.011189479462964488_sp, -0.09834712549229654_sp, -0.19444788933021404_sp]

    do i = 1, size(y)
        print *, bessel_j0(y(i)), "i = ", i
        if (abs(bessel_j0(y(i)) - expected_y(i)) > 1e-6) error stop
    end do
end program
