/*
 * Copyright (C) 2019 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/encoding/multi-byte.py"!
 * Do not change this file!
 */

#include "lexbor/encoding/base.h"

#include "lexbor/core/shs.h"


LXB_API const lxb_encoding_multi_index_t lxb_encoding_multi_index_jis0208[11104] = 
{
    {(lxb_char_t *) "\xe3\x80\x80", 3, 0x3000}, /* (IDEOGRAPHIC SPACE) */
    {(lxb_char_t *) "\xe3\x80\x81", 3, 0x3001}, /* (IDEOGRAPHIC COMMA) */
    {(lxb_char_t *) "\xe3\x80\x82", 3, 0x3002}, /* (IDEOGRAPHIC FULL STOP) */
    {(lxb_char_t *) "\xef\xbc\x8c", 3, 0xFF0C}, /* (FULLWIDTH COMMA) */
    {(lxb_char_t *) "\xef\xbc\x8e", 3, 0xFF0E}, /* (FULLWIDTH FULL STOP) */
    {(lxb_char_t *) "\xe3\x83\xbb", 3, 0x30FB}, /* (KATAKANA MIDDLE DOT) */
    {(lxb_char_t *) "\xef\xbc\x9a", 3, 0xFF1A}, /* (FULLWIDTH COLON) */
    {(lxb_char_t *) "\xef\xbc\x9b", 3, 0xFF1B}, /* (FULLWIDTH SEMICOLON) */
    {(lxb_char_t *) "\xef\xbc\x9f", 3, 0xFF1F}, /* (FULLWIDTH QUESTION MARK) */
    {(lxb_char_t *) "\xef\xbc\x81", 3, 0xFF01}, /* (FULLWIDTH EXCLAMATION MARK) */
    {(lxb_char_t *) "\xe3\x82\x9b", 3, 0x309B}, /* (KATAKANA-HIRAGANA VOICED SOUND MARK) */
    {(lxb_char_t *) "\xe3\x82\x9c", 3, 0x309C}, /* (KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xef\xbd\x80", 3, 0xFF40}, /* (FULLWIDTH GRAVE ACCENT) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xef\xbc\xbe", 3, 0xFF3E}, /* (FULLWIDTH CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xef\xbf\xa3", 3, 0xFFE3}, /* (FULLWIDTH MACRON) */
    {(lxb_char_t *) "\xef\xbc\xbf", 3, 0xFF3F}, /* (FULLWIDTH LOW LINE) */
    {(lxb_char_t *) "\xe3\x83\xbd", 3, 0x30FD}, /* (KATAKANA ITERATION MARK) */
    {(lxb_char_t *) "\xe3\x83\xbe", 3, 0x30FE}, /* (KATAKANA VOICED ITERATION MARK) */
    {(lxb_char_t *) "\xe3\x82\x9d", 3, 0x309D}, /* (HIRAGANA ITERATION MARK) */
    {(lxb_char_t *) "\xe3\x82\x9e", 3, 0x309E}, /* (HIRAGANA VOICED ITERATION MARK) */
    {(lxb_char_t *) "\xe3\x80\x83", 3, 0x3003}, /* (DITTO MARK) */
    {(lxb_char_t *) "\xe4\xbb\x9d", 3, 0x4EDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe3\x80\x85", 3, 0x3005}, /* (IDEOGRAPHIC ITERATION MARK) */
    {(lxb_char_t *) "\xe3\x80\x86", 3, 0x3006}, /* (IDEOGRAPHIC CLOSING MARK) */
    {(lxb_char_t *) "\xe3\x80\x87", 3, 0x3007}, /* (IDEOGRAPHIC NUMBER ZERO) */
    {(lxb_char_t *) "\xe3\x83\xbc", 3, 0x30FC}, /* (KATAKANA-HIRAGANA PROLONGED SOUND MARK) */
    {(lxb_char_t *) "\xe2\x80\x95", 3, 0x2015}, /* (HORIZONTAL BAR) */
    {(lxb_char_t *) "\xe2\x80\x90", 3, 0x2010}, /* (HYPHEN) */
    {(lxb_char_t *) "\xef\xbc\x8f", 3, 0xFF0F}, /* (FULLWIDTH SOLIDUS) */
    {(lxb_char_t *) "\xef\xbc\xbc", 3, 0xFF3C}, /* (FULLWIDTH REVERSE SOLIDUS) */
    {(lxb_char_t *) "\xef\xbd\x9e", 3, 0xFF5E}, /* (FULLWIDTH TILDE) */
    {(lxb_char_t *) "\xe2\x88\xa5", 3, 0x2225}, /* (PARALLEL TO) */
    {(lxb_char_t *) "\xef\xbd\x9c", 3, 0xFF5C}, /* (FULLWIDTH VERTICAL LINE) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa5", 3, 0x2025}, /* (TWO DOT LEADER) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xef\xbc\x88", 3, 0xFF08}, /* (FULLWIDTH LEFT PARENTHESIS) */
    {(lxb_char_t *) "\xef\xbc\x89", 3, 0xFF09}, /* (FULLWIDTH RIGHT PARENTHESIS) */
    {(lxb_char_t *) "\xe3\x80\x94", 3, 0x3014}, /* (LEFT TORTOISE SHELL BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x95", 3, 0x3015}, /* (RIGHT TORTOISE SHELL BRACKET) */
    {(lxb_char_t *) "\xef\xbc\xbb", 3, 0xFF3B}, /* (FULLWIDTH LEFT SQUARE BRACKET) */
    {(lxb_char_t *) "\xef\xbc\xbd", 3, 0xFF3D}, /* (FULLWIDTH RIGHT SQUARE BRACKET) */
    {(lxb_char_t *) "\xef\xbd\x9b", 3, 0xFF5B}, /* (FULLWIDTH LEFT CURLY BRACKET) */
    {(lxb_char_t *) "\xef\xbd\x9d", 3, 0xFF5D}, /* (FULLWIDTH RIGHT CURLY BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x88", 3, 0x3008}, /* (LEFT ANGLE BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x89", 3, 0x3009}, /* (RIGHT ANGLE BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x8a", 3, 0x300A}, /* (LEFT DOUBLE ANGLE BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x8b", 3, 0x300B}, /* (RIGHT DOUBLE ANGLE BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x8c", 3, 0x300C}, /* (LEFT CORNER BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x8d", 3, 0x300D}, /* (RIGHT CORNER BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x8e", 3, 0x300E}, /* (LEFT WHITE CORNER BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x8f", 3, 0x300F}, /* (RIGHT WHITE CORNER BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x90", 3, 0x3010}, /* (LEFT BLACK LENTICULAR BRACKET) */
    {(lxb_char_t *) "\xe3\x80\x91", 3, 0x3011}, /* (RIGHT BLACK LENTICULAR BRACKET) */
    {(lxb_char_t *) "\xef\xbc\x8b", 3, 0xFF0B}, /* (FULLWIDTH PLUS SIGN) */
    {(lxb_char_t *) "\xef\xbc\x8d", 3, 0xFF0D}, /* (FULLWIDTH HYPHEN-MINUS) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xef\xbc\x9d", 3, 0xFF1D}, /* (FULLWIDTH EQUALS SIGN) */
    {(lxb_char_t *) "\xe2\x89\xa0", 3, 0x2260}, /* (NOT EQUAL TO) */
    {(lxb_char_t *) "\xef\xbc\x9c", 3, 0xFF1C}, /* (FULLWIDTH LESS-THAN SIGN) */
    {(lxb_char_t *) "\xef\xbc\x9e", 3, 0xFF1E}, /* (FULLWIDTH GREATER-THAN SIGN) */
    {(lxb_char_t *) "\xe2\x89\xa6", 3, 0x2266}, /* (LESS-THAN OVER EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa7", 3, 0x2267}, /* (GREATER-THAN OVER EQUAL TO) */
    {(lxb_char_t *) "\xe2\x88\x9e", 3, 0x221E}, /* (INFINITY) */
    {(lxb_char_t *) "\xe2\x88\xb4", 3, 0x2234}, /* (THEREFORE) */
    {(lxb_char_t *) "\xe2\x99\x82", 3, 0x2642}, /* (MALE SIGN) */
    {(lxb_char_t *) "\xe2\x99\x80", 3, 0x2640}, /* (FEMALE SIGN) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xe2\x80\xb2", 3, 0x2032}, /* (PRIME) */
    {(lxb_char_t *) "\xe2\x80\xb3", 3, 0x2033}, /* (DOUBLE PRIME) */
    {(lxb_char_t *) "\xe2\x84\x83", 3, 0x2103}, /* (DEGREE CELSIUS) */
    {(lxb_char_t *) "\xef\xbf\xa5", 3, 0xFFE5}, /* (FULLWIDTH YEN SIGN) */
    {(lxb_char_t *) "\xef\xbc\x84", 3, 0xFF04}, /* (FULLWIDTH DOLLAR SIGN) */
    {(lxb_char_t *) "\xef\xbf\xa0", 3, 0xFFE0}, /* (FULLWIDTH CENT SIGN) */
    {(lxb_char_t *) "\xef\xbf\xa1", 3, 0xFFE1}, /* (FULLWIDTH POUND SIGN) */
    {(lxb_char_t *) "\xef\xbc\x85", 3, 0xFF05}, /* (FULLWIDTH PERCENT SIGN) */
    {(lxb_char_t *) "\xef\xbc\x83", 3, 0xFF03}, /* (FULLWIDTH NUMBER SIGN) */
    {(lxb_char_t *) "\xef\xbc\x86", 3, 0xFF06}, /* (FULLWIDTH AMPERSAND) */
    {(lxb_char_t *) "\xef\xbc\x8a", 3, 0xFF0A}, /* (FULLWIDTH ASTERISK) */
    {(lxb_char_t *) "\xef\xbc\xa0", 3, 0xFF20}, /* (FULLWIDTH COMMERCIAL AT) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xe2\x98\x86", 3, 0x2606}, /* (WHITE STAR) */
    {(lxb_char_t *) "\xe2\x98\x85", 3, 0x2605}, /* (BLACK STAR) */
    {(lxb_char_t *) "\xe2\x97\x8b", 3, 0x25CB}, /* (WHITE CIRCLE) */
    {(lxb_char_t *) "\xe2\x97\x8f", 3, 0x25CF}, /* (BLACK CIRCLE) */
    {(lxb_char_t *) "\xe2\x97\x8e", 3, 0x25CE}, /* (BULLSEYE) */
    {(lxb_char_t *) "\xe2\x97\x87", 3, 0x25C7}, /* (WHITE DIAMOND) */
    {(lxb_char_t *) "\xe2\x97\x86", 3, 0x25C6}, /* (BLACK DIAMOND) */
    {(lxb_char_t *) "\xe2\x96\xa1", 3, 0x25A1}, /* (WHITE SQUARE) */
    {(lxb_char_t *) "\xe2\x96\xa0", 3, 0x25A0}, /* (BLACK SQUARE) */
    {(lxb_char_t *) "\xe2\x96\xb3", 3, 0x25B3}, /* (WHITE UP-POINTING TRIANGLE) */
    {(lxb_char_t *) "\xe2\x96\xb2", 3, 0x25B2}, /* (BLACK UP-POINTING TRIANGLE) */
    {(lxb_char_t *) "\xe2\x96\xbd", 3, 0x25BD}, /* (WHITE DOWN-POINTING TRIANGLE) */
    {(lxb_char_t *) "\xe2\x96\xbc", 3, 0x25BC}, /* (BLACK DOWN-POINTING TRIANGLE) */
    {(lxb_char_t *) "\xe2\x80\xbb", 3, 0x203B}, /* (REFERENCE MARK) */
    {(lxb_char_t *) "\xe3\x80\x92", 3, 0x3012}, /* (POSTAL MARK) */
    {(lxb_char_t *) "\xe2\x86\x92", 3, 0x2192}, /* (RIGHTWARDS ARROW) */
    {(lxb_char_t *) "\xe2\x86\x90", 3, 0x2190}, /* (LEFTWARDS ARROW) */
    {(lxb_char_t *) "\xe2\x86\x91", 3, 0x2191}, /* (UPWARDS ARROW) */
    {(lxb_char_t *) "\xe2\x86\x93", 3, 0x2193}, /* (DOWNWARDS ARROW) */
    {(lxb_char_t *) "\xe3\x80\x93", 3, 0x3013}, /* (GETA MARK) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x88\x88", 3, 0x2208}, /* (ELEMENT OF) */
    {(lxb_char_t *) "\xe2\x88\x8b", 3, 0x220B}, /* (CONTAINS AS MEMBER) */
    {(lxb_char_t *) "\xe2\x8a\x86", 3, 0x2286}, /* (SUBSET OF OR EQUAL TO) */
    {(lxb_char_t *) "\xe2\x8a\x87", 3, 0x2287}, /* (SUPERSET OF OR EQUAL TO) */
    {(lxb_char_t *) "\xe2\x8a\x82", 3, 0x2282}, /* (SUBSET OF) */
    {(lxb_char_t *) "\xe2\x8a\x83", 3, 0x2283}, /* (SUPERSET OF) */
    {(lxb_char_t *) "\xe2\x88\xaa", 3, 0x222A}, /* (UNION) */
    {(lxb_char_t *) "\xe2\x88\xa9", 3, 0x2229}, /* (INTERSECTION) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x88\xa7", 3, 0x2227}, /* (LOGICAL AND) */
    {(lxb_char_t *) "\xe2\x88\xa8", 3, 0x2228}, /* (LOGICAL OR) */
    {(lxb_char_t *) "\xef\xbf\xa2", 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {(lxb_char_t *) "\xe2\x87\x92", 3, 0x21D2}, /* (RIGHTWARDS DOUBLE ARROW) */
    {(lxb_char_t *) "\xe2\x87\x94", 3, 0x21D4}, /* (LEFT RIGHT DOUBLE ARROW) */
    {(lxb_char_t *) "\xe2\x88\x80", 3, 0x2200}, /* (FOR ALL) */
    {(lxb_char_t *) "\xe2\x88\x83", 3, 0x2203}, /* (THERE EXISTS) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x88\xa0", 3, 0x2220}, /* (ANGLE) */
    {(lxb_char_t *) "\xe2\x8a\xa5", 3, 0x22A5}, /* (UP TACK) */
    {(lxb_char_t *) "\xe2\x8c\x92", 3, 0x2312}, /* (ARC) */
    {(lxb_char_t *) "\xe2\x88\x82", 3, 0x2202}, /* (PARTIAL DIFFERENTIAL) */
    {(lxb_char_t *) "\xe2\x88\x87", 3, 0x2207}, /* (NABLA) */
    {(lxb_char_t *) "\xe2\x89\xa1", 3, 0x2261}, /* (IDENTICAL TO) */
    {(lxb_char_t *) "\xe2\x89\x92", 3, 0x2252}, /* (APPROXIMATELY EQUAL TO OR THE IMAGE OF) */
    {(lxb_char_t *) "\xe2\x89\xaa", 3, 0x226A}, /* (MUCH LESS-THAN) */
    {(lxb_char_t *) "\xe2\x89\xab", 3, 0x226B}, /* (MUCH GREATER-THAN) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xe2\x88\xbd", 3, 0x223D}, /* (REVERSED TILDE) */
    {(lxb_char_t *) "\xe2\x88\x9d", 3, 0x221D}, /* (PROPORTIONAL TO) */
    {(lxb_char_t *) "\xe2\x88\xb5", 3, 0x2235}, /* (BECAUSE) */
    {(lxb_char_t *) "\xe2\x88\xab", 3, 0x222B}, /* (INTEGRAL) */
    {(lxb_char_t *) "\xe2\x88\xac", 3, 0x222C}, /* (DOUBLE INTEGRAL) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x84\xab", 3, 0x212B}, /* (ANGSTROM SIGN) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xe2\x99\xaf", 3, 0x266F}, /* (MUSIC SHARP SIGN) */
    {(lxb_char_t *) "\xe2\x99\xad", 3, 0x266D}, /* (MUSIC FLAT SIGN) */
    {(lxb_char_t *) "\xe2\x99\xaa", 3, 0x266A}, /* (EIGHTH NOTE) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x97\xaf", 3, 0x25EF}, /* (LARGE CIRCLE) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xef\xbc\x90", 3, 0xFF10}, /* (FULLWIDTH DIGIT ZERO) */
    {(lxb_char_t *) "\xef\xbc\x91", 3, 0xFF11}, /* (FULLWIDTH DIGIT ONE) */
    {(lxb_char_t *) "\xef\xbc\x92", 3, 0xFF12}, /* (FULLWIDTH DIGIT TWO) */
    {(lxb_char_t *) "\xef\xbc\x93", 3, 0xFF13}, /* (FULLWIDTH DIGIT THREE) */
    {(lxb_char_t *) "\xef\xbc\x94", 3, 0xFF14}, /* (FULLWIDTH DIGIT FOUR) */
    {(lxb_char_t *) "\xef\xbc\x95", 3, 0xFF15}, /* (FULLWIDTH DIGIT FIVE) */
    {(lxb_char_t *) "\xef\xbc\x96", 3, 0xFF16}, /* (FULLWIDTH DIGIT SIX) */
    {(lxb_char_t *) "\xef\xbc\x97", 3, 0xFF17}, /* (FULLWIDTH DIGIT SEVEN) */
    {(lxb_char_t *) "\xef\xbc\x98", 3, 0xFF18}, /* (FULLWIDTH DIGIT EIGHT) */
    {(lxb_char_t *) "\xef\xbc\x99", 3, 0xFF19}, /* (FULLWIDTH DIGIT NINE) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xef\xbc\xa1", 3, 0xFF21}, /* (FULLWIDTH LATIN CAPITAL LETTER A) */
    {(lxb_char_t *) "\xef\xbc\xa2", 3, 0xFF22}, /* (FULLWIDTH LATIN CAPITAL LETTER B) */
    {(lxb_char_t *) "\xef\xbc\xa3", 3, 0xFF23}, /* (FULLWIDTH LATIN CAPITAL LETTER C) */
    {(lxb_char_t *) "\xef\xbc\xa4", 3, 0xFF24}, /* (FULLWIDTH LATIN CAPITAL LETTER D) */
    {(lxb_char_t *) "\xef\xbc\xa5", 3, 0xFF25}, /* (FULLWIDTH LATIN CAPITAL LETTER E) */
    {(lxb_char_t *) "\xef\xbc\xa6", 3, 0xFF26}, /* (FULLWIDTH LATIN CAPITAL LETTER F) */
    {(lxb_char_t *) "\xef\xbc\xa7", 3, 0xFF27}, /* (FULLWIDTH LATIN CAPITAL LETTER G) */
    {(lxb_char_t *) "\xef\xbc\xa8", 3, 0xFF28}, /* (FULLWIDTH LATIN CAPITAL LETTER H) */
    {(lxb_char_t *) "\xef\xbc\xa9", 3, 0xFF29}, /* (FULLWIDTH LATIN CAPITAL LETTER I) */
    {(lxb_char_t *) "\xef\xbc\xaa", 3, 0xFF2A}, /* (FULLWIDTH LATIN CAPITAL LETTER J) */
    {(lxb_char_t *) "\xef\xbc\xab", 3, 0xFF2B}, /* (FULLWIDTH LATIN CAPITAL LETTER K) */
    {(lxb_char_t *) "\xef\xbc\xac", 3, 0xFF2C}, /* (FULLWIDTH LATIN CAPITAL LETTER L) */
    {(lxb_char_t *) "\xef\xbc\xad", 3, 0xFF2D}, /* (FULLWIDTH LATIN CAPITAL LETTER M) */
    {(lxb_char_t *) "\xef\xbc\xae", 3, 0xFF2E}, /* (FULLWIDTH LATIN CAPITAL LETTER N) */
    {(lxb_char_t *) "\xef\xbc\xaf", 3, 0xFF2F}, /* (FULLWIDTH LATIN CAPITAL LETTER O) */
    {(lxb_char_t *) "\xef\xbc\xb0", 3, 0xFF30}, /* (FULLWIDTH LATIN CAPITAL LETTER P) */
    {(lxb_char_t *) "\xef\xbc\xb1", 3, 0xFF31}, /* (FULLWIDTH LATIN CAPITAL LETTER Q) */
    {(lxb_char_t *) "\xef\xbc\xb2", 3, 0xFF32}, /* (FULLWIDTH LATIN CAPITAL LETTER R) */
    {(lxb_char_t *) "\xef\xbc\xb3", 3, 0xFF33}, /* (FULLWIDTH LATIN CAPITAL LETTER S) */
    {(lxb_char_t *) "\xef\xbc\xb4", 3, 0xFF34}, /* (FULLWIDTH LATIN CAPITAL LETTER T) */
    {(lxb_char_t *) "\xef\xbc\xb5", 3, 0xFF35}, /* (FULLWIDTH LATIN CAPITAL LETTER U) */
    {(lxb_char_t *) "\xef\xbc\xb6", 3, 0xFF36}, /* (FULLWIDTH LATIN CAPITAL LETTER V) */
    {(lxb_char_t *) "\xef\xbc\xb7", 3, 0xFF37}, /* (FULLWIDTH LATIN CAPITAL LETTER W) */
    {(lxb_char_t *) "\xef\xbc\xb8", 3, 0xFF38}, /* (FULLWIDTH LATIN CAPITAL LETTER X) */
    {(lxb_char_t *) "\xef\xbc\xb9", 3, 0xFF39}, /* (FULLWIDTH LATIN CAPITAL LETTER Y) */
    {(lxb_char_t *) "\xef\xbc\xba", 3, 0xFF3A}, /* (FULLWIDTH LATIN CAPITAL LETTER Z) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xef\xbd\x81", 3, 0xFF41}, /* (FULLWIDTH LATIN SMALL LETTER A) */
    {(lxb_char_t *) "\xef\xbd\x82", 3, 0xFF42}, /* (FULLWIDTH LATIN SMALL LETTER B) */
    {(lxb_char_t *) "\xef\xbd\x83", 3, 0xFF43}, /* (FULLWIDTH LATIN SMALL LETTER C) */
    {(lxb_char_t *) "\xef\xbd\x84", 3, 0xFF44}, /* (FULLWIDTH LATIN SMALL LETTER D) */
    {(lxb_char_t *) "\xef\xbd\x85", 3, 0xFF45}, /* (FULLWIDTH LATIN SMALL LETTER E) */
    {(lxb_char_t *) "\xef\xbd\x86", 3, 0xFF46}, /* (FULLWIDTH LATIN SMALL LETTER F) */
    {(lxb_char_t *) "\xef\xbd\x87", 3, 0xFF47}, /* (FULLWIDTH LATIN SMALL LETTER G) */
    {(lxb_char_t *) "\xef\xbd\x88", 3, 0xFF48}, /* (FULLWIDTH LATIN SMALL LETTER H) */
    {(lxb_char_t *) "\xef\xbd\x89", 3, 0xFF49}, /* (FULLWIDTH LATIN SMALL LETTER I) */
    {(lxb_char_t *) "\xef\xbd\x8a", 3, 0xFF4A}, /* (FULLWIDTH LATIN SMALL LETTER J) */
    {(lxb_char_t *) "\xef\xbd\x8b", 3, 0xFF4B}, /* (FULLWIDTH LATIN SMALL LETTER K) */
    {(lxb_char_t *) "\xef\xbd\x8c", 3, 0xFF4C}, /* (FULLWIDTH LATIN SMALL LETTER L) */
    {(lxb_char_t *) "\xef\xbd\x8d", 3, 0xFF4D}, /* (FULLWIDTH LATIN SMALL LETTER M) */
    {(lxb_char_t *) "\xef\xbd\x8e", 3, 0xFF4E}, /* (FULLWIDTH LATIN SMALL LETTER N) */
    {(lxb_char_t *) "\xef\xbd\x8f", 3, 0xFF4F}, /* (FULLWIDTH LATIN SMALL LETTER O) */
    {(lxb_char_t *) "\xef\xbd\x90", 3, 0xFF50}, /* (FULLWIDTH LATIN SMALL LETTER P) */
    {(lxb_char_t *) "\xef\xbd\x91", 3, 0xFF51}, /* (FULLWIDTH LATIN SMALL LETTER Q) */
    {(lxb_char_t *) "\xef\xbd\x92", 3, 0xFF52}, /* (FULLWIDTH LATIN SMALL LETTER R) */
    {(lxb_char_t *) "\xef\xbd\x93", 3, 0xFF53}, /* (FULLWIDTH LATIN SMALL LETTER S) */
    {(lxb_char_t *) "\xef\xbd\x94", 3, 0xFF54}, /* (FULLWIDTH LATIN SMALL LETTER T) */
    {(lxb_char_t *) "\xef\xbd\x95", 3, 0xFF55}, /* (FULLWIDTH LATIN SMALL LETTER U) */
    {(lxb_char_t *) "\xef\xbd\x96", 3, 0xFF56}, /* (FULLWIDTH LATIN SMALL LETTER V) */
    {(lxb_char_t *) "\xef\xbd\x97", 3, 0xFF57}, /* (FULLWIDTH LATIN SMALL LETTER W) */
    {(lxb_char_t *) "\xef\xbd\x98", 3, 0xFF58}, /* (FULLWIDTH LATIN SMALL LETTER X) */
    {(lxb_char_t *) "\xef\xbd\x99", 3, 0xFF59}, /* (FULLWIDTH LATIN SMALL LETTER Y) */
    {(lxb_char_t *) "\xef\xbd\x9a", 3, 0xFF5A}, /* (FULLWIDTH LATIN SMALL LETTER Z) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe3\x81\x81", 3, 0x3041}, /* (HIRAGANA LETTER SMALL A) */
    {(lxb_char_t *) "\xe3\x81\x82", 3, 0x3042}, /* (HIRAGANA LETTER A) */
    {(lxb_char_t *) "\xe3\x81\x83", 3, 0x3043}, /* (HIRAGANA LETTER SMALL I) */
    {(lxb_char_t *) "\xe3\x81\x84", 3, 0x3044}, /* (HIRAGANA LETTER I) */
    {(lxb_char_t *) "\xe3\x81\x85", 3, 0x3045}, /* (HIRAGANA LETTER SMALL U) */
    {(lxb_char_t *) "\xe3\x81\x86", 3, 0x3046}, /* (HIRAGANA LETTER U) */
    {(lxb_char_t *) "\xe3\x81\x87", 3, 0x3047}, /* (HIRAGANA LETTER SMALL E) */
    {(lxb_char_t *) "\xe3\x81\x88", 3, 0x3048}, /* (HIRAGANA LETTER E) */
    {(lxb_char_t *) "\xe3\x81\x89", 3, 0x3049}, /* (HIRAGANA LETTER SMALL O) */
    {(lxb_char_t *) "\xe3\x81\x8a", 3, 0x304A}, /* (HIRAGANA LETTER O) */
    {(lxb_char_t *) "\xe3\x81\x8b", 3, 0x304B}, /* (HIRAGANA LETTER KA) */
    {(lxb_char_t *) "\xe3\x81\x8c", 3, 0x304C}, /* (HIRAGANA LETTER GA) */
    {(lxb_char_t *) "\xe3\x81\x8d", 3, 0x304D}, /* (HIRAGANA LETTER KI) */
    {(lxb_char_t *) "\xe3\x81\x8e", 3, 0x304E}, /* (HIRAGANA LETTER GI) */
    {(lxb_char_t *) "\xe3\x81\x8f", 3, 0x304F}, /* (HIRAGANA LETTER KU) */
    {(lxb_char_t *) "\xe3\x81\x90", 3, 0x3050}, /* (HIRAGANA LETTER GU) */
    {(lxb_char_t *) "\xe3\x81\x91", 3, 0x3051}, /* (HIRAGANA LETTER KE) */
    {(lxb_char_t *) "\xe3\x81\x92", 3, 0x3052}, /* (HIRAGANA LETTER GE) */
    {(lxb_char_t *) "\xe3\x81\x93", 3, 0x3053}, /* (HIRAGANA LETTER KO) */
    {(lxb_char_t *) "\xe3\x81\x94", 3, 0x3054}, /* (HIRAGANA LETTER GO) */
    {(lxb_char_t *) "\xe3\x81\x95", 3, 0x3055}, /* (HIRAGANA LETTER SA) */
    {(lxb_char_t *) "\xe3\x81\x96", 3, 0x3056}, /* (HIRAGANA LETTER ZA) */
    {(lxb_char_t *) "\xe3\x81\x97", 3, 0x3057}, /* (HIRAGANA LETTER SI) */
    {(lxb_char_t *) "\xe3\x81\x98", 3, 0x3058}, /* (HIRAGANA LETTER ZI) */
    {(lxb_char_t *) "\xe3\x81\x99", 3, 0x3059}, /* (HIRAGANA LETTER SU) */
    {(lxb_char_t *) "\xe3\x81\x9a", 3, 0x305A}, /* (HIRAGANA LETTER ZU) */
    {(lxb_char_t *) "\xe3\x81\x9b", 3, 0x305B}, /* (HIRAGANA LETTER SE) */
    {(lxb_char_t *) "\xe3\x81\x9c", 3, 0x305C}, /* (HIRAGANA LETTER ZE) */
    {(lxb_char_t *) "\xe3\x81\x9d", 3, 0x305D}, /* (HIRAGANA LETTER SO) */
    {(lxb_char_t *) "\xe3\x81\x9e", 3, 0x305E}, /* (HIRAGANA LETTER ZO) */
    {(lxb_char_t *) "\xe3\x81\x9f", 3, 0x305F}, /* (HIRAGANA LETTER TA) */
    {(lxb_char_t *) "\xe3\x81\xa0", 3, 0x3060}, /* (HIRAGANA LETTER DA) */
    {(lxb_char_t *) "\xe3\x81\xa1", 3, 0x3061}, /* (HIRAGANA LETTER TI) */
    {(lxb_char_t *) "\xe3\x81\xa2", 3, 0x3062}, /* (HIRAGANA LETTER DI) */
    {(lxb_char_t *) "\xe3\x81\xa3", 3, 0x3063}, /* (HIRAGANA LETTER SMALL TU) */
    {(lxb_char_t *) "\xe3\x81\xa4", 3, 0x3064}, /* (HIRAGANA LETTER TU) */
    {(lxb_char_t *) "\xe3\x81\xa5", 3, 0x3065}, /* (HIRAGANA LETTER DU) */
    {(lxb_char_t *) "\xe3\x81\xa6", 3, 0x3066}, /* (HIRAGANA LETTER TE) */
    {(lxb_char_t *) "\xe3\x81\xa7", 3, 0x3067}, /* (HIRAGANA LETTER DE) */
    {(lxb_char_t *) "\xe3\x81\xa8", 3, 0x3068}, /* (HIRAGANA LETTER TO) */
    {(lxb_char_t *) "\xe3\x81\xa9", 3, 0x3069}, /* (HIRAGANA LETTER DO) */
    {(lxb_char_t *) "\xe3\x81\xaa", 3, 0x306A}, /* (HIRAGANA LETTER NA) */
    {(lxb_char_t *) "\xe3\x81\xab", 3, 0x306B}, /* (HIRAGANA LETTER NI) */
    {(lxb_char_t *) "\xe3\x81\xac", 3, 0x306C}, /* (HIRAGANA LETTER NU) */
    {(lxb_char_t *) "\xe3\x81\xad", 3, 0x306D}, /* (HIRAGANA LETTER NE) */
    {(lxb_char_t *) "\xe3\x81\xae", 3, 0x306E}, /* (HIRAGANA LETTER NO) */
    {(lxb_char_t *) "\xe3\x81\xaf", 3, 0x306F}, /* (HIRAGANA LETTER HA) */
    {(lxb_char_t *) "\xe3\x81\xb0", 3, 0x3070}, /* (HIRAGANA LETTER BA) */
    {(lxb_char_t *) "\xe3\x81\xb1", 3, 0x3071}, /* (HIRAGANA LETTER PA) */
    {(lxb_char_t *) "\xe3\x81\xb2", 3, 0x3072}, /* (HIRAGANA LETTER HI) */
    {(lxb_char_t *) "\xe3\x81\xb3", 3, 0x3073}, /* (HIRAGANA LETTER BI) */
    {(lxb_char_t *) "\xe3\x81\xb4", 3, 0x3074}, /* (HIRAGANA LETTER PI) */
    {(lxb_char_t *) "\xe3\x81\xb5", 3, 0x3075}, /* (HIRAGANA LETTER HU) */
    {(lxb_char_t *) "\xe3\x81\xb6", 3, 0x3076}, /* (HIRAGANA LETTER BU) */
    {(lxb_char_t *) "\xe3\x81\xb7", 3, 0x3077}, /* (HIRAGANA LETTER PU) */
    {(lxb_char_t *) "\xe3\x81\xb8", 3, 0x3078}, /* (HIRAGANA LETTER HE) */
    {(lxb_char_t *) "\xe3\x81\xb9", 3, 0x3079}, /* (HIRAGANA LETTER BE) */
    {(lxb_char_t *) "\xe3\x81\xba", 3, 0x307A}, /* (HIRAGANA LETTER PE) */
    {(lxb_char_t *) "\xe3\x81\xbb", 3, 0x307B}, /* (HIRAGANA LETTER HO) */
    {(lxb_char_t *) "\xe3\x81\xbc", 3, 0x307C}, /* (HIRAGANA LETTER BO) */
    {(lxb_char_t *) "\xe3\x81\xbd", 3, 0x307D}, /* (HIRAGANA LETTER PO) */
    {(lxb_char_t *) "\xe3\x81\xbe", 3, 0x307E}, /* (HIRAGANA LETTER MA) */
    {(lxb_char_t *) "\xe3\x81\xbf", 3, 0x307F}, /* (HIRAGANA LETTER MI) */
    {(lxb_char_t *) "\xe3\x82\x80", 3, 0x3080}, /* (HIRAGANA LETTER MU) */
    {(lxb_char_t *) "\xe3\x82\x81", 3, 0x3081}, /* (HIRAGANA LETTER ME) */
    {(lxb_char_t *) "\xe3\x82\x82", 3, 0x3082}, /* (HIRAGANA LETTER MO) */
    {(lxb_char_t *) "\xe3\x82\x83", 3, 0x3083}, /* (HIRAGANA LETTER SMALL YA) */
    {(lxb_char_t *) "\xe3\x82\x84", 3, 0x3084}, /* (HIRAGANA LETTER YA) */
    {(lxb_char_t *) "\xe3\x82\x85", 3, 0x3085}, /* (HIRAGANA LETTER SMALL YU) */
    {(lxb_char_t *) "\xe3\x82\x86", 3, 0x3086}, /* (HIRAGANA LETTER YU) */
    {(lxb_char_t *) "\xe3\x82\x87", 3, 0x3087}, /* (HIRAGANA LETTER SMALL YO) */
    {(lxb_char_t *) "\xe3\x82\x88", 3, 0x3088}, /* (HIRAGANA LETTER YO) */
    {(lxb_char_t *) "\xe3\x82\x89", 3, 0x3089}, /* (HIRAGANA LETTER RA) */
    {(lxb_char_t *) "\xe3\x82\x8a", 3, 0x308A}, /* (HIRAGANA LETTER RI) */
    {(lxb_char_t *) "\xe3\x82\x8b", 3, 0x308B}, /* (HIRAGANA LETTER RU) */
    {(lxb_char_t *) "\xe3\x82\x8c", 3, 0x308C}, /* (HIRAGANA LETTER RE) */
    {(lxb_char_t *) "\xe3\x82\x8d", 3, 0x308D}, /* (HIRAGANA LETTER RO) */
    {(lxb_char_t *) "\xe3\x82\x8e", 3, 0x308E}, /* (HIRAGANA LETTER SMALL WA) */
    {(lxb_char_t *) "\xe3\x82\x8f", 3, 0x308F}, /* (HIRAGANA LETTER WA) */
    {(lxb_char_t *) "\xe3\x82\x90", 3, 0x3090}, /* (HIRAGANA LETTER WI) */
    {(lxb_char_t *) "\xe3\x82\x91", 3, 0x3091}, /* (HIRAGANA LETTER WE) */
    {(lxb_char_t *) "\xe3\x82\x92", 3, 0x3092}, /* (HIRAGANA LETTER WO) */
    {(lxb_char_t *) "\xe3\x82\x93", 3, 0x3093}, /* (HIRAGANA LETTER N) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe3\x82\xa1", 3, 0x30A1}, /* (KATAKANA LETTER SMALL A) */
    {(lxb_char_t *) "\xe3\x82\xa2", 3, 0x30A2}, /* (KATAKANA LETTER A) */
    {(lxb_char_t *) "\xe3\x82\xa3", 3, 0x30A3}, /* (KATAKANA LETTER SMALL I) */
    {(lxb_char_t *) "\xe3\x82\xa4", 3, 0x30A4}, /* (KATAKANA LETTER I) */
    {(lxb_char_t *) "\xe3\x82\xa5", 3, 0x30A5}, /* (KATAKANA LETTER SMALL U) */
    {(lxb_char_t *) "\xe3\x82\xa6", 3, 0x30A6}, /* (KATAKANA LETTER U) */
    {(lxb_char_t *) "\xe3\x82\xa7", 3, 0x30A7}, /* (KATAKANA LETTER SMALL E) */
    {(lxb_char_t *) "\xe3\x82\xa8", 3, 0x30A8}, /* (KATAKANA LETTER E) */
    {(lxb_char_t *) "\xe3\x82\xa9", 3, 0x30A9}, /* (KATAKANA LETTER SMALL O) */
    {(lxb_char_t *) "\xe3\x82\xaa", 3, 0x30AA}, /* (KATAKANA LETTER O) */
    {(lxb_char_t *) "\xe3\x82\xab", 3, 0x30AB}, /* (KATAKANA LETTER KA) */
    {(lxb_char_t *) "\xe3\x82\xac", 3, 0x30AC}, /* (KATAKANA LETTER GA) */
    {(lxb_char_t *) "\xe3\x82\xad", 3, 0x30AD}, /* (KATAKANA LETTER KI) */
    {(lxb_char_t *) "\xe3\x82\xae", 3, 0x30AE}, /* (KATAKANA LETTER GI) */
    {(lxb_char_t *) "\xe3\x82\xaf", 3, 0x30AF}, /* (KATAKANA LETTER KU) */
    {(lxb_char_t *) "\xe3\x82\xb0", 3, 0x30B0}, /* (KATAKANA LETTER GU) */
    {(lxb_char_t *) "\xe3\x82\xb1", 3, 0x30B1}, /* (KATAKANA LETTER KE) */
    {(lxb_char_t *) "\xe3\x82\xb2", 3, 0x30B2}, /* (KATAKANA LETTER GE) */
    {(lxb_char_t *) "\xe3\x82\xb3", 3, 0x30B3}, /* (KATAKANA LETTER KO) */
    {(lxb_char_t *) "\xe3\x82\xb4", 3, 0x30B4}, /* (KATAKANA LETTER GO) */
    {(lxb_char_t *) "\xe3\x82\xb5", 3, 0x30B5}, /* (KATAKANA LETTER SA) */
    {(lxb_char_t *) "\xe3\x82\xb6", 3, 0x30B6}, /* (KATAKANA LETTER ZA) */
    {(lxb_char_t *) "\xe3\x82\xb7", 3, 0x30B7}, /* (KATAKANA LETTER SI) */
    {(lxb_char_t *) "\xe3\x82\xb8", 3, 0x30B8}, /* (KATAKANA LETTER ZI) */
    {(lxb_char_t *) "\xe3\x82\xb9", 3, 0x30B9}, /* (KATAKANA LETTER SU) */
    {(lxb_char_t *) "\xe3\x82\xba", 3, 0x30BA}, /* (KATAKANA LETTER ZU) */
    {(lxb_char_t *) "\xe3\x82\xbb", 3, 0x30BB}, /* (KATAKANA LETTER SE) */
    {(lxb_char_t *) "\xe3\x82\xbc", 3, 0x30BC}, /* (KATAKANA LETTER ZE) */
    {(lxb_char_t *) "\xe3\x82\xbd", 3, 0x30BD}, /* (KATAKANA LETTER SO) */
    {(lxb_char_t *) "\xe3\x82\xbe", 3, 0x30BE}, /* (KATAKANA LETTER ZO) */
    {(lxb_char_t *) "\xe3\x82\xbf", 3, 0x30BF}, /* (KATAKANA LETTER TA) */
    {(lxb_char_t *) "\xe3\x83\x80", 3, 0x30C0}, /* (KATAKANA LETTER DA) */
    {(lxb_char_t *) "\xe3\x83\x81", 3, 0x30C1}, /* (KATAKANA LETTER TI) */
    {(lxb_char_t *) "\xe3\x83\x82", 3, 0x30C2}, /* (KATAKANA LETTER DI) */
    {(lxb_char_t *) "\xe3\x83\x83", 3, 0x30C3}, /* (KATAKANA LETTER SMALL TU) */
    {(lxb_char_t *) "\xe3\x83\x84", 3, 0x30C4}, /* (KATAKANA LETTER TU) */
    {(lxb_char_t *) "\xe3\x83\x85", 3, 0x30C5}, /* (KATAKANA LETTER DU) */
    {(lxb_char_t *) "\xe3\x83\x86", 3, 0x30C6}, /* (KATAKANA LETTER TE) */
    {(lxb_char_t *) "\xe3\x83\x87", 3, 0x30C7}, /* (KATAKANA LETTER DE) */
    {(lxb_char_t *) "\xe3\x83\x88", 3, 0x30C8}, /* (KATAKANA LETTER TO) */
    {(lxb_char_t *) "\xe3\x83\x89", 3, 0x30C9}, /* (KATAKANA LETTER DO) */
    {(lxb_char_t *) "\xe3\x83\x8a", 3, 0x30CA}, /* (KATAKANA LETTER NA) */
    {(lxb_char_t *) "\xe3\x83\x8b", 3, 0x30CB}, /* (KATAKANA LETTER NI) */
    {(lxb_char_t *) "\xe3\x83\x8c", 3, 0x30CC}, /* (KATAKANA LETTER NU) */
    {(lxb_char_t *) "\xe3\x83\x8d", 3, 0x30CD}, /* (KATAKANA LETTER NE) */
    {(lxb_char_t *) "\xe3\x83\x8e", 3, 0x30CE}, /* (KATAKANA LETTER NO) */
    {(lxb_char_t *) "\xe3\x83\x8f", 3, 0x30CF}, /* (KATAKANA LETTER HA) */
    {(lxb_char_t *) "\xe3\x83\x90", 3, 0x30D0}, /* (KATAKANA LETTER BA) */
    {(lxb_char_t *) "\xe3\x83\x91", 3, 0x30D1}, /* (KATAKANA LETTER PA) */
    {(lxb_char_t *) "\xe3\x83\x92", 3, 0x30D2}, /* (KATAKANA LETTER HI) */
    {(lxb_char_t *) "\xe3\x83\x93", 3, 0x30D3}, /* (KATAKANA LETTER BI) */
    {(lxb_char_t *) "\xe3\x83\x94", 3, 0x30D4}, /* (KATAKANA LETTER PI) */
    {(lxb_char_t *) "\xe3\x83\x95", 3, 0x30D5}, /* (KATAKANA LETTER HU) */
    {(lxb_char_t *) "\xe3\x83\x96", 3, 0x30D6}, /* (KATAKANA LETTER BU) */
    {(lxb_char_t *) "\xe3\x83\x97", 3, 0x30D7}, /* (KATAKANA LETTER PU) */
    {(lxb_char_t *) "\xe3\x83\x98", 3, 0x30D8}, /* (KATAKANA LETTER HE) */
    {(lxb_char_t *) "\xe3\x83\x99", 3, 0x30D9}, /* (KATAKANA LETTER BE) */
    {(lxb_char_t *) "\xe3\x83\x9a", 3, 0x30DA}, /* (KATAKANA LETTER PE) */
    {(lxb_char_t *) "\xe3\x83\x9b", 3, 0x30DB}, /* (KATAKANA LETTER HO) */
    {(lxb_char_t *) "\xe3\x83\x9c", 3, 0x30DC}, /* (KATAKANA LETTER BO) */
    {(lxb_char_t *) "\xe3\x83\x9d", 3, 0x30DD}, /* (KATAKANA LETTER PO) */
    {(lxb_char_t *) "\xe3\x83\x9e", 3, 0x30DE}, /* (KATAKANA LETTER MA) */
    {(lxb_char_t *) "\xe3\x83\x9f", 3, 0x30DF}, /* (KATAKANA LETTER MI) */
    {(lxb_char_t *) "\xe3\x83\xa0", 3, 0x30E0}, /* (KATAKANA LETTER MU) */
    {(lxb_char_t *) "\xe3\x83\xa1", 3, 0x30E1}, /* (KATAKANA LETTER ME) */
    {(lxb_char_t *) "\xe3\x83\xa2", 3, 0x30E2}, /* (KATAKANA LETTER MO) */
    {(lxb_char_t *) "\xe3\x83\xa3", 3, 0x30E3}, /* (KATAKANA LETTER SMALL YA) */
    {(lxb_char_t *) "\xe3\x83\xa4", 3, 0x30E4}, /* (KATAKANA LETTER YA) */
    {(lxb_char_t *) "\xe3\x83\xa5", 3, 0x30E5}, /* (KATAKANA LETTER SMALL YU) */
    {(lxb_char_t *) "\xe3\x83\xa6", 3, 0x30E6}, /* (KATAKANA LETTER YU) */
    {(lxb_char_t *) "\xe3\x83\xa7", 3, 0x30E7}, /* (KATAKANA LETTER SMALL YO) */
    {(lxb_char_t *) "\xe3\x83\xa8", 3, 0x30E8}, /* (KATAKANA LETTER YO) */
    {(lxb_char_t *) "\xe3\x83\xa9", 3, 0x30E9}, /* (KATAKANA LETTER RA) */
    {(lxb_char_t *) "\xe3\x83\xaa", 3, 0x30EA}, /* (KATAKANA LETTER RI) */
    {(lxb_char_t *) "\xe3\x83\xab", 3, 0x30EB}, /* (KATAKANA LETTER RU) */
    {(lxb_char_t *) "\xe3\x83\xac", 3, 0x30EC}, /* (KATAKANA LETTER RE) */
    {(lxb_char_t *) "\xe3\x83\xad", 3, 0x30ED}, /* (KATAKANA LETTER RO) */
    {(lxb_char_t *) "\xe3\x83\xae", 3, 0x30EE}, /* (KATAKANA LETTER SMALL WA) */
    {(lxb_char_t *) "\xe3\x83\xaf", 3, 0x30EF}, /* (KATAKANA LETTER WA) */
    {(lxb_char_t *) "\xe3\x83\xb0", 3, 0x30F0}, /* (KATAKANA LETTER WI) */
    {(lxb_char_t *) "\xe3\x83\xb1", 3, 0x30F1}, /* (KATAKANA LETTER WE) */
    {(lxb_char_t *) "\xe3\x83\xb2", 3, 0x30F2}, /* (KATAKANA LETTER WO) */
    {(lxb_char_t *) "\xe3\x83\xb3", 3, 0x30F3}, /* (KATAKANA LETTER N) */
    {(lxb_char_t *) "\xe3\x83\xb4", 3, 0x30F4}, /* (KATAKANA LETTER VU) */
    {(lxb_char_t *) "\xe3\x83\xb5", 3, 0x30F5}, /* (KATAKANA LETTER SMALL KA) */
    {(lxb_char_t *) "\xe3\x83\xb6", 3, 0x30F6}, /* (KATAKANA LETTER SMALL KE) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xce\x91", 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {(lxb_char_t *) "\xce\x92", 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {(lxb_char_t *) "\xce\x93", 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {(lxb_char_t *) "\xce\x94", 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {(lxb_char_t *) "\xce\x95", 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {(lxb_char_t *) "\xce\x96", 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {(lxb_char_t *) "\xce\x97", 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {(lxb_char_t *) "\xce\x98", 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {(lxb_char_t *) "\xce\x99", 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {(lxb_char_t *) "\xce\x9a", 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {(lxb_char_t *) "\xce\x9b", 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {(lxb_char_t *) "\xce\x9c", 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {(lxb_char_t *) "\xce\x9d", 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {(lxb_char_t *) "\xce\x9e", 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {(lxb_char_t *) "\xce\x9f", 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {(lxb_char_t *) "\xce\xa0", 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {(lxb_char_t *) "\xce\xa1", 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {(lxb_char_t *) "\xce\xa3", 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {(lxb_char_t *) "\xce\xa4", 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {(lxb_char_t *) "\xce\xa5", 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {(lxb_char_t *) "\xce\xa6", 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {(lxb_char_t *) "\xce\xa7", 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {(lxb_char_t *) "\xce\xa8", 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {(lxb_char_t *) "\xce\xa9", 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xce\xb1", 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {(lxb_char_t *) "\xce\xb2", 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {(lxb_char_t *) "\xce\xb3", 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {(lxb_char_t *) "\xce\xb4", 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {(lxb_char_t *) "\xce\xb5", 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {(lxb_char_t *) "\xce\xb6", 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {(lxb_char_t *) "\xce\xb7", 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {(lxb_char_t *) "\xce\xb8", 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {(lxb_char_t *) "\xce\xb9", 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {(lxb_char_t *) "\xce\xba", 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {(lxb_char_t *) "\xce\xbb", 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {(lxb_char_t *) "\xce\xbc", 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {(lxb_char_t *) "\xce\xbd", 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {(lxb_char_t *) "\xce\xbe", 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {(lxb_char_t *) "\xce\xbf", 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {(lxb_char_t *) "\xcf\x80", 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {(lxb_char_t *) "\xcf\x81", 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {(lxb_char_t *) "\xcf\x83", 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {(lxb_char_t *) "\xcf\x84", 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {(lxb_char_t *) "\xcf\x85", 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {(lxb_char_t *) "\xcf\x86", 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {(lxb_char_t *) "\xcf\x87", 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {(lxb_char_t *) "\xcf\x88", 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {(lxb_char_t *) "\xcf\x89", 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x94\x80", 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\x82", 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {(lxb_char_t *) "\xe2\x94\x8c", 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x90", 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x98", 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x94", 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x9c", 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\xac", 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xa4", 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\xb4", 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xbc", 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\x81", 3, 0x2501}, /* (BOX DRAWINGS HEAVY HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\x83", 3, 0x2503}, /* (BOX DRAWINGS HEAVY VERTICAL) */
    {(lxb_char_t *) "\xe2\x94\x8f", 3, 0x250F}, /* (BOX DRAWINGS HEAVY DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x93", 3, 0x2513}, /* (BOX DRAWINGS HEAVY DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x9b", 3, 0x251B}, /* (BOX DRAWINGS HEAVY UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x97", 3, 0x2517}, /* (BOX DRAWINGS HEAVY UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\xa3", 3, 0x2523}, /* (BOX DRAWINGS HEAVY VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\xb3", 3, 0x2533}, /* (BOX DRAWINGS HEAVY DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xab", 3, 0x252B}, /* (BOX DRAWINGS HEAVY VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\xbb", 3, 0x253B}, /* (BOX DRAWINGS HEAVY UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\x8b", 3, 0x254B}, /* (BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xa0", 3, 0x2520}, /* (BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT) */
    {(lxb_char_t *) "\xe2\x94\xaf", 3, 0x252F}, /* (BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY) */
    {(lxb_char_t *) "\xe2\x94\xa8", 3, 0x2528}, /* (BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT) */
    {(lxb_char_t *) "\xe2\x94\xb7", 3, 0x2537}, /* (BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY) */
    {(lxb_char_t *) "\xe2\x94\xbf", 3, 0x253F}, /* (BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY) */
    {(lxb_char_t *) "\xe2\x94\x9d", 3, 0x251D}, /* (BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY) */
    {(lxb_char_t *) "\xe2\x94\xb0", 3, 0x2530}, /* (BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT) */
    {(lxb_char_t *) "\xe2\x94\xa5", 3, 0x2525}, /* (BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY) */
    {(lxb_char_t *) "\xe2\x94\xb8", 3, 0x2538}, /* (BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT) */
    {(lxb_char_t *) "\xe2\x95\x82", 3, 0x2542}, /* (BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x91\xa0", 3, 0x2460}, /* (CIRCLED DIGIT ONE) */
    {(lxb_char_t *) "\xe2\x91\xa1", 3, 0x2461}, /* (CIRCLED DIGIT TWO) */
    {(lxb_char_t *) "\xe2\x91\xa2", 3, 0x2462}, /* (CIRCLED DIGIT THREE) */
    {(lxb_char_t *) "\xe2\x91\xa3", 3, 0x2463}, /* (CIRCLED DIGIT FOUR) */
    {(lxb_char_t *) "\xe2\x91\xa4", 3, 0x2464}, /* (CIRCLED DIGIT FIVE) */
    {(lxb_char_t *) "\xe2\x91\xa5", 3, 0x2465}, /* (CIRCLED DIGIT SIX) */
    {(lxb_char_t *) "\xe2\x91\xa6", 3, 0x2466}, /* (CIRCLED DIGIT SEVEN) */
    {(lxb_char_t *) "\xe2\x91\xa7", 3, 0x2467}, /* (CIRCLED DIGIT EIGHT) */
    {(lxb_char_t *) "\xe2\x91\xa8", 3, 0x2468}, /* (CIRCLED DIGIT NINE) */
    {(lxb_char_t *) "\xe2\x91\xa9", 3, 0x2469}, /* (CIRCLED NUMBER TEN) */
    {(lxb_char_t *) "\xe2\x91\xaa", 3, 0x246A}, /* (CIRCLED NUMBER ELEVEN) */
    {(lxb_char_t *) "\xe2\x91\xab", 3, 0x246B}, /* (CIRCLED NUMBER TWELVE) */
    {(lxb_char_t *) "\xe2\x91\xac", 3, 0x246C}, /* (CIRCLED NUMBER THIRTEEN) */
    {(lxb_char_t *) "\xe2\x91\xad", 3, 0x246D}, /* (CIRCLED NUMBER FOURTEEN) */
    {(lxb_char_t *) "\xe2\x91\xae", 3, 0x246E}, /* (CIRCLED NUMBER FIFTEEN) */
    {(lxb_char_t *) "\xe2\x91\xaf", 3, 0x246F}, /* (CIRCLED NUMBER SIXTEEN) */
    {(lxb_char_t *) "\xe2\x91\xb0", 3, 0x2470}, /* (CIRCLED NUMBER SEVENTEEN) */
    {(lxb_char_t *) "\xe2\x91\xb1", 3, 0x2471}, /* (CIRCLED NUMBER EIGHTEEN) */
    {(lxb_char_t *) "\xe2\x91\xb2", 3, 0x2472}, /* (CIRCLED NUMBER NINETEEN) */
    {(lxb_char_t *) "\xe2\x91\xb3", 3, 0x2473}, /* (CIRCLED NUMBER TWENTY) */
    {(lxb_char_t *) "\xe2\x85\xa0", 3, 0x2160}, /* (ROMAN NUMERAL ONE) */
    {(lxb_char_t *) "\xe2\x85\xa1", 3, 0x2161}, /* (ROMAN NUMERAL TWO) */
    {(lxb_char_t *) "\xe2\x85\xa2", 3, 0x2162}, /* (ROMAN NUMERAL THREE) */
    {(lxb_char_t *) "\xe2\x85\xa3", 3, 0x2163}, /* (ROMAN NUMERAL FOUR) */
    {(lxb_char_t *) "\xe2\x85\xa4", 3, 0x2164}, /* (ROMAN NUMERAL FIVE) */
    {(lxb_char_t *) "\xe2\x85\xa5", 3, 0x2165}, /* (ROMAN NUMERAL SIX) */
    {(lxb_char_t *) "\xe2\x85\xa6", 3, 0x2166}, /* (ROMAN NUMERAL SEVEN) */
    {(lxb_char_t *) "\xe2\x85\xa7", 3, 0x2167}, /* (ROMAN NUMERAL EIGHT) */
    {(lxb_char_t *) "\xe2\x85\xa8", 3, 0x2168}, /* (ROMAN NUMERAL NINE) */
    {(lxb_char_t *) "\xe2\x85\xa9", 3, 0x2169}, /* (ROMAN NUMERAL TEN) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe3\x8d\x89", 3, 0x3349}, /* (SQUARE MIRI) */
    {(lxb_char_t *) "\xe3\x8c\x94", 3, 0x3314}, /* (SQUARE KIRO) */
    {(lxb_char_t *) "\xe3\x8c\xa2", 3, 0x3322}, /* (SQUARE SENTI) */
    {(lxb_char_t *) "\xe3\x8d\x8d", 3, 0x334D}, /* (SQUARE MEETORU) */
    {(lxb_char_t *) "\xe3\x8c\x98", 3, 0x3318}, /* (SQUARE GURAMU) */
    {(lxb_char_t *) "\xe3\x8c\xa7", 3, 0x3327}, /* (SQUARE TON) */
    {(lxb_char_t *) "\xe3\x8c\x83", 3, 0x3303}, /* (SQUARE AARU) */
    {(lxb_char_t *) "\xe3\x8c\xb6", 3, 0x3336}, /* (SQUARE HEKUTAARU) */
    {(lxb_char_t *) "\xe3\x8d\x91", 3, 0x3351}, /* (SQUARE RITTORU) */
    {(lxb_char_t *) "\xe3\x8d\x97", 3, 0x3357}, /* (SQUARE WATTO) */
    {(lxb_char_t *) "\xe3\x8c\x8d", 3, 0x330D}, /* (SQUARE KARORII) */
    {(lxb_char_t *) "\xe3\x8c\xa6", 3, 0x3326}, /* (SQUARE DORU) */
    {(lxb_char_t *) "\xe3\x8c\xa3", 3, 0x3323}, /* (SQUARE SENTO) */
    {(lxb_char_t *) "\xe3\x8c\xab", 3, 0x332B}, /* (SQUARE PAASENTO) */
    {(lxb_char_t *) "\xe3\x8d\x8a", 3, 0x334A}, /* (SQUARE MIRIBAARU) */
    {(lxb_char_t *) "\xe3\x8c\xbb", 3, 0x333B}, /* (SQUARE PEEZI) */
    {(lxb_char_t *) "\xe3\x8e\x9c", 3, 0x339C}, /* (SQUARE MM) */
    {(lxb_char_t *) "\xe3\x8e\x9d", 3, 0x339D}, /* (SQUARE CM) */
    {(lxb_char_t *) "\xe3\x8e\x9e", 3, 0x339E}, /* (SQUARE KM) */
    {(lxb_char_t *) "\xe3\x8e\x8e", 3, 0x338E}, /* (SQUARE MG) */
    {(lxb_char_t *) "\xe3\x8e\x8f", 3, 0x338F}, /* (SQUARE KG) */
    {(lxb_char_t *) "\xe3\x8f\x84", 3, 0x33C4}, /* (SQUARE CC) */
    {(lxb_char_t *) "\xe3\x8e\xa1", 3, 0x33A1}, /* (SQUARE M SQUARED) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe3\x8d\xbb", 3, 0x337B}, /* (SQUARE ERA NAME HEISEI) */
    {(lxb_char_t *) "\xe3\x80\x9d", 3, 0x301D}, /* (REVERSED DOUBLE PRIME QUOTATION MARK) */
    {(lxb_char_t *) "\xe3\x80\x9f", 3, 0x301F}, /* (LOW DOUBLE PRIME QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x84\x96", 3, 0x2116}, /* (NUMERO SIGN) */
    {(lxb_char_t *) "\xe3\x8f\x8d", 3, 0x33CD}, /* (SQUARE KK) */
    {(lxb_char_t *) "\xe2\x84\xa1", 3, 0x2121}, /* (TELEPHONE SIGN) */
    {(lxb_char_t *) "\xe3\x8a\xa4", 3, 0x32A4}, /* (CIRCLED IDEOGRAPH HIGH) */
    {(lxb_char_t *) "\xe3\x8a\xa5", 3, 0x32A5}, /* (CIRCLED IDEOGRAPH CENTRE) */
    {(lxb_char_t *) "\xe3\x8a\xa6", 3, 0x32A6}, /* (CIRCLED IDEOGRAPH LOW) */
    {(lxb_char_t *) "\xe3\x8a\xa7", 3, 0x32A7}, /* (CIRCLED IDEOGRAPH LEFT) */
    {(lxb_char_t *) "\xe3\x8a\xa8", 3, 0x32A8}, /* (CIRCLED IDEOGRAPH RIGHT) */
    {(lxb_char_t *) "\xe3\x88\xb1", 3, 0x3231}, /* (PARENTHESIZED IDEOGRAPH STOCK) */
    {(lxb_char_t *) "\xe3\x88\xb2", 3, 0x3232}, /* (PARENTHESIZED IDEOGRAPH HAVE) */
    {(lxb_char_t *) "\xe3\x88\xb9", 3, 0x3239}, /* (PARENTHESIZED IDEOGRAPH REPRESENT) */
    {(lxb_char_t *) "\xe3\x8d\xbe", 3, 0x337E}, /* (SQUARE ERA NAME MEIZI) */
    {(lxb_char_t *) "\xe3\x8d\xbd", 3, 0x337D}, /* (SQUARE ERA NAME TAISYOU) */
    {(lxb_char_t *) "\xe3\x8d\xbc", 3, 0x337C}, /* (SQUARE ERA NAME SYOUWA) */
    {(lxb_char_t *) "\xe2\x89\x92", 3, 0x2252}, /* (APPROXIMATELY EQUAL TO OR THE IMAGE OF) */
    {(lxb_char_t *) "\xe2\x89\xa1", 3, 0x2261}, /* (IDENTICAL TO) */
    {(lxb_char_t *) "\xe2\x88\xab", 3, 0x222B}, /* (INTEGRAL) */
    {(lxb_char_t *) "\xe2\x88\xae", 3, 0x222E}, /* (CONTOUR INTEGRAL) */
    {(lxb_char_t *) "\xe2\x88\x91", 3, 0x2211}, /* (N-ARY SUMMATION) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xe2\x8a\xa5", 3, 0x22A5}, /* (UP TACK) */
    {(lxb_char_t *) "\xe2\x88\xa0", 3, 0x2220}, /* (ANGLE) */
    {(lxb_char_t *) "\xe2\x88\x9f", 3, 0x221F}, /* (RIGHT ANGLE) */
    {(lxb_char_t *) "\xe2\x8a\xbf", 3, 0x22BF}, /* (RIGHT TRIANGLE) */
    {(lxb_char_t *) "\xe2\x88\xb5", 3, 0x2235}, /* (BECAUSE) */
    {(lxb_char_t *) "\xe2\x88\xa9", 3, 0x2229}, /* (INTERSECTION) */
    {(lxb_char_t *) "\xe2\x88\xaa", 3, 0x222A}, /* (UNION) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe4\xba\x9c", 3, 0x4E9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x96", 3, 0x5516}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x83", 3, 0x5A03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xbf", 3, 0x963F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x80", 3, 0x54C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x9b", 3, 0x611B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xa8", 3, 0x6328}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xb6", 3, 0x59F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xa2", 3, 0x9022}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xb5", 3, 0x8475}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x9c", 3, 0x831C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x90", 3, 0x7A50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xaa", 3, 0x60AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xa1", 3, 0x63E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa5", 3, 0x6E25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xad", 3, 0x65ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xa6", 3, 0x8466}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xa6", 3, 0x82A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xb5", 3, 0x9BF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x93", 3, 0x6893}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xa7", 3, 0x5727}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xa1", 3, 0x65A1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xb1", 3, 0x6271}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x9b", 3, 0x5B9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x90", 3, 0x59D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\xbb", 3, 0x867B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xb4", 3, 0x98F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xa2", 3, 0x7D62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xbe", 3, 0x7DBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x8e", 3, 0x9B8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x96", 3, 0x6216}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x9f", 3, 0x7C9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xb7", 3, 0x88B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x89", 3, 0x5B89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xb5", 3, 0x5EB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x89", 3, 0x6309}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x97", 3, 0x6697}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x88", 3, 0x6848}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x87", 3, 0x95C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x8d", 3, 0x978D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x8f", 3, 0x674F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xa5", 3, 0x4EE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x8a", 3, 0x4F0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x8d", 3, 0x4F4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x9d", 3, 0x4F9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x89", 3, 0x5049}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xb2", 3, 0x56F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xb7", 3, 0x5937}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x94", 3, 0x59D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x81", 3, 0x5A01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x89", 3, 0x5C09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x9f", 3, 0x60DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x8f", 3, 0x610F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb0", 3, 0x6170}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x93", 3, 0x6613}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x85", 3, 0x6905}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xba", 3, 0x70BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x8f", 3, 0x754F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xb0", 3, 0x7570}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xbb", 3, 0x79FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xad", 3, 0x7DAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xaf", 3, 0x7DEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x83", 3, 0x80C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x8e", 3, 0x840E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xa3", 3, 0x8863}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x82", 3, 0x8B02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x95", 3, 0x9055}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xba", 3, 0x907A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xbb", 3, 0x533B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x95", 3, 0x4E95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa5", 3, 0x4EA5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x9f", 3, 0x57DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xb2", 3, 0x80B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\x81", 3, 0x90C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\xaf", 3, 0x78EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x80", 3, 0x4E00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xb1", 3, 0x58F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xa2", 3, 0x6EA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xb8", 3, 0x9038}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xb2", 3, 0x7A32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xa8", 3, 0x8328}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\x8b", 3, 0x828B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xaf", 3, 0x9C2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x81", 3, 0x5141}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb0", 3, 0x5370}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xbd", 3, 0x54BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xa1", 3, 0x54E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xa0", 3, 0x56E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xbb", 3, 0x59FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x95", 3, 0x5F15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xb2", 3, 0x98F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xab", 3, 0x6DEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xa4", 3, 0x80E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\xad", 3, 0x852D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xa2", 3, 0x9662}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb0", 3, 0x9670}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xa0", 3, 0x96A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xbb", 3, 0x97FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x8b", 3, 0x540B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb3", 3, 0x53F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x87", 3, 0x5B87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\x8f", 3, 0x70CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xbd", 3, 0x7FBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x82", 3, 0x8FC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xa8", 3, 0x96E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xaf", 3, 0x536F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x9c", 3, 0x9D5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xba", 3, 0x7ABA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x91", 3, 0x4E11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x93", 3, 0x7893}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xbc", 3, 0x81FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa6", 3, 0x6E26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x98", 3, 0x5618}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x84", 3, 0x5504}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x9d", 3, 0x6B1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x9a", 3, 0x851A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xbb", 3, 0x9C3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xa5", 3, 0x59E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xa9", 3, 0x53A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xa6", 3, 0x6D66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\x9c", 3, 0x74DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x8f", 3, 0x958F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\x82", 3, 0x5642}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x91", 3, 0x4E91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x8b", 3, 0x904B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xb2", 3, 0x96F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x8f", 3, 0x834F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x8c", 3, 0x990C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa1", 3, 0x53E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xb6", 3, 0x55B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xb0", 3, 0x5B30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xb1", 3, 0x5F71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xa0", 3, 0x6620}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb3", 3, 0x66F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x84", 3, 0x6804}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xb8", 3, 0x6C38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xb3", 3, 0x6CF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xa9", 3, 0x6D29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x9b", 3, 0x745B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x88", 3, 0x76C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x8e", 3, 0x7A4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xb4", 3, 0x9834}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xb1", 3, 0x82F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x9b", 3, 0x885B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xa0", 3, 0x8A60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xad", 3, 0x92ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xb2", 3, 0x6DB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xab", 3, 0x75AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x8a", 3, 0x76CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x85", 3, 0x99C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xa6", 3, 0x60A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x81", 3, 0x8B01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\x8a", 3, 0x8D8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xb2", 3, 0x95B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x8e", 3, 0x698E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xad", 3, 0x53AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x86", 3, 0x5186}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x92", 3, 0x5712}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xb0", 3, 0x5830}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x84", 3, 0x5944}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb4", 3, 0x5BB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb6", 3, 0x5EF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa8", 3, 0x6028}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa9", 3, 0x63A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xb4", 3, 0x63F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xbf", 3, 0x6CBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x94", 3, 0x6F14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x8e", 3, 0x708E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x94", 3, 0x7114}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x99", 3, 0x7159}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x95", 3, 0x71D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xbf", 3, 0x733F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x81", 3, 0x7E01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xb6", 3, 0x8276}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x91", 3, 0x82D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x97", 3, 0x8597}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xa0", 3, 0x9060}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x9b", 3, 0x925B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x9b", 3, 0x9D1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xa9", 3, 0x5869}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xbc", 3, 0x65BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x9a", 3, 0x6C5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xa5", 3, 0x7525}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xb9", 3, 0x51F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xae", 3, 0x592E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa5", 3, 0x5965}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x80", 3, 0x5F80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x9c", 3, 0x5FDC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xbc", 3, 0x62BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xba", 3, 0x65FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xaa", 3, 0x6A2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xa7", 3, 0x6B27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xb4", 3, 0x6BB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\x8b", 3, 0x738B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x81", 3, 0x7FC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x96", 3, 0x8956}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xac", 3, 0x9D2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x8e", 3, 0x9D0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x84", 3, 0x9EC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xa1", 3, 0x5CA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x96", 3, 0x6C96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xbb", 3, 0x837B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x84", 3, 0x5104}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x8b", 3, 0x5C4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xb6", 3, 0x61B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x86", 3, 0x81C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xb6", 3, 0x6876}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xa1", 3, 0x7261}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x99", 3, 0x4E59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xba", 3, 0x4FFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb8", 3, 0x5378}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa9", 3, 0x6069}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa9", 3, 0x6E29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x8f", 3, 0x7A4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xb3", 3, 0x97F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x8b", 3, 0x4E0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x96", 3, 0x5316}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xae", 3, 0x4EEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x95", 3, 0x4F55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xbd", 3, 0x4F3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xa1", 3, 0x4FA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xb3", 3, 0x4F73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xa0", 3, 0x52A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xaf", 3, 0x53EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x89", 3, 0x5609}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x8f", 3, 0x590F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x81", 3, 0x5AC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb6", 3, 0x5BB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa1", 3, 0x5BE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x91", 3, 0x79D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x87", 3, 0x6687}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x9c", 3, 0x679C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xb6", 3, 0x67B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x8c", 3, 0x6B4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xb3", 3, 0x6CB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xab", 3, 0x706B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x82", 3, 0x73C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x8d", 3, 0x798D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xbe", 3, 0x79BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xbc", 3, 0x7A3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x87", 3, 0x7B87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xb1", 3, 0x82B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x9b", 3, 0x82DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x84", 3, 0x8304}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xb7", 3, 0x8377}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xaf", 3, 0x83EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x93", 3, 0x83D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xa6", 3, 0x8766}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xb2", 3, 0x8AB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xa9", 3, 0x5629}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xa8", 3, 0x8CA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xa6", 3, 0x8FE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x8e", 3, 0x904E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x9e", 3, 0x971E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\x8a", 3, 0x868A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x84", 3, 0x4FC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xa8", 3, 0x5CE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x91", 3, 0x6211}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x99", 3, 0x7259}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xbb", 3, 0x753B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xa5", 3, 0x81E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xbd", 3, 0x82BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xbe", 3, 0x86FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x80", 3, 0x8CC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x85", 3, 0x96C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x93", 3, 0x9913}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x95", 3, 0x99D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x8b", 3, 0x4ECB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x9a", 3, 0x4F1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\xa3", 3, 0x89E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x9e", 3, 0x56DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x8a", 3, 0x584A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x8a", 3, 0x58CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xbb", 3, 0x5EFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xab", 3, 0x5FEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xaa", 3, 0x602A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x94", 3, 0x6094}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa2", 3, 0x6062}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x90", 3, 0x61D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x92", 3, 0x6212}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x90", 3, 0x62D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xb9", 3, 0x6539}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x81", 3, 0x9B41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa6", 3, 0x6666}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xb0", 3, 0x68B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xb7", 3, 0x6D77}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xb0", 3, 0x7070}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x8c", 3, 0x754C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x86", 3, 0x7686}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xb5", 3, 0x7D75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xa5", 3, 0x82A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xb9", 3, 0x87F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x8b", 3, 0x958B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x8e", 3, 0x968E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x9d", 3, 0x8C9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xb1", 3, 0x51F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xbe", 3, 0x52BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x96", 3, 0x5916}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xb3", 3, 0x54B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb3", 3, 0x5BB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x96", 3, 0x5D16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xa8", 3, 0x6168}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x82", 3, 0x6982}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xaf", 3, 0x6DAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x8d", 3, 0x788D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x8b", 3, 0x84CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x97", 3, 0x8857}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xb2", 3, 0x8A72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xa7", 3, 0x93A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaa\xb8", 3, 0x9AB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xac", 3, 0x6D6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xa8", 3, 0x99A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x99", 3, 0x86D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xa3", 3, 0x57A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xbf", 3, 0x67FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x8e", 3, 0x86CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x8e", 3, 0x920E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x83", 3, 0x5283}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\x87", 3, 0x5687}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x84", 3, 0x5404}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x93", 3, 0x5ED3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xa1", 3, 0x62E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xb9", 3, 0x64B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xbc", 3, 0x683C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xb8", 3, 0x6838}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xbb", 3, 0x6BBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xb2", 3, 0x7372}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xba", 3, 0x78BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xab", 3, 0x7A6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x9a", 3, 0x899A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\x92", 3, 0x89D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xab", 3, 0x8D6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x83", 3, 0x8F03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xad", 3, 0x90ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa3", 3, 0x95A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x94", 3, 0x9694}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa9", 3, 0x9769}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xa6", 3, 0x5B66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xb3", 3, 0x5CB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xbd", 3, 0x697D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x8d", 3, 0x984D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x8e", 3, 0x984E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x9b", 3, 0x639B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xa0", 3, 0x7B20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xab", 3, 0x6A2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xbf", 3, 0x6A7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xb6", 3, 0x68B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x8d", 3, 0x9C0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x9f", 3, 0x6F5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xb2", 3, 0x5272}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x9d", 3, 0x559D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xb0", 3, 0x6070}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xac", 3, 0x62EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xbb", 3, 0x6D3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x87", 3, 0x6E07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x91", 3, 0x6ED1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x9b", 3, 0x845B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x90", 3, 0x8910}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x84", 3, 0x8F44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x94", 3, 0x4E14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xb9", 3, 0x9C39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb6", 3, 0x53F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x9b", 3, 0x691B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xba", 3, 0x6A3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x84", 3, 0x9784}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xaa", 3, 0x682A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x9c", 3, 0x515C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x83", 3, 0x7AC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xb2", 3, 0x84B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9c", 3, 0x91DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\x8c", 3, 0x938C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\x9b", 3, 0x565B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xa8", 3, 0x9D28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xa2", 3, 0x6822}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x85", 3, 0x8305}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xb1", 3, 0x8431}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xa5", 3, 0x7CA5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x88", 3, 0x5208}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x85", 3, 0x82C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xa6", 3, 0x74E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\xbe", 3, 0x4E7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x83", 3, 0x4F83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa0", 3, 0x51A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x92", 3, 0x5BD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x8a", 3, 0x520A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x98", 3, 0x52D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xa7", 3, 0x52E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xbb", 3, 0x5DFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x9a", 3, 0x559A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xaa", 3, 0x582A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xa6", 3, 0x59E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x8c", 3, 0x5B8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x98", 3, 0x5B98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x9b", 3, 0x5BDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb2", 3, 0x5E72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb9", 3, 0x5E79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xa3", 3, 0x60A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x9f", 3, 0x611F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xa3", 3, 0x6163}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xbe", 3, 0x61BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x9b", 3, 0x63DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xa2", 3, 0x6562}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x91", 3, 0x67D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x93", 3, 0x6853}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xba", 3, 0x68FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xbe", 3, 0x6B3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x93", 3, 0x6B53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x97", 3, 0x6C57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xa2", 3, 0x6F22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x97", 3, 0x6F97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x85", 3, 0x6F45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\xb0", 3, 0x74B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x98", 3, 0x7518}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xa3", 3, 0x76E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x8b", 3, 0x770B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xbf", 3, 0x7AFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\xa1", 3, 0x7BA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xa1", 3, 0x7C21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xa9", 3, 0x7DE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbc\xb6", 3, 0x7F36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xb0", 3, 0x7FF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x9d", 3, 0x809D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xa6", 3, 0x8266}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x9e", 3, 0x839E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xb3", 3, 0x89B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x8c", 3, 0x8ACC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xab", 3, 0x8CAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x84", 3, 0x9084}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x91", 3, 0x9451}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x93", 3, 0x9593}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x91", 3, 0x9591}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa2", 3, 0x95A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xa5", 3, 0x9665}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\x93", 3, 0x97D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xa8", 3, 0x9928}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x98", 3, 0x8218}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xb8", 3, 0x4E38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xab", 3, 0x542B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xb8", 3, 0x5CB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x8c", 3, 0x5DCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\xa9", 3, 0x73A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x8c", 3, 0x764C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xbc", 3, 0x773C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xa9", 3, 0x5CA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xab", 3, 0x7FEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x8b", 3, 0x8D0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x81", 3, 0x96C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x91", 3, 0x9811}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x94", 3, 0x9854}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x98", 3, 0x9858}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x81", 3, 0x4F01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x8e", 3, 0x4F0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb1", 3, 0x5371}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x9c", 3, 0x559C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xa8", 3, 0x5668}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xba", 3, 0x57FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x87", 3, 0x5947}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\x89", 3, 0x5B09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x84", 3, 0x5BC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\x90", 3, 0x5C90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x8c", 3, 0x5E0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xbe", 3, 0x5E7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x8c", 3, 0x5FCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xae", 3, 0x63EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xba", 3, 0x673A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x97", 3, 0x65D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa2", 3, 0x65E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x9f", 3, 0x671F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x8b", 3, 0x68CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x84", 3, 0x68C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x9f", 3, 0x6A5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xb0", 3, 0x5E30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x85", 3, 0x6BC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x97", 3, 0x6C17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xbd", 3, 0x6C7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xbf", 3, 0x757F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x88", 3, 0x7948}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xa3", 3, 0x5B63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x80", 3, 0x7A00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x80", 3, 0x7D00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xbd", 3, 0x5FBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x8f", 3, 0x898F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x98", 3, 0x8A18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb4", 3, 0x8CB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb7", 3, 0x8D77}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x8c", 3, 0x8ECC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x9d", 3, 0x8F1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xa2", 3, 0x98E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x8e", 3, 0x9A0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xbc", 3, 0x9B3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x80", 3, 0x4E80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xbd", 3, 0x507D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x80", 3, 0x5100}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x93", 3, 0x5993}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x9c", 3, 0x5B9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xaf", 3, 0x622F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x80", 3, 0x6280}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xac", 3, 0x64EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xba", 3, 0x6B3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xa0", 3, 0x72A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x91", 3, 0x7591}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x87", 3, 0x7947}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xa9", 3, 0x7FA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xbb", 3, 0x87FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xbc", 3, 0x8ABC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xb0", 3, 0x8B70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xac", 3, 0x63AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x8a", 3, 0x83CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xa0", 3, 0x97A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x89", 3, 0x5409}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x83", 3, 0x5403}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xab", 3, 0x55AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x94", 3, 0x6854}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x98", 3, 0x6A58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xb0", 3, 0x8A70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xa7", 3, 0x7827}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xb5", 3, 0x6775}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x8d", 3, 0x9ECD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb4", 3, 0x5374}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xa2", 3, 0x5BA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x9a", 3, 0x811A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x90", 3, 0x8650}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x86", 3, 0x9006}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x98", 3, 0x4E18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x85", 3, 0x4E45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x87", 3, 0x4EC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x91", 3, 0x4F11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x8a", 3, 0x53CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xb8", 3, 0x5438}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xae", 3, 0x5BAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x93", 3, 0x5F13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa5", 3, 0x6025}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x91", 3, 0x6551}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xbd", 3, 0x673D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x82", 3, 0x6C42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xb2", 3, 0x6C72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xa3", 3, 0x6CE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xb8", 3, 0x7078}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\x83", 3, 0x7403}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xb6", 3, 0x7A76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xae", 3, 0x7AAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x88", 3, 0x7B08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x9a", 3, 0x7D1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xbe", 3, 0x7CFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xa6", 3, 0x7D66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa7", 3, 0x65E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x9b", 3, 0x725B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xbb", 3, 0x53BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x85", 3, 0x5C45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xa8", 3, 0x5DE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x92", 3, 0x62D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xa0", 3, 0x62E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x99", 3, 0x6319}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa0", 3, 0x6E20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x9a", 3, 0x865A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xb1", 3, 0x8A31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x9d", 3, 0x8DDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xb8", 3, 0x92F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x81", 3, 0x6F01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xa6", 3, 0x79A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x9a", 3, 0x9B5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa8", 3, 0x4EA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xab", 3, 0x4EAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xac", 3, 0x4EAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x9b", 3, 0x4F9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xa0", 3, 0x4FA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x91", 3, 0x50D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x87", 3, 0x5147}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xb6", 3, 0x7AF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xb1", 3, 0x5171}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xb6", 3, 0x51F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x94", 3, 0x5354}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xa1", 3, 0x5321}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xbf", 3, 0x537F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xab", 3, 0x53EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xac", 3, 0x55AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\x83", 3, 0x5883}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xa1", 3, 0x5CE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xb7", 3, 0x5F37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x8a", 3, 0x5F4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xaf", 3, 0x602F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x90", 3, 0x6050}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xad", 3, 0x606D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x9f", 3, 0x631F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x99", 3, 0x6559}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x8b", 3, 0x6A4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x81", 3, 0x6CC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x82", 3, 0x72C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xad", 3, 0x72ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xaf", 3, 0x77EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xb8", 3, 0x80F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x85", 3, 0x8105}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x88", 3, 0x8208}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x8e", 3, 0x854E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xb7", 3, 0x90F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\xa1", 3, 0x93E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xbf", 3, 0x97FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x97", 3, 0x9957}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x9a", 3, 0x9A5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xb0", 3, 0x4EF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x9d", 3, 0x51DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xad", 3, 0x5C2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x81", 3, 0x6681}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xad", 3, 0x696D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x80", 3, 0x5C40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb2", 3, 0x66F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xb5", 3, 0x6975}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\x89", 3, 0x7389}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x90", 3, 0x6850}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x81", 3, 0x7C81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x85", 3, 0x50C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xa4", 3, 0x52E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x87", 3, 0x5747}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xbe", 3, 0x5DFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa6", 3, 0x9326}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xa4", 3, 0x65A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xa3", 3, 0x6B23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xbd", 3, 0x6B3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xb4", 3, 0x7434}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x81", 3, 0x7981}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xbd", 3, 0x79BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x8b", 3, 0x7B4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x8a", 3, 0x7DCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xb9", 3, 0x82B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x8c", 3, 0x83CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xbf", 3, 0x887F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x9f", 3, 0x895F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xb9", 3, 0x8B39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x91", 3, 0x8FD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x91", 3, 0x91D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x9f", 3, 0x541F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x80", 3, 0x9280}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x9d", 3, 0x4E5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xb6", 3, 0x5036}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa5", 3, 0x53E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xba", 3, 0x533A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x97", 3, 0x72D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\x96", 3, 0x7396}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xa9", 3, 0x77E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xa6", 3, 0x82E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xaf", 3, 0x8EAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x86", 3, 0x99C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x88", 3, 0x99C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x92", 3, 0x99D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xb7", 3, 0x5177}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x9a", 3, 0x611A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x9e", 3, 0x865E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xb0", 3, 0x55B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xba", 3, 0x7A7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb6", 3, 0x5076}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x93", 3, 0x5BD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x87", 3, 0x9047}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x85", 3, 0x9685}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xb2", 3, 0x4E32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x9b", 3, 0x6ADB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa7", 3, 0x91E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x91", 3, 0x5C51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x88", 3, 0x5C48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x98", 3, 0x6398}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x9f", 3, 0x7A9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x93", 3, 0x6C93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xb4", 3, 0x9774}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\xa1", 3, 0x8F61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xaa", 3, 0x7AAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x8a", 3, 0x718A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x88", 3, 0x9688}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x82", 3, 0x7C82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x97", 3, 0x6817}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xb0", 3, 0x7E70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x91", 3, 0x6851}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xac", 3, 0x936C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xb2", 3, 0x52F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x9b", 3, 0x541B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xab", 3, 0x85AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x93", 3, 0x8A13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xa4", 3, 0x7FA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x8d", 3, 0x8ECD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xa1", 3, 0x90E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xa6", 3, 0x5366}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x88", 3, 0x8888}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x81", 3, 0x7941}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x82", 3, 0x4FC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xbe", 3, 0x50BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x91", 3, 0x5211}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x84", 3, 0x5144}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x93", 3, 0x5553}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xad", 3, 0x572D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xaa", 3, 0x73EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\x8b", 3, 0x578B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x91", 3, 0x5951}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xa2", 3, 0x5F62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x84", 3, 0x5F84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xb5", 3, 0x6075}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb6", 3, 0x6176}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xa7", 3, 0x6167}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xa9", 3, 0x61A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xb2", 3, 0x63B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xba", 3, 0x643A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xac", 3, 0x656C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xaf", 3, 0x666F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x82", 3, 0x6842}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x93", 3, 0x6E13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa6", 3, 0x7566}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xbd", 3, 0x7A3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xbb", 3, 0x7CFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x8c", 3, 0x7D4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x99", 3, 0x7D99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x8b", 3, 0x7E4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xab", 3, 0x7F6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x8e", 3, 0x830E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x8a", 3, 0x834A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x8d", 3, 0x86CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x88", 3, 0x8A08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xa3", 3, 0x8A63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xa6", 3, 0x8B66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xbd", 3, 0x8EFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x9a", 3, 0x981A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\x8f", 3, 0x9D8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xb8", 3, 0x82B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x8e", 3, 0x8FCE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xa8", 3, 0x9BE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x87", 3, 0x5287}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x9f", 3, 0x621F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x83", 3, 0x6483}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x80", 3, 0x6FC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x99", 3, 0x9699}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x81", 3, 0x6841}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x91", 3, 0x5091}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xa0", 3, 0x6B20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xba", 3, 0x6C7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x94", 3, 0x6F54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xb4", 3, 0x7A74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x90", 3, 0x7D50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x80", 3, 0x8840}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xa3", 3, 0x8A23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x88", 3, 0x6708}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xb6", 3, 0x4EF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xb9", 3, 0x5039}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa6", 3, 0x5026}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xa5", 3, 0x5065}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xbc", 3, 0x517C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xb8", 3, 0x5238}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xa3", 3, 0x5263}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xa7", 3, 0x55A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x8f", 3, 0x570F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x85", 3, 0x5805}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x8c", 3, 0x5ACC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xba", 3, 0x5EFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xb2", 3, 0x61B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xb8", 3, 0x61F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xb3", 3, 0x62F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xb2", 3, 0x6372}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x9c", 3, 0x691C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xa9", 3, 0x6A29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xbd", 3, 0x727D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xac", 3, 0x72AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xae", 3, 0x732E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\x94", 3, 0x7814}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xaf", 3, 0x786F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xb9", 3, 0x7D79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x8c", 3, 0x770C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xa9", 3, 0x80A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x8b", 3, 0x898B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x99", 3, 0x8B19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xa2", 3, 0x8CE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x92", 3, 0x8ED2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xa3", 3, 0x9063}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xb5", 3, 0x9375}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xba", 3, 0x967A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x95", 3, 0x9855}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x93", 3, 0x9A13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb9\xb8", 3, 0x9E78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x83", 3, 0x5143}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x9f", 3, 0x539F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xb3", 3, 0x53B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xbb", 3, 0x5E7B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xa6", 3, 0x5F26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x9b", 3, 0x6E1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x90", 3, 0x6E90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\x84", 3, 0x7384}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xbe", 3, 0x73FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x83", 3, 0x7D43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xb7", 3, 0x8237}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x80", 3, 0x8A00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xba", 3, 0x8AFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x90", 3, 0x9650}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x8e", 3, 0x4E4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x8b", 3, 0x500B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa4", 3, 0x53E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xbc", 3, 0x547C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xba", 3, 0x56FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x91", 3, 0x59D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xa4", 3, 0x5B64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xb1", 3, 0x5DF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xab", 3, 0x5EAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xa7", 3, 0x5F27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xb8", 3, 0x6238}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x85", 3, 0x6545}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xaf", 3, 0x67AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x96", 3, 0x6E56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x90", 3, 0x72D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x8a", 3, 0x7CCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xb4", 3, 0x88B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xa1", 3, 0x80A1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xa1", 3, 0x80E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb0", 3, 0x83F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x8e", 3, 0x864E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x87", 3, 0x8A87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xa8", 3, 0x8DE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xb7", 3, 0x9237}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x87", 3, 0x96C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xa7", 3, 0x9867}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\x93", 3, 0x9F13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x94", 3, 0x4E94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x92", 3, 0x4E92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x8d", 3, 0x4F0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x88", 3, 0x5348}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x89", 3, 0x5449}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xbe", 3, 0x543E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xaf", 3, 0x5A2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x8c", 3, 0x5F8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xa1", 3, 0x5FA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x9f", 3, 0x609F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xa7", 3, 0x68A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x8e", 3, 0x6A8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x9a", 3, 0x745A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x81", 3, 0x7881}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x9e", 3, 0x8A9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa4", 3, 0x8AA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xb7", 3, 0x8B77}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x90", 3, 0x9190}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x9e", 3, 0x4E5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x89", 3, 0x9BC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa4", 3, 0x4EA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xbc", 3, 0x4F7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xaf", 3, 0x4FAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x99", 3, 0x5019}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x96", 3, 0x5016}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x89", 3, 0x5149}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xac", 3, 0x516C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x9f", 3, 0x529F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xb9", 3, 0x52B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xbe", 3, 0x52FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x9a", 3, 0x539A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa3", 3, 0x53E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x91", 3, 0x5411}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x8e", 3, 0x540E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x89", 3, 0x5589}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x91", 3, 0x5751}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xa2", 3, 0x57A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xbd", 3, 0x597D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x94", 3, 0x5B54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x9d", 3, 0x5B5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x8f", 3, 0x5B8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xa5", 3, 0x5DE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xa7", 3, 0x5DE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xb7", 3, 0x5DF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb8", 3, 0x5E78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x83", 3, 0x5E83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x9a", 3, 0x5E9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xb7", 3, 0x5EB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x98", 3, 0x5F18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x92", 3, 0x6052}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x8c", 3, 0x614C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x97", 3, 0x6297}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x98", 3, 0x62D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa7", 3, 0x63A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xbb", 3, 0x653B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x82", 3, 0x6602}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x83", 3, 0x6643}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb4", 3, 0x66F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xad", 3, 0x676D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xa1", 3, 0x6821}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x97", 3, 0x6897}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x8b", 3, 0x69CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x9f", 3, 0x6C5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xaa", 3, 0x6D2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xa9", 3, 0x6D69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xaf", 3, 0x6E2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x9d", 3, 0x6E9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xb2", 3, 0x7532}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x87", 3, 0x7687}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xac", 3, 0x786C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xbf", 3, 0x7A3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xa0", 3, 0x7CE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x85", 3, 0x7D05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x98", 3, 0x7D18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x9e", 3, 0x7D5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb1", 3, 0x7DB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x95", 3, 0x8015}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x83", 3, 0x8003}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xaf", 3, 0x80AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xb1", 3, 0x80B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x94", 3, 0x8154}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x8f", 3, 0x818F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xaa", 3, 0x822A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x92", 3, 0x8352}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x8c", 3, 0x884C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xa1", 3, 0x8861}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x9b", 3, 0x8B1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xa2", 3, 0x8CA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xbc", 3, 0x8CFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\x8a", 3, 0x90CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xb5", 3, 0x9175}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xb1", 3, 0x9271}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xbf", 3, 0x783F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xbc", 3, 0x92FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa4", 3, 0x95A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x8d", 3, 0x964D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x85", 3, 0x9805}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\x99", 3, 0x9999}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x98", 3, 0x9AD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xbb", 3, 0x9D3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x9b", 3, 0x525B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xab", 3, 0x52AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb7", 3, 0x53F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x88", 3, 0x5408}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x95", 3, 0x58D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xb7", 3, 0x62F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xa0", 3, 0x6FE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xaa", 3, 0x8C6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x9f", 3, 0x8F5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xb9", 3, 0x9EB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x8b", 3, 0x514B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xbb", 3, 0x523B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x8a", 3, 0x544A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xbd", 3, 0x56FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x80", 3, 0x7A40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xb7", 3, 0x9177}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xa0", 3, 0x9D60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x92", 3, 0x9ED2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\x84", 3, 0x7344}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x89", 3, 0x6F09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xb0", 3, 0x8170}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x91", 3, 0x7511}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xbd", 3, 0x5FFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x9a", 3, 0x60DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaa\xa8", 3, 0x9AA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x9b", 3, 0x72DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xbc", 3, 0x8FBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xa4", 3, 0x6B64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x83", 3, 0x9803}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x8a", 3, 0x4ECA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xb0", 3, 0x56F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xa4", 3, 0x5764}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xbe", 3, 0x58BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\x9a", 3, 0x5A5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa8", 3, 0x6068}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x87", 3, 0x61C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x8f", 3, 0x660F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x86", 3, 0x6606}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xb9", 3, 0x6839}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xb1", 3, 0x68B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb7", 3, 0x6DF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x95", 3, 0x75D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xba", 3, 0x7D3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xae", 3, 0x826E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x82", 3, 0x9B42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x9b", 3, 0x4E9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x90", 3, 0x4F50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x89", 3, 0x53C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x86", 3, 0x5506}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xaf", 3, 0x5D6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xa6", 3, 0x5DE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xae", 3, 0x5DEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xbb", 3, 0x67FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x99", 3, 0x6C99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xb3", 3, 0x7473}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\x82", 3, 0x7802}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x90", 3, 0x8A50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\x96", 3, 0x9396}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x9f", 3, 0x88DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x90", 3, 0x5750}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xa7", 3, 0x5EA7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xab", 3, 0x632B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xb5", 3, 0x50B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xac", 3, 0x50AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x8d", 3, 0x518D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x80", 3, 0x6700}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x89", 3, 0x54C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x9e", 3, 0x585E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xbb", 3, 0x59BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb0", 3, 0x5BB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xa9", 3, 0x5F69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x8d", 3, 0x624D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa1", 3, 0x63A1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xbd", 3, 0x683D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xb3", 3, 0x6B73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x88", 3, 0x6E08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xbd", 3, 0x707D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x87", 3, 0x91C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\x80", 3, 0x7280}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\x95", 3, 0x7815}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xa6", 3, 0x7826}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xad", 3, 0x796D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x8e", 3, 0x658E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xb0", 3, 0x7D30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x9c", 3, 0x83DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x81", 3, 0x88C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x89", 3, 0x8F09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x9b", 3, 0x969B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xa4", 3, 0x5264}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xa8", 3, 0x5728}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x90", 3, 0x6750}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xaa", 3, 0x7F6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xa1", 3, 0x8CA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb4", 3, 0x51B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x82", 3, 0x5742}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xaa", 3, 0x962A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xba", 3, 0x583A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x8a", 3, 0x698A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xb4", 3, 0x80B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xb2", 3, 0x54B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x8e", 3, 0x5D0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xbc", 3, 0x57FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x95", 3, 0x7895}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xba", 3, 0x9DFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x9c", 3, 0x4F5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x8a", 3, 0x524A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x8b", 3, 0x548B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xbe", 3, 0x643E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xa8", 3, 0x6628}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x94", 3, 0x6714}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xb5", 3, 0x67F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x84", 3, 0x7A84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x96", 3, 0x7B56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xa2", 3, 0x7D22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xaf", 3, 0x932F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x9c", 3, 0x685C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xad", 3, 0x9BAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xb9", 3, 0x7B39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x99", 3, 0x5319}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x8a", 3, 0x518A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xb7", 3, 0x5237}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x9f", 3, 0x5BDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xb6", 3, 0x62F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xae", 3, 0x64AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xa6", 3, 0x64E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xad", 3, 0x672D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xba", 3, 0x6BBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xa9", 3, 0x85A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x91", 3, 0x96D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x90", 3, 0x7690}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x96", 3, 0x9BD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x8c", 3, 0x634C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x86", 3, 0x9306}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xab", 3, 0x9BAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xbf", 3, 0x76BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x92", 3, 0x6652}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x89", 3, 0x4E09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x98", 3, 0x5098}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x82", 3, 0x53C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xb1", 3, 0x5C71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xa8", 3, 0x60E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x92", 3, 0x6492}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xa3", 3, 0x6563}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x9f", 3, 0x685F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xa6", 3, 0x71E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x8a", 3, 0x73CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xa3", 3, 0x7523}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x97", 3, 0x7B97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x82", 3, 0x7E82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\x95", 3, 0x8695}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x83", 3, 0x8B83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x9b", 3, 0x8CDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xb8", 3, 0x9178}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x90", 3, 0x9910}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xac", 3, 0x65AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xab", 3, 0x66AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x8b", 3, 0x6B8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x95", 3, 0x4ED5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x94", 3, 0x4ED4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xba", 3, 0x4F3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xbf", 3, 0x4F7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xba", 3, 0x523A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb8", 3, 0x53F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb2", 3, 0x53F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\xa3", 3, 0x55E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x9b", 3, 0x56DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xab", 3, 0x58EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x8b", 3, 0x59CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x89", 3, 0x59C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xbf", 3, 0x59FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x90", 3, 0x5B50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x8d", 3, 0x5C4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x82", 3, 0x5E02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xab", 3, 0x5E2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x97", 3, 0x5FD7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x9d", 3, 0x601D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x87", 3, 0x6307}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xaf", 3, 0x652F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x9c", 3, 0x5B5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xaf", 3, 0x65AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xbd", 3, 0x65BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa8", 3, 0x65E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x9d", 3, 0x679D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xa2", 3, 0x6B62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xbb", 3, 0x6B7B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x8f", 3, 0x6C0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\x85", 3, 0x7345}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x89", 3, 0x7949}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x81", 3, 0x79C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xb8", 3, 0x7CF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x99", 3, 0x7D19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xab", 3, 0x7D2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xa2", 3, 0x80A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x82", 3, 0x8102}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xb3", 3, 0x81F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x96", 3, 0x8996}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x9e", 3, 0x8A5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xa9", 3, 0x8A69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xa6", 3, 0x8A66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x8c", 3, 0x8A8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xae", 3, 0x8AEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x87", 3, 0x8CC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x9c", 3, 0x8CDC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x8c", 3, 0x96CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xbc", 3, 0x98FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xaf", 3, 0x6B6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x8b", 3, 0x4E8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xbc", 3, 0x4F3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x8d", 3, 0x4F8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x90", 3, 0x5150}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x97", 3, 0x5B57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xba", 3, 0x5BFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x88", 3, 0x6148}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x81", 3, 0x6301}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x82", 3, 0x6642}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xa1", 3, 0x6B21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x8b", 3, 0x6ECB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xbb", 3, 0x6CBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xbe", 3, 0x723E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\xbd", 3, 0x74BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x94", 3, 0x75D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x81", 3, 0x78C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xba", 3, 0x793A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x8c", 3, 0x800C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xb3", 3, 0x8033}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xaa", 3, 0x81EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x94", 3, 0x8494}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\x9e", 3, 0x8F9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x90", 3, 0x6C50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb9\xbf", 3, 0x9E7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x8f", 3, 0x5F0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x98", 3, 0x8B58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xab", 3, 0x9D2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xba", 3, 0x7AFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xb8", 3, 0x8EF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x8d", 3, 0x5B8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xab", 3, 0x96EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x83", 3, 0x4E03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb1", 3, 0x53F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xb7", 3, 0x57F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xb1", 3, 0x5931}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x89", 3, 0x5AC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xa4", 3, 0x5BA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x89", 3, 0x6089}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xbf", 3, 0x6E7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x86", 3, 0x6F06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xbe", 3, 0x75BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xaa", 3, 0x8CEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x9f", 3, 0x5B9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x80", 3, 0x8500}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xa0", 3, 0x7BE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb2", 3, 0x5072}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xb4", 3, 0x67F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\x9d", 3, 0x829D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xa1", 3, 0x5C61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x8a", 3, 0x854A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x9e", 3, 0x7E1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x8e", 3, 0x820E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x99", 3, 0x5199}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x84", 3, 0x5C04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xa8", 3, 0x6368}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xa6", 3, 0x8D66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x9c", 3, 0x659C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xae", 3, 0x716E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xbe", 3, 0x793E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x97", 3, 0x7D17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x85", 3, 0x8005}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x9d", 3, 0x8B1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x8a", 3, 0x8ECA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xae", 3, 0x906E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x87", 3, 0x86C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xaa", 3, 0x90AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x9f", 3, 0x501F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xba", 3, 0x52FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xba", 3, 0x5C3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x93", 3, 0x6753}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xbc", 3, 0x707C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xb5", 3, 0x7235}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x8c", 3, 0x914C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x88", 3, 0x91C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xab", 3, 0x932B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xa5", 3, 0x82E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x82", 3, 0x5BC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xb1", 3, 0x5F31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb9", 3, 0x60F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xbb", 3, 0x4E3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x96", 3, 0x53D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x88", 3, 0x5B88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x8b", 3, 0x624B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xb1", 3, 0x6731}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x8a", 3, 0x6B8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xa9", 3, 0x72E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xa0", 3, 0x73E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xae", 3, 0x7A2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xab", 3, 0x816B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\xa3", 3, 0x8DA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x92", 3, 0x9152}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\x96", 3, 0x9996}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x92", 3, 0x5112}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x97", 3, 0x53D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xaa", 3, 0x546A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xbf", 3, 0x5BFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x88", 3, 0x6388}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xb9", 3, 0x6A39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xac", 3, 0x7DAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x80", 3, 0x9700}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x9a", 3, 0x56DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x8e", 3, 0x53CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xa8", 3, 0x5468}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x97", 3, 0x5B97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xb1", 3, 0x5C31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x9e", 3, 0x5DDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xae", 3, 0x4FEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x81", 3, 0x6101}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xbe", 3, 0x62FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xb2", 3, 0x6D32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x80", 3, 0x79C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x8b", 3, 0x79CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x82", 3, 0x7D42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x8d", 3, 0x7E4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x92", 3, 0x7FD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xad", 3, 0x81ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x9f", 3, 0x821F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x90", 3, 0x8490}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x86", 3, 0x8846}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xb2", 3, 0x8972}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x90", 3, 0x8B90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xb4", 3, 0x8E74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xaf", 3, 0x8F2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xb1", 3, 0x9031}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x8b", 3, 0x914B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xac", 3, 0x916C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x86", 3, 0x96C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x9c", 3, 0x919C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x80", 3, 0x4EC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x8f", 3, 0x4F4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x85", 3, 0x5145}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x81", 3, 0x5341}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x93", 3, 0x5F93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x8e", 3, 0x620E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x94", 3, 0x67D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x81", 3, 0x6C41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x8b", 3, 0x6E0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xa3", 3, 0x7363}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xa6", 3, 0x7E26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x8d", 3, 0x91CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x83", 3, 0x9283}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x94", 3, 0x53D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x99", 3, 0x5919}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xbf", 3, 0x5BBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x91", 3, 0x6DD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x9d", 3, 0x795D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xae", 3, 0x7E2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x9b", 3, 0x7C9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xbe", 3, 0x587E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x9f", 3, 0x719F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xba", 3, 0x51FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x93", 3, 0x8853}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xb0", 3, 0x8FF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x8a", 3, 0x4FCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xbb", 3, 0x5CFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xa5", 3, 0x6625}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xac", 3, 0x77AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa3", 3, 0x7AE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x9c", 3, 0x821C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xbf", 3, 0x99FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x86", 3, 0x51C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xaa", 3, 0x5FAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xac", 3, 0x65EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xaf", 3, 0x696F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x89", 3, 0x6B89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb3", 3, 0x6DF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x96", 3, 0x6E96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xa4", 3, 0x6F64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xbe", 3, 0x76FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x94", 3, 0x7D14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xa1", 3, 0x5DE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xb5", 3, 0x9075}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x87", 3, 0x9187}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x86", 3, 0x9806}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xa6", 3, 0x51E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x9d", 3, 0x521D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x80", 3, 0x6240}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x91", 3, 0x6691}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x99", 3, 0x66D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x9a", 3, 0x6E1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xb6", 3, 0x5EB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x92", 3, 0x7DD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xb2", 3, 0x7F72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb8", 3, 0x66F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xaf", 3, 0x85AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xb7", 3, 0x85F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xb8", 3, 0x8AF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xa9", 3, 0x52A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x99", 3, 0x53D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xb3", 3, 0x5973}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x8f", 3, 0x5E8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x90", 3, 0x5F90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x95", 3, 0x6055}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xa4", 3, 0x92E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xa4", 3, 0x9664}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xb7", 3, 0x50B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x9f", 3, 0x511F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x9d", 3, 0x52DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xa0", 3, 0x5320}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x87", 3, 0x5347}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xac", 3, 0x53EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xa8", 3, 0x54E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x86", 3, 0x5546}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xb1", 3, 0x5531}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x97", 3, 0x5617}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa8", 3, 0x5968}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xbe", 3, 0x59BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xbc", 3, 0x5A3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb5", 3, 0x5BB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x86", 3, 0x5C06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x8f", 3, 0x5C0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x91", 3, 0x5C11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x9a", 3, 0x5C1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x84", 3, 0x5E84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x8a", 3, 0x5E8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xa0", 3, 0x5EE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xb0", 3, 0x5F70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xbf", 3, 0x627F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x84", 3, 0x6284}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x9b", 3, 0x62DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x8c", 3, 0x638C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xb7", 3, 0x6377}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x87", 3, 0x6607}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x8c", 3, 0x660C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xad", 3, 0x662D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xb6", 3, 0x6676}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xbe", 3, 0x677E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xa2", 3, 0x68A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x9f", 3, 0x6A1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xb5", 3, 0x6A35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xbc", 3, 0x6CBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x88", 3, 0x6D88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x89", 3, 0x6E09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x98", 3, 0x6E58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\xbc", 3, 0x713C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\xa6", 3, 0x7126}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xa7", 3, 0x7167}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x87", 3, 0x75C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x81", 3, 0x7701}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\x9d", 3, 0x785D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\x81", 3, 0x7901}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xa5", 3, 0x7965}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xb0", 3, 0x79F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa0", 3, 0x7AE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x91", 3, 0x7B11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xa7", 3, 0x7CA7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xb9", 3, 0x7D39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x96", 3, 0x8096}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x96", 3, 0x83D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x8b", 3, 0x848B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x89", 3, 0x8549}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x9d", 3, 0x885D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb3", 3, 0x88F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x9f", 3, 0x8A1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xbc", 3, 0x8A3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x94", 3, 0x8A54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xb3", 3, 0x8A73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xa1", 3, 0x8C61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x9e", 3, 0x8CDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xa4", 3, 0x91A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xa6", 3, 0x9266}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xbe", 3, 0x937E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x98", 3, 0x9418}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x9c", 3, 0x969C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x98", 3, 0x9798}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x8a", 3, 0x4E0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x88", 3, 0x4E08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x9e", 3, 0x4E1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x97", 3, 0x4E57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x97", 3, 0x5197}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xb0", 3, 0x5270}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x8e", 3, 0x57CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xb4", 3, 0x5834}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x8c", 3, 0x58CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xa2", 3, 0x5B22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xb8", 3, 0x5E38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x85", 3, 0x60C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xbe", 3, 0x64FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xa1", 3, 0x6761}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x96", 3, 0x6756}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\x84", 3, 0x6D44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xb6", 3, 0x72B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xb3", 3, 0x7573}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xa3", 3, 0x7A63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xb8", 3, 0x84B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xb2", 3, 0x8B72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xb8", 3, 0x91B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa0", 3, 0x9320}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xb1", 3, 0x5631}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xb4", 3, 0x57F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xbe", 3, 0x98FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xad", 3, 0x62ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x8d", 3, 0x690D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x96", 3, 0x6B96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xad", 3, 0x71ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x94", 3, 0x7E54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb7", 3, 0x8077}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xb2", 3, 0x8272}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\xa6", 3, 0x89E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\x9f", 3, 0x98DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x95", 3, 0x8755}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xb1", 3, 0x8FB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xbb", 3, 0x5C3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xb8", 3, 0x4F38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xa1", 3, 0x4FE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xb5", 3, 0x4FB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x87", 3, 0x5507}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xa0", 3, 0x5A20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x9d", 3, 0x5BDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa9", 3, 0x5BE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x83", 3, 0x5FC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x8e", 3, 0x614E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xaf", 3, 0x632F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xb0", 3, 0x65B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x8b", 3, 0x664B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xae", 3, 0x68EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x9b", 3, 0x699B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xb8", 3, 0x6D78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb1", 3, 0x6DF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xb3", 3, 0x7533}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xb9", 3, 0x75B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x9f", 3, 0x771F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x9e", 3, 0x795E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xa6", 3, 0x79E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xb3", 3, 0x7D33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xa3", 3, 0x81E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xaf", 3, 0x82AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xaa", 3, 0x85AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xaa", 3, 0x89AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xba", 3, 0x8A3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xab", 3, 0x8EAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\x9b", 3, 0x8F9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xb2", 3, 0x9032}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9d", 3, 0x91DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x87", 3, 0x9707}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xba", 3, 0x4EBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x81", 3, 0x4EC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x83", 3, 0x5203}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xb5", 3, 0x5875}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xac", 3, 0x58EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x8b", 3, 0x5C0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x9a", 3, 0x751A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xbd", 3, 0x5C3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x8e", 3, 0x814E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x8a", 3, 0x8A0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x85", 3, 0x8FC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xa3", 3, 0x9663}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xad", 3, 0x976D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xa5", 3, 0x7B25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x8f", 3, 0x8ACF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x88", 3, 0x9808}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xa2", 3, 0x9162}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xb3", 3, 0x56F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xa8", 3, 0x53A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x97", 3, 0x9017}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xb9", 3, 0x5439}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\x82", 3, 0x5782}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xa5", 3, 0x5E25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa8", 3, 0x63A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xb4", 3, 0x6C34}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x8a", 3, 0x708A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xa1", 3, 0x7761}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x8b", 3, 0x7C8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xa0", 3, 0x7FE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xb0", 3, 0x8870}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x82", 3, 0x9042}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x94", 3, 0x9154}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x90", 3, 0x9310}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x98", 3, 0x9318}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x8f", 3, 0x968F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x9e", 3, 0x745E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x84", 3, 0x9AC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x87", 3, 0x5D07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xa9", 3, 0x5D69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xb0", 3, 0x6570}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xa2", 3, 0x67A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\xa8", 3, 0x8DA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x9b", 3, 0x96DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xae", 3, 0x636E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x89", 3, 0x6749}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x99", 3, 0x6919}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x85", 3, 0x83C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x97", 3, 0x9817}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x80", 3, 0x96C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xbe", 3, 0x88FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x84", 3, 0x6F84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xba", 3, 0x647A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xb8", 3, 0x5BF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x96", 3, 0x4E16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xac", 3, 0x702C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x9d", 3, 0x755D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xaf", 3, 0x662F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x84", 3, 0x51C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xb6", 3, 0x5236}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xa2", 3, 0x52E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x93", 3, 0x59D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x81", 3, 0x5F81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa7", 3, 0x6027}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x90", 3, 0x6210}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xbf", 3, 0x653F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xb4", 3, 0x6574}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x9f", 3, 0x661F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xb4", 3, 0x6674}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xb2", 3, 0x68F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x96", 3, 0x6816}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xa3", 3, 0x6B63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x85", 3, 0x6E05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xb2", 3, 0x7272}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x9f", 3, 0x751F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x9b", 3, 0x76DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xbe", 3, 0x7CBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x96", 3, 0x8056}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xb0", 3, 0x58F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xbd", 3, 0x88FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xbf", 3, 0x897F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa0", 3, 0x8AA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x93", 3, 0x8A93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x8b", 3, 0x8ACB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x9d", 3, 0x901D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x92", 3, 0x9192}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x92", 3, 0x9752}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x99", 3, 0x9759}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x89", 3, 0x6589}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x8e", 3, 0x7A0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x86", 3, 0x8106}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xbb", 3, 0x96BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xad", 3, 0x5E2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x9c", 3, 0x60DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x9a", 3, 0x621A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xa5", 3, 0x65A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x94", 3, 0x6614}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x90", 3, 0x6790}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xb3", 3, 0x77F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x8d", 3, 0x7A4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x8d", 3, 0x7C4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xbe", 3, 0x7E3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x8a", 3, 0x810A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xac", 3, 0x8CAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xa4", 3, 0x8D64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xa1", 3, 0x8DE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x9f", 3, 0x8E5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xa9", 3, 0x78A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x87", 3, 0x5207}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x99", 3, 0x62D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa5", 3, 0x63A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\x82", 3, 0x6442}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x98", 3, 0x6298}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xad", 3, 0x8A2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x83", 3, 0x7A83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x80", 3, 0x7BC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xac", 3, 0x8AAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xaa", 3, 0x96EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xb6", 3, 0x7D76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x8c", 3, 0x820C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x89", 3, 0x8749}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x99", 3, 0x4ED9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x88", 3, 0x5148}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x83", 3, 0x5343}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xa0", 3, 0x5360}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xa3", 3, 0x5BA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x82", 3, 0x5C02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x96", 3, 0x5C16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x9d", 3, 0x5DDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xa6", 3, 0x6226}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x87", 3, 0x6247}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xb0", 3, 0x64B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x93", 3, 0x6813}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xb4", 3, 0x6834}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x89", 3, 0x6CC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\x85", 3, 0x6D45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x97", 3, 0x6D17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x93", 3, 0x67D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x9c", 3, 0x6F5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x8e", 3, 0x714E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xbd", 3, 0x717D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x8b", 3, 0x65CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xbf", 3, 0x7A7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\xad", 3, 0x7BAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x9a", 3, 0x7DDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x8a", 3, 0x7E4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xa8", 3, 0x7FA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xba", 3, 0x817A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x9b", 3, 0x821B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xb9", 3, 0x8239}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xa6", 3, 0x85A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xae", 3, 0x8A6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x8e", 3, 0x8CCE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xb5", 3, 0x8DF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xb8", 3, 0x9078}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xb7", 3, 0x9077}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\xad", 3, 0x92AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x91", 3, 0x9291}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x83", 3, 0x9583}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xae", 3, 0x9BAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x8d", 3, 0x524D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x84", 3, 0x5584}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xb8", 3, 0x6F38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\xb6", 3, 0x7136}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xa8", 3, 0x5168}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x85", 3, 0x7985}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x95", 3, 0x7E55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xb3", 3, 0x81B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x8e", 3, 0x7CCE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\x8c", 3, 0x564C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x91", 3, 0x5851}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xa8", 3, 0x5CA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xaa", 3, 0x63AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xbe", 3, 0x66FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xbd", 3, 0x66FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x9a", 3, 0x695A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x99", 3, 0x72D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x8f", 3, 0x758F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x8e", 3, 0x758E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\x8e", 3, 0x790E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x96", 3, 0x7956}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x9f", 3, 0x79DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x97", 3, 0x7C97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xa0", 3, 0x7D20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x84", 3, 0x7D44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x87", 3, 0x8607}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xb4", 3, 0x8A34}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xbb", 3, 0x963B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xa1", 3, 0x9061}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\xa0", 3, 0x9F20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xa7", 3, 0x50E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xb5", 3, 0x5275}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x8c", 3, 0x53CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa2", 3, 0x53E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x89", 3, 0x5009}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xaa", 3, 0x55AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xae", 3, 0x58EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x8f", 3, 0x594F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xbd", 3, 0x723D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x8b", 3, 0x5B8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xa4", 3, 0x5C64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x9d", 3, 0x531D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xa3", 3, 0x60E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb3", 3, 0x60F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x9c", 3, 0x635C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x83", 3, 0x6383}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xbf", 3, 0x633F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xbb", 3, 0x63BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x8d", 3, 0x64CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa9", 3, 0x65E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb9", 3, 0x66F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xa3", 3, 0x5DE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x8d", 3, 0x69CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xbd", 3, 0x69FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x95", 3, 0x6F15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xa5", 3, 0x71E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x89", 3, 0x4E89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xa9", 3, 0x75E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xb8", 3, 0x76F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x93", 3, 0x7A93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x9f", 3, 0x7CDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x8f", 3, 0x7DCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x9c", 3, 0x7D9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xa1", 3, 0x8061}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x89", 3, 0x8349}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x98", 3, 0x8358}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xac", 3, 0x846C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xbc", 3, 0x84BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xbb", 3, 0x85FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x85", 3, 0x88C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb0", 3, 0x8D70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x81", 3, 0x9001}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xad", 3, 0x906D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\x97", 3, 0x9397}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x9c", 3, 0x971C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x92", 3, 0x9A12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x8f", 3, 0x50CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\x97", 3, 0x5897}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x8e", 3, 0x618E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x93", 3, 0x81D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\xb5", 3, 0x8535}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x88", 3, 0x8D08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xa0", 3, 0x9020}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x83", 3, 0x4FC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb4", 3, 0x5074}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x87", 3, 0x5247}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb3", 3, 0x5373}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xaf", 3, 0x606F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x89", 3, 0x6349}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x9f", 3, 0x675F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xac", 3, 0x6E2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\xb3", 3, 0x8DB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x9f", 3, 0x901F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x97", 3, 0x4FD7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x9e", 3, 0x5C5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x8a", 3, 0x8CCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x8f", 3, 0x65CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x9a", 3, 0x7D9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x92", 3, 0x5352}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x96", 3, 0x8896}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xb6", 3, 0x5176}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x83", 3, 0x63C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x98", 3, 0x5B58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xab", 3, 0x5B6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x8a", 3, 0x5C0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x8d", 3, 0x640D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x91", 3, 0x6751}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x9c", 3, 0x905C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x96", 3, 0x4ED6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x9a", 3, 0x591A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xaa", 3, 0x592A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xb0", 3, 0x6C70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x91", 3, 0x8A51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xbe", 3, 0x553E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x95", 3, 0x5815}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xa5", 3, 0x59A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb0", 3, 0x60F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x93", 3, 0x6253}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x81", 3, 0x67C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xb5", 3, 0x8235}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x95", 3, 0x6955}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x80", 3, 0x9640}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x84", 3, 0x99C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\xa8", 3, 0x9A28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x93", 3, 0x4F53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x86", 3, 0x5806}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xbe", 3, 0x5BFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x90", 3, 0x8010}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xb1", 3, 0x5CB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xaf", 3, 0x5E2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x85", 3, 0x5F85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa0", 3, 0x6020}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x8b", 3, 0x614B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xb4", 3, 0x6234}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xbf", 3, 0x66FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xb0", 3, 0x6CF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x9e", 3, 0x6EDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x8e", 3, 0x80CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xbf", 3, 0x817F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x94", 3, 0x82D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x8b", 3, 0x888B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb8", 3, 0x8CB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x80", 3, 0x9000}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xae", 3, 0x902E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x8a", 3, 0x968A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x9b", 3, 0x9EDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x9b", 3, 0x9BDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xa3", 3, 0x4EE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xb0", 3, 0x53F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xa7", 3, 0x5927}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xac", 3, 0x7B2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x8d", 3, 0x918D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x8c", 3, 0x984C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xb9", 3, 0x9DF9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x9d", 3, 0x6EDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xa7", 3, 0x7027}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x93", 3, 0x5353}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x84", 3, 0x5544}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x85", 3, 0x5B85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x98", 3, 0x6258}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x9e", 3, 0x629E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x93", 3, 0x62D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xa2", 3, 0x6CA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xaf", 3, 0x6FEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xa2", 3, 0x7422}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x97", 3, 0x8A17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xb8", 3, 0x9438}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x81", 3, 0x6FC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xbe", 3, 0x8AFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb8", 3, 0x8338}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xa7", 3, 0x51E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xb8", 3, 0x86F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xaa", 3, 0x53EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa9", 3, 0x53E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x86", 3, 0x4F46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x94", 3, 0x9054}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xb0", 3, 0x8FB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xaa", 3, 0x596A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xb1", 3, 0x8131}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xbd", 3, 0x5DFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xaa", 3, 0x7AEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xbf", 3, 0x8FBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x9a", 3, 0x68DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb0\xb7", 3, 0x8C37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xb8", 3, 0x72F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\x88", 3, 0x9C48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xbd", 3, 0x6A3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xb0", 3, 0x8AB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xb9", 3, 0x4E39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x98", 3, 0x5358}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x86", 3, 0x5606}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xa6", 3, 0x5766}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x85", 3, 0x62C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa2", 3, 0x63A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa6", 3, 0x65E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x8e", 3, 0x6B4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xa1", 3, 0x6DE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x9b", 3, 0x6E5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xad", 3, 0x70AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xad", 3, 0x77ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xaf", 3, 0x7AEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\xaa", 3, 0x7BAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xbb", 3, 0x7DBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xbd", 3, 0x803D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x86", 3, 0x80C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x8b", 3, 0x86CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x95", 3, 0x8A95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x9b", 3, 0x935B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xa3", 3, 0x56E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x87", 3, 0x58C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xbe", 3, 0x5F3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xad", 3, 0x65AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x96", 3, 0x6696}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x80", 3, 0x6A80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xb5", 3, 0x6BB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xb7", 3, 0x7537}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x87", 3, 0x8AC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa4", 3, 0x5024}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xa5", 3, 0x77E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xb0", 3, 0x5730}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x9b", 3, 0x5F1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa5", 3, 0x6065}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xba", 3, 0x667A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xa0", 3, 0x6C60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xb4", 3, 0x75F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x9a", 3, 0x7A1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xae", 3, 0x7F6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xb4", 3, 0x81F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x98", 3, 0x8718}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x85", 3, 0x9045}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xb3", 3, 0x99B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x89", 3, 0x7BC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x9c", 3, 0x755C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xb9", 3, 0x7AF9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x91", 3, 0x7B51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x84", 3, 0x84C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x90", 3, 0x9010}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xa9", 3, 0x79E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x92", 3, 0x7A92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb6", 3, 0x8336}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\xa1", 3, 0x5AE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\x80", 3, 0x7740}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xad", 3, 0x4E2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xb2", 3, 0x4EF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x99", 3, 0x5B99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xa0", 3, 0x5FE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xbd", 3, 0x62BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xbc", 3, 0x663C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xb1", 3, 0x67F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xa8", 3, 0x6CE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\xab", 3, 0x866B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xb7", 3, 0x8877}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xbb", 3, 0x8A3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x8e", 3, 0x914E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xb3", 3, 0x92F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x90", 3, 0x99D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x97", 3, 0x6A17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xa6", 3, 0x7026}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xaa", 3, 0x732A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xa7", 3, 0x82E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x97", 3, 0x8457}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xaf", 3, 0x8CAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x81", 3, 0x4E01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x86", 3, 0x5146}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x8b", 3, 0x51CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x8b", 3, 0x558B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xb5", 3, 0x5BF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x96", 3, 0x5E16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xb3", 3, 0x5E33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x81", 3, 0x5E81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x94", 3, 0x5F14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xb5", 3, 0x5F35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xab", 3, 0x5F6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xb4", 3, 0x5FB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xb2", 3, 0x61F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x91", 3, 0x6311}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xa2", 3, 0x66A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x9d", 3, 0x671D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xae", 3, 0x6F6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x92", 3, 0x7252}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xba", 3, 0x753A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xba", 3, 0x773A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb4", 3, 0x8074}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xb9", 3, 0x8139}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xb8", 3, 0x8178}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xb6", 3, 0x8776}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xbf", 3, 0x8ABF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x9c", 3, 0x8ADC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\x85", 3, 0x8D85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xb3", 3, 0x8DF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x9a", 3, 0x929A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x95\xb7", 3, 0x9577}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x82", 3, 0x9802}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xa5", 3, 0x9CE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x85", 3, 0x52C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x97", 3, 0x6357}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xb4", 3, 0x76F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x95", 3, 0x6715}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x88", 3, 0x6C88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x8d", 3, 0x73CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x83", 3, 0x8CC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xae", 3, 0x93AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb3", 3, 0x9673}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xa5", 3, 0x6D25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\x9c", 3, 0x589C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x8e", 3, 0x690E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x8c", 3, 0x69CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xbd", 3, 0x8FFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\x9a", 3, 0x939A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x9b", 3, 0x75DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x9a", 3, 0x901A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x9a", 3, 0x585A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x82", 3, 0x6802}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xb4", 3, 0x63B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xbb", 3, 0x69FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x83", 3, 0x4F43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xac", 3, 0x6F2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x98", 3, 0x67D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xbb", 3, 0x8FBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\xa6", 3, 0x8526}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb4", 3, 0x7DB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x94", 3, 0x9354}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xbf", 3, 0x693F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xb0", 3, 0x6F70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xaa", 3, 0x576A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xb7", 3, 0x58F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xac", 3, 0x5B2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xac", 3, 0x7D2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xaa", 3, 0x722A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x8a", 3, 0x540A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa3", 3, 0x91E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xb4", 3, 0x9DB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xad", 3, 0x4EAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x8e", 3, 0x4F4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x9c", 3, 0x505C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb5", 3, 0x5075}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x83", 3, 0x5243}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x9e", 3, 0x8C9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x88", 3, 0x5448}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xa4", 3, 0x5824}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x9a", 3, 0x5B9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x9d", 3, 0x5E1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x95", 3, 0x5E95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xad", 3, 0x5EAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb7", 3, 0x5EF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x9f", 3, 0x5F1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x8c", 3, 0x608C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xb5", 3, 0x62B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xba", 3, 0x633A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x90", 3, 0x63D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xaf", 3, 0x68AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x80", 3, 0x6C40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x87", 3, 0x7887}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x8e", 3, 0x798E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x8b", 3, 0x7A0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xa0", 3, 0x7DE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x87", 3, 0x8247}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x82", 3, 0x8A02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xa6", 3, 0x8AE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x84", 3, 0x8E44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x93", 3, 0x9013}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xb8", 3, 0x90B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\xad", 3, 0x912D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x98", 3, 0x91D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\x8e", 3, 0x9F0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xa5", 3, 0x6CE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\x98", 3, 0x6458}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xa2", 3, 0x64E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xb5", 3, 0x6575}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xb4", 3, 0x6EF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x84", 3, 0x7684}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x9b", 3, 0x7B1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xa9", 3, 0x9069}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x91", 3, 0x93D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xba", 3, 0x6EBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xb2", 3, 0x54F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xb9", 3, 0x5FB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xa4", 3, 0x64A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x8d", 3, 0x8F4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xad", 3, 0x8FED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x84", 3, 0x9244}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xb8", 3, 0x5178}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xab", 3, 0x586B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xa9", 3, 0x5929}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x95", 3, 0x5C55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x97", 3, 0x5E97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xbb", 3, 0x6DFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x8f", 3, 0x7E8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x9c", 3, 0x751C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xbc", 3, 0x8CBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xa2", 3, 0x8EE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x9b", 3, 0x985B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xb9", 3, 0x70B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x9d", 3, 0x4F1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xbf", 3, 0x6BBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xb1", 3, 0x6FB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xb0", 3, 0x7530}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xbb", 3, 0x96FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x8e", 3, 0x514E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x90", 3, 0x5410}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xb5", 3, 0x5835}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x97", 3, 0x5857}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xac", 3, 0x59AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xa0", 3, 0x5C60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x92", 3, 0x5F92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x97", 3, 0x6597}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x9c", 3, 0x675C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa1", 3, 0x6E21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xbb", 3, 0x767B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x9f", 3, 0x83DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xad", 3, 0x8CED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x94", 3, 0x9014}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xbd", 3, 0x90FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x8d", 3, 0x934D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xa5", 3, 0x7825}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xba", 3, 0x783A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xaa", 3, 0x52AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xa6", 3, 0x5EA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x9f", 3, 0x571F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xb4", 3, 0x5974}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x92", 3, 0x6012}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x92", 3, 0x5012}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x9a", 3, 0x515A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xac", 3, 0x51AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x8d", 3, 0x51CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x80", 3, 0x5200}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x90", 3, 0x5510}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x94", 3, 0x5854}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x98", 3, 0x5858}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x97", 3, 0x5957}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x95", 3, 0x5B95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xb6", 3, 0x5CF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x8b", 3, 0x5D8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xbc", 3, 0x60BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x95", 3, 0x6295}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xad", 3, 0x642D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xb1", 3, 0x6771}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x83", 3, 0x6843}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xbc", 3, 0x68BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x9f", 3, 0x68DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x97", 3, 0x76D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x98", 3, 0x6DD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xaf", 3, 0x6E6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x9b", 3, 0x6D9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xaf", 3, 0x706F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x88", 3, 0x71C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x93", 3, 0x5F53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x98", 3, 0x75D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xb7", 3, 0x7977}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x89", 3, 0x7B49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x94", 3, 0x7B54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x92", 3, 0x7B52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x96", 3, 0x7CD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xb1", 3, 0x7D71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xb0", 3, 0x5230}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xa3", 3, 0x8463}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xa9", 3, 0x8569}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xa4", 3, 0x85E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x8e", 3, 0x8A0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x84", 3, 0x8B04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x86", 3, 0x8C46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x8f", 3, 0x8E0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x83", 3, 0x9003}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x8f", 3, 0x900F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x99", 3, 0x9419}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb6", 3, 0x9676}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xad", 3, 0x982D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\xb0", 3, 0x9A30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x98", 3, 0x95D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x8d", 3, 0x50CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x95", 3, 0x52D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x8c", 3, 0x540C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x82", 3, 0x5802}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x8e", 3, 0x5C0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xa7", 3, 0x61A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x9e", 3, 0x649E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x9e", 3, 0x6D1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xb3", 3, 0x77B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa5", 3, 0x7AE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xb4", 3, 0x80F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x84", 3, 0x8404}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x93", 3, 0x9053}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x85", 3, 0x9285}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xa0", 3, 0x5CE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x87", 3, 0x9D07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xbf", 3, 0x533F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x97", 3, 0x5F97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xb3", 3, 0x5FB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x9c", 3, 0x6D9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xb9", 3, 0x7279}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xa3", 3, 0x7763}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xbf", 3, 0x79BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xa4", 3, 0x7BE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x92", 3, 0x6BD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xac", 3, 0x72EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xad", 3, 0x8AAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x83", 3, 0x6803}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xa1", 3, 0x6A61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xb8", 3, 0x51F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x81", 3, 0x7A81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xb4", 3, 0x6934}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x8a", 3, 0x5C4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xb6", 3, 0x9CF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xab", 3, 0x82EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x85", 3, 0x5BC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x89", 3, 0x9149}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x9e", 3, 0x701E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xb8", 3, 0x5678}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xaf", 3, 0x5C6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x87", 3, 0x60C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xa6", 3, 0x6566}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x8c", 3, 0x6C8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x9a", 3, 0x8C5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x81", 3, 0x9041}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x93", 3, 0x9813}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x91", 3, 0x5451}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x87", 3, 0x66C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x8d", 3, 0x920D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x88", 3, 0x5948}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xa3", 3, 0x90A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x85", 3, 0x5185}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x8d", 3, 0x4E4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xaa", 3, 0x51EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x99", 3, 0x8599}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x8e", 3, 0x8B0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\x98", 3, 0x7058}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xba", 3, 0x637A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x8b", 3, 0x934B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xa2", 3, 0x6962}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xb4", 3, 0x99B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x84", 3, 0x7E04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xb7", 3, 0x7577}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x97", 3, 0x5357}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xa0", 3, 0x6960}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x9f", 3, 0x8EDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xa3", 3, 0x96E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x9d", 3, 0x6C5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x8c", 3, 0x4E8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xbc", 3, 0x5C3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x90", 3, 0x5F10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xa9", 3, 0x8FE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x82", 3, 0x5302}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x91", 3, 0x8CD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x89", 3, 0x8089}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\xb9", 3, 0x8679}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xbf", 3, 0x5EFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa5", 3, 0x65E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\xb3", 3, 0x4E73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xa5", 3, 0x5165}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x82", 3, 0x5982}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xbf", 3, 0x5C3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xae", 3, 0x97EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xbb", 3, 0x4EFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x8a", 3, 0x598A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x8d", 3, 0x5FCD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x8d", 3, 0x8A8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xa1", 3, 0x6FE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xb0", 3, 0x79B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xa2", 3, 0x7962}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa7", 3, 0x5BE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xb1", 3, 0x8471}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xab", 3, 0x732B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\xb1", 3, 0x71B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb4", 3, 0x5E74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xb5", 3, 0x5FF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xbb", 3, 0x637B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x9a", 3, 0x649A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x83", 3, 0x71C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x98", 3, 0x7C98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x83", 3, 0x4E43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xbc", 3, 0x5EFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x8b", 3, 0x4E4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x9c", 3, 0x57DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xa2", 3, 0x56A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xa9", 3, 0x60A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x83", 3, 0x6FC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x8d", 3, 0x7D0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xbd", 3, 0x80FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xb3", 3, 0x8133}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xbf", 3, 0x81BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xb2", 3, 0x8FB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x97", 3, 0x8997}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xa4", 3, 0x86A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xb4", 3, 0x5DF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x8a", 3, 0x628A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xad", 3, 0x64AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x87", 3, 0x8987}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xb7", 3, 0x6777}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xa2", 3, 0x6CE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xbe", 3, 0x6D3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xb6", 3, 0x7436}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xb4", 3, 0x7834}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\x86", 3, 0x5A46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xb5", 3, 0x7F75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xad", 3, 0x82AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xac", 3, 0x99AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xb3", 3, 0x4FF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x83", 3, 0x5EC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x9d", 3, 0x62DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x92", 3, 0x6392}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x97", 3, 0x6557}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xaf", 3, 0x676F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x83", 3, 0x76C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x8c", 3, 0x724C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x8c", 3, 0x80CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xba", 3, 0x80BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xa9", 3, 0x8F29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x8d", 3, 0x914D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x8d", 3, 0x500D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xb9", 3, 0x57F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaa\x92", 3, 0x5A92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x85", 3, 0x6885}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xb3", 3, 0x6973}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xa4", 3, 0x7164}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xbd", 3, 0x72FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb7", 3, 0x8CB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xb2", 3, 0x58F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xa0", 3, 0x8CE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xaa", 3, 0x966A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x99", 3, 0x9019}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xbf", 3, 0x877F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xa4", 3, 0x79E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xa7", 3, 0x77E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xa9", 3, 0x8429}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xaf", 3, 0x4F2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xa5", 3, 0x5265}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x9a", 3, 0x535A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x8d", 3, 0x62CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x8f", 3, 0x67CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x8a", 3, 0x6CCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xbd", 3, 0x767D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x94", 3, 0x7B94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x95", 3, 0x7C95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xb6", 3, 0x8236}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x84", 3, 0x8584}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xab", 3, 0x8FEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x9d", 3, 0x66DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xa0", 3, 0x6F20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\x86", 3, 0x7206}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x9b", 3, 0x7E1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xab", 3, 0x83AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x81", 3, 0x99C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xa6", 3, 0x9EA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xbd", 3, 0x51FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\xb1", 3, 0x7BB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xb2", 3, 0x7872}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\xb8", 3, 0x7BB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x87", 3, 0x8087}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x88", 3, 0x7B48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xa8", 3, 0x6AE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xa1", 3, 0x5E61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x8c", 3, 0x808C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x91", 3, 0x7551}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa0", 3, 0x7560}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xab", 3, 0x516B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xa2", 3, 0x9262}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x8c", 3, 0x6E8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xba", 3, 0x767A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x97", 3, 0x9197}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xaa", 3, 0x9AEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x90", 3, 0x4F10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xb0", 3, 0x7F70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x9c", 3, 0x629C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x8f", 3, 0x7B4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa5", 3, 0x95A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xa9", 3, 0x9CE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xba", 3, 0x567A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x99", 3, 0x5859}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xa4", 3, 0x86E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xbc", 3, 0x96BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xb4", 3, 0x4F34}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xa4", 3, 0x5224}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x8a", 3, 0x534A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x8d", 3, 0x53CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x9b", 3, 0x53DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x86", 3, 0x5E06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xac", 3, 0x642C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x91", 3, 0x6591}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xbf", 3, 0x677F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xbe", 3, 0x6C3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x8e", 3, 0x6C4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x88", 3, 0x7248}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xaf", 3, 0x72AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xad", 3, 0x73ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x94", 3, 0x7554}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x81", 3, 0x7E41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xac", 3, 0x822C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xa9", 3, 0x85E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xa9", 3, 0x8CA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x84", 3, 0x7BC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x86", 3, 0x91C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xa9", 3, 0x7169}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x92", 3, 0x9812}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xaf", 3, 0x98EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xbd", 3, 0x633D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa9", 3, 0x6669}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xaa", 3, 0x756A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xa4", 3, 0x76E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x90", 3, 0x78D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x83", 3, 0x8543}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xae", 3, 0x86EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xaa", 3, 0x532A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x91", 3, 0x5351}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xa6", 3, 0x5426}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x83", 3, 0x5983}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x87", 3, 0x5E87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xbc", 3, 0x5F7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xb2", 3, 0x60B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x89", 3, 0x6249}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xb9", 3, 0x6279}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xab", 3, 0x62AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x90", 3, 0x6590}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x94", 3, 0x6BD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x8c", 3, 0x6CCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xb2", 3, 0x75B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xae", 3, 0x76AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x91", 3, 0x7891}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x98", 3, 0x79D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x8b", 3, 0x7DCB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xb7", 3, 0x7F77}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xa5", 3, 0x80A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xab", 3, 0x88AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xb9", 3, 0x8AB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xbb", 3, 0x8CBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xbf", 3, 0x907F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x9e", 3, 0x975E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\x9b", 3, 0x98DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x8b", 3, 0x6A0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xb8", 3, 0x7C38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x99", 3, 0x5099}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xbe", 3, 0x5C3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xae", 3, 0x5FAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x87", 3, 0x6787}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x98", 3, 0x6BD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xb5", 3, 0x7435}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x89", 3, 0x7709}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x8e", 3, 0x7F8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\xbb", 3, 0x9F3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x8a", 3, 0x67CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x97", 3, 0x7A17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xb9", 3, 0x5339}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x8b", 3, 0x758B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xad", 3, 0x9AED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xa6", 3, 0x5F66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x9d", 3, 0x819D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb1", 3, 0x83F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x98", 3, 0x8098}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xbc", 3, 0x5F3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x85", 3, 0x5FC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa2", 3, 0x7562}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x86", 3, 0x7B46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xbc", 3, 0x903C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xa7", 3, 0x6867}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xab", 3, 0x59EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaa\x9b", 3, 0x5A9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x90", 3, 0x7D10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xbe", 3, 0x767E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xac", 3, 0x8B2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xb5", 3, 0x4FF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xaa", 3, 0x5F6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x99", 3, 0x6A19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xb7", 3, 0x6C37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x82", 3, 0x6F02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xa2", 3, 0x74E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xa8", 3, 0x7968}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xa8", 3, 0x8868}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x95", 3, 0x8A55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xb9", 3, 0x8C79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x9f", 3, 0x5EDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x8f", 3, 0x63CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x85", 3, 0x75C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x92", 3, 0x79D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x97", 3, 0x82D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa8", 3, 0x9328}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xb2", 3, 0x92F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x9c", 3, 0x849C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xad", 3, 0x86ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xad", 3, 0x9C2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x81", 3, 0x54C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xac", 3, 0x5F6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x8c", 3, 0x658C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\x9c", 3, 0x6D5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x95", 3, 0x7015}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xa7", 3, 0x8CA7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x93", 3, 0x8CD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xbb", 3, 0x983B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x8f", 3, 0x654F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xb6", 3, 0x74F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x8d", 3, 0x4E0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x98", 3, 0x4ED8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xa0", 3, 0x57E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xab", 3, 0x592B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\xa6", 3, 0x5A66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x8c", 3, 0x5BCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa8", 3, 0x51A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x83", 3, 0x5E03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x9c", 3, 0x5E9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x96", 3, 0x6016}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xb6", 3, 0x6276}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xb7", 3, 0x6577}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xa7", 3, 0x65A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xae", 3, 0x666E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xae", 3, 0x6D6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xb6", 3, 0x7236}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xa6", 3, 0x7B26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x90", 3, 0x8150}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x9a", 3, 0x819A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\x99", 3, 0x8299}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x9c", 3, 0x8B5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xa0", 3, 0x8CA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xa6", 3, 0x8CE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb4", 3, 0x8D74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\x9c", 3, 0x961C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x84", 3, 0x9644}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xae", 3, 0x4FAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xab", 3, 0x64AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xa6", 3, 0x6B66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x9e", 3, 0x821E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xa1", 3, 0x8461}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xaa", 3, 0x856A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xa8", 3, 0x90E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x81", 3, 0x5C01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x93", 3, 0x6953}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa2\xa8", 3, 0x98A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xba", 3, 0x847A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x97", 3, 0x8557}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x8f", 3, 0x4F0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xaf", 3, 0x526F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xa9", 3, 0x5FA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x85", 3, 0x5E45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x8d", 3, 0x670D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x8f", 3, 0x798F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xb9", 3, 0x8179}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x87", 3, 0x8907}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x86", 3, 0x8986}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb5", 3, 0x6DF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x97", 3, 0x5F17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x95", 3, 0x6255}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xb8", 3, 0x6CB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x8f", 3, 0x4ECF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xa9", 3, 0x7269}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x92", 3, 0x9B92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x86", 3, 0x5206}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xbb", 3, 0x543B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xb4", 3, 0x5674}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xb3", 3, 0x58B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xa4", 3, 0x61A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xae", 3, 0x626E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x9a", 3, 0x711A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xae", 3, 0x596E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x89", 3, 0x7C89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x9e", 3, 0x7CDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x9b", 3, 0x7D1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xb0", 3, 0x96F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x87", 3, 0x6587}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x9e", 3, 0x805E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x99", 3, 0x4E19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xb5", 3, 0x4F75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xb5", 3, 0x5175}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x80", 3, 0x5840}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xa3", 3, 0x5E63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb3", 3, 0x5E73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x8a", 3, 0x5F0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x84", 3, 0x67C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xa6", 3, 0x4E26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\xbd", 3, 0x853D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x89", 3, 0x9589}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x9b", 3, 0x965B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xb3", 3, 0x7C73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x81", 3, 0x9801}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xbb", 3, 0x50FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x81", 3, 0x58C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x96", 3, 0x7656}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xa7", 3, 0x78A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xa5", 3, 0x5225}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xa5", 3, 0x77A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x91", 3, 0x8511}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x86", 3, 0x7B86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x8f", 3, 0x504F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x89", 3, 0x5909}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x87", 3, 0x7247}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x87", 3, 0x7BC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xa8", 3, 0x7DE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xba", 3, 0x8FBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x94", 3, 0x8FD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x8d", 3, 0x904D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xbf", 3, 0x4FBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x89", 3, 0x52C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xa9", 3, 0x5A29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x81", 3, 0x5F01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xad", 3, 0x97AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x9d", 3, 0x4FDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x97", 3, 0x8217}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xaa", 3, 0x92EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x83", 3, 0x5703}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x95", 3, 0x6355}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xa9", 3, 0x6B69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xab", 3, 0x752B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x9c", 3, 0x88DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x94", 3, 0x8F14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x82", 3, 0x7A42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x9f", 3, 0x52DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\x93", 3, 0x5893}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x95", 3, 0x6155}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x8a", 3, 0x620A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xae", 3, 0x66AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x8d", 3, 0x6BCD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xbf", 3, 0x7C3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xa9", 3, 0x83E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa3", 3, 0x5023}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xb8", 3, 0x4FF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x85", 3, 0x5305}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x86", 3, 0x5446}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xb1", 3, 0x5831}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x89", 3, 0x5949}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x9d", 3, 0x5B9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xb0", 3, 0x5CF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xaf", 3, 0x5CEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\xa9", 3, 0x5D29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\x96", 3, 0x5E96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xb1", 3, 0x62B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xa7", 3, 0x6367}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xbe", 3, 0x653E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xb9", 3, 0x65B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x8b", 3, 0x670B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x95", 3, 0x6CD5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xa1", 3, 0x6CE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\xb9", 3, 0x70F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xb2", 3, 0x7832}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xab", 3, 0x7E2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x9e", 3, 0x80DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xb3", 3, 0x82B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x8c", 3, 0x840C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\xac", 3, 0x84EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x82", 3, 0x8702}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x92", 3, 0x8912}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xaa", 3, 0x8A2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x8a", 3, 0x8C4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xa6", 3, 0x90A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x92", 3, 0x92D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xbd", 3, 0x98FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xb3", 3, 0x9CF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xac", 3, 0x9D6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x8f", 3, 0x4E4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa1", 3, 0x4EA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x8d", 3, 0x508D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x96", 3, 0x5256}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x8a", 3, 0x574A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xa8", 3, 0x59A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xbd", 3, 0x5E3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x98", 3, 0x5FD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x99", 3, 0x5FD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xbf", 3, 0x623F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xb4", 3, 0x66B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x9b", 3, 0x671B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x90", 3, 0x67D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x92", 3, 0x68D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x92", 3, 0x5192}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xa1", 3, 0x7D21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xaa", 3, 0x80AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xa8", 3, 0x81A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x80", 3, 0x8B00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x8c", 3, 0x8C8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xbf", 3, 0x8CBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xbe", 3, 0x927E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xb2", 3, 0x9632}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xa0", 3, 0x5420}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xac", 3, 0x982C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x97", 3, 0x5317}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x95", 3, 0x50D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x9c", 3, 0x535C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xa8", 3, 0x58A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xb2", 3, 0x64B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xb4", 3, 0x6734}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xa7", 3, 0x7267}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xa6", 3, 0x7766}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x86", 3, 0x7A46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa6", 3, 0x91E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x83", 3, 0x52C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xa1", 3, 0x6CA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x86", 3, 0x6B86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x80", 3, 0x5800}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x8c", 3, 0x5E4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x94", 3, 0x5954}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xac", 3, 0x672C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xbb", 3, 0x7FFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xa1", 3, 0x51E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x86", 3, 0x76C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xa9", 3, 0x6469}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\xa8", 3, 0x78E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x94", 3, 0x9B54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xbb", 3, 0x9EBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x8b", 3, 0x57CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xb9", 3, 0x59B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xa7", 3, 0x6627}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x9a", 3, 0x679A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x8e", 3, 0x6BCE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xa9", 3, 0x54E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x99", 3, 0x69D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x95", 3, 0x5E55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x9c", 3, 0x819C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x95", 3, 0x6795}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xaa", 3, 0x9BAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xbe", 3, 0x67FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\x92", 3, 0x9C52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x9d", 3, 0x685D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa6", 3, 0x4EA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xa3", 3, 0x4FE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x88", 3, 0x53C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xb9", 3, 0x62B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xab", 3, 0x672B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xab", 3, 0x6CAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x84", 3, 0x8FC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xad", 3, 0x4FAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xad", 3, 0x7E6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xbf", 3, 0x9EBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x87", 3, 0x4E07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xa2", 3, 0x6162}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x80", 3, 0x6E80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xab", 3, 0x6F2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x93", 3, 0x8513}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xb3", 3, 0x5473}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xaa", 3, 0x672A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x85", 3, 0x9B45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xb3", 3, 0x5DF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x95", 3, 0x7B95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xac", 3, 0x5CAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x86", 3, 0x5BC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x9c", 3, 0x871C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x8a", 3, 0x6E4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x91", 3, 0x84D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x94", 3, 0x7A14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x88", 3, 0x8108}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x99", 3, 0x5999}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x8d", 3, 0x7C8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x91", 3, 0x6C11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xa0", 3, 0x7720}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x99", 3, 0x52D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xa2", 3, 0x5922}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\xa1", 3, 0x7121}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x9f", 3, 0x725F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\x9b", 3, 0x77DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xa7", 3, 0x9727}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xa1", 3, 0x9D61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x8b", 3, 0x690B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\xbf", 3, 0x5A7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x98", 3, 0x5A18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa5", 3, 0x51A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x8d", 3, 0x540D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xbd", 3, 0x547D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x8e", 3, 0x660E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x9f", 3, 0x76DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xb7", 3, 0x8FF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x98", 3, 0x9298}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xb4", 3, 0x9CF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xaa", 3, 0x59EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x9d", 3, 0x725D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x85", 3, 0x6EC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x8d", 3, 0x514D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x89", 3, 0x68C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xbf", 3, 0x7DBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xac", 3, 0x7DEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa2", 3, 0x9762}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xba", 3, 0x9EBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xb8", 3, 0x6478}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xa1", 3, 0x6A21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x82", 3, 0x8302}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x84", 3, 0x5984}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x9f", 3, 0x5B5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x9b", 3, 0x6BDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x9b", 3, 0x731B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xb2", 3, 0x76F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb2", 3, 0x7DB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x97", 3, 0x8017}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x99", 3, 0x8499}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xb2", 3, 0x5132}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xa8", 3, 0x6728}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x99", 3, 0x9ED9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xae", 3, 0x76EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xa2", 3, 0x6762}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xbf", 3, 0x52FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x85", 3, 0x9905}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xa4", 3, 0x5C24}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xbb", 3, 0x623B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xbe", 3, 0x7C7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb0", 3, 0x8CB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x8f", 3, 0x554F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xb6", 3, 0x60B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x8b", 3, 0x7D0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x80", 3, 0x9580}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x81", 3, 0x5301}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x9f", 3, 0x4E5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb6", 3, 0x51B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x9c", 3, 0x591C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xba", 3, 0x723A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xb6", 3, 0x8036}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x8e", 3, 0x91CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xa5", 3, 0x5F25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xa2", 3, 0x77E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x84", 3, 0x5384}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xb9", 3, 0x5F79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x84", 3, 0x7D04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xac", 3, 0x85AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xb3", 3, 0x8A33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x8d", 3, 0x8E8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x96", 3, 0x9756}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xb3", 3, 0x67F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xae", 3, 0x85AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x93", 3, 0x9453}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x89", 3, 0x6109}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x88", 3, 0x6108}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xb9", 3, 0x6CB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x92", 3, 0x7652}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xad", 3, 0x8AED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xb8", 3, 0x8F38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xaf", 3, 0x552F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x91", 3, 0x4F51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xaa", 3, 0x512A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x87", 3, 0x52C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x8b", 3, 0x53CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xa5", 3, 0x5BA5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xbd", 3, 0x5E7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xa0", 3, 0x60A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x82", 3, 0x6182}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x96", 3, 0x63D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x89", 3, 0x6709}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x9a", 3, 0x67DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xa7", 3, 0x6E67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x8c", 3, 0x6D8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xb6", 3, 0x7336}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xb7", 3, 0x7337}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xb1", 3, 0x7531}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x90", 3, 0x7950}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x95", 3, 0x88D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x98", 3, 0x8A98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x8a", 3, 0x904A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x91", 3, 0x9091}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xb5", 3, 0x90F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x84", 3, 0x96C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\x8d", 3, 0x878D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x95", 3, 0x5915}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x88", 3, 0x4E88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x99", 3, 0x4F59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x8e", 3, 0x4E0E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x89", 3, 0x8A89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xbf", 3, 0x8F3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x90", 3, 0x9810}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xad", 3, 0x50AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xbc", 3, 0x5E7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x96", 3, 0x5996}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb9", 3, 0x5BB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xb8", 3, 0x5EB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x9a", 3, 0x63DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xba", 3, 0x63FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x81", 3, 0x64C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x9c", 3, 0x66DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x8a", 3, 0x694A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x98", 3, 0x69D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x8b", 3, 0x6D0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xb6", 3, 0x6EB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x94", 3, 0x7194}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xa8", 3, 0x7528}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xaf", 3, 0x7AAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x8a", 3, 0x7F8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x80", 3, 0x8000}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x89", 3, 0x8449}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x89", 3, 0x84C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x81", 3, 0x8981}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xa1", 3, 0x8B21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x8a", 3, 0x8E0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xa5", 3, 0x9065}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xbd", 3, 0x967D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x8a", 3, 0x990A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xbe", 3, 0x617E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x91", 3, 0x6291}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xb2", 3, 0x6B32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x83", 3, 0x6C83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xb4", 3, 0x6D74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x8c", 3, 0x7FCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xbc", 3, 0x7FFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x80", 3, 0x6DC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x85", 3, 0x7F85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xba", 3, 0x87BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb8", 3, 0x88F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xa5", 3, 0x6765}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xb1", 3, 0x83B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xbc", 3, 0x983C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xb7", 3, 0x96F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x9b", 3, 0x6D1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xa1", 3, 0x7D61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xbd", 3, 0x843D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xaa", 3, 0x916A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\xb1", 3, 0x4E71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb5", 3, 0x5375}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x90", 3, 0x5D50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x84", 3, 0x6B04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xab", 3, 0x6FEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x8d", 3, 0x85CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\xad", 3, 0x862D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xa7", 3, 0x89A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xa9", 3, 0x5229}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x8f", 3, 0x540F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xa5", 3, 0x5C65}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x8e", 3, 0x674E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xa8", 3, 0x68A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\x86", 3, 0x7406}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x83", 3, 0x7483}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xa2", 3, 0x75E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x8f", 3, 0x88CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xa1", 3, 0x88E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x8c", 3, 0x91CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xa2", 3, 0x96E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb8", 3, 0x9678}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x8b", 3, 0x5F8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\x87", 3, 0x7387}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x8b", 3, 0x7ACB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x8e", 3, 0x844E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa0", 3, 0x63A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa5", 3, 0x7565}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x89", 3, 0x5289}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\x81", 3, 0x6D41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x9c", 3, 0x6E9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\x89", 3, 0x7409}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x99", 3, 0x7559}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xab", 3, 0x786B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x92", 3, 0x7C92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x86", 3, 0x9686}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x9c", 3, 0x7ADC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbe\x8d", 3, 0x9F8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xb6", 3, 0x4FB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xae", 3, 0x616E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x85", 3, 0x65C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x9c", 3, 0x865C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x86", 3, 0x4E86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xae", 3, 0x4EAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x9a", 3, 0x50DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xa1", 3, 0x4E21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x8c", 3, 0x51CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xae", 3, 0x5BEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x99", 3, 0x6599}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x81", 3, 0x6881}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xbc", 3, 0x6DBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x9f", 3, 0x731F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x82", 3, 0x7642}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xad", 3, 0x77AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x9c", 3, 0x7A1C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xa7", 3, 0x7CE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xaf", 3, 0x826F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x92", 3, 0x8AD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xbc", 3, 0x907C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x8f", 3, 0x91CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb5", 3, 0x9675}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x98", 3, 0x9818}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x9b", 3, 0x529B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x91", 3, 0x7DD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xab", 3, 0x502B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x98", 3, 0x5398}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x97", 3, 0x6797}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x8b", 3, 0x6DCB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x90", 3, 0x71D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xb3", 3, 0x7433}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xa8", 3, 0x81E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xaa", 3, 0x8F2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xa3", 3, 0x96A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\x97", 3, 0x9C57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x9f", 3, 0x9E9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xa0", 3, 0x7460}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x81", 3, 0x5841}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x99", 3, 0x6D99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xaf", 3, 0x7D2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x9e", 3, 0x985E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xa4", 3, 0x4EE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xb6", 3, 0x4F36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x8b", 3, 0x4F8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb7", 3, 0x51B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xb1", 3, 0x52B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xba", 3, 0x5DBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x9c", 3, 0x601C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\xb2", 3, 0x73B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xbc", 3, 0x793C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x93", 3, 0x82D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xb4", 3, 0x9234}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb7", 3, 0x96B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xb6", 3, 0x96F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x8a", 3, 0x970A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x97", 3, 0x9E97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xa2", 3, 0x9F62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xa6", 3, 0x66A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xb4", 3, 0x6B74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x97", 3, 0x5217}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xa3", 3, 0x52A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\x88", 3, 0x70C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x82", 3, 0x88C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x89", 3, 0x5EC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x8b", 3, 0x604B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x90", 3, 0x6190}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xa3", 3, 0x6F23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x89", 3, 0x7149}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xbe", 3, 0x7C3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xb4", 3, 0x7DF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xaf", 3, 0x806F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\xae", 3, 0x84EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xa3", 3, 0x9023}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xac", 3, 0x932C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x82", 3, 0x5442}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\xaf", 3, 0x9B6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x93", 3, 0x6AD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x89", 3, 0x7089}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x82", 3, 0x8CC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xaf", 3, 0x8DEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xb2", 3, 0x9732}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xb4", 3, 0x52B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\x81", 3, 0x5A41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x8a", 3, 0x5ECA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x84", 3, 0x5F04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x97", 3, 0x6717}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xbc", 3, 0x697C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x94", 3, 0x6994}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xaa", 3, 0x6D6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x8f", 3, 0x6F0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xa2", 3, 0x7262}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xbc", 3, 0x72FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xad", 3, 0x7BED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x81", 3, 0x8001}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xbe", 3, 0x807E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x8b", 3, 0x874B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\x8e", 3, 0x90CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xad", 3, 0x516D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x93", 3, 0x9E93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x84", 3, 0x7984}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x8b", 3, 0x808B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xb2", 3, 0x9332}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x96", 3, 0x8AD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xad", 3, 0x502D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x8c", 3, 0x548C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xb1", 3, 0x8A71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xaa", 3, 0x6B6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x84", 3, 0x8CC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x87", 3, 0x8107}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x91", 3, 0x60D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xa0", 3, 0x67A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xb2", 3, 0x9DF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x99", 3, 0x4E99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x98", 3, 0x4E98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x90", 3, 0x9C10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xab", 3, 0x8A6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x81", 3, 0x85C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xa8", 3, 0x8568}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x80", 3, 0x6900}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xbe", 3, 0x6E7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x97", 3, 0x7897}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x95", 3, 0x8155}, /* (<CJK Ideograph>) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe5\xbc\x8c", 3, 0x5F0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x90", 3, 0x4E10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x95", 3, 0x4E15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xaa", 3, 0x4E2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xb1", 3, 0x4E31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xb6", 3, 0x4E36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xbc", 3, 0x4E3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xbf", 3, 0x4E3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x82", 3, 0x4E42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x96", 3, 0x4E56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x98", 3, 0x4E58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x82", 3, 0x4E82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x85", 3, 0x4E85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xab", 3, 0x8C6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x8a", 3, 0x4E8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x92", 3, 0x8212}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x8d", 3, 0x5F0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x8e", 3, 0x4E8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x9e", 3, 0x4E9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\x9f", 3, 0x4E9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa0", 3, 0x4EA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xa2", 3, 0x4EA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xb0", 3, 0x4EB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xb3", 3, 0x4EB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xba\xb6", 3, 0x4EB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x8e", 3, 0x4ECE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x8d", 3, 0x4ECD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x84", 3, 0x4EC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x86", 3, 0x4EC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x82", 3, 0x4EC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x97", 3, 0x4ED7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x9e", 3, 0x4EDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xad", 3, 0x4EED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\x9f", 3, 0x4EDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xb7", 3, 0x4EF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x89", 3, 0x4F09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x9a", 3, 0x4F5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xb0", 3, 0x4F30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x9b", 3, 0x4F5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x9d", 3, 0x4F5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x97", 3, 0x4F57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x87", 3, 0x4F47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xb6", 3, 0x4F76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x88", 3, 0x4F88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x8f", 3, 0x4F8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x98", 3, 0x4F98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xbb", 3, 0x4F7B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xa9", 3, 0x4F69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xb0", 3, 0x4F70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x91", 3, 0x4F91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\xaf", 3, 0x4F6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x86", 3, 0x4F86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x96", 3, 0x4F96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x98", 3, 0x5118}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x94", 3, 0x4FD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x9f", 3, 0x4FDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x8e", 3, 0x4FCE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x98", 3, 0x4FD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x9b", 3, 0x4FDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x91", 3, 0x4FD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x9a", 3, 0x4FDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x90", 3, 0x4FD0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xa4", 3, 0x4FE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xa5", 3, 0x4FE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x9a", 3, 0x501A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa8", 3, 0x5028}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x94", 3, 0x5014}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xaa", 3, 0x502A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa5", 3, 0x5025}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x85", 3, 0x5005}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x9c", 3, 0x4F1C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xb6", 3, 0x4FF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa1", 3, 0x5021}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa9", 3, 0x5029}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xac", 3, 0x502C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xbe", 3, 0x4FFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xaf", 3, 0x4FEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x91", 3, 0x5011}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x86", 3, 0x5006}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x83", 3, 0x5043}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x87", 3, 0x5047}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x83", 3, 0x6703}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x95", 3, 0x5055}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x90", 3, 0x5050}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x88", 3, 0x5048}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x9a", 3, 0x505A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x96", 3, 0x5056}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xac", 3, 0x506C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb8", 3, 0x5078}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x80", 3, 0x5080}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x9a", 3, 0x509A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x85", 3, 0x5085}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xb4", 3, 0x50B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xb2", 3, 0x50B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x89", 3, 0x50C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x8a", 3, 0x50CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\xb3", 3, 0x50B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x82", 3, 0x50C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x96", 3, 0x50D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x9e", 3, 0x50DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xa5", 3, 0x50E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xad", 3, 0x50ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xa3", 3, 0x50E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xae", 3, 0x50EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xb9", 3, 0x50F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xb5", 3, 0x50F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x89", 3, 0x5109}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x81", 3, 0x5101}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x82", 3, 0x5102}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x96", 3, 0x5116}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x95", 3, 0x5115}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x94", 3, 0x5114}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\x9a", 3, 0x511A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xa1", 3, 0x5121}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xba", 3, 0x513A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xb7", 3, 0x5137}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xbc", 3, 0x513C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xbb", 3, 0x513B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x84\xbf", 3, 0x513F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x80", 3, 0x5140}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x92", 3, 0x5152}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x8c", 3, 0x514C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x94", 3, 0x5154}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xa2", 3, 0x5162}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xb8", 3, 0x7AF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xa9", 3, 0x5169}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xaa", 3, 0x516A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xae", 3, 0x516E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x80", 3, 0x5180}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x82", 3, 0x5182}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x98", 3, 0x56D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x8c", 3, 0x518C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x89", 3, 0x5189}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x8f", 3, 0x518F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x91", 3, 0x5191}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x93", 3, 0x5193}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x95", 3, 0x5195}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x96", 3, 0x5196}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa4", 3, 0x51A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa6", 3, 0x51A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa2", 3, 0x51A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xa9", 3, 0x51A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xaa", 3, 0x51AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xab", 3, 0x51AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb3", 3, 0x51B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb1", 3, 0x51B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb2", 3, 0x51B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb0", 3, 0x51B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xb5", 3, 0x51B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xbd", 3, 0x51BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x85", 3, 0x51C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x89", 3, 0x51C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x9b", 3, 0x51DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xa0", 3, 0x51E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x95", 3, 0x8655}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xa9", 3, 0x51E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xad", 3, 0x51ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xb0", 3, 0x51F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xb5", 3, 0x51F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xbe", 3, 0x51FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x84", 3, 0x5204}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x8b", 3, 0x520B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x94", 3, 0x5214}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x8e", 3, 0x520E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xa7", 3, 0x5227}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xaa", 3, 0x522A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xae", 3, 0x522E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xb3", 3, 0x5233}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\xb9", 3, 0x5239}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x8f", 3, 0x524F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x84", 3, 0x5244}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x8b", 3, 0x524B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x8c", 3, 0x524C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x9e", 3, 0x525E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\x94", 3, 0x5254}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xaa", 3, 0x526A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xb4", 3, 0x5274}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xa9", 3, 0x5269}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xb3", 3, 0x5273}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xbf", 3, 0x527F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xbd", 3, 0x527D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x8d", 3, 0x528D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x94", 3, 0x5294}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x92", 3, 0x5292}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x89\xb1", 3, 0x5271}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x88", 3, 0x5288}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x91", 3, 0x5291}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xa8", 3, 0x8FA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xa7", 3, 0x8FA7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xac", 3, 0x52AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xad", 3, 0x52AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xbc", 3, 0x52BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xb5", 3, 0x52B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x81", 3, 0x52C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x8d", 3, 0x52CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x97", 3, 0x52D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x9e", 3, 0x52DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xa3", 3, 0x52E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xa6", 3, 0x52E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xad", 3, 0x98ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xa0", 3, 0x52E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xb3", 3, 0x52F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xb5", 3, 0x52F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xb8", 3, 0x52F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\xb9", 3, 0x52F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x86", 3, 0x5306}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x88", 3, 0x5308}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xb8", 3, 0x7538}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x8d", 3, 0x530D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x90", 3, 0x5310}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x8f", 3, 0x530F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x95", 3, 0x5315}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x9a", 3, 0x531A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xa3", 3, 0x5323}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xaf", 3, 0x532F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xb1", 3, 0x5331}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xb3", 3, 0x5333}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xb8", 3, 0x5338}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x80", 3, 0x5340}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x86", 3, 0x5346}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x85", 3, 0x5345}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\x97", 3, 0x4E17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x89", 3, 0x5349}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x8d", 3, 0x534D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x96", 3, 0x51D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\x9e", 3, 0x535E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xa9", 3, 0x5369}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xae", 3, 0x536E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x98", 3, 0x5918}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xbb", 3, 0x537B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb7", 3, 0x5377}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x82", 3, 0x5382}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x96", 3, 0x5396}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xa0", 3, 0x53A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xa6", 3, 0x53A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xa5", 3, 0x53A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xae", 3, 0x53AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xb0", 3, 0x53B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xb6", 3, 0x53B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x83", 3, 0x53C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x92", 3, 0x7C12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x99", 3, 0x96D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x9f", 3, 0x53DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xbc", 3, 0x66FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xae", 3, 0x71EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xae", 3, 0x53EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xa8", 3, 0x53E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xad", 3, 0x53ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\xba", 3, 0x53FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x81", 3, 0x5401}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xbd", 3, 0x543D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x80", 3, 0x5440}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xac", 3, 0x542C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xad", 3, 0x542D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xbc", 3, 0x543C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xae", 3, 0x542E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xb6", 3, 0x5436}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\xa9", 3, 0x5429}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x90\x9d", 3, 0x541D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x8e", 3, 0x544E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x8f", 3, 0x548F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xb5", 3, 0x5475}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x8e", 3, 0x548E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\x9f", 3, 0x545F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xb1", 3, 0x5471}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xb7", 3, 0x5477}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xb0", 3, 0x5470}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x92", 3, 0x5492}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xbb", 3, 0x547B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x80", 3, 0x5480}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x91\xb6", 3, 0x5476}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x84", 3, 0x5484}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x90", 3, 0x5490}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x86", 3, 0x5486}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x87", 3, 0x54C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xa2", 3, 0x54A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xb8", 3, 0x54B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xa5", 3, 0x54A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xac", 3, 0x54AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x84", 3, 0x54C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x88", 3, 0x54C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xa8", 3, 0x54A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xab", 3, 0x54AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x82", 3, 0x54C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xa4", 3, 0x54A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xbe", 3, 0x54BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xbc", 3, 0x54BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\x98", 3, 0x54D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xa5", 3, 0x54E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xa6", 3, 0x54E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x8f", 3, 0x550F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\x94", 3, 0x5514}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xbd", 3, 0x54FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xae", 3, 0x54EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xad", 3, 0x54ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xba", 3, 0x54FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xa2", 3, 0x54E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xb9", 3, 0x5539}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x80", 3, 0x5540}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\xa3", 3, 0x5563}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x8c", 3, 0x554C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xae", 3, 0x552E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x9c", 3, 0x555C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x85", 3, 0x5545}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x96", 3, 0x5556}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x97", 3, 0x5557}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xb8", 3, 0x5538}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x94\xb3", 3, 0x5533}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\x9d", 3, 0x555D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x99", 3, 0x5599}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x80", 3, 0x5580}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xaf", 3, 0x54AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x8a", 3, 0x558A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x9f", 3, 0x559F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\xbb", 3, 0x557B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\xbe", 3, 0x557E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x98", 3, 0x5598}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x9e", 3, 0x559E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xae", 3, 0x55AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x95\xbc", 3, 0x557C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x83", 3, 0x5583}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xa9", 3, 0x55A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x87", 3, 0x5587}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\xa8", 3, 0x55A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x9a", 3, 0x55DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x85", 3, 0x55C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x9f", 3, 0x55DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x84", 3, 0x55C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x9c", 3, 0x55DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\xa4", 3, 0x55E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x94", 3, 0x55D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x94", 3, 0x5614}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\xb7", 3, 0x55F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x96", 3, 0x5616}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\xbe", 3, 0x55FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\xbd", 3, 0x55FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\x9b", 3, 0x561B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\xb9", 3, 0x55F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\x8e", 3, 0x564E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\x90", 3, 0x5650}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x9f", 3, 0x71DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xb4", 3, 0x5634}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xb6", 3, 0x5636}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xb2", 3, 0x5632}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xb8", 3, 0x5638}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xab", 3, 0x566B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xa4", 3, 0x5664}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x98\xaf", 3, 0x562F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xac", 3, 0x566C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x99\xaa", 3, 0x566A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\x86", 3, 0x5686}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\x80", 3, 0x5680}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\x8a", 3, 0x568A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xa0", 3, 0x56A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\x94", 3, 0x5694}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\x8f", 3, 0x568F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xa5", 3, 0x56A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xae", 3, 0x56AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xb6", 3, 0x56B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xb4", 3, 0x56B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x82", 3, 0x56C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9a\xbc", 3, 0x56BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x81", 3, 0x56C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x83", 3, 0x56C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x80", 3, 0x56C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x88", 3, 0x56C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x8e", 3, 0x56CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x91", 3, 0x56D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x93", 3, 0x56D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\x97", 3, 0x56D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xae", 3, 0x56EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xb9", 3, 0x56F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x80", 3, 0x5700}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9b\xbf", 3, 0x56FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x84", 3, 0x5704}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x89", 3, 0x5709}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x88", 3, 0x5708}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x8b", 3, 0x570B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x8d", 3, 0x570D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x93", 3, 0x5713}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x98", 3, 0x5718}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x96", 3, 0x5716}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x97\x87", 3, 0x55C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\x9c", 3, 0x571C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xa6", 3, 0x5726}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xb7", 3, 0x5737}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xb8", 3, 0x5738}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x8e", 3, 0x574E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9c\xbb", 3, 0x573B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x80", 3, 0x5740}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x8f", 3, 0x574F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xa9", 3, 0x5769}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x80", 3, 0x57C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\x88", 3, 0x5788}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xa1", 3, 0x5761}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xbf", 3, 0x577F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\x89", 3, 0x5789}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\x93", 3, 0x5793}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xa0", 3, 0x57A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xb3", 3, 0x57B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xa4", 3, 0x57A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xaa", 3, 0x57AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xb0", 3, 0x57B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x83", 3, 0x57C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x86", 3, 0x57C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x94", 3, 0x57D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x92", 3, 0x57D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x93", 3, 0x57D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x8a", 3, 0x580A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x96", 3, 0x57D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\xa3", 3, 0x57E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x8b", 3, 0x580B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x99", 3, 0x5819}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\x9d", 3, 0x581D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xb2", 3, 0x5872}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xa1", 3, 0x5821}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xa2", 3, 0x5862}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x8b", 3, 0x584B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xb0", 3, 0x5870}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x80", 3, 0x6BC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\x92", 3, 0x5852}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xbd", 3, 0x583D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa1\xb9", 3, 0x5879}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\x85", 3, 0x5885}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xb9", 3, 0x58B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\x9f", 3, 0x589F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xab", 3, 0x58AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xba", 3, 0x58BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x9e", 3, 0x58DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xbb", 3, 0x58BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xb8", 3, 0x58B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xae", 3, 0x58AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x85", 3, 0x58C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x93", 3, 0x58D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x91", 3, 0x58D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x97", 3, 0x58D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x99", 3, 0x58D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x98", 3, 0x58D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xa5", 3, 0x58E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x9c", 3, 0x58DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xa4", 3, 0x58E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\x9f", 3, 0x58DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xaf", 3, 0x58EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xba", 3, 0x58FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xb9", 3, 0x58F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xbb", 3, 0x58FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xbc", 3, 0x58FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa3\xbd", 3, 0x58FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x82", 3, 0x5902}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x8a", 3, 0x590A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x90", 3, 0x5910}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x9b", 3, 0x591B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xa6", 3, 0x68A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xa5", 3, 0x5925}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xac", 3, 0x592C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xad", 3, 0x592D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xb2", 3, 0x5932}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xb8", 3, 0x5938}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\xbe", 3, 0x593E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x92", 3, 0x7AD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x95", 3, 0x5955}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x90", 3, 0x5950}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x8e", 3, 0x594E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x9a", 3, 0x595A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x98", 3, 0x5958}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa2", 3, 0x5962}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa0", 3, 0x5960}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa7", 3, 0x5967}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xac", 3, 0x596C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa9", 3, 0x5969}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xb8", 3, 0x5978}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x81", 3, 0x5981}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x9d", 3, 0x599D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x9e", 3, 0x4F5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\xab", 3, 0x4FAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xa3", 3, 0x59A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xb2", 3, 0x59B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x86", 3, 0x59C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\xa8", 3, 0x59E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x9c", 3, 0x59DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x8d", 3, 0x598D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x99", 3, 0x59D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa7\x9a", 3, 0x59DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xa5", 3, 0x5A25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x9f", 3, 0x5A1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x91", 3, 0x5A11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x9c", 3, 0x5A1C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x89", 3, 0x5A09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\x9a", 3, 0x5A1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\x80", 3, 0x5A40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\xac", 3, 0x5A6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\x89", 3, 0x5A49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xb5", 3, 0x5A35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa8\xb6", 3, 0x5A36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\xa2", 3, 0x5A62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa9\xaa", 3, 0x5A6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaa\x9a", 3, 0x5A9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaa\xbc", 3, 0x5ABC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaa\xbe", 3, 0x5ABE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x8b", 3, 0x5ACB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x82", 3, 0x5AC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaa\xbd", 3, 0x5ABD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\xa3", 3, 0x5AE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x97", 3, 0x5AD7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\xa6", 3, 0x5AE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\xa9", 3, 0x5AE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x96", 3, 0x5AD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\xba", 3, 0x5AFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\xbb", 3, 0x5AFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\x8c", 3, 0x5B0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\x8b", 3, 0x5B0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\x96", 3, 0x5B16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xb2", 3, 0x5B32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xab\x90", 3, 0x5AD0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xaa", 3, 0x5B2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xb6", 3, 0x5B36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xac\xbe", 3, 0x5B3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x83", 3, 0x5B43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x85", 3, 0x5B45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x80", 3, 0x5B40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x91", 3, 0x5B51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x95", 3, 0x5B55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x9a", 3, 0x5B5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x9b", 3, 0x5B5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xa5", 3, 0x5B65}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xa9", 3, 0x5B69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xb0", 3, 0x5B70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xb3", 3, 0x5B73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xb5", 3, 0x5B75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xb8", 3, 0x5B78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x88", 3, 0x6588}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xba", 3, 0x5B7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x80", 3, 0x5B80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\x83", 3, 0x5B83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xa6", 3, 0x5BA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xae\xb8", 3, 0x5BB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x83", 3, 0x5BC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x87", 3, 0x5BC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x89", 3, 0x5BC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x94", 3, 0x5BD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x90", 3, 0x5BD0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa4", 3, 0x5BE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa6", 3, 0x5BE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa2", 3, 0x5BE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x9e", 3, 0x5BDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa5", 3, 0x5BE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xab", 3, 0x5BEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xb0", 3, 0x5BF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xb6", 3, 0x5BF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xb3", 3, 0x5BF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x85", 3, 0x5C05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x87", 3, 0x5C07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x88", 3, 0x5C08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x8d", 3, 0x5C0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x93", 3, 0x5C13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xa0", 3, 0x5C20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xa2", 3, 0x5C22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xa8", 3, 0x5C28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xb8", 3, 0x5C38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\xb9", 3, 0x5C39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x81", 3, 0x5C41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x86", 3, 0x5C46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x8e", 3, 0x5C4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x93", 3, 0x5C53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x90", 3, 0x5C50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\x8f", 3, 0x5C4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\xb1", 3, 0x5B71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xac", 3, 0x5C6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xae", 3, 0x5C6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\xa2", 3, 0x4E62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xb6", 3, 0x5C76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb1\xb9", 3, 0x5C79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\x8c", 3, 0x5C8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\x91", 3, 0x5C91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\x94", 3, 0x5C94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\x9b", 3, 0x599B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xab", 3, 0x5CAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xbb", 3, 0x5CBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xb6", 3, 0x5CB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xbc", 3, 0x5CBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xb7", 3, 0x5CB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\x85", 3, 0x5CC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xbe", 3, 0x5CBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\x87", 3, 0x5CC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\x99", 3, 0x5CD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xa9", 3, 0x5CE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xbd", 3, 0x5CFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xba", 3, 0x5CFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xad", 3, 0x5CED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x8c", 3, 0x5D8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xaa", 3, 0x5CEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x8b", 3, 0x5D0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x95", 3, 0x5D15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x97", 3, 0x5D17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x9c", 3, 0x5D5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x9f", 3, 0x5D1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x9b", 3, 0x5D1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x91", 3, 0x5D11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x94", 3, 0x5D14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\xa2", 3, 0x5D22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x9a", 3, 0x5D1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x99", 3, 0x5D19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\x98", 3, 0x5D18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x8c", 3, 0x5D4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x92", 3, 0x5D52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x8e", 3, 0x5D4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x8b", 3, 0x5D4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xac", 3, 0x5D6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xb3", 3, 0x5D73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xb6", 3, 0x5D76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x87", 3, 0x5D87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x84", 3, 0x5D84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x82", 3, 0x5D82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xa2", 3, 0x5DA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x9d", 3, 0x5D9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xac", 3, 0x5DAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xae", 3, 0x5DAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xbd", 3, 0x5DBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\x90", 3, 0x5D90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xb7", 3, 0x5DB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xbc", 3, 0x5DBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x89", 3, 0x5DC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x8d", 3, 0x5DCD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x93", 3, 0x5DD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x92", 3, 0x5DD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x96", 3, 0x5DD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x9b", 3, 0x5DDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xab", 3, 0x5DEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xb2", 3, 0x5DF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\xb5", 3, 0x5DF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x8b", 3, 0x5E0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x9a", 3, 0x5E1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x99", 3, 0x5E19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x91", 3, 0x5E11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\x9b", 3, 0x5E1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xb6", 3, 0x5E36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb8\xb7", 3, 0x5E37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x84", 3, 0x5E44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x83", 3, 0x5E43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x80", 3, 0x5E40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x8e", 3, 0x5E4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x97", 3, 0x5E57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x94", 3, 0x5E54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x9f", 3, 0x5E5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xa2", 3, 0x5E62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xa4", 3, 0x5E64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\x87", 3, 0x5E47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb5", 3, 0x5E75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xb6", 3, 0x5E76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xba", 3, 0x5E7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xbc", 3, 0x9EBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb9\xbf", 3, 0x5E7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xba\xa0", 3, 0x5EA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x81", 3, 0x5EC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x82", 3, 0x5EC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x88", 3, 0x5EC8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x90", 3, 0x5ED0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x8f", 3, 0x5ECF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x96", 3, 0x5ED6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xa3", 3, 0x5EE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x9d", 3, 0x5EDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x9a", 3, 0x5EDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\x9b", 3, 0x5EDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xa2", 3, 0x5EE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xa1", 3, 0x5EE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xa8", 3, 0x5EE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xa9", 3, 0x5EE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xac", 3, 0x5EEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb1", 3, 0x5EF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb3", 3, 0x5EF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb0", 3, 0x5EF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb4", 3, 0x5EF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xb8", 3, 0x5EF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbb\xbe", 3, 0x5EFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x83", 3, 0x5F03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x89", 3, 0x5F09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x9d", 3, 0x5F5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x9c", 3, 0x5F5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x8b", 3, 0x5F0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x91", 3, 0x5F11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\x96", 3, 0x5F16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xa9", 3, 0x5F29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xad", 3, 0x5F2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xb8", 3, 0x5F38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x81", 3, 0x5F41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x88", 3, 0x5F48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x8c", 3, 0x5F4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x8e", 3, 0x5F4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xaf", 3, 0x5F2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x91", 3, 0x5F51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x96", 3, 0x5F56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x97", 3, 0x5F57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x99", 3, 0x5F59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xa1", 3, 0x5F61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xad", 3, 0x5F6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xb3", 3, 0x5F73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xb7", 3, 0x5F77}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x83", 3, 0x5F83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x82", 3, 0x5F82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xbf", 3, 0x5F7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x8a", 3, 0x5F8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x88", 3, 0x5F88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x91", 3, 0x5F91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x87", 3, 0x5F87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x9e", 3, 0x5F9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x99", 3, 0x5F99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\x98", 3, 0x5F98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xa0", 3, 0x5FA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xa8", 3, 0x5FA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xad", 3, 0x5FAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xbc", 3, 0x5FBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x96", 3, 0x5FD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xbb", 3, 0x5FFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xa4", 3, 0x5FE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xb8", 3, 0x5FF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xb1", 3, 0x5FF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x9d", 3, 0x5FDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xb3", 3, 0x60B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xbf", 3, 0x5FFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa1", 3, 0x6021}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa0", 3, 0x6060}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x99", 3, 0x6019}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x90", 3, 0x6010}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa9", 3, 0x6029}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x8e", 3, 0x600E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xb1", 3, 0x6031}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x9b", 3, 0x601B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x95", 3, 0x6015}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xab", 3, 0x602B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xa6", 3, 0x6026}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\x8f", 3, 0x600F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x80\xba", 3, 0x603A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x9a", 3, 0x605A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x81", 3, 0x6041}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xaa", 3, 0x606A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xb7", 3, 0x6077}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x9f", 3, 0x605F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x8a", 3, 0x604A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x86", 3, 0x6046}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x8d", 3, 0x604D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa3", 3, 0x6063}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x83", 3, 0x6043}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xa4", 3, 0x6064}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x82", 3, 0x6042}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xac", 3, 0x606C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\xab", 3, 0x606B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x99", 3, 0x6059}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x81", 3, 0x6081}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x8d", 3, 0x608D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xa7", 3, 0x60E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x83", 3, 0x6083}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x9a", 3, 0x609A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x84", 3, 0x6084}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x9b", 3, 0x609B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x96", 3, 0x6096}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x97", 3, 0x6097}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x92", 3, 0x6092}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xa7", 3, 0x60A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x8b", 3, 0x608B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xa1", 3, 0x60E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xb8", 3, 0x60B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xa0", 3, 0x60E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x93", 3, 0x60D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xb4", 3, 0x60B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\xb0", 3, 0x5FF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xbd", 3, 0x60BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x86", 3, 0x60C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\xb5", 3, 0x60B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x98", 3, 0x60D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x8d", 3, 0x614D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x95", 3, 0x6115}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x86", 3, 0x6106}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb6", 3, 0x60F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb7", 3, 0x60F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x80", 3, 0x6100}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb4", 3, 0x60F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xba", 3, 0x60FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x83", 3, 0x6103}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xa1", 3, 0x6121}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xbb", 3, 0x60FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb1", 3, 0x60F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x8d", 3, 0x610D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x8e", 3, 0x610E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x87", 3, 0x6147}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xbe", 3, 0x613E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xa8", 3, 0x6128}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xa7", 3, 0x6127}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x8a", 3, 0x614A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xbf", 3, 0x613F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xbc", 3, 0x613C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xac", 3, 0x612C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xb4", 3, 0x6134}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xbd", 3, 0x613D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x82", 3, 0x6142}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x84", 3, 0x6144}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb3", 3, 0x6173}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb7", 3, 0x6177}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x98", 3, 0x6158}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x99", 3, 0x6159}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x9a", 3, 0x615A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xab", 3, 0x616B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb4", 3, 0x6174}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xaf", 3, 0x616F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xa5", 3, 0x6165}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb1", 3, 0x6171}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x9f", 3, 0x615F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x9d", 3, 0x615D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\x93", 3, 0x6153}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x85\xb5", 3, 0x6175}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x99", 3, 0x6199}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x96", 3, 0x6196}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x87", 3, 0x6187}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xac", 3, 0x61AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x94", 3, 0x6194}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x9a", 3, 0x619A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x8a", 3, 0x618A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x91", 3, 0x6191}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xab", 3, 0x61AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xae", 3, 0x61AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x8c", 3, 0x61CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x8a", 3, 0x61CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x89", 3, 0x61C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xb7", 3, 0x61F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x88", 3, 0x61C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x83", 3, 0x61C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x86", 3, 0x61C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\xba", 3, 0x61BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x8b", 3, 0x61CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xb9", 3, 0x7F79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\x8d", 3, 0x61CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xa6", 3, 0x61E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xa3", 3, 0x61E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xb6", 3, 0x61F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xba", 3, 0x61FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xb4", 3, 0x61F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xbf", 3, 0x61FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xbd", 3, 0x61FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xbc", 3, 0x61FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x87\xbe", 3, 0x61FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x80", 3, 0x6200}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x88", 3, 0x6208}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x89", 3, 0x6209}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x8d", 3, 0x620D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x8c", 3, 0x620C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x94", 3, 0x6214}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x9b", 3, 0x621B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x9e", 3, 0x621E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xa1", 3, 0x6221}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xaa", 3, 0x622A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xae", 3, 0x622E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xb0", 3, 0x6230}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xb2", 3, 0x6232}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\xb3", 3, 0x6233}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x81", 3, 0x6241}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x8e", 3, 0x624E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x9e", 3, 0x625E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xa3", 3, 0x6263}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x9b", 3, 0x625B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xa0", 3, 0x6260}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xa8", 3, 0x6268}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xbc", 3, 0x627C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x82", 3, 0x6282}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x89", 3, 0x6289}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\xbe", 3, 0x627E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x92", 3, 0x6292}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x93", 3, 0x6293}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x96", 3, 0x6296}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x94", 3, 0x62D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x83", 3, 0x6283}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x94", 3, 0x6294}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x97", 3, 0x62D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x91", 3, 0x62D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xbb", 3, 0x62BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x8f", 3, 0x62CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xbf", 3, 0x62FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x86", 3, 0x62C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x94", 3, 0x64D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x88", 3, 0x62C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x9c", 3, 0x62DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x8c", 3, 0x62CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x8a", 3, 0x62CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x82", 3, 0x62C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x87", 3, 0x62C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\x9b", 3, 0x629B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\x89", 3, 0x62C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x8c", 3, 0x630C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xae", 3, 0x62EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xb1", 3, 0x62F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xa7", 3, 0x6327}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x82", 3, 0x6302}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\x88", 3, 0x6308}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xaf", 3, 0x62EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8b\xb5", 3, 0x62F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x90", 3, 0x6350}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8c\xbe", 3, 0x633E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x8d", 3, 0x634D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x9c", 3, 0x641C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\x8f", 3, 0x634F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x96", 3, 0x6396}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x8e", 3, 0x638E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x80", 3, 0x6380}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xab", 3, 0x63AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xb6", 3, 0x6376}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xa3", 3, 0x63A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x8f", 3, 0x638F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x89", 3, 0x6389}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\x9f", 3, 0x639F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xb5", 3, 0x63B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xab", 3, 0x636B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8d\xa9", 3, 0x6369}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8e\xbe", 3, 0x63BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xa9", 3, 0x63E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x80", 3, 0x63C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x86", 3, 0x63C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xa3", 3, 0x63E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x89", 3, 0x63C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x92", 3, 0x63D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xb6", 3, 0x63F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\x84", 3, 0x63C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x96", 3, 0x6416}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xb4", 3, 0x6434}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x86", 3, 0x6406}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x93", 3, 0x6413}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xa6", 3, 0x6426}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xb6", 3, 0x6436}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\x9d", 3, 0x651D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x97", 3, 0x6417}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\xa8", 3, 0x6428}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x90\x8f", 3, 0x640F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xa7", 3, 0x6467}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xaf", 3, 0x646F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xb6", 3, 0x6476}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\x8e", 3, 0x644E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xaa", 3, 0x652A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x95", 3, 0x6495}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x93", 3, 0x6493}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xa5", 3, 0x64A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xa9", 3, 0x64A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x88", 3, 0x6488}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xbc", 3, 0x64BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x9a", 3, 0x64DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x92", 3, 0x64D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x85", 3, 0x64C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x87", 3, 0x64C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\xbb", 3, 0x64BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x98", 3, 0x64D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x82", 3, 0x64C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xb1", 3, 0x64F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xa7", 3, 0x64E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x89", 3, 0x8209}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xa0", 3, 0x64E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xa1", 3, 0x64E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xac", 3, 0x62AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xa3", 3, 0x64E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xaf", 3, 0x64EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xac", 3, 0x652C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xb6", 3, 0x64F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xb4", 3, 0x64F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xb2", 3, 0x64F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xba", 3, 0x64FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\x80", 3, 0x6500}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\xbd", 3, 0x64FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\x98", 3, 0x6518}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\x9c", 3, 0x651C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\x85", 3, 0x6505}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xa4", 3, 0x6524}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xa3", 3, 0x6523}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xab", 3, 0x652B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xb4", 3, 0x6534}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xb5", 3, 0x6535}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xb7", 3, 0x6537}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xb6", 3, 0x6536}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x94\xb8", 3, 0x6538}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x8b", 3, 0x754B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x88", 3, 0x6548}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x96", 3, 0x6556}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x95", 3, 0x6555}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x8d", 3, 0x654D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x98", 3, 0x6558}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x9e", 3, 0x655E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x9d", 3, 0x655D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xb2", 3, 0x6572}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\xb8", 3, 0x6578}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x82", 3, 0x6582}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x83", 3, 0x6583}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x8a", 3, 0x8B8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x9b", 3, 0x659B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\x9f", 3, 0x659F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xab", 3, 0x65AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x96\xb7", 3, 0x65B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x83", 3, 0x65C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x86", 3, 0x65C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x81", 3, 0x65C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x84", 3, 0x65C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x8c", 3, 0x65CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x92", 3, 0x65D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x9b", 3, 0x65DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\x99", 3, 0x65D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa0", 3, 0x65E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xa1", 3, 0x65E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xb1", 3, 0x65F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xb2", 3, 0x6772}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x8a", 3, 0x660A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x83", 3, 0x6603}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x97\xbb", 3, 0x65FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xb3", 3, 0x6773}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xb5", 3, 0x6635}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xb6", 3, 0x6636}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xb4", 3, 0x6634}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x9c", 3, 0x661C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x8f", 3, 0x664F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x84", 3, 0x6644}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x89", 3, 0x6649}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x81", 3, 0x6641}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x9e", 3, 0x665E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x9d", 3, 0x665D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa4", 3, 0x6664}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa7", 3, 0x6667}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa8", 3, 0x6668}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x9f", 3, 0x665F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa2", 3, 0x6662}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xb0", 3, 0x6670}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x83", 3, 0x6683}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x88", 3, 0x6688}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x8e", 3, 0x668E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x89", 3, 0x6689}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x84", 3, 0x6684}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x98", 3, 0x6698}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x9d", 3, 0x669D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x81", 3, 0x66C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xb9", 3, 0x66B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x89", 3, 0x66C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xbe", 3, 0x66BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xbc", 3, 0x66BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x84", 3, 0x66C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xb8", 3, 0x66B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x96", 3, 0x66D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\x9a", 3, 0x66DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xa0", 3, 0x66E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xbf", 3, 0x663F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xa6", 3, 0x66E6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xa9", 3, 0x66E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb0", 3, 0x66F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb5", 3, 0x66F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xb7", 3, 0x66F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x8f", 3, 0x670F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x96", 3, 0x6716}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x9e", 3, 0x671E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xa6", 3, 0x6726}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xa7", 3, 0x6727}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xb8", 3, 0x9738}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xae", 3, 0x672E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xbf", 3, 0x673F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xb6", 3, 0x6736}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x81", 3, 0x6741}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xb8", 3, 0x6738}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\xb7", 3, 0x6737}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x86", 3, 0x6746}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x9e", 3, 0x675E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xa0", 3, 0x6760}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\x99", 3, 0x6759}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xa3", 3, 0x6763}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xa4", 3, 0x6764}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x89", 3, 0x6789}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xb0", 3, 0x6770}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xa9", 3, 0x67A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xbc", 3, 0x677C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9d\xaa", 3, 0x676A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x8c", 3, 0x678C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x8b", 3, 0x678B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xa6", 3, 0x67A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xa1", 3, 0x67A1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\x85", 3, 0x6785}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xb7", 3, 0x67B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xaf", 3, 0x67EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xb4", 3, 0x67B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xac", 3, 0x67EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xb3", 3, 0x67B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xa9", 3, 0x67E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xb8", 3, 0x67B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xa4", 3, 0x67E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x9e", 3, 0x67DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x9d", 3, 0x67DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xa2", 3, 0x67E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xae", 3, 0x67EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xb9", 3, 0x67B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x8e", 3, 0x67CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x86", 3, 0x67C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\xa7", 3, 0x67E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x9c", 3, 0x6A9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x9e", 3, 0x681E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x86", 3, 0x6846}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xa9", 3, 0x6829}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x80", 3, 0x6840}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x8d", 3, 0x684D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xb2", 3, 0x6832}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x8e", 3, 0x684E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xb3", 3, 0x68B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\xab", 3, 0x682B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x99", 3, 0x6859}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xa3", 3, 0x6863}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xb7", 3, 0x6877}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xbf", 3, 0x687F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x9f", 3, 0x689F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x8f", 3, 0x688F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xad", 3, 0x68AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x94", 3, 0x6894}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x9d", 3, 0x689D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x9b", 3, 0x689B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x83", 3, 0x6883}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xae", 3, 0x6AAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xb9", 3, 0x68B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xb4", 3, 0x6874}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xb5", 3, 0x68B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xa0", 3, 0x68A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\xba", 3, 0x68BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x8f", 3, 0x690F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa2\x8d", 3, 0x688D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\xbe", 3, 0x687E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x81", 3, 0x6901}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x8a", 3, 0x68CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x88", 3, 0x6908}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x98", 3, 0x68D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xa2", 3, 0x6922}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xa6", 3, 0x6926}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xa1", 3, 0x68E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x8c", 3, 0x690C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x8d", 3, 0x68CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x94", 3, 0x68D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xa7", 3, 0x68E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x95", 3, 0x68D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xb6", 3, 0x6936}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x92", 3, 0x6912}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x84", 3, 0x6904}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x97", 3, 0x68D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xa3", 3, 0x68E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xa5", 3, 0x6925}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xb9", 3, 0x68F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xa0", 3, 0x68E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\xaf", 3, 0x68EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xa8", 3, 0x6928}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xaa", 3, 0x692A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\x9a", 3, 0x691A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xa3", 3, 0x6923}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xa1", 3, 0x6921}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x86", 3, 0x68C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xb9", 3, 0x6979}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xb7", 3, 0x6977}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x9c", 3, 0x695C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xb8", 3, 0x6978}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xab", 3, 0x696B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x94", 3, 0x6954}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xbe", 3, 0x697E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xae", 3, 0x696E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xb9", 3, 0x6939}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xb4", 3, 0x6974}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xbd", 3, 0x693D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x99", 3, 0x6959}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa4\xb0", 3, 0x6930}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xa1", 3, 0x6961}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x9e", 3, 0x695E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\x9d", 3, 0x695D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x81", 3, 0x6981}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa5\xaa", 3, 0x696A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xb2", 3, 0x69B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xae", 3, 0x69AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x90", 3, 0x69D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xbf", 3, 0x69BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x81", 3, 0x69C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x93", 3, 0x69D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xbe", 3, 0x69BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x8e", 3, 0x69CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xa8", 3, 0x5BE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x8a", 3, 0x69CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x9d", 3, 0x69DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xbb", 3, 0x69BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x83", 3, 0x69C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xa7", 3, 0x69A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xae", 3, 0x6A2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x91", 3, 0x6991}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xa0", 3, 0x69A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x9c", 3, 0x699C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\x95", 3, 0x6995}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xb4", 3, 0x69B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x9e", 3, 0x69DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xa8", 3, 0x69E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x82", 3, 0x6A02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x9b", 3, 0x6A1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xbf", 3, 0x69FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x8a", 3, 0x6B0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xb9", 3, 0x69F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xb2", 3, 0x69F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xa7", 3, 0x69E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x85", 3, 0x6A05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa6\xb1", 3, 0x69B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x9e", 3, 0x6A1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xad", 3, 0x69ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x94", 3, 0x6A14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xab", 3, 0x69EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x8a", 3, 0x6A0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x92", 3, 0x6A12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x81", 3, 0x6AC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xa3", 3, 0x6A23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x93", 3, 0x6A13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x84", 3, 0x6A44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\x8c", 3, 0x6A0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xb2", 3, 0x6A72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xb6", 3, 0x6A36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xb8", 3, 0x6A78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x87", 3, 0x6A47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xa2", 3, 0x6A62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x99", 3, 0x6A59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xa6", 3, 0x6A66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x88", 3, 0x6A48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xb8", 3, 0x6A38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xa2", 3, 0x6A22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x90", 3, 0x6A90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x8d", 3, 0x6A8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xa0", 3, 0x6AA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x84", 3, 0x6A84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xa2", 3, 0x6AA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xa3", 3, 0x6AA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\x97", 3, 0x6A97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x97", 3, 0x8617}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xbb", 3, 0x6ABB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x83", 3, 0x6AC3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x82", 3, 0x6AC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xb8", 3, 0x6AB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xb3", 3, 0x6AB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xac", 3, 0x6AAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x9e", 3, 0x6ADE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x91", 3, 0x6AD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x9f", 3, 0x6ADF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaa\xaa", 3, 0x6AAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\x9a", 3, 0x6ADA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xaa", 3, 0x6AEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xbb", 3, 0x6AFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x85", 3, 0x6B05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x96", 3, 0x8616}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xba", 3, 0x6AFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x92", 3, 0x6B12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x96", 3, 0x6B16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xb1", 3, 0x9B31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\x9f", 3, 0x6B1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xb8", 3, 0x6B38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xb7", 3, 0x6B37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x9c", 3, 0x76DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xac\xb9", 3, 0x6B39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xae", 3, 0x98EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x87", 3, 0x6B47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x83", 3, 0x6B43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x89", 3, 0x6B49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x90", 3, 0x6B50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x99", 3, 0x6B59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x94", 3, 0x6B54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x9b", 3, 0x6B5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\x9f", 3, 0x6B5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xa1", 3, 0x6B61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xb8", 3, 0x6B78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xb9", 3, 0x6B79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xad\xbf", 3, 0x6B7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x80", 3, 0x6B80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x84", 3, 0x6B84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x83", 3, 0x6B83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x8d", 3, 0x6B8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x98", 3, 0x6B98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x95", 3, 0x6B95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\x9e", 3, 0x6B9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xa4", 3, 0x6BA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xaa", 3, 0x6BAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xab", 3, 0x6BAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xaf", 3, 0x6BAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xb2", 3, 0x6BB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xb1", 3, 0x6BB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xb3", 3, 0x6BB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xb7", 3, 0x6BB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xae\xbc", 3, 0x6BBC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x86", 3, 0x6BC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x8b", 3, 0x6BCB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x93", 3, 0x6BD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x9f", 3, 0x6BDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\xac", 3, 0x6BEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\xab", 3, 0x6BEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\xb3", 3, 0x6BF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\xaf", 3, 0x6BEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xbe", 3, 0x9EBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x88", 3, 0x6C08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x93", 3, 0x6C13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x94", 3, 0x6C14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\x9b", 3, 0x6C1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xa4", 3, 0x6C24}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xa3", 3, 0x6C23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x9e", 3, 0x6C5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x95", 3, 0x6C55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xa2", 3, 0x6C62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xaa", 3, 0x6C6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x82", 3, 0x6C82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x8d", 3, 0x6C8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x9a", 3, 0x6C9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x81", 3, 0x6C81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x9b", 3, 0x6C9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xbe", 3, 0x6C7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xa8", 3, 0x6C68}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xb3", 3, 0x6C73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x92", 3, 0x6C92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x90", 3, 0x6C90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x84", 3, 0x6CC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xb1", 3, 0x6CF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x93", 3, 0x6CD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xbd", 3, 0x6CBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x97", 3, 0x6CD7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x85", 3, 0x6CC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x9d", 3, 0x6CDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xae", 3, 0x6CAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xb1", 3, 0x6CB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xbe", 3, 0x6CBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\xba", 3, 0x6CBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x9b", 3, 0x6CDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xaf", 3, 0x6CEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x99", 3, 0x6CD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\xaa", 3, 0x6CEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x9f", 3, 0x6D1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x8d", 3, 0x884D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xb6", 3, 0x6D36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xab", 3, 0x6D2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xbd", 3, 0x6D3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xb8", 3, 0x6D38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x99", 3, 0x6D19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xb5", 3, 0x6D35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\xb3", 3, 0x6D33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x92", 3, 0x6D12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x8c", 3, 0x6D0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xa3", 3, 0x6D63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x93", 3, 0x6D93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xa4", 3, 0x6D64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\x9a", 3, 0x6D5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xb9", 3, 0x6D79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\x99", 3, 0x6D59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x8e", 3, 0x6D8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x95", 3, 0x6D95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xa4", 3, 0x6FE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x85", 3, 0x6D85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb9", 3, 0x6DF9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x95", 3, 0x6E15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x8a", 3, 0x6E0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xb5", 3, 0x6DB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x87", 3, 0x6DC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xa6", 3, 0x6DE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xb8", 3, 0x6DB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x86", 3, 0x6DC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xac", 3, 0x6DEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x9e", 3, 0x6DDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x8c", 3, 0x6DCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xa8", 3, 0x6DE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x92", 3, 0x6DD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x85", 3, 0x6DC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xba", 3, 0x6DFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x99", 3, 0x6DD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xa4", 3, 0x6DE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x95", 3, 0x6DD5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xaa", 3, 0x6DEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xae", 3, 0x6DEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xad", 3, 0x6E2D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xae", 3, 0x6E6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xae", 3, 0x6E2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x99", 3, 0x6E19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xb2", 3, 0x6E72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x9f", 3, 0x6E5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xbe", 3, 0x6E3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa3", 3, 0x6E23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xab", 3, 0x6E6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xab", 3, 0x6E2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\xb6", 3, 0x6E76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x8d", 3, 0x6E4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x9f", 3, 0x6E1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x83", 3, 0x6E43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xba", 3, 0x6E3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x8e", 3, 0x6E4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa4", 3, 0x6E24}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xbf", 3, 0x6EFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\x9d", 3, 0x6E1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xb8", 3, 0x6E38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x82", 3, 0x6E82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xaa", 3, 0x6EAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x98", 3, 0x6E98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x89", 3, 0x6EC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xb7", 3, 0x6EB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x93", 3, 0x6ED3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xbd", 3, 0x6EBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xaf", 3, 0x6EAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x84", 3, 0x6EC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xb2", 3, 0x6EB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x94", 3, 0x6ED4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x95", 3, 0x6ED5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x8f", 3, 0x6E8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xa5", 3, 0x6EA5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x82", 3, 0x6EC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\x9f", 3, 0x6E9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x81", 3, 0x6F41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x91", 3, 0x6F11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\x8c", 3, 0x704C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xac", 3, 0x6EEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xb8", 3, 0x6EF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xbe", 3, 0x6EFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xbf", 3, 0x6F3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xb2", 3, 0x6EF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xb1", 3, 0x6F31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xaf", 3, 0x6EEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xb2", 3, 0x6F32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\x8c", 3, 0x6ECC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\xbe", 3, 0x6F3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbc\x93", 3, 0x6F13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbb\xb7", 3, 0x6EF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x86", 3, 0x6F86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xba", 3, 0x6F7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xb8", 3, 0x6F78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x81", 3, 0x6F81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x80", 3, 0x6F80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xaf", 3, 0x6F6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x9b", 3, 0x6F5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xb3", 3, 0x6FF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xad", 3, 0x6F6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x82", 3, 0x6F82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xbc", 3, 0x6F7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\x98", 3, 0x6F58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x8e", 3, 0x6F8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x91", 3, 0x6F91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x82", 3, 0x6FC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xa6", 3, 0x6F66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xb3", 3, 0x6FB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xa3", 3, 0x6FA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xa1", 3, 0x6FA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xa4", 3, 0x6FA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xb9", 3, 0x6FB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x86", 3, 0x6FC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xaa", 3, 0x6FAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x9f", 3, 0x6FDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x95", 3, 0x6FD5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xac", 3, 0x6FEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x94", 3, 0x6FD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x98", 3, 0x6FD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xb1", 3, 0x6FF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xae", 3, 0x6FEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\x9b", 3, 0x6FDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x89", 3, 0x7009}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x8b", 3, 0x700B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xba", 3, 0x6FFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x91", 3, 0x7011}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x81", 3, 0x7001}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x8f", 3, 0x700F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xbe", 3, 0x6FFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x9b", 3, 0x701B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x9a", 3, 0x701A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbd\xb4", 3, 0x6F74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x9d", 3, 0x701D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x98", 3, 0x7018}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x9f", 3, 0x701F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xb0", 3, 0x7030}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xbe", 3, 0x703E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xb2", 3, 0x7032}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\x91", 3, 0x7051}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x81\xa3", 3, 0x7063}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x99", 3, 0x7099}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x92", 3, 0x7092}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xaf", 3, 0x70AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\xb1", 3, 0x70F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xac", 3, 0x70AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xb8", 3, 0x70B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xb3", 3, 0x70B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xae", 3, 0x70AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\x9f", 3, 0x70DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\x8b", 3, 0x70CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\x9d", 3, 0x70DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\x99", 3, 0x70D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x89", 3, 0x7109}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x83\xbd", 3, 0x70FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x9c", 3, 0x711C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x99", 3, 0x7119}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xa5", 3, 0x7165}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x95", 3, 0x7155}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x88", 3, 0x7188}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xa6", 3, 0x7166}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xa2", 3, 0x7162}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x8c", 3, 0x714C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x96", 3, 0x7156}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\xac", 3, 0x716C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x8f", 3, 0x718F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xbb", 3, 0x71FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x84", 3, 0x7184}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x95", 3, 0x7195}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\xa8", 3, 0x71A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\xac", 3, 0x71AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x97", 3, 0x71D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\xb9", 3, 0x71B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\xbe", 3, 0x71BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x92", 3, 0x71D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x89", 3, 0x71C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x94", 3, 0x71D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\x8e", 3, 0x71CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xa0", 3, 0x71E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xac", 3, 0x71EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xa7", 3, 0x71E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xb5", 3, 0x71F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xbc", 3, 0x71FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xb9", 3, 0x71F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xbf", 3, 0x71FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\x8d", 3, 0x720D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\x90", 3, 0x7210}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\x9b", 3, 0x721B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xa8", 3, 0x7228}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xad", 3, 0x722D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xac", 3, 0x722C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xb0", 3, 0x7230}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xb2", 3, 0x7232}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xbb", 3, 0x723B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xbc", 3, 0x723C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x88\xbf", 3, 0x723F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x80", 3, 0x7240}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x86", 3, 0x7246}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x8b", 3, 0x724B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\x98", 3, 0x7258}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xb4", 3, 0x7274}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x89\xbe", 3, 0x727E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\x82", 3, 0x7282}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\x81", 3, 0x7281}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\x87", 3, 0x7287}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\x92", 3, 0x7292}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\x96", 3, 0x7296}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xa2", 3, 0x72A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xa7", 3, 0x72A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xb9", 3, 0x72B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xb2", 3, 0x72B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x83", 3, 0x72C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x86", 3, 0x72C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x84", 3, 0x72C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x8e", 3, 0x72CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\x92", 3, 0x72D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xa2", 3, 0x72E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xa0", 3, 0x72E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xa1", 3, 0x72E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xb9", 3, 0x72F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8b\xb7", 3, 0x72F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x8f", 3, 0x500F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x97", 3, 0x7317}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x8a", 3, 0x730A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x9c", 3, 0x731C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x96", 3, 0x7316}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\x9d", 3, 0x731D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xb4", 3, 0x7334}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xaf", 3, 0x732F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xa9", 3, 0x7329}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xa5", 3, 0x7325}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xbe", 3, 0x733E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\x8e", 3, 0x734E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\x8f", 3, 0x734F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x98", 3, 0x9ED8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\x97", 3, 0x7357}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xaa", 3, 0x736A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xa8", 3, 0x7368}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xb0", 3, 0x7370}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xb8", 3, 0x7378}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xb5", 3, 0x7375}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xbb", 3, 0x737B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8d\xba", 3, 0x737A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x88", 3, 0x73C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\xb3", 3, 0x73B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x8e", 3, 0x73CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\xbb", 3, 0x73BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x80", 3, 0x73C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xa5", 3, 0x73E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xae", 3, 0x73EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x9e", 3, 0x73DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\xa2", 3, 0x74A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\x85", 3, 0x7405}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xaf", 3, 0x746F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xa5", 3, 0x7425}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xb8", 3, 0x73F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xb2", 3, 0x7432}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xba", 3, 0x743A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x95", 3, 0x7455}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xbf", 3, 0x743F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x9f", 3, 0x745F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x99", 3, 0x7459}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x81", 3, 0x7441}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\x9c", 3, 0x745C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xa9", 3, 0x7469}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xb0", 3, 0x7470}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xa3", 3, 0x7463}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xaa", 3, 0x746A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xb6", 3, 0x7476}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xbe", 3, 0x747E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x8b", 3, 0x748B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x9e", 3, 0x749E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\xa7", 3, 0x74A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\x8a", 3, 0x74CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\x8f", 3, 0x74CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\x94", 3, 0x74D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xb1", 3, 0x73F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xa0", 3, 0x74E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xa3", 3, 0x74E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xa7", 3, 0x74E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xa9", 3, 0x74E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xae", 3, 0x74EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xb2", 3, 0x74F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xb0", 3, 0x74F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xb1", 3, 0x74F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xb8", 3, 0x74F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x93\xb7", 3, 0x74F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x84", 3, 0x7504}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x83", 3, 0x7503}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x85", 3, 0x7505}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x8c", 3, 0x750C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x8e", 3, 0x750E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x8d", 3, 0x750D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x95", 3, 0x7515}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x93", 3, 0x7513}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x9e", 3, 0x751E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xa6", 3, 0x7526}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xac", 3, 0x752C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xbc", 3, 0x753C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x84", 3, 0x7544}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x8d", 3, 0x754D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x8a", 3, 0x754A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x89", 3, 0x7549}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x9b", 3, 0x755B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x86", 3, 0x7546}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\x9a", 3, 0x755A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa9", 3, 0x7569}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa4", 3, 0x7564}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xa7", 3, 0x7567}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xab", 3, 0x756B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xad", 3, 0x756D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xb8", 3, 0x7578}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xb6", 3, 0x7576}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x86", 3, 0x7586}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x87", 3, 0x7587}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xb4", 3, 0x7574}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x8a", 3, 0x758A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x89", 3, 0x7589}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x82", 3, 0x7582}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x94", 3, 0x7594}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x9a", 3, 0x759A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\x9d", 3, 0x759D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xa5", 3, 0x75A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xa3", 3, 0x75A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x82", 3, 0x75C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xb3", 3, 0x75B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x83", 3, 0x75C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xb5", 3, 0x75B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xbd", 3, 0x75BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xb8", 3, 0x75B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xbc", 3, 0x75BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x96\xb1", 3, 0x75B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x8d", 3, 0x75CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x8a", 3, 0x75CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x92", 3, 0x75D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x99", 3, 0x75D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xa3", 3, 0x75E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\x9e", 3, 0x75DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xbe", 3, 0x75FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xbf", 3, 0x75FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xbc", 3, 0x75FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\x81", 3, 0x7601}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xb0", 3, 0x75F0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xba", 3, 0x75FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xb2", 3, 0x75F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x97\xb3", 3, 0x75F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\x8b", 3, 0x760B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\x8d", 3, 0x760D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\x89", 3, 0x7609}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\x9f", 3, 0x761F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xa7", 3, 0x7627}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xa0", 3, 0x7620}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xa1", 3, 0x7621}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xa2", 3, 0x7622}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xa4", 3, 0x7624}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xb4", 3, 0x7634}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xb0", 3, 0x7630}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x98\xbb", 3, 0x763B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x87", 3, 0x7647}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x88", 3, 0x7648}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x86", 3, 0x7646}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x9c", 3, 0x765C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\x98", 3, 0x7658}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xa1", 3, 0x7661}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xa2", 3, 0x7662}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xa8", 3, 0x7668}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xa9", 3, 0x7669}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xaa", 3, 0x766A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xa7", 3, 0x7667}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xac", 3, 0x766C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xb0", 3, 0x7670}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xb2", 3, 0x7672}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xb6", 3, 0x7676}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xb8", 3, 0x7678}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x99\xbc", 3, 0x767C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x80", 3, 0x7680}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x83", 3, 0x7683}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x88", 3, 0x7688}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x8b", 3, 0x768B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x8e", 3, 0x768E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x96", 3, 0x7696}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x93", 3, 0x7693}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x99", 3, 0x7699}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9a", 3, 0x769A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xb0", 3, 0x76B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xb4", 3, 0x76B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xb8", 3, 0x76B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xb9", 3, 0x76B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xba", 3, 0x76BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x82", 3, 0x76C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x8d", 3, 0x76CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x96", 3, 0x76D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x92", 3, 0x76D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\x9e", 3, 0x76DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xa1", 3, 0x76E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xa5", 3, 0x76E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xa7", 3, 0x76E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xaa", 3, 0x76EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\xaf", 3, 0x862F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9b\xbb", 3, 0x76FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x88", 3, 0x7708}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x87", 3, 0x7707}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x84", 3, 0x7704}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xa9", 3, 0x7729}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xa4", 3, 0x7724}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x9e", 3, 0x771E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xa5", 3, 0x7725}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xa6", 3, 0x7726}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\x9b", 3, 0x771B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xb7", 3, 0x7737}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9c\xb8", 3, 0x7738}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\x87", 3, 0x7747}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\x9a", 3, 0x775A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xa8", 3, 0x7768}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xab", 3, 0x776B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\x9b", 3, 0x775B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xa5", 3, 0x7765}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xbf", 3, 0x777F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xbe", 3, 0x777E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9d\xb9", 3, 0x7779}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\x8e", 3, 0x778E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\x8b", 3, 0x778B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\x91", 3, 0x7791}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xa0", 3, 0x77A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\x9e", 3, 0x779E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xb0", 3, 0x77B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xb6", 3, 0x77B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xb9", 3, 0x77B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xbf", 3, 0x77BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xbc", 3, 0x77BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xbd", 3, 0x77BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9e\xbb", 3, 0x77BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\x87", 3, 0x77C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\x8d", 3, 0x77CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\x97", 3, 0x77D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\x9a", 3, 0x77DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\x9c", 3, 0x77DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xa3", 3, 0x77E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xae", 3, 0x77EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9f\xbc", 3, 0x77FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\x8c", 3, 0x780C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\x92", 3, 0x7812}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xa6", 3, 0x7926}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xa0", 3, 0x7820}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xaa", 3, 0x792A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\x85", 3, 0x7845}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x8e", 3, 0x788E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xb4", 3, 0x7874}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x86", 3, 0x7886}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xbc", 3, 0x787C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x9a", 3, 0x789A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\x8c", 3, 0x788C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xa3", 3, 0x78A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xb5", 3, 0x78B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xaa", 3, 0x78AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xaf", 3, 0x78AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x91", 3, 0x78D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x86", 3, 0x78C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x8b", 3, 0x78CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x94", 3, 0x78D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xbe", 3, 0x78BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa2\xbc", 3, 0x78BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x85", 3, 0x78C5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x8a", 3, 0x78CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\xac", 3, 0x78EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\xa7", 3, 0x78E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\x9a", 3, 0x78DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\xbd", 3, 0x78FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa3\xb4", 3, 0x78F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\x87", 3, 0x7907}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\x92", 3, 0x7912}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\x91", 3, 0x7911}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\x99", 3, 0x7919}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xac", 3, 0x792C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xab", 3, 0x792B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x80", 3, 0x7940}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xa0", 3, 0x7960}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x97", 3, 0x7957}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x9f", 3, 0x795F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x9a", 3, 0x795A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x95", 3, 0x7955}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\x93", 3, 0x7953}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xba", 3, 0x797A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa5\xbf", 3, 0x797F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x8a", 3, 0x798A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x9d", 3, 0x799D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xa7", 3, 0x79A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x8b", 3, 0x9F4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xaa", 3, 0x79AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xae", 3, 0x79AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xb3", 3, 0x79B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xb9", 3, 0x79B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\xba", 3, 0x79BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x89", 3, 0x79C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\x95", 3, 0x79D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xa7", 3, 0x79E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xac", 3, 0x79EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xa1", 3, 0x79E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa7\xa3", 3, 0x79E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x88", 3, 0x7A08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x8d", 3, 0x7A0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x98", 3, 0x7A18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x99", 3, 0x7A19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xa0", 3, 0x7A20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\x9f", 3, 0x7A1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa6\x80", 3, 0x7980}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xb1", 3, 0x7A31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xbb", 3, 0x7A3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xbe", 3, 0x7A3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa8\xb7", 3, 0x7A37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x83", 3, 0x7A43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x97", 3, 0x7A57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\x89", 3, 0x7A49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xa1", 3, 0x7A61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xa2", 3, 0x7A62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xa9", 3, 0x7A69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbe\x9d", 3, 0x9F9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xb0", 3, 0x7A70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xb9", 3, 0x7A79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa9\xbd", 3, 0x7A7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x88", 3, 0x7A88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x97", 3, 0x7A97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x95", 3, 0x7A95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x98", 3, 0x7A98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\x96", 3, 0x7A96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xa9", 3, 0x7AA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x88", 3, 0x7AC8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xb0", 3, 0x7AB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xb6", 3, 0x7AB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x85", 3, 0x7AC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x84", 3, 0x7AC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaa\xbf", 3, 0x7ABF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x83", 3, 0x9083}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x87", 3, 0x7AC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x8a", 3, 0x7ACA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x8d", 3, 0x7ACD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x8f", 3, 0x7ACF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x95", 3, 0x7AD5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x93", 3, 0x7AD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x99", 3, 0x7AD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x9a", 3, 0x7ADA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x9d", 3, 0x7ADD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa1", 3, 0x7AE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa2", 3, 0x7AE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa6", 3, 0x7AE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xad", 3, 0x7AED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xb0", 3, 0x7AF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x82", 3, 0x7B02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x8f", 3, 0x7B0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x8a", 3, 0x7B0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x86", 3, 0x7B06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xb3", 3, 0x7B33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x98", 3, 0x7B18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x99", 3, 0x7B19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x9e", 3, 0x7B1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xb5", 3, 0x7B35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xa8", 3, 0x7B28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\xb6", 3, 0x7B36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x90", 3, 0x7B50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xba", 3, 0x7B7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x84", 3, 0x7B04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x8d", 3, 0x7B4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xac\x8b", 3, 0x7B0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x8c", 3, 0x7B4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x85", 3, 0x7B45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xb5", 3, 0x7B75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xa5", 3, 0x7B65}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xb4", 3, 0x7B74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xa7", 3, 0x7B67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xb0", 3, 0x7B70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xb1", 3, 0x7B71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xac", 3, 0x7B6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\xae", 3, 0x7B6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x9d", 3, 0x7B9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x98", 3, 0x7B98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x9f", 3, 0x7B9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x8d", 3, 0x7B8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x9c", 3, 0x7B9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x9a", 3, 0x7B9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x8b", 3, 0x7B8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x92", 3, 0x7B92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x8f", 3, 0x7B8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xad\x9d", 3, 0x7B5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x99", 3, 0x7B99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x8b", 3, 0x7BCB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x81", 3, 0x7BC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x8c", 3, 0x7BCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x8f", 3, 0x7BCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\xb4", 3, 0x7BB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x86", 3, 0x7BC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\x9d", 3, 0x7BDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xa9", 3, 0x7BE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x91", 3, 0x7C11}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x94", 3, 0x7C14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xa6", 3, 0x7BE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xa5", 3, 0x7BE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xa0", 3, 0x7C60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x80", 3, 0x7C00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x87", 3, 0x7C07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x93", 3, 0x7C13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xb3", 3, 0x7BF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xb7", 3, 0x7BF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x97", 3, 0x7C17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x8d", 3, 0x7C0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xaf\xb6", 3, 0x7BF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xa3", 3, 0x7C23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xa7", 3, 0x7C27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xaa", 3, 0x7C2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\x9f", 3, 0x7C1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xb7", 3, 0x7C37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xab", 3, 0x7C2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb0\xbd", 3, 0x7C3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x8c", 3, 0x7C4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x83", 3, 0x7C43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x94", 3, 0x7C54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x8f", 3, 0x7C4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x80", 3, 0x7C40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x90", 3, 0x7C50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x98", 3, 0x7C58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x9f", 3, 0x7C5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xa4", 3, 0x7C64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\x96", 3, 0x7C56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xa5", 3, 0x7C65}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xac", 3, 0x7C6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb1\xb5", 3, 0x7C75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x83", 3, 0x7C83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\x90", 3, 0x7C90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xa4", 3, 0x7CA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xad", 3, 0x7CAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xa2", 3, 0x7CA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xab", 3, 0x7CAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xa1", 3, 0x7CA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xa8", 3, 0x7CA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xb3", 3, 0x7CB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xb2", 3, 0x7CB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xb1", 3, 0x7CB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xae", 3, 0x7CAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xb9", 3, 0x7CB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb2\xbd", 3, 0x7CBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x80", 3, 0x7CC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x85", 3, 0x7CC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x82", 3, 0x7CC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x98", 3, 0x7CD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x92", 3, 0x7CD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\x9c", 3, 0x7CDC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xa2", 3, 0x7CE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xbb", 3, 0x9B3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xaf", 3, 0x7CEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xb2", 3, 0x7CF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xb4", 3, 0x7CF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xb6", 3, 0x7CF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb3\xba", 3, 0x7CFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x86", 3, 0x7D06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x82", 3, 0x7D02}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x9c", 3, 0x7D1C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x95", 3, 0x7D15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\x8a", 3, 0x7D0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x85", 3, 0x7D45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x8b", 3, 0x7D4B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xae", 3, 0x7D2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xb2", 3, 0x7D32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xbf", 3, 0x7D3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb4\xb5", 3, 0x7D35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x86", 3, 0x7D46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xb3", 3, 0x7D73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x96", 3, 0x7D56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x8e", 3, 0x7D4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xb2", 3, 0x7D72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xa8", 3, 0x7D68}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xae", 3, 0x7D6E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x8f", 3, 0x7D4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xa3", 3, 0x7D63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x93", 3, 0x7D93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x89", 3, 0x7D89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x9b", 3, 0x7D5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x8f", 3, 0x7D8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\xbd", 3, 0x7D7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x9b", 3, 0x7D9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xba", 3, 0x7DBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xae", 3, 0x7DAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xa3", 3, 0x7DA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb5", 3, 0x7DB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x87", 3, 0x7DC7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xbd", 3, 0x7DBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xab", 3, 0x7DAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xbd", 3, 0x7E3D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xa2", 3, 0x7DA2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xaf", 3, 0x7DAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x9c", 3, 0x7DDC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb8", 3, 0x7DB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\x9f", 3, 0x7D9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb0", 3, 0x7DB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x98", 3, 0x7DD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x9d", 3, 0x7DDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xa4", 3, 0x7DE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x9e", 3, 0x7DDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xbb", 3, 0x7DFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xb2", 3, 0x7DF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\xa1", 3, 0x7DE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x85", 3, 0x7E05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x8a", 3, 0x7E0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xa3", 3, 0x7E23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xa1", 3, 0x7E21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x92", 3, 0x7E12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xb1", 3, 0x7E31}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x9f", 3, 0x7E1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x89", 3, 0x7E09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\x8b", 3, 0x7E0B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xa2", 3, 0x7E22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x86", 3, 0x7E46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xa6", 3, 0x7E66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xbb", 3, 0x7E3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xb5", 3, 0x7E35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xb9", 3, 0x7E39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x83", 3, 0x7E43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xb7", 3, 0x7E37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xb2", 3, 0x7E32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb8\xba", 3, 0x7E3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xa7", 3, 0x7E67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x9d", 3, 0x7E5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x96", 3, 0x7E56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x9e", 3, 0x7E5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x99", 3, 0x7E59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x9a", 3, 0x7E5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xb9", 3, 0x7E79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xaa", 3, 0x7E6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xa9", 3, 0x7E69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xbc", 3, 0x7E7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xbb", 3, 0x7E7B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x83", 3, 0x7E83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x95", 3, 0x7DD5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xbd", 3, 0x7E7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xae", 3, 0x8FAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\xbf", 3, 0x7E7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x88", 3, 0x7E88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x89", 3, 0x7E89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x8c", 3, 0x7E8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x92", 3, 0x7E92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x90", 3, 0x7E90}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x93", 3, 0x7E93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x94", 3, 0x7E94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x96", 3, 0x7E96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x8e", 3, 0x7E8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x9b", 3, 0x7E9B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xba\x9c", 3, 0x7E9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbc\xb8", 3, 0x7F38}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbc\xba", 3, 0x7F3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x85", 3, 0x7F45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x8c", 3, 0x7F4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x8d", 3, 0x7F4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x8e", 3, 0x7F4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x90", 3, 0x7F50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x91", 3, 0x7F51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x95", 3, 0x7F55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x94", 3, 0x7F54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x98", 3, 0x7F58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x9f", 3, 0x7F5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xa0", 3, 0x7F60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xa8", 3, 0x7F68}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xa9", 3, 0x7F69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xa7", 3, 0x7F67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\xb8", 3, 0x7F78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x82", 3, 0x7F82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x86", 3, 0x7F86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x83", 3, 0x7F83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x88", 3, 0x7F88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x87", 3, 0x7F87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x8c", 3, 0x7F8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x94", 3, 0x7F94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x9e", 3, 0x7F9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x9d", 3, 0x7F9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\x9a", 3, 0x7F9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xa3", 3, 0x7FA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xaf", 3, 0x7FAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xb2", 3, 0x7FB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xb9", 3, 0x7FB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xae", 3, 0x7FAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xb6", 3, 0x7FB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xb8", 3, 0x7FB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xb1", 3, 0x8B71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x85", 3, 0x7FC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x86", 3, 0x7FC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x8a", 3, 0x7FCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x95", 3, 0x7FD5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\x94", 3, 0x7FD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xa1", 3, 0x7FE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xa6", 3, 0x7FE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xa9", 3, 0x7FE9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xb3", 3, 0x7FF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbf\xb9", 3, 0x7FF9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\x9c", 3, 0x98DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x86", 3, 0x8006}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x84", 3, 0x8004}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x8b", 3, 0x800B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x92", 3, 0x8012}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x98", 3, 0x8018}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x99", 3, 0x8019}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\x9c", 3, 0x801C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xa1", 3, 0x8021}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xa8", 3, 0x8028}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xbf", 3, 0x803F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x80\xbb", 3, 0x803B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x8a", 3, 0x804A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x86", 3, 0x8046}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x92", 3, 0x8052}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x98", 3, 0x8058}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x9a", 3, 0x805A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\x9f", 3, 0x805F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xa2", 3, 0x8062}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xa8", 3, 0x8068}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb3", 3, 0x8073}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb2", 3, 0x8072}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb0", 3, 0x8070}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb6", 3, 0x8076}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xb9", 3, 0x8079}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xbd", 3, 0x807D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x81\xbf", 3, 0x807F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x84", 3, 0x8084}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x86", 3, 0x8086}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x85", 3, 0x8085}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x9b", 3, 0x809B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x93", 3, 0x8093}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\x9a", 3, 0x809A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xad", 3, 0x80AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x90", 3, 0x5190}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x82\xac", 3, 0x80AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x9b", 3, 0x80DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xa5", 3, 0x80E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x99", 3, 0x80D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x9d", 3, 0x80DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x84", 3, 0x80C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x9a", 3, 0x80DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\x96", 3, 0x80D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x89", 3, 0x8109}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xaf", 3, 0x80EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xb1", 3, 0x80F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\x9b", 3, 0x811B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xa9", 3, 0x8129}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xa3", 3, 0x8123}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xaf", 3, 0x812F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x8b", 3, 0x814B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x8b", 3, 0x968B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x86", 3, 0x8146}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x84\xbe", 3, 0x813E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x93", 3, 0x8153}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x91", 3, 0x8151}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x83\xbc", 3, 0x80FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xb1", 3, 0x8171}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xae", 3, 0x816E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xa5", 3, 0x8165}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xa6", 3, 0x8166}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\xb4", 3, 0x8174}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x83", 3, 0x8183}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x88", 3, 0x8188}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x8a", 3, 0x818A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x80", 3, 0x8180}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x82", 3, 0x8182}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xa0", 3, 0x81A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x95", 3, 0x8195}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xa4", 3, 0x81A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xa3", 3, 0x81A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x85\x9f", 3, 0x815F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\x93", 3, 0x8193}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xa9", 3, 0x81A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xb0", 3, 0x81B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xb5", 3, 0x81B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xbe", 3, 0x81BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xb8", 3, 0x81B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xbd", 3, 0x81BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x80", 3, 0x81C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x82", 3, 0x81C2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x86\xba", 3, 0x81BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x89", 3, 0x81C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x8d", 3, 0x81CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x91", 3, 0x81D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x99", 3, 0x81D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x98", 3, 0x81D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x88", 3, 0x81C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x9a", 3, 0x81DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\x9f", 3, 0x81DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xa0", 3, 0x81E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xa7", 3, 0x81E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xba", 3, 0x81FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xbb", 3, 0x81FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x87\xbe", 3, 0x81FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x81", 3, 0x8201}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x82", 3, 0x8202}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x85", 3, 0x8205}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x87", 3, 0x8207}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x8a", 3, 0x820A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x8d", 3, 0x820D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x90", 3, 0x8210}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\x96", 3, 0x8216}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xa9", 3, 0x8229}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xab", 3, 0x822B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xb8", 3, 0x8238}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xb3", 3, 0x8233}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x80", 3, 0x8240}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x99", 3, 0x8259}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x98", 3, 0x8258}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x9d", 3, 0x825D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x9a", 3, 0x825A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\x9f", 3, 0x825F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xa4", 3, 0x8264}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xa2", 3, 0x8262}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xa8", 3, 0x8268}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xaa", 3, 0x826A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xab", 3, 0x826B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x88\xae", 3, 0x822E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xb1", 3, 0x8271}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xb7", 3, 0x8277}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xb8", 3, 0x8278}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x89\xbe", 3, 0x827E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\x8d", 3, 0x828D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\x92", 3, 0x8292}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xab", 3, 0x82AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\x9f", 3, 0x829F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xbb", 3, 0x82BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8a\xac", 3, 0x82AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xa1", 3, 0x82E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xa3", 3, 0x82E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x9f", 3, 0x82DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x92", 3, 0x82D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xb4", 3, 0x82F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xb3", 3, 0x82F3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xba", 3, 0x82FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x93", 3, 0x8393}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x83", 3, 0x8303}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xbb", 3, 0x82FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\xb9", 3, 0x82F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x9e", 3, 0x82DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x86", 3, 0x8306}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x9c", 3, 0x82DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x89", 3, 0x8309}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8b\x99", 3, 0x82D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb5", 3, 0x8335}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb4", 3, 0x8334}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x96", 3, 0x8316}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb2", 3, 0x8332}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb1", 3, 0x8331}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x80", 3, 0x8340}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xb9", 3, 0x8339}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x90", 3, 0x8350}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\x85", 3, 0x8345}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xaf", 3, 0x832F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xab", 3, 0x832B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x97", 3, 0x8317}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\x98", 3, 0x8318}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x85", 3, 0x8385}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x9a", 3, 0x839A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xaa", 3, 0x83AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x9f", 3, 0x839F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xa2", 3, 0x83A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x96", 3, 0x8396}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8c\xa3", 3, 0x8323}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x8e", 3, 0x838E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x87", 3, 0x8387}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x8a", 3, 0x838A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xbc", 3, 0x837C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xb5", 3, 0x83B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xb3", 3, 0x8373}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xb5", 3, 0x8375}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xa0", 3, 0x83A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\x89", 3, 0x8389}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xa8", 3, 0x83A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb4", 3, 0x83F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x93", 3, 0x8413}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xab", 3, 0x83EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x8e", 3, 0x83CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xbd", 3, 0x83FD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x83", 3, 0x8403}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x98", 3, 0x83D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x8b", 3, 0x840B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x81", 3, 0x83C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb7", 3, 0x83F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x87", 3, 0x8407}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xa0", 3, 0x83E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb2", 3, 0x83F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\x8d", 3, 0x840D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xa2", 3, 0x8422}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xa0", 3, 0x8420}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8e\xbd", 3, 0x83BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xb8", 3, 0x8438}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x86", 3, 0x8506}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xbb", 3, 0x83FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xad", 3, 0x846D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xaa", 3, 0x842A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xbc", 3, 0x843C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x9a", 3, 0x855A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x84", 3, 0x8484}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xb7", 3, 0x8477}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xab", 3, 0x846B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xad", 3, 0x84AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xae", 3, 0x846E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x82", 3, 0x8482}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xa9", 3, 0x8469}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x86", 3, 0x8446}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xac", 3, 0x842C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xaf", 3, 0x846F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xb9", 3, 0x8479}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x90\xb5", 3, 0x8435}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x8a", 3, 0x84CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\xa2", 3, 0x8462}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xb9", 3, 0x84B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xbf", 3, 0x84BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\x9f", 3, 0x849F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x99", 3, 0x84D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x8d", 3, 0x84CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xbb", 3, 0x84BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x9a", 3, 0x84DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x90", 3, 0x84D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x81", 3, 0x84C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x86", 3, 0x84C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x96", 3, 0x84D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xa1", 3, 0x84A1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\xa1", 3, 0x8521}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\xbf", 3, 0x84FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\xb4", 3, 0x84F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x97", 3, 0x8517}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x98", 3, 0x8518}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\xac", 3, 0x852C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x9f", 3, 0x851F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x95", 3, 0x8515}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x94\x94", 3, 0x8514}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\xbc", 3, 0x84FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x80", 3, 0x8540}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xa3", 3, 0x8563}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x98", 3, 0x8558}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x88", 3, 0x8548}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x81", 3, 0x8541}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x82", 3, 0x8602}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x8b", 3, 0x854B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x95", 3, 0x8555}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x80", 3, 0x8580}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xa4", 3, 0x85A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x88", 3, 0x8588}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x91", 3, 0x8591}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x8a", 3, 0x858A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xa8", 3, 0x85A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xad", 3, 0x856D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x94", 3, 0x8594}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x9b", 3, 0x859B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xaa", 3, 0x85EA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x87", 3, 0x8587}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x9c", 3, 0x859C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xb7", 3, 0x8577}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xbe", 3, 0x857E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\x90", 3, 0x8590}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x89", 3, 0x85C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xba", 3, 0x85BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x8f", 3, 0x85CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x96\xb9", 3, 0x85B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x90", 3, 0x85D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x95", 3, 0x85D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x9d", 3, 0x85DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xa5", 3, 0x85E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\x9c", 3, 0x85DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xb9", 3, 0x85F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x8a", 3, 0x860A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x93", 3, 0x8613}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x8b", 3, 0x860B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xbe", 3, 0x85FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x97\xba", 3, 0x85FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x86", 3, 0x8606}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\xa2", 3, 0x8622}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\x9a", 3, 0x861A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\xb0", 3, 0x8630}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x98\xbf", 3, 0x863F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x8d", 3, 0x864D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb9\x95", 3, 0x4E55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x94", 3, 0x8654}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\x9f", 3, 0x865F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\xa7", 3, 0x8667}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x99\xb1", 3, 0x8671}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\x93", 3, 0x8693}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xa3", 3, 0x86A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xa9", 3, 0x86A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xaa", 3, 0x86AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\x8b", 3, 0x868B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\x8c", 3, 0x868C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xb6", 3, 0x86B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xaf", 3, 0x86AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x84", 3, 0x86C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x86", 3, 0x86C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xb0", 3, 0x86B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x89", 3, 0x86C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xa3", 3, 0x8823}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9a\xab", 3, 0x86AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x94", 3, 0x86D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x9e", 3, 0x86DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xa9", 3, 0x86E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xac", 3, 0x86EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x9f", 3, 0x86DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\x9b", 3, 0x86DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xaf", 3, 0x86EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x92", 3, 0x8712}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x86", 3, 0x8706}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x88", 3, 0x8708}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x80", 3, 0x8700}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x83", 3, 0x8703}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xbb", 3, 0x86FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x91", 3, 0x8711}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x89", 3, 0x8709}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x8d", 3, 0x870D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9b\xb9", 3, 0x86F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x8a", 3, 0x870A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\xb4", 3, 0x8734}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\xbf", 3, 0x873F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\xb7", 3, 0x8737}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\xbb", 3, 0x873B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\xa5", 3, 0x8725}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\xa9", 3, 0x8729}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9c\x9a", 3, 0x871A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xa0", 3, 0x8760}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x9f", 3, 0x875F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xb8", 3, 0x8778}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x8c", 3, 0x874C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x8e", 3, 0x874E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xb4", 3, 0x8774}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x97", 3, 0x8757}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xa8", 3, 0x8768}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xae", 3, 0x876E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x99", 3, 0x8759}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\x93", 3, 0x8753}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xa3", 3, 0x8763}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9d\xaa", 3, 0x876A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x85", 3, 0x8805}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xa2", 3, 0x87A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\x9f", 3, 0x879F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\x82", 3, 0x8782}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xaf", 3, 0x87AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x8b", 3, 0x87CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xbd", 3, 0x87BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x80", 3, 0x87C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x90", 3, 0x87D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x96", 3, 0x96D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xab", 3, 0x87AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x84", 3, 0x87C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xb3", 3, 0x87B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x87", 3, 0x87C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x86", 3, 0x87C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9e\xbb", 3, 0x87BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xaf", 3, 0x87EF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xb2", 3, 0x87F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xa0", 3, 0x87E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x8f", 3, 0x880F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x8d", 3, 0x880D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xbe", 3, 0x87FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xb6", 3, 0x87F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\xb7", 3, 0x87F7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x8e", 3, 0x880E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x9f\x92", 3, 0x87D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x91", 3, 0x8811}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x96", 3, 0x8816}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\x95", 3, 0x8815}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xa2", 3, 0x8822}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xa1", 3, 0x8821}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xb1", 3, 0x8831}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xb6", 3, 0x8836}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xb9", 3, 0x8839}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xa7", 3, 0x8827}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa0\xbb", 3, 0x883B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x84", 3, 0x8844}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x82", 3, 0x8842}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x92", 3, 0x8852}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x99", 3, 0x8859}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\x9e", 3, 0x885E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xa2", 3, 0x8862}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xab", 3, 0x886B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x81", 3, 0x8881}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xbe", 3, 0x887E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x9e", 3, 0x889E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xb5", 3, 0x8875}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xbd", 3, 0x887D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xb5", 3, 0x88B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa1\xb2", 3, 0x8872}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x82", 3, 0x8882}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x97", 3, 0x8897}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x92", 3, 0x8892}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xae", 3, 0x88AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x99", 3, 0x8899}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xa2", 3, 0x88A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\x8d", 3, 0x888D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xa4", 3, 0x88A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xb0", 3, 0x88B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xbf", 3, 0x88BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa2\xb1", 3, 0x88B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x83", 3, 0x88C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x84", 3, 0x88C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x94", 3, 0x88D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x98", 3, 0x88D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x99", 3, 0x88D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\x9d", 3, 0x88DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb9", 3, 0x88F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x82", 3, 0x8902}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xbc", 3, 0x88FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb4", 3, 0x88F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xa8", 3, 0x88E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb2", 3, 0x88F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x84", 3, 0x8904}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x8c", 3, 0x890C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x8a", 3, 0x890A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x93", 3, 0x8913}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x83", 3, 0x8943}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x9e", 3, 0x891E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\xa5", 3, 0x8925}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\xaa", 3, 0x892A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\xab", 3, 0x892B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x81", 3, 0x8941}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x84", 3, 0x8944}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\xbb", 3, 0x893B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\xb6", 3, 0x8936}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\xb8", 3, 0x8938}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x8c", 3, 0x894C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x9d", 3, 0x891D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xa0", 3, 0x8960}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x9e", 3, 0x895E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xa6", 3, 0x8966}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xa4", 3, 0x8964}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xad", 3, 0x896D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xaa", 3, 0x896A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xaf", 3, 0x896F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xb4", 3, 0x8974}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xb7", 3, 0x8977}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\xbe", 3, 0x897E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x83", 3, 0x8983}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x88", 3, 0x8988}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x8a", 3, 0x898A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x93", 3, 0x8993}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\x98", 3, 0x8998}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xa1", 3, 0x89A1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xa9", 3, 0x89A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xa6", 3, 0x89A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xac", 3, 0x89AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xaf", 3, 0x89AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xb2", 3, 0x89B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xba", 3, 0x89BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xbd", 3, 0x89BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa6\xbf", 3, 0x89BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\x80", 3, 0x89C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\x9a", 3, 0x89DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\x9c", 3, 0x89DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\x9d", 3, 0x89DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\xa7", 3, 0x89E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\xb4", 3, 0x89F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa7\xb8", 3, 0x89F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x83", 3, 0x8A03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x96", 3, 0x8A16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x90", 3, 0x8A10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x8c", 3, 0x8A0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x9b", 3, 0x8A1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x9d", 3, 0x8A1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xa5", 3, 0x8A25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xb6", 3, 0x8A36}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x81", 3, 0x8A41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x9b", 3, 0x8A5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x92", 3, 0x8A52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x86", 3, 0x8A46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\x88", 3, 0x8A48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xbc", 3, 0x8A7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xad", 3, 0x8A6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xac", 3, 0x8A6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xa2", 3, 0x8A62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x85", 3, 0x8A85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x82", 3, 0x8A82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x84", 3, 0x8A84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa8", 3, 0x8AA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa1", 3, 0x8AA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x91", 3, 0x8A91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa5", 3, 0x8AA5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa6", 3, 0x8AA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\x9a", 3, 0x8A9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa3", 3, 0x8AA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x84", 3, 0x8AC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x8d", 3, 0x8ACD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x82", 3, 0x8AC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x9a", 3, 0x8ADA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xab", 3, 0x8AEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xb3", 3, 0x8AF3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xa7", 3, 0x8AE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xa4", 3, 0x8AE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xb1", 3, 0x8AF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x94", 3, 0x8B14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xa0", 3, 0x8AE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xa2", 3, 0x8AE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xb7", 3, 0x8AF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x9e", 3, 0x8ADE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x9b", 3, 0x8ADB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x8c", 3, 0x8B0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x87", 3, 0x8B07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x9a", 3, 0x8B1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\xa1", 3, 0x8AE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x96", 3, 0x8B16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x90", 3, 0x8B10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\x97", 3, 0x8B17}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xa0", 3, 0x8B20}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xb3", 3, 0x8B33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xab", 3, 0x97AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xa6", 3, 0x8B26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xab", 3, 0x8B2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xbe", 3, 0x8B3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xac\xa8", 3, 0x8B28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x81", 3, 0x8B41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x8c", 3, 0x8B4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x8f", 3, 0x8B4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x8e", 3, 0x8B4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x89", 3, 0x8B49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x96", 3, 0x8B56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x9b", 3, 0x8B5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x9a", 3, 0x8B5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xab", 3, 0x8B6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x9f", 3, 0x8B5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xac", 3, 0x8B6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xaf", 3, 0x8B6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xb4", 3, 0x8B74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xbd", 3, 0x8B7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x80", 3, 0x8B80}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x8c", 3, 0x8B8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x8e", 3, 0x8B8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x92", 3, 0x8B92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x93", 3, 0x8B93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x96", 3, 0x8B96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x99", 3, 0x8B99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xae\x9a", 3, 0x8B9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb0\xba", 3, 0x8C3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x81", 3, 0x8C41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb0\xbf", 3, 0x8C3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x88", 3, 0x8C48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x8c", 3, 0x8C4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x8e", 3, 0x8C4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x90", 3, 0x8C50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\x95", 3, 0x8C55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xa2", 3, 0x8C62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xac", 3, 0x8C6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xb8", 3, 0x8C78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xba", 3, 0x8C7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x82", 3, 0x8C82}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x89", 3, 0x8C89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x85", 3, 0x8C85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x8a", 3, 0x8C8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x8d", 3, 0x8C8D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x8e", 3, 0x8C8E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x94", 3, 0x8C94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb1\xbc", 3, 0x8C7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\x98", 3, 0x8C98}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x9d", 3, 0x621D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xad", 3, 0x8CAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xaa", 3, 0x8CAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xbd", 3, 0x8CBD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb2", 3, 0x8CB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb3", 3, 0x8CB3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xae", 3, 0x8CAE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb2\xb6", 3, 0x8CB6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x88", 3, 0x8CC8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x81", 3, 0x8CC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xa4", 3, 0x8CE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xa3", 3, 0x8CE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x9a", 3, 0x8CDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xbd", 3, 0x8CFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xba", 3, 0x8CFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xbb", 3, 0x8CFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x84", 3, 0x8D04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x85", 3, 0x8D05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x8a", 3, 0x8D0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x87", 3, 0x8D07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x8f", 3, 0x8D0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x8d", 3, 0x8D0D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x90", 3, 0x8D10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x8e", 3, 0x9F4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x93", 3, 0x8D13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\x8d", 3, 0x8CCD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x94", 3, 0x8D14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x96", 3, 0x8D16}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xa7", 3, 0x8D67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xad", 3, 0x8D6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb1", 3, 0x8D71}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb3", 3, 0x8D73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\x81", 3, 0x8D81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\x99", 3, 0x8D99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x82", 3, 0x8DC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\xbe", 3, 0x8DBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb6\xba", 3, 0x8DBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x8f", 3, 0x8DCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x9a", 3, 0x8DDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x96", 3, 0x8DD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x8c", 3, 0x8DCC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x9b", 3, 0x8DDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x8b", 3, 0x8DCB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xaa", 3, 0x8DEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xab", 3, 0x8DEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\x9f", 3, 0x8DDF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xa3", 3, 0x8DE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xbc", 3, 0x8DFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x88", 3, 0x8E08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x89", 3, 0x8E09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb7\xbf", 3, 0x8DFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x9d", 3, 0x8E1D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x9e", 3, 0x8E1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x90", 3, 0x8E10}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\x9f", 3, 0x8E1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x82", 3, 0x8E42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\xb5", 3, 0x8E35}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\xb0", 3, 0x8E30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\xb4", 3, 0x8E34}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x8a", 3, 0x8E4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x87", 3, 0x8E47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x89", 3, 0x8E49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x8c", 3, 0x8E4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x90", 3, 0x8E50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x88", 3, 0x8E48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x99", 3, 0x8E59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xa4", 3, 0x8E64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xa0", 3, 0x8E60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb8\xaa", 3, 0x8E2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xa3", 3, 0x8E63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\x95", 3, 0x8E55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xb6", 3, 0x8E76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xb2", 3, 0x8E72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb9\xbc", 3, 0x8E7C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x81", 3, 0x8E81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x87", 3, 0x8E87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x85", 3, 0x8E85}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x84", 3, 0x8E84}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x8b", 3, 0x8E8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x8a", 3, 0x8E8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x93", 3, 0x8E93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x91", 3, 0x8E91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x94", 3, 0x8E94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\x99", 3, 0x8E99}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xaa", 3, 0x8EAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xa1", 3, 0x8EA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xac", 3, 0x8EAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xb0", 3, 0x8EB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x86", 3, 0x8EC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xb1", 3, 0x8EB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xba\xbe", 3, 0x8EBE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x85", 3, 0x8EC5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x88", 3, 0x8EC8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x8b", 3, 0x8ECB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\x9b", 3, 0x8EDB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xa3", 3, 0x8EE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xbc", 3, 0x8EFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xbb", 3, 0x8EFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xab", 3, 0x8EEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbb\xbe", 3, 0x8EFE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x8a", 3, 0x8F0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x85", 3, 0x8F05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x95", 3, 0x8F15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x92", 3, 0x8F12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x99", 3, 0x8F19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x93", 3, 0x8F13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x9c", 3, 0x8F1C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x9f", 3, 0x8F1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x9b", 3, 0x8F1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\x8c", 3, 0x8F0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xa6", 3, 0x8F26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xb3", 3, 0x8F33}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xbb", 3, 0x8F3B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xb9", 3, 0x8F39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x85", 3, 0x8F45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x82", 3, 0x8F42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbc\xbe", 3, 0x8F3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x8c", 3, 0x8F4C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x89", 3, 0x8F49}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x86", 3, 0x8F46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x8e", 3, 0x8F4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x97", 3, 0x8F57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\x9c", 3, 0x8F5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\xa2", 3, 0x8F62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\xa3", 3, 0x8F63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbd\xa4", 3, 0x8F64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\x9c", 3, 0x8F9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\x9f", 3, 0x8F9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xa3", 3, 0x8FA3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xad", 3, 0x8FAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xaf", 3, 0x8FAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbe\xb7", 3, 0x8FB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\x9a", 3, 0x8FDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xa5", 3, 0x8FE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xa2", 3, 0x8FE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xaa", 3, 0x8FEA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xaf", 3, 0x8FEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x87", 3, 0x9087}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xb4", 3, 0x8FF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x85", 3, 0x9005}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xb9", 3, 0x8FF9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xba", 3, 0x8FFA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x91", 3, 0x9011}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x95", 3, 0x9015}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xa1", 3, 0x9021}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x8d", 3, 0x900D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x9e", 3, 0x901E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x96", 3, 0x9016}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x8b", 3, 0x900B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xa7", 3, 0x9027}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xb6", 3, 0x9036}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xb5", 3, 0x9035}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xb9", 3, 0x9039}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xbf\xb8", 3, 0x8FF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x8f", 3, 0x904F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x90", 3, 0x9050}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x91", 3, 0x9051}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x92", 3, 0x9052}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\x8e", 3, 0x900E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x89", 3, 0x9049}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x80\xbe", 3, 0x903E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x96", 3, 0x9056}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x98", 3, 0x9058}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x9e", 3, 0x905E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xa8", 3, 0x9068}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xaf", 3, 0x906F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xb6", 3, 0x9076}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xa8", 3, 0x96A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xb2", 3, 0x9072}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x82", 3, 0x9082}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\xbd", 3, 0x907D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x81", 3, 0x9081}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x80", 3, 0x9080}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x8a", 3, 0x908A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x89", 3, 0x9089}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\x8f", 3, 0x908F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xa8", 3, 0x90A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xaf", 3, 0x90AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xb1", 3, 0x90B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x82\xb5", 3, 0x90B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xa2", 3, 0x90E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\xa4", 3, 0x90E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x89\x88", 3, 0x6248}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\x9b", 3, 0x90DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\x82", 3, 0x9102}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\x92", 3, 0x9112}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\x99", 3, 0x9119}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\xb2", 3, 0x9132}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\xb0", 3, 0x9130}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x8a", 3, 0x914A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x96", 3, 0x9156}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\x98", 3, 0x9158}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xa3", 3, 0x9163}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xa5", 3, 0x9165}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xa9", 3, 0x9169}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xb3", 3, 0x9173}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x85\xb2", 3, 0x9172}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x8b", 3, 0x918B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x89", 3, 0x9189}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\x82", 3, 0x9182}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xa2", 3, 0x91A2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xab", 3, 0x91AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xaf", 3, 0x91AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xaa", 3, 0x91AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xb5", 3, 0x91B5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xb4", 3, 0x91B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x86\xba", 3, 0x91BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x80", 3, 0x91C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x81", 3, 0x91C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x89", 3, 0x91C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x8b", 3, 0x91CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x90", 3, 0x91D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x96", 3, 0x91D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9f", 3, 0x91DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa1", 3, 0x91E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9b", 3, 0x91DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xbc", 3, 0x91FC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xb5", 3, 0x91F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xb6", 3, 0x91F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x9e", 3, 0x921E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xbf", 3, 0x91FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x94", 3, 0x9214}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xac", 3, 0x922C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x95", 3, 0x9215}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x91", 3, 0x9211}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x9e", 3, 0x925E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x97", 3, 0x9257}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x85", 3, 0x9245}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x89", 3, 0x9249}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xa4", 3, 0x9264}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x88", 3, 0x9248}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x95", 3, 0x9295}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xbf", 3, 0x923F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x8b", 3, 0x924B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x90", 3, 0x9250}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x9c", 3, 0x929C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x96", 3, 0x9296}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x93", 3, 0x9293}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x9b", 3, 0x929B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x9a", 3, 0x925A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x8f", 3, 0x92CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\xb9", 3, 0x92B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\xb7", 3, 0x92B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xa9", 3, 0x92E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x8f", 3, 0x930F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xba", 3, 0x92FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x84", 3, 0x9344}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xae", 3, 0x932E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x99", 3, 0x9319}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa2", 3, 0x9322}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x9a", 3, 0x931A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa3", 3, 0x9323}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xba", 3, 0x933A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xb5", 3, 0x9335}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xbb", 3, 0x933B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x9c", 3, 0x935C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xa0", 3, 0x9360}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xbc", 3, 0x937C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xae", 3, 0x936E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x96", 3, 0x9356}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xb0", 3, 0x93B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xac", 3, 0x93AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xad", 3, 0x93AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\x94", 3, 0x9394}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xb9", 3, 0x93B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x96", 3, 0x93D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x97", 3, 0x93D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\xa8", 3, 0x93E8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\xa5", 3, 0x93E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x98", 3, 0x93D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x83", 3, 0x93C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x9d", 3, 0x93DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x90", 3, 0x93D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x88", 3, 0x93C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\xa4", 3, 0x93E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x9a", 3, 0x941A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x94", 3, 0x9414}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x93", 3, 0x9413}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x83", 3, 0x9403}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x87", 3, 0x9407}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\x90", 3, 0x9410}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xb6", 3, 0x9436}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xab", 3, 0x942B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xb5", 3, 0x9435}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xa1", 3, 0x9421}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xba", 3, 0x943A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x81", 3, 0x9441}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x92", 3, 0x9452}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x84", 3, 0x9444}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x9b", 3, 0x945B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xa0", 3, 0x9460}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xa2", 3, 0x9462}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x9e", 3, 0x945E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xaa", 3, 0x946A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xa9", 3, 0x9229}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xb0", 3, 0x9470}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xb5", 3, 0x9475}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xb7", 3, 0x9477}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xbd", 3, 0x947D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x9a", 3, 0x945A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xbc", 3, 0x947C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xbe", 3, 0x947E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x92\x81", 3, 0x9481}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\xbf", 3, 0x947F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x82", 3, 0x9582}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x87", 3, 0x9587}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x8a", 3, 0x958A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x94", 3, 0x9594}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x96", 3, 0x9596}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x98", 3, 0x9598}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x99", 3, 0x9599}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa0", 3, 0x95A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa8", 3, 0x95A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xa7", 3, 0x95A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xad", 3, 0x95AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xbc", 3, 0x95BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xbb", 3, 0x95BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xb9", 3, 0x95B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\xbe", 3, 0x95BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x8a", 3, 0x95CA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xb6", 3, 0x6FF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x83", 3, 0x95C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x8d", 3, 0x95CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x8c", 3, 0x95CC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x95", 3, 0x95D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x94", 3, 0x95D4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x96", 3, 0x95D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\x9c", 3, 0x95DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\xa1", 3, 0x95E1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\xa5", 3, 0x95E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x97\xa2", 3, 0x95E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xa1", 3, 0x9621}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xa8", 3, 0x9628}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xae", 3, 0x962E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x98\xaf", 3, 0x962F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x82", 3, 0x9642}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x8c", 3, 0x964C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x8f", 3, 0x964F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x8b", 3, 0x964B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb7", 3, 0x9677}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x9c", 3, 0x965C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x9e", 3, 0x965E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x9d", 3, 0x965D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\x9f", 3, 0x965F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xa6", 3, 0x9666}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xb2", 3, 0x9672}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x99\xac", 3, 0x966C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x8d", 3, 0x968D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x98", 3, 0x9698}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x95", 3, 0x9695}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\x97", 3, 0x9697}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xaa", 3, 0x96AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xa7", 3, 0x96A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb1", 3, 0x96B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb2", 3, 0x96B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb0", 3, 0x96B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb4", 3, 0x96B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb6", 3, 0x96B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb8", 3, 0x96B8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xb9", 3, 0x96B9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x8e", 3, 0x96CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x8b", 3, 0x96CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x89", 3, 0x96C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x8d", 3, 0x96CD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa5\x8d", 3, 0x894D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x9c", 3, 0x96DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x8d", 3, 0x970D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\x95", 3, 0x96D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9b\xb9", 3, 0x96F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x84", 3, 0x9704}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x86", 3, 0x9706}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x88", 3, 0x9708}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x93", 3, 0x9713}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x8e", 3, 0x970E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x91", 3, 0x9711}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x8f", 3, 0x970F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x96", 3, 0x9716}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\x99", 3, 0x9719}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xa4", 3, 0x9724}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xaa", 3, 0x972A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xb0", 3, 0x9730}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xb9", 3, 0x9739}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xbd", 3, 0x973D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xbe", 3, 0x973E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x84", 3, 0x9744}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x86", 3, 0x9746}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x88", 3, 0x9748}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x82", 3, 0x9742}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x89", 3, 0x9749}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x9c", 3, 0x975C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa0", 3, 0x9760}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa4", 3, 0x9764}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa6", 3, 0x9766}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa8", 3, 0x9768}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x92", 3, 0x52D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xab", 3, 0x976B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xb1", 3, 0x9771}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xb9", 3, 0x9779}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x85", 3, 0x9785}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xbc", 3, 0x977C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x81", 3, 0x9781}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xba", 3, 0x977A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x86", 3, 0x9786}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x8b", 3, 0x978B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x8f", 3, 0x978F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x90", 3, 0x9790}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\x9c", 3, 0x979C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xa8", 3, 0x97A8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xa6", 3, 0x97A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xa3", 3, 0x97A3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xb3", 3, 0x97B3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9e\xb4", 3, 0x97B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\x83", 3, 0x97C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\x86", 3, 0x97C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\x88", 3, 0x97C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\x8b", 3, 0x97CB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\x9c", 3, 0x97DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xad", 3, 0x97ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x8f", 3, 0x9F4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xb2", 3, 0x97F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x9f", 3, 0x7ADF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xb6", 3, 0x97F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9f\xb5", 3, 0x97F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x8f", 3, 0x980F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\x8c", 3, 0x980C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xb8", 3, 0x9838}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xa4", 3, 0x9824}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xa1", 3, 0x9821}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xb7", 3, 0x9837}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa0\xbd", 3, 0x983D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x86", 3, 0x9846}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x8f", 3, 0x984F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x8b", 3, 0x984B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xab", 3, 0x986B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xaf", 3, 0x986F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xb0", 3, 0x9870}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xb1", 3, 0x9871}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xb4", 3, 0x9874}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xb3", 3, 0x9873}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa2\xaa", 3, 0x98AA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa2\xaf", 3, 0x98AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa2\xb1", 3, 0x98B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa2\xb6", 3, 0x98B6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\x84", 3, 0x98C4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\x83", 3, 0x98C3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\x86", 3, 0x98C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xa9", 3, 0x98E9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa3\xab", 3, 0x98EB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x83", 3, 0x9903}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x89", 3, 0x9909}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x92", 3, 0x9912}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x94", 3, 0x9914}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x98", 3, 0x9918}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xa1", 3, 0x9921}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x9d", 3, 0x991D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\x9e", 3, 0x991E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xa4", 3, 0x9924}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xa0", 3, 0x9920}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xac", 3, 0x992C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xae", 3, 0x992E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xbd", 3, 0x993D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa4\xbe", 3, 0x993E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x82", 3, 0x9942}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x89", 3, 0x9949}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x85", 3, 0x9945}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x90", 3, 0x9950}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x8b", 3, 0x994B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x91", 3, 0x9951}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x92", 3, 0x9952}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x8c", 3, 0x994C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa5\x95", 3, 0x9955}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\x97", 3, 0x9997}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\x98", 3, 0x9998}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xa5", 3, 0x99A5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xad", 3, 0x99AD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xae", 3, 0x99AE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa6\xbc", 3, 0x99BC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x9f", 3, 0x99DF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x9b", 3, 0x99DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x9d", 3, 0x99DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x98", 3, 0x99D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\x91", 3, 0x99D1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xad", 3, 0x99ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xae", 3, 0x99EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xb1", 3, 0x99F1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xb2", 3, 0x99F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xbb", 3, 0x99FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xb8", 3, 0x99F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x81", 3, 0x9A01}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x8f", 3, 0x9A0F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x85", 3, 0x9A05}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa7\xa2", 3, 0x99E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\x99", 3, 0x9A19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\xab", 3, 0x9A2B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\xb7", 3, 0x9A37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x85", 3, 0x9A45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x82", 3, 0x9A42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x80", 3, 0x9A40}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x83", 3, 0x9A43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa8\xbe", 3, 0x9A3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x95", 3, 0x9A55}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x8d", 3, 0x9A4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x9b", 3, 0x9A5B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x97", 3, 0x9A57}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x9f", 3, 0x9A5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\xa2", 3, 0x9A62}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\xa5", 3, 0x9A65}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\xa4", 3, 0x9A64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\xa9", 3, 0x9A69}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\xab", 3, 0x9A6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\xaa", 3, 0x9A6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaa\xad", 3, 0x9AAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaa\xb0", 3, 0x9AB0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaa\xbc", 3, 0x9ABC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x80", 3, 0x9AC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x8f", 3, 0x9ACF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x91", 3, 0x9AD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x93", 3, 0x9AD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x94", 3, 0x9AD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x9e", 3, 0x9ADE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x9f", 3, 0x9ADF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xa2", 3, 0x9AE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xa3", 3, 0x9AE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xa6", 3, 0x9AE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xaf", 3, 0x9AEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xab", 3, 0x9AEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xae", 3, 0x9AEE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xb4", 3, 0x9AF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xb1", 3, 0x9AF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xb7", 3, 0x9AF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\xbb", 3, 0x9AFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\x86", 3, 0x9B06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\x98", 3, 0x9B18}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\x9a", 3, 0x9B1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\x9f", 3, 0x9B1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xa2", 3, 0x9B22}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xa3", 3, 0x9B23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xa5", 3, 0x9B25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xa7", 3, 0x9B27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xa8", 3, 0x9B28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xa9", 3, 0x9B29}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xaa", 3, 0x9B2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xae", 3, 0x9B2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xaf", 3, 0x9B2F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xac\xb2", 3, 0x9B32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x84", 3, 0x9B44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x83", 3, 0x9B43}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x8f", 3, 0x9B4F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x8d", 3, 0x9B4D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x8e", 3, 0x9B4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x91", 3, 0x9B51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\x98", 3, 0x9B58}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\xb4", 3, 0x9B74}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x93", 3, 0x9B93}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x83", 3, 0x9B83}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x91", 3, 0x9B91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x96", 3, 0x9B96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x97", 3, 0x9B97}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x9f", 3, 0x9B9F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xa0", 3, 0x9BA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xa8", 3, 0x9BA8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xb4", 3, 0x9BB4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x80", 3, 0x9BC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x8a", 3, 0x9BCA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xb9", 3, 0x9BB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x86", 3, 0x9BC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x8f", 3, 0x9BCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x91", 3, 0x9BD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x92", 3, 0x9BD2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xa3", 3, 0x9BE3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xa2", 3, 0x9BE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xa4", 3, 0x9BE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\x94", 3, 0x9BD4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xa1", 3, 0x9BE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xba", 3, 0x9C3A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xb2", 3, 0x9BF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xb1", 3, 0x9BF1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xaf\xb0", 3, 0x9BF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x95", 3, 0x9C15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x94", 3, 0x9C14}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x89", 3, 0x9C09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x93", 3, 0x9C13}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x8c", 3, 0x9C0C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x86", 3, 0x9C06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x88", 3, 0x9C08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x92", 3, 0x9C12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x8a", 3, 0x9C0A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x84", 3, 0x9C04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xae", 3, 0x9C2E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x9b", 3, 0x9C1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xa5", 3, 0x9C25}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xa4", 3, 0x9C24}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xa1", 3, 0x9C21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xb0", 3, 0x9C30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\x87", 3, 0x9C47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xb2", 3, 0x9C32}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\x86", 3, 0x9C46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\xbe", 3, 0x9C3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\x9a", 3, 0x9C5A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\xa0", 3, 0x9C60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\xa7", 3, 0x9C67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\xb6", 3, 0x9C76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb1\xb8", 3, 0x9C78}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xa7", 3, 0x9CE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xac", 3, 0x9CEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xb0", 3, 0x9CF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x89", 3, 0x9D09}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x88", 3, 0x9D08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb3\xab", 3, 0x9CEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x83", 3, 0x9D03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x86", 3, 0x9D06}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xaa", 3, 0x9D2A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xa6", 3, 0x9D26}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xaf", 3, 0x9DAF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xa3", 3, 0x9D23}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x9f", 3, 0x9D1F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x84", 3, 0x9D44}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x95", 3, 0x9D15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\x92", 3, 0x9D12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x81", 3, 0x9D41}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xbf", 3, 0x9D3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb4\xbe", 3, 0x9D3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x86", 3, 0x9D46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x88", 3, 0x9D48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x9d", 3, 0x9D5D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x9e", 3, 0x9D5E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xa4", 3, 0x9D64}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x91", 3, 0x9D51}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x90", 3, 0x9D50}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\x99", 3, 0x9D59}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xb2", 3, 0x9D72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\x89", 3, 0x9D89}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\x87", 3, 0x9D87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xab", 3, 0x9DAB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xaf", 3, 0x9D6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xba", 3, 0x9D7A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\x9a", 3, 0x9D9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xa4", 3, 0x9DA4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xa9", 3, 0x9DA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xb2", 3, 0x9DB2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x84", 3, 0x9DC4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x81", 3, 0x9DC1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xbb", 3, 0x9DBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xb8", 3, 0x9DB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb6\xba", 3, 0x9DBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x86", 3, 0x9DC6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x8f", 3, 0x9DCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x82", 3, 0x9DC2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x99", 3, 0x9DD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\x93", 3, 0x9DD3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xb8", 3, 0x9DF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xa6", 3, 0x9DE6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xad", 3, 0x9DED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xaf", 3, 0x9DEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb7\xbd", 3, 0x9DFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb8\x9a", 3, 0x9E1A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb8\x9b", 3, 0x9E1B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb8\x9e", 3, 0x9E1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb9\xb5", 3, 0x9E75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb9\xb9", 3, 0x9E79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb9\xbd", 3, 0x9E7D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x81", 3, 0x9E81}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x88", 3, 0x9E88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x8b", 3, 0x9E8B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x8c", 3, 0x9E8C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x92", 3, 0x9E92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x95", 3, 0x9E95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x91", 3, 0x9E91}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\x9d", 3, 0x9E9D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xa5", 3, 0x9EA5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xa9", 3, 0x9EA9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xb8", 3, 0x9EB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xaa", 3, 0x9EAA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xba\xad", 3, 0x9EAD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\xa1", 3, 0x9761}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x8c", 3, 0x9ECC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x8e", 3, 0x9ECE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x8f", 3, 0x9ECF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x90", 3, 0x9ED0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x94", 3, 0x9ED4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x9c", 3, 0x9EDC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x9e", 3, 0x9EDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x9d", 3, 0x9EDD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xa0", 3, 0x9EE0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xa5", 3, 0x9EE5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xa8", 3, 0x9EE8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xaf", 3, 0x9EEF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xb4", 3, 0x9EF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xb6", 3, 0x9EF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xb7", 3, 0x9EF7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xb9", 3, 0x9EF9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xbb", 3, 0x9EFB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xbc", 3, 0x9EFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\xbd", 3, 0x9EFD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\x87", 3, 0x9F07}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\x88", 3, 0x9F08}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xb7", 3, 0x76B7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\x95", 3, 0x9F15}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\xa1", 3, 0x9F21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\xac", 3, 0x9F2C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbc\xbe", 3, 0x9F3E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x8a", 3, 0x9F4A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x92", 3, 0x9F52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x94", 3, 0x9F54}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xa3", 3, 0x9F63}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\x9f", 3, 0x9F5F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xa0", 3, 0x9F60}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xa1", 3, 0x9F61}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xa6", 3, 0x9F66}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xa7", 3, 0x9F67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xac", 3, 0x9F6C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xaa", 3, 0x9F6A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xb7", 3, 0x9F77}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xb2", 3, 0x9F72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbd\xb6", 3, 0x9F76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbe\x95", 3, 0x9F95}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbe\x9c", 3, 0x9F9C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbe\xa0", 3, 0x9FA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa0\xaf", 3, 0x582F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\x87", 3, 0x69C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x81\x99", 3, 0x9059}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xa4", 3, 0x7464}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\x9c", 3, 0x51DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x86\x99", 3, 0x7199}, /* (<CJK Ideograph>) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe7\xba\x8a", 3, 0x7E8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x9c", 3, 0x891C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x88", 3, 0x9348}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x88", 3, 0x9288}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x9c", 3, 0x84DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x89", 3, 0x4FC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xbb", 3, 0x70BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xb1", 3, 0x6631}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x88", 3, 0x68C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xb9", 3, 0x92F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xbb", 3, 0x66FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x85", 3, 0x5F45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xa8", 3, 0x4E28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xa1", 3, 0x4EE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xbc", 3, 0x4EFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x80", 3, 0x4F00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x83", 3, 0x4F03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xb9", 3, 0x4F39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x96", 3, 0x4F56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x92", 3, 0x4F92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x8a", 3, 0x4F8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x9a", 3, 0x4F9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x94", 3, 0x4F94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x8d", 3, 0x4FCD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x80", 3, 0x5040}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa2", 3, 0x5022}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xbf", 3, 0x4FFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x9e", 3, 0x501E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x86", 3, 0x5046}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb0", 3, 0x5070}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x82", 3, 0x5042}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x94", 3, 0x5094}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xb4", 3, 0x50F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x98", 3, 0x50D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x8a", 3, 0x514A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xa4", 3, 0x5164}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x9d", 3, 0x519D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xbe", 3, 0x51BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xac", 3, 0x51EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x95", 3, 0x5215}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x9c", 3, 0x529C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xa6", 3, 0x52A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x80", 3, 0x52C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x9b", 3, 0x52DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x80", 3, 0x5300}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x87", 3, 0x5307}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xa4", 3, 0x5324}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb2", 3, 0x5372}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x93", 3, 0x5393}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xb2", 3, 0x53B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x9d", 3, 0x53DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x8e", 3, 0xFA0E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0E) */
    {(lxb_char_t *) "\xe5\x92\x9c", 3, 0x549C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x8a", 3, 0x548A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xa9", 3, 0x54A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xbf", 3, 0x54FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x86", 3, 0x5586}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x99", 3, 0x5759}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xa5", 3, 0x5765}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xac", 3, 0x57AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x88", 3, 0x57C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x87", 3, 0x57C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x8f", 3, 0xFA0F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0F) */
    {(lxb_char_t *) "\xef\xa8\x90", 3, 0xFA10}, /* (CJK COMPATIBILITY IDEOGRAPH-FA10) */
    {(lxb_char_t *) "\xe5\xa2\x9e", 3, 0x589E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xb2", 3, 0x58B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x8b", 3, 0x590B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x93", 3, 0x5953}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x9b", 3, 0x595B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x9d", 3, 0x595D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa3", 3, 0x5963}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xa4", 3, 0x59A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xba", 3, 0x59BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x96", 3, 0x5B56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x80", 3, 0x5BC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xaf", 3, 0x752F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x98", 3, 0x5BD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xac", 3, 0x5BEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x9e", 3, 0x5C1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xa6", 3, 0x5CA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xba", 3, 0x5CBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xb5", 3, 0x5CF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\xa7", 3, 0x5D27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x93", 3, 0x5D53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x91", 3, 0xFA11}, /* (CJK COMPATIBILITY IDEOGRAPH-FA11) */
    {(lxb_char_t *) "\xe5\xb5\x82", 3, 0x5D42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xad", 3, 0x5D6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xb8", 3, 0x5DB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xb9", 3, 0x5DB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x90", 3, 0x5DD0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xa1", 3, 0x5F21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xb4", 3, 0x5F34}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xa7", 3, 0x5F67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xb7", 3, 0x5FB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x9e", 3, 0x5FDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x9d", 3, 0x605D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x85", 3, 0x6085}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x8a", 3, 0x608A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x9e", 3, 0x60DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x95", 3, 0x60D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xa0", 3, 0x6120}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb2", 3, 0x60F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x91", 3, 0x6111}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xb7", 3, 0x6137}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xb0", 3, 0x6130}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x98", 3, 0x6198}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x93", 3, 0x6213}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xa6", 3, 0x62A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xb5", 3, 0x63F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xa0", 3, 0x6460}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x9d", 3, 0x649D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x8e", 3, 0x64CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x8e", 3, 0x654E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x80", 3, 0x6600}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x95", 3, 0x6615}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xbb", 3, 0x663B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x89", 3, 0x6609}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xae", 3, 0x662E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x9e", 3, 0x661E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xa4", 3, 0x6624}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa5", 3, 0x6665}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x97", 3, 0x6657}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x99", 3, 0x6659}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x92", 3, 0xFA12}, /* (CJK COMPATIBILITY IDEOGRAPH-FA12) */
    {(lxb_char_t *) "\xe6\x99\xb3", 3, 0x6673}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x99", 3, 0x6699}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xa0", 3, 0x66A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xb2", 3, 0x66B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xbf", 3, 0x66BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xba", 3, 0x66FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x8e", 3, 0x670E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa4\xa9", 3, 0xF929}, /* (CJK COMPATIBILITY IDEOGRAPH-F929) */
    {(lxb_char_t *) "\xe6\x9d\xa6", 3, 0x6766}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xbb", 3, 0x67BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x92", 3, 0x6852}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x80", 3, 0x67C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x81", 3, 0x6801}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x84", 3, 0x6844}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x8f", 3, 0x68CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x93", 3, 0xFA13}, /* (CJK COMPATIBILITY IDEOGRAPH-FA13) */
    {(lxb_char_t *) "\xe6\xa5\xa8", 3, 0x6968}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x94", 3, 0xFA14}, /* (CJK COMPATIBILITY IDEOGRAPH-FA14) */
    {(lxb_char_t *) "\xe6\xa6\x98", 3, 0x6998}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xa2", 3, 0x69E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xb0", 3, 0x6A30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xab", 3, 0x6A6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x86", 3, 0x6A46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xb3", 3, 0x6A73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xbe", 3, 0x6A7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xa2", 3, 0x6AE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xa4", 3, 0x6AE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x96", 3, 0x6BD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xbf", 3, 0x6C3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x9c", 3, 0x6C5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x86", 3, 0x6C86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xaf", 3, 0x6C6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x9a", 3, 0x6CDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x84", 3, 0x6D04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x87", 3, 0x6D87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xaf", 3, 0x6D6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x96", 3, 0x6D96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xac", 3, 0x6DAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x8f", 3, 0x6DCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb8", 3, 0x6DF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb2", 3, 0x6DF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xbc", 3, 0x6DFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xb9", 3, 0x6E39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x9c", 3, 0x6E5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa7", 3, 0x6E27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xbc", 3, 0x6E3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xbf", 3, 0x6EBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x88", 3, 0x6F88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xb5", 3, 0x6FB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xb5", 3, 0x6FF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x85", 3, 0x7005}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x87", 3, 0x7007}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xa8", 3, 0x7028}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x85", 3, 0x7085}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xab", 3, 0x70AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x8f", 3, 0x710F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x84", 3, 0x7104}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x9c", 3, 0x715C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x86", 3, 0x7146}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x87", 3, 0x7147}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x95", 3, 0xFA15}, /* (CJK COMPATIBILITY IDEOGRAPH-FA15) */
    {(lxb_char_t *) "\xe7\x87\x81", 3, 0x71C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xbe", 3, 0x71FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xb1", 3, 0x72B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xbe", 3, 0x72BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xa4", 3, 0x7324}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x96", 3, 0xFA16}, /* (CJK COMPATIBILITY IDEOGRAPH-FA16) */
    {(lxb_char_t *) "\xe7\x8d\xb7", 3, 0x7377}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\xbd", 3, 0x73BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x89", 3, 0x73C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x96", 3, 0x73D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xa3", 3, 0x73E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x92", 3, 0x73D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\x87", 3, 0x7407}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xb5", 3, 0x73F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xa6", 3, 0x7426}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xaa", 3, 0x742A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xa9", 3, 0x7429}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xae", 3, 0x742E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xa2", 3, 0x7462}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x89", 3, 0x7489}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x9f", 3, 0x749F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x81", 3, 0x7501}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xaf", 3, 0x756F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x82", 3, 0x7682}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9c", 3, 0x769C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9e", 3, 0x769E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9b", 3, 0x769B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xa6", 3, 0x76A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x97", 3, 0xFA17}, /* (CJK COMPATIBILITY IDEOGRAPH-FA17) */
    {(lxb_char_t *) "\xe7\x9d\x86", 3, 0x7746}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xaf", 3, 0x52AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xa1", 3, 0x7821}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\x8e", 3, 0x784E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xa4", 3, 0x7864}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xba", 3, 0x787A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xb0", 3, 0x7930}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x98", 3, 0xFA18}, /* (CJK COMPATIBILITY IDEOGRAPH-FA18) */
    {(lxb_char_t *) "\xef\xa8\x99", 3, 0xFA19}, /* (CJK COMPATIBILITY IDEOGRAPH-FA19) */
    {(lxb_char_t *) "\xef\xa8\x9a", 3, 0xFA1A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1A) */
    {(lxb_char_t *) "\xe7\xa6\x94", 3, 0x7994}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9b", 3, 0xFA1B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1B) */
    {(lxb_char_t *) "\xe7\xa6\x9b", 3, 0x799B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x91", 3, 0x7AD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa7", 3, 0x7AE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9c", 3, 0xFA1C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1C) */
    {(lxb_char_t *) "\xe7\xab\xab", 3, 0x7AEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x9e", 3, 0x7B9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9d", 3, 0xFA1D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1D) */
    {(lxb_char_t *) "\xe7\xb5\x88", 3, 0x7D48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x9c", 3, 0x7D5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb7", 3, 0x7DB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xa0", 3, 0x7DA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x96", 3, 0x7DD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x92", 3, 0x7E52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x87", 3, 0x7F47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xa1", 3, 0x7FA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9e", 3, 0xFA1E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1E) */
    {(lxb_char_t *) "\xe8\x8c\x81", 3, 0x8301}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xa2", 3, 0x8362}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xbf", 3, 0x837F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x87", 3, 0x83C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb6", 3, 0x83F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x88", 3, 0x8448}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xb4", 3, 0x84B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x93", 3, 0x8553}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x99", 3, 0x8559}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xab", 3, 0x856B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9f", 3, 0xFA1F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1F) */
    {(lxb_char_t *) "\xe8\x96\xb0", 3, 0x85B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa0", 3, 0xFA20}, /* (CJK COMPATIBILITY IDEOGRAPH-FA20) */
    {(lxb_char_t *) "\xef\xa8\xa1", 3, 0xFA21}, /* (CJK COMPATIBILITY IDEOGRAPH-FA21) */
    {(lxb_char_t *) "\xe8\xa0\x87", 3, 0x8807}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb5", 3, 0x88F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x92", 3, 0x8A12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xb7", 3, 0x8A37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xb9", 3, 0x8A79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa7", 3, 0x8AA7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xbe", 3, 0x8ABE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x9f", 3, 0x8ADF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa2", 3, 0xFA22}, /* (CJK COMPATIBILITY IDEOGRAPH-FA22) */
    {(lxb_char_t *) "\xe8\xab\xb6", 3, 0x8AF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x93", 3, 0x8B53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xbf", 3, 0x8B7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xb0", 3, 0x8CF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xb4", 3, 0x8CF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x92", 3, 0x8D12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb6", 3, 0x8D76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa3", 3, 0xFA23}, /* (CJK COMPATIBILITY IDEOGRAPH-FA23) */
    {(lxb_char_t *) "\xe8\xbb\x8f", 3, 0x8ECF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa4", 3, 0xFA24}, /* (CJK COMPATIBILITY IDEOGRAPH-FA24) */
    {(lxb_char_t *) "\xef\xa8\xa5", 3, 0xFA25}, /* (CJK COMPATIBILITY IDEOGRAPH-FA25) */
    {(lxb_char_t *) "\xe9\x81\xa7", 3, 0x9067}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\x9e", 3, 0x90DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa6", 3, 0xFA26}, /* (CJK COMPATIBILITY IDEOGRAPH-FA26) */
    {(lxb_char_t *) "\xe9\x84\x95", 3, 0x9115}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\xa7", 3, 0x9127}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9a", 3, 0x91DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x97", 3, 0x91D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9e", 3, 0x91DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xad", 3, 0x91ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xae", 3, 0x91EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa4", 3, 0x91E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa5", 3, 0x91E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x86", 3, 0x9206}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x90", 3, 0x9210}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x8a", 3, 0x920A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xba", 3, 0x923A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x80", 3, 0x9240}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xbc", 3, 0x923C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x8e", 3, 0x924E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x99", 3, 0x9259}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x91", 3, 0x9251}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xb9", 3, 0x9239}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xa7", 3, 0x9267}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\xa7", 3, 0x92A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xb7", 3, 0x9277}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xb8", 3, 0x9278}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xa7", 3, 0x92E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x97", 3, 0x92D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x99", 3, 0x92D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x90", 3, 0x92D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa7", 3, 0xFA27}, /* (CJK COMPATIBILITY IDEOGRAPH-FA27) */
    {(lxb_char_t *) "\xe9\x8b\x95", 3, 0x92D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xa0", 3, 0x92E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x93", 3, 0x92D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa5", 3, 0x9325}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa1", 3, 0x9321}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xbb", 3, 0x92FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa8", 3, 0xFA28}, /* (CJK COMPATIBILITY IDEOGRAPH-FA28) */
    {(lxb_char_t *) "\xe9\x8c\x9e", 3, 0x931E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xbf", 3, 0x92FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x9d", 3, 0x931D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x82", 3, 0x9302}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xb0", 3, 0x9370}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x97", 3, 0x9357}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xa4", 3, 0x93A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x86", 3, 0x93C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x9e", 3, 0x93DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\xb8", 3, 0x93F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xb1", 3, 0x9431}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x85", 3, 0x9445}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x88", 3, 0x9448}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x92", 3, 0x9592}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa7\x9c", 3, 0xF9DC}, /* (CJK COMPATIBILITY IDEOGRAPH-F9DC) */
    {(lxb_char_t *) "\xef\xa8\xa9", 3, 0xFA29}, /* (CJK COMPATIBILITY IDEOGRAPH-FA29) */
    {(lxb_char_t *) "\xe9\x9a\x9d", 3, 0x969D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xaf", 3, 0x96AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xb3", 3, 0x9733}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xbb", 3, 0x973B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x83", 3, 0x9743}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x8d", 3, 0x974D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x8f", 3, 0x974F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x91", 3, 0x9751}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x95", 3, 0x9755}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x97", 3, 0x9857}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xa5", 3, 0x9865}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xaa", 3, 0xFA2A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2A) */
    {(lxb_char_t *) "\xef\xa8\xab", 3, 0xFA2B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2B) */
    {(lxb_char_t *) "\xe9\xa4\xa7", 3, 0x9927}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xac", 3, 0xFA2C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2C) */
    {(lxb_char_t *) "\xe9\xa6\x9e", 3, 0x999E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x8e", 3, 0x9A4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x99", 3, 0x9AD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x9c", 3, 0x9ADC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\xb5", 3, 0x9B75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\xb2", 3, 0x9B72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x8f", 3, 0x9B8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xb1", 3, 0x9BB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xbb", 3, 0x9BBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x80", 3, 0x9C00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xb0", 3, 0x9D70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xab", 3, 0x9D6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xad", 3, 0xFA2D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2D) */
    {(lxb_char_t *) "\xe9\xb8\x99", 3, 0x9E19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x91", 3, 0x9ED1}, /* (<CJK Ideograph>) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x85\xb0", 3, 0x2170}, /* (SMALL ROMAN NUMERAL ONE) */
    {(lxb_char_t *) "\xe2\x85\xb1", 3, 0x2171}, /* (SMALL ROMAN NUMERAL TWO) */
    {(lxb_char_t *) "\xe2\x85\xb2", 3, 0x2172}, /* (SMALL ROMAN NUMERAL THREE) */
    {(lxb_char_t *) "\xe2\x85\xb3", 3, 0x2173}, /* (SMALL ROMAN NUMERAL FOUR) */
    {(lxb_char_t *) "\xe2\x85\xb4", 3, 0x2174}, /* (SMALL ROMAN NUMERAL FIVE) */
    {(lxb_char_t *) "\xe2\x85\xb5", 3, 0x2175}, /* (SMALL ROMAN NUMERAL SIX) */
    {(lxb_char_t *) "\xe2\x85\xb6", 3, 0x2176}, /* (SMALL ROMAN NUMERAL SEVEN) */
    {(lxb_char_t *) "\xe2\x85\xb7", 3, 0x2177}, /* (SMALL ROMAN NUMERAL EIGHT) */
    {(lxb_char_t *) "\xe2\x85\xb8", 3, 0x2178}, /* (SMALL ROMAN NUMERAL NINE) */
    {(lxb_char_t *) "\xe2\x85\xb9", 3, 0x2179}, /* (SMALL ROMAN NUMERAL TEN) */
    {(lxb_char_t *) "\xef\xbf\xa2", 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {(lxb_char_t *) "\xef\xbf\xa4", 3, 0xFFE4}, /* (FULLWIDTH BROKEN BAR) */
    {(lxb_char_t *) "\xef\xbc\x87", 3, 0xFF07}, /* (FULLWIDTH APOSTROPHE) */
    {(lxb_char_t *) "\xef\xbc\x82", 3, 0xFF02}, /* (FULLWIDTH QUOTATION MARK) */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {NULL, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {(lxb_char_t *) "\xe2\x85\xb0", 3, 0x2170}, /* (SMALL ROMAN NUMERAL ONE) */
    {(lxb_char_t *) "\xe2\x85\xb1", 3, 0x2171}, /* (SMALL ROMAN NUMERAL TWO) */
    {(lxb_char_t *) "\xe2\x85\xb2", 3, 0x2172}, /* (SMALL ROMAN NUMERAL THREE) */
    {(lxb_char_t *) "\xe2\x85\xb3", 3, 0x2173}, /* (SMALL ROMAN NUMERAL FOUR) */
    {(lxb_char_t *) "\xe2\x85\xb4", 3, 0x2174}, /* (SMALL ROMAN NUMERAL FIVE) */
    {(lxb_char_t *) "\xe2\x85\xb5", 3, 0x2175}, /* (SMALL ROMAN NUMERAL SIX) */
    {(lxb_char_t *) "\xe2\x85\xb6", 3, 0x2176}, /* (SMALL ROMAN NUMERAL SEVEN) */
    {(lxb_char_t *) "\xe2\x85\xb7", 3, 0x2177}, /* (SMALL ROMAN NUMERAL EIGHT) */
    {(lxb_char_t *) "\xe2\x85\xb8", 3, 0x2178}, /* (SMALL ROMAN NUMERAL NINE) */
    {(lxb_char_t *) "\xe2\x85\xb9", 3, 0x2179}, /* (SMALL ROMAN NUMERAL TEN) */
    {(lxb_char_t *) "\xe2\x85\xa0", 3, 0x2160}, /* (ROMAN NUMERAL ONE) */
    {(lxb_char_t *) "\xe2\x85\xa1", 3, 0x2161}, /* (ROMAN NUMERAL TWO) */
    {(lxb_char_t *) "\xe2\x85\xa2", 3, 0x2162}, /* (ROMAN NUMERAL THREE) */
    {(lxb_char_t *) "\xe2\x85\xa3", 3, 0x2163}, /* (ROMAN NUMERAL FOUR) */
    {(lxb_char_t *) "\xe2\x85\xa4", 3, 0x2164}, /* (ROMAN NUMERAL FIVE) */
    {(lxb_char_t *) "\xe2\x85\xa5", 3, 0x2165}, /* (ROMAN NUMERAL SIX) */
    {(lxb_char_t *) "\xe2\x85\xa6", 3, 0x2166}, /* (ROMAN NUMERAL SEVEN) */
    {(lxb_char_t *) "\xe2\x85\xa7", 3, 0x2167}, /* (ROMAN NUMERAL EIGHT) */
    {(lxb_char_t *) "\xe2\x85\xa8", 3, 0x2168}, /* (ROMAN NUMERAL NINE) */
    {(lxb_char_t *) "\xe2\x85\xa9", 3, 0x2169}, /* (ROMAN NUMERAL TEN) */
    {(lxb_char_t *) "\xef\xbf\xa2", 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {(lxb_char_t *) "\xef\xbf\xa4", 3, 0xFFE4}, /* (FULLWIDTH BROKEN BAR) */
    {(lxb_char_t *) "\xef\xbc\x87", 3, 0xFF07}, /* (FULLWIDTH APOSTROPHE) */
    {(lxb_char_t *) "\xef\xbc\x82", 3, 0xFF02}, /* (FULLWIDTH QUOTATION MARK) */
    {(lxb_char_t *) "\xe3\x88\xb1", 3, 0x3231}, /* (PARENTHESIZED IDEOGRAPH STOCK) */
    {(lxb_char_t *) "\xe2\x84\x96", 3, 0x2116}, /* (NUMERO SIGN) */
    {(lxb_char_t *) "\xe2\x84\xa1", 3, 0x2121}, /* (TELEPHONE SIGN) */
    {(lxb_char_t *) "\xe2\x88\xb5", 3, 0x2235}, /* (BECAUSE) */
    {(lxb_char_t *) "\xe7\xba\x8a", 3, 0x7E8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa4\x9c", 3, 0x891C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x88", 3, 0x9348}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\x88", 3, 0x9288}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x93\x9c", 3, 0x84DC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x89", 3, 0x4FC9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xbb", 3, 0x70BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xb1", 3, 0x6631}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x88", 3, 0x68C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xb9", 3, 0x92F9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xbb", 3, 0x66FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\x85", 3, 0x5F45}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xb8\xa8", 3, 0x4E28}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xa1", 3, 0x4EE1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbb\xbc", 3, 0x4EFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x80", 3, 0x4F00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\x83", 3, 0x4F03}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbc\xb9", 3, 0x4F39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbd\x96", 3, 0x4F56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x92", 3, 0x4F92}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x8a", 3, 0x4F8A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x9a", 3, 0x4F9A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbe\x94", 3, 0x4F94}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\x8d", 3, 0x4FCD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x80", 3, 0x5040}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\xa2", 3, 0x5022}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe4\xbf\xbf", 3, 0x4FFF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x80\x9e", 3, 0x501E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x86", 3, 0x5046}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\xb0", 3, 0x5070}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x81\x82", 3, 0x5042}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x82\x94", 3, 0x5094}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\xb4", 3, 0x50F4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x83\x98", 3, 0x50D8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\x8a", 3, 0x514A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x85\xa4", 3, 0x5164}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\x9d", 3, 0x519D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x86\xbe", 3, 0x51BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x87\xac", 3, 0x51EC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x88\x95", 3, 0x5215}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\x9c", 3, 0x529C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xa6", 3, 0x52A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x80", 3, 0x52C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8b\x9b", 3, 0x52DB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x80", 3, 0x5300}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\x87", 3, 0x5307}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8c\xa4", 3, 0x5324}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8d\xb2", 3, 0x5372}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\x93", 3, 0x5393}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8e\xb2", 3, 0x53B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8f\x9d", 3, 0x53DD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x8e", 3, 0xFA0E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0E) */
    {(lxb_char_t *) "\xe5\x92\x9c", 3, 0x549C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\x8a", 3, 0x548A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x92\xa9", 3, 0x54A9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x93\xbf", 3, 0x54FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x96\x86", 3, 0x5586}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\x99", 3, 0x5759}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9d\xa5", 3, 0x5765}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9e\xac", 3, 0x57AC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x88", 3, 0x57C8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x9f\x87", 3, 0x57C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x8f", 3, 0xFA0F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0F) */
    {(lxb_char_t *) "\xef\xa8\x90", 3, 0xFA10}, /* (CJK COMPATIBILITY IDEOGRAPH-FA10) */
    {(lxb_char_t *) "\xe5\xa2\x9e", 3, 0x589E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa2\xb2", 3, 0x58B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa4\x8b", 3, 0x590B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x93", 3, 0x5953}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x9b", 3, 0x595B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\x9d", 3, 0x595D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa5\xa3", 3, 0x5963}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xa4", 3, 0x59A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xa6\xba", 3, 0x59BA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xad\x96", 3, 0x5B56}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x80", 3, 0x5BC0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\xaf", 3, 0x752F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\x98", 3, 0x5BD8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xaf\xac", 3, 0x5BEC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb0\x9e", 3, 0x5C1E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xa6", 3, 0x5CA6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb2\xba", 3, 0x5CBA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb3\xb5", 3, 0x5CF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb4\xa7", 3, 0x5D27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\x93", 3, 0x5D53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x91", 3, 0xFA11}, /* (CJK COMPATIBILITY IDEOGRAPH-FA11) */
    {(lxb_char_t *) "\xe5\xb5\x82", 3, 0x5D42}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb5\xad", 3, 0x5D6D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xb8", 3, 0x5DB8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb6\xb9", 3, 0x5DB9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xb7\x90", 3, 0x5DD0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xa1", 3, 0x5F21}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbc\xb4", 3, 0x5F34}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbd\xa7", 3, 0x5F67}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbe\xb7", 3, 0x5FB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\xbf\x9e", 3, 0x5FDE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x81\x9d", 3, 0x605D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x85", 3, 0x6085}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x82\x8a", 3, 0x608A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x9e", 3, 0x60DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\x95", 3, 0x60D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xa0", 3, 0x6120}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x83\xb2", 3, 0x60F2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\x91", 3, 0x6111}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xb7", 3, 0x6137}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x84\xb0", 3, 0x6130}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x86\x98", 3, 0x6198}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x88\x93", 3, 0x6213}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8a\xa6", 3, 0x62A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x8f\xb5", 3, 0x63F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x91\xa0", 3, 0x6460}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x92\x9d", 3, 0x649D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x93\x8e", 3, 0x64CE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x95\x8e", 3, 0x654E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x80", 3, 0x6600}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x95", 3, 0x6615}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xbb", 3, 0x663B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x89", 3, 0x6609}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xae", 3, 0x662E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\x9e", 3, 0x661E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x98\xa4", 3, 0x6624}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\xa5", 3, 0x6665}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x97", 3, 0x6657}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x99\x99", 3, 0x6659}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x92", 3, 0xFA12}, /* (CJK COMPATIBILITY IDEOGRAPH-FA12) */
    {(lxb_char_t *) "\xe6\x99\xb3", 3, 0x6673}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\x99", 3, 0x6699}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xa0", 3, 0x66A0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xb2", 3, 0x66B2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9a\xbf", 3, 0x66BF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9b\xba", 3, 0x66FA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9c\x8e", 3, 0x670E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa4\xa9", 3, 0xF929}, /* (CJK COMPATIBILITY IDEOGRAPH-F929) */
    {(lxb_char_t *) "\xe6\x9d\xa6", 3, 0x6766}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9e\xbb", 3, 0x67BB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x92", 3, 0x6852}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\x9f\x80", 3, 0x67C0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa0\x81", 3, 0x6801}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa1\x84", 3, 0x6844}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa3\x8f", 3, 0x68CF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x93", 3, 0xFA13}, /* (CJK COMPATIBILITY IDEOGRAPH-FA13) */
    {(lxb_char_t *) "\xe6\xa5\xa8", 3, 0x6968}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x94", 3, 0xFA14}, /* (CJK COMPATIBILITY IDEOGRAPH-FA14) */
    {(lxb_char_t *) "\xe6\xa6\x98", 3, 0x6998}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa7\xa2", 3, 0x69E2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa8\xb0", 3, 0x6A30}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xab", 3, 0x6A6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\x86", 3, 0x6A46}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xb3", 3, 0x6A73}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xa9\xbe", 3, 0x6A7E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xa2", 3, 0x6AE2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xab\xa4", 3, 0x6AE4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xaf\x96", 3, 0x6BD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb0\xbf", 3, 0x6C3F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\x9c", 3, 0x6C5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb2\x86", 3, 0x6C86}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb1\xaf", 3, 0x6C6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb3\x9a", 3, 0x6CDA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb4\x84", 3, 0x6D04}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x87", 3, 0x6D87}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb5\xaf", 3, 0x6D6F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\x96", 3, 0x6D96}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb6\xac", 3, 0x6DAC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\x8f", 3, 0x6DCF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb8", 3, 0x6DF8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xb2", 3, 0x6DF2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb7\xbc", 3, 0x6DFC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xb9", 3, 0x6E39}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb9\x9c", 3, 0x6E5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xa7", 3, 0x6E27}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xb8\xbc", 3, 0x6E3C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xba\xbf", 3, 0x6EBF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\x88", 3, 0x6F88}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbe\xb5", 3, 0x6FB5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe6\xbf\xb5", 3, 0x6FF5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x85", 3, 0x7005}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\x87", 3, 0x7007}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x80\xa8", 3, 0x7028}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\x85", 3, 0x7085}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x82\xab", 3, 0x70AB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x8f", 3, 0x710F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x84\x84", 3, 0x7104}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x9c", 3, 0x715C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x86", 3, 0x7146}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x85\x87", 3, 0x7147}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x95", 3, 0xFA15}, /* (CJK COMPATIBILITY IDEOGRAPH-FA15) */
    {(lxb_char_t *) "\xe7\x87\x81", 3, 0x71C1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x87\xbe", 3, 0x71FE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xb1", 3, 0x72B1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8a\xbe", 3, 0x72BE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8c\xa4", 3, 0x7324}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x96", 3, 0xFA16}, /* (CJK COMPATIBILITY IDEOGRAPH-FA16) */
    {(lxb_char_t *) "\xe7\x8d\xb7", 3, 0x7377}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8e\xbd", 3, 0x73BD}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x89", 3, 0x73C9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x96", 3, 0x73D6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xa3", 3, 0x73E3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\x92", 3, 0x73D2}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\x87", 3, 0x7407}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x8f\xb5", 3, 0x73F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xa6", 3, 0x7426}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xaa", 3, 0x742A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xa9", 3, 0x7429}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x90\xae", 3, 0x742E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x91\xa2", 3, 0x7462}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x89", 3, 0x7489}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x92\x9f", 3, 0x749F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x94\x81", 3, 0x7501}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x95\xaf", 3, 0x756F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x82", 3, 0x7682}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9c", 3, 0x769C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9e", 3, 0x769E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\x9b", 3, 0x769B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\x9a\xa6", 3, 0x76A6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x97", 3, 0xFA17}, /* (CJK COMPATIBILITY IDEOGRAPH-FA17) */
    {(lxb_char_t *) "\xe7\x9d\x86", 3, 0x7746}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe5\x8a\xaf", 3, 0x52AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa0\xa1", 3, 0x7821}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\x8e", 3, 0x784E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xa4", 3, 0x7864}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa1\xba", 3, 0x787A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xa4\xb0", 3, 0x7930}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x98", 3, 0xFA18}, /* (CJK COMPATIBILITY IDEOGRAPH-FA18) */
    {(lxb_char_t *) "\xef\xa8\x99", 3, 0xFA19}, /* (CJK COMPATIBILITY IDEOGRAPH-FA19) */
    {(lxb_char_t *) "\xef\xa8\x9a", 3, 0xFA1A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1A) */
    {(lxb_char_t *) "\xe7\xa6\x94", 3, 0x7994}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9b", 3, 0xFA1B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1B) */
    {(lxb_char_t *) "\xe7\xa6\x9b", 3, 0x799B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\x91", 3, 0x7AD1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xab\xa7", 3, 0x7AE7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9c", 3, 0xFA1C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1C) */
    {(lxb_char_t *) "\xe7\xab\xab", 3, 0x7AEB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xae\x9e", 3, 0x7B9E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9d", 3, 0xFA1D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1D) */
    {(lxb_char_t *) "\xe7\xb5\x88", 3, 0x7D48}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb5\x9c", 3, 0x7D5C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xb7", 3, 0x7DB7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb6\xa0", 3, 0x7DA0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb7\x96", 3, 0x7DD6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xb9\x92", 3, 0x7E52}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbd\x87", 3, 0x7F47}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe7\xbe\xa1", 3, 0x7FA1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9e", 3, 0xFA1E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1E) */
    {(lxb_char_t *) "\xe8\x8c\x81", 3, 0x8301}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xa2", 3, 0x8362}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8d\xbf", 3, 0x837F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\x87", 3, 0x83C7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x8f\xb6", 3, 0x83F6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x91\x88", 3, 0x8448}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x92\xb4", 3, 0x84B4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x93", 3, 0x8553}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\x99", 3, 0x8559}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\x95\xab", 3, 0x856B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\x9f", 3, 0xFA1F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1F) */
    {(lxb_char_t *) "\xe8\x96\xb0", 3, 0x85B0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa0", 3, 0xFA20}, /* (CJK COMPATIBILITY IDEOGRAPH-FA20) */
    {(lxb_char_t *) "\xef\xa8\xa1", 3, 0xFA21}, /* (CJK COMPATIBILITY IDEOGRAPH-FA21) */
    {(lxb_char_t *) "\xe8\xa0\x87", 3, 0x8807}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa3\xb5", 3, 0x88F5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\x92", 3, 0x8A12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa8\xb7", 3, 0x8A37}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xa9\xb9", 3, 0x8A79}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xa7", 3, 0x8AA7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xaa\xbe", 3, 0x8ABE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xab\x9f", 3, 0x8ADF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa2", 3, 0xFA22}, /* (CJK COMPATIBILITY IDEOGRAPH-FA22) */
    {(lxb_char_t *) "\xe8\xab\xb6", 3, 0x8AF6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\x93", 3, 0x8B53}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xad\xbf", 3, 0x8B7F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xb0", 3, 0x8CF0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb3\xb4", 3, 0x8CF4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb4\x92", 3, 0x8D12}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe8\xb5\xb6", 3, 0x8D76}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa3", 3, 0xFA23}, /* (CJK COMPATIBILITY IDEOGRAPH-FA23) */
    {(lxb_char_t *) "\xe8\xbb\x8f", 3, 0x8ECF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa4", 3, 0xFA24}, /* (CJK COMPATIBILITY IDEOGRAPH-FA24) */
    {(lxb_char_t *) "\xef\xa8\xa5", 3, 0xFA25}, /* (CJK COMPATIBILITY IDEOGRAPH-FA25) */
    {(lxb_char_t *) "\xe9\x81\xa7", 3, 0x9067}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x83\x9e", 3, 0x90DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa6", 3, 0xFA26}, /* (CJK COMPATIBILITY IDEOGRAPH-FA26) */
    {(lxb_char_t *) "\xe9\x84\x95", 3, 0x9115}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x84\xa7", 3, 0x9127}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9a", 3, 0x91DA}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x97", 3, 0x91D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\x9e", 3, 0x91DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xad", 3, 0x91ED}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xae", 3, 0x91EE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa4", 3, 0x91E4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x87\xa5", 3, 0x91E5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x86", 3, 0x9206}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x90", 3, 0x9210}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\x8a", 3, 0x920A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xba", 3, 0x923A}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x80", 3, 0x9240}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xbc", 3, 0x923C}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x8e", 3, 0x924E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x99", 3, 0x9259}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\x91", 3, 0x9251}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x88\xb9", 3, 0x9239}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xa7", 3, 0x9267}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8a\xa7", 3, 0x92A7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xb7", 3, 0x9277}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x89\xb8", 3, 0x9278}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xa7", 3, 0x92E7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x97", 3, 0x92D7}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x99", 3, 0x92D9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x90", 3, 0x92D0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa7", 3, 0xFA27}, /* (CJK COMPATIBILITY IDEOGRAPH-FA27) */
    {(lxb_char_t *) "\xe9\x8b\x95", 3, 0x92D5}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xa0", 3, 0x92E0}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\x93", 3, 0x92D3}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa5", 3, 0x9325}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\xa1", 3, 0x9321}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xbb", 3, 0x92FB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xa8", 3, 0xFA28}, /* (CJK COMPATIBILITY IDEOGRAPH-FA28) */
    {(lxb_char_t *) "\xe9\x8c\x9e", 3, 0x931E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8b\xbf", 3, 0x92FF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x9d", 3, 0x931D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8c\x82", 3, 0x9302}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\xb0", 3, 0x9370}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8d\x97", 3, 0x9357}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8e\xa4", 3, 0x93A4}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x86", 3, 0x93C6}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\x9e", 3, 0x93DE}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x8f\xb8", 3, 0x93F8}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x90\xb1", 3, 0x9431}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x85", 3, 0x9445}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x91\x88", 3, 0x9448}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x96\x92", 3, 0x9592}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa7\x9c", 3, 0xF9DC}, /* (CJK COMPATIBILITY IDEOGRAPH-F9DC) */
    {(lxb_char_t *) "\xef\xa8\xa9", 3, 0xFA29}, /* (CJK COMPATIBILITY IDEOGRAPH-FA29) */
    {(lxb_char_t *) "\xe9\x9a\x9d", 3, 0x969D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9a\xaf", 3, 0x96AF}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xb3", 3, 0x9733}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9c\xbb", 3, 0x973B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x83", 3, 0x9743}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x8d", 3, 0x974D}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x8f", 3, 0x974F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x91", 3, 0x9751}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\x9d\x95", 3, 0x9755}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\x97", 3, 0x9857}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa1\xa5", 3, 0x9865}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xaa", 3, 0xFA2A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2A) */
    {(lxb_char_t *) "\xef\xa8\xab", 3, 0xFA2B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2B) */
    {(lxb_char_t *) "\xe9\xa4\xa7", 3, 0x9927}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xac", 3, 0xFA2C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2C) */
    {(lxb_char_t *) "\xe9\xa6\x9e", 3, 0x999E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xa9\x8e", 3, 0x9A4E}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x99", 3, 0x9AD9}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xab\x9c", 3, 0x9ADC}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\xb5", 3, 0x9B75}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xad\xb2", 3, 0x9B72}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\x8f", 3, 0x9B8F}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xb1", 3, 0x9BB1}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xae\xbb", 3, 0x9BBB}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb0\x80", 3, 0x9C00}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xb0", 3, 0x9D70}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xb5\xab", 3, 0x9D6B}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xef\xa8\xad", 3, 0xFA2D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2D) */
    {(lxb_char_t *) "\xe9\xb8\x99", 3, 0x9E19}, /* (<CJK Ideograph>) */
    {(lxb_char_t *) "\xe9\xbb\x91", 3, 0x9ED1}, /* (<CJK Ideograph>) */
};

/* Table size: 9253; Max deep: 4 */
LXB_API const lexbor_shs_hash_t lxb_encoding_multi_hash_jis0208[11349] = 
{
    {0, NULL, 0},{27759, (void *) 8427, 11144},
    {27760, (void *) 3134, 0},
    {0, NULL, 0},
    {27762, (void *) 1945, 0},
    {27763, (void *) 5721, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27770, (void *) 2139, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27773, (void *) 1884, 0},
    {37027, (void *) 3542, 9933},
    {0, NULL, 0},
    {0, NULL, 0},
    {37030, (void *) 3961, 9932},
    {27778, (void *) 5714, 0},
    {27779, (void *) 4199, 10506},
    {0, NULL, 0},
    {37034, (void *) 2594, 0},
    {27782, (void *) 8426, 11143},
    {0, NULL, 0},
    {27784, (void *) 3321, 0},
    {0, NULL, 0},
    {37039, (void *) 7261, 0},
    {0, NULL, 0},
    {27788, (void *) 3534, 10507},
    {27789, (void *) 5715, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27792, (void *) 5723, 10508},
    {0, NULL, 0},
    {27794, (void *) 5722, 0},
    {27795, (void *) 2070, 9489},
    {0, NULL, 0},
    {0, NULL, 0},
    {27798, (void *) 1610, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27801, (void *) 2376, 0},
    {27802, (void *) 5716, 0},
    {27803, (void *) 5718, 0},
    {37057, (void *) 1483, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27809, (void *) 4002, 0},
    {27810, (void *) 3185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37066, (void *) 2312, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37070, (void *) 4349, 0},
    {9312, (void *) 1128, 0},
    {9313, (void *) 1129, 9603},
    {9314, (void *) 1130, 0},
    {9315, (void *) 1131, 0},
    {9316, (void *) 1132, 9935},
    {9317, (void *) 1133, 0},
    {9318, (void *) 1134, 0},
    {9319, (void *) 1135, 9936},
    {9320, (void *) 1136, 0},
    {9321, (void *) 1137, 9285},
    {9322, (void *) 1138, 0},
    {9323, (void *) 1139, 0},
    {9324, (void *) 1140, 10511},
    {9325, (void *) 1141, 0},
    {9326, (void *) 1142, 9572},
    {9327, (void *) 1143, 9632},
    {9328, (void *) 1144, 9937},
    {9329, (void *) 1145, 9371},
    {9330, (void *) 1146, 9324},
    {9331, (void *) 1147, 9934},
    {27838, (void *) 5733, 0},
    {27839, (void *) 1575, 10510},
    {0, NULL, 0},
    {27841, (void *) 1996, 0},
    {0, NULL, 0},
    {37096, (void *) 3843, 0},
    {27844, (void *) 5724, 0},
    {27845, (void *) 5729, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37101, (void *) 1743, 0},
    {27849, (void *) 2997, 0},
    {27850, (void *) 3652, 0},
    {0, NULL, 0},
    {27852, (void *) 3736, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37109, (void *) 4160, 0},
    {0, NULL, 0},
    {37111, (void *) 2004, 0},
    {27859, (void *) 5726, 0},
    {0, NULL, 0},
    {27861, (void *) 3948, 0},
    {0, NULL, 0},
    {27863, (void *) 5728, 0},
    {37117, (void *) 3435, 0},
    {27865, (void *) 5737, 0},
    {27866, (void *) 8428, 11145},
    {27867, (void *) 5735, 0},
    {0, NULL, 0},
    {27869, (void *) 5730, 10512},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27873, (void *) 3949, 0},
    {27874, (void *) 3611, 0},
    {27875, (void *) 1946, 0},
    {0, NULL, 0},
    {27877, (void *) 3388, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27880, (void *) 3272, 0},
    {0, NULL, 0},
    {27882, (void *) 5738, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37138, (void *) 7269, 0},
    {0, NULL, 0},
    {27887, (void *) 5736, 0},
    {27888, (void *) 3158, 10906},
    {27889, (void *) 5725, 0},
    {0, NULL, 0},
    {27891, (void *) 1546, 0},
    {37145, (void *) 7270, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37159, (void *) 8552, 11269},
    {0, NULL, 0},
    {27908, (void *) 8429, 11146},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37165, (void *) 3385, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27915, (void *) 4181, 10513},
    {27916, (void *) 5749, 0},
    {37170, (void *) 7271, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27922, (void *) 5748, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 87, 0},
    {168, (void *) 14, 9439},
    {0, NULL, 0},
    {27929, (void *) 5745, 0},
    {0, NULL, 0},
    {27931, (void *) 4211, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27934, (void *) 3499, 0},
    {176, (void *) 74, 9938},
    {177, (void *) 61, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {180, (void *) 12, 0},
    {37193, (void *) 3528, 0},
    {182, (void *) 182, 9480},
    {37195, (void *) 2653, 0},
    {37196, (void *) 2601, 0},
    {37197, (void *) 3630, 0},
    {27945, (void *) 1547, 9471},
    {27946, (void *) 2286, 0},
    {27947, (void *) 5742, 0},
    {0, NULL, 0},
    {37202, (void *) 2619, 0},
    {0, NULL, 0},
    {37204, (void *) 2895, 0},
    {0, NULL, 0},
    {37206, (void *) 7274, 0},
    {27954, (void *) 2638, 0},
    {27955, (void *) 5747, 10515},
    {0, NULL, 0},
    {27957, (void *) 5746, 0},
    {27958, (void *) 5741, 0},
    {0, NULL, 0},
    {27960, (void *) 5744, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27963, (void *) 1763, 0},
    {0, NULL, 0},
    {37218, (void *) 2880, 9940},
    {27966, (void *) 3612, 10516},
    {0, NULL, 0},
    {37221, (void *) 7277, 0},
    {27969, (void *) 4243, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {27972, (void *) 2809, 10517},
    {27973, (void *) 2998, 9647},
    {215, (void *) 62, 0},
    {37228, (void *) 2654, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9472, (void *) 658, 0},
    {9473, (void *) 669, 0},
    {9474, (void *) 659, 0},
    {9475, (void *) 670, 10518},
    {37235, (void *) 7279, 0},
    {0, NULL, 0},
    {37237, (void *) 2313, 0},
    {0, NULL, 0},
    {37239, (void *) 2338, 0},
    {37240, (void *) 2475, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9484, (void *) 660, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9487, (void *) 671, 9944},
    {9488, (void *) 661, 9942},
    {0, NULL, 0},
    {27996, (void *) 3804, 0},
    {9491, (void *) 672, 10521},
    {9492, (void *) 663, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9495, (void *) 674, 0},
    {9496, (void *) 662, 9396},
    {28003, (void *) 5750, 0},
    {28004, (void *) 5752, 10520},
    {9499, (void *) 673, 0},
    {247, (void *) 63, 9259},
    {9501, (void *) 685, 0},
    {37261, (void *) 3174, 0},
    {28009, (void *) 2287, 0},
    {9504, (void *) 680, 9674},
    {37264, (void *) 2240, 0},
    {28012, (void *) 1720, 0},
    {9507, (void *) 675, 9429},
    {9508, (void *) 666, 9565},
    {9509, (void *) 687, 10853},
    {0, NULL, 0},
    {0, NULL, 0},
    {9512, (void *) 682, 9533},
    {0, NULL, 0},
    {28020, (void *) 4200, 0},
    {9515, (void *) 677, 0},
    {9516, (void *) 665, 0},
    {28023, (void *) 1695, 9391},
    {28024, (void *) 2846, 0},
    {9519, (void *) 681, 9943},
    {9520, (void *) 686, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9523, (void *) 676, 10522},
    {9524, (void *) 667, 0},
    {37284, (void *) 2788, 0},
    {0, NULL, 0},
    {9527, (void *) 683, 0},
    {9528, (void *) 688, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9531, (void *) 678, 9946},
    {9532, (void *) 668, 10523},
    {28039, (void *) 8430, 11147},
    {28040, (void *) 2760, 0},
    {9535, (void *) 684, 0},
    {37295, (void *) 7286, 0},
    {0, NULL, 0},
    {9538, (void *) 689, 9635},
    {0, NULL, 0},
    {28046, (void *) 5756, 0},
    {37300, (void *) 7289, 0},
    {37301, (void *) 7288, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37304, (void *) 2815, 9941},
    {0, NULL, 0},
    {9547, (void *) 679, 9945},
    {28054, (void *) 8432, 11149},
    {0, NULL, 0},
    {0, NULL, 0},
    {28057, (void *) 4291, 0},
    {0, NULL, 0},
    {28059, (void *) 3466, 10526},
    {28060, (void *) 3511, 10527},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37318, (void *) 3713, 0},
    {37319, (void *) 2400, 0},
    {37320, (void *) 2602, 0},
    {37321, (void *) 7293, 0},
    {0, NULL, 0},
    {37323, (void *) 7294, 0},
    {37324, (void *) 4233, 0},
    {37325, (void *) 2668, 0},
    {37326, (void *) 4119, 0},
    {37327, (void *) 4273, 0},
    {37328, (void *) 7295, 0},
    {37329, (void *) 2039, 10854},
    {0, NULL, 0},
    {0, NULL, 0},
    {28079, (void *) 1713, 0},
    {0, NULL, 0},
    {37334, (void *) 7296, 0},
    {28082, (void *) 1556, 10908},
    {37336, (void *) 3386, 0},
    {0, NULL, 0},
    {28085, (void *) 5763, 10907},
    {37339, (void *) 7299, 0},
    {37340, (void *) 1779, 0},
    {37341, (void *) 2862, 9948},
    {37342, (void *) 8555, 11272},
    {37343, (void *) 7297, 0},
    {0, NULL, 0},
    {28092, (void *) 4264, 10528},
    {0, NULL, 0},
    {37347, (void *) 3353, 0},
    {37348, (void *) 8558, 11275},
    {28096, (void *) 4203, 10909},
    {37350, (void *) 4000, 0},
    {37351, (void *) 2065, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28101, (void *) 5773, 0},
    {28102, (void *) 5767, 0},
    {28103, (void *) 5764, 0},
    {37357, (void *) 8556, 11273},
    {37358, (void *) 8557, 11274},
    {0, NULL, 0},
    {28107, (void *) 4281, 0},
    {28108, (void *) 5770, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28111, (void *) 8434, 11151},
    {37365, (void *) 7301, 0},
    {28113, (void *) 2673, 10529},
    {28114, (void *) 5772, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28117, (void *) 5777, 0},
    {0, NULL, 0},
    {37372, (void *) 7300, 0},
    {28120, (void *) 3464, 0},
    {28121, (void *) 5775, 0},
    {37375, (void *) 7304, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28126, (void *) 5769, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28129, (void *) 3219, 10910},
    {0, NULL, 0},
    {0, NULL, 0},
    {28132, (void *) 5776, 0},
    {37386, (void *) 8562, 11279},
    {28134, (void *) 5765, 0},
    {0, NULL, 0},
    {37389, (void *) 3540, 9949},
    {37390, (void *) 1726, 0},
    {9632, (void *) 96, 9950},
    {9633, (void *) 95, 9275},
    {28140, (void *) 5768, 10532},
    {0, NULL, 0},
    {28142, (void *) 5779, 0},
    {37396, (void *) 7305, 0},
    {37397, (void *) 7307, 0},
    {28145, (void *) 2847, 0},
    {28146, (void *) 8436, 11153},
    {28147, (void *) 2694, 0},
    {0, NULL, 0},
    {28149, (void *) 3858, 0},
    {0, NULL, 0},
    {28151, (void *) 2363, 0},
    {28152, (void *) 8435, 11152},
    {28153, (void *) 5760, 10530},
    {28154, (void *) 5774, 0},
    {28155, (void *) 3409, 0},
    {9650, (void *) 98, 10855},
    {9651, (void *) 97, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37417, (void *) 7378, 0},
    {28165, (void *) 2935, 0},
    {9660, (void *) 100, 0},
    {9661, (void *) 99, 9297},
    {28168, (void *) 2398, 0},
    {28169, (void *) 2761, 0},
    {28170, (void *) 5762, 0},
    {28171, (void *) 2665, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37428, (void *) 4304, 0},
    {9670, (void *) 94, 0},
    {9671, (void *) 93, 0},
    {37431, (void *) 2219, 0},
    {28179, (void *) 2111, 0},
    {37433, (void *) 8569, 11286},
    {9675, (void *) 90, 9947},
    {0, NULL, 0},
    {37436, (void *) 8565, 11282},
    {9678, (void *) 92, 0},
    {9679, (void *) 91, 9951},
    {28186, (void *) 2708, 10538},
    {28187, (void *) 2187, 10913},
    {0, NULL, 0},
    {28189, (void *) 5798, 0},
    {0, NULL, 0},
    {37444, (void *) 3403, 9954},
    {28192, (void *) 1963, 10534},
    {28193, (void *) 3430, 0},
    {0, NULL, 0},
    {28195, (void *) 5787, 10536},
    {28196, (void *) 5796, 10535},
    {28197, (void *) 1424, 0},
    {28198, (void *) 1521, 10539},
    {28199, (void *) 8440, 11157},
    {0, NULL, 0},
    {28201, (void *) 1622, 10914},
    {0, NULL, 0},
    {28203, (void *) 5789, 10540},
    {28204, (void *) 3113, 10915},
    {28205, (void *) 5780, 0},
    {28206, (void *) 5782, 0},
    {28207, (void *) 2288, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37463, (void *) 7310, 0},
    {0, NULL, 0},
    {37465, (void *) 8567, 11284},
    {37466, (void *) 7323, 0},
    {37467, (void *) 1587, 0},
    {0, NULL, 0},
    {28216, (void *) 5799, 0},
    {9711, (void *) 187, 10533},
    {28218, (void *) 5794, 0},
    {0, NULL, 0},
    {28220, (void *) 8441, 11158},
    {37474, (void *) 3678, 0},
    {28222, (void *) 5786, 0},
    {37476, (void *) 7313, 0},
    {0, NULL, 0},
    {37478, (void *) 2789, 0},
    {37479, (void *) 8570, 11287},
    {28227, (void *) 5793, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28234, (void *) 4052, 0},
    {0, NULL, 0},
    {37489, (void *) 2314, 0},
    {28237, (void *) 5791, 0},
    {28238, (void *) 5795, 0},
    {9733, (void *) 89, 0},
    {9734, (void *) 88, 0},
    {0, NULL, 0},
    {37495, (void *) 8572, 11289},
    {37496, (void *) 8573, 11290},
    {0, NULL, 0},
    {0, NULL, 0},
    {28246, (void *) 2209, 0},
    {0, NULL, 0},
    {28248, (void *) 2762, 0},
    {37502, (void *) 3987, 0},
    {0, NULL, 0},
    {37504, (void *) 2041, 9461},
    {28252, (void *) 8439, 11156},
    {0, NULL, 0},
    {37507, (void *) 2669, 0},
    {28255, (void *) 5785, 0},
    {37509, (void *) 3505, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37512, (void *) 8275, 10992},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28263, (void *) 4150, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28267, (void *) 5788, 0},
    {37521, (void *) 3020, 0},
    {65281, (void *) 9, 0},
    {28270, (void *) 5781, 10543},
    {65283, (void *) 83, 9499},
    {65284, (void *) 79, 10537},
    {65285, (void *) 82, 10542},
    {65286, (void *) 84, 9952},
    {37528, (void *) 4076, 10959},
    {65288, (void *) 41, 0},
    {65289, (void *) 42, 9478},
    {65290, (void *) 85, 9953},
    {65291, (void *) 59, 10541},
    {65292, (void *) 3, 0},
    {65293, (void *) 60, 0},
    {65294, (void *) 4, 0},
    {65295, (void *) 30, 0},
    {65296, (void *) 203, 0},
    {65297, (void *) 204, 0},
    {65298, (void *) 205, 9678},
    {65299, (void *) 206, 9378},
    {65300, (void *) 207, 9604},
    {65301, (void *) 208, 0},
    {65302, (void *) 209, 9955},
    {65303, (void *) 210, 0},
    {65304, (void *) 211, 0},
    {65305, (void *) 212, 0},
    {65306, (void *) 6, 0},
    {65307, (void *) 7, 0},
    {65308, (void *) 66, 9441},
    {65309, (void *) 64, 0},
    {65310, (void *) 67, 9254},
    {65311, (void *) 8, 0},
    {9794, (void *) 72, 9255},
    {65313, (void *) 220, 0},
    {65314, (void *) 221, 0},
    {65315, (void *) 222, 9965},
    {65316, (void *) 223, 9330},
    {65317, (void *) 224, 0},
    {65318, (void *) 225, 10547},
    {65319, (void *) 226, 0},
    {65320, (void *) 227, 10546},
    {65321, (void *) 228, 0},
    {65322, (void *) 229, 9394},
    {65323, (void *) 230, 0},
    {65324, (void *) 231, 9957},
    {65325, (void *) 232, 0},
    {65326, (void *) 233, 0},
    {65327, (void *) 234, 0},
    {65328, (void *) 235, 9654},
    {65329, (void *) 236, 9340},
    {65330, (void *) 237, 0},
    {65331, (void *) 238, 9968},
    {65332, (void *) 239, 0},
    {65333, (void *) 240, 0},
    {65334, (void *) 241, 9273},
    {65335, (void *) 242, 0},
    {65336, (void *) 243, 0},
    {65337, (void *) 244, 9966},
    {65338, (void *) 245, 0},
    {65339, (void *) 45, 0},
    {65340, (void *) 31, 0},
    {65341, (void *) 46, 0},
    {65342, (void *) 15, 9956},
    {65343, (void *) 17, 10920},
    {65344, (void *) 13, 0},
    {65345, (void *) 252, 9586},
    {65346, (void *) 253, 10923},
    {65347, (void *) 254, 9962},
    {65348, (void *) 255, 10921},
    {65349, (void *) 256, 0},
    {65350, (void *) 257, 9964},
    {65351, (void *) 258, 0},
    {9834, (void *) 179, 9256},
    {65353, (void *) 260, 0},
    {65354, (void *) 261, 9642},
    {9837, (void *) 178, 9257},
    {65356, (void *) 263, 0},
    {9839, (void *) 177, 9258},
    {65358, (void *) 265, 9491},
    {65359, (void *) 266, 10922},
    {65360, (void *) 267, 0},
    {65361, (void *) 268, 9961},
    {65362, (void *) 269, 0},
    {65363, (void *) 270, 9399},
    {65364, (void *) 271, 0},
    {65365, (void *) 272, 0},
    {65366, (void *) 273, 9967},
    {65367, (void *) 274, 0},
    {65368, (void *) 275, 9963},
    {65369, (void *) 276, 9581},
    {65370, (void *) 277, 0},
    {65371, (void *) 47, 0},
    {65372, (void *) 34, 9280},
    {65373, (void *) 48, 9958},
    {65374, (void *) 32, 0},
    {28363, (void *) 2539, 0},
    {28364, (void *) 5827, 0},
    {37618, (void *) 3797, 0},
    {37619, (void *) 3277, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28369, (void *) 1765, 0},
    {0, NULL, 0},
    {37624, (void *) 1967, 9960},
    {28372, (void *) 5810, 10802},
    {28373, (void *) 5811, 10549},
    {37627, (void *) 8584, 11301},
    {37628, (void *) 2316, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37631, (void *) 8587, 11304},
    {0, NULL, 0},
    {0, NULL, 0},
    {28381, (void *) 3177, 10926},
    {28382, (void *) 3159, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37638, (void *) 2455, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37647, (void *) 7328, 0},
    {37648, (void *) 2896, 0},
    {28396, (void *) 5819, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28399, (void *) 5825, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28402, (void *) 5823, 0},
    {37656, (void *) 2897, 0},
    {28404, (void *) 3392, 10551},
    {37658, (void *) 7334, 0},
    {0, NULL, 0},
    {28407, (void *) 5830, 0},
    {28408, (void *) 5820, 10925},
    {37662, (void *) 8586, 11303},
    {0, NULL, 0},
    {37664, (void *) 2816, 0},
    {37665, (void *) 8583, 11300},
    {37666, (void *) 7333, 0},
    {28414, (void *) 5821, 10552},
    {28415, (void *) 5797, 0},
    {37669, (void *) 8582, 11299},
    {28417, (void *) 1968, 9319},
    {28418, (void *) 3785, 0},
    {37672, (void *) 3796, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28422, (void *) 2568, 9383},
    {37676, (void *) 4326, 0},
    {0, NULL, 0},
    {28425, (void *) 2342, 10550},
    {37679, (void *) 2437, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37682, (void *) 4354, 0},
    {0, NULL, 0},
    {28431, (void *) 4342, 0},
    {37685, (void *) 7337, 0},
    {28433, (void *) 5817, 0},
    {0, NULL, 0},
    {28435, (void *) 5829, 0},
    {28436, (void *) 1576, 0},
    {28437, (void *) 3077, 10553},
    {37691, (void *) 7338, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37700, (void *) 7330, 0},
    {28448, (void *) 3660, 0},
    {0, NULL, 0},
    {28450, (void *) 1818, 0},
    {28451, (void *) 4319, 10798},
    {0, NULL, 0},
    {0, NULL, 0},
    {37707, (void *) 3550, 0},
    {0, NULL, 0},
    {37709, (void *) 3436, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28459, (void *) 4042, 0},
    {28460, (void *) 3339, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37716, (void *) 3344, 0},
    {0, NULL, 0},
    {28465, (void *) 5824, 10554},
    {28466, (void *) 5826, 10927},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37723, (void *) 3230, 0},
    {37724, (void *) 7339, 0},
    {28472, (void *) 3025, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37728, (void *) 7340, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28478, (void *) 5828, 0},
    {28479, (void *) 5822, 0},
    {0, NULL, 0},
    {28481, (void *) 5816, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28485, (void *) 1820, 0},
    {0, NULL, 0},
    {37740, (void *) 2080, 0},
    {0, NULL, 0},
    {37742, (void *) 7342, 0},
    {0, NULL, 0},
    {37744, (void *) 8590, 11307},
    {65504, (void *) 80, 0},
    {65505, (void *) 81, 0},
    {65506, (void *) 137, 10957},
    {65507, (void *) 16, 0},
    {37749, (void *) 2177, 10958},
    {65509, (void *) 78, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28500, (void *) 2140, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37756, (void *) 7341, 0},
    {28504, (void *) 5842, 0},
    {37758, (void *) 2790, 0},
    {0, NULL, 0},
    {28507, (void *) 5837, 0},
    {28508, (void *) 3001, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28511, (void *) 1758, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28516, (void *) 2696, 0},
    {0, NULL, 0},
    {28518, (void *) 5846, 0},
    {37772, (void *) 1780, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28525, (void *) 5839, 0},
    {28526, (void *) 3301, 0},
    {28527, (void *) 5836, 10555},
    {28528, (void *) 3346, 0},
    {37782, (void *) 2380, 0},
    {37783, (void *) 3096, 0},
    {0, NULL, 0},
    {28532, (void *) 5871, 0},
    {37786, (void *) 3331, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28536, (void *) 5833, 0},
    {0, NULL, 0},
    {28538, (void *) 5832, 0},
    {0, NULL, 0},
    {28540, (void *) 5841, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37796, (void *) 8592, 11309},
    {28544, (void *) 5835, 0},
    {28545, (void *) 5834, 0},
    {37799, (void *) 1718, 9970},
    {0, NULL, 0},
    {28548, (void *) 2914, 0},
    {0, NULL, 0},
    {28550, (void *) 5831, 0},
    {37804, (void *) 7345, 0},
    {37805, (void *) 7346, 10858},
    {37806, (void *) 3324, 0},
    {0, NULL, 0},
    {37808, (void *) 7344, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28558, (void *) 5843, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28561, (void *) 5844, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37817, (void *) 7348, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28567, (void *) 1819, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37827, (void *) 7354, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28577, (void *) 5849, 10928},
    {0, NULL, 0},
    {28579, (void *) 5848, 10560},
    {28580, (void *) 5850, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28586, (void *) 5853, 0},
    {37840, (void *) 7356, 0},
    {37841, (void *) 3396, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28593, (void *) 3418, 10556},
    {37847, (void *) 7350, 0},
    {28595, (void *) 5847, 10559},
    {0, NULL, 0},
    {28597, (void *) 8444, 11161},
    {0, NULL, 0},
    {0, NULL, 0},
    {37853, (void *) 7355, 0},
    {28601, (void *) 5851, 10929},
    {0, NULL, 0},
    {0, NULL, 0},
    {37857, (void *) 2005, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37860, (void *) 7358, 0},
    {28608, (void *) 2134, 10558},
    {28609, (void *) 3190, 0},
    {28610, (void *) 5845, 0},
    {28611, (void *) 3598, 10557},
    {0, NULL, 0},
    {0, NULL, 0},
    {28614, (void *) 5852, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37880, (void *) 8595, 11312},
    {28628, (void *) 5857, 0},
    {28629, (void *) 5855, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28632, (void *) 5858, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28635, (void *) 5861, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37891, (void *) 7362, 0},
    {28639, (void *) 5854, 0},
    {28640, (void *) 2329, 0},
    {28641, (void *) 3579, 0},
    {37895, (void *) 7363, 0},
    {0, NULL, 0},
    {28644, (void *) 5758, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28651, (void *) 4219, 10563},
    {28652, (void *) 5856, 0},
    {0, NULL, 0},
    {28654, (void *) 5860, 10562},
    {28655, (void *) 3186, 10561},
    {0, NULL, 0},
    {28657, (void *) 5859, 0},
    {0, NULL, 0},
    {37912, (void *) 2791, 9969},
    {37913, (void *) 3487, 0},
    {37914, (void *) 7359, 10859},
    {28662, (void *) 7404, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28666, (void *) 5864, 0},
    {0, NULL, 0},
    {37921, (void *) 7368, 0},
    {0, NULL, 0},
    {28670, (void *) 5868, 0},
    {0, NULL, 0},
    {913, (void *) 470, 0},
    {914, (void *) 471, 9973},
    {915, (void *) 472, 0},
    {916, (void *) 473, 0},
    {917, (void *) 474, 0},
    {918, (void *) 475, 10860},
    {919, (void *) 476, 10565},
    {920, (void *) 477, 10861},
    {921, (void *) 478, 0},
    {922, (void *) 479, 9971},
    {923, (void *) 480, 0},
    {924, (void *) 481, 9972},
    {925, (void *) 482, 10930},
    {926, (void *) 483, 0},
    {927, (void *) 484, 0},
    {928, (void *) 485, 9974},
    {929, (void *) 486, 10566},
    {28689, (void *) 5865, 10564},
    {931, (void *) 487, 0},
    {932, (void *) 488, 9456},
    {933, (void *) 489, 0},
    {934, (void *) 490, 9560},
    {935, (void *) 491, 0},
    {936, (void *) 492, 0},
    {937, (void *) 493, 9975},
    {0, NULL, 0},
    {28698, (void *) 5870, 0},
    {28699, (void *) 5869, 0},
    {37953, (void *) 7370, 0},
    {28701, (void *) 5872, 0},
    {28702, (void *) 3529, 0},
    {28703, (void *) 5874, 10569},
    {945, (void *) 502, 10931},
    {946, (void *) 503, 0},
    {947, (void *) 504, 0},
    {948, (void *) 505, 10932},
    {949, (void *) 506, 0},
    {950, (void *) 507, 0},
    {951, (void *) 508, 9473},
    {952, (void *) 509, 9455},
    {953, (void *) 510, 10862},
    {954, (void *) 511, 0},
    {955, (void *) 512, 0},
    {956, (void *) 513, 0},
    {957, (void *) 514, 9303},
    {958, (void *) 515, 10568},
    {959, (void *) 516, 9630},
    {960, (void *) 517, 0},
    {961, (void *) 518, 9976},
    {0, NULL, 0},
    {963, (void *) 519, 9977},
    {964, (void *) 520, 0},
    {965, (void *) 521, 0},
    {966, (void *) 522, 10572},
    {967, (void *) 523, 10570},
    {968, (void *) 524, 0},
    {969, (void *) 525, 0},
    {37982, (void *) 7376, 0},
    {0, NULL, 0},
    {37984, (void *) 7374, 0},
    {0, NULL, 0},
    {37986, (void *) 7375, 0},
    {28734, (void *) 5876, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {37994, (void *) 7377, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38000, (void *) 7379, 0},
    {28748, (void *) 5818, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38005, (void *) 7380, 0},
    {28753, (void *) 5878, 0},
    {38007, (void *) 7381, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38012, (void *) 7384, 0},
    {28760, (void *) 3548, 10571},
    {38014, (void *) 7385, 0},
    {38015, (void *) 7387, 0},
    {0, NULL, 0},
    {38017, (void *) 7386, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28771, (void *) 5879, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28779, (void *) 1645, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28783, (void *) 3467, 0},
    {1025, (void *) 570, 9289},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28792, (void *) 1947, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28796, (void *) 2599, 0},
    {28797, (void *) 2399, 0},
    {0, NULL, 0},
    {1040, (void *) 564, 0},
    {1041, (void *) 565, 0},
    {1042, (void *) 566, 0},
    {1043, (void *) 567, 0},
    {1044, (void *) 568, 0},
    {1045, (void *) 569, 0},
    {1046, (void *) 571, 10863},
    {1047, (void *) 572, 0},
    {1048, (void *) 573, 0},
    {1049, (void *) 574, 0},
    {1050, (void *) 575, 9673},
    {1051, (void *) 576, 9421},
    {1052, (void *) 577, 0},
    {1053, (void *) 578, 0},
    {1054, (void *) 579, 0},
    {1055, (void *) 580, 9282},
    {1056, (void *) 581, 0},
    {1057, (void *) 582, 0},
    {1058, (void *) 583, 0},
    {1059, (void *) 584, 9979},
    {1060, (void *) 585, 0},
    {1061, (void *) 586, 0},
    {1062, (void *) 587, 0},
    {1063, (void *) 588, 0},
    {1064, (void *) 589, 0},
    {1065, (void *) 590, 0},
    {1066, (void *) 591, 9978},
    {1067, (void *) 592, 0},
    {1068, (void *) 593, 0},
    {1069, (void *) 594, 0},
    {1070, (void *) 595, 0},
    {1071, (void *) 596, 0},
    {1072, (void *) 612, 0},
    {1073, (void *) 613, 0},
    {1074, (void *) 614, 0},
    {1075, (void *) 615, 0},
    {1076, (void *) 616, 0},
    {1077, (void *) 617, 0},
    {1078, (void *) 619, 0},
    {1079, (void *) 620, 0},
    {1080, (void *) 621, 0},
    {1081, (void *) 622, 0},
    {1082, (void *) 623, 0},
    {1083, (void *) 624, 0},
    {1084, (void *) 625, 10864},
    {1085, (void *) 626, 9981},
    {1086, (void *) 627, 9462},
    {1087, (void *) 628, 9984},
    {1088, (void *) 629, 9980},
    {1089, (void *) 630, 0},
    {1090, (void *) 631, 0},
    {1091, (void *) 632, 0},
    {1092, (void *) 633, 9983},
    {1093, (void *) 634, 0},
    {1094, (void *) 635, 0},
    {1095, (void *) 636, 0},
    {1096, (void *) 637, 0},
    {1097, (void *) 638, 9982},
    {1098, (void *) 639, 9494},
    {1099, (void *) 640, 9271},
    {1100, (void *) 641, 10800},
    {1101, (void *) 642, 0},
    {1102, (void *) 643, 0},
    {1103, (void *) 644, 0},
    {0, NULL, 0},
    {1105, (void *) 618, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28872, (void *) 4314, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28875, (void *) 5889, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28879, (void *) 1511, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28889, (void *) 5891, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28893, (void *) 5890, 0},
    {0, NULL, 0},
    {28895, (void *) 5888, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28913, (void *) 5883, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28921, (void *) 3950, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28925, (void *) 5893, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28932, (void *) 8452, 11169},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28937, (void *) 5892, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28943, (void *) 8451, 11168},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28948, (void *) 1578, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28953, (void *) 5895, 0},
    {28954, (void *) 3871, 0},
    {0, NULL, 0},
    {28956, (void *) 5894, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28961, (void *) 4062, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28966, (void *) 2764, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28982, (void *) 3026, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28988, (void *) 2763, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {28998, (void *) 8454, 11171},
    {28999, (void *) 8455, 11172},
    {0, NULL, 0},
    {29001, (void *) 4320, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29004, (void *) 5901, 0},
    {0, NULL, 0},
    {29006, (void *) 3002, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38263, (void *) 3314, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29013, (void *) 5897, 0},
    {29014, (void *) 5902, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29017, (void *) 1579, 0},
    {0, NULL, 0},
    {38272, (void *) 4112, 0},
    {29020, (void *) 8453, 11170},
    {38274, (void *) 7388, 0},
    {38275, (void *) 3021, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29026, (void *) 5900, 10573},
    {0, NULL, 0},
    {29028, (void *) 3636, 9577},
    {29029, (void *) 5896, 10574},
    {38283, (void *) 1702, 9985},
    {29031, (void *) 2765, 0},
    {0, NULL, 0},
    {29033, (void *) 3714, 0},
    {38287, (void *) 1531, 0},
    {0, NULL, 0},
    {38289, (void *) 1840, 9986},
    {38290, (void *) 8599, 11316},
    {38291, (void *) 1839, 9381},
    {38292, (void *) 7391, 0},
    {0, NULL, 0},
    {38294, (void *) 7392, 0},
    {0, NULL, 0},
    {38296, (void *) 7393, 0},
    {38297, (void *) 7394, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38304, (void *) 7395, 0},
    {0, NULL, 0},
    {38306, (void *) 1841, 9440},
    {38307, (void *) 1744, 0},
    {38308, (void *) 2317, 0},
    {38309, (void *) 3687, 0},
    {0, NULL, 0},
    {38311, (void *) 7397, 0},
    {38312, (void *) 7396, 0},
    {29060, (void *) 5906, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29064, (void *) 5898, 10575},
    {0, NULL, 0},
    {29066, (void *) 2074, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38322, (void *) 1563, 0},
    {0, NULL, 0},
    {29071, (void *) 5904, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29076, (void *) 4183, 10576},
    {29077, (void *) 5907, 0},
    {38331, (void *) 7400, 0},
    {38332, (void *) 7399, 0},
    {0, NULL, 0},
    {38334, (void *) 7402, 10797},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38339, (void *) 7405, 0},
    {29087, (void *) 2678, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38343, (void *) 1448, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38346, (void *) 7403, 0},
    {0, NULL, 0},
    {38348, (void *) 7407, 0},
    {29096, (void *) 5908, 10577},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29100, (void *) 5909, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38356, (void *) 7409, 0},
    {38357, (void *) 7408, 0},
    {29105, (void *) 3585, 10578},
    {0, NULL, 0},
    {38360, (void *) 3491, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38364, (void *) 7411, 0},
    {0, NULL, 0},
    {29113, (void *) 5911, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38369, (void *) 7412, 0},
    {38370, (void *) 7414, 0},
    {29118, (void *) 5912, 0},
    {0, NULL, 0},
    {38373, (void *) 7413, 0},
    {29121, (void *) 8457, 11174},
    {0, NULL, 0},
    {29123, (void *) 3590, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29128, (void *) 3468, 0},
    {29129, (void *) 5914, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29134, (void *) 5916, 0},
    {0, NULL, 0},
    {29136, (void *) 4282, 0},
    {0, NULL, 0},
    {29138, (void *) 5913, 0},
    {0, NULL, 0},
    {29140, (void *) 5915, 0},
    {29141, (void *) 1580, 0},
    {0, NULL, 0},
    {29143, (void *) 5910, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29151, (void *) 4758, 0},
    {29152, (void *) 5917, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29157, (void *) 3078, 0},
    {29158, (void *) 2467, 0},
    {29159, (void *) 5919, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29164, (void *) 5918, 0},
    {29165, (void *) 2823, 0},
    {29166, (void *) 4662, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29173, (void *) 5920, 0},
    {0, NULL, 0},
    {38428, (void *) 3835, 0},
    {0, NULL, 0},
    {29177, (void *) 5922, 0},
    {0, NULL, 0},
    {29179, (void *) 5905, 0},
    {29180, (void *) 5921, 10579},
    {0, NULL, 0},
    {29182, (void *) 8458, 11175},
    {29183, (void *) 5923, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38440, (void *) 7416, 0},
    {0, NULL, 0},
    {38442, (void *) 2418, 0},
    {29190, (void *) 3661, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38446, (void *) 7417, 0},
    {38447, (void *) 7418, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38450, (void *) 3988, 9987},
    {0, NULL, 0},
    {0, NULL, 0},
    {29200, (void *) 5925, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38459, (void *) 3050, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38463, (void *) 1413, 0},
    {38464, (void *) 3144, 9988},
    {0, NULL, 0},
    {38466, (void *) 7419, 0},
    {0, NULL, 0},
    {38468, (void *) 3836, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {19968, (void *) 1485, 0},
    {19969, (void *) 3285, 10581},
    {38476, (void *) 7420, 0},
    {38477, (void *) 2318, 9376},
    {0, NULL, 0},
    {29226, (void *) 3351, 10580},
    {38480, (void *) 2195, 0},
    {19975, (void *) 4039, 9991},
    {19976, (void *) 2795, 9990},
    {19977, (void *) 2459, 0},
    {19978, (void *) 2794, 0},
    {19979, (void *) 1625, 9992},
    {0, NULL, 0},
    {19981, (void *) 3811, 9993},
    {19982, (void *) 4166, 0},
    {0, NULL, 0},
    {29237, (void *) 2600, 9680},
    {19985, (void *) 1518, 9566},
    {38492, (void *) 7424, 0},
    {38493, (void *) 7426, 0},
    {19988, (void *) 1769, 10583},
    {29242, (void *) 4117, 9681},
    {19990, (void *) 2917, 9994},
    {19991, (void *) 4639, 9995},
    {38498, (void *) 1504, 9311},
    {29246, (void *) 2541, 9419},
    {38500, (void *) 2723, 9996},
    {38501, (void *) 1842, 9997},
    {38502, (void *) 7428, 0},
    {0, NULL, 0},
    {19998, (void *) 2796, 0},
    {0, NULL, 0},
    {38506, (void *) 3641, 0},
    {20001, (void *) 4259, 9998},
    {29255, (void *) 3903, 10585},
    {29256, (void *) 3704, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38512, (void *) 1505, 9576},
    {29260, (void *) 3626, 0},
    {38514, (void *) 7429, 10804},
    {38515, (void *) 3325, 0},
    {20010, (void *) 4421, 0},
    {38517, (void *) 4274, 0},
    {38518, (void *) 3488, 0},
    {20013, (void *) 3265, 9476},
    {38520, (void *) 4235, 0},
    {0, NULL, 0},
    {38522, (void *) 2178, 0},
    {20017, (void *) 4422, 0},
    {20018, (void *) 2063, 0},
    {38525, (void *) 4194, 10000},
    {29273, (void *) 1668, 0},
    {0, NULL, 0},
    {29275, (void *) 1956, 9682},
    {0, NULL, 0},
    {20024, (void *) 1846, 9618},
    {20025, (void *) 3211, 0},
    {29279, (void *) 4063, 0},
    {38533, (void *) 2062, 9384},
    {29281, (void *) 1617, 9656},
    {29282, (void *) 4343, 0},
    {38536, (void *) 2075, 0},
    {20031, (void *) 4425, 0},
    {38538, (void *) 3167, 0},
    {38539, (void *) 6580, 0},
    {29287, (void *) 3997, 9684},
    {20035, (void *) 3592, 10586},
    {38542, (void *) 1703, 9573},
    {20037, (void *) 1934, 9422},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38548, (void *) 1745, 0},
    {20043, (void *) 3594, 10588},
    {0, NULL, 0},
    {29298, (void *) 2936, 9511},
    {20046, (void *) 2196, 10587},
    {38553, (void *) 2135, 9589},
    {0, NULL, 0},
    {38555, (void *) 2410, 0},
    {38556, (void *) 2792, 0},
    {38557, (void *) 8602, 11319},
    {29305, (void *) 3512, 0},
    {20053, (void *) 6808, 0},
    {38560, (void *) 1506, 9685},
    {20055, (void *) 2797, 0},
    {29309, (void *) 2164, 9686},
    {20057, (void *) 1618, 9661},
    {0, NULL, 0},
    {29312, (void *) 2401, 0},
    {29313, (void *) 5942, 0},
    {20061, (void *) 2042, 10003},
    {20062, (void *) 2241, 10503},
    {20063, (void *) 4114, 0},
    {38570, (void *) 7435, 0},
    {0, NULL, 0},
    {20066, (void *) 4987, 10004},
    {0, NULL, 0},
    {0, NULL, 0},
    {38575, (void *) 8603, 11320},
    {38576, (void *) 7439, 0},
    {38577, (void *) 7437, 0},
    {38578, (void *) 7438, 0},
    {0, NULL, 0},
    {38580, (void *) 7440, 0},
    {0, NULL, 0},
    {38582, (void *) 7441, 0},
    {38583, (void *) 4305, 10005},
    {38584, (void *) 7442, 0},
    {38585, (void *) 7443, 0},
    {0, NULL, 0},
    {38587, (void *) 2954, 9648},
    {38588, (void *) 3692, 0},
    {20083, (void *) 3570, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38592, (void *) 2912, 0},
    {38593, (void *) 1856, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38596, (void *) 4161, 0},
    {38597, (void *) 1674, 9308},
    {38598, (void *) 2655, 0},
    {38599, (void *) 2220, 10007},
    {20094, (void *) 1790, 0},
    {38601, (void *) 7446, 0},
    {20096, (void *) 1900, 0},
    {38603, (void *) 7445, 0},
    {38604, (void *) 2526, 9687},
    {38605, (void *) 7447, 0},
    {38606, (void *) 7444, 0},
    {20101, (void *) 4430, 0},
    {20102, (void *) 4256, 0},
    {29356, (void *) 2165, 9362},
    {20104, (void *) 4164, 0},
    {20105, (void *) 3079, 0},
    {29359, (void *) 3705, 9688},
    {20107, (void *) 2529, 10592},
    {20108, (void *) 3560, 10381},
    {29362, (void *) 5949, 0},
    {20110, (void *) 4435, 0},
    {38617, (void *) 4659, 0},
    {0, NULL, 0},
    {20113, (void *) 1533, 9412},
    {20114, (void *) 2224, 10591},
    {0, NULL, 0},
    {20116, (void *) 2223, 10009},
    {20117, (void *) 1479, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38626, (void *) 4234, 9677},
    {38627, (void *) 3558, 9676},
    {0, NULL, 0},
    {20123, (void *) 2368, 0},
    {20124, (void *) 1410, 0},
    {29378, (void *) 1997, 0},
    {38632, (void *) 1514, 9689},
    {20127, (void *) 4437, 10012},
    {38634, (void *) 2980, 9690},
    {38635, (void *) 2559, 9590},
    {20130, (void *) 4439, 0},
    {0, NULL, 0},
    {20132, (void *) 2243, 0},
    {20133, (void *) 1480, 0},
    {38640, (void *) 3876, 9600},
    {0, NULL, 0},
    {38642, (void *) 1535, 9313},
    {29390, (void *) 5953, 0},
    {0, NULL, 0},
    {20139, (void *) 1972, 9333},
    {20140, (void *) 1973, 9666},
    {20141, (void *) 3355, 9646},
    {20142, (void *) 4257, 0},
    {38649, (void *) 7452, 0},
    {20144, (void *) 4440, 0},
    {38651, (void *) 3420, 0},
    {29399, (void *) 2046, 0},
    {20147, (void *) 4441, 0},
    {29401, (void *) 3039, 0},
    {0, NULL, 0},
    {29403, (void *) 2348, 9388},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20154, (void *) 2864, 10593},
    {29408, (void *) 5956, 0},
    {29409, (void *) 5957, 10594},
    {38663, (void *) 2863, 10014},
    {38664, (void *) 7455, 0},
    {0, NULL, 0},
    {20160, (void *) 2657, 9667},
    {20161, (void *) 2865, 0},
    {20162, (void *) 4447, 0},
    {38669, (void *) 7450, 0},
    {29417, (void *) 2614, 9692},
    {38671, (void *) 7459, 0},
    {20166, (void *) 4446, 0},
    {20167, (void *) 1935, 9508},
    {29421, (void *) 1998, 0},
    {38675, (void *) 7456, 0},
    {20170, (void *) 2352, 0},
    {20171, (void *) 1677, 0},
    {38678, (void *) 7460, 0},
    {20173, (void *) 4444, 0},
    {20174, (void *) 4443, 0},
    {20175, (void *) 3862, 10597},
    {0, NULL, 0},
    {0, NULL, 0},
    {38684, (void *) 3097, 10016},
    {29432, (void *) 3207, 0},
    {38686, (void *) 1663, 9368},
    {20181, (void *) 2480, 0},
    {20182, (void *) 3131, 0},
    {29436, (void *) 4344, 9693},
    {29437, (void *) 3637, 9562},
    {20185, (void *) 2984, 0},
    {38692, (void *) 7462, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20189, (void *) 23, 9612},
    {20190, (void *) 4449, 0},
    {20191, (void *) 4451, 0},
    {38698, (void *) 7463, 0},
    {20193, (void *) 8285, 11002},
    {0, NULL, 0},
    {20195, (void *) 3170, 0},
    {20196, (void *) 4294, 0},
    {20197, (void *) 1451, 10019},
    {38704, (void *) 7464, 0},
    {0, NULL, 0},
    {38706, (void *) 4333, 0},
    {38707, (void *) 8604, 11321},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20205, (void *) 4450, 0},
    {20206, (void *) 1627, 9884},
    {38713, (void *) 7465, 0},
    {20208, (void *) 2009, 0},
    {29462, (void *) 5964, 10935},
    {20210, (void *) 3266, 10018},
    {38717, (void *) 7466, 0},
    {38718, (void *) 7467, 0},
    {0, NULL, 0},
    {20214, (void *) 2146, 9621},
    {20215, (void *) 4452, 10020},
    {29469, (void *) 5965, 10599},
    {38723, (void *) 8606, 11323},
    {29471, (void *) 4265, 10598},
    {20219, (void *) 3575, 0},
    {38726, (void *) 7469, 10805},
    {0, NULL, 0},
    {38728, (void *) 7470, 0},
    {38729, (void *) 7472, 10868},
    {29477, (void *) 5969, 10806},
    {20225, (void *) 1860, 0},
    {0, NULL, 0},
    {20227, (void *) 8288, 10936},
    {29481, (void *) 5968, 0},
    {29482, (void *) 3281, 10937},
    {29483, (void *) 3584, 0},
    {38737, (void *) 8609, 11326},
    {38738, (void *) 2949, 0},
    {29486, (void *) 2166, 9694},
    {20234, (void *) 1452, 10022},
    {38741, (void *) 8610, 11327},
    {38742, (void *) 4128, 0},
    {20237, (void *) 2225, 0},
    {20238, (void *) 1861, 0},
    {38745, (void *) 2950, 9569},
    {20240, (void *) 3683, 0},
    {20241, (void *) 1936, 9636},
    {29495, (void *) 4153, 10600},
    {0, NULL, 0},
    {38750, (void *) 3748, 0},
    {0, NULL, 0},
    {38752, (void *) 7474, 0},
    {38753, (void *) 7758, 0},
    {38754, (void *) 4085, 0},
    {29502, (void *) 5970, 0},
    {29503, (void *) 1581, 9288},
    {0, NULL, 0},
    {20252, (void *) 4488, 10602},
    {20253, (void *) 3416, 0},
    {38760, (void *) 7477, 0},
    {38761, (void *) 1746, 9348},
    {29509, (void *) 2509, 0},
    {38763, (void *) 7479, 0},
    {0, NULL, 0},
    {38765, (void *) 2876, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38769, (void *) 7480, 0},
    {0, NULL, 0},
    {29518, (void *) 5971, 0},
    {38772, (void *) 2071, 10023},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20271, (void *) 3647, 10603},
    {20272, (void *) 4455, 10605},
    {0, NULL, 0},
    {29527, (void *) 5974, 10604},
    {0, NULL, 0},
    {20276, (void *) 3693, 0},
    {0, NULL, 0},
    {20278, (void *) 4295, 0},
    {38785, (void *) 7484, 0},
    {20280, (void *) 2832, 0},
    {20281, (void *) 8289, 11006},
    {38788, (void *) 1774, 9369},
    {38789, (void *) 7482, 0},
    {20284, (void *) 2530, 10606},
    {20285, (void *) 1629, 0},
    {29539, (void *) 2666, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38795, (void *) 7487, 0},
    {0, NULL, 0},
    {38797, (void *) 1449, 9481},
    {0, NULL, 0},
    {29546, (void *) 5975, 10607},
    {20294, (void *) 3197, 10608},
    {20295, (void *) 4459, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29552, (void *) 5977, 0},
    {0, NULL, 0},
    {20301, (void *) 1453, 9294},
    {38808, (void *) 2793, 9485},
    {20303, (void *) 2658, 0},
    {20304, (void *) 2369, 10026},
    {20305, (void *) 4139, 0},
    {38812, (void *) 7490, 10870},
    {20307, (void *) 3147, 10025},
    {0, NULL, 0},
    {20309, (void *) 1628, 10028},
    {38816, (void *) 1918, 10027},
    {20311, (void *) 4458, 0},
    {0, NULL, 0},
    {20313, (void *) 4165, 10611},
    {20314, (void *) 4454, 0},
    {20315, (void *) 4456, 0},
    {20316, (void *) 2427, 10610},
    {20317, (void *) 4457, 0},
    {20318, (void *) 4891, 10609},
    {29572, (void *) 2189, 0},
    {0, NULL, 0},
    {38827, (void *) 7036, 0},
    {29575, (void *) 4237, 0},
    {38829, (void *) 3913, 0},
    {29577, (void *) 2017, 0},
    {0, NULL, 0},
    {29579, (void *) 1603, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20329, (void *) 4465, 10612},
    {38836, (void *) 7495, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20335, (void *) 4468, 0},
    {20336, (void *) 4466, 0},
    {29590, (void *) 2047, 0},
    {0, NULL, 0},
    {20339, (void *) 1631, 0},
    {0, NULL, 0},
    {20341, (void *) 3880, 0},
    {20342, (void *) 4460, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38851, (void *) 7496, 0},
    {0, NULL, 0},
    {20347, (void *) 4464, 0},
    {20348, (void *) 2244, 10613},
    {0, NULL, 0},
    {38856, (void *) 7498, 0},
    {20351, (void *) 2483, 0},
    {0, NULL, 0},
    {38859, (void *) 7499, 0},
    {0, NULL, 0},
    {20355, (void *) 1791, 0},
    {29609, (void *) 1850, 0},
    {0, NULL, 0},
    {20358, (void *) 4469, 0},
    {0, NULL, 0},
    {20360, (void *) 4461, 0},
    {38867, (void *) 1843, 0},
    {20362, (void *) 8292, 11009},
    {20363, (void *) 4296, 0},
    {0, NULL, 0},
    {20365, (void *) 2531, 9664},
    {29619, (void *) 5983, 0},
    {20367, (void *) 4462, 0},
    {0, NULL, 0},
    {20369, (void *) 4467, 0},
    {38876, (void *) 7500, 10808},
    {0, NULL, 0},
    {20372, (void *) 8294, 11011},
    {0, NULL, 0},
    {20374, (void *) 4470, 10030},
    {0, NULL, 0},
    {20376, (void *) 4463, 10871},
    {0, NULL, 0},
    {20378, (void *) 8293, 11010},
    {20379, (void *) 1974, 10031},
    {0, NULL, 0},
    {20381, (void *) 1454, 9286},
    {0, NULL, 0},
    {0, NULL, 0},
    {20384, (void *) 1975, 0},
    {20385, (void *) 1630, 0},
    {0, NULL, 0},
    {29640, (void *) 5982, 10614},
    {38894, (void *) 3574, 10872},
    {29642, (void *) 2468, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29645, (void *) 3322, 10615},
    {38899, (void *) 1624, 10029},
    {0, NULL, 0},
    {20395, (void *) 4892, 10616},
    {38902, (void *) 7505, 0},
    {20397, (void *) 4036, 10875},
    {20398, (void *) 3837, 0},
    {20399, (void *) 2245, 0},
    {0, NULL, 0},
    {38907, (void *) 1507, 10873},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38911, (void *) 2006, 9414},
    {20406, (void *) 4252, 0},
    {38913, (void *) 3892, 0},
    {38914, (void *) 3315, 0},
    {38915, (void *) 2351, 10033},
    {0, NULL, 0},
    {38917, (void *) 2319, 9385},
    {38918, (void *) 2702, 0},
    {0, NULL, 0},
    {38920, (void *) 2879, 10874},
    {20415, (void *) 3909, 0},
    {29669, (void *) 5987, 0},
    {0, NULL, 0},
    {20418, (void *) 2091, 10618},
    {20419, (void *) 3106, 0},
    {20420, (void *) 1665, 0},
    {29674, (void *) 2097, 10617},
    {38928, (void *) 4169, 0},
    {38929, (void *) 1857, 0},
    {29677, (void *) 3706, 9538},
    {38931, (void *) 3537, 10032},
    {20426, (void *) 2682, 0},
    {0, NULL, 0},
    {29681, (void *) 6015, 0},
    {38935, (void *) 2911, 10809},
    {38936, (void *) 4275, 9695},
    {0, NULL, 0},
    {38938, (void *) 2126, 9696},
    {20433, (void *) 4477, 0},
    {0, NULL, 0},
    {29688, (void *) 5994, 0},
    {20436, (void *) 4472, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20439, (void *) 3116, 10621},
    {20440, (void *) 4475, 0},
    {29694, (void *) 2190, 0},
    {20442, (void *) 4478, 10620},
    {20443, (void *) 4476, 0},
    {0, NULL, 0},
    {20445, (void *) 3914, 0},
    {29699, (void *) 1948, 0},
    {20447, (void *) 4473, 0},
    {29701, (void *) 5991, 0},
    {20449, (void *) 2833, 9651},
    {38956, (void *) 3990, 10876},
    {38957, (void *) 3489, 9601},
    {29705, (void *) 4245, 9697},
    {20453, (void *) 4481, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38964, (void *) 1551, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {38967, (void *) 7512, 0},
    {20462, (void *) 2635, 10619},
    {20463, (void *) 4494, 0},
    {0, NULL, 0},
    {38971, (void *) 3808, 0},
    {38972, (void *) 4209, 0},
    {20467, (void *) 3619, 10622},
    {0, NULL, 0},
    {20469, (void *) 3781, 0},
    {20470, (void *) 4489, 0},
    {0, NULL, 0},
    {20472, (void *) 3933, 0},
    {0, NULL, 0},
    {20474, (void *) 1619, 0},
    {0, NULL, 0},
    {38982, (void *) 7514, 0},
    {29730, (void *) 3187, 0},
    {20478, (void *) 4493, 0},
    {20479, (void *) 8298, 11015},
    {29733, (void *) 5993, 0},
    {38987, (void *) 7516, 10878},
    {38988, (void *) 3175, 0},
    {38989, (void *) 1750, 0},
    {38990, (void *) 1751, 10880},
    {20485, (void *) 4487, 10623},
    {20486, (void *) 4496, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20489, (void *) 3057, 10881},
    {38996, (void *) 1858, 0},
    {38997, (void *) 2179, 9331},
    {0, NULL, 0},
    {20493, (void *) 3631, 10035},
    {39000, (void *) 1859, 9660},
    {29748, (void *) 2028, 10017},
    {29749, (void *) 3757, 0},
    {39003, (void *) 3414, 9522},
    {20498, (void *) 3444, 0},
    {0, NULL, 0},
    {39006, (void *) 4293, 9698},
    {29754, (void *) 5996, 0},
    {20502, (void *) 2247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20505, (void *) 2246, 0},
    {20506, (void *) 4482, 10036},
    {39013, (void *) 8612, 11329},
    {29761, (void *) 6001, 0},
    {39015, (void *) 2221, 0},
    {20510, (void *) 8299, 11016},
    {20511, (void *) 2595, 0},
    {0, NULL, 0},
    {20513, (void *) 4490, 10624},
    {20514, (void *) 8297, 11014},
    {20515, (void *) 3932, 0},
    {20516, (void *) 3240, 0},
    {20517, (void *) 4486, 10625},
    {20518, (void *) 2148, 10626},
    {39025, (void *) 7520, 0},
    {20520, (void *) 4483, 0},
    {20521, (void *) 4491, 10628},
    {20522, (void *) 4485, 10627},
    {20523, (void *) 4278, 0},
    {20524, (void *) 4492, 0},
    {20525, (void *) 4356, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29781, (void *) 5997, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29785, (void *) 6000, 0},
    {29786, (void *) 2235, 0},
    {29787, (void *) 1548, 9320},
    {29788, (void *) 6002, 0},
    {0, NULL, 0},
    {20537, (void *) 2147, 9423},
    {29791, (void *) 5999, 0},
    {29792, (void *) 4289, 0},
    {0, NULL, 0},
    {29794, (void *) 8475, 11192},
    {29795, (void *) 6005, 0},
    {29796, (void *) 7805, 0},
    {20544, (void *) 8296, 11013},
    {0, NULL, 0},
    {20546, (void *) 8302, 11019},
    {20547, (void *) 4497, 0},
    {29801, (void *) 6003, 0},
    {29802, (void *) 6006, 0},
    {20550, (void *) 8300, 11017},
    {20551, (void *) 4498, 0},
    {20552, (void *) 4502, 0},
    {20553, (void *) 1455, 0},
    {29807, (void *) 5992, 0},
    {29808, (void *) 6004, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29811, (void *) 2377, 0},
    {20559, (void *) 3901, 0},
    {20560, (void *) 4501, 0},
    {29814, (void *) 6007, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20565, (void *) 4500, 0},
    {20566, (void *) 4504, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29822, (void *) 6008, 0},
    {20570, (void *) 4503, 0},
    {0, NULL, 0},
    {20572, (void *) 3357, 0},
    {0, NULL, 0},
    {39080, (void *) 3846, 9652},
    {0, NULL, 0},
    {39082, (void *) 7523, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29833, (void *) 8476, 11193},
    {20581, (void *) 2149, 10629},
    {29835, (void *) 6009, 0},
    {39089, (void *) 7525, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20588, (void *) 4505, 10630},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20592, (void *) 8301, 11018},
    {0, NULL, 0},
    {20594, (void *) 2574, 0},
    {0, NULL, 0},
    {20596, (void *) 3107, 0},
    {20597, (void *) 3358, 0},
    {20598, (void *) 2059, 0},
    {0, NULL, 0},
    {20600, (void *) 4506, 0},
    {29854, (void *) 6010, 10631},
    {39108, (void *) 7527, 10882},
    {0, NULL, 0},
    {39110, (void *) 7529, 0},
    {20605, (void *) 1901, 10034},
    {0, NULL, 0},
    {0, NULL, 0},
    {20608, (void *) 4507, 0},
    {0, NULL, 0},
    {29863, (void *) 6011, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20613, (void *) 4509, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29872, (void *) 1821, 0},
    {0, NULL, 0},
    {20621, (void *) 3968, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20625, (void *) 2137, 9545},
    {39132, (void *) 6529, 0},
    {0, NULL, 0},
    {20628, (void *) 8303, 11020},
    {39135, (void *) 2828, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39138, (void *) 1897, 9363},
    {20633, (void *) 3752, 0},
    {20634, (void *) 4508, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39145, (void *) 7530, 0},
    {0, NULL, 0},
    {39147, (void *) 7531, 0},
    {0, NULL, 0},
    {39149, (void *) 4617, 0},
    {39150, (void *) 5666, 0},
    {39151, (void *) 3716, 10037},
    {0, NULL, 0},
    {0, NULL, 0},
    {39154, (void *) 1500, 0},
    {0, NULL, 0},
    {39156, (void *) 1436, 10038},
    {0, NULL, 0},
    {20652, (void *) 2386, 0},
    {20653, (void *) 4170, 0},
    {0, NULL, 0},
    {29908, (void *) 6014, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39164, (void *) 2527, 9701},
    {39165, (void *) 3963, 9703},
    {39166, (void *) 2819, 9700},
    {20661, (void *) 2385, 0},
    {0, NULL, 0},
    {29916, (void *) 1530, 9400},
    {0, NULL, 0},
    {39171, (void *) 7532, 0},
    {0, NULL, 0},
    {39173, (void *) 4104, 10039},
    {0, NULL, 0},
    {29922, (void *) 3786, 0},
    {20670, (void *) 2092, 10040},
    {39177, (void *) 7533, 0},
    {39178, (void *) 4195, 0},
    {29926, (void *) 1789, 0},
    {39180, (void *) 1537, 9704},
    {0, NULL, 0},
    {29929, (void *) 6019, 0},
    {20677, (void *) 2020, 0},
    {39184, (void *) 2476, 0},
    {0, NULL, 0},
    {39186, (void *) 7534, 0},
    {39187, (void *) 1675, 9702},
    {20682, (void *) 4513, 10632},
    {29936, (void *) 6022, 0},
    {29937, (void *) 6023, 0},
    {20685, (void *) 3492, 10043},
    {39192, (void *) 7536, 0},
    {20687, (void *) 3099, 0},
    {0, NULL, 0},
    {20689, (void *) 1976, 9561},
    {29943, (void *) 6025, 0},
    {29944, (void *) 6024, 10633},
    {39198, (void *) 7539, 0},
    {20693, (void *) 3992, 0},
    {20694, (void *) 4516, 10635},
    {39201, (void *) 7537, 0},
    {20696, (void *) 8305, 11022},
    {0, NULL, 0},
    {20698, (void *) 4258, 10634},
    {0, NULL, 0},
    {29953, (void *) 8478, 11195},
    {39207, (void *) 8615, 11332},
    {39208, (void *) 1844, 9705},
    {29956, (void *) 6026, 0},
    {29957, (void *) 6028, 0},
    {0, NULL, 0},
    {39212, (void *) 7542, 0},
    {20707, (void *) 4520, 0},
    {39214, (void *) 7543, 0},
    {20709, (void *) 4518, 0},
    {0, NULL, 0},
    {20711, (void *) 3053, 10045},
    {29965, (void *) 6031, 0},
    {29966, (void *) 6030, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29969, (void *) 2344, 0},
    {20717, (void *) 4519, 0},
    {20718, (void *) 4521, 10046},
    {0, NULL, 0},
    {29973, (void *) 6032, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {29976, (void *) 1822, 10636},
    {39230, (void *) 7545, 10810},
    {29978, (void *) 2870, 9706},
    {0, NULL, 0},
    {29980, (void *) 3411, 0},
    {39234, (void *) 7546, 0},
    {20729, (void *) 4522, 10047},
    {29983, (void *) 2937, 0},
    {20731, (void *) 3893, 10637},
    {0, NULL, 0},
    {0, NULL, 0},
    {29987, (void *) 2469, 0},
    {39241, (void *) 7547, 0},
    {29989, (void *) 1592, 9306},
    {20737, (void *) 4525, 10048},
    {20738, (void *) 4526, 10641},
    {29992, (void *) 4184, 0},
    {20740, (void *) 1612, 0},
    {0, NULL, 0},
    {29995, (void *) 3920, 10638},
    {29996, (void *) 6036, 10640},
    {39250, (void *) 7552, 0},
    {20745, (void *) 4524, 0},
    {29999, (void *) 8347, 11064},
    {30000, (void *) 3419, 10642},
    {30001, (void *) 4154, 0},
    {39255, (void *) 2007, 9341},
    {30003, (void *) 2848, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20754, (void *) 2621, 9467},
    {30008, (void *) 4625, 0},
    {20756, (void *) 4529, 0},
    {30010, (void *) 3303, 9708},
    {30011, (void *) 1669, 9707},
    {30012, (void *) 6037, 0},
    {20760, (void *) 4471, 0},
    {0, NULL, 0},
    {20762, (void *) 4530, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20767, (void *) 2725, 10049},
    {0, NULL, 0},
    {20769, (void *) 4531, 10050},
    {0, NULL, 0},
    {0, NULL, 0},
    {30025, (void *) 6041, 0},
    {30026, (void *) 6040, 0},
    {30027, (void *) 5391, 0},
    {30028, (void *) 1697, 0},
    {30029, (void *) 6039, 0},
    {0, NULL, 0},
    {30031, (void *) 1467, 9633},
    {0, NULL, 0},
    {30033, (void *) 3675, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30036, (void *) 3707, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20786, (void *) 4098, 0},
    {0, NULL, 0},
    {30041, (void *) 4246, 0},
    {30042, (void *) 6044, 0},
    {30043, (void *) 6042, 0},
    {30044, (void *) 3255, 9709},
    {30045, (void *) 2919, 0},
    {0, NULL, 0},
    {20794, (void *) 4532, 0},
    {30048, (void *) 3676, 9710},
    {20796, (void *) 4534, 0},
    {30050, (void *) 3772, 0},
    {0, NULL, 0},
    {20799, (void *) 4536, 10052},
    {30053, (void *) 4241, 9711},
    {20801, (void *) 1493, 9325},
    {30055, (void *) 6047, 0},
    {20803, (void *) 2182, 0},
    {20804, (void *) 2094, 10051},
    {20805, (void *) 2659, 9539},
    {20806, (void *) 3286, 10053},
    {20807, (void *) 1977, 0},
    {20808, (void *) 2985, 10054},
    {20809, (void *) 2248, 0},
    {20810, (void *) 8306, 10883},
    {30064, (void *) 1468, 9345},
    {39318, (void *) 2620, 9713},
    {20813, (void *) 4081, 10643},
    {30067, (void *) 2811, 9495},
    {39321, (void *) 2320, 10056},
    {20816, (void *) 2532, 0},
    {30070, (void *) 6051, 0},
    {30071, (void *) 3554, 9712},
    {30072, (void *) 6050, 0},
    {20820, (void *) 4540, 10940},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30079, (void *) 1885, 9497},
    {39333, (void *) 7557, 0},
    {20828, (void *) 1776, 0},
    {30082, (void *) 6057, 0},
    {39336, (void *) 1721, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30086, (void *) 6052, 0},
    {39340, (void *) 3618, 9714},
    {39341, (void *) 7558, 0},
    {30089, (void *) 6056, 10645},
    {20837, (void *) 3571, 10057},
    {30091, (void *) 3764, 0},
    {0, NULL, 0},
    {20840, (void *) 3027, 0},
    {30094, (void *) 3041, 9469},
    {30095, (void *) 3040, 9512},
    {20843, (void *) 3677, 0},
    {30097, (void *) 1910, 9336},
    {20845, (void *) 4350, 0},
    {20846, (void *) 4545, 0},
    {30100, (void *) 6058, 0},
    {0, NULL, 0},
    {20849, (void *) 1979, 0},
    {39356, (void *) 7560, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20853, (void *) 3881, 10058},
    {20854, (void *) 3123, 0},
    {20855, (void *) 2054, 9530},
    {20856, (void *) 3404, 10059},
    {0, NULL, 0},
    {39364, (void *) 3145, 0},
    {39365, (void *) 1559, 0},
    {39366, (void *) 2051, 9327},
    {0, NULL, 0},
    {39368, (void *) 2052, 10061},
    {0, NULL, 0},
    {20864, (void *) 4546, 10060},
    {0, NULL, 0},
    {20866, (void *) 4547, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {20869, (void *) 3543, 0},
    {30123, (void *) 1557, 9281},
    {39377, (void *) 7565, 0},
    {39378, (void *) 2053, 0},
    {20873, (void *) 4550, 0},
    {20874, (void *) 2442, 0},
    {39381, (void *) 1676, 0},
    {20876, (void *) 4549, 10064},
    {20877, (void *) 2387, 9542},
    {30131, (void *) 6064, 10649},
    {20879, (void *) 4551, 0},
    {30133, (void *) 6066, 10263},
    {20881, (void *) 4552, 10647},
    {20882, (void *) 3980, 0},
    {20883, (void *) 4553, 10062},
    {30137, (void *) 2849, 0},
    {20885, (void *) 4554, 10646},
    {20886, (void *) 4555, 0},
    {20887, (void *) 2798, 10063},
    {30141, (void *) 6067, 10655},
    {30142, (void *) 2569, 9380},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30146, (void *) 6063, 10812},
    {30147, (void *) 6065, 0},
    {0, NULL, 0},
    {20896, (void *) 1792, 9557},
    {0, NULL, 0},
    {30151, (void *) 2766, 9717},
    {39405, (void *) 7566, 0},
    {20900, (void *) 4556, 10650},
    {20901, (void *) 4070, 10066},
    {20902, (void *) 4557, 0},
    {39409, (void *) 7568, 0},
    {20904, (void *) 3817, 10065},
    {20905, (void *) 4559, 0},
    {20906, (void *) 4560, 0},
    {20907, (void *) 4561, 0},
    {20908, (void *) 3446, 0},
    {30162, (void *) 6073, 0},
    {39416, (void *) 7571, 0},
    {30164, (void *) 2543, 0},
    {30165, (void *) 2364, 9719},
    {20913, (void *) 4563, 10652},
    {20914, (void *) 4564, 0},
    {30168, (void *) 3470, 9718},
    {20916, (void *) 2416, 10067},
    {39423, (void *) 2688, 9720},
    {30171, (void *) 3332, 9624},
    {20919, (void *) 4297, 10653},
    {0, NULL, 0},
    {30174, (void *) 6076, 0},
    {0, NULL, 0},
    {39429, (void *) 7574, 0},
    {0, NULL, 0},
    {30178, (void *) 4230, 9721},
    {30179, (void *) 6075, 10813},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39438, (void *) 1898, 9427},
    {20933, (void *) 4568, 10654},
    {20934, (void *) 2689, 0},
    {0, NULL, 0},
    {39442, (void *) 3098, 0},
    {39443, (void *) 2180, 9722},
    {0, NULL, 0},
    {20939, (void *) 3287, 10068},
    {20940, (void *) 4260, 0},
    {20941, (void *) 3447, 10069},
    {30195, (void *) 6084, 0},
    {30196, (void *) 3247, 10656},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30202, (void *) 6082, 0},
    {20950, (void *) 4642, 0},
    {30204, (void *) 6079, 0},
    {0, NULL, 0},
    {30206, (void *) 6077, 0},
    {30207, (void *) 6078, 0},
    {20955, (void *) 4570, 0},
    {30209, (void *) 6080, 10796},
    {20957, (void *) 2010, 0},
    {39464, (void *) 3146, 0},
    {0, NULL, 0},
    {20960, (void *) 4571, 0},
    {20961, (void *) 4009, 10657},
    {0, NULL, 0},
    {0, NULL, 0},
    {30217, (void *) 6087, 0},
    {0, NULL, 0},
    {20966, (void *) 2703, 9503},
    {20967, (void *) 3193, 0},
    {30221, (void *) 6086, 0},
    {20969, (void *) 4573, 0},
    {20970, (void *) 3545, 0},
    {0, NULL, 0},
    {20972, (void *) 8310, 11027},
    {20973, (void *) 4574, 10658},
    {0, NULL, 0},
    {0, NULL, 0},
    {20976, (void *) 4575, 0},
    {20977, (void *) 1705, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39486, (void *) 7583, 0},
    {20981, (void *) 4576, 0},
    {20982, (void *) 1980, 10661},
    {0, NULL, 0},
    {20984, (void *) 3521, 10660},
    {20985, (void *) 1593, 10662},
    {20986, (void *) 2679, 10071},
    {30240, (void *) 6090, 10659},
    {30241, (void *) 6091, 0},
    {20989, (void *) 3666, 10072},
    {20990, (void *) 4577, 0},
    {30244, (void *) 6093, 0},
    {20992, (void *) 3448, 0},
    {0, NULL, 0},
    {30247, (void *) 6089, 0},
    {20995, (void *) 2866, 10664},
    {20996, (void *) 4578, 10941},
    {0, NULL, 0},
    {20998, (void *) 3865, 0},
    {20999, (void *) 2971, 0},
    {21000, (void *) 1787, 0},
    {0, NULL, 0},
    {21002, (void *) 1794, 0},
    {21003, (void *) 4579, 10073},
    {0, NULL, 0},
    {39511, (void *) 7587, 0},
    {21006, (void *) 4581, 0},
    {30260, (void *) 6094, 0},
    {39514, (void *) 2008, 0},
    {21009, (void *) 2093, 10665},
    {0, NULL, 0},
    {0, NULL, 0},
    {21012, (void *) 4580, 0},
    {39519, (void *) 7588, 10814},
    {30267, (void *) 6096, 0},
    {21015, (void *) 4312, 0},
    {39522, (void *) 7589, 0},
    {0, NULL, 0},
    {39524, (void *) 7591, 0},
    {39525, (void *) 7590, 0},
    {0, NULL, 0},
    {21021, (void *) 2704, 9657},
    {0, NULL, 0},
    {39529, (void *) 7592, 0},
    {39530, (void *) 7594, 0},
    {30278, (void *) 6099, 10666},
    {30279, (void *) 6097, 0},
    {30280, (void *) 6098, 0},
    {21028, (void *) 3694, 0},
    {21029, (void *) 3897, 0},
    {0, NULL, 0},
    {30284, (void *) 1851, 9723},
    {0, NULL, 0},
    {21033, (void *) 4223, 0},
    {21034, (void *) 4583, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30290, (void *) 4135, 0},
    {21038, (void *) 4584, 0},
    {0, NULL, 0},
    {21040, (void *) 3477, 0},
    {30294, (void *) 3895, 0},
    {0, NULL, 0},
    {21043, (void *) 4585, 10075},
    {0, NULL, 0},
    {0, NULL, 0},
    {21046, (void *) 2922, 0},
    {21047, (void *) 2443, 10074},
    {21048, (void *) 2151, 0},
    {21049, (void *) 4586, 0},
    {21050, (void *) 2484, 0},
    {21051, (void *) 2334, 0},
    {30305, (void *) 6102, 0},
    {30306, (void *) 6103, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30311, (void *) 6107, 0},
    {21059, (void *) 3359, 10076},
    {21060, (void *) 4588, 10077},
    {30314, (void *) 6106, 0},
    {0, NULL, 0},
    {21063, (void *) 3108, 10078},
    {0, NULL, 0},
    {0, NULL, 0},
    {21066, (void *) 2428, 0},
    {21067, (void *) 4589, 10079},
    {21068, (void *) 4590, 0},
    {21069, (void *) 3023, 10080},
    {0, NULL, 0},
    {21071, (void *) 4587, 0},
    {0, NULL, 0},
    {30326, (void *) 6111, 0},
    {0, NULL, 0},
    {30328, (void *) 6112, 0},
    {21076, (void *) 4592, 0},
    {30330, (void *) 3680, 0},
    {30331, (void *) 3431, 9591},
    {30332, (void *) 6113, 0},
    {30333, (void *) 3653, 0},
    {30334, (void *) 3779, 0},
    {0, NULL, 0},
    {21083, (void *) 2323, 10081},
    {0, NULL, 0},
    {30338, (void *) 8480, 11197},
    {39592, (void *) 2347, 9724},
    {30340, (void *) 3393, 0},
    {0, NULL, 0},
    {30342, (void *) 1698, 0},
    {30343, (void *) 2291, 0},
    {21091, (void *) 2152, 10083},
    {21092, (void *) 2411, 0},
    {21093, (void *) 3648, 0},
    {30347, (void *) 6117, 10668},
    {0, NULL, 0},
    {0, NULL, 0},
    {21097, (void *) 4595, 10084},
    {21098, (void *) 4593, 0},
    {30352, (void *) 2452, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39608, (void *) 1719, 10086},
    {21103, (void *) 3850, 0},
    {21104, (void *) 2799, 0},
    {21105, (void *) 4602, 10085},
    {21106, (void *) 1759, 10669},
    {21107, (void *) 4596, 0},
    {21108, (void *) 4594, 10087},
    {21109, (void *) 3054, 10088},
    {39616, (void *) 7598, 10884},
    {30364, (void *) 8481, 11198},
    {0, NULL, 0},
    {30366, (void *) 8482, 11199},
    {39620, (void *) 2900, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21117, (void *) 4598, 0},
    {0, NULL, 0},
    {21119, (void *) 4597, 0},
    {0, NULL, 0},
    {30374, (void *) 8484, 11201},
    {0, NULL, 0},
    {21123, (void *) 1727, 0},
    {0, NULL, 0},
    {39631, (void *) 7599, 0},
    {0, NULL, 0},
    {21127, (void *) 2131, 10670},
    {21128, (void *) 4603, 0},
    {30382, (void *) 3738, 9653},
    {39636, (void *) 7602, 0},
    {30384, (void *) 6123, 0},
    {0, NULL, 0},
    {21133, (void *) 4599, 0},
    {39640, (void *) 2321, 0},
    {30388, (void *) 6124, 10942},
    {0, NULL, 0},
    {21137, (void *) 4604, 0},
    {21138, (void *) 4601, 10781},
    {30392, (void *) 6125, 0},
    {21140, (void *) 4600, 10089},
    {30394, (void *) 6127, 10673},
    {0, NULL, 0},
    {0, NULL, 0},
    {39650, (void *) 7605, 0},
    {39651, (void *) 7606, 0},
    {30399, (void *) 2457, 0},
    {21147, (void *) 4276, 0},
    {39654, (void *) 7607, 10815},
    {30402, (void *) 6128, 0},
    {30403, (void *) 3625, 0},
    {21151, (void *) 2250, 0},
    {21152, (void *) 1632, 9534},
    {30406, (void *) 4010, 10675},
    {0, NULL, 0},
    {30408, (void *) 1549, 9549},
    {39662, (void *) 7610, 0},
    {30410, (void *) 1558, 10674},
    {21158, (void *) 8313, 11030},
    {39665, (void *) 7612, 0},
    {30413, (void *) 6129, 0},
    {21161, (void *) 2716, 0},
    {21162, (void *) 3439, 10676},
    {21163, (void *) 2324, 0},
    {21164, (void *) 4607, 0},
    {21165, (void *) 4608, 10091},
    {0, NULL, 0},
    {21167, (void *) 8487, 11204},
    {0, NULL, 0},
    {21169, (void *) 4298, 10090},
    {30423, (void *) 3463, 0},
    {0, NULL, 0},
    {21172, (void *) 4334, 0},
    {21173, (void *) 4610, 0},
    {30427, (void *) 2938, 0},
    {30428, (void *) 5664, 0},
    {0, NULL, 0},
    {21177, (void *) 2251, 10092},
    {30431, (void *) 4074, 0},
    {0, NULL, 0},
    {21180, (void *) 4609, 10093},
    {0, NULL, 0},
    {21182, (void *) 1706, 9301},
    {30436, (void *) 3720, 0},
    {30437, (void *) 6134, 10816},
    {21185, (void *) 4611, 0},
    {30439, (void *) 6135, 0},
    {21187, (void *) 4001, 0},
    {0, NULL, 0},
    {21189, (void *) 3317, 10094},
    {0, NULL, 0},
    {21191, (void *) 4141, 0},
    {0, NULL, 0},
    {21193, (void *) 3910, 9622},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30450, (void *) 4094, 9725},
    {39704, (void *) 7616, 0},
    {30452, (void *) 3319, 0},
    {39706, (void *) 7617, 0},
    {0, NULL, 0},
    {21202, (void *) 7478, 0},
    {30456, (void *) 3081, 0},
    {0, NULL, 0},
    {21205, (void *) 3493, 10680},
    {30459, (void *) 6138, 0},
    {21207, (void *) 4613, 0},
    {21208, (void *) 1795, 10681},
    {30462, (void *) 2697, 9611},
    {0, NULL, 0},
    {39717, (void *) 7621, 10817},
    {30465, (void *) 2767, 0},
    {21213, (void *) 2726, 10683},
    {21214, (void *) 4614, 10684},
    {21215, (void *) 3924, 10098},
    {21216, (void *) 4618, 10686},
    {0, NULL, 0},
    {21218, (void *) 2923, 10097},
    {21219, (void *) 4615, 10096},
    {21220, (void *) 2021, 9548},
    {39727, (void *) 7627, 0},
    {30475, (void *) 1824, 9726},
    {21223, (void *) 1796, 9329},
    {39730, (void *) 7628, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39739, (void *) 6385, 0},
    {39740, (void *) 1899, 9323},
    {21235, (void *) 4619, 0},
    {0, NULL, 0},
    {21237, (void *) 4620, 0},
    {30491, (void *) 6147, 0},
    {39745, (void *) 1692, 0},
    {39746, (void *) 2367, 9727},
    {21241, (void *) 4622, 10100},
    {21242, (void *) 2596, 9417},
    {39749, (void *) 4046, 9610},
    {0, NULL, 0},
    {0, NULL, 0},
    {21246, (void *) 2252, 0},
    {21247, (void *) 4103, 10099},
    {30501, (void *) 6145, 10818},
    {21249, (void *) 4113, 10101},
    {21250, (void *) 3564, 0},
    {39757, (void *) 7632, 0},
    {30505, (void *) 6142, 10691},
    {21253, (void *) 3934, 10690},
    {21254, (void *) 4623, 0},
    {39761, (void *) 7634, 10819},
    {21256, (void *) 4624, 0},
    {0, NULL, 0},
    {39764, (void *) 4013, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21261, (void *) 4626, 0},
    {39768, (void *) 7635, 0},
    {21263, (void *) 4628, 0},
    {39770, (void *) 1970, 9728},
    {0, NULL, 0},
    {30519, (void *) 6148, 0},
    {30520, (void *) 6149, 0},
    {0, NULL, 0},
    {30522, (void *) 3304, 9729},
    {21270, (void *) 1626, 0},
    {30524, (void *) 1852, 9593},
    {0, NULL, 0},
    {21273, (void *) 2441, 0},
    {21274, (void *) 4630, 0},
    {30528, (void *) 3264, 0},
    {0, NULL, 0},
    {21277, (void *) 3064, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21280, (void *) 2727, 0},
    {21281, (void *) 1982, 10886},
    {30535, (void *) 6150, 0},
    {21283, (void *) 4631, 0},
    {21284, (void *) 8318, 11035},
    {39791, (void *) 4328, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39794, (void *) 8622, 11339},
    {0, NULL, 0},
    {21290, (void *) 3724, 10692},
    {39797, (void *) 8621, 11338},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21295, (void *) 4632, 0},
    {0, NULL, 0},
    {21297, (void *) 4633, 0},
    {0, NULL, 0},
    {21299, (void *) 4634, 0},
    {0, NULL, 0},
    {30554, (void *) 6151, 0},
    {30555, (void *) 6154, 0},
    {0, NULL, 0},
    {21304, (void *) 4635, 0},
    {21305, (void *) 3763, 10694},
    {21306, (void *) 2045, 0},
    {21307, (void *) 1478, 0},
    {30561, (void *) 2890, 0},
    {0, NULL, 0},
    {30563, (void *) 3513, 0},
    {21311, (void *) 3508, 0},
    {21312, (void *) 4636, 10104},
    {21313, (void *) 2660, 9594},
    {0, NULL, 0},
    {21315, (void *) 2986, 10102},
    {39822, (void *) 1439, 0},
    {21317, (void *) 4638, 10944},
    {21318, (void *) 4637, 10103},
    {21319, (void *) 2728, 10695},
    {21320, (void *) 2226, 9574},
    {21321, (void *) 4640, 10693},
    {21322, (void *) 3695, 0},
    {0, NULL, 0},
    {39830, (void *) 7640, 0},
    {21325, (void *) 4641, 10696},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21329, (void *) 3725, 0},
    {21330, (void *) 3121, 0},
    {21331, (void *) 3179, 0},
    {21332, (void *) 1981, 10106},
    {39839, (void *) 7642, 0},
    {39840, (void *) 7643, 0},
    {21335, (void *) 3555, 0},
    {21336, (void *) 3212, 0},
    {30590, (void *) 6157, 0},
    {21338, (void *) 3649, 10105},
    {0, NULL, 0},
    {21340, (void *) 3993, 0},
    {0, NULL, 0},
    {21342, (void *) 4643, 10697},
    {0, NULL, 0},
    {21344, (void *) 2987, 9598},
    {39851, (void *) 2456, 0},
    {0, NULL, 0},
    {39853, (void *) 2439, 0},
    {39854, (void *) 3022, 0},
    {0, NULL, 0},
    {21350, (void *) 2088, 10108},
    {39857, (void *) 8624, 11341},
    {0, NULL, 0},
    {21353, (void *) 4644, 10107},
    {39860, (void *) 7645, 0},
    {0, NULL, 0},
    {30609, (void *) 6161, 0},
    {0, NULL, 0},
    {21358, (void *) 4645, 0},
    {21359, (void *) 1515, 10699},
    {21360, (void *) 1494, 0},
    {21361, (void *) 1862, 10945},
    {21362, (void *) 8319, 11036},
    {21363, (void *) 3109, 0},
    {21364, (void *) 1928, 0},
    {21365, (void *) 4216, 0},
    {39872, (void *) 7646, 0},
    {21367, (void *) 4648, 0},
    {21368, (void *) 1620, 0},
    {30622, (void *) 6163, 0},
    {0, NULL, 0},
    {21371, (void *) 4647, 10109},
    {39878, (void *) 7649, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21375, (void *) 1983, 9335},
    {30629, (void *) 3898, 10698},
    {0, NULL, 0},
    {21378, (void *) 4649, 0},
    {0, NULL, 0},
    {21380, (void *) 4122, 0},
    {39887, (void *) 7650, 0},
    {0, NULL, 0},
    {30636, (void *) 2685, 10700},
    {30637, (void *) 4267, 10701},
    {0, NULL, 0},
    {39892, (void *) 7656, 0},
    {30640, (void *) 6164, 0},
    {39894, (void *) 2453, 0},
    {0, NULL, 0},
    {30643, (void *) 3500, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39899, (void *) 3169, 10110},
    {0, NULL, 0},
    {21395, (void *) 8320, 11037},
    {30649, (void *) 6166, 0},
    {0, NULL, 0},
    {21398, (void *) 4650, 10113},
    {30652, (void *) 6168, 10704},
    {21400, (void *) 4279, 10112},
    {39907, (void *) 7653, 0},
    {21402, (void *) 2253, 10111},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39912, (void *) 2130, 0},
    {21407, (void *) 2183, 0},
    {21408, (void *) 4651, 0},
    {0, NULL, 0},
    {30663, (void *) 6171, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21413, (void *) 4653, 0},
    {21414, (void *) 4652, 10707},
    {39921, (void *) 7660, 0},
    {21416, (void *) 2882, 10114},
    {21417, (void *) 1528, 0},
    {0, NULL, 0},
    {39925, (void *) 1428, 0},
    {0, NULL, 0},
    {21421, (void *) 1565, 0},
    {21422, (void *) 4654, 0},
    {0, NULL, 0},
    {21424, (void *) 4655, 0},
    {0, NULL, 0},
    {30679, (void *) 6173, 10820},
    {21427, (void *) 2184, 0},
    {0, NULL, 0},
    {30682, (void *) 6174, 0},
    {30683, (void *) 4064, 9730},
    {30684, (void *) 6175, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {39940, (void *) 7671, 0},
    {21435, (void *) 1957, 0},
    {39942, (void *) 7667, 0},
    {30690, (void *) 4121, 0},
    {30691, (void *) 6176, 10712},
    {39945, (void *) 7664, 0},
    {30693, (void *) 3241, 10714},
    {0, NULL, 0},
    {21442, (void *) 2461, 9526},
    {39949, (void *) 1757, 9731},
    {30697, (void *) 2048, 0},
    {0, NULL, 0},
    {39952, (void *) 4367, 0},
    {0, NULL, 0},
    {30701, (void *) 3222, 9602},
    {21449, (void *) 2370, 10115},
    {21450, (void *) 1937, 9316},
    {21451, (void *) 4142, 10708},
    {21452, (void *) 3055, 0},
    {21453, (void *) 3696, 0},
    {21454, (void *) 2630, 9431},
    {0, NULL, 0},
    {0, NULL, 0},
    {39963, (void *) 7673, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21460, (void *) 2670, 0},
    {0, NULL, 0},
    {21462, (void *) 2609, 0},
    {21463, (void *) 2622, 10116},
    {0, NULL, 0},
    {21465, (void *) 2717, 0},
    {39972, (void *) 7675, 0},
    {21467, (void *) 3697, 10716},
    {0, NULL, 0},
    {30722, (void *) 2378, 10821},
    {0, NULL, 0},
    {21471, (void *) 4660, 0},
    {0, NULL, 0},
    {21473, (void *) 1538, 0},
    {21474, (void *) 3056, 0},
    {21475, (void *) 2254, 9558},
    {21476, (void *) 2198, 10715},
    {39983, (void *) 1492, 9321},
    {39984, (void *) 7677, 0},
    {30732, (void *) 6179, 0},
    {21480, (void *) 4664, 10718},
    {21481, (void *) 3196, 0},
    {21482, (void *) 3195, 0},
    {21483, (void *) 1984, 0},
    {21484, (void *) 2729, 0},
    {21485, (void *) 4665, 10117},
    {21486, (void *) 4663, 0},
    {21487, (void *) 1633, 9298},
    {30741, (void *) 2402, 9453},
    {39995, (void *) 1526, 9377},
    {21490, (void *) 2486, 0},
    {21491, (void *) 1509, 0},
    {39998, (void *) 7681, 0},
    {0, NULL, 0},
    {21494, (void *) 1771, 0},
    {21495, (void *) 2325, 0},
    {21496, (void *) 2485, 0},
    {0, NULL, 0},
    {21498, (void *) 4666, 0},
    {30752, (void *) 6182, 0},
    {40006, (void *) 7680, 10887},
    {40007, (void *) 7678, 0},
    {40008, (void *) 3208, 0},
    {0, NULL, 0},
    {30757, (void *) 3437, 0},
    {30758, (void *) 2403, 9733},
    {30759, (void *) 1925, 0},
    {21507, (void *) 1920, 0},
    {21508, (void *) 1729, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21512, (void *) 2326, 9599},
    {21513, (void *) 1919, 0},
    {21514, (void *) 3352, 0},
    {21515, (void *) 1508, 0},
    {21516, (void *) 3494, 0},
    {30770, (void *) 3951, 9614},
    {21518, (void *) 2256, 0},
    {30772, (void *) 3614, 9650},
    {21520, (void *) 3422, 10719},
    {21521, (void *) 2255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30778, (void *) 3438, 0},
    {40032, (void *) 7683, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30783, (void *) 2315, 0},
    {21531, (void *) 2082, 0},
    {0, NULL, 0},
    {21533, (void *) 4676, 10720},
    {0, NULL, 0},
    {21535, (void *) 2040, 0},
    {21536, (void *) 3989, 10120},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {12288, (void *) 0, 0},
    {12289, (void *) 1, 9541},
    {12290, (void *) 2, 0},
    {12291, (void *) 22, 0},
    {21545, (void *) 4675, 10888},
    {12293, (void *) 24, 0},
    {12294, (void *) 25, 9304},
    {12295, (void *) 26, 9734},
    {12296, (void *) 49, 9735},
    {12297, (void *) 50, 9736},
    {12298, (void *) 51, 0},
    {12299, (void *) 52, 0},
    {12300, (void *) 53, 0},
    {12301, (void *) 54, 0},
    {12302, (void *) 55, 0},
    {12303, (void *) 56, 0},
    {12304, (void *) 57, 0},
    {12305, (void *) 58, 9737},
    {12306, (void *) 102, 0},
    {12307, (void *) 107, 9312},
    {12308, (void *) 43, 9420},
    {12309, (void *) 44, 0},
    {21563, (void *) 3866, 0},
    {21564, (void *) 4672, 0},
    {21565, (void *) 4668, 0},
    {21566, (void *) 2228, 0},
    {30820, (void *) 8490, 11207},
    {21568, (void *) 4669, 0},
    {0, NULL, 0},
    {12317, (void *) 1191, 9671},
    {0, NULL, 0},
    {12319, (void *) 1192, 0},
    {0, NULL, 0},
    {21574, (void *) 3935, 9655},
    {30828, (void *) 2292, 0},
    {21576, (void *) 3361, 0},
    {21577, (void *) 2227, 0},
    {30831, (void *) 2168, 9346},
    {0, NULL, 0},
    {0, NULL, 0},
    {30834, (void *) 3668, 0},
    {21582, (void *) 4677, 0},
    {30836, (void *) 6186, 0},
    {0, NULL, 0},
    {21585, (void *) 3538, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30842, (void *) 8491, 11208},
    {0, NULL, 0},
    {30844, (void *) 6188, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {30849, (void *) 2236, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21599, (void *) 4681, 0},
    {0, NULL, 0},
    {30854, (void *) 6187, 0},
    {30855, (void *) 3375, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {12353, (void *) 282, 0},
    {12354, (void *) 283, 10123},
    {12355, (void *) 284, 9291},
    {12356, (void *) 285, 10121},
    {12357, (void *) 286, 9387},
    {12358, (void *) 287, 0},
    {12359, (void *) 288, 9543},
    {12360, (void *) 289, 0},
    {12361, (void *) 290, 9277},
    {12362, (void *) 291, 0},
    {12363, (void *) 292, 9357},
    {12364, (void *) 293, 9741},
    {12365, (void *) 294, 9679},
    {12366, (void *) 295, 9605},
    {12367, (void *) 296, 0},
    {12368, (void *) 297, 9739},
    {12369, (void *) 298, 9747},
    {12370, (void *) 299, 9742},
    {12371, (void *) 300, 0},
    {12372, (void *) 301, 0},
    {12373, (void *) 302, 0},
    {12374, (void *) 303, 9745},
    {12375, (void *) 304, 9332},
    {12376, (void *) 305, 9615},
    {12377, (void *) 306, 10124},
    {12378, (void *) 307, 0},
    {12379, (void *) 308, 9746},
    {12380, (void *) 309, 0},
    {12381, (void *) 310, 9579},
    {12382, (void *) 311, 0},
    {12383, (void *) 312, 9433},
    {12384, (void *) 313, 10126},
    {12385, (void *) 314, 9750},
    {12386, (void *) 315, 0},
    {12387, (void *) 316, 0},
    {12388, (void *) 317, 0},
    {12389, (void *) 318, 10127},
    {12390, (void *) 319, 9359},
    {12391, (void *) 320, 9675},
    {12392, (void *) 321, 0},
    {12393, (void *) 322, 9740},
    {12394, (void *) 323, 9738},
    {12395, (void *) 324, 9749},
    {12396, (void *) 325, 0},
    {12397, (void *) 326, 9744},
    {12398, (void *) 327, 0},
    {12399, (void *) 328, 0},
    {12400, (void *) 329, 9295},
    {12401, (void *) 330, 0},
    {12402, (void *) 331, 10133},
    {12403, (void *) 332, 0},
    {12404, (void *) 333, 10132},
    {12405, (void *) 334, 0},
    {12406, (void *) 335, 9479},
    {12407, (void *) 336, 9373},
    {12408, (void *) 337, 10723},
    {12409, (void *) 338, 0},
    {12410, (void *) 339, 9535},
    {12411, (void *) 340, 10134},
    {12412, (void *) 341, 10129},
    {12413, (void *) 342, 9752},
    {12414, (void *) 343, 0},
    {12415, (void *) 344, 9761},
    {12416, (void *) 345, 9754},
    {12417, (void *) 346, 10130},
    {12418, (void *) 347, 0},
    {12419, (void *) 348, 9758},
    {12420, (void *) 349, 9587},
    {12421, (void *) 350, 9617},
    {12422, (void *) 351, 9540},
    {12423, (void *) 352, 9509},
    {12424, (void *) 353, 0},
    {12425, (void *) 354, 0},
    {12426, (void *) 355, 9778},
    {12427, (void *) 356, 0},
    {12428, (void *) 357, 0},
    {12429, (void *) 358, 9355},
    {12430, (void *) 359, 9290},
    {12431, (void *) 360, 0},
    {12432, (void *) 361, 10138},
    {12433, (void *) 362, 0},
    {12434, (void *) 363, 0},
    {12435, (void *) 364, 9753},
    {40195, (void *) 7693, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21692, (void *) 4704, 10728},
    {21693, (void *) 1495, 9506},
    {21694, (void *) 4703, 10726},
    {40201, (void *) 7690, 0},
    {12443, (void *) 10, 9270},
    {12444, (void *) 11, 9559},
    {12445, (void *) 20, 9760},
    {12446, (void *) 21, 9596},
    {40206, (void *) 1607, 9756},
    {0, NULL, 0},
    {12449, (void *) 376, 0},
    {12450, (void *) 377, 9751},
    {12451, (void *) 378, 9757},
    {12452, (void *) 379, 9351},
    {12453, (void *) 380, 9272},
    {12454, (void *) 381, 10735},
    {12455, (void *) 382, 0},
    {12456, (void *) 383, 0},
    {12457, (void *) 384, 0},
    {12458, (void *) 385, 10140},
    {12459, (void *) 386, 0},
    {12460, (void *) 387, 9283},
    {12461, (void *) 388, 0},
    {12462, (void *) 389, 0},
    {12463, (void *) 390, 0},
    {12464, (void *) 391, 10733},
    {12465, (void *) 392, 0},
    {12466, (void *) 393, 0},
    {12467, (void *) 394, 9762},
    {12468, (void *) 395, 10732},
    {12469, (void *) 396, 0},
    {12470, (void *) 397, 0},
    {12471, (void *) 398, 9408},
    {12472, (void *) 399, 0},
    {12473, (void *) 400, 9299},
    {12474, (void *) 401, 0},
    {12475, (void *) 402, 10729},
    {12476, (void *) 403, 9274},
    {12477, (void *) 404, 9284},
    {12478, (void *) 405, 0},
    {12479, (void *) 406, 0},
    {12480, (void *) 407, 9763},
    {12481, (void *) 408, 9764},
    {12482, (void *) 409, 0},
    {12483, (void *) 410, 9401},
    {12484, (void *) 411, 9442},
    {12485, (void *) 412, 0},
    {12486, (void *) 413, 0},
    {12487, (void *) 414, 10143},
    {12488, (void *) 415, 9769},
    {12489, (void *) 416, 9768},
    {12490, (void *) 417, 0},
    {12491, (void *) 418, 0},
    {12492, (void *) 419, 9343},
    {12493, (void *) 420, 9492},
    {12494, (void *) 421, 0},
    {12495, (void *) 422, 10144},
    {12496, (void *) 423, 10738},
    {12497, (void *) 424, 0},
    {12498, (void *) 425, 10737},
    {12499, (void *) 426, 0},
    {12500, (void *) 427, 0},
    {12501, (void *) 428, 9770},
    {12502, (void *) 429, 0},
    {12503, (void *) 430, 10740},
    {12504, (void *) 431, 9767},
    {12505, (void *) 432, 10741},
    {12506, (void *) 433, 10825},
    {12507, (void *) 434, 0},
    {12508, (void *) 435, 10118},
    {12509, (void *) 436, 0},
    {12510, (void *) 437, 0},
    {12511, (void *) 438, 9278},
    {12512, (void *) 439, 10119},
    {12513, (void *) 440, 9349},
    {12514, (void *) 441, 9415},
    {12515, (void *) 442, 0},
    {12516, (void *) 443, 0},
    {12517, (void *) 444, 0},
    {12518, (void *) 445, 10889},
    {12519, (void *) 446, 0},
    {12520, (void *) 447, 0},
    {12521, (void *) 448, 0},
    {12522, (void *) 449, 9765},
    {12523, (void *) 450, 9498},
    {12524, (void *) 451, 0},
    {12525, (void *) 452, 9276},
    {12526, (void *) 453, 10742},
    {12527, (void *) 454, 9766},
    {12528, (void *) 455, 9374},
    {12529, (void *) 456, 9269},
    {12530, (void *) 457, 9613},
    {12531, (void *) 458, 0},
    {12532, (void *) 459, 9382},
    {12533, (void *) 460, 10744},
    {12534, (void *) 461, 10147},
    {31041, (void *) 2090, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {12539, (void *) 5, 0},
    {12540, (void *) 27, 10947},
    {12541, (void *) 18, 9309},
    {12542, (void *) 19, 9305},
    {31049, (void *) 2510, 0},
    {40303, (void *) 7718, 0},
    {40304, (void *) 8627, 11344},
    {0, NULL, 0},
    {40306, (void *) 7714, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31056, (void *) 4155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21806, (void *) 4719, 10148},
    {21807, (void *) 4138, 0},
    {31061, (void *) 6219, 10749},
    {21809, (void *) 2732, 9443},
    {31063, (void *) 6216, 0},
    {21811, (void *) 4725, 0},
    {0, NULL, 0},
    {31066, (void *) 6218, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31069, (void *) 2674, 9776},
    {31070, (void *) 2851, 9772},
    {31071, (void *) 6217, 0},
    {31072, (void *) 6215, 0},
    {0, NULL, 0},
    {31074, (void *) 3581, 10748},
    {21822, (void *) 3136, 0},
    {40329, (void *) 7715, 0},
    {31077, (void *) 2770, 9773},
    {0, NULL, 0},
    {0, NULL, 0},
    {31080, (void *) 3787, 0},
    {21828, (void *) 3180, 0},
    {40335, (void *) 2127, 9775},
    {21830, (void *) 2731, 0},
    {0, NULL, 0},
    {31085, (void *) 2404, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21836, (void *) 4718, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21839, (void *) 4109, 0},
    {40346, (void *) 7720, 0},
    {0, NULL, 0},
    {31095, (void *) 3471, 0},
    {21843, (void *) 2095, 0},
    {0, NULL, 0},
    {31098, (void *) 6221, 0},
    {21846, (void *) 4722, 0},
    {21847, (void *) 4723, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31103, (void *) 6222, 10750},
    {31104, (void *) 6244, 0},
    {31105, (void *) 2029, 9774},
    {21853, (void *) 4726, 0},
    {0, NULL, 0},
    {31108, (void *) 4352, 10751},
    {31109, (void *) 3028, 0},
    {40363, (void *) 7717, 0},
    {0, NULL, 0},
    {21859, (void *) 4717, 0},
    {0, NULL, 0},
    {31114, (void *) 6223, 10731},
    {0, NULL, 0},
    {0, NULL, 0},
    {31117, (void *) 1647, 10752},
    {31118, (void *) 3376, 0},
    {40372, (void *) 3354, 9570},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {40376, (void *) 7727, 0},
    {31124, (void *) 8496, 11213},
    {40378, (void *) 7728, 0},
    {40379, (void *) 7726, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31131, (void *) 8498, 11215},
    {40385, (void *) 7725, 0},
    {31133, (void *) 6224, 10755},
    {0, NULL, 0},
    {40388, (void *) 7724, 0},
    {21883, (void *) 4732, 0},
    {21884, (void *) 4737, 10753},
    {0, NULL, 0},
    {21886, (void *) 4733, 0},
    {0, NULL, 0},
    {21888, (void *) 4728, 0},
    {31142, (void *) 1969, 0},
    {31143, (void *) 6225, 0},
    {21891, (void *) 4738, 0},
    {21892, (void *) 3024, 0},
    {31146, (void *) 6227, 10754},
    {21894, (void *) 8328, 11045},
    {21895, (void *) 4740, 0},
    {0, NULL, 0},
    {21897, (void *) 2257, 10150},
    {21898, (void *) 4730, 0},
    {21899, (void *) 3288, 9517},
    {0, NULL, 0},
    {0, NULL, 0},
    {31155, (void *) 6229, 0},
    {40409, (void *) 7732, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31161, (void *) 6230, 0},
    {31162, (void *) 6231, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31165, (void *) 2030, 9779},
    {31166, (void *) 1648, 9777},
    {21914, (void *) 1798, 9507},
    {31168, (void *) 2639, 0},
    {21916, (void *) 1863, 9370},
    {21917, (void *) 1760, 0},
    {21918, (void *) 4735, 0},
    {21919, (void *) 4731, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {40429, (void *) 7736, 0},
    {31177, (void *) 6232, 0},
    {40431, (void *) 7737, 0},
    {31179, (void *) 2640, 0},
    {21927, (void *) 2153, 0},
    {40434, (void *) 4364, 9780},
    {21929, (void *) 4739, 0},
    {21930, (void *) 3058, 0},
    {21931, (void *) 1921, 0},
    {31185, (void *) 1639, 9314},
    {31186, (void *) 3794, 0},
    {21934, (void *) 4736, 10757},
    {40441, (void *) 3176, 0},
    {21936, (void *) 2057, 9358},
    {0, NULL, 0},
    {0, NULL, 0},
    {31192, (void *) 3740, 10759},
    {0, NULL, 0},
    {0, NULL, 0},
    {21942, (void *) 1539, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31199, (void *) 3044, 0},
    {0, NULL, 0},
    {31201, (void *) 6236, 0},
    {0, NULL, 0},
    {31203, (void *) 6237, 0},
    {31204, (void *) 3644, 0},
    {0, NULL, 0},
    {31206, (void *) 2852, 0},
    {31207, (void *) 6234, 0},
    {0, NULL, 0},
    {31209, (void *) 3260, 9781},
    {21957, (void *) 4743, 0},
    {0, NULL, 0},
    {21959, (void *) 4800, 10152},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31216, (void *) 2771, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {40473, (void *) 8630, 11347},
    {40474, (void *) 7739, 0},
    {40475, (void *) 7740, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21972, (void *) 4748, 10760},
    {0, NULL, 0},
    {31227, (void *) 1469, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21978, (void *) 4742, 0},
    {31232, (void *) 1888, 0},
    {21980, (void *) 4746, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21983, (void *) 4744, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {21987, (void *) 2487, 10153},
    {21988, (void *) 4747, 0},
    {0, NULL, 0},
    {31243, (void *) 3377, 0},
    {0, NULL, 0},
    {31245, (void *) 6239, 0},
    {31246, (void *) 2952, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31252, (void *) 4054, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31255, (void *) 3762, 0},
    {31256, (void *) 6240, 0},
    {31257, (void *) 6241, 0},
    {31258, (void *) 3248, 0},
    {0, NULL, 0},
    {31260, (void *) 4268, 9782},
    {0, NULL, 0},
    {22009, (void *) 4755, 0},
    {31263, (void *) 6243, 0},
    {31264, (void *) 6242, 0},
    {0, NULL, 0},
    {22013, (void *) 4753, 0},
    {22014, (void *) 4752, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22022, (void *) 3213, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22025, (void *) 1634, 9386},
    {0, NULL, 0},
    {0, NULL, 0},
    {31281, (void *) 6245, 0},
    {31282, (void *) 1489, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31287, (void *) 6248, 0},
    {0, NULL, 0},
    {22036, (void *) 4749, 0},
    {0, NULL, 0},
    {22038, (void *) 4751, 10154},
    {31292, (void *) 1649, 9402},
    {22040, (void *) 1522, 9326},
    {31294, (void *) 6247, 0},
    {31295, (void *) 2293, 0},
    {31296, (void *) 2337, 9783},
    {0, NULL, 0},
    {31298, (void *) 3923, 0},
    {31299, (void *) 6249, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31302, (void *) 3999, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31305, (void *) 6251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31309, (void *) 2962, 0},
    {31310, (void *) 1550, 9287},
    {31311, (void *) 1623, 0},
    {31312, (void *) 1421, 10761},
    {0, NULL, 0},
    {0, NULL, 0},
    {40568, (void *) 2181, 0},
    {22063, (void *) 4765, 10762},
    {0, NULL, 0},
    {22065, (void *) 2817, 0},
    {22066, (void *) 4761, 10155},
    {40573, (void *) 7744, 0},
    {22068, (void *) 4759, 0},
    {40575, (void *) 2552, 0},
    {22070, (void *) 4760, 0},
    {40577, (void *) 7745, 0},
    {22072, (void *) 4762, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31329, (void *) 6252, 0},
    {31330, (void *) 6253, 0},
    {31331, (void *) 2812, 10763},
    {0, NULL, 0},
    {0, NULL, 0},
    {40587, (void *) 7747, 0},
    {22082, (void *) 1532, 10764},
    {0, NULL, 0},
    {31337, (void *) 6254, 0},
    {0, NULL, 0},
    {31339, (void *) 1738, 0},
    {40593, (void *) 7751, 0},
    {40594, (void *) 7749, 0},
    {40595, (void *) 4351, 0},
    {0, NULL, 0},
    {31344, (void *) 6256, 10765},
    {22092, (void *) 3032, 0},
    {40599, (void *) 4308, 0},
    {22094, (void *) 4756, 0},
    {31348, (void *) 2141, 0},
    {22096, (void *) 4757, 0},
    {31350, (void *) 1949, 0},
    {0, NULL, 0},
    {40605, (void *) 7752, 0},
    {31353, (void *) 6257, 0},
    {31354, (void *) 2058, 9663},
    {12849, (void *) 1201, 10985},
    {12850, (void *) 1202, 0},
    {31357, (void *) 6258, 0},
    {0, NULL, 0},
    {31359, (void *) 3005, 0},
    {22107, (void *) 1781, 10766},
    {31361, (void *) 3522, 9531},
    {0, NULL, 0},
    {12857, (void *) 1203, 9435},
    {31364, (void *) 2434, 10767},
    {40618, (void *) 7756, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31368, (void *) 6259, 10769},
    {22116, (void *) 4764, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22120, (void *) 1864, 0},
    {0, NULL, 0},
    {22122, (void *) 4767, 0},
    {22123, (void *) 4763, 0},
    {22124, (void *) 4766, 0},
    {31378, (void *) 3261, 0},
    {31379, (void *) 3082, 10768},
    {40633, (void *) 2332, 0},
    {40634, (void *) 4086, 10157},
    {40635, (void *) 4014, 10158},
    {40636, (void *) 5068, 10156},
    {31384, (void *) 6262, 0},
    {22132, (void *) 3867, 9929},
    {40639, (void *) 4038, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22136, (void *) 3530, 0},
    {0, NULL, 0},
    {40644, (void *) 1608, 9322},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22144, (void *) 4769, 0},
    {0, NULL, 0},
    {40652, (void *) 7759, 0},
    {40653, (void *) 1927, 0},
    {31401, (void *) 6264, 10770},
    {31402, (void *) 2073, 10771},
    {22150, (void *) 4768, 10772},
    {22151, (void *) 1728, 10949},
    {40658, (void *) 2340, 0},
    {31406, (void *) 1950, 0},
    {31407, (void *) 4185, 9784},
    {31408, (void *) 6266, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {40664, (void *) 5973, 0},
    {40665, (void *) 4100, 9785},
    {0, NULL, 0},
    {40667, (void *) 3168, 10159},
    {40668, (void *) 7764, 0},
    {40669, (void *) 7766, 0},
    {22164, (void *) 4772, 10774},
    {31418, (void *) 1517, 0},
    {40672, (void *) 7767, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31423, (void *) 6270, 0},
    {40677, (void *) 7768, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31427, (void *) 1777, 10775},
    {31428, (void *) 6269, 0},
    {22176, (void *) 4771, 10160},
    {0, NULL, 0},
    {22178, (void *) 3596, 10162},
    {31432, (void *) 6265, 0},
    {0, NULL, 0},
    {22181, (void *) 4774, 10163},
    {31435, (void *) 4238, 0},
    {0, NULL, 0},
    {31437, (void *) 6274, 0},
    {0, NULL, 0},
    {31439, (void *) 6275, 10777},
    {0, NULL, 0},
    {40694, (void *) 7772, 10890},
    {31442, (void *) 4877, 10778},
    {22190, (void *) 4775, 10164},
    {40697, (void *) 7774, 0},
    {31445, (void *) 6276, 0},
    {40699, (void *) 7775, 0},
    {40700, (void *) 7776, 0},
    {40701, (void *) 7777, 0},
    {22196, (void *) 4777, 10165},
    {31450, (void *) 6279, 0},
    {22198, (void *) 4776, 0},
    {31452, (void *) 4250, 0},
    {31453, (void *) 6280, 0},
    {0, NULL, 0},
    {31455, (void *) 7504, 0},
    {31456, (void *) 2772, 0},
    {22204, (void *) 4779, 10166},
    {31458, (void *) 6282, 10779},
    {31459, (void *) 2686, 10780},
    {0, NULL, 0},
    {31461, (void *) 3501, 9786},
    {22209, (void *) 4780, 10167},
    {22210, (void *) 4778, 10891},
    {22211, (void *) 4781, 0},
    {40718, (void *) 3387, 0},
    {31466, (void *) 3203, 0},
    {31467, (void *) 8502, 11219},
    {0, NULL, 0},
    {22216, (void *) 4783, 10168},
    {12964, (void *) 1196, 9334},
    {12965, (void *) 1197, 9463},
    {12966, (void *) 1198, 10169},
    {12967, (void *) 1199, 0},
    {12968, (void *) 1200, 0},
    {22222, (void *) 4784, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31478, (void *) 1978, 9787},
    {0, NULL, 0},
    {31480, (void *) 4542, 9788},
    {31481, (void *) 3256, 0},
    {31482, (void *) 2556, 0},
    {40736, (void *) 3052, 0},
    {22231, (void *) 4787, 10783},
    {22232, (void *) 4548, 0},
    {0, NULL, 0},
    {31487, (void *) 1825, 9389},
    {22235, (void *) 2488, 0},
    {0, NULL, 0},
    {31490, (void *) 6286, 0},
    {22238, (void *) 1680, 0},
    {31492, (void *) 6299, 0},
    {22240, (void *) 1497, 0},
    {31494, (void *) 6289, 0},
    {40748, (void *) 7783, 0},
    {31496, (void *) 1951, 9465},
    {0, NULL, 0},
    {31498, (void *) 6288, 0},
    {31499, (void *) 6301, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31503, (void *) 6287, 0},
    {0, NULL, 0},
    {31505, (void *) 2773, 0},
    {0, NULL, 0},
    {22254, (void *) 4788, 0},
    {0, NULL, 0},
    {22256, (void *) 2353, 0},
    {40763, (void *) 3760, 0},
    {22258, (void *) 1456, 0},
    {22259, (void *) 2881, 10170},
    {31513, (void *) 6292, 10784},
    {0, NULL, 0},
    {31515, (void *) 3394, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22265, (void *) 4789, 10171},
    {22266, (void *) 2200, 0},
    {31520, (void *) 1753, 0},
    {0, NULL, 0},
    {22269, (void *) 2336, 0},
    {0, NULL, 0},
    {22271, (void *) 4791, 0},
    {31525, (void *) 2877, 9789},
    {31526, (void *) 3827, 10149},
    {0, NULL, 0},
    {22275, (void *) 3917, 10172},
    {22276, (void *) 4792, 10453},
    {40783, (void *) 7502, 0},
    {0, NULL, 0},
    {31532, (void *) 3173, 0},
    {22280, (void *) 4794, 10786},
    {22281, (void *) 4793, 0},
    {40788, (void *) 7787, 0},
    {22283, (void *) 4795, 0},
    {0, NULL, 0},
    {22285, (void *) 4796, 0},
    {31539, (void *) 6290, 0},
    {22287, (void *) 2154, 0},
    {31541, (void *) 6294, 0},
    {31542, (void *) 6296, 0},
    {22290, (void *) 1567, 0},
    {22291, (void *) 4797, 0},
    {31545, (void *) 2440, 0},
    {40799, (void *) 7789, 0},
    {22294, (void *) 4799, 10787},
    {40801, (void *) 7791, 0},
    {40802, (void *) 4309, 9790},
    {40803, (void *) 7788, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22300, (void *) 4801, 10788},
    {40807, (void *) 7793, 0},
    {0, NULL, 0},
    {22303, (void *) 3441, 0},
    {31557, (void *) 6303, 10789},
    {31558, (void *) 3773, 0},
    {40812, (void *) 7794, 0},
    {31560, (void *) 3671, 0},
    {31561, (void *) 3472, 0},
    {0, NULL, 0},
    {31563, (void *) 2031, 9791},
    {22311, (void *) 1430, 10174},
    {13059, (void *) 1165, 9353},
    {0, NULL, 0},
    {31567, (void *) 3686, 0},
    {31568, (void *) 6297, 0},
    {31569, (void *) 3257, 10792},
    {22317, (void *) 2096, 9500},
    {0, NULL, 0},
    {31572, (void *) 3473, 0},
    {22320, (void *) 3242, 0},
    {31574, (void *) 2435, 0},
    {13069, (void *) 1169, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22327, (void *) 4803, 0},
    {22328, (void *) 4804, 10184},
    {13076, (void *) 1160, 0},
    {0, NULL, 0},
    {22331, (void *) 4806, 0},
    {0, NULL, 0},
    {13080, (void *) 1163, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22336, (void *) 4807, 10176},
    {0, NULL, 0},
    {22338, (void *) 2417, 10178},
    {40845, (void *) 4251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {13090, (void *) 1161, 9318},
    {13091, (void *) 1171, 0},
    {31598, (void *) 6311, 0},
    {22346, (void *) 3970, 0},
    {13094, (void *) 1170, 10179},
    {13095, (void *) 1164, 10180},
    {0, NULL, 0},
    {22350, (void *) 4805, 0},
    {22351, (void *) 4808, 10177},
    {13099, (void *) 1172, 9350},
    {22353, (void *) 2258, 0},
    {40860, (void *) 7800, 0},
    {40861, (void *) 6255, 0},
    {0, NULL, 0},
    {31610, (void *) 6298, 0},
    {40864, (void *) 7801, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22361, (void *) 8329, 11046},
    {0, NULL, 0},
    {13110, (void *) 1166, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {13115, (void *) 1174, 0},
    {31622, (void *) 3900, 9793},
    {31623, (void *) 1650, 0},
    {0, NULL, 0},
    {22372, (void *) 2354, 0},
    {22373, (void *) 8330, 11047},
    {22374, (void *) 3214, 10182},
    {0, NULL, 0},
    {31629, (void *) 6315, 0},
    {22377, (void *) 4809, 0},
    {22378, (void *) 3347, 10183},
    {0, NULL, 0},
    {0, NULL, 0},
    {31634, (void *) 6319, 0},
    {13129, (void *) 1159, 0},
    {13130, (void *) 1173, 9527},
    {31637, (void *) 4048, 0},
    {0, NULL, 0},
    {13133, (void *) 1162, 9366},
    {31640, (void *) 6313, 0},
    {31641, (void *) 6322, 0},
    {31642, (void *) 6317, 0},
    {13137, (void *) 1167, 0},
    {31644, (void *) 6316, 0},
    {31645, (void *) 6312, 0},
    {31646, (void *) 8503, 11220},
    {31647, (void *) 6314, 0},
    {0, NULL, 0},
    {13143, (void *) 1168, 9302},
    {0, NULL, 0},
    {0, NULL, 0},
    {22399, (void *) 4813, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22402, (void *) 2885, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31658, (void *) 3224, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31661, (void *) 3006, 9792},
    {22409, (void *) 4814, 0},
    {0, NULL, 0},
    {22411, (void *) 2098, 0},
    {31665, (void *) 3667, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31668, (void *) 6327, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31672, (void *) 3669, 9794},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31680, (void *) 2978, 0},
    {31681, (void *) 6324, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31684, (void *) 3712, 0},
    {13179, (void *) 1190, 9795},
    {13180, (void *) 1206, 10186},
    {13181, (void *) 1205, 9337},
    {13182, (void *) 1204, 9293},
    {31689, (void *) 3254, 9797},
    {0, NULL, 0},
    {31691, (void *) 6323, 0},
    {31692, (void *) 6325, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22442, (void *) 4819, 10185},
    {0, NULL, 0},
    {22444, (void *) 8331, 11048},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22448, (void *) 4820, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {13198, (void *) 1178, 9796},
    {13199, (void *) 1179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31709, (void *) 6329, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31712, (void *) 2573, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31716, (void *) 3515, 0},
    {22464, (void *) 4810, 10188},
    {13212, (void *) 1175, 10187},
    {13213, (void *) 1176, 0},
    {13214, (void *) 1177, 9798},
    {31721, (void *) 6330, 0},
    {0, NULL, 0},
    {13217, (void *) 1181, 9799},
    {22471, (void *) 8333, 11050},
    {31725, (void *) 4345, 10826},
    {0, NULL, 0},
    {0, NULL, 0},
    {22475, (void *) 4015, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22478, (void *) 2800, 10189},
    {0, NULL, 0},
    {0, NULL, 0},
    {31734, (void *) 6343, 0},
    {22482, (void *) 4824, 10190},
    {22483, (void *) 4825, 0},
    {22484, (void *) 4823, 0},
    {0, NULL, 0},
    {22486, (void *) 4827, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31744, (void *) 6336, 0},
    {22492, (void *) 3595, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22495, (void *) 1481, 0},
    {22496, (void *) 3813, 0},
    {0, NULL, 0},
    {31751, (void *) 6337, 0},
    {22499, (void *) 4828, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31757, (void *) 6342, 0},
    {13252, (void *) 1180, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31761, (void *) 6331, 0},
    {31762, (void *) 4658, 0},
    {31763, (void *) 6338, 0},
    {31764, (void *) 6332, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {13261, (void *) 1194, 10191},
    {0, NULL, 0},
    {22516, (void *) 2818, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22519, (void *) 2562, 0},
    {0, NULL, 0},
    {22521, (void *) 3632, 0},
    {22522, (void *) 1865, 10194},
    {0, NULL, 0},
    {31777, (void *) 1827, 9356},
    {0, NULL, 0},
    {31779, (void *) 6344, 0},
    {0, NULL, 0},
    {22528, (void *) 4004, 0},
    {0, NULL, 0},
    {22530, (void *) 3495, 10192},
    {0, NULL, 0},
    {0, NULL, 0},
    {22533, (void *) 2155, 10193},
    {22534, (void *) 3148, 10195},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22538, (void *) 4826, 0},
    {22539, (void *) 4829, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31799, (void *) 6348, 0},
    {31800, (void *) 3751, 0},
    {0, NULL, 0},
    {22549, (void *) 3137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31805, (void *) 6350, 0},
    {31806, (void *) 4321, 9800},
    {31807, (void *) 3930, 0},
    {31808, (void *) 6355, 0},
    {0, NULL, 0},
    {22557, (void *) 4831, 0},
    {31811, (void *) 6352, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22561, (void *) 4833, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22564, (void *) 3362, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31820, (void *) 6351, 0},
    {31821, (void *) 2963, 0},
    {0, NULL, 0},
    {22570, (void *) 1799, 10196},
    {31824, (void *) 6356, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31828, (void *) 6353, 10794},
    {22576, (void *) 1568, 0},
    {22577, (void *) 3936, 10198},
    {0, NULL, 0},
    {31832, (void *) 6357, 0},
    {22580, (void *) 2801, 0},
    {22581, (void *) 3423, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22586, (void *) 2419, 10197},
    {31840, (void *) 6335, 0},
    {0, NULL, 0},
    {22589, (void *) 4839, 0},
    {0, NULL, 0},
    {31844, (void *) 6359, 0},
    {22592, (void *) 3882, 10199},
    {22593, (void *) 4290, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31852, (void *) 6362, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22602, (void *) 1681, 0},
    {22603, (void *) 4835, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31859, (void *) 3891, 0},
    {0, NULL, 0},
    {31861, (void *) 6363, 0},
    {22609, (void *) 3033, 0},
    {22610, (void *) 4838, 0},
    {0, NULL, 0},
    {22612, (void *) 3450, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22615, (void *) 3424, 0},
    {22616, (void *) 3451, 0},
    {22617, (void *) 3690, 9623},
    {22618, (void *) 3334, 0},
    {0, NULL, 0},
    {31873, (void *) 2019, 0},
    {31874, (void *) 2076, 0},
    {22622, (void *) 2390, 10200},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22626, (void *) 4834, 0},
    {0, NULL, 0},
    {31881, (void *) 3873, 0},
    {0, NULL, 0},
    {31883, (void *) 2891, 0},
    {0, NULL, 0},
    {31885, (void *) 4057, 0},
    {22633, (void *) 1589, 0},
    {0, NULL, 0},
    {22635, (void *) 3405, 10201},
    {0, NULL, 0},
    {31890, (void *) 4248, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31893, (void *) 3655, 9802},
    {0, NULL, 0},
    {31895, (void *) 3045, 9801},
    {31896, (void *) 3591, 0},
    {0, NULL, 0},
    {22645, (void *) 2867, 0},
    {31899, (void *) 2676, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22649, (void *) 4840, 0},
    {31903, (void *) 1441, 0},
    {0, NULL, 0},
    {31905, (void *) 6370, 0},
    {31906, (void *) 6368, 0},
    {22654, (void *) 2677, 0},
    {31908, (void *) 6366, 0},
    {31909, (void *) 1786, 0},
    {0, NULL, 0},
    {31911, (void *) 2774, 0},
    {22659, (void *) 1986, 10202},
    {0, NULL, 0},
    {22661, (void *) 4841, 0},
    {31915, (void *) 6369, 0},
    {0, NULL, 0},
    {31917, (void *) 6367, 0},
    {31918, (void *) 6375, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31921, (void *) 6374, 0},
    {31922, (void *) 6373, 0},
    {31923, (void *) 6372, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22675, (void *) 3925, 0},
    {31929, (void *) 6376, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22679, (void *) 3100, 0},
    {31933, (void *) 6377, 0},
    {31934, (void *) 2939, 0},
    {0, NULL, 0},
    {31936, (void *) 6378, 0},
    {22684, (void *) 3327, 0},
    {31938, (void *) 6380, 0},
    {22686, (void *) 8336, 11053},
    {22687, (void *) 4843, 0},
    {31941, (void *) 6379, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31946, (void *) 2211, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22696, (void *) 3994, 0},
    {31950, (void *) 3031, 0},
    {0, NULL, 0},
    {22699, (void *) 4844, 0},
    {0, NULL, 0},
    {31954, (void *) 6382, 0},
    {22702, (void *) 4849, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31958, (void *) 3475, 0},
    {22706, (void *) 8337, 11054},
    {22707, (void *) 3868, 10203},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {31964, (void *) 6383, 0},
    {22712, (void *) 4848, 0},
    {31966, (void *) 3874, 9803},
    {31967, (void *) 3083, 9804},
    {31968, (void *) 2294, 9805},
    {0, NULL, 0},
    {31970, (void *) 6384, 0},
    {22718, (void *) 2355, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22721, (void *) 3894, 0},
    {31975, (void *) 4269, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22725, (void *) 4850, 0},
    {0, NULL, 0},
    {22727, (void *) 3232, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22730, (void *) 1682, 10204},
    {0, NULL, 0},
    {22732, (void *) 2802, 0},
    {31986, (void *) 6387, 0},
    {0, NULL, 0},
    {31988, (void *) 6388, 0},
    {0, NULL, 0},
    {22737, (void *) 4852, 10205},
    {0, NULL, 0},
    {31992, (void *) 2512, 9806},
    {0, NULL, 0},
    {22741, (void *) 2327, 10206},
    {31995, (void *) 2114, 0},
    {22743, (void *) 4853, 0},
    {22744, (void *) 4855, 0},
    {31998, (void *) 1953, 9807},
    {0, NULL, 0},
    {32000, (void *) 1889, 0},
    {22748, (void *) 4857, 0},
    {32002, (void *) 6392, 0},
    {22750, (void *) 4846, 0},
    {32004, (void *) 4124, 9808},
    {32005, (void *) 2295, 0},
    {32006, (void *) 6391, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22756, (void *) 4858, 0},
    {22757, (void *) 4856, 10209},
    {32011, (void *) 4111, 0},
    {0, NULL, 0},
    {32013, (void *) 3599, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22763, (void *) 2489, 9553},
    {22764, (void *) 2868, 0},
    {0, NULL, 0},
    {22766, (void *) 3059, 0},
    {32020, (void *) 2698, 9809},
    {22768, (void *) 2941, 10208},
    {22769, (void *) 1486, 0},
    {32023, (void *) 2588, 9525},
    {32024, (void *) 2296, 0},
    {32025, (void *) 2513, 0},
    {32026, (void *) 1952, 0},
    {32027, (void *) 3875, 0},
    {22775, (void *) 3348, 10207},
    {0, NULL, 0},
    {22777, (void *) 4862, 0},
    {22778, (void *) 4861, 0},
    {32032, (void *) 3046, 9810},
    {32033, (void *) 3981, 9811},
    {32034, (void *) 2436, 9812},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22786, (void *) 4866, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32043, (void *) 2514, 0},
    {32044, (void *) 3350, 0},
    {0, NULL, 0},
    {22793, (void *) 3902, 10210},
    {32047, (void *) 4292, 9813},
    {32048, (void *) 2406, 10828},
    {0, NULL, 0},
    {32050, (void *) 6399, 0},
    {32051, (void *) 2853, 0},
    {22799, (void *) 1635, 0},
    {22800, (void *) 4868, 10212},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32057, (void *) 2775, 0},
    {32058, (void *) 2365, 9639},
    {22806, (void *) 1707, 0},
    {0, NULL, 0},
    {22808, (void *) 4646, 0},
    {22809, (void *) 2671, 0},
    {22810, (void *) 3132, 10211},
    {22811, (void *) 4869, 0},
    {22812, (void *) 4116, 0},
    {32066, (void *) 2641, 0},
    {32067, (void *) 2191, 0},
    {32068, (void *) 3047, 0},
    {32069, (void *) 6396, 0},
    {32070, (void *) 6402, 0},
    {22818, (void *) 4061, 0},
    {32072, (void *) 8505, 11222},
    {0, NULL, 0},
    {22821, (void *) 4871, 0},
    {32075, (void *) 6397, 0},
    {32076, (void *) 2115, 9454},
    {0, NULL, 0},
    {22825, (void *) 3406, 10215},
    {22826, (void *) 3133, 10217},
    {32080, (void *) 2142, 9563},
    {22828, (void *) 4872, 0},
    {22829, (void *) 4873, 0},
    {22830, (void *) 1594, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22833, (void *) 2563, 10214},
    {22834, (void *) 4874, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32091, (void *) 6413, 0},
    {22839, (void *) 1457, 10892},
    {22840, (void *) 4875, 0},
    {32094, (void *) 2297, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32097, (void *) 4212, 0},
    {32098, (void *) 1437, 0},
    {22846, (void *) 4876, 10218},
    {0, NULL, 0},
    {0, NULL, 0},
    {32102, (void *) 1954, 0},
    {0, NULL, 0},
    {32104, (void *) 6407, 0},
    {22852, (void *) 1569, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22855, (void *) 1866, 0},
    {22856, (void *) 3541, 0},
    {22857, (void *) 3937, 10216},
    {0, NULL, 0},
    {0, NULL, 0},
    {32113, (void *) 3476, 0},
    {32114, (void *) 6406, 0},
    {22862, (void *) 4880, 10213},
    {22863, (void *) 3060, 0},
    {32117, (void *) 1699, 9814},
    {22865, (void *) 2099, 9437},
    {0, NULL, 0},
    {22867, (void *) 8339, 11056},
    {32121, (void *) 2169, 9595},
    {22869, (void *) 4878, 0},
    {0, NULL, 0},
    {22871, (void *) 3452, 0},
    {22872, (void *) 4882, 10221},
    {0, NULL, 0},
    {22874, (void *) 4881, 0},
    {22875, (void *) 8340, 11057},
    {0, NULL, 0},
    {22877, (void *) 8341, 11058},
    {0, NULL, 0},
    {0, NULL, 0},
    {22880, (void *) 4884, 0},
    {0, NULL, 0},
    {22882, (void *) 4883, 0},
    {22883, (void *) 8342, 11059},
    {32137, (void *) 6412, 0},
    {22885, (void *) 1595, 0},
    {0, NULL, 0},
    {22887, (void *) 4885, 0},
    {22888, (void *) 2734, 0},
    {22889, (void *) 4887, 0},
    {22890, (void *) 3200, 10220},
    {0, NULL, 0},
    {22892, (void *) 4886, 0},
    {0, NULL, 0},
    {22894, (void *) 3872, 10219},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22899, (void *) 2718, 0},
    {32153, (void *) 2116, 9496},
    {32154, (void *) 3120, 0},
    {32155, (void *) 6416, 0},
    {32156, (void *) 3085, 0},
    {22904, (void *) 4888, 0},
    {0, NULL, 0},
    {32159, (void *) 6429, 0},
    {32160, (void *) 8508, 11225},
    {0, NULL, 0},
    {22909, (void *) 2260, 10223},
    {32163, (void *) 6419, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {22913, (void *) 4889, 0},
    {22914, (void *) 3572, 0},
    {22915, (void *) 3727, 0},
    {22916, (void *) 4090, 0},
    {0, NULL, 0},
    {32171, (void *) 6423, 0},
    {32172, (void *) 2627, 0},
    {32173, (void *) 1470, 0},
    {32174, (void *) 6418, 0},
    {22922, (void *) 3576, 10224},
    {32176, (void *) 6430, 0},
    {32177, (void *) 2298, 0},
    {32178, (void *) 4095, 9816},
    {0, NULL, 0},
    {32180, (void *) 3343, 0},
    {32181, (void *) 6420, 0},
    {0, NULL, 0},
    {32183, (void *) 8507, 11224},
    {22931, (void *) 1903, 10225},
    {0, NULL, 0},
    {32186, (void *) 6417, 0},
    {32187, (void *) 3225, 9640},
    {0, NULL, 0},
    {32189, (void *) 6422, 0},
    {32190, (void *) 1438, 9609},
    {32191, (void *) 4083, 0},
    {22939, (void *) 4993, 0},
    {0, NULL, 0},
    {22941, (void *) 4890, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32199, (void *) 6421, 0},
    {22947, (void *) 4893, 0},
    {22948, (void *) 8343, 11060},
    {32202, (void *) 2032, 9450},
    {32203, (void *) 3741, 0},
    {0, NULL, 0},
    {22952, (void *) 3971, 0},
    {0, NULL, 0},
    {32207, (void *) 3084, 0},
    {0, NULL, 0},
    {22956, (void *) 3425, 9659},
    {32210, (void *) 2710, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32213, (void *) 6469, 0},
    {32214, (void *) 8509, 11226},
    {22962, (void *) 4894, 0},
    {32216, (void *) 6431, 0},
    {0, NULL, 0},
    {32218, (void *) 3007, 0},
    {0, NULL, 0},
    {32220, (void *) 6427, 0},
    {32221, (void *) 6432, 0},
    {22969, (void *) 4016, 10226},
    {22970, (void *) 8344, 11061},
    {22971, (void *) 2391, 9487},
    {32225, (void *) 6437, 0},
    {0, NULL, 0},
    {22974, (void *) 2735, 0},
    {32228, (void *) 6433, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32232, (void *) 3905, 0},
    {32233, (void *) 1828, 0},
    {0, NULL, 0},
    {22982, (void *) 4895, 0},
    {32236, (void *) 4084, 0},
    {0, NULL, 0},
    {22985, (void *) 2491, 0},
    {32239, (void *) 1471, 0},
    {22987, (void *) 2490, 0},
    {0, NULL, 0},
    {32242, (void *) 6436, 0},
    {0, NULL, 0},
    {32244, (void *) 4322, 0},
    {22992, (void *) 1434, 0},
    {22993, (void *) 2201, 0},
    {0, NULL, 0},
    {22995, (void *) 2924, 0},
    {22996, (void *) 1458, 0},
    {0, NULL, 0},
    {32251, (void *) 6435, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23001, (void *) 4899, 0},
    {23002, (void *) 4900, 0},
    {0, NULL, 0},
    {32257, (void *) 1582, 9815},
    {0, NULL, 0},
    {0, NULL, 0},
    {32260, (void *) 3553, 0},
    {32261, (void *) 6438, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32265, (void *) 6445, 0},
    {23013, (void *) 1527, 10227},
    {23014, (void *) 1800, 10228},
    {0, NULL, 0},
    {23016, (void *) 4896, 0},
    {0, NULL, 0},
    {23018, (void *) 4078, 0},
    {23019, (void *) 3776, 0},
    {0, NULL, 0},
    {32274, (void *) 6442, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23030, (void *) 1417, 9529},
    {0, NULL, 0},
    {0, NULL, 0},
    {32286, (void *) 2579, 0},
    {32287, (void *) 6444, 0},
    {23035, (void *) 1498, 0},
    {32289, (void *) 6441, 0},
    {32290, (void *) 6447, 0},
    {32291, (void *) 6440, 0},
    {23039, (void *) 2492, 0},
    {0, NULL, 0},
    {23041, (void *) 1459, 9392},
    {0, NULL, 0},
    {23043, (void *) 1412, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32299, (void *) 3952, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32302, (void *) 2675, 9819},
    {0, NULL, 0},
    {0, NULL, 0},
    {32305, (void *) 6443, 0},
    {32306, (void *) 6455, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32309, (void *) 6451, 0},
    {23057, (void *) 4903, 0},
    {32311, (void *) 6454, 0},
    {0, NULL, 0},
    {32313, (void *) 6452, 0},
    {32314, (void *) 6456, 0},
    {32315, (void *) 6450, 0},
    {0, NULL, 0},
    {23064, (void *) 4069, 10222},
    {32318, (void *) 2964, 0},
    {23066, (void *) 4906, 0},
    {0, NULL, 0},
    {32321, (void *) 3708, 9818},
    {0, NULL, 0},
    {32323, (void *) 6453, 0},
    {23071, (void *) 4902, 0},
    {23072, (void *) 2836, 0},
    {32326, (void *) 6448, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32330, (void *) 3008, 9817},
    {32331, (void *) 2117, 0},
    {0, NULL, 0},
    {32333, (void *) 2642, 0},
    {23081, (void *) 3911, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32338, (void *) 8510, 11227},
    {0, NULL, 0},
    {23087, (void *) 2229, 9413},
    {32341, (void *) 3029, 0},
    {32342, (void *) 6459, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32345, (void *) 6461, 0},
    {23093, (void *) 4910, 10230},
    {23094, (void *) 4911, 0},
    {0, NULL, 0},
    {32349, (void *) 6458, 0},
    {32350, (void *) 6460, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23100, (void *) 2736, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23104, (void *) 4907, 0},
    {23105, (void *) 4335, 10229},
    {32359, (void *) 6457, 0},
    {0, NULL, 0},
    {32361, (void *) 6465, 0},
    {32362, (void *) 6464, 0},
    {23110, (void *) 3615, 0},
    {0, NULL, 0},
    {32365, (void *) 4037, 0},
    {23113, (void *) 4909, 0},
    {0, NULL, 0},
    {32368, (void *) 2078, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32377, (void *) 6463, 0},
    {0, NULL, 0},
    {32379, (void *) 6467, 0},
    {32380, (void *) 6466, 0},
    {32381, (void *) 6470, 0},
    {0, NULL, 0},
    {23130, (void *) 2356, 10232},
    {0, NULL, 0},
    {0, NULL, 0},
    {32386, (void *) 2471, 0},
    {32387, (void *) 6468, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23138, (void *) 4912, 0},
    {32392, (void *) 6473, 0},
    {32393, (void *) 6474, 0},
    {32394, (void *) 8272, 10989},
    {23142, (void *) 3815, 0},
    {32396, (void *) 6475, 0},
    {0, NULL, 0},
    {32398, (void *) 6481, 0},
    {32399, (void *) 3410, 9820},
    {32400, (void *) 6477, 0},
    {23148, (void *) 4908, 0},
    {32402, (void *) 6476, 0},
    {32403, (void *) 6478, 0},
    {32404, (void *) 6479, 0},
    {0, NULL, 0},
    {32406, (void *) 6480, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32411, (void *) 6482, 0},
    {32412, (void *) 6483, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23167, (void *) 4068, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23186, (void *) 3633, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23194, (void *) 4914, 0},
    {23195, (void *) 3777, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23228, (void *) 4915, 0},
    {23229, (void *) 4919, 0},
    {23230, (void *) 4916, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23233, (void *) 1636, 0},
    {23234, (void *) 4918, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23241, (void *) 2564, 0},
    {0, NULL, 0},
    {23243, (void *) 4917, 0},
    {23244, (void *) 2156, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23248, (void *) 4931, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23254, (void *) 4924, 0},
    {23255, (void *) 4921, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23265, (void *) 3263, 0},
    {0, NULL, 0},
    {23267, (void *) 4920, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23270, (void *) 4922, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23273, (void *) 4923, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23290, (void *) 4925, 0},
    {23291, (void *) 4926, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23305, (void *) 1867, 0},
    {0, NULL, 0},
    {23307, (void *) 4928, 0},
    {23308, (void *) 4927, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32566, (void *) 1829, 0},
    {0, NULL, 0},
    {32568, (void *) 6484, 0},
    {0, NULL, 0},
    {32570, (void *) 6485, 0},
    {23318, (void *) 4929, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32581, (void *) 6486, 0},
    {0, NULL, 0},
    {23330, (void *) 2803, 10893},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32588, (void *) 6487, 0},
    {32589, (void *) 6488, 0},
    {32590, (void *) 6489, 0},
    {23338, (void *) 4932, 0},
    {32592, (void *) 6490, 0},
    {23340, (void *) 3349, 10233},
    {0, NULL, 0},
    {0, NULL, 0},
    {32596, (void *) 6493, 0},
    {23344, (void *) 1540, 10234},
    {0, NULL, 0},
    {23346, (void *) 4930, 0},
    {32600, (void *) 6494, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23350, (void *) 4933, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32607, (void *) 6495, 0},
    {32608, (void *) 6496, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23358, (void *) 4934, 0},
    {0, NULL, 0},
    {23360, (void *) 4937, 0},
    {0, NULL, 0},
    {32615, (void *) 6499, 0},
    {23363, (void *) 4935, 10235},
    {32617, (void *) 6498, 0},
    {32618, (void *) 2414, 9821},
    {32619, (void *) 2118, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32622, (void *) 3249, 0},
    {0, NULL, 0},
    {32624, (void *) 3684, 0},
    {0, NULL, 0},
    {32626, (void *) 2711, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23376, (void *) 2493, 9523},
    {23377, (void *) 4938, 0},
    {32631, (void *) 3742, 0},
    {32632, (void *) 6500, 0},
    {23380, (void *) 2261, 9858},
    {23381, (void *) 4939, 0},
    {23382, (void *) 8345, 11062},
    {23383, (void *) 2533, 0},
    {23384, (void *) 3125, 0},
    {0, NULL, 0},
    {23386, (void *) 4940, 0},
    {23387, (void *) 4941, 0},
    {23388, (void *) 2501, 0},
    {23389, (void *) 2262, 10236},
    {32643, (void *) 6503, 0},
    {23391, (void *) 4091, 0},
    {32645, (void *) 4204, 0},
    {32646, (void *) 6502, 0},
    {32647, (void *) 6505, 0},
    {23395, (void *) 1887, 10237},
    {23396, (void *) 2202, 0},
    {32650, (void *) 4186, 9822},
    {23398, (void *) 1747, 0},
    {32652, (void *) 6506, 0},
    {0, NULL, 0},
    {32654, (void *) 3759, 9823},
    {0, NULL, 0},
    {23403, (void *) 3126, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32660, (void *) 6507, 0},
    {23408, (void *) 4944, 0},
    {23409, (void *) 4984, 0},
    {0, NULL, 0},
    {23411, (void *) 4945, 0},
    {0, NULL, 0},
    {23413, (void *) 4946, 10239},
    {0, NULL, 0},
    {0, NULL, 0},
    {23416, (void *) 4947, 10238},
    {32670, (void *) 6508, 0},
    {23418, (void *) 4949, 0},
    {0, NULL, 0},
    {32673, (void *) 8512, 11229},
    {0, NULL, 0},
    {32675, (void *) 6511, 0},
    {32676, (void *) 2085, 0},
    {23424, (void *) 4950, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32680, (void *) 3009, 9824},
    {32681, (void *) 1912, 0},
    {23429, (void *) 3181, 0},
    {0, NULL, 0},
    {23431, (void *) 1510, 0},
    {23432, (void *) 2610, 0},
    {23433, (void *) 1443, 10241},
    {32687, (void *) 6512, 0},
    {23435, (void *) 3062, 0},
    {23436, (void *) 1801, 0},
    {23437, (void *) 2558, 10240},
    {0, NULL, 0},
    {23439, (void *) 2263, 0},
    {0, NULL, 0},
    {32694, (void *) 6516, 0},
    {0, NULL, 0},
    {32696, (void *) 6517, 0},
    {32697, (void *) 6514, 0},
    {23445, (void *) 3453, 0},
    {0, NULL, 0},
    {23447, (void *) 2632, 0},
    {32701, (void *) 1512, 9300},
    {23449, (void *) 3267, 0},
    {23450, (void *) 3363, 0},
    {23451, (void *) 1433, 0},
    {32705, (void *) 1604, 9307},
    {23453, (void *) 3938, 0},
    {0, NULL, 0},
    {23455, (void *) 2571, 0},
    {32709, (void *) 6519, 0},
    {32710, (void *) 6520, 0},
    {23458, (void *) 1929, 0},
    {23459, (void *) 2988, 0},
    {23460, (void *) 2565, 0},
    {23461, (void *) 4143, 10242},
    {23462, (void *) 4952, 0},
    {32716, (void *) 4201, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32722, (void *) 2643, 0},
    {23470, (void *) 1939, 0},
    {32724, (void *) 6523, 0},
    {23472, (void *) 2392, 10243},
    {0, NULL, 0},
    {0, NULL, 0},
    {23475, (void *) 1709, 0},
    {23476, (void *) 1570, 0},
    {23477, (void *) 2737, 0},
    {23478, (void *) 1637, 0},
    {0, NULL, 0},
    {23480, (void *) 4953, 0},
    {23481, (void *) 4173, 0},
    {0, NULL, 0},
    {32736, (void *) 2892, 0},
    {32737, (void *) 6524, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23487, (void *) 2672, 0},
    {23488, (void *) 8346, 11063},
    {32742, (void *) 6525, 0},
    {23490, (void *) 2605, 0},
    {23491, (void *) 4954, 0},
    {23492, (void *) 1868, 10244},
    {23493, (void *) 3527, 0},
    {32747, (void *) 1854, 9607},
    {23495, (void *) 4955, 0},
    {0, NULL, 0},
    {23497, (void *) 4956, 0},
    {0, NULL, 0},
    {32752, (void *) 1830, 0},
    {23500, (void *) 3816, 0},
    {0, NULL, 0},
    {32755, (void *) 6527, 0},
    {0, NULL, 0},
    {23504, (void *) 4958, 0},
    {0, NULL, 0},
    {23506, (void *) 1793, 0},
    {23507, (void *) 2060, 0},
    {23508, (void *) 4957, 10245},
    {0, NULL, 0},
    {32763, (void *) 4008, 0},
    {32764, (void *) 4202, 0},
    {23512, (void *) 8348, 11065},
    {0, NULL, 0},
    {0, NULL, 0},
    {23515, (void *) 1803, 9643},
    {32769, (void *) 4346, 0},
    {23517, (void *) 2837, 0},
    {32771, (void *) 2300, 9825},
    {23519, (void *) 2444, 10247},
    {32773, (void *) 2589, 0},
    {23521, (void *) 1638, 10246},
    {23522, (void *) 4961, 0},
    {0, NULL, 0},
    {23524, (void *) 4959, 0},
    {23525, (void *) 4963, 0},
    {23526, (void *) 4960, 10248},
    {32780, (void *) 2546, 9518},
    {23528, (void *) 5590, 0},
    {23529, (void *) 2838, 0},
    {0, NULL, 0},
    {32784, (void *) 3150, 9826},
    {23532, (void *) 8349, 11066},
    {32786, (void *) 6533, 0},
    {23534, (void *) 4261, 0},
    {0, NULL, 0},
    {32789, (void *) 2299, 9827},
    {0, NULL, 0},
    {32791, (void *) 4096, 0},
    {23539, (void *) 4967, 10249},
    {32793, (void *) 6535, 0},
    {23541, (void *) 3289, 0},
    {23542, (void *) 4966, 0},
    {32796, (void *) 6536, 0},
    {23544, (void *) 2916, 0},
    {0, NULL, 0},
    {23546, (void *) 2534, 0},
    {0, NULL, 0},
    {32801, (void *) 6537, 0},
    {0, NULL, 0},
    {23550, (void *) 3149, 0},
    {23551, (void *) 2624, 0},
    {0, NULL, 0},
    {23553, (void *) 3844, 0},
    {23554, (void *) 2989, 0},
    {32808, (void *) 6538, 0},
    {23556, (void *) 2582, 0},
    {23557, (void *) 4968, 0},
    {23558, (void *) 2738, 0},
    {23559, (void *) 4969, 0},
    {23560, (void *) 4970, 0},
    {23561, (void *) 1460, 0},
    {23562, (void *) 3127, 0},
    {23563, (void *) 2869, 0},
    {0, NULL, 0},
    {23565, (void *) 4971, 0},
    {32819, (void *) 2547, 9504},
    {23567, (void *) 2739, 0},
    {0, NULL, 0},
    {23569, (void *) 2740, 9625},
    {0, NULL, 0},
    {23571, (void *) 4972, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23574, (void *) 2990, 10251},
    {0, NULL, 0},
    {32829, (void *) 3226, 0},
    {0, NULL, 0},
    {23578, (void *) 2741, 10250},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23582, (void *) 8350, 11067},
    {0, NULL, 0},
    {23584, (void *) 4973, 0},
    {32838, (void *) 6542, 0},
    {23586, (void *) 4974, 0},
    {0, NULL, 0},
    {23588, (void *) 4105, 0},
    {32842, (void *) 6541, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23592, (void *) 4975, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23597, (void *) 2011, 10252},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23601, (void *) 2633, 9428},
    {0, NULL, 0},
    {32856, (void *) 6544, 0},
    {0, NULL, 0},
    {32858, (void *) 6545, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23608, (void *) 4976, 0},
    {32862, (void *) 3878, 9828},
    {23610, (void *) 2597, 10253},
    {23611, (void *) 2831, 0},
    {32865, (void *) 3086, 9514},
    {23613, (void *) 2871, 10254},
    {23614, (void *) 3753, 0},
    {23615, (void *) 3573, 0},
    {23616, (void *) 2014, 0},
    {23617, (void *) 4978, 0},
    {0, NULL, 0},
    {32872, (void *) 6548, 0},
    {0, NULL, 0},
    {23621, (void *) 1958, 0},
    {23622, (void *) 4979, 0},
    {0, NULL, 0},
    {23624, (void *) 2067, 0},
    {0, NULL, 0},
    {23626, (void *) 3524, 9670},
    {23627, (void *) 1613, 10257},
    {0, NULL, 0},
    {23629, (void *) 2494, 10256},
    {23630, (void *) 4980, 10255},
    {32884, (void *) 3305, 9829},
    {23632, (void *) 4982, 0},
    {23633, (void *) 2066, 10258},
    {32887, (void *) 2825, 0},
    {23635, (void *) 4981, 0},
    {32889, (void *) 6553, 0},
    {23637, (void *) 3407, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32893, (void *) 6554, 0},
    {32894, (void *) 4347, 0},
    {32895, (void *) 6555, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23646, (void *) 3117, 0},
    {32900, (void *) 6556, 0},
    {23648, (void *) 3426, 10260},
    {23649, (void *) 2577, 10259},
    {32903, (void *) 3670, 0},
    {0, NULL, 0},
    {23652, (void *) 3063, 9515},
    {23653, (void *) 4225, 0},
    {32907, (void *) 4353, 0},
    {32908, (void *) 3674, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23660, (void *) 4985, 0},
    {0, NULL, 0},
    {23662, (void *) 4986, 10262},
    {23663, (void *) 3531, 0},
    {0, NULL, 0},
    {23665, (void *) 2462, 9409},
    {0, NULL, 0},
    {32920, (void *) 3769, 0},
    {0, NULL, 0},
    {32922, (void *) 6561, 0},
    {23670, (void *) 4988, 10261},
    {0, NULL, 0},
    {32925, (void *) 1831, 0},
    {23673, (void *) 4989, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32929, (void *) 2213, 0},
    {32930, (void *) 2515, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32933, (void *) 3743, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32937, (void *) 2171, 0},
    {32938, (void *) 3982, 0},
    {0, NULL, 0},
    {32940, (void *) 6564, 0},
    {32941, (void *) 6562, 0},
    {0, NULL, 0},
    {32943, (void *) 2301, 0},
    {0, NULL, 0},
    {32945, (void *) 2302, 9830},
    {32946, (void *) 1482, 0},
    {0, NULL, 0},
    {32948, (void *) 2421, 0},
    {23696, (void *) 1869, 0},
    {23697, (void *) 4991, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23700, (void *) 4992, 0},
    {32954, (void *) 3628, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {32963, (void *) 1472, 0},
    {32964, (void *) 6569, 0},
    {0, NULL, 0},
    {23713, (void *) 1609, 9464},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23718, (void *) 8351, 11068},
    {32972, (void *) 3627, 0},
    {23720, (void *) 3034, 0},
    {23721, (void *) 1853, 9451},
    {0, NULL, 0},
    {23723, (void *) 4994, 0},
    {23724, (void *) 4049, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23729, (void *) 3151, 10266},
    {0, NULL, 0},
    {23731, (void *) 1748, 0},
    {32985, (void *) 6567, 0},
    {32986, (void *) 6570, 0},
    {23734, (void *) 4996, 10264},
    {23735, (void *) 4998, 0},
    {23736, (void *) 1848, 10265},
    {32990, (void *) 3953, 0},
    {23738, (void *) 8352, 11069},
    {23739, (void *) 4995, 0},
    {32993, (void *) 2214, 9831},
    {0, NULL, 0},
    {23742, (void *) 5000, 0},
    {32996, (void *) 1502, 0},
    {32997, (void *) 6566, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23749, (void *) 4999, 0},
    {0, NULL, 0},
    {23751, (void *) 5001, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33007, (void *) 6573, 0},
    {0, NULL, 0},
    {33009, (void *) 6574, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33012, (void *) 3502, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33016, (void *) 2000, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33020, (void *) 6585, 0},
    {33021, (void *) 3600, 0},
    {23769, (void *) 5002, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33026, (void *) 2516, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33029, (void *) 2001, 9505},
    {23777, (void *) 1987, 9430},
    {33031, (void *) 4361, 0},
    {33032, (void *) 4055, 0},
    {33033, (void *) 6572, 0},
    {33034, (void *) 2965, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23784, (void *) 1666, 0},
    {23785, (void *) 5003, 0},
    {23786, (void *) 5008, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23789, (void *) 5006, 0},
    {0, NULL, 0},
    {23791, (void *) 3940, 0},
    {23792, (void *) 3939, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33050, (void *) 1930, 10829},
    {23798, (void *) 3454, 10267},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23802, (void *) 5005, 0},
    {23803, (void *) 2683, 0},
    {0, NULL, 0},
    {23805, (void *) 5004, 0},
    {33059, (void *) 6577, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33065, (void *) 6576, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23815, (void *) 2901, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33071, (void *) 6578, 0},
    {23819, (void *) 5009, 0},
    {33073, (void *) 3201, 0},
    {0, NULL, 0},
    {23822, (void *) 2423, 9519},
    {0, NULL, 0},
    {0, NULL, 0},
    {23825, (void *) 5015, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33081, (void *) 3306, 9832},
    {23829, (void *) 5010, 0},
    {23830, (void *) 1710, 0},
    {23831, (void *) 5011, 0},
    {23832, (void *) 5020, 0},
    {23833, (void *) 5019, 10268},
    {23834, (void *) 5018, 0},
    {23835, (void *) 5014, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23839, (void *) 5013, 0},
    {0, NULL, 0},
    {33094, (void *) 6581, 0},
    {23842, (void *) 5017, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33099, (void *) 6579, 0},
    {23847, (void *) 8354, 11071},
    {0, NULL, 0},
    {33102, (void *) 2872, 9583},
    {0, NULL, 0},
    {33104, (void *) 3828, 0},
    {33105, (void *) 6584, 0},
    {0, NULL, 0},
    {33107, (void *) 6583, 0},
    {33108, (void *) 2303, 0},
    {33109, (void *) 4374, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33119, (void *) 6600, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33125, (void *) 6588, 0},
    {33126, (void *) 6589, 0},
    {23874, (void *) 8357, 11074},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33131, (void *) 2617, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33134, (void *) 6587, 0},
    {0, NULL, 0},
    {33136, (void *) 2343, 9833},
    {23884, (void *) 5021, 10269},
    {0, NULL, 0},
    {23886, (void *) 5023, 0},
    {33140, (void *) 6590, 0},
    {23888, (void *) 4217, 0},
    {0, NULL, 0},
    {23890, (void *) 5022, 0},
    {33144, (void *) 3307, 10830},
    {33145, (void *) 3855, 0},
    {33146, (void *) 3010, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33151, (void *) 3161, 0},
    {33152, (void *) 6594, 0},
    {23900, (void *) 5012, 0},
    {33154, (void *) 6595, 0},
    {33155, (void *) 6591, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33160, (void *) 6592, 0},
    {0, NULL, 0},
    {33162, (void *) 6593, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23913, (void *) 2902, 0},
    {33167, (void *) 2304, 0},
    {0, NULL, 0},
    {23916, (void *) 5025, 0},
    {23917, (void *) 8358, 11075},
    {33171, (void *) 6601, 0},
    {23919, (void *) 2372, 0},
    {33173, (void *) 6597, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23923, (void *) 5026, 0},
    {0, NULL, 0},
    {33178, (void *) 3829, 0},
    {23926, (void *) 5027, 0},
    {33180, (void *) 4023, 0},
    {33181, (void *) 3767, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33184, (void *) 6596, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33187, (void *) 6599, 0},
    {33188, (void *) 6598, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23938, (void *) 5030, 0},
    {33192, (void *) 3983, 0},
    {23940, (void *) 5029, 10270},
    {0, NULL, 0},
    {0, NULL, 0},
    {23943, (void *) 5028, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23947, (void *) 3455, 10271},
    {23948, (void *) 5007, 0},
    {0, NULL, 0},
    {33203, (void *) 3030, 0},
    {0, NULL, 0},
    {23952, (void *) 5036, 10272},
    {0, NULL, 0},
    {0, NULL, 0},
    {33208, (void *) 6606, 0},
    {0, NULL, 0},
    {33210, (void *) 6610, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33213, (void *) 6607, 0},
    {33214, (void *) 6605, 0},
    {33215, (void *) 3602, 0},
    {33216, (void *) 6608, 0},
    {0, NULL, 0},
    {23965, (void *) 5032, 10273},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33222, (void *) 1615, 0},
    {23970, (void *) 5031, 0},
    {33224, (void *) 6616, 0},
    {33225, (void *) 6611, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33229, (void *) 6612, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {23980, (void *) 5033, 10274},
    {0, NULL, 0},
    {33235, (void *) 3102, 9834},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33240, (void *) 6615, 0},
    {33241, (void *) 6614, 0},
    {33242, (void *) 6617, 0},
    {0, NULL, 0},
    {23991, (void *) 5037, 0},
    {23992, (void *) 8359, 11076},
    {23993, (void *) 8360, 11077},
    {23994, (void *) 4299, 10275},
    {33248, (void *) 6619, 0},
    {23996, (void *) 5038, 0},
    {23997, (void *) 5035, 0},
    {33251, (void *) 2854, 0},
    {0, NULL, 0},
    {33253, (void *) 1670, 0},
    {0, NULL, 0},
    {33255, (void *) 6620, 0},
    {33256, (void *) 4284, 0},
    {0, NULL, 0},
    {33258, (void *) 2548, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33261, (void *) 2644, 0},
    {24009, (void *) 5039, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24012, (void *) 1849, 0},
    {24013, (void *) 5040, 0},
    {33267, (void *) 2517, 0},
    {33268, (void *) 3250, 0},
    {24016, (void *) 8361, 11078},
    {0, NULL, 0},
    {24018, (void *) 5042, 0},
    {24019, (void *) 5041, 0},
    {0, NULL, 0},
    {33274, (void *) 6621, 0},
    {24022, (void *) 5043, 10276},
    {33276, (void *) 1520, 0},
    {0, NULL, 0},
    {33278, (void *) 6623, 0},
    {0, NULL, 0},
    {24027, (void *) 5044, 0},
    {33281, (void *) 6624, 0},
    {24029, (void *) 2991, 10277},
    {24030, (void *) 2634, 0},
    {0, NULL, 0},
    {33285, (void *) 6626, 0},
    {24033, (void *) 2699, 0},
    {33287, (void *) 6627, 0},
    {33288, (void *) 2002, 9446},
    {33289, (void *) 5367, 0},
    {24037, (void *) 2264, 10278},
    {24038, (void *) 2373, 0},
    {24039, (void *) 2265, 9438},
    {24040, (void *) 1959, 10279},
    {33294, (void *) 2580, 0},
    {0, NULL, 0},
    {24043, (void *) 5045, 10280},
    {0, NULL, 0},
    {33298, (void *) 4433, 0},
    {24046, (void *) 2374, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24049, (void *) 2203, 10281},
    {33303, (void *) 3915, 9835},
    {33304, (void *) 1845, 9606},
    {24052, (void *) 3606, 0},
    {24053, (void *) 5047, 0},
    {33307, (void *) 3011, 0},
    {24055, (void *) 2266, 9393},
    {0, NULL, 0},
    {33310, (void *) 3840, 0},
    {33311, (void *) 2645, 0},
    {24059, (void *) 1797, 0},
    {0, NULL, 0},
    {24061, (void *) 3202, 0},
    {24062, (void *) 2023, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24066, (void *) 2495, 0},
    {24067, (void *) 3818, 0},
    {33321, (void *) 6632, 0},
    {33322, (void *) 2305, 0},
    {24070, (void *) 3698, 10282},
    {33324, (void *) 3709, 0},
    {0, NULL, 0},
    {33326, (void *) 6647, 0},
    {0, NULL, 0},
    {24075, (void *) 5048, 0},
    {24076, (void *) 1870, 0},
    {0, NULL, 0},
    {33331, (void *) 6635, 0},
    {0, NULL, 0},
    {33333, (void *) 3142, 0},
    {33334, (void *) 3656, 9836},
    {33335, (void *) 2192, 0},
    {33336, (void *) 6634, 0},
    {33337, (void *) 3012, 0},
    {0, NULL, 0},
    {24086, (void *) 3290, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24089, (void *) 5050, 0},
    {24090, (void *) 5049, 0},
    {24091, (void *) 5052, 10283},
    {0, NULL, 0},
    {24093, (void *) 3364, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33351, (void *) 3379, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24101, (void *) 2886, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24107, (void *) 2496, 0},
    {0, NULL, 0},
    {24109, (void *) 2955, 0},
    {0, NULL, 0},
    {24111, (void *) 3152, 0},
    {24112, (void *) 1881, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24115, (void *) 3291, 10284},
    {33369, (void *) 6637, 0},
    {33370, (void *) 6640, 0},
    {24118, (void *) 5053, 0},
    {24119, (void *) 5054, 0},
    {24120, (void *) 2804, 10285},
    {0, NULL, 0},
    {33375, (void *) 6641, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24125, (void *) 3972, 10286},
    {0, NULL, 0},
    {33380, (void *) 6642, 0},
    {24128, (void *) 5057, 0},
    {33382, (void *) 1832, 0},
    {0, NULL, 0},
    {24131, (void *) 5056, 10287},
    {24132, (void *) 5055, 0},
    {24133, (void *) 3852, 10288},
    {33387, (void *) 6646, 0},
    {24135, (void *) 5064, 0},
    {0, NULL, 0},
    {33390, (void *) 2366, 0},
    {33391, (void *) 4270, 0},
    {0, NULL, 0},
    {24140, (void *) 4005, 10289},
    {33394, (void *) 2826, 0},
    {24142, (void *) 5058, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33398, (void *) 1583, 0},
    {33399, (void *) 6649, 0},
    {33400, (void *) 6650, 0},
    {24148, (void *) 5060, 0},
    {24149, (void *) 4022, 0},
    {0, NULL, 0},
    {24151, (void *) 5059, 0},
    {0, NULL, 0},
    {33406, (void *) 6651, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24159, (void *) 5061, 0},
    {0, NULL, 0},
    {24161, (void *) 3673, 0},
    {24162, (void *) 5062, 0},
    {24163, (void *) 3883, 0},
    {24164, (void *) 5063, 0},
    {0, NULL, 0},
    {33419, (void *) 1491, 0},
    {0, NULL, 0},
    {33421, (void *) 6652, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33426, (void *) 6653, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24178, (void *) 1804, 0},
    {24179, (void *) 3884, 0},
    {24180, (void *) 3586, 9567},
    {24181, (void *) 5065, 0},
    {24182, (void *) 5066, 0},
    {0, NULL, 0},
    {24184, (void *) 2267, 9379},
    {24185, (void *) 1805, 0},
    {24186, (void *) 5067, 10290},
    {24187, (void *) 2185, 0},
    {24188, (void *) 4171, 0},
    {24189, (void *) 4144, 0},
    {24190, (void *) 1871, 0},
    {24191, (void *) 5069, 0},
    {33445, (void *) 1700, 0},
    {33446, (void *) 1427, 9474},
    {0, NULL, 0},
    {24195, (void *) 2268, 0},
    {24196, (void *) 2742, 0},
    {0, NULL, 0},
    {33451, (void *) 6654, 0},
    {24199, (void *) 3728, 10292},
    {33453, (void *) 3617, 0},
    {0, NULL, 0},
    {24202, (void *) 2743, 9418},
    {0, NULL, 0},
    {33457, (void *) 1651, 0},
    {0, NULL, 0},
    {33459, (void *) 3954, 0},
    {24207, (void *) 2719, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33464, (void *) 2128, 0},
    {33465, (void *) 2033, 0},
    {24213, (void *) 3365, 0},
    {24214, (void *) 3942, 10291},
    {24215, (void *) 3408, 0},
    {33469, (void *) 1671, 0},
    {0, NULL, 0},
    {24218, (void *) 2269, 0},
    {0, NULL, 0},
    {24220, (void *) 3819, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33477, (void *) 1788, 9837},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24230, (void *) 3440, 0},
    {24231, (void *) 2383, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24235, (void *) 2204, 0},
    {33489, (void *) 1584, 0},
    {24237, (void *) 3366, 10293},
    {33491, (void *) 4303, 0},
    {33492, (void *) 3162, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33495, (void *) 3795, 0},
    {0, NULL, 0},
    {33497, (void *) 6673, 0},
    {24245, (void *) 1444, 0},
    {33499, (void *) 1652, 9397},
    {24247, (void *) 2270, 10297},
    {24248, (void *) 4174, 0},
    {33502, (void *) 6669, 0},
    {33503, (void *) 6660, 0},
    {0, NULL, 0},
    {33505, (void *) 6658, 0},
    {0, NULL, 0},
    {33507, (void *) 6659, 0},
    {0, NULL, 0},
    {33509, (void *) 2604, 0},
    {33510, (void *) 2049, 9838},
    {33511, (void *) 3282, 9839},
    {24259, (void *) 3620, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33515, (void *) 3526, 0},
    {0, NULL, 0},
    {24264, (void *) 5073, 0},
    {24265, (void *) 4316, 0},
    {24266, (void *) 4336, 0},
    {0, NULL, 0},
    {33521, (void *) 1552, 0},
    {0, NULL, 0},
    {33523, (void *) 6663, 0},
    {24271, (void *) 5075, 10294},
    {24272, (void *) 5074, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24275, (void *) 1730, 0},
    {33529, (void *) 6668, 0},
    {33530, (void *) 6664, 0},
    {24278, (void *) 5076, 10295},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24282, (void *) 5079, 0},
    {24283, (void *) 5080, 0},
    {33537, (void *) 8514, 11231},
    {33538, (void *) 4089, 9840},
    {33539, (void *) 6666, 0},
    {33540, (void *) 1653, 9556},
    {33541, (void *) 1784, 9403},
    {24289, (void *) 5082, 10296},
    {24290, (void *) 5081, 0},
    {24291, (void *) 5077, 0},
    {33545, (void *) 6672, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24296, (void *) 5083, 0},
    {33550, (void *) 2119, 9841},
    {0, NULL, 0},
    {0, NULL, 0},
    {24300, (void *) 5085, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24304, (void *) 5088, 0},
    {24305, (void *) 5086, 10300},
    {33559, (void *) 6685, 0},
    {24307, (void *) 5087, 10306},
    {24308, (void *) 5089, 0},
    {0, NULL, 0},
    {24310, (void *) 1571, 0},
    {33564, (void *) 1420, 9486},
    {24312, (void *) 5090, 0},
    {0, NULL, 0},
    {24314, (void *) 2157, 0},
    {24315, (void *) 1683, 0},
    {24316, (void *) 3593, 0},
    {0, NULL, 0},
    {24318, (void *) 5091, 10309},
    {24319, (void *) 3568, 0},
    {0, NULL, 0},
    {24321, (void *) 3912, 0},
    {0, NULL, 0},
    {33576, (void *) 1490, 9842},
    {24324, (void *) 4337, 0},
    {0, NULL, 0},
    {33579, (void *) 6684, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24329, (void *) 5093, 0},
    {24330, (void *) 3885, 10305},
    {24331, (void *) 5096, 0},
    {24332, (void *) 4418, 10302},
    {24333, (void *) 4434, 10301},
    {0, NULL, 0},
    {24335, (void *) 2553, 10299},
    {24336, (void *) 3562, 10298},
    {33590, (void *) 3262, 9843},
    {0, NULL, 0},
    {24339, (void *) 1940, 9458},
    {24340, (void *) 3293, 10304},
    {24341, (void *) 1499, 0},
    {24342, (void *) 5098, 0},
    {24343, (void *) 3859, 0},
    {24344, (void *) 2271, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24347, (void *) 3243, 10303},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24351, (void *) 3368, 0},
    {33605, (void *) 6682, 0},
    {24353, (void *) 8362, 11079},
    {0, NULL, 0},
    {0, NULL, 0},
    {33609, (void *) 3087, 0},
    {33610, (void *) 2120, 9626},
    {24358, (void *) 2186, 0},
    {24359, (void *) 2205, 0},
    {0, NULL, 0},
    {24361, (void *) 5099, 0},
    {33615, (void *) 1536, 0},
    {33616, (void *) 6681, 0},
    {0, NULL, 0},
    {33618, (void *) 2306, 9844},
    {0, NULL, 0},
    {24367, (void *) 5106, 0},
    {0, NULL, 0},
    {24369, (void *) 2606, 0},
    {0, NULL, 0},
    {33624, (void *) 3088, 0},
    {24372, (void *) 8363, 11080},
    {24373, (void *) 3294, 0},
    {0, NULL, 0},
    {24375, (void *) 1988, 0},
    {24376, (void *) 5101, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24380, (void *) 3770, 0},
    {33634, (void *) 8515, 11232},
    {24382, (void *) 3233, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24385, (void *) 5102, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24389, (void *) 8283, 11000},
    {0, NULL, 0},
    {0, NULL, 0},
    {24392, (void *) 5103, 0},
    {0, NULL, 0},
    {24394, (void *) 1989, 0},
    {0, NULL, 0},
    {24396, (void *) 5104, 0},
    {0, NULL, 0},
    {24398, (void *) 5105, 10314},
    {0, NULL, 0},
    {33653, (void *) 6700, 0},
    {24401, (void *) 5107, 0},
    {33655, (void *) 1654, 0},
    {24403, (void *) 3469, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33659, (void *) 1611, 9845},
    {24407, (void *) 5109, 10312},
    {0, NULL, 0},
    {24409, (void *) 5110, 0},
    {33663, (void *) 8516, 11233},
    {0, NULL, 0},
    {24412, (void *) 5095, 0},
    {24413, (void *) 5094, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33669, (void *) 6687, 0},
    {24417, (void *) 5111, 0},
    {24418, (void *) 2100, 10311},
    {0, NULL, 0},
    {33673, (void *) 6702, 0},
    {33674, (void *) 6696, 0},
    {24422, (void *) 3766, 0},
    {24423, (void *) 8364, 11081},
    {0, NULL, 0},
    {24425, (void *) 2393, 10310},
    {24426, (void *) 3782, 0},
    {24427, (void *) 3295, 0},
    {24428, (void *) 3802, 0},
    {24429, (void *) 5112, 0},
    {33683, (void *) 6665, 0},
    {0, NULL, 0},
    {24432, (void *) 2745, 0},
    {24433, (void *) 1541, 10308},
    {0, NULL, 0},
    {24435, (void *) 5113, 0},
    {0, NULL, 0},
    {33690, (void *) 6688, 0},
    {0, NULL, 0},
    {24439, (void *) 5114, 0},
    {0, NULL, 0},
    {33694, (void *) 1833, 9627},
    {33695, (void *) 6690, 0},
    {33696, (void *) 6701, 0},
    {24444, (void *) 3729, 0},
    {33698, (void *) 6691, 0},
    {0, NULL, 0},
    {24447, (void *) 5117, 0},
    {24448, (void *) 1596, 0},
    {24449, (void *) 2925, 0},
    {24450, (void *) 5116, 0},
    {24451, (void *) 5115, 10315},
    {24452, (void *) 2101, 0},
    {24453, (void *) 3153, 10307},
    {33707, (void *) 3663, 0},
    {24455, (void *) 5121, 0},
    {24456, (void *) 5119, 0},
    {0, NULL, 0},
    {24458, (void *) 5118, 0},
    {24459, (void *) 4236, 0},
    {24460, (void *) 2230, 9645},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24464, (void *) 2720, 10313},
    {24465, (void *) 5120, 0},
    {24466, (void *) 3427, 0},
    {24467, (void *) 2661, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24471, (void *) 3509, 0},
    {24472, (void *) 5124, 10322},
    {24473, (void *) 5123, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33729, (void *) 6712, 0},
    {0, NULL, 0},
    {24478, (void *) 5122, 0},
    {0, NULL, 0},
    {33733, (void *) 2910, 9846},
    {24481, (void *) 2231, 0},
    {33735, (void *) 8517, 11234},
    {0, NULL, 0},
    {0, NULL, 0},
    {33738, (void *) 1917, 0},
    {0, NULL, 0},
    {33740, (void *) 2034, 0},
    {24488, (void *) 5126, 0},
    {24489, (void *) 3851, 10316},
    {24490, (void *) 2690, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24493, (void *) 5127, 0},
    {33747, (void *) 1656, 9546},
    {0, NULL, 0},
    {0, NULL, 0},
    {33750, (void *) 2777, 0},
    {0, NULL, 0},
    {24499, (void *) 3510, 10318},
    {24500, (void *) 3296, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33756, (void *) 2407, 10832},
    {0, NULL, 0},
    {24505, (void *) 3399, 0},
    {33759, (void *) 3432, 0},
    {33760, (void *) 6715, 0},
    {24508, (void *) 5128, 0},
    {24509, (void *) 1890, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24515, (void *) 2839, 0},
    {33769, (void *) 3931, 0},
    {24517, (void *) 3771, 0},
    {33771, (void *) 6706, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33775, (void *) 1655, 0},
    {33776, (void *) 2215, 0},
    {24524, (void *) 1872, 9550},
    {24525, (void *) 3577, 10319},
    {0, NULL, 0},
    {33780, (void *) 6704, 0},
    {0, NULL, 0},
    {33782, (void *) 8518, 11235},
    {33783, (void *) 6713, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24534, (void *) 5129, 10324},
    {24535, (void *) 2497, 0},
    {24536, (void *) 3973, 10317},
    {24537, (void *) 3974, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24540, (void *) 1597, 0},
    {24541, (void *) 5134, 0},
    {33795, (void *) 6709, 10833},
    {33796, (void *) 3503, 0},
    {24544, (void *) 3268, 0},
    {0, NULL, 0},
    {33799, (void *) 6714, 0},
    {0, NULL, 0},
    {24548, (void *) 5131, 0},
    {0, NULL, 0},
    {33803, (void *) 6711, 0},
    {33804, (void *) 3955, 0},
    {33805, (void *) 6717, 0},
    {33806, (void *) 1473, 0},
    {0, NULL, 0},
    {24555, (void *) 1684, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33811, (void *) 6705, 0},
    {0, NULL, 0},
    {24560, (void *) 5182, 0},
    {24561, (void *) 5133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24565, (void *) 3587, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24568, (void *) 5132, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24571, (void *) 5130, 10321},
    {0, NULL, 0},
    {24573, (void *) 2345, 10320},
    {0, NULL, 0},
    {24575, (void *) 5136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33833, (void *) 3646, 0},
    {33834, (void *) 6725, 0},
    {0, NULL, 0},
    {33836, (void *) 6736, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33841, (void *) 1785, 0},
    {0, NULL, 0},
    {24590, (void *) 5142, 0},
    {24591, (void *) 5148, 0},
    {24592, (void *) 5140, 10330},
    {0, NULL, 0},
    {24594, (void *) 3443, 0},
    {33848, (void *) 6721, 0},
    {0, NULL, 0},
    {24597, (void *) 5145, 0},
    {24598, (void *) 3820, 0},
    {33852, (void *) 6726, 0},
    {33853, (void *) 4213, 0},
    {24601, (void *) 5139, 0},
    {0, NULL, 0},
    {24603, (void *) 5144, 0},
    {24604, (void *) 4300, 0},
    {24605, (void *) 2498, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24608, (void *) 3154, 0},
    {24609, (void *) 5137, 10328},
    {0, NULL, 0},
    {33864, (void *) 8519, 11236},
    {33865, (void *) 4188, 0},
    {24613, (void *) 1941, 0},
    {24614, (void *) 5147, 0},
    {24615, (void *) 2926, 0},
    {24616, (void *) 1572, 0},
    {33870, (void *) 4239, 9847},
    {24618, (void *) 1685, 0},
    {24619, (void *) 5146, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24623, (void *) 1990, 0},
    {0, NULL, 0},
    {24625, (void *) 5143, 0},
    {33879, (void *) 3283, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33883, (void *) 1766, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24634, (void *) 5149, 0},
    {0, NULL, 0},
    {33889, (void *) 3841, 0},
    {33890, (void *) 6741, 0},
    {33891, (void *) 3478, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33894, (void *) 1426, 9848},
    {24642, (void *) 5161, 0},
    {24643, (void *) 5159, 0},
    {33897, (void *) 6734, 0},
    {0, NULL, 0},
    {24646, (void *) 5156, 10327},
    {33900, (void *) 3089, 0},
    {33901, (void *) 6724, 0},
    {33902, (void *) 6732, 0},
    {24650, (void *) 5155, 10329},
    {24651, (void *) 4317, 0},
    {33905, (void *) 3583, 0},
    {24653, (void *) 5157, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33909, (void *) 1419, 9315},
    {0, NULL, 0},
    {24658, (void *) 2272, 10326},
    {0, NULL, 0},
    {33913, (void *) 6738, 0},
    {24661, (void *) 2721, 9568},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24665, (void *) 5164, 0},
    {24666, (void *) 5150, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33922, (void *) 6733, 10834},
    {0, NULL, 0},
    {24671, (void *) 5154, 10325},
    {24672, (void *) 5138, 0},
    {0, NULL, 0},
    {24674, (void *) 1687, 0},
    {24675, (void *) 5158, 0},
    {24676, (void *) 5160, 0},
    {24677, (void *) 3244, 0},
    {33931, (void *) 2778, 0},
    {0, NULL, 0},
    {24680, (void *) 2357, 0},
    {24681, (void *) 1621, 0},
    {24682, (void *) 5152, 0},
    {33936, (void *) 2646, 9850},
    {24684, (void *) 5162, 0},
    {24685, (void *) 1992, 0},
    {0, NULL, 0},
    {33940, (void *) 2549, 9448},
    {24688, (void *) 1761, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {33945, (void *) 4097, 0},
    {24693, (void *) 2102, 0},
    {0, NULL, 0},
    {33948, (void *) 3798, 9849},
    {0, NULL, 0},
    {0, NULL, 0},
    {33951, (void *) 6744, 0},
    {0, NULL, 0},
    {33953, (void *) 6753, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24705, (void *) 5165, 0},
    {0, NULL, 0},
    {24707, (void *) 5168, 0},
    {24708, (void *) 5170, 0},
    {24709, (void *) 8368, 11085},
    {0, NULL, 0},
    {0, NULL, 0},
    {33965, (void *) 6731, 0},
    {24713, (void *) 2566, 0},
    {24714, (void *) 8369, 11086},
    {24715, (void *) 5176, 0},
    {24716, (void *) 3369, 0},
    {33970, (void *) 1778, 9851},
    {0, NULL, 0},
    {33972, (void *) 8520, 11237},
    {0, NULL, 0},
    {0, NULL, 0},
    {24722, (void *) 5174, 0},
    {33976, (void *) 2813, 0},
    {24724, (void *) 1686, 10331},
    {0, NULL, 0},
    {24726, (void *) 5172, 10334},
    {33980, (void *) 3090, 9852},
    {0, NULL, 0},
    {0, NULL, 0},
    {24730, (void *) 5169, 10332},
    {24731, (void *) 5171, 0},
    {33985, (void *) 6750, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24735, (void *) 2232, 9470},
    {24736, (void *) 4145, 0},
    {33990, (void *) 6751, 0},
    {0, NULL, 0},
    {24739, (void *) 1806, 0},
    {33993, (void *) 4189, 0},
    {33994, (void *) 6740, 0},
    {24742, (void *) 1560, 9292},
    {24743, (void *) 5175, 0},
    {33997, (void *) 6746, 0},
    {24745, (void *) 3597, 0},
    {24746, (void *) 1422, 0},
    {34000, (void *) 6749, 0},
    {34001, (void *) 4053, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34006, (void *) 6752, 0},
    {24754, (void *) 3730, 0},
    {24755, (void *) 5135, 0},
    {24756, (void *) 5181, 10333},
    {24757, (void *) 5185, 10335},
    {24758, (void *) 4110, 0},
    {34012, (void *) 8276, 10993},
    {24760, (void *) 5178, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24764, (void *) 3456, 0},
    {24765, (void *) 5183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24773, (void *) 2805, 0},
    {24774, (void *) 5184, 0},
    {24775, (void *) 3532, 9584},
    {0, NULL, 0},
    {34030, (void *) 4324, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34036, (void *) 6756, 0},
    {0, NULL, 0},
    {24785, (void *) 4362, 0},
    {0, NULL, 0},
    {24787, (void *) 5180, 0},
    {0, NULL, 0},
    {24789, (void *) 8371, 11088},
    {0, NULL, 0},
    {34044, (void *) 6763, 0},
    {24792, (void *) 5186, 0},
    {0, NULL, 0},
    {24794, (void *) 2346, 10336},
    {34048, (void *) 2572, 0},
    {24796, (void *) 2956, 0},
    {0, NULL, 0},
    {24798, (void *) 8370, 11087},
    {24799, (void *) 1461, 0},
    {24800, (void *) 5179, 0},
    {24801, (void *) 5177, 10323},
    {0, NULL, 0},
    {24803, (void *) 3065, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24807, (void *) 5167, 0},
    {24808, (void *) 2463, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34065, (void *) 3899, 0},
    {0, NULL, 0},
    {34067, (void *) 4043, 0},
    {34068, (void *) 6762, 0},
    {24816, (void *) 3139, 10339},
    {24817, (void *) 5198, 0},
    {34071, (void *) 6757, 10835},
    {24819, (void *) 3066, 10337},
    {24820, (void *) 5193, 0},
    {34074, (void *) 1525, 0},
    {24822, (void *) 5190, 0},
    {24823, (void *) 5191, 0},
    {0, NULL, 0},
    {24825, (void *) 2607, 0},
    {24826, (void *) 5194, 10338},
    {24827, (void *) 5197, 0},
    {34081, (void *) 6754, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24832, (void *) 5192, 0},
    {24833, (void *) 2636, 9483},
    {0, NULL, 0},
    {24835, (void *) 5195, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24838, (void *) 5189, 0},
    {34092, (void *) 6759, 0},
    {34093, (void *) 1503, 9631},
    {24841, (void *) 4132, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24845, (void *) 5199, 0},
    {24846, (void *) 5200, 0},
    {24847, (void *) 1462, 0},
    {34101, (void *) 3103, 0},
    {24849, (void *) 8374, 11091},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24853, (void *) 5188, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34109, (void *) 3888, 0},
    {0, NULL, 0},
    {24858, (void *) 2055, 0},
    {24859, (void *) 1415, 10340},
    {34113, (void *) 6768, 0},
    {0, NULL, 0},
    {34115, (void *) 3722, 0},
    {24863, (void *) 1807, 0},
    {24864, (void *) 8372, 11089},
    {24865, (void *) 5196, 0},
    {0, NULL, 0},
    {34120, (void *) 6767, 0},
    {34121, (void *) 2779, 0},
    {34122, (void *) 2578, 0},
    {34123, (void *) 6770, 0},
    {24871, (void *) 5204, 0},
    {24872, (void *) 5203, 0},
    {34126, (void *) 2003, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24876, (void *) 5208, 0},
    {0, NULL, 0},
    {34131, (void *) 8521, 11238},
    {0, NULL, 0},
    {34133, (void *) 6771, 10836},
    {0, NULL, 0},
    {34135, (void *) 3848, 0},
    {34136, (void *) 6766, 0},
    {24884, (void *) 5209, 10895},
    {34138, (void *) 6727, 0},
    {0, NULL, 0},
    {24887, (void *) 8375, 11092},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24892, (void *) 5207, 0},
    {24893, (void *) 5210, 0},
    {24894, (void *) 5202, 10341},
    {24895, (void *) 5206, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24898, (void *) 5211, 0},
    {34152, (void *) 4370, 0},
    {34153, (void *) 3479, 9853},
    {34154, (void *) 3842, 0},
    {34155, (void *) 8523, 11240},
    {24903, (void *) 5201, 0},
    {24904, (void *) 2535, 10344},
    {0, NULL, 0},
    {24906, (void *) 5205, 0},
    {24907, (void *) 3155, 0},
    {24908, (void *) 2273, 0},
    {24909, (void *) 5187, 0},
    {24910, (void *) 2840, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34167, (void *) 6784, 0},
    {24915, (void *) 5225, 0},
    {0, NULL, 0},
    {24917, (void *) 3926, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24920, (void *) 5215, 0},
    {24921, (void *) 5216, 10349},
    {24922, (void *) 5217, 0},
    {34176, (void *) 6772, 0},
    {0, NULL, 0},
    {24925, (void *) 5224, 0},
    {0, NULL, 0},
    {34180, (void *) 3657, 9855},
    {0, NULL, 0},
    {0, NULL, 0},
    {24930, (void *) 4040, 10347},
    {24931, (void *) 1808, 10342},
    {0, NULL, 0},
    {24933, (void *) 5221, 10343},
    {0, NULL, 0},
    {24935, (void *) 2104, 0},
    {24936, (void *) 1711, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24939, (void *) 5218, 10350},
    {34193, (void *) 6775, 0},
    {0, NULL, 0},
    {24942, (void *) 4253, 0},
    {24943, (void *) 5220, 10345},
    {24944, (void *) 1463, 0},
    {24945, (void *) 5222, 0},
    {34199, (void *) 1585, 0},
    {24947, (void *) 5213, 0},
    {34201, (void *) 3546, 9854},
    {24949, (void *) 5226, 0},
    {24950, (void *) 2103, 10346},
    {24951, (void *) 5214, 10348},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24958, (void *) 4196, 0},
    {34212, (void *) 6773, 0},
    {0, NULL, 0},
    {34214, (void *) 3013, 0},
    {24962, (void *) 4146, 0},
    {34216, (void *) 6777, 0},
    {34217, (void *) 2450, 0},
    {34218, (void *) 2856, 0},
    {34219, (void *) 2083, 0},
    {34220, (void *) 4125, 9856},
    {0, NULL, 0},
    {34222, (void *) 4130, 0},
    {34223, (void *) 2713, 9857},
    {34224, (void *) 8525, 11242},
    {0, NULL, 0},
    {0, NULL, 0},
    {24974, (void *) 3101, 0},
    {0, NULL, 0},
    {24976, (void *) 4318, 0},
    {24977, (void *) 5234, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24980, (void *) 5231, 10352},
    {34234, (void *) 6788, 0},
    {24982, (void *) 5228, 0},
    {0, NULL, 0},
    {24984, (void *) 8377, 11094},
    {24985, (void *) 5227, 0},
    {24986, (void *) 5232, 0},
    {0, NULL, 0},
    {34241, (void *) 4369, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {24996, (void *) 3869, 10351},
    {0, NULL, 0},
    {0, NULL, 0},
    {24999, (void *) 3497, 0},
    {34253, (void *) 4220, 0},
    {25001, (void *) 2105, 0},
    {34255, (void *) 6789, 0},
    {25003, (void *) 5235, 10353},
    {25004, (void *) 5230, 0},
    {0, NULL, 0},
    {25006, (void *) 5236, 0},
    {0, NULL, 0},
    {34261, (void *) 6792, 0},
    {0, NULL, 0},
    {25010, (void *) 2158, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25014, (void *) 1614, 0},
    {34268, (void *) 6795, 0},
    {34269, (void *) 6793, 0},
    {0, NULL, 0},
    {25018, (void *) 5244, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25022, (void *) 1809, 0},
    {34276, (void *) 3480, 0},
    {34277, (void *) 6794, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25027, (void *) 5242, 0},
    {34281, (void *) 3710, 0},
    {34282, (void *) 6781, 0},
    {25030, (void *) 5243, 0},
    {25031, (void *) 2358, 0},
    {25032, (void *) 5241, 0},
    {25033, (void *) 5239, 0},
    {25034, (void *) 5238, 0},
    {25035, (void *) 5245, 0},
    {25036, (void *) 5237, 0},
    {25037, (void *) 5247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25040, (void *) 1688, 0},
    {0, NULL, 0},
    {34295, (void *) 2714, 0},
    {0, NULL, 0},
    {34297, (void *) 6796, 0},
    {34298, (void *) 6801, 0},
    {34299, (void *) 3091, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34302, (void *) 6800, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34306, (void *) 6769, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34310, (void *) 6802, 0},
    {34311, (void *) 3048, 0},
    {25059, (void *) 5249, 0},
    {0, NULL, 0},
    {34314, (void *) 6797, 0},
    {25062, (void *) 5248, 10354},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34323, (void *) 6798, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34326, (void *) 5656, 0},
    {25074, (void *) 3297, 9913},
    {0, NULL, 0},
    {25076, (void *) 5252, 0},
    {34330, (void *) 6804, 0},
    {25078, (void *) 5250, 0},
    {25079, (void *) 5240, 0},
    {25080, (void *) 2159, 0},
    {0, NULL, 0},
    {25082, (void *) 5251, 0},
    {0, NULL, 0},
    {25084, (void *) 5255, 0},
    {25085, (void *) 5254, 10355},
    {25086, (void *) 5256, 0},
    {25087, (void *) 5253, 0},
    {25088, (void *) 5257, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34349, (void *) 4221, 9859},
    {25097, (void *) 5259, 0},
    {25098, (void *) 3927, 10095},
    {34352, (void *) 6805, 0},
    {25100, (void *) 5261, 0},
    {25101, (void *) 5260, 0},
    {25102, (void *) 2662, 0},
    {0, NULL, 0},
    {25104, (void *) 2927, 0},
    {25105, (void *) 1667, 0},
    {25106, (void *) 1689, 0},
    {25107, (void *) 8378, 11095},
    {25108, (void *) 5262, 0},
    {0, NULL, 0},
    {25110, (void *) 1440, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25114, (void *) 2957, 10356},
    {25115, (void *) 5263, 0},
    {0, NULL, 0},
    {25117, (void *) 7084, 0},
    {25118, (void *) 5264, 0},
    {25119, (void *) 2132, 0},
    {0, NULL, 0},
    {25121, (void *) 5265, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25126, (void *) 2992, 0},
    {0, NULL, 0},
    {34381, (void *) 6807, 0},
    {34382, (void *) 2216, 0},
    {25130, (void *) 5266, 0},
    {34384, (void *) 1931, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25134, (void *) 5267, 0},
    {25135, (void *) 1905, 10357},
    {34389, (void *) 4572, 9860},
    {0, NULL, 0},
    {25138, (void *) 5269, 0},
    {25139, (void *) 5270, 0},
    {25140, (void *) 3156, 0},
    {34394, (void *) 1964, 0},
    {0, NULL, 0},
    {34396, (void *) 4255, 0},
    {25144, (void *) 2206, 0},
    {34398, (void *) 2056, 0},
    {34399, (void *) 6810, 0},
    {25147, (void *) 4106, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25151, (void *) 3975, 0},
    {25152, (void *) 2705, 0},
    {25153, (void *) 5271, 0},
    {34407, (void *) 6811, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34411, (void *) 3273, 0},
    {25159, (void *) 2993, 0},
    {25160, (void *) 7266, 0},
    {25161, (void *) 3731, 0},
    {0, NULL, 0},
    {25163, (void *) 2611, 0},
    {34417, (void *) 6812, 0},
    {25165, (void *) 2394, 0},
    {25166, (void *) 5272, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25171, (void *) 3140, 0},
    {34425, (void *) 3567, 0},
    {25173, (void *) 3860, 0},
    {34427, (void *) 1435, 0},
    {0, NULL, 0},
    {25176, (void *) 3182, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25179, (void *) 5275, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25182, (void *) 5273, 0},
    {0, NULL, 0},
    {25184, (void *) 5276, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25187, (void *) 5274, 0},
    {0, NULL, 0},
    {34442, (void *) 1664, 0},
    {34443, (void *) 6817, 0},
    {34444, (void *) 6818, 0},
    {25192, (void *) 5277, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25198, (void *) 3870, 10358},
    {0, NULL, 0},
    {34453, (void *) 2472, 0},
    {25201, (void *) 1432, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25206, (void *) 3821, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25209, (void *) 3732, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25212, (void *) 5278, 0},
    {0, NULL, 0},
    {25214, (void *) 5281, 10359},
    {25215, (void *) 2746, 9520},
    {25216, (void *) 1906, 0},
    {0, NULL, 0},
    {25218, (void *) 5279, 0},
    {25219, (void *) 5286, 0},
    {25220, (void *) 2747, 10360},
    {34474, (void *) 6816, 0},
    {34475, (void *) 6826, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25225, (void *) 5280, 0},
    {25226, (void *) 3607, 10362},
    {34480, (void *) 6823, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25233, (void *) 4197, 10361},
    {25234, (void *) 5282, 0},
    {25235, (void *) 5283, 0},
    {25236, (void *) 5287, 0},
    {25237, (void *) 3457, 0},
    {25238, (void *) 5284, 0},
    {25239, (void *) 2274, 0},
    {25240, (void *) 2975, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25243, (void *) 5301, 0},
    {25244, (void *) 3685, 0},
    {0, NULL, 0},
    {25246, (void *) 3183, 0},
    {34500, (void *) 6821, 0},
    {0, NULL, 0},
    {34502, (void *) 6822, 0},
    {34503, (void *) 2593, 0},
    {0, NULL, 0},
    {34505, (void *) 6824, 0},
    {0, NULL, 0},
    {34507, (void *) 3228, 10837},
    {0, NULL, 0},
    {34509, (void *) 2121, 0},
    {34510, (void *) 1725, 0},
    {0, NULL, 0},
    {25259, (void *) 3733, 0},
    {25260, (void *) 5370, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34516, (void *) 6827, 0},
    {0, NULL, 0},
    {25265, (void *) 3943, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34521, (void *) 1722, 0},
    {25269, (void *) 3370, 0},
    {34523, (void *) 6832, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25273, (void *) 4032, 10363},
    {34527, (void *) 6831, 0},
    {25275, (void *) 5290, 0},
    {25276, (void *) 1598, 0},
    {25277, (void *) 3269, 0},
    {0, NULL, 0},
    {34532, (void *) 3691, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25282, (void *) 5299, 0},
    {0, NULL, 0},
    {34537, (void *) 6829, 0},
    {25285, (void *) 3215, 0},
    {25286, (void *) 5293, 0},
    {25287, (void *) 5300, 10364},
    {34541, (void *) 3799, 9861},
    {34542, (void *) 3723, 9862},
    {25290, (void *) 5298, 10365},
    {0, NULL, 0},
    {25292, (void *) 5297, 0},
    {25293, (void *) 3650, 0},
    {0, NULL, 0},
    {25295, (void *) 5291, 0},
    {25296, (void *) 1690, 0},
    {25297, (void *) 5289, 0},
    {25298, (void *) 1960, 0},
    {25299, (void *) 3184, 9459},
    {25300, (void *) 5285, 10370},
    {0, NULL, 0},
    {34555, (void *) 6839, 0},
    {25303, (void *) 5288, 0},
    {25304, (void *) 2275, 0},
    {34558, (void *) 1672, 9434},
    {0, NULL, 0},
    {25307, (void *) 2748, 10368},
    {25308, (void *) 5296, 0},
    {25309, (void *) 3621, 9585},
    {34563, (void *) 6838, 0},
    {0, NULL, 0},
    {25312, (void *) 1961, 0},
    {25313, (void *) 1731, 10367},
    {0, NULL, 0},
    {34568, (void *) 6836, 0},
    {34569, (void *) 6841, 0},
    {34570, (void *) 6844, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34573, (void *) 6842, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25324, (void *) 1762, 10369},
    {25325, (void *) 2820, 10366},
    {25326, (void *) 5304, 0},
    {25327, (void *) 5309, 0},
    {0, NULL, 0},
    {25329, (void *) 5305, 0},
    {0, NULL, 0},
    {25331, (void *) 2160, 9468},
    {0, NULL, 0},
    {25333, (void *) 5310, 10371},
    {25334, (void *) 2445, 0},
    {25335, (void *) 2328, 9608},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25342, (void *) 2637, 0},
    {25343, (void *) 5292, 0},
    {34597, (void *) 6849, 0},
    {25345, (void *) 2536, 0},
    {25346, (void *) 5307, 0},
    {0, NULL, 0},
    {34601, (void *) 6850, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25351, (void *) 2499, 0},
    {25352, (void *) 5308, 0},
    {25353, (void *) 1445, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25356, (void *) 5303, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34612, (void *) 6845, 0},
    {0, NULL, 0},
    {25361, (void *) 3298, 0},
    {34615, (void *) 6847, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34619, (void *) 6848, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25369, (void *) 1962, 0},
    {34623, (void *) 6846, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25375, (void *) 1993, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34633, (void *) 2983, 0},
    {0, NULL, 0},
    {34635, (void *) 4348, 0},
    {25383, (void *) 5306, 10373},
    {25384, (void *) 1416, 0},
    {34638, (void *) 6856, 0},
    {0, NULL, 0},
    {25387, (void *) 2384, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34643, (void *) 6862, 0},
    {25391, (void *) 2841, 0},
    {34645, (void *) 2829, 0},
    {0, NULL, 0},
    {34647, (void *) 6858, 0},
    {0, NULL, 0},
    {34649, (void *) 6861, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25402, (void *) 3371, 10372},
    {34656, (void *) 6852, 0},
    {0, NULL, 0},
    {25405, (void *) 3717, 0},
    {25406, (void *) 5312, 10376},
    {25407, (void *) 3069, 0},
    {0, NULL, 0},
    {34662, (void *) 1657, 0},
    {0, NULL, 0},
    {34664, (void *) 6859, 0},
    {0, NULL, 0},
    {34666, (void *) 6864, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25417, (void *) 3111, 10375},
    {0, NULL, 0},
    {0, NULL, 0},
    {25420, (void *) 2454, 0},
    {25421, (void *) 5313, 0},
    {0, NULL, 0},
    {25423, (void *) 5315, 10374},
    {25424, (void *) 5311, 0},
    {34678, (void *) 3308, 0},
    {0, NULL, 0},
    {34680, (void *) 6854, 0},
    {0, NULL, 0},
    {25429, (void *) 3918, 0},
    {0, NULL, 0},
    {25431, (void *) 3318, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34687, (void *) 3643, 0},
    {0, NULL, 0},
    {25436, (void *) 3067, 0},
    {34690, (void *) 6868, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25447, (void *) 3944, 0},
    {25448, (void *) 2583, 9638},
    {25449, (void *) 5327, 0},
    {0, NULL, 0},
    {25451, (void *) 5326, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25454, (void *) 2907, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25458, (void *) 2161, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25462, (void *) 5320, 0},
    {25463, (void *) 2750, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25466, (void *) 3549, 10377},
    {25467, (void *) 3588, 0},
    {0, NULL, 0},
    {34722, (void *) 6866, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25472, (void *) 5318, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25475, (void *) 3068, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34731, (void *) 6875, 0},
    {0, NULL, 0},
    {25480, (void *) 2625, 0},
    {25481, (void *) 5323, 0},
    {34735, (void *) 6869, 0},
    {0, NULL, 0},
    {25484, (void *) 2749, 0},
    {0, NULL, 0},
    {25486, (void *) 5317, 10383},
    {25487, (void *) 5322, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25490, (void *) 3622, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34746, (void *) 4205, 0},
    {25494, (void *) 5316, 10386},
    {0, NULL, 0},
    {25496, (void *) 2068, 10378},
    {0, NULL, 0},
    {0, NULL, 0},
    {25499, (void *) 1752, 10379},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25503, (void *) 5324, 10382},
    {25504, (void *) 4240, 0},
    {25505, (void *) 2395, 10385},
    {25506, (void *) 3216, 10384},
    {25507, (void *) 5321, 0},
    {0, NULL, 0},
    {25509, (void *) 2973, 0},
    {34763, (void *) 6870, 0},
    {25511, (void *) 2276, 0},
    {25512, (void *) 2887, 0},
    {25513, (void *) 1573, 0},
    {25514, (void *) 3035, 0},
    {25515, (void *) 5319, 10380},
    {25516, (void *) 1916, 0},
    {34770, (void *) 6890, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25522, (void *) 2106, 0},
    {0, NULL, 0},
    {25524, (void *) 3336, 0},
    {25525, (void *) 5325, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25531, (void *) 3070, 10387},
    {0, NULL, 0},
    {0, NULL, 0},
    {25534, (void *) 5328, 0},
    {0, NULL, 0},
    {25536, (void *) 5330, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25539, (void *) 3124, 0},
    {25540, (void *) 5336, 0},
    {0, NULL, 0},
    {25542, (void *) 5331, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25545, (void *) 5333, 0},
    {34799, (void *) 6881, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34802, (void *) 6882, 0},
    {0, NULL, 0},
    {25551, (void *) 3792, 0},
    {25552, (void *) 3372, 0},
    {34806, (void *) 6887, 0},
    {25554, (void *) 5334, 10388},
    {0, NULL, 0},
    {34809, (void *) 1701, 0},
    {0, NULL, 0},
    {34811, (void *) 1913, 9634},
    {0, NULL, 0},
    {0, NULL, 0},
    {34814, (void *) 6886, 0},
    {25562, (void *) 4175, 0},
    {25563, (void *) 1810, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34821, (void *) 6865, 0},
    {25569, (void *) 1423, 0},
    {34823, (void *) 8528, 11245},
    {25571, (void *) 5332, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34829, (void *) 6885, 0},
    {25577, (void *) 5329, 10389},
    {34831, (void *) 6884, 0},
    {0, NULL, 0},
    {34833, (void *) 6891, 0},
    {0, NULL, 0},
    {25582, (void *) 1873, 0},
    {0, NULL, 0},
    {34837, (void *) 6893, 0},
    {34838, (void *) 6892, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25588, (void *) 1574, 0},
    {25589, (void *) 8380, 11097},
    {25590, (void *) 5335, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25594, (void *) 4176, 0},
    {0, NULL, 0},
    {34849, (void *) 6895, 0},
    {34850, (void *) 6894, 0},
    {34851, (void *) 6825, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34855, (void *) 6899, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25606, (void *) 5339, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34865, (void *) 6896, 0},
    {25613, (void *) 3128, 0},
    {0, NULL, 0},
    {25615, (void *) 5346, 0},
    {0, NULL, 0},
    {34870, (void *) 6897, 0},
    {0, NULL, 0},
    {25619, (void *) 5340, 0},
    {34873, (void *) 6898, 0},
    {0, NULL, 0},
    {25622, (void *) 5337, 10390},
    {25623, (void *) 5344, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34880, (void *) 2143, 0},
    {25628, (void *) 5314, 0},
    {34882, (void *) 6902, 0},
    {0, NULL, 0},
    {34884, (void *) 6901, 0},
    {0, NULL, 0},
    {34886, (void *) 2647, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25638, (void *) 5341, 0},
    {34892, (void *) 2307, 0},
    {25640, (void *) 5345, 9939},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25644, (void *) 3699, 0},
    {25645, (void *) 3458, 10391},
    {34899, (void *) 2680, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34903, (void *) 1716, 0},
    {0, NULL, 0},
    {25652, (void *) 5338, 10392},
    {0, NULL, 0},
    {34907, (void *) 1553, 9863},
    {0, NULL, 0},
    {34909, (void *) 2780, 0},
    {34910, (void *) 6905, 0},
    {25658, (void *) 2107, 0},
    {0, NULL, 0},
    {34913, (void *) 2308, 0},
    {34914, (void *) 6906, 0},
    {34915, (void *) 1474, 9360},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25666, (void *) 2974, 0},
    {34920, (void *) 3788, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34923, (void *) 6907, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34928, (void *) 2893, 0},
    {0, NULL, 0},
    {34930, (void *) 6914, 0},
    {25678, (void *) 5350, 0},
    {0, NULL, 0},
    {34933, (void *) 6911, 0},
    {0, NULL, 0},
    {34935, (void *) 3274, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25688, (void *) 3389, 10393},
    {34942, (void *) 6909, 0},
    {34943, (void *) 2035, 0},
    {0, NULL, 0},
    {34945, (void *) 6908, 0},
    {34946, (void *) 6915, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25696, (void *) 8381, 11098},
    {0, NULL, 0},
    {0, NULL, 0},
    {34952, (void *) 2089, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34955, (void *) 3163, 0},
    {25703, (void *) 5347, 0},
    {34957, (void *) 6921, 0},
    {25705, (void *) 4011, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34962, (void *) 6917, 0},
    {0, NULL, 0},
    {25711, (void *) 5348, 0},
    {0, NULL, 0},
    {34966, (void *) 3122, 0},
    {34967, (void *) 6916, 0},
    {0, NULL, 0},
    {34969, (void *) 6919, 0},
    {0, NULL, 0},
    {25718, (void *) 5349, 0},
    {0, NULL, 0},
    {25720, (void *) 4087, 0},
    {34974, (void *) 6910, 0},
    {25722, (void *) 2915, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34978, (void *) 6920, 0},
    {0, NULL, 0},
    {34980, (void *) 6922, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25731, (void *) 2133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34987, (void *) 3744, 0},
    {0, NULL, 0},
    {25736, (void *) 5356, 0},
    {34990, (void *) 6918, 0},
    {0, NULL, 0},
    {34992, (void *) 6923, 0},
    {34993, (void *) 6925, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {34996, (void *) 2212, 0},
    {34997, (void *) 6913, 0},
    {0, NULL, 0},
    {34999, (void *) 1442, 9364},
    {25747, (void *) 5353, 0},
    {0, NULL, 0},
    {25749, (void *) 5352, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25754, (void *) 3589, 10394},
    {0, NULL, 0},
    {35009, (void *) 2408, 0},
    {35010, (void *) 4315, 10838},
    {25758, (void *) 3498, 10395},
    {35012, (void *) 6927, 0},
    {35013, (void *) 3092, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25764, (void *) 3400, 0},
    {25765, (void *) 5354, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25769, (void *) 5355, 0},
    {35023, (void *) 4231, 0},
    {25771, (void *) 3838, 0},
    {0, NULL, 0},
    {25773, (void *) 3608, 0},
    {25774, (void *) 2446, 0},
    {35028, (void *) 6928, 0},
    {25776, (void *) 2994, 9637},
    {0, NULL, 0},
    {25778, (void *) 3995, 0},
    {35032, (void *) 6929, 0},
    {35033, (void *) 6930, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35036, (void *) 3921, 0},
    {35037, (void *) 6931, 0},
    {25785, (void *) 1732, 0},
    {35039, (void *) 2381, 0},
    {25787, (void *) 5362, 0},
    {35041, (void *) 4232, 9864},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25793, (void *) 4177, 0},
    {25794, (void *) 5364, 0},
    {35048, (void *) 6936, 0},
    {0, NULL, 0},
    {25797, (void *) 5360, 0},
    {0, NULL, 0},
    {25799, (void *) 5361, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25805, (void *) 3071, 10397},
    {35059, (void *) 2781, 10839},
    {35060, (void *) 6935, 0},
    {35061, (void *) 8529, 11246},
    {0, NULL, 0},
    {25810, (void *) 5359, 0},
    {35064, (void *) 4206, 0},
    {25812, (void *) 5294, 10396},
    {0, NULL, 0},
    {0, NULL, 0},
    {35068, (void *) 6934, 0},
    {35069, (void *) 2942, 9865},
    {35070, (void *) 2913, 0},
    {25818, (void *) 5358, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35074, (void *) 6933, 0},
    {0, NULL, 0},
    {35076, (void *) 6938, 0},
    {25824, (void *) 5368, 0},
    {25825, (void *) 5369, 0},
    {25826, (void *) 3390, 9571},
    {25827, (void *) 5371, 0},
    {0, NULL, 0},
    {35082, (void *) 6940, 0},
    {25830, (void *) 2447, 0},
    {25831, (void *) 5366, 10398},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35088, (void *) 1767, 0},
    {25836, (void *) 1907, 0},
    {35090, (void *) 3958, 0},
    {35091, (void *) 6941, 0},
    {25839, (void *) 5372, 0},
    {0, NULL, 0},
    {25841, (void *) 5365, 0},
    {25842, (void *) 5376, 0},
    {0, NULL, 0},
    {25844, (void *) 5375, 0},
    {0, NULL, 0},
    {25846, (void *) 5374, 0},
    {35100, (void *) 8273, 10990},
    {35101, (void *) 6953, 0},
    {35102, (void *) 6943, 0},
    {25850, (void *) 5377, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25853, (void *) 5379, 0},
    {25854, (void *) 2806, 0},
    {0, NULL, 0},
    {25856, (void *) 5378, 10399},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25861, (void *) 5382, 10400},
    {35115, (void *) 6946, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35126, (void *) 6950, 0},
    {0, NULL, 0},
    {35128, (void *) 6951, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35131, (void *) 6949, 0},
    {0, NULL, 0},
    {25880, (void *) 5380, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25884, (void *) 5381, 10401},
    {25885, (void *) 5343, 0},
    {35139, (void *) 6942, 0},
    {35140, (void *) 6948, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25891, (void *) 5384, 0},
    {25892, (void *) 5383, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35148, (void *) 6952, 0},
    {35149, (void *) 7448, 0},
    {0, NULL, 0},
    {25898, (void *) 5351, 0},
    {25899, (void *) 5385, 0},
    {25900, (void *) 5373, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25903, (void *) 2500, 0},
    {0, NULL, 0},
    {35158, (void *) 1605, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25908, (void *) 5386, 0},
    {25909, (void *) 5387, 0},
    {25910, (void *) 5389, 0},
    {25911, (void *) 5388, 0},
    {25912, (void *) 5390, 0},
    {25913, (void *) 1691, 10403},
    {35167, (void *) 2036, 0},
    {25915, (void *) 2277, 10402},
    {0, NULL, 0},
    {0, NULL, 0},
    {25918, (void *) 3945, 0},
    {25919, (void *) 2928, 10404},
    {0, NULL, 0},
    {35174, (void *) 6956, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25925, (void *) 2207, 10406},
    {0, NULL, 0},
    {0, NULL, 0},
    {25928, (void *) 5392, 10405},
    {0, NULL, 0},
    {35183, (void *) 6960, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35186, (void *) 2648, 9866},
    {25934, (void *) 8384, 11101},
    {25935, (void *) 3809, 10407},
    {0, NULL, 0},
    {25937, (void *) 1942, 0},
    {35191, (void *) 6962, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {25941, (void *) 5394, 0},
    {25942, (void *) 5393, 0},
    {25943, (void *) 3623, 0},
    {25944, (void *) 5396, 0},
    {25945, (void *) 1994, 10408},
    {35199, (void *) 2943, 0},
    {0, NULL, 0},
    {35201, (void *) 4190, 0},
    {25949, (void *) 5398, 0},
    {25950, (void *) 5397, 10409},
    {0, NULL, 0},
    {0, NULL, 0},
    {35206, (void *) 3857, 0},
    {25954, (void *) 1811, 9521},
    {25955, (void *) 2465, 10410},
    {0, NULL, 0},
    {35210, (void *) 6966, 0},
    {35211, (void *) 2172, 9510},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35215, (void *) 1891, 0},
    {0, NULL, 0},
    {25964, (void *) 2108, 0},
    {0, NULL, 0},
    {35219, (void *) 6967, 0},
    {0, NULL, 0},
    {25968, (void *) 2903, 0},
    {35222, (void *) 2518, 0},
    {35223, (void *) 3604, 9867},
    {35224, (void *) 6968, 0},
    {25972, (void *) 2929, 0},
    {35226, (void *) 1739, 9490},
    {0, NULL, 0},
    {25975, (void *) 3822, 0},
    {25976, (void *) 5400, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35233, (void *) 6969, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35238, (void *) 6971, 0},
    {35239, (void *) 4222, 9868},
    {25987, (void *) 5402, 0},
    {35241, (void *) 6970, 0},
    {35242, (void *) 2857, 0},
    {0, NULL, 0},
    {25991, (void *) 3877, 10411},
    {25992, (void *) 4948, 0},
    {25993, (void *) 2951, 0},
    {35247, (void *) 6973, 0},
    {0, NULL, 0},
    {25996, (void *) 3803, 0},
    {35250, (void *) 6974, 0},
    {35251, (void *) 1834, 9352},
    {0, NULL, 0},
    {26000, (void *) 3734, 0},
    {26001, (void *) 3700, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35258, (void *) 6975, 0},
    {0, NULL, 0},
    {26007, (void *) 3428, 0},
    {35261, (void *) 6976, 0},
    {26009, (void *) 4262, 0},
    {35263, (void *) 6977, 0},
    {26011, (void *) 5404, 10412},
    {26012, (void *) 2585, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26015, (void *) 5405, 0},
    {0, NULL, 0},
    {26017, (void *) 1431, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26020, (void *) 2025, 0},
    {26021, (void *) 2958, 0},
    {0, NULL, 0},
    {26023, (void *) 3823, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26027, (void *) 5406, 0},
    {26028, (void *) 2477, 0},
    {35282, (void *) 1740, 9466},
    {0, NULL, 0},
    {26031, (void *) 2502, 0},
    {26032, (void *) 2842, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35290, (void *) 6979, 0},
    {0, NULL, 0},
    {26039, (void *) 5407, 10413},
    {35293, (void *) 6981, 0},
    {26041, (void *) 3946, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26044, (void *) 1590, 0},
    {26045, (void *) 2503, 0},
    {35299, (void *) 1679, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35302, (void *) 2827, 9870},
    {35303, (void *) 6982, 0},
    {26051, (void *) 5408, 0},
    {26052, (void *) 5411, 0},
    {26053, (void *) 4254, 0},
    {26054, (void *) 5409, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26059, (void *) 3004, 0},
    {26060, (void *) 5412, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26063, (void *) 3119, 10414},
    {0, NULL, 0},
    {0, NULL, 0},
    {26066, (void *) 5413, 0},
    {35320, (void *) 6984, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26071, (void *) 1875, 0},
    {0, NULL, 0},
    {26073, (void *) 5415, 0},
    {0, NULL, 0},
    {35328, (void *) 2193, 9871},
    {0, NULL, 0},
    {35330, (void *) 3380, 0},
    {35331, (void *) 6985, 0},
    {0, NULL, 0},
    {26080, (void *) 5416, 0},
    {26081, (void *) 5417, 0},
    {26082, (void *) 1876, 0},
    {35336, (void *) 2122, 0},
    {0, NULL, 0},
    {35338, (void *) 2873, 9516},
    {26086, (void *) 3217, 0},
    {26087, (void *) 1955, 10416},
    {26088, (void *) 2504, 0},
    {26089, (void *) 3072, 9501},
    {0, NULL, 0},
    {35344, (void *) 6987, 0},
    {26092, (void *) 2691, 0},
    {26093, (void *) 1425, 10896},
    {35347, (void *) 2084, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26097, (void *) 5418, 10415},
    {35351, (void *) 3188, 0},
    {35352, (void *) 1892, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35355, (void *) 6989, 0},
    {0, NULL, 0},
    {35357, (void *) 6990, 0},
    {0, NULL, 0},
    {26106, (void *) 1599, 9410},
    {26107, (void *) 5422, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35363, (void *) 2144, 0},
    {0, NULL, 0},
    {35365, (void *) 6991, 10840},
    {0, NULL, 0},
    {26114, (void *) 2278, 0},
    {26115, (void *) 5421, 0},
    {0, NULL, 0},
    {35370, (void *) 3959, 0},
    {26118, (void *) 2360, 0},
    {26119, (void *) 2751, 0},
    {35373, (void *) 2976, 0},
    {26121, (void *) 8388, 11105},
    {26122, (void *) 5420, 0},
    {0, NULL, 0},
    {35377, (void *) 1965, 9404},
    {0, NULL, 0},
    {26126, (void *) 4073, 9628},
    {26127, (void *) 2359, 9444},
    {0, NULL, 0},
    {35382, (void *) 6992, 0},
    {35383, (void *) 8531, 11248},
    {26131, (void *) 1464, 0},
    {26132, (void *) 2959, 0},
    {35386, (void *) 2858, 10841},
    {35387, (void *) 3275, 0},
    {35388, (void *) 2783, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26140, (void *) 5427, 10417},
    {0, NULL, 0},
    {26142, (void *) 8390, 11107},
    {26143, (void *) 2930, 0},
    {26144, (void *) 1542, 0},
    {35398, (void *) 6996, 0},
    {0, NULL, 0},
    {35400, (void *) 6997, 0},
    {26148, (void *) 8391, 11108},
    {26149, (void *) 2684, 0},
    {0, NULL, 0},
    {26151, (void *) 4017, 0},
    {26152, (void *) 2431, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35408, (void *) 2379, 0},
    {35409, (void *) 3135, 0},
    {26157, (void *) 2753, 10419},
    {26158, (void *) 8389, 11106},
    {35412, (void *) 2784, 9426},
    {35413, (void *) 3789, 0},
    {26161, (void *) 8279, 10996},
    {0, NULL, 0},
    {0, NULL, 0},
    {26164, (void *) 5426, 0},
    {26165, (void *) 5424, 0},
    {26166, (void *) 5425, 10418},
    {0, NULL, 0},
    {0, NULL, 0},
    {35422, (void *) 2519, 0},
    {0, NULL, 0},
    {35424, (void *) 1554, 10842},
    {26172, (void *) 3270, 0},
    {35426, (void *) 7001, 0},
    {35427, (void *) 2123, 0},
    {26175, (void *) 5457, 0},
    {0, NULL, 0},
    {35430, (void *) 2521, 9874},
    {26178, (void *) 2537, 0},
    {26179, (void *) 2279, 0},
    {35433, (void *) 2520, 9872},
    {0, NULL, 0},
    {35435, (void *) 4368, 0},
    {35436, (void *) 7000, 0},
    {35437, (void *) 6999, 0},
    {35438, (void *) 3014, 9873},
    {0, NULL, 0},
    {35440, (void *) 1924, 9416},
    {35441, (void *) 4358, 0},
    {35442, (void *) 1717, 0},
    {35443, (void *) 2785, 0},
    {26191, (void *) 5428, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26194, (void *) 2458, 0},
    {0, NULL, 0},
    {35449, (void *) 8532, 11249},
    {0, NULL, 0},
    {0, NULL, 0},
    {35452, (void *) 6998, 10843},
    {0, NULL, 0},
    {26201, (void *) 8394, 11111},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26205, (void *) 5433, 10420},
    {26206, (void *) 5432, 0},
    {26207, (void *) 5437, 10421},
    {35461, (void *) 7002, 0},
    {0, NULL, 0},
    {35463, (void *) 2217, 9878},
    {0, NULL, 0},
    {35465, (void *) 4167, 9875},
    {26213, (void *) 8392, 11109},
    {26214, (void *) 1693, 0},
    {35468, (void *) 2522, 9876},
    {35469, (void *) 3578, 9877},
    {26217, (void *) 3718, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35473, (void *) 7007, 0},
    {0, NULL, 0},
    {35475, (void *) 2945, 9564},
    {26223, (void *) 2109, 0},
    {35477, (void *) 3229, 9879},
    {0, NULL, 0},
    {0, NULL, 0},
    {35480, (void *) 4157, 10845},
    {26228, (void *) 2931, 0},
    {35482, (void *) 7010, 0},
    {26230, (void *) 2754, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35486, (void *) 2237, 0},
    {26234, (void *) 3245, 0},
    {35488, (void *) 2944, 0},
    {35489, (void *) 7006, 0},
    {0, NULL, 0},
    {35491, (void *) 7011, 0},
    {35492, (void *) 2238, 0},
    {35493, (void *) 7008, 0},
    {26241, (void *) 2012, 10423},
    {35495, (void *) 8533, 11250},
    {26243, (void *) 5440, 10422},
    {26244, (void *) 5444, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26247, (void *) 1640, 9436},
    {35501, (void *) 3518, 9880},
    {26249, (void *) 5443, 0},
    {0, NULL, 0},
    {35504, (void *) 3210, 0},
    {0, NULL, 0},
    {35506, (void *) 1658, 0},
    {26254, (void *) 5442, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26257, (void *) 2706, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35513, (void *) 3745, 0},
    {0, NULL, 0},
    {26262, (void *) 3235, 0},
    {26263, (void *) 1446, 9310},
    {26264, (void *) 5445, 0},
    {26265, (void *) 8397, 10897},
    {35519, (void *) 3309, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26269, (void *) 5446, 10424},
    {0, NULL, 0},
    {35524, (void *) 7012, 0},
    {26272, (void *) 8398, 11115},
    {0, NULL, 0},
    {35527, (void *) 3239, 9475},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35531, (void *) 2946, 9668},
    {35532, (void *) 1835, 0},
    {35533, (void *) 7013, 0},
    {0, NULL, 0},
    {35535, (void *) 2878, 0},
    {26283, (void *) 2478, 0},
    {0, NULL, 0},
    {35538, (void *) 4271, 0},
    {26286, (void *) 3928, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35542, (void *) 4355, 0},
    {26290, (void *) 8399, 11116},
    {0, NULL, 0},
    {26292, (void *) 3976, 0},
    {35546, (void *) 7015, 0},
    {35547, (void *) 7026, 0},
    {35548, (void *) 3310, 0},
    {26296, (void *) 5453, 0},
    {26297, (void *) 5448, 10425},
    {35551, (void *) 8535, 11252},
    {35552, (void *) 7022, 0},
    {26300, (void *) 5451, 10427},
    {35554, (void *) 7023, 0},
    {26302, (void *) 5450, 0},
    {35556, (void *) 7019, 10846},
    {0, NULL, 0},
    {35558, (void *) 3381, 9881},
    {35559, (void *) 7018, 0},
    {0, NULL, 0},
    {26308, (void *) 5452, 0},
    {0, NULL, 0},
    {35563, (void *) 7016, 0},
    {26311, (void *) 3539, 0},
    {35565, (void *) 4136, 0},
    {35566, (void *) 2523, 9882},
    {0, NULL, 0},
    {0, NULL, 0},
    {35569, (void *) 7020, 0},
    {0, NULL, 0},
    {35571, (void *) 7017, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35574, (void *) 8537, 11254},
    {35575, (void *) 7024, 0},
    {35576, (void *) 2715, 0},
    {0, NULL, 0},
    {35578, (void *) 2194, 0},
    {26326, (void *) 5454, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26329, (void *) 2707, 9457},
    {26330, (void *) 5455, 0},
    {35584, (void *) 3984, 0},
    {35585, (void *) 1561, 9641},
    {35586, (void *) 1475, 9528},
    {0, NULL, 0},
    {35588, (void *) 3482, 0},
    {26336, (void *) 5456, 0},
    {0, NULL, 0},
    {35591, (void *) 7028, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26342, (void *) 5458, 0},
    {35596, (void *) 7027, 0},
    {0, NULL, 0},
    {35598, (void *) 3547, 9883},
    {0, NULL, 0},
    {35600, (void *) 7032, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35604, (void *) 7021, 0},
    {26352, (void *) 5460, 0},
    {35606, (void *) 7031, 0},
    {26354, (void *) 2015, 10428},
    {26355, (void *) 1543, 0},
    {35609, (void *) 2173, 9338},
    {26357, (void *) 5461, 10426},
    {35611, (void *) 2309, 0},
    {26359, (void *) 5462, 0},
    {35613, (void *) 2590, 9398},
    {26361, (void *) 3073, 0},
    {26362, (void *) 8401, 11118},
    {35616, (void *) 7034, 10803},
    {35617, (void *) 4191, 9732},
    {26365, (void *) 3037, 0},
    {26366, (void *) 3036, 0},
    {26367, (void *) 3157, 0},
    {26368, (void *) 2388, 0},
    {35622, (void *) 7037, 0},
    {0, NULL, 0},
    {26371, (void *) 4499, 10429},
    {0, NULL, 0},
    {0, NULL, 0},
    {35627, (void *) 7038, 0},
    {35628, (void *) 3780, 0},
    {26376, (void *) 2145, 0},
    {26377, (void *) 4148, 0},
    {0, NULL, 0},
    {26379, (void *) 3947, 0},
    {0, NULL, 0},
    {26381, (void *) 3853, 0},
    {35635, (void *) 7035, 10847},
    {26383, (void *) 5463, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35641, (void *) 2037, 9361},
    {26389, (void *) 3320, 0},
    {26390, (void *) 5464, 0},
    {26391, (void *) 4338, 0},
    {0, NULL, 0},
    {35646, (void *) 7039, 0},
    {0, NULL, 0},
    {26395, (void *) 3977, 0},
    {35649, (void *) 7041, 0},
    {26397, (void *) 3300, 0},
    {26398, (void *) 5465, 0},
    {26399, (void *) 1877, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35657, (void *) 7045, 0},
    {0, NULL, 0},
    {26406, (void *) 5466, 0},
    {26407, (void *) 5467, 10430},
    {26408, (void *) 4099, 0},
    {35662, (void *) 7044, 0},
    {26410, (void *) 4045, 10431},
    {26411, (void *) 4033, 0},
    {26412, (void *) 4007, 0},
    {26413, (void *) 2448, 0},
    {26414, (void *) 5469, 10899},
    {0, NULL, 0},
    {0, NULL, 0},
    {26417, (void *) 2612, 10432},
    {0, NULL, 0},
    {35672, (void *) 2554, 0},
    {26420, (void *) 3996, 0},
    {35674, (void *) 7048, 0},
    {26422, (void *) 5471, 10433},
    {35676, (void *) 3831, 9886},
    {26424, (void *) 5473, 0},
    {0, NULL, 0},
    {26426, (void *) 1874, 10435},
    {0, NULL, 0},
    {0, NULL, 0},
    {26429, (void *) 1943, 0},
    {0, NULL, 0},
    {26431, (void *) 5470, 0},
    {0, NULL, 0},
    {35686, (void *) 2124, 9885},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26438, (void *) 5475, 10434},
    {35692, (void *) 7051, 0},
    {0, NULL, 0},
    {26441, (void *) 2908, 0},
    {35695, (void *) 7052, 0},
    {35696, (void *) 1915, 0},
    {35697, (void *) 6518, 0},
    {35698, (void *) 2814, 0},
    {26446, (void *) 4226, 0},
    {26447, (void *) 1450, 10436},
    {26448, (void *) 2413, 0},
    {26449, (void *) 3129, 0},
    {35703, (void *) 2239, 0},
    {26451, (void *) 2598, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26454, (void *) 2808, 0},
    {0, NULL, 0},
    {35709, (void *) 7054, 0},
    {26457, (void *) 5478, 0},
    {35711, (void *) 8539, 11256},
    {35712, (void *) 7055, 0},
    {26460, (void *) 3429, 0},
    {0, NULL, 0},
    {35715, (void *) 2473, 9887},
    {26463, (void *) 3112, 0},
    {26464, (void *) 5477, 0},
    {26465, (void *) 2807, 0},
    {26466, (void *) 4102, 0},
    {26467, (void *) 5479, 0},
    {26468, (void *) 5480, 0},
    {26469, (void *) 4207, 9869},
    {26470, (void *) 8404, 11121},
    {35724, (void *) 7056, 0},
    {0, NULL, 0},
    {35726, (void *) 7057, 0},
    {26474, (void *) 5485, 0},
    {35728, (void *) 2649, 0},
    {0, NULL, 0},
    {26477, (void *) 2281, 10437},
    {35731, (void *) 7059, 0},
    {26479, (void *) 3624, 0},
    {26480, (void *) 5482, 0},
    {26481, (void *) 3459, 10438},
    {26482, (void *) 5419, 0},
    {26483, (void *) 5423, 0},
    {35737, (void *) 7061, 0},
    {26485, (void *) 1926, 10439},
    {0, NULL, 0},
    {26487, (void *) 3610, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26492, (void *) 5484, 0},
    {0, NULL, 0},
    {26494, (void *) 2755, 0},
    {26495, (void *) 3701, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26501, (void *) 5490, 0},
    {0, NULL, 0},
    {26503, (void *) 3755, 0},
    {0, NULL, 0},
    {26505, (void *) 5481, 0},
    {0, NULL, 0},
    {26507, (void *) 5487, 0},
    {26508, (void *) 5486, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26512, (void *) 2960, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26517, (void *) 4024, 0},
    {0, NULL, 0},
    {26519, (void *) 4280, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26522, (void *) 4018, 0},
    {0, NULL, 0},
    {26524, (void *) 1641, 0},
    {26525, (void *) 2505, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26528, (void *) 4363, 0},
    {26529, (void *) 5489, 0},
    {26530, (void *) 2904, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26534, (void *) 5488, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26537, (void *) 5483, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26543, (void *) 2208, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26547, (void *) 5495, 0},
    {26548, (void *) 5493, 0},
    {0, NULL, 0},
    {26550, (void *) 1642, 0},
    {26551, (void *) 5491, 0},
    {26552, (void *) 5497, 0},
    {26553, (void *) 5503, 0},
    {0, NULL, 0},
    {26555, (void *) 8405, 11122},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26560, (void *) 8407, 11124},
    {26561, (void *) 3141, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26564, (void *) 3886, 0},
    {0, NULL, 0},
    {26566, (void *) 5505, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26570, (void *) 3761, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26574, (void *) 5504, 0},
    {26575, (void *) 3651, 0},
    {26576, (void *) 3978, 0},
    {26577, (void *) 1812, 0},
    {0, NULL, 0},
    {26579, (void *) 3000, 0},
    {26580, (void *) 2663, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26584, (void *) 3340, 0},
    {0, NULL, 0},
    {26586, (void *) 4149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26589, (void *) 5500, 0},
    {26590, (void *) 5499, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26594, (void *) 5501, 0},
    {0, NULL, 0},
    {26596, (void *) 5498, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26599, (void *) 5506, 0},
    {0, NULL, 0},
    {26601, (void *) 5496, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26604, (void *) 5494, 0},
    {0, NULL, 0},
    {26606, (void *) 5502, 0},
    {26607, (void *) 5492, 0},
    {0, NULL, 0},
    {26609, (void *) 3271, 0},
    {0, NULL, 0},
    {26611, (void *) 4129, 0},
    {26612, (void *) 2575, 0},
    {26613, (void *) 2433, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26619, (void *) 2375, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26622, (void *) 4026, 0},
    {26623, (void *) 1724, 0},
    {0, NULL, 0},
    {26625, (void *) 8408, 11125},
    {26626, (void *) 3335, 0},
    {26627, (void *) 3519, 0},
    {26628, (void *) 1544, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35895, (void *) 3206, 0},
    {26643, (void *) 2995, 0},
    {0, NULL, 0},
    {35898, (void *) 7063, 0},
    {26646, (void *) 2933, 0},
    {26647, (void *) 2077, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35903, (void *) 7065, 0},
    {0, NULL, 0},
    {35905, (void *) 7064, 0},
    {0, NULL, 0},
    {26654, (void *) 5508, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26657, (void *) 2282, 9502},
    {26658, (void *) 1783, 0},
    {35912, (void *) 7066, 0},
    {0, NULL, 0},
    {35914, (void *) 3960, 0},
    {0, NULL, 0},
    {35916, (void *) 7067, 0},
    {0, NULL, 0},
    {26665, (void *) 5510, 10440},
    {26666, (void *) 1775, 0},
    {26667, (void *) 5516, 10441},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35925, (void *) 7070, 0},
    {0, NULL, 0},
    {26674, (void *) 5513, 0},
    {0, NULL, 0},
    {26676, (void *) 2996, 0},
    {35930, (void *) 3535, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26680, (void *) 1734, 0},
    {26681, (void *) 2361, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26684, (void *) 1733, 9411},
    {26685, (void *) 2396, 10442},
    {0, NULL, 0},
    {0, NULL, 0},
    {26688, (void *) 5511, 0},
    {26689, (void *) 2136, 0},
    {26690, (void *) 2110, 0},
    {26691, (void *) 3460, 0},
    {26692, (void *) 8409, 11126},
    {35946, (void *) 2330, 0},
    {35947, (void *) 4431, 9889},
    {35948, (void *) 7072, 0},
    {26696, (void *) 1447, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26701, (void *) 5512, 0},
    {26702, (void *) 5514, 0},
    {0, NULL, 0},
    {26704, (void *) 2018, 0},
    {26705, (void *) 2079, 0},
    {26706, (void *) 8406, 11123},
    {26707, (void *) 1813, 10443},
    {26708, (void *) 1922, 9555},
    {35962, (void *) 7074, 0},
    {0, NULL, 0},
    {35964, (void *) 7082, 0},
    {0, NULL, 0},
    {26713, (void *) 5517, 0},
    {8208, (void *) 29, 0},
    {0, NULL, 0},
    {26716, (void *) 2438, 0},
    {26717, (void *) 4028, 10444},
    {0, NULL, 0},
    {8213, (void *) 28, 9365},
    {35973, (void *) 7077, 0},
    {0, NULL, 0},
    {8216, (void *) 37, 0},
    {8217, (void *) 38, 9890},
    {35977, (void *) 7076, 0},
    {35978, (void *) 7078, 0},
    {8220, (void *) 39, 0},
    {8221, (void *) 40, 9552},
    {35981, (void *) 7079, 0},
    {35982, (void *) 7080, 0},
    {8224, (void *) 180, 0},
    {8225, (void *) 181, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8229, (void *) 36, 10445},
    {8230, (void *) 35, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {35992, (void *) 7083, 0},
    {26740, (void *) 5530, 0},
    {0, NULL, 0},
    {26742, (void *) 1616, 0},
    {26743, (void *) 5519, 0},
    {35997, (void *) 1704, 0},
    {35998, (void *) 3360, 0},
    {8240, (void *) 176, 0},
    {36000, (void *) 3832, 0},
    {8242, (void *) 75, 9354},
    {8243, (void *) 76, 9342},
    {26750, (void *) 5536, 0},
    {26751, (void *) 5520, 0},
    {0, NULL, 0},
    {26753, (void *) 4263, 0},
    {36007, (void *) 3806, 0},
    {36008, (void *) 1660, 9895},
    {36009, (void *) 3711, 0},
    {8251, (void *) 101, 9524},
    {36011, (void *) 1836, 0},
    {36012, (void *) 2966, 0},
    {36013, (void *) 7085, 0},
    {36014, (void *) 7090, 0},
    {36015, (void *) 3284, 0},
    {36016, (void *) 4108, 0},
    {0, NULL, 0},
    {26765, (void *) 5535, 10447},
    {36019, (void *) 7089, 0},
    {36020, (void *) 1893, 9892},
    {0, NULL, 0},
    {36022, (void *) 7091, 0},
    {36023, (void *) 3638, 0},
    {26771, (void *) 1429, 9452},
    {26772, (void *) 5524, 0},
    {63785, (void *) 8403, 11120},
    {36027, (void *) 3746, 0},
    {26775, (void *) 2283, 9493},
    {36029, (void *) 7087, 0},
    {0, NULL, 0},
    {36031, (void *) 3986, 0},
    {36032, (void *) 1673, 9894},
    {36033, (void *) 7093, 0},
    {36034, (void *) 4331, 9893},
    {36035, (void *) 3323, 0},
    {36036, (void *) 4360, 9891},
    {26784, (void *) 5532, 0},
    {0, NULL, 0},
    {36039, (void *) 2524, 9405},
    {36040, (void *) 7092, 0},
    {0, NULL, 0},
    {36042, (void *) 3118, 0},
    {26790, (void *) 4870, 0},
    {26791, (void *) 2233, 0},
    {26792, (void *) 4227, 10455},
    {36046, (void *) 3015, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {36049, (void *) 3565, 0},
    {26797, (void *) 5523, 0},
    {36051, (void *) 3807, 0},
    {26799, (void *) 3373, 0},
    {26800, (void *) 1694, 0},
    {26801, (void *) 2362, 0},
    {0, NULL, 0},
    {26803, (void *) 5515, 0},
    {0, NULL, 0},
    {26805, (void *) 5531, 10448},
    {26806, (void *) 1756, 9367},
    {36060, (void *) 2525, 0},
    {0, NULL, 0},
    {36062, (void *) 2787, 9896},
    {26810, (void *) 5533, 0},
    {36064, (void *) 3640, 0},
    {26812, (void *) 3461, 0},
    {36066, (void *) 2174, 0},
    {36067, (void *) 7095, 0},
    {36068, (void *) 7094, 0},
    {0, NULL, 0},
    {36070, (void *) 3833, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26820, (void *) 1879, 0},
    {36074, (void *) 2570, 0},
    {26822, (void *) 5563, 0},
    {0, NULL, 0},
    {36077, (void *) 3433, 10801},
    {26825, (void *) 4082, 0},
    {26826, (void *) 5538, 0},
    {26827, (void *) 1878, 10900},
    {0, NULL, 0},
    {26829, (void *) 5545, 0},
    {0, NULL, 0},
    {26831, (void *) 8410, 10901},
    {0, NULL, 0},
    {0, NULL, 0},
    {26834, (void *) 3979, 0},
    {0, NULL, 0},
    {26836, (void *) 5546, 0},
    {26837, (void *) 5548, 10450},
    {36091, (void *) 7099, 0},
    {36092, (void *) 2311, 9897},
    {26840, (void *) 5540, 10449},
    {0, NULL, 0},
    {26842, (void *) 3205, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26847, (void *) 3462, 10451},
    {26848, (void *) 5556, 10452},
    {26849, (void *) 5543, 0},
    {36103, (void *) 7103, 0},
    {36104, (void *) 3104, 9898},
    {0, NULL, 0},
    {36106, (void *) 7102, 0},
    {36107, (void *) 1855, 0},
    {26855, (void *) 5547, 0},
    {36109, (void *) 7105, 0},
    {0, NULL, 0},
    {36111, (void *) 7104, 0},
    {36112, (void *) 7106, 0},
    {0, NULL, 0},
    {36114, (void *) 8542, 11259},
    {26862, (void *) 2844, 10454},
    {26863, (void *) 5557, 10456},
    {0, NULL, 0},
    {36118, (void *) 7111, 0},
    {26866, (void *) 2932, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26873, (void *) 5555, 0},
    {26874, (void *) 1814, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26880, (void *) 4371, 0},
    {26881, (void *) 5537, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26884, (void *) 5551, 0},
    {26885, (void *) 1465, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26888, (void *) 5539, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26891, (void *) 4067, 0},
    {26892, (void *) 5544, 0},
    {26893, (void *) 2821, 0},
    {26894, (void *) 3328, 0},
    {26895, (void *) 5534, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26898, (void *) 5550, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26905, (void *) 2909, 0},
    {26906, (void *) 5560, 0},
    {26907, (void *) 1772, 0},
    {26908, (void *) 2162, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26913, (void *) 5562, 0},
    {26914, (void *) 5541, 0},
    {26915, (void *) 5561, 0},
    {0, NULL, 0},
    {26917, (void *) 5554, 0},
    {26918, (void *) 5542, 0},
    {0, NULL, 0},
    {26920, (void *) 5558, 0},
    {0, NULL, 0},
    {26922, (void *) 5559, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26928, (void *) 5576, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26932, (void *) 3523, 0},
    {0, NULL, 0},
    {26934, (void *) 5549, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26937, (void *) 5572, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26941, (void *) 5574, 0},
    {0, NULL, 0},
    {36196, (void *) 2967, 9484},
    {0, NULL, 0},
    {36198, (void *) 2584, 0},
    {36199, (void *) 7112, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {36203, (void *) 1741, 0},
    {0, NULL, 0},
    {36205, (void *) 7113, 10933},
    {0, NULL, 0},
    {26954, (void *) 4179, 0},
    {36208, (void *) 3093, 0},
    {36209, (void *) 7114, 0},
    {8451, (void *) 77, 0},
    {36211, (void *) 7115, 0},
    {36212, (void *) 3834, 0},
    {0, NULL, 0},
    {36214, (void *) 8543, 11260},
    {36215, (void *) 1894, 0},
    {26963, (void *) 3845, 0},
    {26964, (void *) 5569, 0},
    {26965, (void *) 3143, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26969, (void *) 5575, 0},
    {26970, (void *) 3038, 0},
    {0, NULL, 0},
    {26972, (void *) 5566, 10457},
    {26973, (void *) 5579, 0},
    {26974, (void *) 5578, 0},
    {0, NULL, 0},
    {8470, (void *) 1193, 9477},
    {26977, (void *) 5577, 0},
    {26978, (void *) 3551, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {36234, (void *) 1562, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26984, (void *) 8412, 11129},
    {0, NULL, 0},
    {26986, (void *) 5581, 0},
    {8481, (void *) 1195, 9899},
    {0, NULL, 0},
    {26989, (void *) 2013, 0},
    {26990, (void *) 5571, 0},
    {26991, (void *) 2692, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {26995, (void *) 3635, 0},
    {26996, (void *) 5573, 10458},
    {8491, (void *) 175, 9317},
    {0, NULL, 0},
    {26999, (void *) 5565, 0},
    {27000, (void *) 5567, 0},
    {27001, (void *) 5564, 0},
    {64014, (void *) 8323, 11040},
    {64015, (void *) 8334, 11051},
    {27004, (void *) 4339, 10827},
    {27005, (void *) 1749, 10831},
    {36259, (void *) 2618, 9900},
    {64019, (void *) 8411, 11128},
    {64020, (void *) 8413, 11130},
    {27009, (void *) 5580, 10865},
    {27010, (void *) 1712, 10869},
    {36264, (void *) 2905, 10885},
    {64024, (void *) 8493, 11210},
    {64025, (void *) 8494, 11211},
    {64026, (void *) 8495, 11212},
    {64027, (void *) 8497, 11214},
    {64028, (void *) 8501, 11218},
    {64029, (void *) 8504, 11221},
    {27018, (void *