#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <gsl/gsl_rng.h>
#include "tests.h"
#include "constant.h"
#include "fonction.h"

// Test the dierfc() function from o_rescale.c
double dierfc(double y);

void test_dierfc()
{
#define SQRTTWO 1.414213562
    long int nsamp = 200000;
    long int i;
    double rnd;
    double var, mu, val;

    gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);
    gsl_rng_set (r, 4321);

    var = mu = 0.; 
    for( i = 0; i < nsamp; i++ ) 
    {
        rnd = gsl_rng_uniform (r);
        val = SQRTTWO * dierfc(2 * (1. - rnd));
        mu += val;
        var += val*val;
    }
    gsl_rng_free (r);

    mu /= nsamp;
    var = var/nsamp - mu*mu;
    assert(mu < 1E-4);
    assert(fabs(var - 1.) < 1E-2);
}

int main(void)
{
    printf("test dierfc..."); fflush(stdout);
    test_dierfc(); printf("ok\n");
    return 0;
}
