#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <gsl/gsl_rng.h>
#include "tests.h"
#include "constant.h"
#include "fonction.h"

void test_omega_M_z()
{
    extern struct g_cosmo C;
    C.omegaM = 0.31;
    C.omegaX = 0.69;
    C.kcourb = 0.;
    C.wX = -1.;
    C.wa = 0.;
    C.h = 100./h0;
    C.model = 1;

    assert(fabs(omega_M_z(0.3) -0.496743) < 1E-6);
}

void test_deltaVF()
{
    extern struct g_cosmo C;
    C.omegaM = 0.31;
    C.omegaX = 0.69;
    C.kcourb = 0.;
    C.wX = -1.;
    C.wa = 0.;
    C.h = 100./h0;
    C.model = 1;

    assert(fabs(deltaVF(0.5) - 137.112) < 1E-3);
}

int main(void)
{
    printf("test omega_M_z..."); fflush(stdout);
    test_omega_M_z(); printf("ok\n");

    printf("test deltaVF..."); fflush(stdout);
    test_deltaVF(); printf("ok\n");
    
    return 0;
}
