/**
 * Copyright (c) OpenLens Authors. All rights reserved.
 * Licensed under MIT License. See LICENSE in root directory for more information.
 */
import { getInjectable } from "@ogre-tools/injectable";
import { lensThemeDeclarationInjectionToken } from "./declaration";

const lensDarkThemeInjectable = getInjectable({
  id: "lens-dark-theme",
  instantiate: () => ({
    name: "Dark",
    type: "dark" as const,
    description: "Original Lens dark theme",
    author: "Mirantis",
    monacoTheme: "clouds-midnight" as const,
    colors: {
      blue: "#3d90ce",
      magenta: "#c93dce",
      golden: "#ffc63d",
      halfGray: "#87909c80",
      primary: "#3d90ce",
      textColorPrimary: "#8e9297",
      textColorSecondary: "#a0a0a0",
      textColorTertiary: "#909ba6",
      textColorAccent: "#ffffff",
      textColorDimmed: "#8e92978c",
      borderColor: "#4c5053",
      borderFaintColor: "#373a3e",
      mainBackground: "#1e2124",
      secondaryBackground: "#1e2125",
      contentColor: "#262b2f",
      layoutBackground: "#2e3136",
      layoutTabsBackground: "#252729",
      layoutTabsActiveColor: "#ffffff",
      layoutTabsLineColor: "#87909c80",
      sidebarBackground: "#36393e",
      sidebarLogoBackground: "#414448",
      sidebarActiveColor: "#ffffff",
      sidebarSubmenuActiveColor: "#ffffff",
      sidebarItemHoverBackground: "#3a3e44",
      badgeBackgroundColor: "#ffba44",
      buttonPrimaryBackground: "#3d90ce",
      buttonDefaultBackground: "#414448",
      buttonLightBackground: "#f1f1f1",
      buttonAccentBackground: "#e85555",
      buttonDisabledBackground: "#808080",
      tableBgcStripe: "#2a2d33",
      tableBgcSelected: "#383c42",
      tableHeaderBackground: "#262b2f",
      tableHeaderColor: "#ffffff",
      tableSelectedRowColor: "#ffffff",
      helmLogoBackground: "#ffffff",
      helmStableRepo: "#3d90ce",
      helmIncubatorRepo: "#ff7043",
      helmDescriptionHr: "#41474a",
      helmDescriptionBlockquoteColor: "#bbb",
      helmDescriptionBlockquoteBorder: "#8a8f93",
      helmDescriptionBlockquoteBackground: "#3b4348",
      helmDescriptionHeaders: "#3e4147",
      helmDescriptionH6: "#6a737d",
      helmDescriptionTdBorder: "#47494a",
      helmDescriptionTrBackground: "#1c2125",
      helmDescriptionCodeBackground: "#ffffff1a",
      helmDescriptionPreBackground: "#1b1f21",
      helmDescriptionPreColor: "#b4b5b4",
      colorSuccess: "#43a047",
      colorOk: "#4caf50",
      colorInfo: "#3d90ce",
      colorError: "#ce3933",
      colorSoftError: "#e85555",
      colorWarning: "#ff9800",
      colorVague: "#36393e",
      colorTerminated: "#4c5053",
      dockHeadBackground: "#2e3136",
      dockInfoBackground: "#1e2125",
      dockInfoBorderColor: "#303136",
      dockEditorBackground: "#000000",
      dockEditorTag: "#8e97a3",
      dockEditorKeyword: "#ffffff",
      dockEditorComment: "#808080",
      dockEditorActiveLineBackground: "#3a3d41",
      dockBadgeBackground: "#36393e",
      dockTabBorderColor: "#43424d",
      dockTabActiveBackground: "#3a3e45",
      logsBackground: "#000000",
      logsForeground: "#ffffff",
      logRowHoverBackground: "#35373a",
      dialogTextColor: "#87909c",
      dialogBackground: "#ffffff",
      dialogHeaderBackground: "#36393e",
      dialogFooterBackground: "#f4f4f4",
      drawerTogglerBackground: "#2f343a",
      drawerTitleText: "#ffffff",
      drawerSubtitleBackground: "#373a3e",
      drawerItemNameColor: "#87909c",
      drawerItemValueColor: "#a0a0a0",
      clusterMenuBackground: "#252729",
      clusterMenuBorderColor: "#252729",
      clusterMenuCellBackground: "#2e3136",
      clusterSettingsBackground: "#1e2124",
      addClusterIconColor: "#252729",
      boxShadow: "#0000003a",
      iconActiveColor: "#ffffff",
      iconActiveBackground: "#ffffff18",
      filterAreaBackground: "#23272b",
      chartLiveBarBackground: "#00000033",
      chartStripesColor: "#ffffff08",
      chartCapacityColor: "#4c545f",
      pieChartDefaultColor: "#30353a",
      inputOptionHoverColor: "#87909c",
      inputControlBackground: "#1e2125",
      inputControlBorder: "#414448",
      inputControlHoverBorder: "#474a4f",
      lineProgressBackground: "#414448",
      radioActiveBackground: "#36393e",
      menuActiveBackground: "#3d90ce",
      menuSelectedOptionBgc: "#36393e",
      canvasBackground: "#24292e",
      scrollBarColor: "#5f6064",
      settingsBackground: "#262b2e",
      settingsColor: "#909ba6",
      navSelectedBackground: "#262b2e",
      navHoverColor: "#dcddde",
      hrColor: "#ffffff0f",
      tooltipBackground: "#18191c",
    },
    terminalColors: {
      background: "#000000",
      foreground: "#ffffff",
      cursor: "#ffffff",
      cursorAccent: "#000000",
      selection: "#ffffff77",
      black: "#2e3436",
      red: "#cc0000",
      green: "#4e9a06",
      yellow: "#c4a000",
      blue: "#3465a4",
      magenta: "#75507b",
      cyan: "#06989a",
      white: "#d3d7cf",
      brightBlack: "#555753",
      brightRed: "#ef2929",
      brightGreen: "#8ae234",
      brightYellow: "#fce94f",
      brightBlue: "#729fcf",
      brightMagenta: "#ad7fa8",
      brightCyan: "#34e2e2",
      brightWhite: "#eeeeec",
    },
    isDefault: true,
  }),
  injectionToken: lensThemeDeclarationInjectionToken,
});

export default lensDarkThemeInjectable;

