#include "ldastoolsal/AtExit.hh"
#include "ldastoolsal/Singleton.hh"
#include "ldastoolsal/UnitTestTS.h"

LDASTools::Testing::UnitTestTS	Test;

static void test_1( );

using LDASTools::AL::AtExit;
using LDASTools::AL::Singleton;

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Initialize the test structure
  //---------------------------------------------------------------------
  Test.Init(ArgC, ArgV);

  //---------------------------------------------------------------------
  // Test the basic functionality
  //---------------------------------------------------------------------
  test_1();

  //---------------------------------------------------------------------
  // Exit with the appropriate exit status
  //---------------------------------------------------------------------
  AtExit::Cleanup( );
  Test.Exit();
  return 1;
}

class Test1
  : public Singleton< Test1 >
{
public:
  Test1( )
  {
  }

  ~Test1( ) throw()
  {
  }
};

SINGLETON_INSTANCE_DEFINITION(SingletonHolder<Test1>)

static void
test_1( )
{
  bool	passed = true;
  try
  {
    Test1::Instance( );
  }
  catch( ... )
  {
    passed = false;
  }
}
