#ifndef GENERAL__CMD__SED
#define GENERAL__CMD__SED

#include "ldastoolsal/Memory.hh"

namespace LDASTools
{
  namespace Cmd
  {
    //-------------------------------------------------------------------
    /// @brief Limited implementation of the Unix sed command
    //-------------------------------------------------------------------
    class Sed
    {
    public:
      //-----------------------------------------------------------------
      /// @brief Constructor
      ///
      /// @param[in] Expression
      ///     The sed expression describing the actions to be performed.
      ///
      /// @return A new instance of a Sed object
      //-----------------------------------------------------------------
      Sed( const std::string& Expression );

      std::string operator()( const std::string& Input ) const;

      void operator()( std::istream& Input, std::ostream& Output ) const;

    private:
      class pd;

      std::auto_ptr< pd >	pdata;
    };
  }
}

#endif /* GENERAL__CMD__SED */
