#include <ldas_tools_config.h>

#include "ldastoolsal/AtExit.hh"
#include "ldastoolsal/IOLock.hh"

namespace LDASTools
{
  namespace AL
  {
    IOLock::baton_type		IOLock::m_key_ostream;

    IOLock::keys_ostream_type	IOLock::m_keys_ostream;

    MutexLock::baton_type IOLock::
    GetKey( const std::ostream& Stream )
    {
      MutexLock			lock( m_key_ostream,
				      __FILE__, __LINE__ );

      baton_type			key;
      keys_ostream_type::iterator	cur;
      keys_ostream_type::iterator	last;
  
      for( cur = m_keys_ostream.begin( ),
	     last = m_keys_ostream.end( );
	   cur != last;
	   ++cur )
      {
	if ( (*cur)->key == (&Stream) )
	{
	  break;
	}
      }
      if ( cur == last )
      {
	m_keys_ostream.push_back( new lock_set );
	m_keys_ostream.back( )->key = &Stream;
	key = m_keys_ostream.back( )->lock;
      }
      else
      {
	key = (*cur)->lock;
      }
      return key;
    }
  } // namespace - AL
} // namespace - LDASTools
