#ifdef HAVE_CONFIG_H
#include <ldas_tools_config.h>
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <stdexcept>

#include "genericAPI/StatStream.hh"

namespace GenericAPI
{
  int StatStream::
  Request( int ReadFD, int WriteFD,
	   const std::string& Filename, struct stat& Buf ) const
  {
    //-------------------------------------------------------------------
    // :TODO: transmit the request on the socket
    //-------------------------------------------------------------------
    int len = Filename.length( );

    write( WriteFD, &len, sizeof( len ) );
    write( WriteFD, Filename.c_str( ), len );
    //-------------------------------------------------------------------
    // :TODO: Read the responce
    //-------------------------------------------------------------------
    int	retval;
    int	errcode;

    read( ReadFD, &retval, sizeof( retval ) );
    if ( retval == 0 )
    {
      // Successfully processed request
      read( ReadFD, &Buf, sizeof( Buf ) );
    }
    else
    {
      // Error condition.
      read( ReadFD, &errcode, sizeof( errcode ) );
      errno = errcode;
    }
    return retval;
  }

  void StatStream::
  Process( int ReadFD, int WriteFD ) const
  {
    int		len;
    char	buffer[ 1024 ];

    //-------------------------------------------------------------------
    // Read the request
    //-------------------------------------------------------------------
    read( ReadFD, &len, sizeof(int) );
    if ( len > 0 )
    {
      read( ReadFD, buffer, len );
    }
    buffer[ len ] = '\0';
    //-------------------------------------------------------------------
    // Process the request
    //-------------------------------------------------------------------
    struct stat	buf;
    int		retval;
    int		errcode;

    retval = lstat( buffer, &buf );
    errcode = errno;

    //-------------------------------------------------------------------
    // Write the responce
    //-------------------------------------------------------------------
    write( WriteFD, &retval, sizeof( retval ) );
    if ( retval == 0 )
    {
      // Successfully processed request
      write( WriteFD, &buf, sizeof( buf ) );
    }
    else
    {
      write( WriteFD, &errcode, sizeof( errcode ) );
    }
  }

  void StatStream::
  read( int FD, void* Buffer, int BufferSize ) const
  {
    int status = 0;
    char*	buffer = static_cast<char*>( Buffer );
    int offset = 0;

    do
    {
      status = ::read( FD, &buffer[ offset ], BufferSize - offset );
      offset += status;
    }
    while ( ( status > 0 ) && ( offset < BufferSize ) );
    if ( status <= 0 )
    {
      throw std::underflow_error( "Read less than 1 byte" );
    }
  }

  void StatStream::
  write( int FD, const void* Buffer, int BufferSize ) const
  {
    int status = ::write( FD, Buffer, BufferSize );

    if ( status <= 0 )
    {
      throw std::underflow_error( "Wrote less than 1 byte" );
    }
  }
}

