/* -*- mode: c++ -*- */

%option c++
%option yyclass = "ChannelNameLexer"
%option outfile = "ChannelNameLex.cc"
%option noyywrap
%option never-interactive

%{
#include <cstring>
#include <cstdio>
#include <cstdlib>

#include <sstream>

#include "ChannelNameLexer.hh"

using namespace GenericAPI;

using std::exit;
using std::free;
using std::malloc;
using std::memset;
using std::realloc;

/**
 * \todo
 *     Need to check if size_t is unsigned to determine if YY_INPUT needs
 *     to be redefined not to check for error of < 0.
 */
/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
\
  result = LexerInput( (char *) buf, max_size ) \

#endif

%}

whitespaces [ \n\t\(\)\,\;]
channel [A-Za-z][0-9]"\\"?":"[^ \n\t\(\),\;]+
non_whitespaces [^ \n\t\(\)\,\;]
%%
{whitespaces}*		/* Eat white spaces */ ;
{channel}?		{
  std::string channel( YYText( ), YYLeng( ) );
  add_channel( channel.c_str( ) );
}
{non_whitespaces}* 	/* Eat everything else */ ;

%%

namespace GenericAPI
{
  ChannelNameLexer::
  ChannelNameLexer( const std::string& NameString )
    : yyFlexLexer()
  {
    Parse( NameString );
  }

  void ChannelNameLexer::
  Parse( const std::string& NameString )
  {
    // Setup the parser
    // std::istringstream	ss( ( NameString.size() > 0 ) ? ( NameString ) : "" );
    std::istringstream	ss( NameString + " " );

    switch_streams( &ss, 0 );
    // Fetch the strings
    while ( yylex() )
      ;
  }

  void ChannelNameLexer::
  LexerError( const char* msg )
  {
  }

  void ChannelNameLexer::
  add_channel( const char* Channel )
  {
    std::string	name;

    for ( const char* c(Channel); *c; c++ )
    {
      if ( *c != '\\' )
      {
	name += *c;
      }
    }
    data_list_type::iterator	c( m_channel_names.find( std::string(name) ) );

    if ( c == m_channel_names.end() )
    {
      m_channel_names[ name ] = 1;
    }
    else
    {
      c->second++;
    }
  }

} // namespace - GenericAPI
