/* -*- mode: c++ -*- */

%module LDASframe

%{
#include <string>
#include <list>

#include "Catalog.hh"

using namespace FrameAPI;
using LDASTools::AL::GPSTime;
using FrameAPI::Catalog;
%}

%include "std_list.i"
%include "std_string.i"

%import "ldastoolsal/gpstime.i"
%import "ldastoolsal/unordered_map.hh"

%apply swig_list_string_type { Catalog::stream_source_type };

%rename(DataDictionary) FrameAPI::Catalog::DataDictionary;
%template(ChannelDict) LDASTools::AL::unordered_map< std::string, Catalog::ChannelMetaData >;

%{
  //---------------------------------------------------------------------
  // Expose the inner class to appear as a global class for SWIG
  //---------------------------------------------------------------------
  typedef FrameAPI::Catalog::DataDictionary DataDictionary;
%}

class DataDictionary
{
public:
  typedef LDASTools::AL::SharedPtr< Channel > channel_type;
};

%extend DataDictionary  {
#if SWIGPYTHON
  DataDictionary::channel_type __getitem__( const char* Name )
  {
    DataDictionary::channel_type
      retval = (*self)[ std::string( Name ) ];

    return retval;
  }
#endif /* SWIGPYTHON */
};

class Catalog
{
 public:
  typedef INT_4U gps_seconds_type;
  typedef channel_container_type channel_name_type;
  typedef LDASTools::AL::SharedPtr< DataDictionary> data_dict_type;

  Catalog( Catalog::stream_source_type Sources );
  GPSTime GPSStartTime( ) const;
  GPSTime GPSEndTime( ) const;

  data_dict_type Fetch( gps_seconds_type Start,
			gps_seconds_type Stop,
			channel_container_type ChannelNames );

  LDAS_PROPERTY_READ_ONLY("GpsStartTime",GPSStartTime);
  LDAS_PROPERTY_READ_ONLY("GpsEndTime",GPSEndTime);
};
