#ifndef FrameCPP__COMMON__MEMORY_BUFFER_HH
#define FrameCPP__COMMON__MEMORY_BUFFER_HH

#if !defined(SWIGIMPORTED)
#include <list>
#include <iosfwd>
#endif /* !defined(SWIGIMPORTED) */

#include "ldastoolsal/types.hh"
#include "ldastoolsal/autoarray.hh"
#include "ldastoolsal/System.hh"

#include "framecpp/Common/FrameBufferInterface.hh"

namespace FrameCPP
{
  namespace Common
  {
    //===================================================================
    /// \brief Buffer appropriate for caching frame data
    ///
    /// If the buffer is for input, then the buffer needs to be
    /// initialized with the contents.
    /// The initialization needs to be done as via the call to the
    /// str( ) method before the buffer is associated with an
    /// IFrameStream object.
    /// \code
    /// MemoryBuffer	imb( std::ios:in);
    /// 
    /// imb.str( frame_file_data );
    /// 
    /// IFrameStream	ifs_mem( false, &imb );
    /// 
    /// \endcode
    ///
    //===================================================================
    template< typename BT = std::stringbuf >
    class MemoryBufferT
      : public FrameBufferInterface,
	public BT
    {
    public:
      typedef BT				buffer_type;
      typedef typename buffer_type::char_type	char_type;

      //-----------------------------------------------------------------
      /// \brief Seed an input buffer for MemoryBufferT
      //-----------------------------------------------------------------
      class Seeder {
      public:
	typedef MemoryBufferT::buffer_type buffer_type;
	Seeder( );

	virtual ~Seeder( );

	void operator()( buffer_type& Buffer );
	virtual bool operator()( void ) = 0;
      private:
	buffer_type*	output;
      };

      //-----------------------------------------------------------------
      /// \brief Seed an input buffer for MemoryBufferT from buffers
      //-----------------------------------------------------------------
      class BufferSeeder
	: public Seeder
      {
      public:
	BufferSeeder( );

	virtual bool operator( )( void );
      };

      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      MemoryBufferT( std::ios::openmode Mode,
		     bool ParentAutoDelete = true );

      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      MemoryBufferT( Seeder& Seed,
		     bool ParentAutoDelete = true );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      virtual ~MemoryBufferT( );

      //-----------------------------------------------------------------
      /// \brief Returns true if filtering happens internally; false otherwise
      //-----------------------------------------------------------------
      bool FilterInternally( ) const;

      std::string str( );

      void str( const std::string& S );

    protected:
      friend class IStream;
      friend class OStream;

      //-----------------------------------------------------------------
      /// \brief Routine to register if the caller has specified a buffer
      //-----------------------------------------------------------------
      virtual MemoryBufferT* setbuf( char_type* S, std::streamsize N );

      //-----------------------------------------------------------------
      /// \brief Initialization of the buffer
      //-----------------------------------------------------------------
      virtual void buffer( );

    private:
      LDASTools::AL::AutoArray< char_type >	buffer_cache;

      /// \brief State of user supplied buffer
      bool				buffer_user_supplied;

      /// \brief Perform filtering operations on the stream
      virtual void filter( const char_type* Begin,
			   const char_type* End );

    };

    //-------------------------------------------------------------------
    // Backwards compatability
    //-------------------------------------------------------------------
    typedef MemoryBufferT<> MemoryBuffer;

  } // namespace - Common
} // namespace - FrameCPP

#endif /* FrameCPP__COMMON__MEMORY_BUFFER_HH */
