#include "general/config.h"

#include <iostream>

#include "general/unittest.h"
#include "general/PSInfo.hh"

General::UnitTest Test;

void validate( )
{
  try
  {
    static const int	sleep_time = 5;

    using General::PSInfo;
    PSInfo		self;
    PSInfo::psinfo_type	query;

    sleep( sleep_time );

    self( query );

    Test.Check( query.s_pid == getpid( ) )
      << "pid (" << query.s_pid << ")" << std::endl;
    Test.Check( query.s_state == 'R' )
      << "state(" << query.s_state << ")" << std::endl;
    Test.Check( query.s_user.length( ) > 0 )
      << "user(" << query.s_user << ")" << std::endl;
    Test.Check( query.s_vsz > 0 )
      << "vsz(" << query.s_vsz << ")" << std::endl;
    Test.Check( ( query.s_rsz > 0 ) && ( query.s_rsz < query.s_vsz ) )
      << "rsz(" << query.s_rsz << ")" << std::endl;
    Test.Check( ( query.s_pcpu >= 0.0 ) && ( query.s_pcpu <= 100.0 ) )
      << "pcpu(" << query.s_pcpu << ")" << std::endl;
    Test.Check( ( query.s_pmem >= 0.0 ) && ( query.s_pmem <= 100.0 ) )
      << "pmem(" << query.s_pmem << ")" << std::endl;
    Test.Check( ( query.s_etime >= ( sleep_time - 1 ) ) &&
		( query.s_etime <= ( sleep_time + 2 ) ) )
      << "etime(" << query.s_etime << ")" << std::endl;
    Test.Check( query.s_fname.length( ) > 0 )
      << "fname(" << query.s_fname << ")" << std::endl;
    Test.Check( query.s_args.length( ) > 0 )
      << "args(" << query.s_args << ")" << std::endl;
  }
  catch( const std::exception& Exception )
  {
    Test.Check( false ) << "Exception was thrown: " << Exception.what( )
			<< std::endl
      ;
  }

}

int
main( int ArgC, char** ArgV )
{
  Test.Init(ArgC, ArgV);

  validate( );

  Test.Exit();
}
