/* -*- mode: c++; c-basic-offset: 4; -*- */

#ifndef TOSS_HH
#define TOSS_HH

#include <string>

namespace General
{

    //-------------------------------------------------------------------
    /// \brief  Helper function for throwing standard exceptions
    ///
    /// \param[in] ClassName
    ///     The class throwing the exception, as a string.
    /// \param[in] Filename
    ///     The program unit where the exception is thrown
    /// \param[in] LineNumber
    ///	    The line number in the file where exception is thrown
    /// \param[in] Description
    ///	    A short description of the exceptional condition
    //-------------------------------------------------------------------
    template< class T >
    void toss( const std::string& ClassName,
	       const std::string& Filename,
	       int                LineNumber,
	       const std::string& Description );

} // namespace General

#endif // TOSS_HH
