#ifndef GeneralStreamExceptionHH
#define GeneralStreamExceptionHH


#include "general/config.h"
#include "ldasexception.hh"
#include<iostream>

//-----------------------------------------------------------------------------
/// \brief  Stream Exception
///
class StreamException : public LdasException
{
public:

    /// \brief  Enumerated type classifying the type of stream errors.
    enum Error
    {
        BAD_STREAM = 0,
        FAIL_STREAM,
        END_OF_FILE,
        UNKNOWN_ERROR
    };
    
    /* Constructors */
    StreamException( std::istream& in, int library, const std::string& info,
                     const char* file = 0, size_t line = 0 );
    StreamException( std::ostream& out, int library, const std::string& info,
                     const char* file = 0, size_t line = 0 );
    StreamException(
        int library, int code, const std::string& message, const std::string& info,
        const char* file = 0, size_t line = 0 ) throw();
};


//-----------------------------------------------------------------------------
/// \brief  Constructor.
///
/// \param library Name of library or api casuing the excption
/// \param code Code for the exception
/// \param message Text message describing the exception
/// \param info Additional information about the exception
/// \param file Name of the file where the exception was thrown
/// \param line Line number of the file where the exception was thrown
///
inline StreamException::StreamException(
    int library, int code, const std::string& message, const std::string& info,
    const char* file, size_t line ) throw()
        : LdasException( library, code, message, info, file, line )
{
}


#endif // GeneralStreamExceptionHH
