#ifndef GeneralErrorsHH
#define GeneralErrorsHH

#include <string>

namespace General
{
  //---------------------------------------------------------------------
  /// \brief Error mechanism similar to errno
  ///
  /// \todo
  ///     This needs to be used by more of the LDAS libraries.
  //---------------------------------------------------------------------
  namespace Errors {
    //-------------------------------------------------------------------
    /// \brief  General Lib Errors
    //-------------------------------------------------------------------
    enum Error
      {
	INVALID_REGEX
      };


    //-------------------------------------------------------------------
    /// \brief Return the string version of the specified error number.
    ///
    /// \param[in] err
    ///     The numeric representation of the error.
    //-------------------------------------------------------------------
    std::string getErrorString( int err );


  } // namespace - Errors
} // namespace - General


#endif // GeneralErrorsHH
