#include "general/config.h"

#include <signal.h>

#include <list>

#include "general/gpstime.hh"
#include "general/mutexlock.hh"
#include "general/SingletonT.hh"
#include "general/types.hh"

namespace General
{
  /// \brief  Keep track of threads to be run for a specified time.
  class TimerThread
    : private SingletonClient
  {
  public:
    /// \brief  Unique key
    typedef INT_4U key_t;

    TimerThread( );
    ~TimerThread( );

    key_t AddTimer( int Wakeup, int Signal );
    bool RemoveTimer( key_t Key );

  private:
    struct timer_info {
      key_t	s_key;
      GPSTime	s_when;
      int	s_signal;
      pthread_t	s_thread;
    };

    typedef std::list< timer_info >	timers_type;

    bool			m_waiter_done;
    pthread_t			m_waiter_thread;
    pthread_mutex_t		m_waiter_busy_lock;
    MutexLock::lock_type	m_lock;
    timers_type			m_timers;
    key_t			m_current_key;
    GPSTime			m_next_event;
#if 0
    pthread_cond_t		m_next_event_condition;
#endif /* 0 */
    pthread_mutex_t		m_next_event_lock;

    timer_info peek_head_timer( );
    timer_info pop_timer( const GPSTime& Time );
    void reset_timer( );
    void* waiter( );
    static void* waiter( void* Data );
  };
}
