/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__TIMEOUT_HH
#define GENERAL__TIMEOUT_HH

#include "general/config.h"

#include <pthread.h>
#include <stdexcept>

#include <memory>

#include "general/ConditionalVariable.hh"
#include "general/SharedPtr.hh"
#include "general/Task.hh"

namespace General
{
  class Task;
  class SystemCallTask;

  class TimeoutException
    : public std::runtime_error
  {
  public:
    TimeoutException( const std::string& msg );
  };

  const int TIMEOUT_TIMED_OUT 	= 0x0001;
  const int TIMEOUT_COMPLETED 	= 0x0002;

  int Timeout( Task* CallerTask, int Seconds,
	       int& Status,
	       bool ThrowTimeoutException = true );

  template< typename T >
  int Timeout( SharedPtr< T > CallerTask, int Seconds,
	       int& Status,
	       bool ThrowTimeoutException = true )
  {
    return Timeout( CallerTask.get( ), Seconds, Status, ThrowTimeoutException );
  }
}
#endif /* GENERAL__TIMEOUT_HH */
