#include "general/config.h"

#include <signal.h>

#include <list>
#include <sstream>
#include <typeinfo>

#include "general/ErrorLog.hh"
#include "general/TaskThread.hh"
#include "general/ThreadPool.hh"
#include "general/Timeout.hh"

namespace General
{

  //=====================================================================
  //=====================================================================
  TimeoutException::
  TimeoutException( const std::string& msg )
    : std::runtime_error( msg.c_str( ) )
  {
  }

  //=====================================================================
  //=====================================================================
  int
  Timeout( Task* CallerTask, int Seconds,
	   int& Status,
	   bool ThrowTimeoutException )
  {
    bool 	timedout( false );
    std::string	task_name( ( CallerTask )
			   ? typeid( *CallerTask ).name( )
			   : "null_timed_task" );

    Status = TIMEOUT_COMPLETED;

    if ( CallerTask )
    {
      TaskThread*	slave = ThreadPool::Acquire( );

      if ( slave )
      {
	bool joinable = true;

	slave->AddTask( CallerTask );

	//---------------------------------------------------------------
	// Wait for task to complete
	//---------------------------------------------------------------
	slave->TimedWait( Seconds );
	timedout = slave->TimedOut( );
	joinable = slave->Halt( );

	if ( joinable )
	{
	  // Return the resouce to the pool
	  ThreadPool::Relinquish( slave );
	} // if joinable
	else
	{
	  Status &= ~TIMEOUT_COMPLETED;
	}
      } // if slave
    } // if CallerTask
    if ( timedout )
    {
      Status |= TIMEOUT_TIMED_OUT;
    }
    if ( timedout && ThrowTimeoutException )
    {
      std::ostringstream	msg;

      msg << "Unable to finish " << task_name
	  << " within " << Seconds << " seconds";

      throw General::TimeoutException( msg.str( ) );

    }
    return ( ( timedout == true )
	     ? -1
	     : 0 );
  } // Timeout()
}
