/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__TASK_THREAD_HH
#define GENERAL__TASK_THREAD_HH

#include "general/config.h"

#include "general/ConditionalVariable.hh"
#include "general/Thread.hh"

namespace General
{
  class Task;

  class TaskThread
    : public Thread
  {
  public:
    enum {
      CANCEL_SIGNAL_CANCEL = 0,
      /// This is just the initial setting
      CANCEL_SIGNAL_UNINITIALIZED = -1,
      /// This thread will be removed from the queue and detached if
      ///   its task is not completed before the timer rings.
      CANCEL_SIGNAL_ABANDON = -2
    };
    enum state_type {
      TASK_THREAD_NOT_STARTED,
      TASK_THREAD_SLEEPING,
      TASK_THREAD_RUNNING,
      TASK_THREAD_TIMEDOUT,
      TASK_THREAD_FINISHED,
      TASK_THREAD_EXITING
    };

    TaskThread( );
    virtual ~TaskThread( );
    void AddTask( Task& TaskToDo );
    void AddTask( Task* TaskToDo );
    void CriticalSection( bool );

    bool Halt( );
    MutexLock::lock_type& Mutex( );
    enum state_type State( ) const;
    bool TimedOut( );
    void TimedWait( int Seconds );
    void Wait( );

    const char* Name( ) const;

  private:
    bool		m_done;
    ConditionalVariable	m_task_available;
    Task*		m_task;
    const char*		m_task_type_name;
    int			m_cancel_signal;
    state_type		m_state;

    virtual void action( );

    TaskThread( const TaskThread& Source );
    TaskThread& operator=( const TaskThread& Source );
  };


  inline void TaskThread::
  AddTask( Task& TaskToDo )
  {
    AddTask( &TaskToDo );
  }

  inline MutexLock::lock_type& TaskThread::
  Mutex( )
  {
    return m_task_available.Mutex( );
  }

  inline const char* TaskThread::
  Name( ) const
  {
    return m_task_type_name;
  }

  inline enum TaskThread::state_type TaskThread::
  State( ) const
  {
    return m_state;
  }

  inline bool TaskThread::
  TimedOut( )
  {
    CriticalSection( true );
    bool retval( m_state == TASK_THREAD_TIMEDOUT );
    CriticalSection( false );

    return retval;
  }
}

#endif /* GENERAL__TASK_THREAD_HH */
