/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__TASK_HH
#define GENERAL__TASK_HH

#include "general/config.h"

#include "general/mutexlock.hh"

namespace General
{
  class Task {
  public:
    Task( int CancelSignal = 0 );
    virtual ~Task( );

    inline int 
    CancelSignal( ) const
    {
      return m_cancel_signal;
    }

    inline bool DeleteOnCompletion( ) const
    {
      return m_delete_on_completion;
    }

    virtual void
    OnCompletion( int TaskThreadState );

    virtual void operator()( ) = 0;

    mutable MutexLock::lock_type	m_key;

  protected:
    inline void
    delete_on_completion( bool Value )
    {
      m_delete_on_completion = Value;
    }

  private:
    int		m_cancel_signal;
    bool	m_delete_on_completion;
  };

}

#endif /* GENERAL__TASK_HH */
