/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__SYSTEM_CALL_HH
#define GENERAL__SYSTEM_CALL_HH

namespace General
{
  //-------------------------------------------------------------
  /// \brief Interface for doing operating system calls
  //-------------------------------------------------------------
  class SystemCall
  {
  public:
    SystemCall( );

    //-----------------------------------------------------------
    /// \brief Destructor to properly destroy all resources.
    //-----------------------------------------------------------
    virtual ~SystemCall( );

    int SystemErrNo( ) const;

    int SystemReturnCode( ) const;

  protected:
    int	m_returnCode;
    int m_errNo;
  };

  inline SystemCall::
  ~SystemCall( )
  {
  }

  inline int SystemCall::
  SystemErrNo( ) const
  {
    return m_errNo;
  }

  inline int SystemCall::
  SystemReturnCode( ) const
  {
    return m_returnCode;
  }
}

#endif /* GENERAL__SYSTEM_CALL_HH */
