/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#if !defined(GENERAL__SHARED_PTR_HELPER_I)
#define GENERAL__SHARED_PTR_HELPER_I

// This is a helper file for LDAS_SHARED_PTR_CLASS and should not be included directly.

// The main implementation detail in using this smart pointer of a type is to customise the code generated
// to use a pointer to the smart pointer of the type, rather than the usual pointer to the underlying type.
// So for some type T, LDAS_SHARED_PTR_CLASS<T> * is used rather than T *.

// LDAS_SHARED_PTR_CLASS namespaces could be boost or std or std::tr1
// For example for std::tr1, use:
// #define SWIG_LDAS_SHARED_PTR_CLASS_NAMESPACE std
// #define SWIG_SHARED_PTR_SUBNAMESPACE tr1


#if !defined(LDAS_SHARED_PTR_CLASS)
#define LDAS_SHARED_PTR_CLASS SharedPtr
#endif /* !defined(LDAS_SHARED_PTR_CLASS) */

#if !defined(LDAS_SHARED_PTR_NAMESPACE)
# define LDAS_SHARED_PTR_NAMESPACE General
#endif

#if defined(LDAS_SHARED_PTR_SUBNAMESPACE)
# define LDAS_SHARED_PTR_QNAMESPACE LDAS_SHARED_PTR_NAMESPACE::LDAS_SHARED_PTR_SUBNAMESPACE
#else
# define LDAS_SHARED_PTR_QNAMESPACE LDAS_SHARED_PTR_NAMESPACE
#endif

#define LDAS_SHARED_PTR_QCLASS LDAS_SHARED_PTR_QNAMESPACE::LDAS_SHARED_PTR_CLASS

namespace LDAS_SHARED_PTR_NAMESPACE {
#if defined(LDAS_SHARED_PTR_SUBNAMESPACE)
  namespace LDAS_SHARED_PTR_SUBNAMESPACE {
#endif
    template <class T> class LDAS_SHARED_PTR_CLASS {
    };
#if defined(LDAS_SHARED_PTR_SUBNAMESPACE)
  }
#endif
}

%fragment("SWIG_null_deleter", "header") {
struct SWIG_null_deleter {
  void operator() (void const *) const {
  }
};
%#define SWIG_NO_NULL_DELETER_0 , SWIG_null_deleter()
%#define SWIG_NO_NULL_DELETER_1
%#define SWIG_NO_NULL_DELETER_SWIG_POINTER_NEW
%#define SWIG_NO_NULL_DELETER_SWIG_POINTER_OWN
}


// Workaround empty first macro argument bug
#define SWIGEMPTYHACK
// Main user macro for defining LDAS_SHARED_PTR_CLASS typemaps for both const and non-const pointer types
%define %SharedPtr(TYPE...)
%feature("smartptr", noblock=1) TYPE { LDAS_SHARED_PTR_QNAMESPACE::LDAS_SHARED_PTR_CLASS< TYPE > }
LDAS_SHARED_PTR_TYPEMAPS(SWIGEMPTYHACK, TYPE)
LDAS_SHARED_PTR_TYPEMAPS(const, TYPE)
%enddef

%define %SharedPtrTypedef(TYPE,LTYPE)
  typedef LDAS_SHARED_PTR_QNAMESPACE::LDAS_SHARED_PTR_CLASS<TYPE> LTYPE;
%enddef

#endif /* !defined( GENERAL__SHARED_PTR_HELPER_I ) */
