/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#ifndef GENERAL__SHARED_PTR_HH
#define GENERAL__SHARED_PTR_HH
   
#if defined(SWIG)
%include <general/SharedPtr.i>
#else
#include <general/Memory.hh>

#define SHARED_PTR_NAMESPACE NAMESPACE_GENERAL_MEMORY

namespace General
{
#if defined(HAVE_CXX_TEMPLATE_ALIASES) || defined(HAVE_CXX_TEMPLATE_ALIASES_VIA_USING)
#define SharedPtr shared_ptr
#define SharedConstPtr shared_ptr
#define WeakPtr weak_ptr

#define StaticPointerCast static_pointer_cast
#define DynamicPointerCast dynamic_pointer_cast

#define LDAS_SHARED_PTR_QCLASS General::SharedPtr
#endif /* defined(HAVE_CXX_TEMPLATE_ALIASES) || defined(HAVE_CXX_TEMPLATE_ALIASES_VIA_USING) */

#if HAVE_CXX_TEMPLATE_ALIASES
  template< class T > using SharedPtr = typename SHARED_PTR_NAMESPACE::SharedPtr< T >;
  template< class T > using WeakPtr = typename SHARED_PTR_NAMESPACE::WeakPtr< T >;

  template< typename T, typename U > using StaticPointerCast = typename SHARED_PTR_NAMESPACE :: StaticPointerCast< T, U >;
  template< typename T, typename U > using DynamicPointerCast = typename SHARED_PTR_NAMESPACE :: DynamicPointerCast< T, U >;
#elif HAVE_CXX_TEMPLATE_ALIASES_VIA_USING
  using SHARED_PTR_NAMESPACE::SharedPtr;
  using SHARED_PTR_NAMESPACE::WeakPtr;

  using SHARED_PTR_NAMESPACE::StaticPointerCast;
  using SHARED_PTR_NAMESPACE::DynamicPointerCast;
#else /* HAVE_CXX_TEMPLATE_ALIASES */
  template< class T>
  class SharedPtr
    : public SHARED_PTR_NAMESPACE::shared_ptr< T >
  {
  public:
    inline SharedPtr( )
    {
    }

    inline SharedPtr( T* Ptr )
      : SHARED_PTR_NAMESPACE::shared_ptr< T >( Ptr )
    {
    }

    inline SharedPtr( SharedPtr< T > const & Ptr )
      : SHARED_PTR_NAMESPACE::shared_ptr< T >( Ptr )
    {
    }

    inline SharedPtr( SHARED_PTR_NAMESPACE::shared_ptr< T > const & Ptr )
      : SHARED_PTR_NAMESPACE::shared_ptr< T >( Ptr )
    {
    }
  };
  
  template< class T>
  class SharedConstPtr
    : public SharedPtr< T >
  {
  public:
    inline SharedConstPtr( )
    {
    }

    inline SharedConstPtr( T* Ptr )
      : SharedPtr< T >( Ptr )
    {
    }

    inline SharedConstPtr( SharedPtr< T > const & Ptr )
      : SharedPtr< T >( Ptr )
    {
    }

    inline SharedConstPtr( SHARED_PTR_NAMESPACE::shared_ptr< T > const & Ptr )
      : SharedPtr< T >( Ptr )
    {
    }

    inline
    const T& operator*( ) const
    {
      return SharedPtr< T >::operator*( );
    }

    inline
    const T* operator->( ) const
    {
      return SharedPtr< T >::operator->( );
    }

    inline
    const T* get( ) const
    {
      return SharedPtr< T >::get( );
    }
  };
  
  template< class T>
  class WeakPtr
    : public SHARED_PTR_NAMESPACE::weak_ptr< T >
  {
  public:
    inline WeakPtr( )
    {
    }

    inline WeakPtr( SharedPtr< T > Ptr )
      : SHARED_PTR_NAMESPACE::weak_ptr< T >( Ptr )
    {
    }
  };
#endif /* HAVE_CXX_TEMPLATE_ALIASES */  
}
#endif /* ! defined(SWIG) */

#endif /* GENERAL__SHARED_PTR_HH */
