#include <iostream>
#include <list>

#include "general/mutexlock.hh"

namespace General
{
  /// \brief  Class to coordinate writing of streams.
  ///
  /// This class allows multithreaded applications to share a stream
  /// when threads cooperate.
  class IOLock
  {
  public:
    /// \brief  Obtain the lock for a stream.
    static pthread_mutex_t*	GetKey( const std::ostream& Stream );

  private:
    struct lock_set {
      const void*	key;
      pthread_mutex_t	lock;
    };
    typedef std::list< lock_set* >	keys_ostream_type;

    static pthread_mutex_t		m_key_ostream;

    static keys_ostream_type		m_keys_ostream;
  }; // class - IOLock
} // namespace - General
