#ifndef GENERAL__EXEC
#define GENERAL__EXEC

#include <string>
#include <vector>

#include "general/Fork.hh"

namespace General
{
  //---------------------------------------------------------------------
  //---------------------------------------------------------------------
  class Exec
    : public Fork
  {
  public:
    typedef const char* arg_type;
    typedef double time_type;

    static arg_type COMMAND_END;

    Exec( arg_type Command, ... );

    arg_type Command( ) const;

    bool IfExited( ) const;

    bool CoreDump( );

    int ExitCode( );

    int Signal( );

    virtual void Spawn( );

    const std::string& Stdout( ) const;

    const std::string& Stderr( ) const;

    time_type TimeCPU( ) const;

  protected:
    virtual void evalChild( );
    virtual void evalParent( );

  private:
    static const int E_STDOUT = 0;
    static const int E_STDERR = 1;

    typedef std::vector< arg_type > options_type;

    struct exit_type
    {
      int	s_exit_code;
      int	s_signal;
      bool	s_core_dump;
      bool	s_exited;
      time_type	s_time_user;
      time_type	s_time_system;

      std::string	s_output[ 2 ];
    };

    options_type	m_options;
    exit_type		m_child_exit;

    time_type	m_start_time_user;
    time_type	m_start_time_system;
  };

  inline Exec::arg_type Exec::
  Command( ) const
  {
    return m_options[ 0 ];
  }

  inline bool Exec::
  CoreDump( )
  {
    return m_child_exit.s_core_dump;
  }

  inline int Exec::
  ExitCode( )
  {
    return m_child_exit.s_exit_code;
  }

  inline bool Exec::
  IfExited( ) const
  {
    return m_child_exit.s_exited;
  }

  inline int Exec::
  Signal( )
  {
    return m_child_exit.s_signal;
  }

  inline const std::string& Exec::
  Stderr( ) const
  {
    return m_child_exit.s_output[ E_STDERR ];
  }

  inline const std::string& Exec::
  Stdout( ) const
  {
    return m_child_exit.s_output[ E_STDOUT ];
  }

  inline Exec::time_type Exec::
  TimeCPU( ) const
  {
    return ( m_child_exit.s_time_user
	     + m_child_exit.s_time_system );
  }
}
#endif /* GENERAL__EXEC */
