#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/FrTOCSerData.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/FrTOC.hh"

#include "framecpp/Version8/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    //===================================================================
    void FrTOCSerData::
    QuerySer( const Common::TOCInfo& Info,
	       INT_4U FrameOffset,
	       INT_8U Position )
    {
      STRING	name;

      Info.TOCQuery( TOCInfo::IC_NAME, TOCInfo::DT_STRING_2, &name,
		     TOCInfo::IC_EOQ );

      ser_info_type& i( m_info[ name ] );
      i.resize( FrameOffset + 1 );
      i[ FrameOffset ] = Position;
    }

    const FrTOCSerData& FrTOCSerData::
    operator=( const Previous::FrTOCSerData& Source )
    {
      m_info = Source.GetSer( );
      m_keys = Source.GetPositionKeys( );

      return *this;
    }
    
  } // namespace - Version_8
} // namespace - FrameCPP
