#ifndef FrameCPP_VERSION_8_FrEvent_HH
#define FrameCPP_VERSION_8_FrEvent_HH

#if defined(__cplusplus)
#if ! defined(SWIG)
#include <string>
#include <vector>

#include "framecpp/FrameCPP.hh"

#include "framecpp/Common/SearchContainer.hh"
#include "framecpp/Common/TOCInfo.hh"
#endif /* ! defined(SWIG) */
#endif /* defined(__cplusplus) */

#include "framecpp/Version7/FrEvent.hh"

#if defined(__cplusplus)
#if ! defined(SWIG)
#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/GPSTime.hh"
#include "framecpp/Version8/FrVect.hh"
#include "framecpp/Version8/FrTable.hh"
#include "framecpp/Version8/STRING.hh"
#endif /* ! defined(SWIG) */
#endif /* defined(__cplusplus) */

#if defined(__cplusplus)
namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    // FrEventStorage
    //===================================================================

#if ! defined(SWIG)
    typedef Previous::FrEvent::FrEventStorage FrEventStorage;
#endif /* ! defined(SWIG) */

    //===================================================================
    // FrEventRefs
    //===================================================================

#if ! defined(SWIG)
    using Previous::FrEventRefsT;
#endif /* ! defined(SWIG) */

    typedef FrEventRefsT< FrVect, FrTable> FrEventRefs;

    //===================================================================
    // FrEvent
    //===================================================================
    //-------------------------------------------------------------------
    /// \brief Event data structure definition
    //-------------------------------------------------------------------
    class FrEvent
#if ! defined(SWIG)
      : public ObjectWithChecksum< Common::FrameSpec::Object >,
	public FrEventStorage,
	public FrEventRefs,
	public Common::TOCInfo
#endif /* ! defined(SWIG) */
    {
    public:

      typedef FR_EVENT_TIME_BEFORE_TYPE		timeBefore_type;
      typedef FR_EVENT_TIME_AFTER_TYPE		timeAfter_type;
      typedef FR_EVENT_EVENT_STATUS_TYPE	eventStatus_type;
      typedef FR_EVENT_AMPLITUDE_TYPE		amplitude_type;
      typedef FR_EVENT_PROBABILITY_TYPE		probability_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      FrEvent( );
      //-----------------------------------------------------------------
      /// \brief Copy constructor
      ///
      /// \param[in] eventData
      ///      Source of the event data.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrEvent( const FrEvent& eventData );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] name
      ///     Name of event.
      /// \param[in] comment
      ///     Descriptor of event.
      /// \param[in] inputs
      ///     Input channels and filter parameters to event process.
      /// \param[in] time
      ///     GPS time corresponding to reference value of event.
      /// \param[in] timeBefore
      ///     Signal duration before time.
      /// \param[in] timeAfter
      ///     Signal duration after time.
      /// \param[in] eventStatus
      ///     Defined by event search algorithm.
      /// \param[in] amplitude
      ///     Continuous output amplitude returned by event.
      /// \param[in] prob
      ///     Likelihood estimate of event.
      /// \param[in] statistics
      ///     Statistical description of event.
      /// \param[in] parameters
      ///     Array of additional event parameters.
      ///
      /// \return 
     ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrEvent( const name_type& name,
	       const comment_type& comment,
	       const inputs_type& inputs,
	       const time_type& time,
	       const timeBefore_type timeBefore,
	       const timeAfter_type timeAfter,
	       const eventStatus_type eventStatus,
	       const amplitude_type amplitude,
	       const probability_type prob,
	       const statistics_type& statistics,
	       const ParamList_type& parameters );

      //-----------------------------------------------------------------
      /// \brief Upconvert constructor
      ///
      /// \param[in] Source
      ///     An instance of a similiar object from a previous version
      ///     of the frame specification.
      /// \param[in] Stream
      ///     The stream from which the origional object was read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrEvent( const Previous::FrEvent& Source,
	       istream_type* Stream );

      //-----------------------------------------------------------------
      /// \brief Retrieve the name of the event
      ///
      /// \return
      ///     A name of the event via non-inlined function
      //-----------------------------------------------------------------
      const std::string& GetNameSlow( ) const;

      //-----------------------------------------------------------------
      /// \brief Promote previous version of object to this version
      ///
      /// \param[in] Source
      ///     The frame specification version of the object.
      /// \param[in] Obj
      ///     The previous version of the object.
      /// \param[in] Stream
      ///     Stream from which the origional object was created.
      ///
      /// \return
      ///     A new instance of FrEvent based on Obj
      //-----------------------------------------------------------------
      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       istream_type* Stream );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Merge with another FrEvent
      ///
      /// \param[in] RHS
      ///     FrEvent information to incorperate into this object.
      //-----------------------------------------------------------------
      FrEvent& Merge( const FrEvent& RHS );

#if WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Retrieve table of contents information.
      ///
      /// \param[in] InfoClass
      ///     Type of information to retrieve.
      //-----------------------------------------------------------------
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrEndOfFrame object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrEvent& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] Obj
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Down grade an object
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Upgrade an object
      ///
      /// \param[in] Target
      ///     The version of the frame specification to promote too.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of this class.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      cmn_streamsize_type pBytes( const Common::StreamBase& Stream) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor.
      ///
      /// \param[in] Stream
      ///     The input stream from which to read the object.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrEvent* pCreate( istream_type& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( ostream_type& Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      /// \param[in] vl
      ///     Variable argument list of requested data.
      //-----------------------------------------------------------------
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

    private:
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Constructor via stream
      ///
      /// \param[in] Stream
      ///     The input stream from which the object is being read.
      //-----------------------------------------------------------------
      FrEvent( istream_type& Stream );
    };

    inline FrEvent::promote_ret_type FrEvent::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     istream_type* Stream )
    {
      return Object::PromoteObject< Previous::FrEvent, FrEvent >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    inline const char* FrEvent::
    StructName( )
    {
      static const char* name = "FrEvent";
      return name;
    }

    inline bool FrEvent::
    operator==( const FrEvent& RHS ) const
    {
      return ( ( this == &RHS )
	       || ( ( m_data == RHS.m_data )
		    && (m_refs == RHS.m_refs )
		    ) );
    }
  } // namespace - Version_8
} // namespace FrameCPP

#endif /* defined(__cplusplus) */

#endif /* FrameCPP_VERSION_8_FrEvent_HH */
