#ifndef FrameCPP_VERSION_8_FrEndOfFrame_HH
#define FrameCPP_VERSION_8_FrEndOfFrame_HH

#include "general/types.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/GPSTime.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //-------------------------------------------------------------------
    /// \brief End of Frame data structure
    //-------------------------------------------------------------------
    class FrEndOfFrame
      : public ObjectWithChecksum< Common::FrameSpec::Object >
    {
    public:
      using ObjectWithChecksum< Common::FrameSpec::Object >::Bytes;

      typedef INT_4S run_type;
      typedef INT_4U frame_type;
      typedef INT_4U GTimeS_type;
      typedef INT_4U GTimeN_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      FrEndOfFrame( );

      //-----------------------------------------------------------------
      /// \brief Constructor
      //-----------------------------------------------------------------
      FrEndOfFrame( INT_4S Run, INT_4U Frame );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief Desctructor
      //-----------------------------------------------------------------
      virtual ~FrEndOfFrame( );

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      INT_8U Bytes( ) const;

      //-----------------------------------------------------------------
      /// \brief Run number of the frame
      /// \return
      ///     The run number of frame.
      ///     It is the same as the value in the FrameH run datum.
      //-----------------------------------------------------------------
      INT_4S	GetRun( ) const;

      //-----------------------------------------------------------------
      /// \brief frame number
      ///
      /// \return
      ///     The frame number.
      ///     It is the same as the value in the FrameH frame datum.
      //-----------------------------------------------------------------
      INT_4U	GetFrame( ) const;

      //-----------------------------------------------------------------
      /// \brief Get the GPS start time of this frame
      ///
      /// \return
      ///     The start time of the frame.
      //-----------------------------------------------------------------
      const GPSTime& GetGTime( ) const;

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrEndOfFrame object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrEndOfFrame& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] RHS
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& RHS ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Demotes object to previous version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Promotes object to another version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the promoted frame specification.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object promoted to the next generation.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      virtual cmn_streamsize_type
      pBytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor.
      ///
      /// \param[in] Stream
      ///     The input stream from which to read the object.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      virtual FrEndOfFrame* pCreate( istream_type& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( ostream_type& Stream ) const;

    private:
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      struct data_type
      {
	//---------------------------------------------------------------
	/// Run number.
	/// This is the same as the FrameH::rum member
        //---------------------------------------------------------------
	INT_4S	run;
        //---------------------------------------------------------------
	/// Frame number, monotonically increasing until end of run;
	/// This is the same as the FrameH::frame number datum.
        //---------------------------------------------------------------
	INT_4U	frame;
        //---------------------------------------------------------------
	/// Frame start time in GPS seconds.
        //---------------------------------------------------------------
	GPSTime	GTime;
      };

      struct data_type m_data;

      //-----------------------------------------------------------------
      /// \brief Constructor via stream
      ///
      /// \param[in] Stream
      ///     The input stream from which the object is being read.
      //-----------------------------------------------------------------
      FrEndOfFrame( istream_type& Stream );
    };

    inline const char* FrEndOfFrame::
    StructName( )
    {
      static const CHAR* class_name( "FrEndOfFrame" );
      return class_name;
    }

    //: Return run number of frame
    inline INT_4S FrEndOfFrame::
    GetRun( ) const
    {
      return m_data.run;
    }

    //: Return frame number
    inline INT_4U FrEndOfFrame::
    GetFrame( ) const
    {
      return m_data.frame;
    }
    
    inline const GPSTime& FrEndOfFrame::
    GetGTime( ) const
    {
      return m_data.GTime;
    }

  } // namespace - Version_8
} // namespce - FrameCPP

#endif /* FrameCPP_VERSION_8_FrEndOfFrame_HH */
