#ifndef FrameCPP__VERSION_6__Specs_HH
#define FrameCPP__VERSION_6__Specs_HH

#include "general/types.hh"

#include "framecpp/Common/FrameSpec.hh"

#if defined(__cplusplus) && !defined(SWIG)
namespace FrameCPP
{
  namespace Common
  {
    class IStream;
    class OStream;
  }

  namespace Version_4 {}

  //---------------------------------------------------------------------
  /// \brief Implementation of the version 6 specification
  ///
  /// This namespace includes classes and functions needed to implement
  /// the version 6 frame specification as described by LIGO-T970130-F-E
  /// dated August 14, 2002.
  //---------------------------------------------------------------------
  namespace Version_6
  {
    using Common::IStream;
    using Common::OStream;

    //-------------------------------------------------------------------
    /// The namespace Previous is to the version 4 frame specification
    /// since the version 5 frame specification was never fully
    /// implemented.
    //-------------------------------------------------------------------
    namespace Previous = Version_4;

    typedef REAL_4 dt_type;
    typedef INT_8U position_type;

    const CHAR_U DATA_FORMAT_VERSION = 6;
    const CHAR_U LIBRARY_MINOR_VERSION = 3;

    bool init_frame_spec( );
  } // namespace - Version_6
} // namespace - FrameCPP
#endif /* defined(__cplusplus) && !defined(SWIG) */
#endif /* FrameCPP__VERSION_6__Specs_HH */
