#include "framecpp/config.h"

#include "framecpp/Version3/Dimension.hh"

namespace FrameCPP
{
  namespace Version_3
  {
    //------------------------------------------------------------------
    // Constructors
    //------------------------------------------------------------------


    //------------------------------------------------------------------
    //
    //: Default Constructor.
    //
    // This creates a dimension object with the following values:
    //
    //   Dimension Length (Nx) - 1
    //   Scale Factor (Dx) - 1.0
    //   Units (UnitX) - ""
    //
    //!exc: None.   
    //   
    Dimension::Dimension()
      : mNx( 1 ),
	mDx( 1.0 ),
	mUnitX( "" )
    {
    }


    //------------------------------------------------------------------
    //
    //: Copy constructor.
    //
    //!param: const Dimension& dim - The Dimension to copy from.
    //
    //!exc: std::bad_alloc - Memory allocation failed.
    //
    Dimension::
    Dimension( const Dimension& dim )
      : mNx( dim.mNx ),
	mDx( dim.mDx ),
	mUnitX( dim.mUnitX )
    {
    }
    

    //------------------------------------------------------------------
    //: Constructor.
    //
    // This creates a Dimension object with the specified attributes.
    //
    //!param: INT_8U nx - The dimension length.
    //!param: REAL_8 dx - The Scale Factor. Default: 1.0
    //!param: const std::string& unitX - The units (unit per step size). Default: ""
    //
    //!exc: std::bad_alloc - Memory allocation failed.
    //   
    Dimension::
    Dimension( nx_type nx,
	       dx_type dx,
	       const std::string& unitX )
      : mNx( nx ),
	mDx( dx ),
	mUnitX( unitX )
    {
    }
  } // namespace - Version_3
} // namespace - FrameCPP
