#ifndef FRAMECPP__COMMON__MD5SUM_HH
#define FRAMECPP__COMMON__MD5SUM_HH

#include "framecpp/config.h"

#if ! defined(SWIGIMPORTED)
#include <iostream>
#include <stdexcept>
#endif /* ! defined(SWIGIMPORTED) */

#include "general/types.hh"

#if HAVE_MD5_H && HAVE_LIBMD5
extern "C" {
#define PROTOTYPES 1
#if HAVE_MD5GLOBAL_H
#if ! defined(SWIGIMPORTED)
#include <md5global.h>
#endif /* ! defined(SWIGIMPORTED) */
#endif /* HAVE_MD5GLOBAL_H */
#include <md5.h>
} /* extern "C" */

#define MD5_Final MD5Final
#define MD5_Init MD5Init
#define MD5_Update MD5Update

typedef unsigned char* md5_data_type;

#elif HAVE_COMMONCRYPTO_COMMONDIGEST_H
#if ! defined(SWIGIMPORTED)
#include <CommonCrypto/CommonDigest.h>

#define MD5_CTX CC_MD5_CTX
#define MD5_Init CC_MD5_Init
#define MD5_Final CC_MD5_Final
#define MD5_Update CC_MD5_Update
#define MD5_LBLOCK CC_MD5_BLOCK_LONG

typedef void* md5_data_type;
#endif /* ! defined(SWIGIMPORTED) */

#elif HAVE_OPENSSL_MD5_H && HAVE_MD5_IN_CRYPTO
extern "C" {
#if ! defined(SWIGIMPORTED)
#include <openssl/md5.h>
#endif /* ! defined(SWIGIMPORTED) */
} /* extern "C" */
typedef void* md5_data_type;

#endif /* OPENSSL_MD5_H */

#ifndef MD5_DIGEST_LENGTH
#define MD5_DIGEST_LENGTH 16
#endif /* MD5_DIGEST_LENGTH */

namespace FrameCPP
{
  namespace Common
  {
    class MD5Sum;
  }
}

namespace std
{
  std::ostream& operator<<( std::ostream& Stream,
			    const FrameCPP::Common::MD5Sum& Data );
}

namespace FrameCPP
{
  namespace Common
  {
    class MD5Sum
    {
    public:
      typedef md5_data_type 	data_type;
      typedef INT_4U		size_type;
      typedef CHAR_U*		md_type;

      MD5Sum( );

      MD5Sum( const MD5Sum& Source );

      std::ostream& DumpIntermediate( std::ostream& Stream ) const;

      void Finalize( ) const;

      bool Finalized( ) const;

      void Reset( );

      void Update( const data_type Data, size_type Length );

      md_type Value( ) const;

      std::ostream& operator<<( std::ostream& Stream );

      MD5Sum& operator=( const MD5Sum& MD5 );

      bool operator==( const MD5Sum& RHS ) const;

      bool operator!=( const MD5Sum& RHS ) const;
    private:
      friend std::ostream& std::operator<<( std::ostream& stream,
					    const MD5Sum& Data );
      mutable bool	m_final;
      mutable MD5_CTX	m_context;
      mutable CHAR_U	m_message_digest[ MD5_DIGEST_LENGTH ];
    };

    inline MD5Sum::
    MD5Sum( )
      : m_final( false )
    {
      // Initialize the context to be used
      MD5_Init( &m_context );
    }

    inline void MD5Sum::
    Finalize( ) const
    {
      if ( m_final == false )
      {
	MD5_Final( m_message_digest, &m_context );
	m_final = true;
      }
    }

    inline bool MD5Sum::
    Finalized( ) const
    {
      return m_final;
    }

    inline void MD5Sum::
    Reset( )
    {
      m_final = false;
      MD5_Init( &m_context );
    }

    inline void MD5Sum::
    Update( const data_type Data, size_type Length )
    {
      if ( m_final )
      {
	throw std::runtime_error( "MD5 error: Update called after value had been  finalized" );
      }
      MD5_Update( &m_context, Data, Length );
	
    }

    inline MD5Sum::md_type MD5Sum::
    Value( ) const
    {
      Finalize( );
      return static_cast<const md_type>( m_message_digest );
    }

    inline bool MD5Sum::
    operator!=( const MD5Sum& RHS ) const
    {
      return ! operator==( RHS );
    }
  } // namespace - Common
} // namespace - FrameCPP

#ifdef MD5_Final
#undef MD5_Final
#undef  MD5_Init
#define MD5_Init MD5Init
#undef  MD5_Update
#define MD5_Update MD5Update
#endif /* MD5_Final */

#endif /* FRAMECPP__COMMON__MD5SUM_HH */
