#include "framecpp/config.h"

#include <cstring>

#include <iomanip>
#include <iostream>

#include "framecpp/Common/MD5Sum.hh"

using std::memcpy;

namespace
{
#ifdef MD5_LBLOCK
  bool
  operator==( const MD5_CTX& LHS,
	      const MD5_CTX& RHS )
  {
#define MD5_CTX_CMP( a ) ( LHS.a == RHS.a )

    bool retval = ( MD5_CTX_CMP( A )
		    && MD5_CTX_CMP( B )
		    && MD5_CTX_CMP( C )
		    && MD5_CTX_CMP( D )
		    && MD5_CTX_CMP( Nl )
		    && MD5_CTX_CMP( Nh )
		    && std::equal( LHS.data,
				   LHS.data + MD5_LBLOCK,
				   RHS.data )
		    && MD5_CTX_CMP( num )
		    );
#undef MD5_CTX_CMP
    return retval;
  }
#else /* MD5_LBLOCK */
  bool
  operator==( const MD5_CTX& LHS,
	      const MD5_CTX& RHS )
  {
    bool retval =
      std::equal( LHS.state,
		  LHS.state + ( sizeof( LHS.state ) / sizeof( *LHS.state ) ),
		  RHS.state )
      && std::equal( LHS.count,
		     LHS.count
		     + ( sizeof( LHS.count ) / sizeof( *LHS.count ) ),
		     RHS.state )
      && std::equal( LHS.buf_un.buf8,
		     LHS.buf_un.buf8 + ( sizeof( LHS.buf_un.buf8 )
					 / sizeof( *LHS.buf_un.buf8 ) ),
		     RHS.buf_un.buf8 )
      ;
    return retval;
  }
#endif /* MD5_LBLOCK */
}

FrameCPP::Common::MD5Sum::
MD5Sum( const MD5Sum& Source )
  : m_final( Source.m_final )
{
  memcpy( &m_context, &Source.m_context, sizeof( m_context ) );
  memcpy( m_message_digest, Source.m_message_digest, sizeof( m_message_digest ) );
}


std::ostream& FrameCPP::Common::MD5Sum::
DumpIntermediate( std::ostream& Stream ) const
{
  //---------------------------------------------------------------------
  // Preserve stream formatting rules
  //---------------------------------------------------------------------

  std::ios_base::fmtflags	sflags( Stream.flags( ) );
  Stream.setf( std::ios_base::hex, std::ios_base::basefield );
  Stream.unsetf( std::ios_base::uppercase );

  std::streamsize swidth( Stream.width( 8 ) );
  int sfill( Stream.fill( '0' ) );

  //---------------------------------------------------------------------
  // Output our data
  //---------------------------------------------------------------------

#if 0
  Stream << "MD5Sum: A: " << m_context.A
	 << " B: " << m_context.B
	 << " C: " << m_context.C
	 << " D: " << m_context.D
	 << " Nl: " << m_context.Nl
	 << " Nh: " << m_context.Nh
	 << " num: " << m_context.num
    ;
#endif /* 0 */

  //---------------------------------------------------------------------
  // Restore the formatting rules
  //---------------------------------------------------------------------

  Stream.width( swidth );
  Stream.fill( sfill );
  Stream.flags( sflags );

  return Stream;
}

FrameCPP::Common::MD5Sum& FrameCPP::Common::MD5Sum::
operator=( const MD5Sum& Source )
{
  m_final = Source.m_final;
  memcpy( &m_context, &Source.m_context, sizeof( m_context ) );
  memcpy( m_message_digest, Source.m_message_digest, sizeof( m_message_digest ) );
  return *this;
}

bool FrameCPP::Common::MD5Sum::
operator==( const MD5Sum& RHS ) const
{
      bool retval = false;
      if ( &RHS == this )
      {
	retval = true;
      }
      else
      {
	if ( Finalized( ) == RHS.Finalized( ) )
	{
	  if ( Finalized( ) )
	  {
	    retval = std::equal( m_message_digest,
				 m_message_digest + MD5_DIGEST_LENGTH,
				 RHS.m_message_digest );
	  }
	  else
	  {
	    retval = ( m_context == RHS.m_context );
	  }
	}
      }
      return retval;
}

std::ostream& std::
operator<<( std::ostream& Stream, const FrameCPP::Common::MD5Sum& Data )
{
  Data.Finalize( );	// Do any finization
  //---------------------------------------------------------------------
  // Preserve stream formatting rules
  //---------------------------------------------------------------------

  std::ios_base::fmtflags	sflags( Stream.flags( ) );
  Stream.setf( std::ios_base::hex, std::ios_base::basefield );
  Stream.unsetf( std::ios_base::uppercase );

  std::streamsize swidth( Stream.width( 2 ) );
  int sfill( Stream.fill( '0' ) );

  //---------------------------------------------------------------------
  // Output our data
  //---------------------------------------------------------------------

  for ( INT_2U i = 0; i < sizeof( Data.m_message_digest ); ++i )
  {
    Stream << std::hex << std::setw(2) << std::setfill('0') << (int)Data.m_message_digest[ i ];
  }

  //---------------------------------------------------------------------
  // Restore the formatting rules
  //---------------------------------------------------------------------

  Stream.width( swidth );
  Stream.fill( sfill );
  Stream.flags( sflags );

  return Stream;
}
