/* -*- mode: C++; c-basic-offset: 2; -*- */

#ifndef FrameCPP__COMMON__FrameStructCheckSum_HH
#define FrameCPP__COMMON__FrameStructCheckSum_HH

#include "general/types.hh"

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/IOStream.hh"

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    /// \brief Per frame structure checksum
    ///
    /// This class is intended to provide methods to support the
    /// per frame structure checksum data which as added with
    /// version 8 of the frame specification.
    /// 
    /// \tparam CT
    ///     The actual type used for the checksum field.
    //-------------------------------------------------------------------
    template< class CT >
    class FrameStructCheckSum
    {
    public:
      typedef CT chkSum_type;

      FrameStructCheckSum( );

      FrameStructCheckSum( IStream& Stream );

      virtual FrameSpec::size_type Bytes( const StreamBase& Stream ) const;

   private:
      chkSum_type	m_chkSum;
    };
  }
}

#include "framecpp/Common/FrameStructCheckSum.tcc"

#endif /* FrameCPP__COMMON__FrameStructCheckSum_HH */
