#include "framecpp/config.h"

#include "framecpp/FrameCPP.hh"
#include "framecpp/Common/FrVect.hh"

namespace FrameCPP
{
  namespace Common
  {
    void FrVect::
    compressToBuffer( const Compression::compress_type_mapping&
		      CompressionMapping,
		      const Compression::compress_type_reverse_mapping&
		      CompressionReverseMapping,
		      const Compression::data_type_mapping&
		      DataTypeMapping,
		      const INT_4U DataType,
		      const INT_8U NData,
		      const CHAR_U* Source,
		      const INT_8U SourceNBytes,
		      const INT_4U SourceCompressionMode,
		      General::AutoArray< CHAR_U >& Dest,
		      INT_8U& DestNBytes,
		      INT_4U& DestCompressionMode,
		      const INT_4U Level ) const
    {
      General::AutoArray< CHAR_U > expanded_buffer;

      const INT_8U	nData( NData );
      INT_8U		nBytes( SourceNBytes );

#if WORKING
      //---------------------------------------------------------------------
      // Ensure the buffer is fully expanded
      /// \todo need to ensure that this is working for both endiannesses.
      //---------------------------------------------------------------------
      if ( ( SourceCompressionMode & 0xFF ) != Compression::MODE_RAW )
      {
	expandToBuffer( CompressionMapping,
			DataTypeMapping,
			DataType,
			NData,
			Source,
			SourceNBytes,
			SourceCompressionMode,
			expanded_buffer,
			nBytes );
      }
#endif /* WORKING */

      //-----------------------------------------------------------------
      // Now compress the data
      //-----------------------------------------------------------------

      INT_4U	compress = ( DestCompressionMode & 0xFF );
      CHAR_U*	data_out( (CHAR_U*)NULL );
      INT_8U	data_out_len( 0 );

      FrameCPP::Compression::
	Compress( compress,
		  Level,
		  CompressionMapping,
		  CompressionReverseMapping,
		  DataType,
		  DataTypeMapping,
		  ( expanded_buffer.get( ) )	// Have uncompressed buffer?
		  ? expanded_buffer.get( )	// Yes; use it
		  : Source,			// No; use data buffer
		  nData,
		  nBytes,
		  data_out,
		  data_out_len );
      //-----------------------------------------------------------------
      // Final validation before returning to the caller
      //-----------------------------------------------------------------
      Dest.reset( data_out );
      DestNBytes = data_out_len;
      
      if ( data_out_len == 0 )
      {
	Dest.reset( (CHAR_U*)NULL );
      }
      else
      {
	DestCompressionMode = compress;
      }
    } // method - FrVect::compressToBuffer

    void FrVect::
    compressToBuffer( const Compression::compress_type_mapping&
		      CompressionMapping,
		      const Compression::compress_type_reverse_mapping&
		      CompressionReverseMapping,
		      const Compression::data_type_mapping&
		      DataTypeMapping,
		      const INT_4U DataType,
		      const INT_8U NData,
		      const CHAR_U* Source,
		      const INT_8U SourceNBytes,
		      const INT_4U SourceCompressionMode,
		      General::SharedArray< CHAR_U >& Dest,
		      INT_8U& DestNBytes,
		      INT_4U& DestCompressionMode,
		      const INT_4U Level ) const
    {
      General::SharedArray< CHAR_U > expanded_buffer;

      const INT_8U	nData( NData );
      INT_8U		nBytes( SourceNBytes );

#if WORKING
      //---------------------------------------------------------------------
      // Ensure the buffer is fully expanded
      /// \todo need to ensure that this is working for both endiannesses.
      //---------------------------------------------------------------------
      if ( ( SourceCompressionMode & 0xFF ) != Compression::MODE_RAW )
      {
	expandToBuffer( CompressionMapping,
			DataTypeMapping,
			DataType,
			NData,
			Source,
			SourceNBytes,
			SourceCompressionMode,
			expanded_buffer,
			nBytes );
      }
#endif /* WORKING */

      //-----------------------------------------------------------------
      // Now compress the data
      //-----------------------------------------------------------------

      INT_4U	compress = ( DestCompressionMode & 0xFF );
      CHAR_U*	data_out( (CHAR_U*)NULL );
      INT_8U	data_out_len( 0 );

      FrameCPP::Compression::
	Compress( compress,
		  Level,
		  CompressionMapping,
		  CompressionReverseMapping,
		  DataType,
		  DataTypeMapping,
		  ( expanded_buffer.get( ) )	// Have uncompressed buffer?
		  ? expanded_buffer.get( )	// Yes; use it
		  : Source,			// No; use data buffer
		  nData,
		  nBytes,
		  data_out,
		  data_out_len );
      //-----------------------------------------------------------------
      // Final validation before returning to the caller
      //-----------------------------------------------------------------
      Dest.reset( data_out );
      DestNBytes = data_out_len;
      
      if ( data_out_len == 0 )
      {
	Dest.reset( (CHAR_U*)NULL );
      }
      else
      {
	DestCompressionMode = compress;
      }
    } // method - FrVect::compressToBuffer

    void FrVect::
    expandToBuffer( const Compression::compress_type_mapping&
		    CompressionMapping,
		    const Compression::data_type_mapping&
		    DataTypeMapping,
		    const INT_4U DataType,
		    const INT_8U NData,
		    const CHAR_U* Source,
		    const INT_8U SourceNBytes,
		    const INT_4U SourceCompressionMode,
		    const INT_4U SourceByteOrder,
		    General::SharedArray< CHAR_U >& Dest,
		    INT_8U& DestNBytes ) const
    {
      //---------------------------------------------------------------------
      // Uncompress to local buffers, then use those buffers as
      //       input to the compression routines
      //---------------------------------------------------------------------
      CHAR_U*	data_out( (CHAR_U*)NULL );
      INT_8U	data_out_len( 0 );

      FrameCPP::Compression::
	Expand( ( BYTE_ORDER_HOST == SourceByteOrder ),
		( SourceCompressionMode & 0xFF ),
		CompressionMapping,
		DataType,
		DataTypeMapping,
		Source,
		NData,
		SourceNBytes,
		data_out,
		data_out_len );
      DestNBytes = data_out_len;
      if ( data_out )
      {
	Dest.reset( data_out );
	if ( DestNBytes == 0 )
	{
	  //-----------------------------------------------------------------
	  // Deallocate the buffer since data_out_length shows a buffer
	  // of size zero
	  //-----------------------------------------------------------------
	  Dest.reset( (CHAR_U*)NULL );
	}
      }
      else
      {
	Dest.reset( (CHAR_U*)NULL );
	DestNBytes = 0;
      }
    } // method - FrVect::expandToBuffer

    void FrVect::
    expandToBuffer( const Compression::compress_type_mapping&
		    CompressionMapping,
		    const Compression::data_type_mapping&
		    DataTypeMapping,
		    const INT_4U DataType,
		    const INT_8U NData,
		    const CHAR_U* Source,
		    const INT_8U SourceNBytes,
		    const INT_4U SourceCompressionMode,
		    const INT_4U SourceByteOrder,
		    General::AutoArray< CHAR_U >& Dest,
		    INT_8U& DestNBytes ) const
    {
      //---------------------------------------------------------------------
      // Uncompress to local buffers, then use those buffers as
      //       input to the compression routines
      //---------------------------------------------------------------------
      CHAR_U*	data_out( (CHAR_U*)NULL );
      INT_8U	data_out_len( 0 );

      FrameCPP::Compression::
	Expand( ( BYTE_ORDER_HOST == SourceByteOrder ),
		( SourceCompressionMode & 0xFF ),
		CompressionMapping,
		DataType,
		DataTypeMapping,
		Source,
		NData,
		SourceNBytes,
		data_out,
		data_out_len );
      DestNBytes = data_out_len;
      if ( data_out )
      {
	Dest.reset( data_out );
	if ( DestNBytes == 0 )
	{
	  //-----------------------------------------------------------------
	  // Deallocate the buffer since data_out_length shows a buffer
	  // of size zero
	  //-----------------------------------------------------------------
	  Dest.reset( (CHAR_U*)NULL );
	}
      }
      else
      {
	Dest.reset( (CHAR_U*)NULL );
	DestNBytes = 0;
      }
    } // method - FrVect::expandToBuffer
  } // namespace - Common
} // namespace - FrameCPP
