#ifndef FrameCPP__COMMON__FR_END_OF_FILE_HH
#define FrameCPP__COMMON__FR_END_OF_FILE_HH

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/StringStream.hh"

namespace FrameCPP
{
  namespace Common
  {
    class Description;
    class CheckSum;
    class IFrameStream;
    class IStringStream;

    class FrEndOfFile
      : public FrameSpec::Object
    {
    public:
      typedef INT_8U nBytes_cmn_type;
      typedef INT_8U seekTOC_cmn_type;
      typedef INT_4U chkType_cmn_type;
      typedef INT_4U chkSum_cmn_type;
      typedef IStringStream assign_stream_type;

      static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FR_END_OF_FILE;

      FrEndOfFile( const Description* Desc );

      virtual ~FrEndOfFile( );

      virtual nBytes_cmn_type NBytes( ) const = 0;

      virtual seekTOC_cmn_type SeekTOC( ) const;

      //-----------------------------------------------------------------
      /// \brief Run filters over the given bytes.
      ///
      /// \param Stream[in,out]
      ///     The source of the bytes to read.
      /// \param Check[in,out]
      ///     The running checksum calculation
      /// \param[in] Buffer
      ///     The bytes to be filtered
      /// \param[in] Size
      ///     The number of bytes in Buffer to be checked.
      ///
      /// \return
      ///     The checksum value recorded within the
      ///     FrEndOfFile structure.
      //-----------------------------------------------------------------
      virtual  chkSum_cmn_type Filter( const Common::IStream& Stream,
				       CheckSum& Check,
				       chkType_cmn_type& Type,
				       void* Buffer, INT_8U Size ) const = 0;

      //-----------------------------------------------------------------
      /// \brief Assign the contents of the instance
      ///
      /// \param[in] Source
      ///     An input stream from which to read information for
      ///     the instance.
      //-----------------------------------------------------------------
      virtual void assign( assign_stream_type& Stream ) = 0;
    };
  } // namespace - Common
} // namespace - FrameCPP


#endif /* FrameCPP__COMMON__FR_END_OF_FILE_HH */
