#ifndef FRAMECPP__COMMON__Description_HH
#define FRAMECPP__COMMON__Description_HH

#if ! defined(SWIGIMPORTED)
#include <list>
#endif /* ! defined(SWIGIMPORTED) */

#include "general/SharedPtr.hh"
#include "general/types.hh"

#include "framecpp/Common/FrameSpec.hh"

namespace FrameCPP
{
  namespace Common
  {
    class OFrameStream;

    class Description
    {
    public:
      typedef General::SharedPtr< FrameSpec::Object > object_type;

      virtual ~Description( );

      const std::string& GetName( ) const;

      void Write( OFrameStream& Stream ) const;

      void operator( )( object_type Obj );

      void operator( )( const object_type::element_type& Obj );

      INT_4U size( ) const;

      template< typename T >
      static const char* Ascii( );
    private:
      typedef std::list< object_type > description_container;

      description_container	m_desc;
    };

    template< >
    inline const char* Common::Description::Ascii< INT_2S >( )
    {
      return( "INT_2S" );
    }

    template< >
    inline const char* Common::Description::Ascii< INT_2U >( )
    {
      return( "INT_2U" );
    }

    template< >
    inline const char* Common::Description::Ascii< INT_4S >( )
    {
      return( "INT_4S" );
    }

    template< >
    inline const char* Common::Description::Ascii< INT_4U >( )
    {
      return( "INT_4U" );
    }

    template< >
    inline const char* Common::Description::Ascii< INT_8S >( )
    {
      return( "INT_8S" );
    }

    template< >
    inline const char* Common::Description::Ascii< INT_8U >( )
    {
      return( "INT_8U" );
    }

    template< >
    inline const char* Common::Description::Ascii< REAL_4 >( )
    {
      return( "REAL_4" );
    }

    template< >
    inline const char* Common::Description::Ascii< REAL_8 >( )
    {
      return( "REAL_8" );
    }

    template< >
    inline const char* Common::Description::Ascii< const char* >( )
    {
      return( "STRING" );
    }

    template< >
    inline const char* Common::Description::Ascii< std::string >( )
    {
      return( "STRING" );
    }

    inline INT_4U Common::Description::
    size( ) const
    {
      return m_desc.size( );
    }

  } // namespace - Common
} // namespace - FrameCPP

#endif /* FRAMECPP__COMMON__Description_HH */

