#ifndef FRAME_CPP__Common__CompressionGZip_hh
#define	FRAME_CPP__Common__CompressionGZip_hh

#include "general/autoarray.hh"

namespace FrameCPP
{
  namespace Compression
  {
    //-------------------------------------------------------------------
    /// \brief Routines related to the gzip compression algorith
    //-------------------------------------------------------------------
    namespace GZip
    {
      //-----------------------------------------------------------------
      /// \brief Compress the data with GZip.
      ///
      /// \param[in] DataIn
      ///     Pointer to the data to be compressed
      /// \param[in] NBytesIn
      ///     The number of bytes to be compressed.
      ///     Upon return, the size of the compressed buffer is returned.
      /// \param[in] Level
      ///     Compression level.
      /// \param[out] DataOut
      ///     Pointer to the data to be compressed
      /// \param[out] NBytesOut
      ///     The number of bytes to be compressed.
      ///     Upon return, the size of the compressed buffer is returned.
      /// \todo Correct this documentation
      //-----------------------------------------------------------------
      void Compress( const CHAR_U* DataIn, INT_8U NBytesIn, size_t Level,
		     General::AutoArray< CHAR_U >& DataOut,
		     INT_8U& NBytesOut );

      //-----------------------------------------------------------------
      /// \brief Expand the data with GZip.
      ///
      /// \param[in] DataIn
      /// \param[in] NBytesIn
      /// \param[out] DataOut
      /// \param[in,out] NBytesOut
      ///     On input, this must be set to the expected number of bytes
      ///     for the expanded buffer.
      ///     On output, this will have the number of bytes in the
      ///     DataOut buffer.
      //-----------------------------------------------------------------
      void Expand( const CHAR_U* DataIn, INT_8U NBytesIn,
		   General::AutoArray< CHAR_U >& DataOut,
		   INT_8U& NBytesOut );

    } // namespace - GZip

  } // namespace -  Compression
  
} // namespace - FrameCPP


#endif /* FRAME_CPP__Common__CompressionGZip_hh */

