#ifndef FRAME_CPP_INTERFACE__FR_HISTORY_INTERNAL_HH
#define FRAME_CPP_INTERFACE__FR_HISTORY_INTERNAL_HH

#include "general/SharedPtr.hh"

namespace FrameC
{
  struct FrHistory
    : public Handle
  {
    typedef FrameCPP::FrHistory			data_core_t;
    typedef General::SharedPtr< data_core_t >	data_t;
    typedef data_core_t::time_type			time_t;

    data_t	m_data;

    FrHistory( );

    FrHistory( const char* Name,
	       time_t Time,
	       const char* Comment );
	       
  };

  template<>
  inline pointer_type
  PointerType( FrHistory* Value )
  {
    return POINTER_FR_HISTORY;
  }

}

#endif /* FRAME_CPP_INTERFACE__FR_HISTORY_INTERNAL_HH */
