#ifndef RECTANGULARWINDOW_HH
#define RECTANGULARWINDOW_HH

//!ppp: {eval `cat $ENV{SRCDIR}/cc_rules.pl`}

#include "Window.hh"

namespace Filters {

    //
    //: A class representing a rectangular window
    //
    class RectangularWindow : public Window {
	
    public:
	//
	//: Return window name
	//
	//!return: string - window name
	//
	virtual std::string name() const;

	//
	//: Return window parameter
	//
	//!return: double - window parameter
	//
	virtual double param() const;

	//
	//: Clone a window
	//
	//!return: RectangularWindow* - copy of current window
	//
	virtual RectangularWindow* Clone() const;
	
    private:
	//
	//: Get the ith element of the window
	//
	// A rectangular window is defined by 
	//
	//     w[i] = 1.0 
	//
	// for i = 0,1, ... n-1.
	//
	//!param: i - element at which the window is evaluated
	//
	//!return: double - the window element w[i]
	//
	virtual double element(const size_t i) const;

    };
    
} // namespace Filters

#endif // RECTANGULARWINDOW_HH
